/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ft.FundTransferBillCollection;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.ReturnBillCollection;
import com.kingdee.eas.fm.nt.ReturnBillFactory;
import com.kingdee.eas.fm.nt.ReturnBillInfo;
import com.kingdee.eas.fm.recon.SipgFmCashflow;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionEntryInfo;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingEntryInfo;
import com.kingdee.eas.fm.recon.app.ISipgFmReconStrategy;
import com.kingdee.eas.fm.recon.app.SipgFmReconStrategyBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SipgReceivableBillStrategy
extends SipgFmReconStrategyBase
implements ISipgFmReconStrategy {
    @Override
    public List _getReconResult(Context ctx, HashMap hmParams) {
        if (!this.initParams(hmParams)) {
            return null;
        }
        try {
            this.baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.baseCurrency.getId()));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < reconMapping.getEntrys().size(); ++i) {
            SipgFmReconMappingEntryInfo mappingEntry = reconMapping.getEntrys().get(i);
            String fmNumber = null;
            String fmName = null;
            String glNumber = null;
            String glName = null;
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("name");
                selector.add("number");
                NTTypeInfo nTTypeInfo = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK(mappingEntry.getBillType().getId()), selector);
                fmNumber = nTTypeInfo.getNumber();
                fmName = nTTypeInfo.getName();
                AccountViewInfo accountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(mappingEntry.getAccount().getId()), selector);
                glNumber = accountViewInfo.getNumber();
                glName = accountViewInfo.getName();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            HashMap currencyMap = this.getCurrencyFmEnd(ctx, mappingEntry);
            for (CurrencyInfo cur : currencyMap.keySet()) {
                HashMap fmIncDec = (HashMap)currencyMap.get(cur);
                HashMap<String, Object> hmResult = this.getReturnValue(ctx, fmNumber, fmName, glNumber, glName, fmIncDec, cur, mappingEntry);
                result.add(hmResult);
            }
        }
        return result;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection src = new SelectorItemCollection();
        src.add("id");
        src.add("number");
        src.add("billAmt");
        src.add("transferDate");
        src.add("draftNumber");
        src.add("billState");
        src.add("naturalAmt");
        src.add("issuesDate");
        src.add("takeDate");
        src.add("company");
        src.add("receivingBillId");
        src.add("isTrustee");
        src.add("trustDate");
        src.add("isPledge");
        src.add("wageId.id");
        src.add("wageId.issuedate");
        src.add("wageId.amountlocalcur");
        src.add("wageId.Amount");
        src.add("endorseBill.id");
        src.add("endorseBill.endorseDate");
        src.add("endorseBill.localAmount");
        src.add("endorseBill.endorseAmt");
        src.add("discountBill.id");
        src.add("discountBill.DiscountDate");
        src.add("discountBill.localAmount");
        src.add("discountBill.billAmount");
        src.add("discountBill.actRecvAmount");
        src.add("discountBill.actRecvLocAmount");
        src.add("split");
        return src;
    }

    private HashMap getCurrencyFmEnd(Context ctx, SipgFmReconMappingEntryInfo mappingEntry) {
        try {
            Date bizDateStart = reconPeriod.getBeginDate();
            Timestamp bizDateEnd = reconPeriod.getEndDate();
            Date date = new Date();
            EntityViewInfo evis = new EntityViewInfo();
            FilterInfo filters = new FilterInfo();
            evis.setFilter(filters);
            evis.setSelector(this.getSelectors());
            filters.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId(), CompareType.EQUALS));
            filters.getFilterItems().add(new FilterItemInfo("takeDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
            filters.getFilterItems().add(this.getMappingFilter(mappingEntry));
            ReceivableBillCollection rbCols = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(evis);
            HashMap hmTDB = new HashMap();
            for (int i = 0; i < rbCols.size(); ++i) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                ReceivableBillInfo receivableBillInfo = rbCols.get(i);
                HashMap hmcDec = this.getFmIncDec(ctx, mappingEntry, directionInfo, bizDateStart, bizDateEnd, receivableBillInfo);
                BigDecimal endInc = (BigDecimal)hmcDec.get("endIncrease");
                BigDecimal endDec = (BigDecimal)hmcDec.get("endDecrease");
                BigDecimal fmInc = (BigDecimal)hmcDec.get("fmIncrease");
                BigDecimal fmDec = (BigDecimal)hmcDec.get("fmDecrease");
                BigDecimal fmEnd = endInc.subtract(endDec);
                BigDecimal fmBegin = fmEnd.add(fmDec).subtract(fmInc);
                hmTDB_Detail.put("fmBegin", fmBegin);
                hmTDB_Detail.put("fmIncrease", fmInc);
                hmTDB_Detail.put("fmDecrease", fmDec);
                hmTDB_Detail.put("fmEnd", fmEnd);
                if (hmTDB.containsKey(this.baseCurrency)) {
                    HashMap hashMap = (HashMap)hmTDB.get(this.baseCurrency);
                    BigDecimal fmsBegin = (BigDecimal)hashMap.get("fmBegin");
                    BigDecimal fmsIncrease = (BigDecimal)hashMap.get("fmIncrease");
                    BigDecimal fmsDecrease = (BigDecimal)hashMap.get("fmDecrease");
                    BigDecimal fmsEnd = (BigDecimal)hashMap.get("fmEnd");
                    hmTDB_Detail.put("fmBegin", fmsBegin.add(fmBegin));
                    hmTDB_Detail.put("fmIncrease", fmsIncrease.add(fmInc));
                    hmTDB_Detail.put("fmDecrease", fmsDecrease.add(fmDec));
                    hmTDB_Detail.put("fmEnd", fmsEnd.add(fmEnd));
                    hmTDB.put(this.baseCurrency, hmTDB_Detail);
                    continue;
                }
                hmTDB.put(this.baseCurrency, hmTDB_Detail);
            }
            if (rbCols.size() == 0) {
                HashMap<String, BigDecimal> hmTDB_Detail = new HashMap<String, BigDecimal>();
                hmTDB_Detail.put("fmBegin", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmIncrease", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmDecrease", new BigDecimal("0.00").setScale(this.persion));
                hmTDB_Detail.put("fmEnd", new BigDecimal("0.00").setScale(this.persion));
                hmTDB.put(this.baseCurrency, hmTDB_Detail);
            }
            return hmTDB;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap getFmIncDec_old(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, SipgFmReconDirectionInfo reconDirection, Date bizDateStart, Date bizDateEnd, CurrencyInfo currency, String id) {
        String billTypeId = mappingEntry.getBillType().getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        CompanyOrgUnitInfo companyfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyfo.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("takeDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)billTypeId, CompareType.EQUALS));
        try {
            HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
            BigDecimal fmIncrease = new BigDecimal("0.00");
            fmIncrease = fmIncrease.setScale(this.persion);
            BigDecimal fmDecrease = new BigDecimal("0.00");
            fmDecrease = fmDecrease.setScale(this.persion);
            ReceivableBillCollection rbCol = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(evi);
            for (int i = 0; i < rbCol.size(); ++i) {
                ReceivableBillInfo receivableInfo = rbCol.get(i);
                String state = receivableInfo.getBillState().toString();
                for (int j = 0; j < reconDirection.getEntrys().size(); ++j) {
                    SipgFmReconDirectionEntryInfo FmReconDirectionEntryInfo = reconDirection.getEntrys().get(j);
                    String billState = FmReconDirectionEntryInfo.getStatusName();
                    if (!state.equals(billState)) continue;
                    if ((bizDateStart == null || receivableInfo.getTakeDate().getTime() >= bizDateStart.getTime()) && FmReconDirectionEntryInfo.getCashflow().equals((Object)SipgFmCashflow.increase)) {
                        fmIncrease = fmIncrease.add(receivableInfo.getBillAmt());
                    }
                    if (receivableInfo.getTransferDate() != null && (bizDateStart == null || receivableInfo.getTransferDate().getTime() >= bizDateStart.getTime()) && receivableInfo.getTransferDate().getTime() <= bizDateEnd.getTime() && FmReconDirectionEntryInfo.getCashflow().equals((Object)SipgFmCashflow.decrease)) {
                        fmDecrease = fmDecrease.add(receivableInfo.getBillAmt());
                    }
                    if (receivableInfo.getTransferDate() == null || bizDateStart != null && receivableInfo.getTransferDate().getTime() <= bizDateEnd.getTime() || bizDateStart != null && receivableInfo.getTakeDate().getTime() < bizDateStart.getTime() || !FmReconDirectionEntryInfo.getCashflow().equals((Object)SipgFmCashflow.decrease)) continue;
                    fmIncrease = fmIncrease.add(receivableInfo.getBillAmt());
                    System.out.println(fmIncrease);
                }
            }
            hashmap.put("fmIncrease", fmIncrease);
            hashmap.put("fmDecrease", fmDecrease);
            return hashmap;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap getFmIncDec(Context ctx, SipgFmReconMappingEntryInfo mappingEntry, SipgFmReconDirectionInfo reconDirection, Date bizDateStart, Date bizDateEnd, ReceivableBillInfo receivableInfo) {
        HashMap<String, BigDecimal> hashmap = new HashMap<String, BigDecimal>();
        BigDecimal fmIncrease = new BigDecimal("0.00");
        fmIncrease = fmIncrease.setScale(this.persion);
        BigDecimal fmDecrease = new BigDecimal("0.00");
        fmDecrease = fmDecrease.setScale(this.persion);
        BigDecimal endIncrease = new BigDecimal("0.00");
        endIncrease = endIncrease.setScale(this.persion);
        BigDecimal endDecrease = new BigDecimal("0.00");
        endDecrease = endDecrease.setScale(this.persion);
        SipgFmCashflow direction = SipgFmCashflow.none;
        BigDecimal amount = new BigDecimal("0.00");
        amount.setScale(this.persion);
        Date tempDate = null;
        HashMap map = new HashMap();
        Boolean hasTraceDown = true;
        String id = receivableInfo.getId().toString();
        switch (receivableInfo.getBillState().getValue()) {
            case 0: {
                hasTraceDown = false;
                direction = this.getDirectionType(0);
                amount = receivableInfo.getNaturalAmt();
                tempDate = receivableInfo.getTakeDate();
                break;
            }
            case 1: {
                map = this.getTrusteeOrPledge(ctx, 1, bizDateStart, bizDateEnd, receivableInfo);
                hasTraceDown = (Boolean)map.get("hasTraceDown");
                direction = (SipgFmCashflow)((Object)map.get("direction"));
                amount = (BigDecimal)map.get("amount");
                tempDate = (Date)map.get("tempDate");
                break;
            }
            case 8: {
                map = this.getTrusteeOrPledge(ctx, 8, bizDateStart, bizDateEnd, receivableInfo);
                hasTraceDown = (Boolean)map.get("hasTraceDown");
                direction = (SipgFmCashflow)((Object)map.get("direction"));
                amount = (BigDecimal)map.get("amount");
                tempDate = (Date)map.get("tempDate");
                break;
            }
            case 12: {
                break;
            }
            case 11: {
                break;
            }
            case 7: {
                direction = this.getDirectionType(5);
                tempDate = receivableInfo.getEndorseBill().getEndorseDate();
                amount = receivableInfo.getNaturalAmt();
                break;
            }
            case 2: {
                direction = this.getDirectionType(6);
                tempDate = receivableInfo.getEndorseBill().getEndorseDate();
                amount = receivableInfo.getNaturalAmt();
                break;
            }
            case 3: {
                direction = this.getDirectionType(7);
                amount = receivableInfo.getNaturalAmt();
                tempDate = receivableInfo.getDiscountBill().getDiscountDate();
                break;
            }
            case 4: {
                direction = this.getDirectionType(8);
                map = this.getGatherDecrease(ctx, receivableInfo);
                amount = (BigDecimal)map.get("amount");
                tempDate = (Date)map.get("tempDate");
                break;
            }
            case 9: {
                direction = this.getDirectionType(9);
                map = this.getAbandonDecrease(ctx, bizDateStart, bizDateEnd, id);
                amount = (BigDecimal)map.get("amount");
                tempDate = (Date)map.get("tempDate");
                break;
            }
            case 10: {
                direction = this.getDirectionType(10);
                map = this.getTranlendDecrease(ctx, bizDateStart, bizDateEnd, id);
                amount = (BigDecimal)map.get("amount");
                tempDate = (Date)map.get("tempDate");
            }
        }
        if (tempDate != null) {
            if (SipgFmCashflow.increase.equals((Object)direction)) {
                if (!tempDate.after(bizDateEnd) && amount != null) {
                    endIncrease = endIncrease.add(amount);
                    if (!tempDate.before(bizDateStart)) {
                        fmIncrease = fmIncrease.add(amount);
                    }
                }
            } else if (SipgFmCashflow.decrease.equals((Object)direction) && !tempDate.after(bizDateEnd) && amount != null) {
                endDecrease = endDecrease.add(amount);
                if (!tempDate.before(bizDateStart)) {
                    fmDecrease = fmDecrease.add(amount);
                }
            }
        }
        if (hasTraceDown.booleanValue() && !receivableInfo.isSplit() && !receivableInfo.getTakeDate().after(bizDateEnd)) {
            endIncrease = endIncrease.add(receivableInfo.getNaturalAmt());
            if (!receivableInfo.getTakeDate().before(bizDateStart)) {
                fmIncrease = fmIncrease.add(receivableInfo.getNaturalAmt());
            }
        }
        hashmap.put("fmIncrease", fmIncrease);
        hashmap.put("fmDecrease", fmDecrease);
        hashmap.put("endIncrease", endIncrease);
        hashmap.put("endDecrease", endDecrease);
        return hashmap;
    }

    private FilterItemInfo getMappingFilter(SipgFmReconMappingEntryInfo mappingEntry) {
        FilterItemInfo itemInfo = new FilterItemInfo();
        if (mappingEntry.getBillType() != null) {
            itemInfo = new FilterItemInfo("ntType", (Object)mappingEntry.getBillType().getId().toString(), CompareType.EQUALS);
            return itemInfo;
        }
        return itemInfo;
    }

    private SipgFmCashflow getDirectionType(int i) {
        SipgFmReconDirectionEntryCollection directionEntryCollection = directionInfo.getEntrys();
        SipgFmReconDirectionEntryInfo entryInfo = directionEntryCollection.get(i);
        return entryInfo.getCashflow();
    }

    private HashMap getTrusteeOrPledge(Context ctx, int state, Date bizDateStart, Date bizDateEnd, ReceivableBillInfo receivableInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amount", new BigDecimal("0.00").setScale(this.persion));
        if (receivableInfo.isIsTrustee()) {
            map.put("hasTraceDown", true);
            map.put("direction", (Object)this.getDirectionType(3));
            map.put("amount", receivableInfo.getNaturalAmt());
            map.put("tempDate", receivableInfo.getTrustDate());
        } else if (receivableInfo.isIsPledge()) {
            map.put("hasTraceDown", true);
            map.put("direction", (Object)this.getDirectionType(4));
            map.put("amount", receivableInfo.getNaturalAmt());
            map.put("tempDate", receivableInfo.getWageId().getIssuedate());
        } else if (state == 1) {
            map.put("hasTraceDown", false);
            map.put("direction", (Object)this.getDirectionType(1));
            map.put("amount", receivableInfo.getNaturalAmt());
            map.put("tempDate", receivableInfo.getTakeDate());
        } else if (state == 8) {
            map.put("hasTraceDown", false);
            map.put("direction", (Object)this.getDirectionType(2));
            map.put("amount", receivableInfo.getNaturalAmt());
            map.put("tempDate", receivableInfo.getTakeDate());
        }
        return map;
    }

    private HashMap getGatherDecrease(Context ctx, ReceivableBillInfo receivableBill) {
        HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
        map.put("amount", receivableBill.getBillAmt());
        map.put("tempDate", receivableBill.getTransferDate());
        return map;
    }

    private HashMap getAbandonDecrease(Context ctx, Date bizDateStart, Date bizDateEnd, String id) {
        HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("srcBillId");
        selector.add("returnDate");
        selector.add("locAmount");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("srcBillId", (Object)id, CompareType.EQUALS));
        try {
            ReturnBillCollection coll = ReturnBillFactory.getLocalInstance((Context)ctx).getReturnBillCollection(view);
            for (int j = 0; j < coll.size(); ++j) {
                ReturnBillInfo info = coll.get(j);
                map.put("amount", info.getLocAmount());
                map.put("tempDate", info.getReturnDate());
            }
            if (coll.size() == 0) {
                map.put("amount", new BigDecimal("0.00").setScale(this.persion));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }

    private HashMap getTranlendDecrease(Context ctx, Date bizDateStart, Date bizDateEnd, String id) {
        HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("sourceBillId");
        selector.add("bizDate");
        selector.add("loanAmtLocal");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)id, CompareType.EQUALS));
        if (bizDateStart == null) {
            filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateStart), CompareType.GREATER_EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)sdf.format(bizDateEnd), CompareType.LESS_EQUALS));
        try {
            FundTransferBillCollection coll = FundTransferBillFactory.getLocalInstance((Context)ctx).getFundTransferBillCollection(view);
            for (int j = 0; j < coll.size(); ++j) {
                FundTransferBillInfo info = coll.get(j);
                map.put("amount", info.getLoanAmtLocal());
                map.put("tempDate", info.getBizDate());
            }
            if (coll.size() == 0) {
                map.put("amount", new BigDecimal("0.00").setScale(this.persion));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }
}

