/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CommonHelper {
    public static String resourcePath = "com.kingdee.eas.fm.rpm.RecPayClaimResource";

    public CompanyOrgUnitCollection getUserOrgRangesWithRange(Context ctx, String permissionItem) throws BOSException, EASBizException {
        Set orgPermSet;
        UserInfo userInfo;
        CompanyOrgUnitInfo currentCompany;
        CompanyOrgUnitCollection orgColl = new CompanyOrgUnitCollection();
        if (ctx == null) {
            currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            orgPermSet = PermissionFactory.getRemoteInstance().getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
        } else {
            currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            orgPermSet = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
        }
        if (orgPermSet.contains(currentCompany.getId().toString()) && currentCompany.isIsBizUnit() && currentCompany.getAccountTable() != null && !currentCompany.isIsOUSealUp()) {
            orgColl.add(currentCompany);
            return orgColl;
        }
        for (String orgUnitId : orgPermSet) {
            ObjectUuidPK pk = new ObjectUuidPK(orgUnitId);
            CompanyOrgUnitInfo company = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)pk) : CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
            if (!company.isIsBizUnit() || company.getAccountTable() == null || company.isIsOUSealUp() || company.isIsSealUp()) continue;
            orgColl.add(company);
            break;
        }
        return orgColl;
    }

    public AsstActTypeCollection getAsstActTypeColl(Set companySet, boolean isPay, boolean isRec) throws BOSException {
        FilterInfo filter = this.getAsstActTypeFilter(companySet, isPay, isRec);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("realtionDataObject"));
        IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(evi);
        return asstActTypeCollection;
    }

    public AsstActTypeCollection getAsstActTypeColl(String cuId, boolean isPay, boolean isRec) throws BOSException, EASBizException {
        FilterInfo filter = this.getAsstActTypeFilter(cuId, isPay, isRec);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("realtionDataObject"));
        IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(evi);
        return asstActTypeCollection;
    }

    private FilterInfo getAsstActTypeFilter(String cuId, boolean isPay, boolean isRec) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)cuId)) {
            cuId = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit().getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("select FAsstActTypeID from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        sb.append(" and Fcompanyid='" + cuId + "'");
        if (isPay) {
            sb.append(" and FISDEFAULTACCOUNTPAYABLE=1");
        }
        if (isRec) {
            sb.append(" and FISDEFAULTACCOUNTRECEIVABLE=1");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        return filter;
    }

    private FilterInfo getAsstActTypeFilter(Set companySet, boolean isPay, boolean isRec) throws BOSException {
        if (EmptyUtil.isEmpty((Collection)companySet)) {
            companySet = new HashSet<String>();
            companySet.add(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("select FAsstActTypeID from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        Object[] set = new String[companySet.size()];
        Iterator it = companySet.iterator();
        int i = 0;
        while (it.hasNext()) {
            String id = (String)it.next();
            set[i++] = id;
        }
        sb.append(" and " + FMHelper.buildIn((String)"Fcompanyid", (Object[])set));
        if (isPay) {
            sb.append(" and FISDEFAULTACCOUNTPAYABLE=1");
        }
        if (isRec) {
            sb.append(" and FISDEFAULTACCOUNTRECEIVABLE=1");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        return filter;
    }

    public void createBotpRelation(Context ctx, String srcBillID, String destBillID) throws BOSException {
        IBOTRelation iBOTRelation = ctx != null ? BOTRelationFactory.getLocalInstance((Context)ctx) : BOTRelationFactory.getRemoteInstance();
        BOTRelationInfo botp = new BOTRelationInfo();
        String srcBosType = BOSUuid.read((String)srcBillID).getType().toString();
        String destBosType = BOSUuid.read((String)destBillID).getType().toString();
        botp.setSrcEntityID(srcBosType);
        botp.setDestEntityID(destBosType);
        botp.setSrcObjectID(srcBillID);
        botp.setDestObjectID(destBillID);
        botp.setDate(new Date());
        botp.setOperatorID("system");
        botp.setIsEffected(true);
        botp.setType(0);
        iBOTRelation.addnew(botp);
    }
}

