/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.RecRecService;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillCollection;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillFactory;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillFactory;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.cl.IConsignLoanIntBill;
import com.kingdee.eas.fm.cl.IConsingnRepaymentBill;
import com.kingdee.eas.fm.cl.OperationTypeEnum;
import com.kingdee.eas.fm.cl.StateEnum;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.ILoan;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.ft.FundTransferInterestBillCollection;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.ft.IFundTransferInterestBill;
import com.kingdee.eas.fm.ft.IFundTransferRepayBill;
import com.kingdee.eas.fm.im.AccrualBillFactory;
import com.kingdee.eas.fm.im.AccrualBillInfo;
import com.kingdee.eas.fm.im.IAccrualBill;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.FinancingRedeemFactory;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import com.kingdee.eas.fm.ivt.IFinancingRedeem;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.DiscountBillFactory;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.IDiscountBill;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.OprtEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.rpm.BillClaimStatusEnum;
import com.kingdee.eas.fm.rpm.CommonHelper;
import com.kingdee.eas.fm.rpm.RecBillClaimCollection;
import com.kingdee.eas.fm.rpm.RecBillClaimFactory;
import com.kingdee.eas.fm.rpm.RecBillClaimInfo;
import com.kingdee.eas.fm.rpm.RecClaimBillTypeEnum;
import com.kingdee.eas.fm.rpm.app.AbstractRecBillClaimControllerBean;
import com.kingdee.eas.fm.td.IIntReceivedBill;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.IntReceivedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecBillClaimControllerBean
extends AbstractRecBillClaimControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.rpm.app.RecBillClaimControllerBean");
    private CommonHelper helper = new CommonHelper();

    @Override
    protected Map _submitClaim(Context ctx, RecBillClaimCollection recBillClaimCol) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sql = "update t_cas_receivingbill set FBillClaimStatus=? , FRecBillClaim=? where fid=? ";
        StringBuffer sbFail = new StringBuffer();
        HashSet<IObjectPK> success = new HashSet<IObjectPK>();
        HashMap<String, Boolean> permission = new HashMap<String, Boolean>();
        Boolean isPermission = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.name");
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        for (int i = 0; i < recBillClaimCol.size(); ++i) {
            RecBillClaimInfo info = recBillClaimCol.get(i);
            String recId = info.getReceivingBillID().toString();
            ReceivingBillInfo recInfo = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(recId), sic);
            if (permission.containsKey(recInfo.getCompany().getId().toString())) {
                isPermission = (Boolean)permission.get(recInfo.getCompany().getId().toString());
            } else {
                isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId()), (String)"rpm_recClaim_02submit");
                permission.put(recInfo.getCompany().getId().toString(), isPermission);
            }
            if (isPermission.booleanValue()) {
                if (recInfo.getBillClaimStatus().equals((Object)BillClaimStatusEnum.AUDIT)) {
                    sbFail.append(info.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaimStatusIsAudit"));
                    continue;
                }
                info.setSubmiter(userInfo);
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                info.setSubmitTime(ts);
                IObjectPK pk = this.save(ctx, (CoreBaseInfo)info);
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{20, pk.toString(), recId});
                success.add(pk);
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"submitClaim", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(recInfo.getId()), (String)recInfo.getNumber(), (String)"rpm_recClaim_submit", (String)ctx.get((Object)"CurCompanyId").toString(), null);
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                continue;
            }
            sbFail.append(info.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"WithoutRecSubmitPermission", (String[])new String[]{recInfo.getCompany().getName()}));
        }
        result.put("all", recBillClaimCol.size());
        result.put("success", success);
        result.put("failDetail", sbFail.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _auditClaim(Context ctx, RecBillClaimCollection col) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer();
        HashSet success = new HashSet();
        Boolean lock1 = false;
        Boolean lock2 = false;
        HashMap<String, Boolean> permission = new HashMap<String, Boolean>();
        Boolean isPermission = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.name");
        sic.add("SettlementType.*");
        sic.add("SettlementType.nttype.*");
        sic.add("entries.*");
        SelectorItemCollection claimSic = new SelectorItemCollection();
        claimSic.add("*");
        claimSic.add("recType.sourceSysType");
        for (int i = 0; i < col.size(); ++i) {
            RecBillClaimInfo info = col.get(i);
            ReceivingBillInfo recInfo = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(info.getReceivingBillID()), sic);
            if (!recInfo.getBillClaimStatus().equals((Object)BillClaimStatusEnum.SUBMIT)) {
                sb.append(recInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaimStatusIsNotSubmit"));
                continue;
            }
            info = RecBillClaimFactory.getLocalInstance(ctx).getRecBillClaimInfo((IObjectPK)new ObjectUuidPK(recInfo.getRecBillClaim().getId()), claimSic);
            if (permission.containsKey(recInfo.getCompany().getId().toString())) {
                isPermission = (Boolean)permission.get(recInfo.getCompany().getId().toString());
            } else {
                isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId()), (String)"rpm_recClaim_03audit");
                permission.put(recInfo.getCompany().getId().toString(), isPermission);
            }
            if (!isPermission.booleanValue()) {
                sb.append(recInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"WithoutRecAuditPermission", (String[])new String[]{recInfo.getCompany().getName()}));
                continue;
            }
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            try {
                lock1 = iMutex.requestObjIDForUpdate(recInfo.getId().toString());
                lock2 = iMutex.requestObjIDForUpdate(info.getSrcBillID());
                if (lock1 & lock2) {
                    RecBillClaimFactory.getLocalInstance(ctx).auditOne(info, recInfo, sb, success);
                    continue;
                }
                sb.append(recInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecBillIsLocked"));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                sb.append(recInfo.getNumber()).append(String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"0_PayBillClaimControllerBean", (Locale)ctx.getLocale()), e.getMessage()));
                continue;
            }
            finally {
                if (lock1.booleanValue()) {
                    iMutex.releaseObjIDForUpdate(recInfo.getId().toString());
                }
                if (lock2.booleanValue()) {
                    iMutex.releaseObjIDForUpdate(info.getSrcBillID());
                }
            }
        }
        result.put("all", col.size());
        result.put("success", success);
        result.put("failDetail", sb.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _antiAuditClaim(Context ctx, RecBillClaimCollection col) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer();
        HashSet success = new HashSet();
        Boolean lock1 = false;
        Boolean lock2 = false;
        HashMap<String, Boolean> permission = new HashMap<String, Boolean>();
        Boolean isPermission = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.name");
        sic.add("SettlementType.*");
        sic.add("SettlementType.nttype.*");
        sic.add("entries.*");
        for (int i = 0; i < col.size(); ++i) {
            RecBillClaimInfo info = col.get(i);
            ReceivingBillInfo recInfo = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(info.getReceivingBillID()), sic);
            if (!recInfo.getBillClaimStatus().equals((Object)BillClaimStatusEnum.AUDIT)) {
                sb.append(recInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaimStatusIsNotAudit"));
                continue;
            }
            info = RecBillClaimFactory.getLocalInstance(ctx).getRecBillClaimInfo((IObjectPK)new ObjectUuidPK(recInfo.getRecBillClaim().getId()));
            if (permission.containsKey(recInfo.getCompany().getId().toString())) {
                isPermission = (Boolean)permission.get(recInfo.getCompany().getId().toString());
            } else {
                isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId()), (String)"rpm_recClaim_04antiAudit");
                permission.put(recInfo.getCompany().getId().toString(), isPermission);
            }
            if (!isPermission.booleanValue()) {
                sb.append(recInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"WithoutRecAntiAuditPermission", (String[])new String[]{recInfo.getCompany().getName()}));
                continue;
            }
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            try {
                lock1 = iMutex.requestObjIDForUpdate(recInfo.getId().toString());
                lock2 = iMutex.requestObjIDForUpdate(info.getSrcBillID());
                if (lock1 & lock2) {
                    RecBillClaimFactory.getLocalInstance(ctx).antiAuditOne(info, recInfo, sb, success);
                    continue;
                }
                sb.append(recInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecBillIsLocked"));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                sb.append(recInfo.getNumber()).append(String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"0_PayBillClaimControllerBean", (Locale)ctx.getLocale()), e.getMessage()));
                continue;
            }
            finally {
                if (lock1.booleanValue()) {
                    iMutex.releaseObjIDForUpdate(recInfo.getId().toString());
                }
                if (lock2.booleanValue()) {
                    iMutex.releaseObjIDForUpdate(info.getSrcBillID());
                }
            }
        }
        result.put("all", col.size());
        result.put("success", success);
        result.put("failDetail", sb.toString());
        return result;
    }

    @Override
    protected void _auditOne(Context ctx, RecBillClaimInfo info, ReceivingBillInfo recInfo, StringBuffer sb, Set success) throws BOSException, EASBizException {
        if (!recInfo.getBillClaimStatus().equals((Object)BillClaimStatusEnum.SUBMIT)) {
            sb.append(recInfo.getNumber()).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaimStatusIsNotSubmit"));
            return;
        }
        String claimSql = "UPDATE T_RPM_RecBillClaim SET fauditor=?,faudittime=GETDATE()  WHERE fid=? ";
        StringBuilder saveSql = new StringBuilder();
        saveSql.append("update t_cas_receivingbill set ");
        StringBuilder entrySql = new StringBuilder();
        entrySql.append("update\tt_cas_receivingbillentry set ");
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> entryParams = new ArrayList<String>();
        if (info.getRecType() != null) {
            saveSql.append(" FRecBillTypeId=?, ");
            params.add(info.getRecType().getId().toString());
            recInfo.setRecBillType(info.getRecType());
            saveSql.append(" FSourceType=?, ");
            params.add(info.getRecType().getSourceSysType().getValue());
            recInfo.setSourceSysType(info.getRecType().getSourceSysType());
        }
        if (info.getFundFlowItem() != null) {
            saveSql.append(" FFundFlowItemId=?, ");
            params.add(info.getFundFlowItem().getId().toString());
            recInfo.setFundFlowItem(info.getFundFlowItem());
            entrySql.append(" FFUNDFLOWITEMID=?, ");
            entryParams.add(info.getFundFlowItem().getId().toString());
        }
        if (info.getOppAccount() != null) {
            saveSql.append(" FOppAccountId=?, ");
            params.add(info.getOppAccount().getId().toString());
            recInfo.setOppAccount(info.getOppAccount());
            entrySql.append(" FOPPACCOUNTID=?, ");
            entryParams.add(info.getOppAccount().getId().toString());
        }
        if (EmptyUtil.isEmpty((String)info.getSrcBillID()) || EmptyUtil.isEmpty((Object)((Object)info.getRecClaimBillType()))) {
            saveSql.append(" fbillclaimstatus=? where  fid=?");
            params.add(30);
            params.add(recInfo.getId().toString());
            DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
            entrySql.append(" FRECEIVINGBILLID=? where FRECEIVINGBILLID =?");
            entryParams.add(info.getReceivingBillID());
            entryParams.add(info.getReceivingBillID());
            DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
            logger.error((Object)("---------id:" + info.getId().toString() + "-------claimSql : " + claimSql));
            DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
            success.add(recInfo.getId().toString());
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"auditOne", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(recInfo.getId()), (String)recInfo.getNumber(), (String)"rpm_recClaim_audit", (String)ctx.get((Object)"CurCompanyId").toString(), null);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            return;
        }
        saveSql.append(" fbillclaimstatus=?, ");
        params.add(30);
        int billType = info.getRecClaimBillType().getValue();
        String srcBillID = info.getSrcBillID();
        String srcBillNumber = info.getSrcBillNumber();
        String destBillID = info.getReceivingBillID();
        String destBillNumber = recInfo.getNumber();
        String description = recInfo.getDescription() == null ? "" : recInfo.getDescription();
        switch (billType) {
            case 10: {
                ILoan iLoan = LoanFactory.getLocalInstance((Context)ctx);
                if (!iLoan.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                LoanInfo loan = iLoan.getLoanInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!loan.getStatus().equals((Object)FinBillStatusEnum.AUDITED) || loan.isIsGenRecBill() || !EmptyUtil.isEmpty((CoreBaseInfo)loan.getCashier()) || loan.getAmount().compareTo(recInfo.getActRecAmt()) != 0) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecClaim_LoanTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"75_RecBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(destBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FRECEIVINGBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                String loanSql = "update T_FIN_Loan set fisGenRecBill=1 where fid=?";
                logger.error((Object)("---------id:" + info.getId().toString() + "-------loanSql : " + loanSql));
                DbUtil.execute((Context)ctx, (String)loanSql, (Object[])new Object[]{srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(recInfo.getId().toString());
                break;
            }
            case 20: {
                BigDecimal accrualForCheck;
                IConsingnRepaymentBill iConRepay = ConsingnRepaymentBillFactory.getLocalInstance((Context)ctx);
                if (!iConRepay.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                ConsingnRepaymentBillInfo conRepay = iConRepay.getConsingnRepaymentBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!conRepay.getOperationType().equals((Object)OperationTypeEnum.CONSIGN) || !conRepay.getState().equals((Object)StateEnum.EAA) || conRepay.isIsGenRecBill() || conRepay.getRepayAmt().compareTo(recInfo.getActRecAmt()) > 0) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecClaim_ConsignmentRepaybillTip"));
                    return;
                }
                BigDecimal bigDecimal = accrualForCheck = info.getInterest() == null ? conRepay.getAccrual() : info.getInterest();
                if (accrualForCheck.compareTo(recInfo.getActRecAmt()) == 1) {
                    sb.append(destBillNumber).append(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"76_RecBillClaimControllerBean", (Locale)ctx.getLocale()));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"77_RecBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber, conRepay.getRepaySeq())).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(destBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FRECEIVINGBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("repayBill.id", (Object)conRepay.getId().toString()));
                evi.setFilter(filter);
                ConsignLoanIntBillCollection conLoanIntCol = ConsignLoanIntBillFactory.getLocalInstance((Context)ctx).getConsignLoanIntBillCollection(evi);
                BigDecimal accrual = conRepay.getAccrual();
                for (int j = 0; j < conLoanIntCol.size(); ++j) {
                    accrual = accrualForCheck;
                    this.helper.createBotpRelation(ctx, conLoanIntCol.get(j).getId().toString(), destBillID);
                    String conLoanIntSql = "update T_CL_ConsignLoanIntBill set FshijiIntAmt=? where fid=?";
                    DbUtil.execute((Context)ctx, (String)conLoanIntSql, (Object[])new Object[]{accrual, conLoanIntCol.get(j).getId().toString()});
                }
                String repaySql = "update T_CL_ConsingnRepaymentBill set FRecBillID = ?,FAccrual=?,FIsGenRecBill=1 where FID = ?";
                logger.error((Object)("---------id:" + info.getId().toString() + "-------repaySql : " + repaySql + ",destBillID" + destBillID + ",accrual" + accrual + ",srcBillID" + srcBillID));
                DbUtil.execute((Context)ctx, (String)repaySql, (Object[])new Object[]{destBillID, accrual, srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(recInfo.getId().toString());
                break;
            }
            case 30: {
                BigDecimal fundaccrualForCheck;
                IFundTransferRepayBill iFundRepay = FundTransferRepayBillFactory.getLocalInstance((Context)ctx);
                if (!iFundRepay.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                FundTransferRepayBillInfo fundRepay = iFundRepay.getFundTransferRepayBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!fundRepay.getState().equals((Object)StateEnum.EAA) || fundRepay.getRecBill() != null || !EmptyUtil.isEmpty((CoreBaseInfo)fundRepay.getCashier()) || fundRepay.getRepayAmt().compareTo(recInfo.getActRecAmt()) > 0) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecClaim_FundtransferRepaybillTip"));
                    return;
                }
                BigDecimal bigDecimal = fundaccrualForCheck = info.getInterest() == null ? fundRepay.getAccrual() : info.getInterest();
                if (fundaccrualForCheck.compareTo(recInfo.getActRecAmt()) == 1) {
                    sb.append(destBillNumber).append(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"76_RecBillClaimControllerBean", (Locale)ctx.getLocale()));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"78_RecBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber, fundRepay.getRepaySeq())).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(destBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FRECEIVINGBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                EntityViewInfo fundevi = new EntityViewInfo();
                FilterInfo fundfilter = new FilterInfo();
                fundfilter.getFilterItems().add(new FilterItemInfo("transRepay.id", (Object)fundRepay.getId().toString()));
                fundevi.setFilter(fundfilter);
                FundTransferInterestBillCollection fundIntBillCol = FundTransferInterestBillFactory.getLocalInstance((Context)ctx).getFundTransferInterestBillCollection(fundevi);
                BigDecimal fundaccrual = fundRepay.getAccrual();
                for (int j = 0; j < fundIntBillCol.size(); ++j) {
                    fundaccrual = fundaccrualForCheck;
                    this.helper.createBotpRelation(ctx, fundIntBillCol.get(j).getId().toString(), destBillID);
                    String conLoanIntSql = "update T_FT_FundTransferInterestBill set FshijiIntAmt=? where fid=?";
                    DbUtil.execute((Context)ctx, (String)conLoanIntSql, (Object[])new Object[]{fundaccrual, fundIntBillCol.get(j).getId().toString()});
                }
                String fundSql = "update T_FT_FundTransferRepayBill set FRecBillID = ?,FAccrual=? where FID = ?";
                logger.error((Object)("---------id:" + info.getId().toString() + "-------fundSql : " + fundSql + ",destBillID" + destBillID + ",fundaccrual" + fundaccrual + ",srcBillID" + srcBillID));
                DbUtil.execute((Context)ctx, (String)fundSql, (Object[])new Object[]{destBillID, fundaccrual, srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(recInfo.getId().toString());
                break;
            }
            case 40: {
                boolean isAutoVerifyReceivingBill;
                IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance((Context)ctx);
                if (!iReceivableBill.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                ReceivableBillInfo receivableBill = iReceivableBill.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!receivableBill.getBillState().equals((Object)BillStateEnum.SAVED) && !receivableBill.getBillState().equals((Object)BillStateEnum.Audit) || receivableBill.getBillAmt().compareTo(recInfo.getActRecAmt()) != 0) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecClaim_ReceivablebillTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"79_RecBillClaimControllerBean", (Locale)ctx.getLocale()), receivableBill.getDraftNumber())).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fsettlementnumber=?,fSourceBillId=?  where fid=?");
                params.add(description);
                params.add(receivableBill.getDraftNumber());
                params.add(srcBillID);
                params.add(destBillID);
                recInfo.setSettlementNumber(receivableBill.getDraftNumber());
                recInfo.setBillClaimStatus(BillClaimStatusEnum.AUDIT);
                recInfo.setSourceBillId(srcBillID);
                if (recInfo.getBillStatus().equals((Object)BillStatusEnum.RECED) && (isAutoVerifyReceivingBill = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS070", (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId())))) {
                    RecRecService recService = new RecRecService();
                    recService.WriteOffReceivableBill(ctx, recInfo, recInfo.getCompany().getId().toString());
                }
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FRECEIVINGBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                success.add(recInfo.getId().toString());
                break;
            }
            case 50: {
                IFinancingRedeem iRedeem = FinancingRedeemFactory.getLocalInstance((Context)ctx);
                if (!iRedeem.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                FinancingRedeemInfo redeem = iRedeem.getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!redeem.getState().equals((Object)com.kingdee.eas.fm.ivt.BillStateEnum.AUDITED) || redeem.isIsBook() || redeem.isIsGeneGaterBill()) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecClaim_FinancingRedeemTip"));
                    return;
                }
                BigDecimal finamount = redeem.getRedeemAmount();
                BigDecimal recTotalAmount = redeem.getRecTotalAmount().add(recInfo.getActRecAmt());
                if (recTotalAmount.compareTo(finamount.add(redeem.getPracticalWinAmount())) == 1) {
                    sb.append(destBillNumber).append(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"80_RecBillClaimControllerBean", (Locale)ctx.getLocale()));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"81_RecBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=?  where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(destBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FRECEIVINGBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                String redeemSql = "update T_IVT_FinancingRedeem set FIsGeneGaterBill=1 ,FRecTotalAmount= ?where fid=?";
                logger.error((Object)("---------id:" + info.getId().toString() + "-------redeemSql : " + redeemSql + ",recTotalAmount" + recTotalAmount + ",destBillID" + destBillID));
                DbUtil.execute((Context)ctx, (String)redeemSql, (Object[])new Object[]{recTotalAmount, srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(recInfo.getId().toString());
                break;
            }
            case 60: {
                IDiscountBill iDiscount = DiscountBillFactory.getLocalInstance((Context)ctx);
                if (!iDiscount.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                DiscountBillInfo discount = iDiscount.getDiscountBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!EmptyUtil.isEmpty((String)discount.getRpBillId()) || !EmptyUtil.isEmpty((CoreBaseInfo)discount.getCashier()) || discount.getBillAmount().compareTo(recInfo.getActRecAmt()) == -1) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecClaim_DiscountBillTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"82_RecBillClaimControllerBean", (Locale)ctx.getLocale()), discount.getNoteBillNumber())).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fsettlementnumber=?,fSourceBillId=? where fid=?");
                params.add(description);
                params.add(discount.getNumber());
                params.add(srcBillID);
                params.add(destBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FRECEIVINGBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                BigDecimal actInterest = discount.getBillAmount().subtract(recInfo.getActRecAmt());
                BigDecimal actLocalInterest = actInterest.multiply(discount.getExRate());
                BigDecimal actLocalAmt = recInfo.getActRecAmt().multiply(discount.getExRate());
                String discountSql = "update T_NT_DiscountBill set FRpBillId=? ,FDISCOUNTINT=?,FACTDISCOUNTINT=?,FDISCOUNTLOCINT=?,FACTRECVAMOUNT=?,FACTRECVLOCAMOUNT=? where fid=?";
                logger.error((Object)("---------id:" + info.getId().toString() + "-------discountSql : " + discountSql + ",destBillID" + destBillID + ",actInterest" + actInterest + ",actLocalInterest" + actLocalInterest + ",ActRecAmt" + recInfo.getActRecAmt() + ",actLocalAmt" + actLocalAmt + ",srcBillID" + srcBillID));
                DbUtil.execute((Context)ctx, (String)discountSql, (Object[])new Object[]{destBillID, actInterest, actInterest, actLocalInterest, recInfo.getActRecAmt(), actLocalAmt, srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(recInfo.getId().toString());
                break;
            }
            case 70: {
                IFundTransferInterestBill iFTInterest = FundTransferInterestBillFactory.getLocalInstance((Context)ctx);
                if (!iFTInterest.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                FundTransferInterestBillInfo FTInterestBill = iFTInterest.getFundTransferInterestBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (FTInterestBill.isIsGatherBill() || !FTInterestBill.getEffectedStatus().equals((Object)StateEnum.EAA) || !FTInterestBill.getIntCalType().equals((Object)IntCalTypeEnum.REC_INT) || FTInterestBill.getShijiIntAmt().compareTo(recInfo.getActRecAmt()) != 0) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecClaim_FTInterestTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"83_RecBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=?  where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(destBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FRECEIVINGBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                String FTISql = "update T_FT_FundTransferInterestBill set FIsGatherBill=1 where fid=?";
                logger.error((Object)("---------id:" + info.getId().toString() + "-------FTISql : " + FTISql + ",srcBillID" + srcBillID));
                DbUtil.execute((Context)ctx, (String)FTISql, (Object[])new Object[]{srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(recInfo.getId().toString());
                break;
            }
            case 80: {
                IConsignLoanIntBill iCLIntBill = ConsignLoanIntBillFactory.getLocalInstance((Context)ctx);
                if (!iCLIntBill.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                ConsignLoanIntBillInfo CLIntBill = iCLIntBill.getConsignLoanIntBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (!CLIntBill.getIntCalType().equals((Object)IntCalTypeEnum.REC_INT) && !CLIntBill.getIntCalType().equals((Object)IntCalTypeEnum.REPAY_INT) || CLIntBill.isIsGenReceiving() || !CLIntBill.getEffectedStatus().equals((Object)StateEnum.EAA) || !EmptyUtil.isEmpty((CoreBaseInfo)CLIntBill.getCashier()) || !CLIntBill.getOperationType().equals((Object)OperationTypeEnum.CONSIGN) || CLIntBill.getShijiIntAmt().compareTo(recInfo.getActRecAmt()) != 0) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecClaim_ConsignLoanIntTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"84_RecBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=?  where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(destBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FRECEIVINGBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                String CLISql = "update T_CL_ConsignLoanIntBill set FIsGenReceiving=1 where fid=?";
                logger.error((Object)("---------id:" + info.getId().toString() + "-------CLISql : " + CLISql + ",srcBillID" + srcBillID));
                DbUtil.execute((Context)ctx, (String)CLISql, (Object[])new Object[]{srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(recInfo.getId().toString());
                break;
            }
            case 90: {
                IAccrualBill iaccrualBill = AccrualBillFactory.getLocalInstance((Context)ctx);
                if (!iaccrualBill.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                AccrualBillInfo accrualBill = iaccrualBill.getAccrualBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (accrualBill.isIsGenReceiving() || !accrualBill.isHasEffected() || accrualBill.isIsSettled() || accrualBill.getNetAmt().subtract(accrualBill.getOverDraftAccrua()).compareTo(recInfo.getActRecAmt()) != 0) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecClaim_AccrualTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"85_RecBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=?  where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(destBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FRECEIVINGBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                String AccSql = "update T_INT_AccrualBill set FIsGenReceiving=1 where fid=?";
                logger.error((Object)("---------id:" + info.getId().toString() + "-------AccSql : " + AccSql + ",srcBillID" + srcBillID));
                DbUtil.execute((Context)ctx, (String)AccSql, (Object[])new Object[]{srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(recInfo.getId().toString());
                break;
            }
            case 100: {
                IIntReceivedBill iIntReceivedBill = IntReceivedBillFactory.getLocalInstance((Context)ctx);
                if (!iIntReceivedBill.exists((IObjectPK)new ObjectUuidPK(srcBillID))) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaim_CheckBillExist"));
                    return;
                }
                IntReceivedBillInfo intReceivedBill = iIntReceivedBill.getIntReceivedBillInfo((IObjectPK)new ObjectUuidPK(srcBillID));
                if (intReceivedBill.isIsGenReceiving() || intReceivedBill.getEffectedStatus() != IntReceivedStatusEnum.EXAMINE || intReceivedBill.isIsBooked() || intReceivedBill.getShijiAmt().compareTo(recInfo.getActRecAmt()) != 0 && intReceivedBill.getShijiAmt().add(intReceivedBill.getDepositAmt()).compareTo(recInfo.getActRecAmt()) != 0) {
                    sb.append(destBillNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"RecClaim_IntReceiedTip"));
                    return;
                }
                if ((description = description + String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"86_RecBillClaimControllerBean", (Locale)ctx.getLocale()), srcBillNumber)).length() > 255) {
                    description = description.substring(0, 255);
                }
                saveSql.append(" fdescription=?,fSourceBillId=?  where fid=?");
                params.add(description);
                params.add(srcBillID);
                params.add(destBillID);
                DbUtil.execute((Context)ctx, (String)saveSql.toString(), (Object[])params.toArray());
                entrySql.append(" FSOURCEBILLID =? where FRECEIVINGBILLID =? ");
                entryParams.add(srcBillID);
                entryParams.add(destBillID);
                DbUtil.execute((Context)ctx, (String)entrySql.toString(), (Object[])entryParams.toArray());
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{ctx.getCaller().toString(), info.getId().toString()});
                String TdTntSql = "update T_TD_IntReceivedBill set FIsGenReceiving=1 where fid=?";
                logger.error((Object)("---------id:" + info.getId().toString() + "-------TdTntSql : " + TdTntSql + ",srcBillID" + srcBillID));
                DbUtil.execute((Context)ctx, (String)TdTntSql, (Object[])new Object[]{srcBillID});
                this.helper.createBotpRelation(ctx, srcBillID, destBillID);
                success.add(recInfo.getId().toString());
            }
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"auditOne", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(recInfo.getId()), (String)recInfo.getNumber(), (String)"rpm_recClaim_audit", (String)ctx.get((Object)"CurCompanyId").toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _antiAuditOne(Context ctx, RecBillClaimInfo info, ReceivingBillInfo recInfo, StringBuffer sb, Set success) throws BOSException, EASBizException {
        String srcObjectId = info.getSrcBillID();
        String srcNumber = info.getSrcBillNumber();
        String destObjectId = info.getReceivingBillID();
        String destNumber = recInfo.getNumber();
        String claimSql = "UPDATE T_RPM_RecBillClaim SET fauditor=null,faudittime=null  WHERE fid=? ";
        String recSql = "update t_cas_receivingbill set fbillclaimstatus=?, fdescription=null, fSourceBillId=null where fid=?";
        String entrySql = "update\tt_cas_receivingbillentry set FSOURCEBILLID =? where FRECEIVINGBILLID =? ";
        Object[] recParams = new Object[]{20, destObjectId};
        Object[] entryParams = new Object[]{null, destObjectId};
        if (!recInfo.getBillClaimStatus().equals((Object)BillClaimStatusEnum.AUDIT)) {
            sb.append(destNumber).append(CASWebUtil.getResource((Context)ctx, (String)CommonHelper.resourcePath, (String)"BillClaimStatusIsNotAudit"));
            return;
        }
        if (EmptyUtil.isEmpty((String)srcObjectId)) {
            DbUtil.execute((Context)ctx, (String)recSql, (Object[])new Object[]{20, destObjectId});
            DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
            success.add(destObjectId);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"antiAuditOne", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(recInfo.getId()), (String)recInfo.getNumber(), (String)"rpm_recClaim_antiAudit", (String)ctx.get((Object)"CurCompanyId").toString(), null);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            return;
        }
        String billType = info.getRecClaimBillType().getAlias();
        IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationInfo botInfo = new BOTRelationInfo();
        if (!info.getRecClaimBillType().equals((Object)RecClaimBillTypeEnum.ReceivableBill)) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("srcObjectId", (Object)srcObjectId));
            filter.getFilterItems().add(new FilterItemInfo("destObjectId", (Object)destObjectId));
            evi.setFilter(filter);
            BOTRelationCollection botCol = iBotRelation.getCollection(evi);
            if (botCol.size() == 0) {
                sb.append(String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"87_RecBillClaimControllerBean", (Locale)ctx.getLocale()), destNumber, billType, srcNumber));
                return;
            }
            if (botCol.size() == 1) {
                botInfo = botCol.get(0);
            } else {
                sb.append(String.format(ResourceBase.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"88_RecBillClaimControllerBean", (Locale)ctx.getLocale()), destNumber, billType, srcNumber));
                return;
            }
        }
        switch (info.getRecClaimBillType().getValue()) {
            case 10: {
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)recSql, (Object[])recParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String loanSql = "update T_FIN_Loan set fisGenRecBill=0 where fid=?";
                DbUtil.execute((Context)ctx, (String)loanSql, (Object[])new Object[]{srcObjectId});
                success.add(destObjectId);
                break;
            }
            case 20: {
                BigDecimal accrual = BigDecimal.ZERO;
                EntityViewInfo conevi = new EntityViewInfo();
                FilterInfo confilter = new FilterInfo();
                confilter.getFilterItems().add(new FilterItemInfo("repayBill.id", (Object)srcObjectId));
                conevi.setFilter(confilter);
                ConsignLoanIntBillCollection conLoanIntCol = ConsignLoanIntBillFactory.getLocalInstance((Context)ctx).getConsignLoanIntBillCollection(conevi);
                String conLoanIntSql = "update T_CL_ConsignLoanIntBill set FshijiIntAmt=? where fid=?";
                String conBtpSql = "delete from t_bot_relation where fsrcobjectid=? and fdestobjectid=?";
                for (int i = 0; i < conLoanIntCol.size(); ++i) {
                    accrual = conLoanIntCol.get(i).getYingjiIntAmt();
                    DbUtil.execute((Context)ctx, (String)conBtpSql, (Object[])new Object[]{conLoanIntCol.get(i).getId().toString(), destObjectId});
                    DbUtil.execute((Context)ctx, (String)conLoanIntSql, (Object[])new Object[]{accrual, conLoanIntCol.get(i).getId().toString()});
                }
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)recSql, (Object[])recParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String repaySql = "update T_CL_ConsingnRepaymentBill set FRecBillID = ?,FAccrual=?,FIsGenRecBill=0 where FID = ?";
                DbUtil.execute((Context)ctx, (String)repaySql, (Object[])new Object[]{null, accrual, srcObjectId});
                success.add(destObjectId);
                break;
            }
            case 30: {
                EntityViewInfo fundevi = new EntityViewInfo();
                FilterInfo fundfilter = new FilterInfo();
                fundfilter.getFilterItems().add(new FilterItemInfo("transRepay.id", (Object)srcObjectId));
                fundevi.setFilter(fundfilter);
                FundTransferInterestBillCollection fundIntBillCol = FundTransferInterestBillFactory.getLocalInstance((Context)ctx).getFundTransferInterestBillCollection(fundevi);
                BigDecimal fundaccrual = BigDecimal.ZERO;
                String fundBtpSql = "delete from t_bot_relation where fsrcobjectid=? and fdestobjectid=?";
                String fundLoanIntSql = "update T_FT_FundTransferInterestBill set FshijiIntAmt=? where fid=?";
                for (int i = 0; i < fundIntBillCol.size(); ++i) {
                    fundaccrual = fundIntBillCol.get(i).getYingjiIntAmt();
                    DbUtil.execute((Context)ctx, (String)fundBtpSql, (Object[])new Object[]{fundIntBillCol.get(i).getId().toString(), destObjectId});
                    DbUtil.execute((Context)ctx, (String)fundLoanIntSql, (Object[])new Object[]{fundaccrual, fundIntBillCol.get(i).getId().toString()});
                }
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)recSql, (Object[])recParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String fundSql = "update T_FT_FundTransferRepayBill set FRecBillID = ?,FAccrual=? where FID = ?";
                DbUtil.execute((Context)ctx, (String)fundSql, (Object[])new Object[]{null, fundaccrual, srcObjectId});
                success.add(destObjectId);
                break;
            }
            case 40: {
                boolean isAutoVerifyReceivingBill = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS070", (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId()));
                if (isAutoVerifyReceivingBill) {
                    this.UnWriteOffReceivableBill(ctx, recInfo);
                }
                DbUtil.execute((Context)ctx, (String)recSql, (Object[])recParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                success.add(destObjectId);
                break;
            }
            case 50: {
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)recSql, (Object[])recParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                BigDecimal payAmount = recInfo.getActRecAmt();
                FinancingRedeemInfo redeemInfo = FinancingRedeemFactory.getLocalInstance((Context)ctx).getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(srcObjectId));
                BigDecimal recTotalAmount = redeemInfo.getRecTotalAmount().subtract(payAmount);
                String redeemSql = "update T_IVT_FinancingRedeem set FIsGeneGaterBill =0,FRecTotalAmount= ? where FID= ? ";
                DbUtil.execute((Context)ctx, (String)redeemSql, (Object[])new Object[]{recTotalAmount, srcObjectId});
                success.add(destObjectId);
                break;
            }
            case 60: {
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)recSql, (Object[])recParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("currency.precision");
                DiscountBillInfo discount = DiscountBillFactory.getLocalInstance((Context)ctx).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(srcObjectId), sic);
                int precision = discount.getCurrency().getPrecision();
                BigDecimal inTimeValue = discount.getBillAmount();
                BigDecimal discountRate = discount.getDiscountRate();
                BigDecimal convertDays = new BigDecimal(discount.getConvertDays());
                BigDecimal debitDays = new BigDecimal(discount.getDebitDays());
                IntRateTypeExpressionEnum intRateTypeExp = discount.getIntRateTypeExp();
                Date matDate = discount.getMaturityDate();
                Date discountDate = discount.getDiscountDate();
                if (inTimeValue != null && discountRate != null && matDate != null && discountDate != null && convertDays.intValue() != 0) {
                    BigDecimal dividend = Constants.ONE;
                    if (intRateTypeExp.equals((Object)IntRateTypeExpressionEnum.YEAR)) {
                        dividend = convertDays.multiply(Constants.ONE_HUNDRED);
                    } else if (intRateTypeExp.equals((Object)IntRateTypeExpressionEnum.MONTH)) {
                        dividend = convertDays.multiply(Constants.ONE_THOUSAND);
                    }
                    long datediff = DateUtil.dateDiff((String)"d", (Date)discountDate, (Date)matDate);
                    BigDecimal dateDiff = new BigDecimal(datediff).abs().add(debitDays);
                    BigDecimal discountInt = inTimeValue.multiply(discountRate).multiply(dateDiff).divide(dividend, precision, 4);
                    BigDecimal locDiscountInt = discountInt.multiply(discount.getExRate());
                    BigDecimal actRecvAmount = inTimeValue.subtract(discountInt);
                    BigDecimal locActRecvAmount = actRecvAmount.multiply(discount.getExRate());
                    String discountSql = "update T_NT_DiscountBill set FRpBillId=? ,FDISCOUNTINT=?,FACTDISCOUNTINT=?,FDISCOUNTLOCINT=?,FACTRECVAMOUNT=?,FACTRECVLOCAMOUNT=? where fid=?";
                    DbUtil.execute((Context)ctx, (String)discountSql, (Object[])new Object[]{null, discountInt, discountInt, locDiscountInt, actRecvAmount, locActRecvAmount, srcObjectId});
                } else {
                    String discountSql = "update T_NT_DiscountBill set FRpBillId=? where fid=?";
                    DbUtil.execute((Context)ctx, (String)discountSql, (Object[])new Object[]{null, srcObjectId});
                }
                success.add(destObjectId);
                break;
            }
            case 70: {
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)recSql, (Object[])recParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String FTISql = "update T_FT_FundTransferInterestBill set fisGatherBill=0 where fid=?";
                DbUtil.execute((Context)ctx, (String)FTISql, (Object[])new Object[]{srcObjectId});
                success.add(destObjectId);
                break;
            }
            case 80: {
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)recSql, (Object[])recParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String FCLSql = "update T_CL_ConsignLoanIntBill set FIsGenReceiving=0 where fid=?";
                DbUtil.execute((Context)ctx, (String)FCLSql, (Object[])new Object[]{srcObjectId});
                success.add(destObjectId);
                break;
            }
            case 90: {
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)recSql, (Object[])recParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String FAccSql = "update T_INT_AccrualBill set FIsGenReceiving=0 where fid=?";
                DbUtil.execute((Context)ctx, (String)FAccSql, (Object[])new Object[]{srcObjectId});
                success.add(destObjectId);
                break;
            }
            case 100: {
                iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
                DbUtil.execute((Context)ctx, (String)recSql, (Object[])recParams);
                DbUtil.execute((Context)ctx, (String)entrySql, (Object[])entryParams);
                DbUtil.execute((Context)ctx, (String)claimSql, (Object[])new Object[]{info.getId().toString()});
                String FTdIntSql = "update T_TD_IntReceivedBill set FIsGenReceiving=0 where fid=?";
                DbUtil.execute((Context)ctx, (String)FTdIntSql, (Object[])new Object[]{srcObjectId});
                success.add(destObjectId);
            }
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"antiAuditOne", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(recInfo.getId()), (String)recInfo.getNumber(), (String)"rpm_recClaim_antiAudit", (String)ctx.get((Object)"CurCompanyId").toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    private void UnWriteOffReceivableBill(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        ReceivableBillInfo recvBillInfo = null;
        info.setBillClaimStatus(BillClaimStatusEnum.SUBMIT);
        if (info.getSettlementType() != null && info.getSettlementType().getNtType() != null && info.getSettlementType().getNtType().getGroup() != null && NTTypeGroupEnum.RECEIVABLE.equals((Object)info.getSettlementType().getNtType().getSuperGroup()) && info.getSettlementNumber() != null && info.getSourceType() == SourceTypeEnum.CASH) {
            ReceivableBillCollection receivableBillCollection;
            String number = info.getSettlementNumber().replaceAll("\\s|\u3000", "");
            EntityViewInfo query = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            query.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)number));
            filter.getFilterItems().add(new FilterItemInfo("isWriteOff", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("billAmt", (Object)info.getActRecAmt()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)BillStateEnum.GATHERED));
            filter.getFilterItems().add(new FilterItemInfo("expiredDate", (Object)new Date(), CompareType.LESS_EQUALS));
            if (info.getCurrency() != null) {
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
            }
            if (info.getSettlementType().getNtType() != null) {
                filter.getFilterItems().add(new FilterItemInfo("ntType.id", (Object)info.getSettlementType().getNtType().getId().toString()));
            }
            if ((receivableBillCollection = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(query)) != null && receivableBillCollection.size() >= 1) {
                recvBillInfo = receivableBillCollection.get(0);
                recvBillInfo.setBillState(recvBillInfo.getBillLastState());
                recvBillInfo.setIsWriteOff(false);
                recvBillInfo.setTransferDate(null);
                recvBillInfo.setReceivingBillId(null);
                IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance((Context)ctx);
                iReceivableBill.update((IObjectPK)new ObjectUuidPK(recvBillInfo.getId().toString()), (CoreBaseInfo)recvBillInfo);
                if (EmptyUtil.isEmpty((String)recvBillInfo.getRpBillId())) {
                    info.getEntries().get(0).setSourceBillId(null);
                    ReceivingBillFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
                    String srcBosType = new ReceivableBillInfo().getBOSType().toString();
                    IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
                    iBOTRelation.removeRelationByDestObjId(info.getId().toString(), srcBosType);
                }
                recvBillInfo.setOprtLogDate(info.getBizDate());
                NTHelper.writOprtLog((Context)ctx, (IObjectValue)recvBillInfo, (String)recvBillInfo.getId().toString(), (OprtEnum)OprtEnum.SAVE, (OprtEnum)OprtEnum.RECEIVE);
            }
        }
    }
}

