/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ss.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ss.BusinessTypeFactory;
import com.kingdee.eas.fm.ss.ISmartSettleEntryBusiness;
import com.kingdee.eas.fm.ss.ISmartSettleEntryCompany;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessFactory;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.SmartSettleEntryCompanyFactory;
import com.kingdee.eas.fm.ss.SmartSettleEntryCompanyInfo;
import com.kingdee.eas.fm.ss.SmartSettleFacadeFactory;
import com.kingdee.eas.fm.ss.SmartSettleScheduleFactory;
import com.kingdee.eas.fm.ss.SmartSettleScheduleInfo;
import com.kingdee.eas.fm.ss.SmartSettleSchemaFactory;
import com.kingdee.eas.fm.ss.SmartSettleSchemaInfo;
import com.kingdee.eas.fm.ss.SystemEnum;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleSchemaControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SmartSettleSchemaControllerBean
extends AbstractSmartSettleSchemaControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ss.app.SmartSettleSchemaControllerBean");

    @Override
    protected String _startBackTask(Context ctx, String smartAccountingID) throws BOSException, EASBizException {
        String result = "";
        try {
            result = SmartSettleFacadeFactory.getLocalInstance(ctx).processBackTask(smartAccountingID);
        }
        catch (Exception e) {
            String string = "";
        }
        return result;
    }

    @Override
    protected String _stopBackTask(Context ctx, String smartSettleID) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Object[] _fetchInitData(Context ctx, Object[] param) throws BOSException, EASBizException {
        Object[] result = new Object[3];
        String module = null;
        Map map = null;
        if (!EmptyUtil.isEmpty((Object[])param)) {
            for (int i = 0; i < param.length; ++i) {
                map = (Map)param[i];
                if (!map.keySet().contains("module")) continue;
                module = (String)map.get("module");
            }
        }
        result[0] = this.getSubSystemList(ctx, module);
        result[1] = this.getBusinessTypeMap(ctx, module);
        result[2] = this.getOperatorTypeMap(ctx, module);
        return result;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SmartSettleSchemaInfo smartSettle = (SmartSettleSchemaInfo)model;
        return this._submitInternal(ctx, smartSettle);
    }

    protected void deleteAllCompanyEntries(Context ctx, String smartAccountID) throws BOSException, EASBizException {
        String sbSql = "delete from T_SS_SmartSettleEntryCompany where FSmartAccountingID = ?";
        Object[] params = new Object[]{smartAccountID};
        DbUtil.execute((Context)ctx, (String)sbSql, (Object[])params);
    }

    protected void deleteAllBusinessEntries(Context ctx, String smartAccountID) throws BOSException, EASBizException {
        String sbSql = "delete from T_SS_SmartSettleEntryBusiness where FSmartSettleID = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql);
            ps.setString(1, smartAccountID);
            sbSql = null;
            ps.executeUpdate();
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
    }

    protected IObjectPK _submitInternal(Context ctx, SmartSettleSchemaInfo smartAccounting) throws BOSException, EASBizException {
        ObjectUuidPK oldPK = new ObjectUuidPK(smartAccounting.getId());
        this.deleteAllCompanyEntries(ctx, oldPK.toString());
        this.deleteAllBusinessEntries(ctx, oldPK.toString());
        smartAccounting.put("name_" + ctx.getLocale(), smartAccounting.getName());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"deleteSchema", (BOSObjectType)smartAccounting.getBOSType(), (IObjectPK)new ObjectUuidPK(smartAccounting.getId()), (String)smartAccounting.getNumber(), (String)"fi_smartSettle", (String)ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString(), (String)"\u65b9\u6848\u4fdd\u5b58");
        IObjectPK smartAccountingPK = super._submit(ctx, (IObjectValue)smartAccounting);
        smartAccounting.put("id", smartAccountingPK.getKeyValue("id"));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        Iterator iteratorBusinessEntry = smartAccounting.getSmartAccountEntriesBusiness().iterator();
        Iterator iteratorCompanyEntry = smartAccounting.getSmartAccountEntriesCompany().iterator();
        ISmartSettleEntryBusiness iBusinessEntry = SmartSettleEntryBusinessFactory.getLocalInstance(ctx);
        ISmartSettleEntryCompany iCompanyEntry = SmartSettleEntryCompanyFactory.getLocalInstance(ctx);
        while (iteratorBusinessEntry.hasNext()) {
            SmartSettleEntryBusinessInfo business_entry = (SmartSettleEntryBusinessInfo)iteratorBusinessEntry.next();
            if (StringUtils.isEmpty((String)business_entry.getFilterSql()) && !StringUtils.isEmpty((String)business_entry.getFilter())) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ss.SmartAccountingResource", (String)"filterRuleError", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{business_entry.getSeq()})));
            }
            business_entry.setSmartSettle(smartAccounting);
            iBusinessEntry.submit((CoreBaseInfo)business_entry);
        }
        CoreBaseCollection smartSettleEntryCompanys = new CoreBaseCollection();
        while (iteratorCompanyEntry.hasNext()) {
            SmartSettleEntryCompanyInfo company_entry = (SmartSettleEntryCompanyInfo)iteratorCompanyEntry.next();
            company_entry.setSmartAccounting(smartAccounting);
            smartSettleEntryCompanys.add((CoreBaseInfo)company_entry);
        }
        if (smartSettleEntryCompanys != null && smartSettleEntryCompanys.size() > 0) {
            iCompanyEntry.submitBatchData(smartSettleEntryCompanys);
        }
        if (smartAccounting.getBackSchedule() != null) {
            String scheduleID = smartAccounting.getBackSchedule().getId().toString();
            String sbSql = "update t_ss_smartaccountschedule set fsmartaccountid = ? where fid = ?";
            SmartSettleScheduleInfo scheduleInfo = (SmartSettleScheduleInfo)SmartSettleScheduleFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(scheduleID));
            if (scheduleInfo.getSmartAccount() != null && scheduleInfo.getSmartAccount().getId() != null && smartAccounting != null && smartAccounting.getId() != null && scheduleInfo.getSmartAccount().getId().toString().equals(smartAccounting.getId().toString())) {
                scheduleInfo.put("smartAccount", smartAccounting.getId().toString());
                SmartSettleScheduleFactory.getLocalInstance(ctx).submit((CoreBaseInfo)scheduleInfo);
            } else {
                scheduleInfo.put("smartAccount", smartAccounting.getId().toString());
                scheduleInfo.setId(null);
                scheduleInfo.setJobDefID(null);
                IObjectPK scheduleInfoPK = SmartSettleScheduleFactory.getLocalInstance(ctx).addnew(scheduleInfo);
                smartAccounting = (SmartSettleSchemaInfo)SmartSettleSchemaFactory.getLocalInstance(ctx).getValue(smartAccountingPK);
                smartAccounting.setBackSchedule((SmartSettleScheduleInfo)SmartSettleScheduleFactory.getLocalInstance(ctx).getValue(scheduleInfoPK));
                super._submit(ctx, (IObjectValue)smartAccounting);
            }
        }
        return smartAccountingPK;
    }

    private Map getBusinessTypeMap(Context ctx, String module) throws BOSException, EASBizException {
        Map businessTypeM = BusinessTypeFactory.getLocalInstance(ctx).getBusinessTypeMap(module);
        return businessTypeM;
    }

    protected Map getOperatorTypeMap(Context ctx, String module) throws BOSException, EASBizException {
        HashMap operatorTypeMap = new HashMap();
        ArrayList operatorList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        Locale loc = ctx.getLocale();
        String locStr = loc.toString();
        String geneVoucher = EASResource.getString((String)"com.kingdee.eas.fi.vc.SmartAccountingResource", (String)"geneVoucher", (Locale)loc);
        sql.append(" select * from ( ");
        sql.append(" select fsubsystem,to_char(fnumber) fnumber,to_char(foperatorNumber) foperatorNumber,to_char(foperatorName_" + locStr + ") fname,fmodule,to_char(fdatafilterui) fdataFilterUI ,fseq  from t_ss_businesstype ");
        sql.append(" union all ");
        sql.append(" select fsubsystem,to_char(fbosobjecttype) fnumber ,to_char('scpz') foperatorNumber,to_char('" + geneVoucher + "') fname,fmodule,to_char('') fdataFilterUI,fseq from t_ss_billtype ) T  ");
        if (!EmptyUtil.isEmpty((String)module)) {
            sql.append(" where fmodule = ? ");
        }
        sql.append(" order by fsubsystem ,fseq asc");
        try {
            IRowSet rs = null;
            rs = !EmptyUtil.isEmpty((String)module) ? DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{module}) : DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String preNumber = null;
            String number = null;
            int preSubSystem = 0;
            int subSystem = 0;
            while (rs.next()) {
                number = rs.getString("fnumber");
                subSystem = rs.getInt("fsubsystem");
                if (preNumber == null && preSubSystem == 0) {
                    preNumber = number;
                    preSubSystem = subSystem;
                } else if (!preNumber.equals(number) || preSubSystem != subSystem) {
                    if (operatorTypeMap.containsKey(preSubSystem + preNumber)) {
                        ((List)operatorTypeMap.get(preSubSystem + preNumber)).addAll(operatorList);
                    } else {
                        operatorTypeMap.put(preSubSystem + preNumber, operatorList);
                    }
                    operatorList = new ArrayList();
                    preNumber = number;
                    preSubSystem = subSystem;
                }
                HashMap<String, String> opeMap = new HashMap<String, String>();
                String foperator = rs.getString("foperatorNumber");
                String fname = rs.getString("fname");
                String fdataFilterUI = rs.getString("fdataFilterUI");
                opeMap.put("number", foperator);
                opeMap.put("name", fname);
                opeMap.put("dataFilterUI", fdataFilterUI);
                operatorList.add(opeMap);
            }
            if (preNumber != null && preNumber.equals(number) && number != null && preSubSystem == subSystem && subSystem != 0) {
                if (operatorTypeMap.containsKey(preSubSystem + preNumber)) {
                    ((List)operatorTypeMap.get(preSubSystem + preNumber)).addAll(operatorList);
                } else {
                    operatorTypeMap.put(preSubSystem + preNumber, operatorList);
                }
                operatorList = new ArrayList();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return operatorTypeMap;
    }

    private List getSubSystemList(Context ctx, String module) throws BOSException, EASBizException {
        ArrayList<SystemEnum> result = new ArrayList<SystemEnum>();
        String sql = "select distinct t.FSubSystem from T_ss_SubSystem t ";
        if (!EmptyUtil.isEmpty((String)module)) {
            sql = sql + "where fmodule = ? ";
        }
        sql = sql + " order by FSubSystem asc ";
        try {
            IRowSet rs = null;
            rs = !EmptyUtil.isEmpty((String)module) ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{module}) : DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                int subSystemValue = rs.getInt("FSubSystem");
                if (SystemEnum.getEnum(subSystemValue) == null) continue;
                SystemEnum subSystemEnum = SystemEnum.getEnum(subSystemValue);
                result.add(subSystemEnum);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }
}

