/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.td.ITimeDepositBill;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;

public class TimeDepositBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        TimeDepositBillInfo timeDepositBill = this.getTimeDepositBillInfo(ctx, billId);
        if (!timeDepositBill.isIsHistoryBill()) {
            if (timeDepositBill.getBankDepAcct() != null) {
                JournalInfo dJournal = this.createDJournal(timeDepositBill);
                if (!FMHelper.checkIsBooked((Context)ctx, (String)timeDepositBill.getSourceBillId(), (BOSObjectType)new PaymentBillInfo().getBOSType(), (AccountBankInfo)dJournal.getAccountBank()) && dJournal.getAccountBank().isIsBank()) {
                    journalCollection.add(dJournal);
                }
            }
            if (timeDepositBill.getBankCurAcct() != null) {
                JournalInfo cJournal = this.createCjournal(timeDepositBill);
                if (!FMHelper.checkIsBooked((Context)ctx, (String)timeDepositBill.getSourceBillId(), (BOSObjectType)new PaymentBillInfo().getBOSType(), (AccountBankInfo)cJournal.getAccountBank()) && cJournal.getAccountBank().isIsBank()) {
                    journalCollection.add(cJournal);
                }
            }
        }
        return journalCollection;
    }

    private JournalInfo createCjournal(TimeDepositBillInfo timeDepositBill) {
        JournalInfo cJournal = this.createBaseJournal(timeDepositBill);
        cJournal.setAccountBank(timeDepositBill.getBankCurAcct());
        cJournal.setAccountView(timeDepositBill.getBankCurAcct().getAccount());
        if (!timeDepositBill.isIsAddedByReDeposit()) {
            cJournal.setCreditAmount(timeDepositBill.getDepositAmt());
        } else {
            cJournal.setCreditAmount(timeDepositBill.getDepositAmt().subtract(timeDepositBill.getAccrualToDepositAmt()));
        }
        return cJournal;
    }

    private JournalInfo createDJournal(TimeDepositBillInfo timeDepositBill) {
        JournalInfo dJournal = this.createBaseJournal(timeDepositBill);
        dJournal.setAccountBank(timeDepositBill.getBankDepAcct());
        dJournal.setAccountView(timeDepositBill.getBankDepAcct().getAccount());
        dJournal.setDebitAmount(timeDepositBill.getDepositAmt());
        return dJournal;
    }

    private JournalInfo createBaseJournal(TimeDepositBillInfo timeDepositBill) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setCurrency(timeDepositBill.getCurrency());
        journalInfo.setCreateDate(timeDepositBill.getBizDate());
        journalInfo.setBizDate(timeDepositBill.getBizDate());
        journalInfo.setDescription(timeDepositBill.getDescription());
        journalInfo.setCompany(timeDepositBill.getDepositCompany());
        journalInfo.setBillId(timeDepositBill.getId().toString());
        journalInfo.setBillNumber(timeDepositBill.getNumber());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillType(BillTypeEnum.TimeDepositBill);
        return journalInfo;
    }

    private TimeDepositBillInfo getTimeDepositBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        ITimeDepositBill iTimeDepositBill = null;
        iTimeDepositBill = ctx == null ? TimeDepositBillFactory.getRemoteInstance() : TimeDepositBillFactory.getLocalInstance(ctx);
        return iTimeDepositBill.getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("bankDepAcct.*");
        cel.add("bankDepAcct.account.id");
        cel.add("bankCurAcct.*");
        cel.add("bankCurAcct.account.id");
        return cel;
    }
}

