/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompIntReceivedBillCollection;
import com.kingdee.eas.fm.fin.CompIntReceivedBillFactory;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillInfo;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositBillCollection;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.UnTimeDepositBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;
import com.kingdee.eas.fm.td.app.UnDepositSeqInfo;
import com.kingdee.eas.fm.td.app.UnDepositSeqInfoList;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;

public class BillReceiverUtils {
    protected final String errorMsgHeader = EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"1_BillReceiverUtils");
    private static final Integer HAS_BEEN_RECEIVED = new Integer(1);
    private static final String NUMBER_SUFFIX = "-Received";

    protected void copyProperties(CoreBaseInfo desInfo, CoreBaseInfo srcInfo) {
        if (srcInfo instanceof CompDepositAccountBillInfo) {
            if (desInfo instanceof TimeDepositBillInfo) {
                this.copyPropertiesToTimeDepositBill((TimeDepositBillInfo)desInfo, (CompDepositAccountBillInfo)srcInfo);
            }
        } else if (srcInfo instanceof CompUnTimeDepositBillInfo) {
            if (desInfo instanceof UnTimeDepositBillInfo) {
                this.copyPropertiesToUnTimeDepositBill((UnTimeDepositBillInfo)desInfo, (CompUnTimeDepositBillInfo)srcInfo);
            }
        } else if (srcInfo instanceof CompIntReceivedBillInfo && desInfo instanceof IntReceivedBillInfo) {
            this.copyPropertiesToIntBill((IntReceivedBillInfo)desInfo, (CompIntReceivedBillInfo)srcInfo);
        }
    }

    private void copyPropertiesToIntBill(IntReceivedBillInfo desInfo, CompIntReceivedBillInfo srcInfo) {
        desInfo.setCompany(srcInfo.getDepCompany());
        desInfo.setIntReceiveType(srcInfo.getIntReceiveType());
        desInfo.setBank(srcInfo.getBank());
        desInfo.setBizDate(DateTimeUtils.truncateDate((Date)srcInfo.getBizDate()));
        desInfo.setCurrency(srcInfo.getCurrency());
        desInfo.setEffectiveDate(DateTimeUtils.truncateDate((Date)srcInfo.getEffectiveDate()));
        desInfo.setEndDate(DateTimeUtils.truncateDate((Date)srcInfo.getEndDate()));
        desInfo.setIntervalDays(srcInfo.getIntervalDays());
        desInfo.setIntRateTypeExpression(srcInfo.getIntRateTypeExpression());
        desInfo.setYearDays(srcInfo.getYearDays());
        desInfo.setDepositAmt(srcInfo.getDepositAmt());
        desInfo.setDepYearRate(srcInfo.getDepYearRate());
        desInfo.setDeInterest(srcInfo.getDeInterest());
        desInfo.setCreYearRate(srcInfo.getCreYearRate());
        desInfo.setCreInterest(srcInfo.getCreInterest());
        desInfo.setShijiAmt(srcInfo.getShijiAmt());
        desInfo.setYingjiAmt(srcInfo.getYingjiAmt());
        desInfo.setDigest(srcInfo.getDigest());
        desInfo.setIsAddedByReceive(true);
        desInfo.setComInterstBillID(srcInfo.getId());
        desInfo.setId(BOSUuid.create((BOSObjectType)desInfo.getBOSType()));
        desInfo.setNumber(srcInfo.getNumber() + NUMBER_SUFFIX);
    }

    private void copyPropertiesToUnTimeDepositBill(UnTimeDepositBillInfo desInfo, CompUnTimeDepositBillInfo srcInfo) {
        desInfo.setBizDate(srcInfo.getUntimeDate());
        desInfo.setIsCalInt(srcInfo.isIsCalInt());
        desInfo.setIsAppointRate(srcInfo.isIsAppointRate());
        desInfo.setYearRate(srcInfo.getYearRate());
        desInfo.setUnDepositType(srcInfo.getUnDepositType());
        desInfo.setBank(srcInfo.getBank());
        desInfo.setCompany(srcInfo.getDepCompany());
        desInfo.setUnTimeDepositSeqNo(srcInfo.getUnTimeDepositSeqNo());
        desInfo.setCurrency(srcInfo.getCurrency());
        desInfo.setExchangeRate(srcInfo.getExchangeRate());
        desInfo.setUnDepositAmt(srcInfo.getUnDepositAmt());
        desInfo.setAccumulativeUnTimeDepostAmt(srcInfo.getAccumulativeUnTimeDepostAmt());
        desInfo.setHandler(srcInfo.getHandler());
        desInfo.setDescription(srcInfo.getDescription());
        desInfo.setIsAddedByReceive(true);
        desInfo.setComUnDepositBillID(srcInfo.getId());
        desInfo.setId(BOSUuid.create((BOSObjectType)desInfo.getBOSType()));
        desInfo.setNumber(srcInfo.getNumber() + NUMBER_SUFFIX);
    }

    private void copyPropertiesToTimeDepositBill(TimeDepositBillInfo desInfo, CompDepositAccountBillInfo srcInfo) {
        desInfo.setCompany(srcInfo.getDepCompany());
        desInfo.setDepositCompany(srcInfo.getDepCompany());
        desInfo.setDepositBank(srcInfo.getDepositBank());
        desInfo.setBizDate(srcInfo.getBizDate());
        desInfo.setCertificateNo(srcInfo.getCertificateNo());
        desInfo.setTimeDepositType(srcInfo.getDepositType());
        desInfo.setIsAccrualToDepositAmt(srcInfo.isIsAccrualToDepositAmt());
        if (srcInfo.isIsAccrualToDepositAmt()) {
            desInfo.setAccrualToDepositAmt(srcInfo.getAccrualToDepositAmt());
        } else {
            desInfo.setAccrualToDepositAmt(Constants.ZERO);
        }
        desInfo.setEffectiveDate(DateTimeUtils.truncateDate((Date)srcInfo.getEffectiveDate()));
        desInfo.setIntTerm(srcInfo.getInterm());
        desInfo.setMaturityDay(DateTimeUtils.truncateDate((Date)srcInfo.getMaturityDay()));
        desInfo.setIntRateTable(srcInfo.getIntRateTable());
        desInfo.setFloating(srcInfo.getBasePoints());
        desInfo.setYearRate(srcInfo.getRate());
        desInfo.setCurYearRate(srcInfo.getCurRate());
        desInfo.setIntRateTypeExpression(srcInfo.getIntRateTypeExpression());
        desInfo.setYearDays(srcInfo.getYearDays());
        desInfo.setCurrency(srcInfo.getCurrency());
        desInfo.setExchangeRate(srcInfo.getExchangeRate());
        desInfo.setDepositAmt(srcInfo.getAmount());
        desInfo.setDepositLocalAmt(srcInfo.getNaturalAmt());
        desInfo.setFloorAmt(srcInfo.getIntFreeAmt());
        desInfo.setMatureIntAmtIntending(srcInfo.getExpireIn());
        desInfo.setHandler(srcInfo.getHandler());
        desInfo.setDescription(srcInfo.getDigest());
        desInfo.setDepositLocalAmt(srcInfo.getNaturalAmt());
        desInfo.setIsAccrualToDepositAmt(srcInfo.isIsAccrualToDepositAmt());
        desInfo.setIsHistoryBill(srcInfo.isIsHistory());
        if (desInfo.isIsHistoryBill()) {
            desInfo.setBalance(srcInfo.getInitBalanceOfHistoryBill());
        } else {
            desInfo.setBalance(desInfo.getDepositAmt());
        }
        if (desInfo.isIsHistoryBill()) {
            desInfo.setInitBalanceOfHistoryBill(srcInfo.getInitBalanceOfHistoryBill());
        } else {
            desInfo.setInitBalanceOfHistoryBill(desInfo.getDepositLocalAmt());
        }
        desInfo.setIsAddedByReceive(true);
        desInfo.setComDepositBillID(srcInfo.getId());
        desInfo.setId(BOSUuid.create((BOSObjectType)desInfo.getBOSType()));
        desInfo.setNumber(srcInfo.getNumber() + NUMBER_SUFFIX);
        if (srcInfo.getDepType() != null) {
            desInfo.setDepType(srcInfo.getDepType());
        }
    }

    protected void doReceive(Context ctx, CoreBaseInfo info, UnTimeDepositBillInfo utdbi, CompIntReceivedBillInfo compIntReceivedBillInfo, CoreBaseInfo compInfo) throws EASBizException, BOSException {
        if (compIntReceivedBillInfo == null) {
            UnTimeDepositBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)utdbi);
            this.updateStatus(ctx, compIntReceivedBillInfo, compInfo);
        } else {
            if (info instanceof IntReceivedBillInfo) {
                IntReceivedBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)((IntReceivedBillInfo)info));
            } else if (info instanceof TimeDepositBillInfo) {
                TimeDepositBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)((TimeDepositBillInfo)info));
            } else {
                throw new TDException(TDException.RECEIVE_UNKNWON_BILLTYPE);
            }
            this.updateStatus(ctx, compIntReceivedBillInfo, compInfo);
        }
    }

    protected CompIntReceivedBillInfo getComIntReceivedBillInfoBySrcID(Context ctx, String srcBillID) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("timeDepositBillID.id", (Object)srcBillID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("intReceiveType", (Object)"2", CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        CompIntReceivedBillCollection col = CompIntReceivedBillFactory.getLocalInstance((Context)ctx).getCompIntReceivedBillCollection(evi);
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    protected TimeDepositBillInfo getTimeDepositBill(Context ctx, CompDepositAccountBillInfo info) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("comDepositBillID", (Object)info.getId().toString(), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        TimeDepositBillCollection col = TimeDepositBillFactory.getLocalInstance(ctx).getTimeDepositBillCollection(evi);
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    protected UnDepositSeqInfoList getMaxReceivedUnTimeDePosit(Context ctx, Set ids) throws BOSException {
        UnDepositSeqInfoList li = new UnDepositSeqInfoList();
        StringBuffer sql = new StringBuffer();
        sql.append(" select untd.fid, td.fid,");
        sql.append(" (select max(FUnTimeDepositSeqNo) from T_FIN_UnTimeDepositBill  ");
        sql.append("where FTimeDepositBillID = untd.FTimeDepositBillID) ");
        sql.append("from T_FIN_CompDepositAccountBill as td,T_FIN_UnTimeDepositBill as untd  ");
        sql.append("where td.fid = untd.ftimedepositbillid ");
        sql.append(" and untd.fid in ").append(this.getValues(ids.toArray(new String[ids.size()])));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        UnDepositSeqInfo info = null;
        try {
            while (rs.next()) {
                info = new UnDepositSeqInfo(rs.getString(1), rs.getString(2), rs.getInt(3));
                li.add(info);
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return li;
    }

    private String getValues(String[] currencyIDs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < currencyIDs.length; ++i) {
            sb.append("'").append(currencyIDs[i]).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ")";
    }

    protected void setOriginalTimeDepositBill(Context ctx, CoreBaseInfo tdbi, IntReceivedBillInfo intBillInfo, String sourceID) throws BOSException, EASBizException {
        String sql = "select fid from t_td_timedepositbill where fcomdepositbillid = ?".intern();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{sourceID});
        String id = null;
        try {
            if (rs.next()) {
                id = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new TDException(TDException.RECEIVE_ERROR_REDE);
        }
        if (id == null || id.trim().length() == 0) {
            if (null != FMHelper.checkIsExistsTimeDeposit((Context)ctx, (String)sourceID)) {
                id = FMHelper.checkIsExistsTimeDeposit((Context)ctx, (String)sourceID);
            } else {
                throw new TDException(TDException.RECEIVE_ERROR_REDE);
            }
        }
        TimeDepositBillInfo info = new TimeDepositBillInfo();
        info.setId(BOSUuid.read((String)id));
        intBillInfo.setTimeDepositBillID(info);
        if (tdbi instanceof TimeDepositBillInfo) {
            ((TimeDepositBillInfo)tdbi).setSourceBillId(id);
            intBillInfo.setTimeDepositBillInfo((TimeDepositBillInfo)tdbi);
            intBillInfo.setSrcBillID(((TimeDepositBillInfo)tdbi).getId().toString());
        } else if (tdbi instanceof UnTimeDepositBillInfo) {
            ((UnTimeDepositBillInfo)tdbi).setTimeDepositBill(info);
            intBillInfo.setUnTimeDepositBillInfo((UnTimeDepositBillInfo)tdbi);
            intBillInfo.setSrcBillID(((UnTimeDepositBillInfo)tdbi).getId().toString());
        }
    }

    protected void updateStatus(Context ctx, CompIntReceivedBillInfo compIntReceivedBillInfo, CoreBaseInfo comp) throws BOSException {
        Object[] params = null;
        if (comp instanceof CompDepositAccountBillInfo) {
            String sql = " update t_fin_compdepositaccountbill set FIsreceived = ? where fid =? ";
            params = new Object[]{HAS_BEEN_RECEIVED, ((CompDepositAccountBillInfo)comp).getId().toString()};
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
            if (compIntReceivedBillInfo != null && compIntReceivedBillInfo.getId() != null) {
                sql = " update t_fin_compintreceivedbill set FIsreceived = ? where fid  = ? ";
                params = new Object[]{HAS_BEEN_RECEIVED, compIntReceivedBillInfo.getId().toString()};
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
            }
        } else if (comp instanceof CompUnTimeDepositBillInfo) {
            String sql = " update T_FIN_UnTimeDepositBill set FIsreceived = ? where fid =? ";
            params = new Object[]{HAS_BEEN_RECEIVED, ((CompUnTimeDepositBillInfo)comp).getId().toString()};
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
            if (compIntReceivedBillInfo != null) {
                sql = " update t_fin_compintreceivedbill set FIsreceived = ? where fid  = ?";
                params = new Object[]{HAS_BEEN_RECEIVED, compIntReceivedBillInfo.getId().toString()};
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
            }
        }
    }
}

