/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.fin.CompDepositAccountBillCollection;
import com.kingdee.eas.fm.fin.CompDepositAccountBillFactory;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompDepositBillStatusEnum;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositBillCollection;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.app.BillReceiverUtils;
import com.kingdee.eas.fm.td.app.IBillReceive;
import com.kingdee.eas.fm.td.app.ReceiveTestUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DepositBillReceiver
extends BillReceiverUtils
implements IBillReceive {
    private static DepositBillReceiver dbr = null;

    private DepositBillReceiver() {
    }

    public static DepositBillReceiver getInstance() {
        if (dbr == null) {
            dbr = new DepositBillReceiver();
        }
        return dbr;
    }

    @Override
    public Map receive(Context ctx, Set ids, AccountBankInfo acctBank) throws BOSException, EASBizException {
        StringBuffer errMsgBody = new StringBuffer();
        HashSet<String> receivedBill = new HashSet<String>();
        CompDepositAccountBillCollection col = this.getCompDepositToBeReceived(ctx, ids);
        HashSet<String> receivedDepositBillID = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            CompDepositAccountBillInfo comp = col.get(i);
            receivedBill.add(this.receive(ctx, comp));
            receivedDepositBillID.add(comp.getId().toString());
        }
        HashMap<String, Serializable> mapReturn = new HashMap<String, Serializable>();
        mapReturn.put("receivedBillId", receivedBill);
        mapReturn.put("errorMsg", errMsgBody);
        return mapReturn;
    }

    private String receive(Context ctx, CompDepositAccountBillInfo comp) throws BOSException, EASBizException {
        TimeDepositBillInfo tdbi = new TimeDepositBillInfo();
        if (comp.isIsReDeposited()) {
            this.checkSourceBillReceived(ctx, comp);
            this.setValueForTimeDepositBill(ctx, comp, tdbi);
            tdbi.setIsAddedByReDeposit(true);
            CompIntReceivedBillInfo compIntReceivedBillInfo = this.getComIntReceivedBillInfoBySrcID(ctx, comp.getSourceBillId().toString());
            if (compIntReceivedBillInfo == null) {
                return "";
            }
            if (compIntReceivedBillInfo.getEffectedStatus() != CompDepositBillStatusEnum.ACCEPTED) {
                throw new TDException(TDException.INTBILLUNACCEPT);
            }
            AccountBankInfo accountBankInfo = FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)compIntReceivedBillInfo.getCorpCurAcct());
            if (accountBankInfo == null) {
                throw new TDException(TDException.RECEIVE_ERROR_NO_BANKACCOUNT);
            }
            IntReceivedBillInfo intBillInfo = new IntReceivedBillInfo();
            this.copyProperties((CoreBaseInfo)intBillInfo, (CoreBaseInfo)compIntReceivedBillInfo);
            this.setOtherValueForTimeDeposit(tdbi, true);
            this.setOriginalTimeDepositBill(ctx, (CoreBaseInfo)tdbi, intBillInfo, comp.getSourceBillId());
            intBillInfo.setCorpCurAcct(accountBankInfo);
            this.doReceive(ctx, (CoreBaseInfo)intBillInfo, null, compIntReceivedBillInfo, (CoreBaseInfo)comp);
        } else {
            if (comp.getCorpCurAcct() == null && (comp.getDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || comp.getDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) ? FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)comp.getCorpDepAcct()) == null : FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)comp.getCorpDepAcct()) == null || FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)comp.getCorpCurAcct()) == null) {
                throw new TDException(TDException.RECEIVE_ERROR_NO_BANKACCOUNT);
            }
            this.setValueForTimeDepositBill(ctx, comp, tdbi);
            CompIntReceivedBillInfo ci = new CompIntReceivedBillInfo();
            ci.setNumber("noIntBillExisted");
            this.doReceive(ctx, (CoreBaseInfo)tdbi, null, ci, (CoreBaseInfo)comp);
        }
        HashMap<String, String> idMap = new HashMap<String, String>();
        idMap.put(comp.getId().toString(), tdbi.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, idMap);
        return tdbi.getId().toString();
    }

    private void setValueForTimeDepositBill(Context ctx, CompDepositAccountBillInfo comp, TimeDepositBillInfo tdbi) throws BOSException {
        this.copyProperties((CoreBaseInfo)tdbi, (CoreBaseInfo)comp);
        this.setBankCurAcct(ctx, comp, tdbi);
        this.setOtherValueForTimeDeposit(tdbi, false);
    }

    private void setBankCurAcct(Context ctx, CompDepositAccountBillInfo comp, TimeDepositBillInfo tdbi) throws BOSException {
        tdbi.setBankDepAcct(this.getBankAccountByInnerAccount(ctx, comp.getCorpDepAcct()));
        tdbi.setBankCurAcct(this.getBankAccountByInnerAccount(ctx, comp.getCorpCurAcct()));
    }

    private void checkSourceBillReceived(Context ctx, CompDepositAccountBillInfo comp) throws BOSException, EASBizException {
        String sourceid = comp.getSourceBillId();
        if (sourceid == null) {
            throw new TDException(TDException.RECEIVE_ERROR_REDE);
        }
        String sql = "select fisreceived from t_fin_compdepositaccountbill  where fid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{sourceid});
        try {
            int isreceived;
            if (rs.next() && (isreceived = rs.getInt(1)) == 0) {
                throw new TDException(TDException.RECEIVE_ERROR_REDE);
            }
        }
        catch (SQLException e) {
            throw new TDException(TDException.RECEIVE_ERROR_REDE);
        }
        if (FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)comp.getCorpDepAcct()) == null || FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)comp.getCorpCurAcct()) == null) {
            throw new TDException(TDException.RECEIVE_ERROR_NO_BANKACCOUNT);
        }
        sql = "select fisreceived from T_FIN_UnTimeDepositBill where FTimeDepositBillID = ? ";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{sourceid});
        try {
            while (rs1.next()) {
                int fisreceived = rs1.getInt(1);
                if (fisreceived != 0) continue;
                throw new TDException(TDException.RECEIVE_ERROR5);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private AccountBankInfo getBankAccountByInnerAccount(Context ctx, InnerAccountInfo innerAccount) throws BOSException {
        return FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)innerAccount);
    }

    private void setOtherValueForTimeDeposit(TimeDepositBillInfo tdbi, boolean isAddedByReDeposit) {
        tdbi.setIsAddedByReDeposit(isAddedByReDeposit);
    }

    private CompDepositAccountBillCollection getCompDepositToBeReceived(Context ctx, Set ids) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return CompDepositAccountBillFactory.getLocalInstance((Context)ctx).getCompDepositAccountBillCollection(evi);
    }

    @Override
    public Map receiveTest(Context ctx, Set ids) throws BOSException, EASBizException {
        StringBuffer errMsgBody = new StringBuffer();
        HashSet<String> receivedBill = new HashSet<String>();
        TimeDepositBillCollection col = ReceiveTestUtil.getCompDepositToBeReceived(ctx, ids);
        for (int i = 0; i < col.size(); ++i) {
            TimeDepositBillInfo comp = col.get(i);
            try {
                receivedBill.add(this.receiveTest(ctx, comp));
                continue;
            }
            catch (Exception e) {
                e.getCause().printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        HashMap<String, Serializable> mapReturn = new HashMap<String, Serializable>();
        mapReturn.put("receivedBillId", receivedBill);
        mapReturn.put("errorMsg", errMsgBody);
        return mapReturn;
    }

    private String receiveTest(Context ctx, TimeDepositBillInfo comp) throws BOSException, EASBizException {
        TimeDepositBillInfo tdbi = new TimeDepositBillInfo();
        ReceiveTestUtil.copyProperties((CoreBaseInfo)tdbi, (CoreBaseInfo)comp);
        if (comp.isIsAddedByReDeposit()) {
            IntReceivedBillInfo compIntReceivedBillInfo = ReceiveTestUtil.getComIntReceivedBillInfoBySrcID(ctx, comp.getId().toString());
            if (compIntReceivedBillInfo == null) {
                return "";
            }
            IntReceivedBillInfo intBillInfo = new IntReceivedBillInfo();
            ReceiveTestUtil.copyProperties((CoreBaseInfo)intBillInfo, (CoreBaseInfo)compIntReceivedBillInfo);
            ReceiveTestUtil.setOtherValueForTimeDeposit(tdbi);
            ReceiveTestUtil.setOtherValueForIntBill(intBillInfo, tdbi);
            String sql = "select fid from t_td_timedepositbill where fcomdepositbillid = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{tdbi.getSourceBillId()});
            String id = null;
            try {
                if (rs.next()) {
                    id = rs.getString(1);
                }
            }
            catch (SQLException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            TimeDepositBillInfo info = new TimeDepositBillInfo();
            info.setId(BOSUuid.read((String)id));
            intBillInfo.setTimeDepositBillID(info);
            intBillInfo.getTimeDepositBillInfo().setSourceBillId(id);
            IntReceivedBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)intBillInfo);
        } else {
            tdbi.setId(BOSUuid.create((BOSObjectType)tdbi.getBOSType()));
            TimeDepositBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)tdbi).toString();
        }
        return tdbi.getId().toString();
    }
}

