/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.td.IUnTimeDepositBill;
import com.kingdee.eas.fm.td.IntReceiveHelper;
import com.kingdee.eas.fm.td.IntReceivedBillCollection;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.IntReceivedStatusEnum;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositBillCollection;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.TimeDepositHelper;
import com.kingdee.eas.fm.td.UnTimeDepositBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;
import com.kingdee.eas.fm.td.app.AbstractIntReceivedBillControllerBean;
import com.kingdee.eas.fm.td.app.IntReceiveBillBookNotifyBuilder;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IntReceivedBillControllerBean
extends AbstractIntReceivedBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.td.app.IntReceivedBillControllerBean");
    private final Integer HAS_BEEN_RECEIVED = new Integer(1);
    private final Integer HAS_NOT_BEEN_RECEIVED = new Integer(0);
    private static Map botpRelationShip = new HashMap();
    private boolean deleteRelated = false;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        IntReceivedBillInfo info = (IntReceivedBillInfo)model;
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"2_IntReceivedBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new IntReceivedBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"td_int_add");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return super._addnew(ctx, model);
    }

    protected void antiBook(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        facade.antiBook(pk.toString());
        String sql = "update t_td_intreceivedbill set FIsBooked = 0 where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean intChanged = false;
        IntReceivedBillInfo modelInfo = (IntReceivedBillInfo)model;
        if (modelInfo.getId() != null && this.exists(ctx, (IObjectPK)new ObjectUuidPK(modelInfo.getId().toString()))) {
            IntReceivedBillInfo infoBeforeSubmit = this.getIntReceivedBillInfo(ctx, (IObjectPK)new ObjectUuidPK(modelInfo.getId().toString()));
            intChanged = modelInfo.getShijiAmt().compareTo(infoBeforeSubmit.getShijiAmt()) != 0;
        }
        IObjectPK pkReturn = super._submit(ctx, model);
        IntReceivedBillInfo infoInt = (IntReceivedBillInfo)model;
        if (infoInt.getTimeDepositBillInfo() != null || infoInt.getUnTimeDepositBillInfo() != null) {
            if (infoInt.getIntReceiveType() != IntReceivedBillTypeEnum.PRE_DRAWING) {
                this.afterSubmit(ctx, infoInt, pkReturn);
            }
        } else {
            ArrayList unTimeIDList = BOTRelationFactory.getLocalInstance((Context)ctx).getSrcObjIdBySrcType(pkReturn.toString(), "2AC24016");
            if (!EmptyUtil.isEmpty((Collection)unTimeIDList) && intChanged) {
                String unTimeId = (String)unTimeIDList.get(0);
                IUnTimeDepositBill iUnTimeBill = UnTimeDepositBillFactory.getLocalInstance(ctx);
                UnTimeDepositBillInfo unTimeBill = iUnTimeBill.getUnTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(unTimeId));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("intDeAmt"));
                sic.add(new SelectorItemInfo("intCurAmt"));
                sic.add(new SelectorItemInfo("intSum"));
                unTimeBill.setIntDeAmt(infoInt.getDeInterest());
                unTimeBill.setIntCurAmt(infoInt.getCreInterest());
                unTimeBill.setIntSum(infoInt.getDeInterest().add(infoInt.getCreInterest()));
                UnTimeDepositBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)unTimeBill, sic);
            }
            if (this.needBook(ctx, infoInt.getCompany().getId().toString()) && intChanged) {
                if (infoInt.isIsBooked()) {
                    IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
                    facade.antiBook(pkReturn.toString());
                }
                if (infoInt.getShijiAmt().compareTo(Constants.ZERO) != 0) {
                    this.doBook(ctx, pkReturn);
                }
            }
        }
        return pkReturn;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pkReturn = super._save(ctx, model);
        IntReceivedBillInfo infoInt = (IntReceivedBillInfo)model;
        this.afterSave(ctx, infoInt, pkReturn);
        return pkReturn;
    }

    private void afterSave(Context ctx, IntReceivedBillInfo infoInt, IObjectPK pk) throws EASBizException, BOSException {
        String addNewType = infoInt.getIntReceiveType().getValue();
        if (addNewType.equals("0")) {
            this.additionalProcess(addNewType, infoInt, (CoreBaseInfo)infoInt.getTimeDepositBillInfo(), ctx, pk);
        }
    }

    private void afterSubmit(Context ctx, IntReceivedBillInfo infoInt, IObjectPK pk) throws EASBizException, BOSException {
        String addNewType = infoInt.getIntReceiveType().getValue();
        if (addNewType.equals("1")) {
            this.additionalProcess(addNewType, infoInt, (CoreBaseInfo)infoInt.getUnTimeDepositBillInfo(), ctx, pk);
        } else if (addNewType.equals("2")) {
            this.additionalProcess(addNewType, infoInt, (CoreBaseInfo)infoInt.getTimeDepositBillInfo(), ctx, pk);
        }
        if (infoInt.isIsAddedByReceive()) {
            // empty if block
        }
    }

    private void additionalProcess(String addType, IntReceivedBillInfo info, CoreBaseInfo utDBillInfo, Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (addType.equals("0")) {
            this.reverseToTimeDepositBill(info, ctx);
            this.saveBOTPRelationShip(ctx, pk, info.getTimeDepositBillID());
            this.reverseIsPreDraw(ctx, info.getTimeDepositBillID());
        } else if (addType.equals("2")) {
            TimeDepositBillInfo timeDepositBillInfo = (TimeDepositBillInfo)utDBillInfo;
            int val = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS001", (IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getCompany().getId()));
            boolean valTD008 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TD008", (IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getCompany().getId()));
            if (!timeDepositBillInfo.isIsAccrualToDepositAmt() && val == 0 && valTD008) {
                this.book(ctx, pk, info);
            }
            this.addTimeDepositBill(ctx, timeDepositBillInfo, info);
            this.saveBOTPRelationShip(ctx, pk, info.getTimeDepositBillID());
            this.doBizOperation(ctx, info, addType);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"3_IntReceivedBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new TimeDepositBillInfo().getBOSType(), null, (String)timeDepositBillInfo.getNumber(), (String)"td_rede");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        } else if (addType.equals("1")) {
            UnTimeDepositBillInfo unTimeDepositBillInfo = (UnTimeDepositBillInfo)utDBillInfo;
            int val = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS001", (IObjectPK)new ObjectUuidPK(unTimeDepositBillInfo.getCompany().getId()));
            boolean valTD008 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TD008", (IObjectPK)new ObjectUuidPK(unTimeDepositBillInfo.getCompany().getId()));
            if (val == 0 && valTD008) {
                this.book(ctx, pk, info);
            }
            this.addUnDepositBill(ctx, info, unTimeDepositBillInfo, pk);
            this.saveBOTPRelationShip(ctx, pk, info.getTimeDepositBillID());
            this.doBizOperation(ctx, info, addType);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"4_IntReceivedBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new UnTimeDepositBillInfo().getBOSType(), null, (String)unTimeDepositBillInfo.getNumber(), (String)"td_unde");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
    }

    private boolean needBook(Context ctx, String companyId) {
        int val = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS001", (IObjectPK)new ObjectUuidPK(companyId));
        boolean valTD008 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TD008", (IObjectPK)new ObjectUuidPK(companyId));
        return val == 0 && valTD008;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            IntReceivedBillInfo info = (IntReceivedBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private void reverseIsPreDraw(Context ctx, TimeDepositBillInfo info) throws BOSException {
        String sql = "update t_td_timedepositbill set FIsPreDraw = ? where fid=?".intern();
        Object[] params = new Object[]{new Integer(1), info.getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void addUnDepositBill(Context ctx, IntReceivedBillInfo info, UnTimeDepositBillInfo unTimeDepositBillInfo, IObjectPK pk) throws BOSException, EASBizException {
        unTimeDepositBillInfo.setIntDeAmt(info.getDeInterest());
        unTimeDepositBillInfo.setIntCurAmt(info.getCreInterest());
        unTimeDepositBillInfo.setIntSum(unTimeDepositBillInfo.getIntDeAmt().add(unTimeDepositBillInfo.getIntCurAmt()));
        IObjectPK unTimeBillId = UnTimeDepositBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)unTimeDepositBillInfo);
        FinUtils.addBotRelation((Context)ctx, (String)unTimeBillId.toString(), (String)pk.toString());
    }

    private void doBizOperation(Context ctx, IntReceivedBillInfo curIntRinfo, String addType) throws BOSException, EASBizException {
        TimeDepositBillInfo timeDepositBillInfo = TimeDepositBillFactory.getLocalInstance(ctx).getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(curIntRinfo.getTimeDepositBillID().getId().toString()));
        if (timeDepositBillInfo.getBalance().compareTo(Constants.ZERO) > 0) {
            return;
        }
        String sqlUpdate2 = "update T_TD_IntReceivedBill set FYichongxiaoAmt =  (select isnull(sum(fshijiamt),0) from T_TD_IntReceivedBill where FEndDate <=? and FIntReceiveType ='0' and FTimeDepositBillIDID =? and FIsChongzhang=0) where fid = ?".intern();
        Object[] params2 = new Object[]{new Date(curIntRinfo.getEndDate().getTime()), curIntRinfo.getTimeDepositBillID().getId().toString(), curIntRinfo.getId().toString()};
        DbUtil.execute((Context)ctx, (String)sqlUpdate2, (Object[])params2);
        String sqlUpdate1 = "update T_TD_IntReceivedBill set FIsChongzhang =1, FStrikedBy = ? where  FEndDate <=? and FIntReceiveType ='0' and FTimeDepositBillIDID =? " + "and FIsChongzhang=0".intern();
        Object[] params1 = new Object[]{curIntRinfo.getId().toString(), new Date(curIntRinfo.getEndDate().getTime()), curIntRinfo.getTimeDepositBillID().getId().toString()};
        DbUtil.execute((Context)ctx, (String)sqlUpdate1, (Object[])params1);
    }

    private void saveBOTPRelationShip(Context ctx, IObjectPK pk, TimeDepositBillInfo timeDepositBillID) throws BOSException {
        botpRelationShip.clear();
        botpRelationShip.put(timeDepositBillID.getId().toString(), pk.toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)botpRelationShip);
    }

    private void book(Context ctx, IObjectPK pk, IntReceivedBillInfo info) throws BOSException, EASBizException {
        if (info.getShijiAmt().compareTo(Constants.ZERO) != 0 && !info.isIsBooked()) {
            this.doBook(ctx, pk);
        }
    }

    protected void doBook(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        facade.book(IntReceiveBillBookNotifyBuilder.class.getName(), pk.toString());
        String sql = "update t_td_intreceivedbill set FIsBooked = 1 where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
    }

    private void addTimeDepositBill(Context ctx, TimeDepositBillInfo timeDepositBillInfo, IntReceivedBillInfo info) throws BOSException, EASBizException {
        BigDecimal billDepsositAmt = timeDepositBillInfo.getDepositAmt();
        if (timeDepositBillInfo.isIsAccrualToDepositAmt()) {
            if (!timeDepositBillInfo.isIsAddedByReceive()) {
                timeDepositBillInfo.setDepositAmt(timeDepositBillInfo.getDepositAmt().add(info.getShijiAmt()));
            }
            timeDepositBillInfo.setDepositLocalAmt(timeDepositBillInfo.getDepositAmt().multiply(timeDepositBillInfo.getExchangeRate()));
            timeDepositBillInfo.setBalance(timeDepositBillInfo.getDepositAmt());
            timeDepositBillInfo.setAccrualToDepositAmt(info.getShijiAmt());
            if (timeDepositBillInfo.isIsHistoryBill()) {
                timeDepositBillInfo.setInitBalanceOfHistoryBill(timeDepositBillInfo.getBalance());
            } else {
                timeDepositBillInfo.setInitBalanceOfHistoryBill(timeDepositBillInfo.getDepositAmt());
            }
        }
        if (!timeDepositBillInfo.isIsAddedByReceive()) {
            this.checkNowDBBalance(ctx, timeDepositBillInfo.getSourceBillId(), billDepsositAmt);
        }
        TimeDepositBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)timeDepositBillInfo);
    }

    private void checkNowDBBalance(Context ctx, String sourceID, BigDecimal billDepsositAmt) throws EASBizException, BOSException {
        TimeDepositBillInfo sourceInfo = TimeDepositBillFactory.getLocalInstance(ctx).getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(sourceID));
        BigDecimal balanceNow = sourceInfo.getBalance();
        if (balanceNow.compareTo(billDepsositAmt) != 0) {
            throw new TDException(TDException.REDEPOSIT_ERROR1);
        }
    }

    private void reverseToTimeDepositBill(IntReceivedBillInfo info, Context ctx) throws BOSException, EASBizException {
        String sql = "update t_td_timedepositbill set flastrecvintday = ? where fid = ?";
        java.util.Date intBillEndDate = DateUtil.getAfterDay((java.util.Date)info.getEndDate());
        Object[] params = new Object[]{new Date(intBillEndDate.getTime()), info.getTimeDepositBillID().getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected Set _addBatch(Context ctx, Set ids, java.util.Date date) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        TimeDepositBillInfo timeDepositBillInfo = null;
        IntReceivedBillInfo intReceivedBillInfo = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        TimeDepositBillCollection tdbc = this.getTimeDepositBillCollection(ctx, ids);
        for (int i = 0; i < tdbc.size(); ++i) {
            timeDepositBillInfo = tdbc.get(i);
            intReceivedBillInfo = new IntReceivedBillInfo();
            intReceivedBillInfo = IntReceiveHelper.getInstance().createIntReceiveBillToBeSaved(ctx, intReceivedBillInfo, timeDepositBillInfo, date);
            createdIntReceivedID.add(this.save(ctx, (CoreBaseInfo)intReceivedBillInfo));
            sb.append(intReceivedBillInfo.getNumber()).append(" | ");
        }
        return createdIntReceivedID;
    }

    protected TimeDepositBillCollection getTimeDepositBillCollection(Context ctx, Set ids) throws BOSException {
        String includeValue = this.parseValue(ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("intTerm.*"));
        return TimeDepositBillFactory.getLocalInstance(ctx).getTimeDepositBillCollection(evi);
    }

    private String parseValue(Set setIDs) {
        return TimeDepositHelper.getInstance().parseValue(setIDs);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IntReceivedBillInfo info = this.getIntReceivedBillInfo(ctx, pk);
        this.deleteCheck(ctx, info);
        this.antiBook(ctx, pk);
        java.util.Date lastIntDate = info.getLastIntDate();
        Date dp = null;
        if (lastIntDate != null) {
            dp = new Date(lastIntDate.getTime());
        }
        String sql = null;
        if (info.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING || info.getIntReceiveType() == IntReceivedBillTypeEnum.INTBILL_REDEPOSIT) {
            if (lastIntDate == null) {
                sql = "update t_td_timedepositbill set flastrecvintday = null where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getTimeDepositBillID().getId().toString()});
            } else {
                sql = "update t_td_timedepositbill set flastrecvintday = ? where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{dp, info.getTimeDepositBillID().getId().toString()});
            }
        }
        super._delete(ctx, pk);
        this.cancleIsPreDraw(ctx, info.getTimeDepositBillID());
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    private void deleteCheck(Context ctx, IntReceivedBillInfo info) throws EASBizException, BOSException {
        if (info.isIsChongzhang() && info.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING) {
            throw new TDException(TDException.INTRECEIVEBILL_DELETE_EXC5);
        }
        if (info.isFivouchered()) {
            throw new TDException(TDException.INTRECEIVEBILL_DELETE_EXC2);
        }
        this.checkDate(ctx, info);
        this.checkType(ctx, info);
        if (!this.deleteRelated && info.getIntReceiveType() != IntReceivedBillTypeEnum.PRE_DRAWING) {
            throw new TDException(TDException.INTRECEIVEBILL_DELETE_EXC1);
        }
        if (info.getEffectedStatus() == IntReceivedStatusEnum.EXAMINE) {
            throw new TDException(TDException.CANNOT_DELETE_AUDIT_BILL);
        }
    }

    private void checkDate(Context ctx, IntReceivedBillInfo info) throws BOSException, TDException {
        IntReceivedBillCollection intBillCol = this.getIntCol(ctx, info);
        java.util.Date endate = info.getEndDate();
        IntReceivedBillInfo infoTmp = null;
        for (int i = 0; i < intBillCol.size(); ++i) {
            infoTmp = intBillCol.get(i);
            if (endate.compareTo(infoTmp.getEndDate()) >= 0) continue;
            throw new TDException(TDException.INTRECEIVEBILL_DELETE_EXC3);
        }
    }

    private IntReceivedBillCollection getIntCol(Context ctx, IntReceivedBillInfo info) throws BOSException {
        return IntReceivedBillFactory.getLocalInstance(ctx).getIntReceivedBillCollection(this.getEntity(ctx, info));
    }

    private EntityViewInfo getEntity(Context ctx, IntReceivedBillInfo info) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcBillID", (Object)info.getSrcBillID()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        view.setFilter(filter);
        return view;
    }

    private void checkType(Context ctx, IntReceivedBillInfo info) throws BOSException, TDException {
        if (info.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING) {
            java.util.Date endate = info.getEndDate();
            IntReceivedBillCollection intBillCol = this.getIntCol(ctx, info);
            IntReceivedBillInfo infoTmp = null;
            for (int i = 0; i < intBillCol.size(); ++i) {
                infoTmp = intBillCol.get(i);
                if (endate.compareTo(infoTmp.getEndDate()) != 0 || !this.isReOrUnDeposit(infoTmp.getIntReceiveType().getValue())) continue;
                throw new TDException(TDException.INTRECEIVEBILL_DELETE_EXC4);
            }
        }
    }

    private boolean isReOrUnDeposit(String type) {
        return type.equals("2") || type.equals("1");
    }

    private void cancleIsPreDraw(Context ctx, TimeDepositBillInfo info) throws BOSException {
        String sql = "update t_td_timedepositbill set FIsPreDraw = ? where fid=?".intern();
        Object[] params = new Object[]{new Integer(0), info.getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    protected void checkintrecebill(Context ctx, IntReceivedBillInfo intReceivedBillInfo) throws EASBizException {
    }

    @Override
    protected void _deleteRelated(Context ctx, IObjectPK utdPk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcBillID", (Object)utdPk.toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IntReceivedBillCollection intRCol = IntReceivedBillFactory.getLocalInstance(ctx).getIntReceivedBillCollection(evi);
        for (int i = 0; i < intRCol.size(); ++i) {
            IntReceivedBillInfo intReceivedBillInfo = intRCol.get(i);
            this.checkintrecebill(ctx, intReceivedBillInfo);
            ObjectUuidPK pk = new ObjectUuidPK(intReceivedBillInfo.getId());
            this.updateChoangZhangStatus(ctx, (IObjectPK)pk);
            this.deleteRelated = true;
            super.delete(ctx, (IObjectPK)pk);
            if (!intReceivedBillInfo.isIsAddedByReceive()) continue;
            this.updateCompIntBillStatus(ctx, intReceivedBillInfo);
        }
    }

    private void updateCompIntBillStatus(Context ctx, IntReceivedBillInfo intReceivedBillInfo) throws BOSException {
        String sql = "update t_fin_compintreceivedbill set FIsreceived = ? where fid  = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{this.HAS_NOT_BEEN_RECEIVED, intReceivedBillInfo.getComInterstBillID().toString()});
    }

    private void updateChoangZhangStatus(Context ctx, IObjectPK pk) throws BOSException {
        String sqlUpdate1 = "update T_TD_IntReceivedBill set FIsChongzhang =0 where  FIntReceiveType ='0' and FStrikedBy = ? ".intern();
        Object[] params1 = new Object[]{pk.toString()};
        DbUtil.execute((Context)ctx, (String)sqlUpdate1, (Object[])params1);
    }

    private void checkIntBillIsVoucher(IntReceivedBillInfo intReceivedBillInfo) throws BOSException {
        if (intReceivedBillInfo.isFivouchered()) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fm.td.TimeDeposittResource", (String)"intBillCannotDeleted_reason1"));
        }
    }

    private void checkIntBillIsLastBill(Context ctx, IntReceivedBillInfo intReceivedBillInfo) throws BOSException {
        String relatedTimeBillId = intReceivedBillInfo.getTimeDepositBillID().getId().toString();
        java.util.Date maxDate = this.getMaxDate(ctx, relatedTimeBillId);
        if (maxDate != null && this.isStartDateBeforeEndDate(intReceivedBillInfo.getEndDate(), maxDate)) {
            throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fm.td.TimeDeposittResource", (String)"intBillCannotDeleted_reason2", (Locale)ctx.getLocale()));
        }
    }

    private boolean isStartDateBeforeEndDate(java.util.Date p_startDate, java.util.Date p_endDate) {
        return p_startDate.compareTo(p_endDate) < 0;
    }

    private long getMillisOfDate(java.util.Date p_date) {
        Calendar c = Calendar.getInstance();
        c.setTime(p_date);
        return c.getTimeInMillis();
    }

    private java.util.Date getMaxDate(Context ctx, String relatedTimeBillId) throws BOSException {
        java.util.Date returnDate = null;
        String sql = "select max(fenddate) from t_td_intreceivedbill where  ftimedepositbillidid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{relatedTimeBillId});
        try {
            Date obj;
            if (rs.next() && (obj = rs.getDate(1)) != null) {
                returnDate = new java.util.Date(rs.getDate(1).getTime());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnDate;
    }

    private void reverseIntBillChongZhangStatus(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "update t_td_intreceivedbill set FIsChongzhang = 0 where FStrikedBy = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    @Override
    protected IObjectCollection _submitBatch(Context ctx, Set ids, String modyType) throws BOSException, EASBizException {
        IntReceivedBillCollection collection = new IntReceivedBillCollection();
        if (FMHelper.isEmpty((Collection)ids)) {
            return collection;
        }
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next().toString();
            IntReceivedBillInfo info = IntReceivedBillFactory.getLocalInstance(ctx).getIntReceivedBillInfo((IObjectPK)new ObjectUuidPK(id));
            if (modyType.equals("submit")) {
                if (info.getEffectedStatus() == IntReceivedStatusEnum.EXAMINE) continue;
                info.setEffectedStatus(IntReceivedStatusEnum.SUBMIT);
                this.submit(ctx, (CoreBaseInfo)info);
                collection.add(info);
                continue;
            }
            if (modyType.equals("Approve")) {
                if (info.getEffectedStatus() != IntReceivedStatusEnum.SUBMIT) continue;
                info.setEffectedStatus(IntReceivedStatusEnum.EXAMINE);
            } else if (modyType.equals("RevApprove")) {
                if (info.getEffectedStatus() != IntReceivedStatusEnum.EXAMINE || info.isIsGenReceiving()) continue;
                info.setEffectedStatus(IntReceivedStatusEnum.SUBMIT);
            }
            try {
                super.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
                collection.add(info);
            }
            catch (EASBizException eASBizException) {
            }
            catch (BOSException bOSException) {}
        }
        return collection;
    }
}

