/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.td.IntReceivedBillCollection;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.TimeDepositBillCollection;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.UnTimeDepositBillCollection;
import com.kingdee.eas.fm.td.UnTimeDepositBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;
import com.kingdee.eas.fm.td.app.UnDepositSeqInfo;
import com.kingdee.eas.fm.td.app.UnDepositSeqInfoList;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;

public class ReceiveTestUtil {
    public static TimeDepositBillCollection getCompDepositToBeReceived(Context ctx, Set ids) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return TimeDepositBillFactory.getLocalInstance(ctx).getTimeDepositBillCollection(evi);
    }

    public static UnTimeDepositBillCollection getUnCompDepositToBeReceived(Context ctx, Set ids) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return UnTimeDepositBillFactory.getLocalInstance(ctx).getUnTimeDepositBillCollection(evi);
    }

    public static void copyProperties(CoreBaseInfo desInfo, CoreBaseInfo srcInfo) {
        if (srcInfo instanceof TimeDepositBillInfo) {
            if (desInfo instanceof TimeDepositBillInfo) {
                ReceiveTestUtil.copyPropertiesToTimeDepositBill((TimeDepositBillInfo)desInfo, (TimeDepositBillInfo)srcInfo);
            }
        } else if (srcInfo instanceof UnTimeDepositBillInfo) {
            if (desInfo instanceof UnTimeDepositBillInfo) {
                ReceiveTestUtil.copyPropertiesToUnTimeDepositBill((UnTimeDepositBillInfo)desInfo, (UnTimeDepositBillInfo)srcInfo);
            }
        } else if (srcInfo instanceof IntReceivedBillInfo && desInfo instanceof IntReceivedBillInfo) {
            ReceiveTestUtil.copyPropertiesToIntBill((IntReceivedBillInfo)desInfo, (IntReceivedBillInfo)srcInfo);
        }
    }

    private static void copyPropertiesToIntBill(IntReceivedBillInfo desInfo, IntReceivedBillInfo srcInfo) {
        desInfo.setIntReceiveType(srcInfo.getIntReceiveType());
        desInfo.setBank(srcInfo.getBank());
        desInfo.setBizDate(DateTimeUtils.truncateDate((Date)srcInfo.getBizDate()));
        desInfo.setCurrency(srcInfo.getCurrency());
        desInfo.setEffectiveDate(DateTimeUtils.truncateDate((Date)srcInfo.getEffectiveDate()));
        desInfo.setEndDate(DateTimeUtils.truncateDate((Date)srcInfo.getEndDate()));
        desInfo.setIntervalDays(srcInfo.getIntervalDays());
        desInfo.setIntRateTypeExpression(srcInfo.getIntRateTypeExpression());
        desInfo.setYearDays(srcInfo.getYearDays());
        desInfo.setDepositAmt(srcInfo.getDepositAmt());
        desInfo.setDepYearRate(srcInfo.getDepYearRate());
        desInfo.setDeInterest(srcInfo.getDeInterest());
        desInfo.setCreYearRate(srcInfo.getCreYearRate());
        desInfo.setCreInterest(srcInfo.getCreInterest());
        desInfo.setShijiAmt(srcInfo.getShijiAmt());
        desInfo.setYingjiAmt(srcInfo.getYingjiAmt());
        desInfo.setDigest(srcInfo.getDigest());
        desInfo.setIsAddedByReceive(true);
        desInfo.setId(BOSUuid.create((BOSObjectType)desInfo.getBOSType()));
        desInfo.setNumber(srcInfo.getNumber() + " Received");
    }

    private static void copyPropertiesToUnTimeDepositBill(UnTimeDepositBillInfo desInfo, UnTimeDepositBillInfo srcInfo) {
        desInfo.setBizDate(srcInfo.getBizDate());
        desInfo.setUnDepositType(srcInfo.getUnDepositType());
        desInfo.setBank(srcInfo.getBank());
        desInfo.setCompany(srcInfo.getCompany());
        desInfo.setUnTimeDepositSeqNo(srcInfo.getUnTimeDepositSeqNo());
        desInfo.setPayeeBankAccount(srcInfo.getPayeeBankAccount());
        desInfo.setCurrency(srcInfo.getCurrency());
        desInfo.setExchangeRate(srcInfo.getExchangeRate());
        desInfo.setUnDepositAmt(srcInfo.getUnDepositAmt());
        desInfo.setAccumulativeUnTimeDepostAmt(srcInfo.getAccumulativeUnTimeDepostAmt());
        desInfo.setHandler(srcInfo.getHandler());
        desInfo.setDescription(srcInfo.getDescription());
        desInfo.setComUnDepositBillID(srcInfo.getId());
        desInfo.setIsAddedByReceive(true);
        desInfo.setId(BOSUuid.create((BOSObjectType)desInfo.getBOSType()));
        desInfo.setNumber(srcInfo.getNumber() + " Received");
        desInfo.setTimeDepositBill(srcInfo.getTimeDepositBill());
    }

    private static void copyPropertiesToTimeDepositBill(TimeDepositBillInfo desInfo, TimeDepositBillInfo srcInfo) {
        desInfo.setCompany(srcInfo.getCompany());
        desInfo.setDepositBank(srcInfo.getDepositBank());
        desInfo.setBizDate(DateUtil.getDayBegin());
        desInfo.setCertificateNo(srcInfo.getCertificateNo());
        desInfo.setTimeDepositType(srcInfo.getTimeDepositType());
        desInfo.setIsAccrualToDepositAmt(srcInfo.isIsAccrualToDepositAmt());
        desInfo.setEffectiveDate(DateTimeUtils.truncateDate((Date)srcInfo.getEffectiveDate()));
        desInfo.setIntTerm(srcInfo.getIntTerm());
        desInfo.setMaturityDay(DateTimeUtils.truncateDate((Date)srcInfo.getMaturityDay()));
        desInfo.setIntRateTable(srcInfo.getIntRateTable());
        desInfo.setFloating(srcInfo.getFloating());
        desInfo.setYearRate(srcInfo.getYearRate());
        desInfo.setCurYearRate(srcInfo.getCurYearRate());
        desInfo.setIntRateTypeExpression(srcInfo.getIntRateTypeExpression());
        desInfo.setYearDays(srcInfo.getYearDays());
        desInfo.setBankDepAcct(srcInfo.getBankDepAcct());
        desInfo.setBankCurAcct(srcInfo.getBankCurAcct());
        desInfo.setCurrency(srcInfo.getCurrency());
        desInfo.setExchangeRate(srcInfo.getExchangeRate());
        desInfo.setDepositAmt(srcInfo.getDepositAmt());
        desInfo.setDepositLocalAmt(srcInfo.getDepositLocalAmt());
        desInfo.setFloorAmt(srcInfo.getFloorAmt());
        desInfo.setMatureIntAmtIntending(srcInfo.getMatureIntAmtIntending());
        desInfo.setHandler(srcInfo.getHandler());
        desInfo.setDescription(srcInfo.getDescription());
        desInfo.setDepositLocalAmt(srcInfo.getDepositLocalAmt());
        desInfo.setIsAccrualToDepositAmt(srcInfo.isIsAccrualToDepositAmt());
        desInfo.setIsAddedByReceive(true);
        desInfo.setComDepositBillID(srcInfo.getId());
        desInfo.setBalance(srcInfo.getBalance());
        desInfo.setIsHistoryBill(srcInfo.isIsHistoryBill());
        desInfo.setId(BOSUuid.create((BOSObjectType)desInfo.getBOSType()));
        desInfo.setNumber(srcInfo.getNumber() + " Received");
        desInfo.setSourceBillId(srcInfo.getSourceBillId());
    }

    public static void setOtherValueForTimeDeposit(TimeDepositBillInfo tdbi) {
        tdbi.setId(BOSUuid.create((BOSObjectType)tdbi.getBOSType()));
        tdbi.setBalance(tdbi.getDepositAmt());
        if (tdbi.isIsHistoryBill()) {
            tdbi.setInitBalanceOfHistoryBill(tdbi.getBalance());
        } else {
            tdbi.setInitBalanceOfHistoryBill(tdbi.getDepositLocalAmt());
        }
        tdbi.setIsAddedByReDeposit(true);
    }

    public static void setOtherValueForIntBill(IntReceivedBillInfo intBillInfo, TimeDepositBillInfo tdbi) {
        intBillInfo.setTimeDepositBillInfo(tdbi);
        intBillInfo.setSrcBillID(tdbi.getId().toString());
        intBillInfo.setCompany(tdbi.getCompany());
    }

    public static void setOtherValueForIntBill(IntReceivedBillInfo intBillInfo, UnTimeDepositBillInfo tdbi) {
        intBillInfo.setUnTimeDepositBillInfo(tdbi);
        intBillInfo.setSrcBillID(tdbi.getId().toString());
        intBillInfo.setCompany(tdbi.getCompany());
    }

    public static IntReceivedBillInfo getComIntReceivedBillInfoBySrcID(Context ctx, String depositBillID) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcBillID", (Object)depositBillID, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IntReceivedBillCollection col = IntReceivedBillFactory.getLocalInstance(ctx).getIntReceivedBillCollection(evi);
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    protected static UnDepositSeqInfoList getMaxReceivedUnTimeDePosit(Context ctx, Set ids) throws BOSException {
        UnDepositSeqInfoList li = new UnDepositSeqInfoList();
        StringBuffer sql = new StringBuffer();
        sql.append(" select untd.fid, td.fid,");
        sql.append(" (select max(FUnTimeDepositSeqNo) from T_td_UnTimeDepositBill  ");
        sql.append("where FTimeDepositBillID = untd.FTimeDepositBillID) ");
        sql.append("from t_td_timedepositbill as td,T_td_UnTimeDepositBill as untd  ");
        sql.append("where td.fid = untd.ftimedepositbillid ");
        sql.append(" and untd.fid in ").append(ReceiveTestUtil.getValues(ids.toArray(new String[ids.size()])));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        UnDepositSeqInfo info = null;
        try {
            while (rs.next()) {
                info = new UnDepositSeqInfo(rs.getString(1), rs.getString(2), rs.getInt(3));
                li.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return li;
    }

    private static String getValues(String[] currencyIDs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < currencyIDs.length; ++i) {
            sb.append("'").append(currencyIDs[i]).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ")";
    }
}

