/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.td.StatisticalUnitEnum;
import com.kingdee.eas.fm.td.TimeDepositTypeEnum;
import com.kingdee.eas.fm.td.app.RptTimeDepositSumFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.bireport.util.SimpleTreeNode;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class RptTimeDepositHelper {
    private String queryType;
    private Date startDate;
    private Date endDate;
    private CurrencyInfo currencyInfo;
    private CurrencyInfo baseCurrency;
    private CompanyOrgUnitInfo currentCompany;
    private TimeDepositTypeEnum timeDepositType;
    private Set banks;
    private Set companys;
    private StatisticalUnitEnum amountUnit;
    private SimpleTreeNode companyTree = null;
    private String loc;
    private String configFile = "";
    private StringBuffer mdx = null;
    private String commonFilerToTimeDeposit;
    private StringBuffer sql = null;
    private String bankTmp;
    private boolean isNeedExchange = false;
    private String groupByColum = "";
    String unit = "1";

    public static RptTimeDepositHelper getInstance(RptParams params, Context ctx, String bankTmp) throws EASBizException, BOSException {
        return new RptTimeDepositHelper(params, ctx, bankTmp);
    }

    public RptTimeDepositHelper(RptParams params, Context ctx, String bankTmp) throws EASBizException, BOSException {
        this.bankTmp = bankTmp;
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(this.currentCompany);
        this.queryType = (String)params.getObject("queryType");
        this.startDate = (Date)params.getObject("startDate");
        this.endDate = (Date)params.getObject("endDate");
        try {
            this.currencyInfo = (CurrencyInfo)params.getObject("currency");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            this.timeDepositType = (TimeDepositTypeEnum)((Object)params.getObject("depositType"));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.banks = FMHelper.asSet((String[])((String[])params.getObject("bankIDS")));
        this.companys = (Set)params.getObject("companyIDS");
        this.amountUnit = (StatisticalUnitEnum)((Object)params.getObject("amountUnit"));
        this.companyTree = (SimpleTreeNode)params.getObject("companyTree");
        this.loc = this.getLoc(ctx);
        this.isNeedExchange = this.setIsLocalCurrency(this.currencyInfo);
    }

    private boolean setIsLocalCurrency(CurrencyInfo currencyInfo2) {
        return currencyInfo2 == null;
    }

    private String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    private String getCommonFilterToTimeDeposit() {
        Iterator it;
        StringBuffer sb = new StringBuffer();
        sb.append("(FEffectedStatus = 2 ");
        if (this.currencyInfo != null) {
            sb.append(" and fcurrencyid = '").append(this.currencyInfo.getId().toString()).append("' ");
        }
        if (this.timeDepositType != null && (this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_OUTER)) {
            sb.append(" and ftimedeposittype ='").append(this.timeDepositType.getValue()).append("' ");
        }
        if (this.companys.size() > 0) {
            sb.append(" and fdepositcompanyid in (");
            it = this.companys.iterator();
            while (it.hasNext()) {
                sb.append("'").append(it.next().toString()).append("',");
            }
            sb.append("'')");
        }
        if (this.banks != null && this.banks.size() > 0) {
            sb.append(" and fdepositbankid in (");
            it = this.banks.iterator();
            while (it.hasNext()) {
                sb.append("'").append(it.next().toString()).append("',");
            }
            sb.append("'')");
        }
        sb.append(")");
        return sb.toString();
    }

    public void prepare(Context ctx, String queryType) throws BOSException, EASBizException {
        this.commonFilerToTimeDeposit = this.getCommonFilterToTimeDeposit();
        if (this.amountUnit.equals((Object)StatisticalUnitEnum.THOUSAND)) {
            this.unit = "1000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.TEN_THOUSAND)) {
            this.unit = "10000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.MILLION)) {
            this.unit = "1000000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.HUNDRED_THOUSAND)) {
            this.unit = "10000000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.HUNDRED_MILLION)) {
            this.unit = "100000000";
        }
    }

    public void setSchemaSource(Context ctx, SchemaSource ss) {
        ss.setDataItem("Fact", this.getSumSql1Prepare(this.unit), this.getParams());
        this.sql = new StringBuffer();
        this.sql.setLength(0);
        if (this.queryType.equals("byBank")) {
            this.sql.append("select com.FId,com.FName_").append(this.loc).append(" as FName,FParentID as FParentID from " + this.bankTmp + " as com\n");
            ss.setDataItem("Bank", this.sql.toString(), null);
            this.configFile = "RptTimeDepositSum_Bank.xml";
            this.mdx = new StringBuffer();
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"7_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append("\n select  [Measures].members on columns, ");
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"62_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append(" \n from fm");
        } else if (this.queryType.equals("byCompany")) {
            this.sql.append("select com.FId,com.FName_").append(this.loc).append(" as FName,FParentID as FParentID from T_ORG_Company as com\n");
            ss.setDataItem("Company", this.sql.toString(), null);
            this.configFile = "RptTimeDepositSum_Company.xml";
            this.mdx = new StringBuffer();
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"8_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append("\n select  [Measures].members on columns, ");
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"63_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append(" \n from fm");
        } else if (this.queryType.equals("byCurrency")) {
            this.sql.append("select cur.FId,cur.FName_").append(this.loc).append(" as FName from T_BD_Currency as cur\n");
            ss.setDataItem("Currency", this.sql.toString(), null);
            this.configFile = "RptTimeDepositSum_Currency.xml";
            this.mdx = new StringBuffer();
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"9_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append("\n select  [Measures].members on columns,");
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"10_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append("\n from fm");
        }
        ss.setCaller(RptTimeDepositSumFacadeControllerBean.class);
        ss.setFilename(this.configFile);
        ss.setMdx(this.mdx.toString());
    }

    private String getSumSql1(String unit2) {
        StringBuffer sbInnerSQL1 = this.getInnerSQL1();
        StringBuffer sbInnerSQL2 = this.getInnerSQL2(sbInnerSQL1);
        StringBuffer sbInnerSQL3 = this.getInnerSQL3(sbInnerSQL2);
        return sbInnerSQL3.toString();
    }

    private StringBuffer getInnerSQL3(StringBuffer sbInnerSQL2) {
        StringBuffer sqlInnerSQL3 = new StringBuffer();
        if (this.queryType.equals("byBank")) {
            this.groupByColum = " fbankid ";
        } else if (this.queryType.equals("byCompany")) {
            this.groupByColum = " fcompanyid ";
        } else if (this.queryType.equals("byCurrency")) {
            this.groupByColum = " fcurrencyid ";
        }
        sqlInnerSQL3.append("select ").append(this.groupByColum).append(",");
        sqlInnerSQL3.append("sum(FQICHUYUE)/").append(this.unit).append(" as FQICHUYUE,       \n");
        sqlInnerSQL3.append("sum(FBENQIZENGJIA)/").append(this.unit).append(" as FBENQIZENGJIA,\n");
        sqlInnerSQL3.append("sum(FBENQIJIANSHAO)/").append(this.unit).append(" as FBENQIJIANSHAO,\n");
        sqlInnerSQL3.append("sum(FQICHUYUE+FBENQIZENGJIA-FBENQIJIANSHAO)/").append(this.unit).append(" as FBENQIYUE \n");
        sqlInnerSQL3.append("from                                                        \n");
        sqlInnerSQL3.append("(                                                           \n");
        sqlInnerSQL3.append(sbInnerSQL2);
        sqlInnerSQL3.append(")  bb                                                         \n");
        sqlInnerSQL3.append("group by ").append(this.groupByColum);
        return sqlInnerSQL3;
    }

    private StringBuffer getInnerSQL2(StringBuffer sbInnerSQL1) {
        StringBuffer innerSQL2 = new StringBuffer();
        innerSQL2.append("select                                                       \n");
        innerSQL2.append("fid,fcompanyid,fcurrencyid,fbankid,                          \n");
        innerSQL2.append("(qichubenjinbase-unDepositAmt1-redeamt) as FQICHUYUE,                           \n");
        innerSQL2.append("benqizengjia as FBENQIZENGJIA,                           \n");
        innerSQL2.append("(unDepositAmt2 + redeamt1) as FBENQIJIANSHAO            \n");
        innerSQL2.append("                                                             \n");
        innerSQL2.append("from                                                         \n");
        innerSQL2.append("(                                                            \n");
        innerSQL2.append(sbInnerSQL1);
        innerSQL2.append(") aa                                                           \n");
        return innerSQL2;
    }

    private StringBuffer getInnerSQL1() {
        StringBuffer innerSQL1 = new StringBuffer();
        innerSQL1.append("select                                                                                             \n");
        innerSQL1.append("tim.fid,tim.fbizdate,tim.fdepositcompanyid as fcompanyid,tim.fcurrencyid,tim.fdepositbankid as fbankid,                 \n");
        innerSQL1.append("tim.fishistorybill,                                                                                \n");
        innerSQL1.append("(tim.finitbalanceofhistorybill*tim.fexchangeRate) as finitbalanceofhistorybill ,                   \n");
        innerSQL1.append("tim.fdepositlocalamt,                                                                              \n");
        innerSQL1.append(" (select isnull(sum(tim3.finitbalanceofhistorybill*tim3.fexchangeRate),0)  from t_td_timedepositbill  tim3 where tim3.feffectivedate<{" + FMConstants.FORMAT_TIME.format(this.startDate) + "} and tim3.fid = tim.fid ) as qichubenjinbase,  \n");
        innerSQL1.append("(   \n");
        innerSQL1.append("\t\t  select isnull(sum(tim1.finitbalanceofhistorybill*tim1.fexchangeRate),0) from t_td_timedepositbill tim1  \n");
        innerSQL1.append("\t\t\twhere tim1.feffectivedate <= {" + FMConstants.FORMAT_TIME.format(this.endDate) + "} and  \n");
        innerSQL1.append("\t      tim1.feffectivedate >= {" + FMConstants.FORMAT_TIME.format(this.startDate) + "} and tim1.fid = tim.fid \n");
        innerSQL1.append(") as benqizengjia, \n");
        innerSQL1.append("(                                                                                                  \n");
        innerSQL1.append(" select isnull(sum(ff.fundepositamtlocal),0)                                                          \n");
        innerSQL1.append(" from t_td_untimedepositbill ff                                                                    \n");
        innerSQL1.append(" where  ff.fbizdate < {").append(FMConstants.FORMAT_TIME.format(this.startDate)).append("}");
        innerSQL1.append(" and ff.ftimedepositbillid = tim.fid ) as unDepositAmt1,                                               \n");
        innerSQL1.append("(case tim.fisredeposited                                                                           \n");
        innerSQL1.append("  when 1 then                                                                                      \n");
        innerSQL1.append("   isnull( (                                                                                              \n");
        innerSQL1.append("      select timinner.finitbalanceofhistorybill*timinner.fexchangeRate - timinner.faccrualtodepositamt*timinner.fexchangeRate                             \n");
        innerSQL1.append("      from t_td_timedepositbill timinner ");
        innerSQL1.append("\t\t\twhere timinner.feffectivedate < {" + FMConstants.FORMAT_TIME.format(this.startDate) + "} and timinner.fsourcebillid = tim.fid),0) \n");
        innerSQL1.append("  else 0                                                                                           \n");
        innerSQL1.append("  end                                                                                              \n");
        innerSQL1.append(") as redeamt,                                                                                      \n");
        innerSQL1.append("(case tim.fisredeposited                                                                           \n");
        innerSQL1.append("  when 1 then                                                                                      \n");
        innerSQL1.append("      (select isnull(sum(timinner.finitbalanceofhistorybill*timinner.fexchangeRate - timinner.faccrualtodepositamt*timinner.fexchangeRate),0)                             \n");
        innerSQL1.append("      from t_td_timedepositbill timinner ");
        innerSQL1.append("\t\t\twhere timinner.feffectivedate >= {" + FMConstants.FORMAT_TIME.format(this.startDate) + "} and timinner.fmaturityday <={" + Constants.FORMAT_TIME.format(this.endDate) + "} and timinner.fsourcebillid = tim.fid) \n");
        innerSQL1.append("  else 0                                                                                           \n");
        innerSQL1.append("  end                                                                                              \n");
        innerSQL1.append(") as redeamt1,                                                                                      \n");
        innerSQL1.append("(case tim.fishistorybill                                                                           \n");
        innerSQL1.append(" when 1 then (select isnull((sum(tim4.fdepositlocalamt - tim4.finitbalanceofhistorybill)),0) ");
        innerSQL1.append(" from t_td_timedepositbill tim4 ");
        innerSQL1.append("\t\t\twhere tim4.feffectivedate <= {" + FMConstants.FORMAT_TIME.format(this.endDate) + "} and  \n");
        innerSQL1.append("\t      tim4.feffectivedate >= {" + FMConstants.FORMAT_TIME.format(this.startDate) + "} and tim4.fid = tim.fid) \n");
        innerSQL1.append("  else 0                                                                                           \n");
        innerSQL1.append("  end                                                                                              \n");
        innerSQL1.append(") as amt3,  \t\t\t\t\t\t\t                                                             \n");
        innerSQL1.append("(select isnull(sum(ff.fundepositamtlocal),0)                                                          \n");
        innerSQL1.append(" from t_td_untimedepositbill ff                                                                    \n");
        innerSQL1.append(" where     \n");
        innerSQL1.append("  fbizdate >= {").append(FMConstants.FORMAT_TIME.format(this.startDate)).append("} and fbizdate <= {").append(FMConstants.FORMAT_TIME.format(this.endDate)).append("} and \n");
        innerSQL1.append(" ff.ftimedepositbillid = tim.fid                                                                   \n");
        innerSQL1.append(") as unDepositAmt2                                                                                 \n");
        innerSQL1.append("from t_td_timedepositbill tim                                                                      \n");
        innerSQL1.append(" where ").append(this.getCommonFilterToTimeDeposit());
        return innerSQL1;
    }

    private SqlParams getSqlParams1() {
        SqlParams sqlp = new SqlParams();
        return sqlp;
    }

    private String getSumSql1Prepare(String unit2) {
        StringBuffer sbInnerSQL1 = this.getInnerSQL1Prepare();
        StringBuffer sbInnerSQL2 = this.getInnerSQL2(sbInnerSQL1);
        StringBuffer sbInnerSQL3 = this.getInnerSQL3(sbInnerSQL2);
        return sbInnerSQL3.toString();
    }

    private StringBuffer getInnerSQL1Prepare() {
        StringBuffer innerSQL1 = new StringBuffer();
        innerSQL1.append("select                                                                                             \n");
        innerSQL1.append("tim.fid,tim.fbizdate,tim.fdepositcompanyid as fcompanyid,tim.fcurrencyid,tim.fdepositbankid as fbankid,                 \n");
        innerSQL1.append("tim.fishistorybill,                                                                                \n");
        if (this.isNeedExchange) {
            innerSQL1.append(" (select isnull(sum(tim3.finitbalanceofhistorybill*tim3.fexchangeRate),0)  from t_td_timedepositbill  tim3 where tim3.feffectivedate<? and tim3.fid = tim.fid ) as qichubenjinbase,  \n");
        } else {
            innerSQL1.append(" (select isnull(sum(tim3.finitbalanceofhistorybill),0)  from t_td_timedepositbill  tim3 where tim3.feffectivedate<? and tim3.fid = tim.fid ) as qichubenjinbase,  \n");
        }
        innerSQL1.append("(   \n");
        innerSQL1.append("\t\t  select isnull(sum(  ").append(this.getBenQiZengJia()).append("    ),0) from t_td_timedepositbill tim1  \n");
        innerSQL1.append("\t\t\twhere tim1.feffectivedate <= ? and  \n");
        innerSQL1.append("\t      tim1.feffectivedate >= ? and tim1.fid = tim.fid \n");
        innerSQL1.append(") as benqizengjia, \n");
        innerSQL1.append("(                                                                                                  \n");
        innerSQL1.append(" select isnull(sum( ").append(this.getUnDepositAmt()).append(" ),0)                                                          \n");
        innerSQL1.append(" from t_td_untimedepositbill ff                                                                    \n");
        innerSQL1.append(" where  ff.fbizdate < ? ");
        innerSQL1.append(" and ff.ftimedepositbillid = tim.fid ) as unDepositAmt1,                                               \n");
        innerSQL1.append("(case tim.fisredeposited                                                                           \n");
        innerSQL1.append("  when 1 then                                                                                      \n");
        innerSQL1.append("   isnull( (                                                                                              \n");
        innerSQL1.append("      select                             \n").append(this.getRedeamt());
        innerSQL1.append("      from t_td_timedepositbill timinner ");
        innerSQL1.append("\t\t\twhere timinner.feffectivedate < ? and timinner.fsourcebillid = tim.fid),0) \n");
        innerSQL1.append("  else 0                                                                                           \n");
        innerSQL1.append("  end                                                                                              \n");
        innerSQL1.append(") as redeamt,                                                                                      \n");
        innerSQL1.append("(case tim.fisredeposited                                                                           \n");
        innerSQL1.append("  when 1 then                                                                                      \n");
        innerSQL1.append("      (select isnull(sum(  ").append(this.getRedeamt1()).append("  ),0)                             \n");
        innerSQL1.append("      from t_td_timedepositbill timinner ");
        innerSQL1.append("\t\t\twhere timinner.feffectivedate >= ? and timinner.feffectivedate <=? and timinner.fsourcebillid = tim.fid) \n");
        innerSQL1.append("  else 0                                                                                           \n");
        innerSQL1.append("  end                                                                                              \n");
        innerSQL1.append(") as redeamt1,                                                                                      \n");
        innerSQL1.append("(case tim.fishistorybill                                                                           \n");
        innerSQL1.append(" when 1 then (select isnull((   ").append(this.getAmt3()).append(" )),0) ");
        innerSQL1.append(" from t_td_timedepositbill tim4 ");
        innerSQL1.append("\t\t\twhere tim4.feffectivedate <= ? and  \n");
        innerSQL1.append("\t      tim4.feffectivedate >= ? and tim4.fid = tim.fid) \n");
        innerSQL1.append("  else 0                                                                                           \n");
        innerSQL1.append("  end                                                                                              \n");
        innerSQL1.append(") as amt3,  \t\t\t\t\t\t\t                                                             \n");
        innerSQL1.append("(select isnull(sum( " + this.getUnDepositAmt() + " ),0)                                                          \n");
        innerSQL1.append(" from t_td_untimedepositbill ff                                                                    \n");
        innerSQL1.append(" where     \n");
        innerSQL1.append("  fbizdate >= ? and fbizdate <= ? and \n");
        innerSQL1.append(" ff.ftimedepositbillid = tim.fid                                                                   \n");
        innerSQL1.append(") as unDepositAmt2                                                                                 \n");
        innerSQL1.append("from t_td_timedepositbill tim                                                                      \n");
        innerSQL1.append(" where ").append(this.getCommonFilterToTimeDepositPrepared());
        return innerSQL1;
    }

    private String getAmt3() {
        String returnValue = this.isNeedExchange ? "sum(tim4.fdepositlocalamt - tim4.finitbalanceofhistorybill*tim4.FExchangeRate" : "sum(tim4.FDepositAmt - tim4.finitbalanceofhistorybill";
        return returnValue;
    }

    private String getRedeamt1() {
        String returnValue = this.isNeedExchange ? "timinner.finitbalanceofhistorybill*timinner.fexchangeRate - timinner.faccrualtodepositamt*timinner.fexchangeRate" : "timinner.finitbalanceofhistorybill - timinner.faccrualtodepositamt";
        return returnValue;
    }

    private String getRedeamt() {
        String returnValue = this.isNeedExchange ? "timinner.finitbalanceofhistorybill*timinner.fexchangeRate - timinner.faccrualtodepositamt*timinner.fexchangeRate" : "timinner.finitbalanceofhistorybill - timinner.faccrualtodepositamt";
        return returnValue;
    }

    private String getUnDepositAmt() {
        String returnValue = this.isNeedExchange ? "ff.fundepositamtlocal" : "ff.FUnDepositAmt";
        return returnValue;
    }

    private String getBenQiZengJia() {
        String returnValue = "tim1.finitbalanceofhistorybill";
        if (this.isNeedExchange) {
            returnValue = returnValue + "*tim1.fexchangeRate";
        }
        return returnValue;
    }

    private SqlParams getParams() {
        Object[] fixParam = this.getFixPara();
        Object[] currencyParam = this.getCurrencyPara();
        Object[] timeDepositTypeParam = this.getTimeDepositTypePara();
        Object[] companyParam = this.getCompanyPara();
        Object[] bankParam = this.getBankPara();
        return this.combineParam(fixParam, currencyParam, timeDepositTypeParam, companyParam, bankParam);
    }

    private SqlParams combineParam(Object[] fixParam, Object[] currencyParam, Object[] timeDepositTypeParam, Object[] companyParam, Object[] bankParam) {
        int paramCount = fixParam.length + currencyParam.length + timeDepositTypeParam.length + companyParam.length + bankParam.length;
        Object[] allParam = new Object[paramCount];
        int copyPosition = 0;
        System.arraycopy(fixParam, 0, allParam, copyPosition, fixParam.length);
        System.arraycopy(currencyParam, 0, allParam, copyPosition += fixParam.length, currencyParam.length);
        System.arraycopy(timeDepositTypeParam, 0, allParam, copyPosition += currencyParam.length, timeDepositTypeParam.length);
        System.arraycopy(companyParam, 0, allParam, copyPosition += timeDepositTypeParam.length, companyParam.length);
        System.arraycopy(bankParam, 0, allParam, copyPosition += companyParam.length, bankParam.length);
        return new SqlParams(allParam);
    }

    private Object[] getBankPara() {
        if (this.banks != null) {
            Object[] bankIDParam = new Object[this.getPlaceholderCount(this.banks.size())];
            int bankIDChoosedCount = this.banks.size();
            Object[] bankids = this.banks.toArray();
            System.arraycopy(bankids, 0, bankIDParam, 0, bankids.length);
            for (int j = 0; j < bankIDParam.length - bankIDChoosedCount; ++j) {
                bankIDParam[j + bankIDChoosedCount] = "";
            }
            return bankIDParam;
        }
        return new Object[0];
    }

    private Object[] getCompanyPara() {
        Object[] companyIDParam = new Object[this.getPlaceholderCount(this.companys.size())];
        int loanCompanyIDChoosedCount = this.companys.size();
        Object[] companyids = this.companys.toArray();
        System.arraycopy(companyids, 0, companyIDParam, 0, companyids.length);
        for (int j = 0; j < companyIDParam.length - loanCompanyIDChoosedCount; ++j) {
            companyIDParam[j + loanCompanyIDChoosedCount] = "";
        }
        return companyIDParam;
    }

    private Object[] getTimeDepositTypePara() {
        Object[] timeDepositTypeParam = null;
        if (this.timeDepositType != null) {
            if (this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) {
                timeDepositTypeParam = new String[]{this.timeDepositType.getValue()};
            }
        } else {
            timeDepositTypeParam = new String[]{};
        }
        return timeDepositTypeParam;
    }

    private Object[] getCurrencyPara() {
        Object[] currencyParam = null;
        currencyParam = this.currencyInfo != null ? new String[]{this.currencyInfo.getId().toString()} : new String[]{};
        return currencyParam;
    }

    private Object[] getFixPara() {
        return new Object[]{this.startDate, this.endDate, this.startDate, this.startDate, this.startDate, this.startDate, this.endDate, this.endDate, this.startDate, this.startDate, this.endDate};
    }

    private String getCommonFilterToTimeDepositPrepared() {
        StringBuffer sb = new StringBuffer();
        sb.append("(FEffectedStatus = 2 ");
        if (this.currencyInfo != null) {
            sb.append(" and fcurrencyid = ? ");
        }
        if (this.timeDepositType != null && (this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_OUTER)) {
            sb.append(" and ftimedeposittype =? ");
        }
        if (this.companys.size() > 0) {
            sb.append(" and ").append(this.getCompanyPrepared(this.companys));
        }
        if (this.banks != null && this.banks.size() > 0) {
            sb.append(" and ").append(this.getBankPrepared(this.banks));
        }
        sb.append(")");
        return sb.toString();
    }

    private String getBankPrepared(Set bankset) {
        StringBuffer sb = new StringBuffer();
        int placeholderCount = this.getPlaceholderCount(this.banks.size());
        for (int i = 0; i < placeholderCount; ++i) {
            sb.append(" fdepositbankid = ? ");
            if (i == placeholderCount - 1) continue;
            sb.append(" or ");
        }
        return "(" + sb.toString() + ")";
    }

    private String getCompanyPrepared(Set companys) {
        StringBuffer sb = new StringBuffer();
        int placeholderCount = this.getPlaceholderCount(companys.size());
        for (int i = 0; i < placeholderCount; ++i) {
            sb.append(" fdepositcompanyid = ? ");
            if (i == placeholderCount - 1) continue;
            sb.append(" or ");
        }
        return "(" + sb.toString() + ")";
    }

    private int getPlaceholderCount(int i) {
        if (i <= 20) {
            return 20;
        }
        if (i > 20 && i <= 40) {
            return 40;
        }
        if (i > 40 && i <= 60) {
            return 60;
        }
        if (i > 60 && i <= 80) {
            return 80;
        }
        return i;
    }
}

