/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.TermTypeEnum;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositApplyFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyInfo;
import com.kingdee.eas.fm.td.TimeDepositBillBookNotifyBuilder;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.TimeDepositHelper;
import com.kingdee.eas.fm.td.app.AbstractTimeDepositBillControllerBean;
import com.kingdee.eas.fm.td.app.BillReceiver;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TimeDepositBillControllerBean
extends AbstractTimeDepositBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.td.app.TimeDepositBillControllerBean");

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected IRowSet _getMaturityDeposit(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("select a.fid,a.fnumber,a.feffectivedate,a.fdepositamt,b.fnumber||b.fname_").append(loc).append(" ,a.fmaturityday,a.fyearrate,c.fnumber||c.fname_").append(loc).append(" ");
        sql.append(" from t_td_timedepositbill a,t_int_intterm b,t_bd_bank c ");
        sql.append(" where a.finttermid=b.fid and a.fdepositbankid = c.fid and a.fmaturityday<=?");
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        JdbcRowSet rowset = null;
        cn = this.getConnection(ctx);
        try {
            pstmt = cn.prepareStatement(sql.toString());
            pstmt.setDate(1, new Date(new java.util.Date().getTime()));
            rs = pstmt.executeQuery();
            rowset = new JdbcRowSet();
            rowset.populate(rs);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return rowset;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TimeDepositBillInfo info = (TimeDepositBillInfo)model;
        if (info.isIsAddedByReDeposit() && info.getDepositAmt() != null && info.getIntTerm() != null && info.getYearRate() != null) {
            int intervalDays = 0;
            BigDecimal base = Constants.ONE_HUNDRED;
            BigDecimal depositAmt = info.getFloorAmt() == null ? info.getDepositAmt() : info.getDepositAmt().subtract(info.getFloorAmt());
            BigDecimal yearrate = info.getYearRate();
            BigDecimal yearDays = new BigDecimal(String.valueOf(info.getYearDays()));
            java.util.Date startDate = info.getEffectiveDate();
            java.util.Date endDate = info.getMaturityDay();
            intervalDays = TimeDepositHelper.getInstance().value_TD001_server(ctx, info.getCompany()) && info.getIntTerm().getType() == TermTypeEnum.MONTH ? info.getIntTerm().getTerm() * 30 : (TimeDepositHelper.getInstance().value_TD001_server(ctx, info.getCompany()) && info.getIntTerm().getType() == TermTypeEnum.YEAR ? info.getIntTerm().getTerm() * 360 : TimeDepositHelper.getInstance().calcuIntervalDays(endDate, startDate));
            if (info.getIntRateTypeExpression() != IntRateTypeExpressionEnum.YEAR) {
                base = Constants.ONE_THOUSAND;
            }
            BigDecimal intAmt = TimeDepositHelper.getInstance().calcMatureIntAmt(depositAmt, yearrate, yearDays, new BigDecimal(String.valueOf(intervalDays)), base);
            info.setMatureIntAmtIntending(intAmt);
        }
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)info, (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        String sourceBillId;
        TimeDepositBillInfo timeDepositBillInfo = (TimeDepositBillInfo)info;
        IObjectPK pk = super._submit(ctx, (IObjectValue)timeDepositBillInfo);
        int val = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS001", (IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getCompany().getId()));
        boolean valTD008 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TD008", (IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getCompany().getId()));
        if (val == 0 && valTD008 && !timeDepositBillInfo.isIsHistoryBill()) {
            this.antiBook(ctx, pk);
            this.book(ctx, pk);
        }
        if (timeDepositBillInfo.isIsAddedByReDeposit()) {
            this.doUpdate(ctx, timeDepositBillInfo);
            this.saveBOTPRelationShip(ctx, pk, timeDepositBillInfo);
        }
        if ((sourceBillId = timeDepositBillInfo.getSourceBillId()) != null && new TimeDepositApplyInfo().getBOSType().equals((Object)BOSUuid.read((String)sourceBillId).getType())) {
            HashMap<String, String> botpRelationShip = new HashMap<String, String>();
            botpRelationShip.clear();
            botpRelationShip.put(sourceBillId, pk.toString());
            FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
            TimeDepositApplyInfo timeDepositApplyInfo = TimeDepositApplyFactory.getLocalInstance(ctx).getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            BigDecimal applyAmount = timeDepositApplyInfo.getApplyAmount();
            BigDecimal totalDepositAmt = timeDepositBillInfo.getDepositAmt();
            String sql = "select sum(FDepositAmt) as totalAmt from T_TD_TimeDepositBill where fsourceBillId =? ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{timeDepositBillInfo.getSourceBillId()});
            try {
                if (rowSet.next() && rowSet.getBigDecimal("totalAmt") != null) {
                    totalDepositAmt = rowSet.getBigDecimal("totalAmt");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (applyAmount.compareTo(totalDepositAmt) < 0) {
                throw new TDException(TDException.OVERAPPLYAMOUNT);
            }
            if (applyAmount.compareTo(totalDepositAmt) == 0) {
                timeDepositApplyInfo.setIsTimeDepBank(1);
                TimeDepositApplyFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectStringPK(sourceBillId), (CoreBaseInfo)timeDepositApplyInfo);
            }
        }
        return pk;
    }

    protected void saveBOTPRelationShip(Context ctx, IObjectPK pk, TimeDepositBillInfo timeDepositBillInfo) throws BOSException {
        HashMap<String, String> botpRelationShip = new HashMap<String, String>();
        botpRelationShip.clear();
        botpRelationShip.put(timeDepositBillInfo.getSourceBillId().toString(), pk.toString());
        FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
    }

    protected void doUpdate(Context ctx, TimeDepositBillInfo timeDepositBillInfo) throws EASBizException, BOSException {
        String sql = "update T_TD_TimeDepositBill set FIsReDeposited = 1,FRemAmt = 0,FLastRecvIntDay=? where fid=? ";
        Date lastRecDate = new Date(timeDepositBillInfo.getBizDate().getTime());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{DateUtil.truncateSqlDate((Date)lastRecDate), timeDepositBillInfo.getSourceBillId()});
    }

    private void book(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        facade.book(TimeDepositBillBookNotifyBuilder.class.getName(), pk.toString());
        String sql = "update T_TD_TimeDepositBill set FIsBooked = 1 where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
    }

    protected void _delete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        TimeDepositBillInfo billInfo = (TimeDepositBillInfo)this.getValue(ctx, pk);
        if (billInfo.isIsAddedByReDeposit()) {
            this.doOtherWork(ctx, billInfo);
        }
        if (billInfo.isIsAddedByReceive()) {
            this.updateCompDepositBillStatus(ctx, billInfo);
        }
        this.antiBook(ctx, pk);
        String sourceBillId = billInfo.getSourceBillId();
        if (sourceBillId != null && new TimeDepositApplyInfo().getBOSType().equals((Object)BOSUuid.read((String)sourceBillId).getType())) {
            TimeDepositApplyInfo timeDepositApplyInfo = TimeDepositApplyFactory.getLocalInstance(ctx).getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            timeDepositApplyInfo.setIsTimeDepBank(0);
            TimeDepositApplyFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)timeDepositApplyInfo);
        }
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)billInfo, (String)billInfo.getCompany().getId().toString());
    }

    protected void doOtherWork(Context ctx, TimeDepositBillInfo billInfo) throws BOSException, EASBizException {
        this.deleteIntBill(ctx, billInfo.getId());
        this.reverseSourceBillAmt(ctx, billInfo);
        this.deleteBOTRelations(ctx, billInfo);
    }

    private void deleteBOTRelations(Context ctx, TimeDepositBillInfo billInfo) throws BOSException, BTPException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (!iBTPManager.ifHaveDestBills(billInfo.getSourceBillId())) {
            try {
                TimeDepositBillInfo info = new TimeDepositBillInfo();
                info.setId(BOSUuid.read((String)billInfo.getSourceBillId()));
                iBTPManager.removeAllSRCRelation((CoreBillBaseInfo)billInfo);
            }
            catch (BTPException ex) {
                throw new BTPException(BTPException.RELATIONDELETEERROR);
            }
        }
    }

    protected void updateCompDepositBillStatus(Context ctx, TimeDepositBillInfo billInfo) throws BOSException {
        String sql = "update t_fin_compdepositaccountbill set fisreceived=0 where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{billInfo.getComDepositBillID().toString()});
        if (billInfo.isIsAddedByReDeposit()) {
            String sql2 = "update t_fin_compintreceivedbill set fisreceived=0 where ftimedepositbillidid = ?";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new String[]{billInfo.getComDepositBillID().toString()});
        }
    }

    private void deleteIntBill(Context ctx, BOSUuid pk) throws BOSException, EASBizException {
        IntReceivedBillFactory.getLocalInstance(ctx).deleteRelated((IObjectPK)new ObjectUuidPK(pk));
    }

    private void antiBook(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        facade.antiBook(pk.toString());
        String sql = "update T_TD_TimeDepositBill set FIsBooked = 0 where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
    }

    private void reverseSourceBillAmt(Context ctx, TimeDepositBillInfo billInfo) throws BOSException, EASBizException {
        String sql = "update t_td_timedepositbill set FIsReDeposited = 0,fremamt = fremamt + " + billInfo.getDepositAmt().subtract(billInfo.getAccrualToDepositAmt()) + " where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{billInfo.getSourceBillId()});
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            TimeDepositBillInfo info = (TimeDepositBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected void _setBillStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected Map _receiveFromCompDeposit(Context ctx, Set compDepositBillIDs) throws BOSException, EASBizException {
        return BillReceiver.receive(ctx, compDepositBillIDs, 0, null);
    }
}

