/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompDepositBillStatusEnum;
import com.kingdee.eas.fm.fin.CompIntReceivedBillCollection;
import com.kingdee.eas.fm.fin.CompIntReceivedBillFactory;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillCollection;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillFactory;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillInfo;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.UnTimeDepositBillCollection;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;
import com.kingdee.eas.fm.td.app.BillReceiverUtils;
import com.kingdee.eas.fm.td.app.IBillReceive;
import com.kingdee.eas.fm.td.app.ReceiveTestUtil;
import com.kingdee.eas.fm.td.app.UnDepositSeqInfo;
import com.kingdee.eas.fm.td.app.UnDepositSeqInfoList;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UnDepositBillReceiver
extends BillReceiverUtils
implements IBillReceive {
    private static UnDepositBillReceiver dbr = null;

    private UnDepositBillReceiver() {
    }

    public static UnDepositBillReceiver getInstance() {
        if (dbr == null) {
            dbr = new UnDepositBillReceiver();
        }
        return dbr;
    }

    private AccountBankInfo getBankAccountByInnerAccount(Context ctx, InnerAccountInfo innerAccount) throws BOSException {
        return FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)innerAccount);
    }

    @Override
    public Map receive(Context ctx, Set ids, AccountBankInfo acctBank) throws BOSException, EASBizException {
        UnDepositSeqInfoList allInfoList = this.getMaxReceivedUnTimeDePosit(ctx, ids);
        StringBuffer errMsgBody = new StringBuffer();
        HashSet<String> receivedBill = new HashSet<String>();
        CompUnTimeDepositBillCollection col = this.getCompUnDepositToBeReceived(ctx, ids);
        for (int i = 0; i < col.size(); ++i) {
            CompUnTimeDepositBillInfo info = col.get(i);
            this.checkValid(ctx, allInfoList, info);
            receivedBill.add(this.innerReceive(ctx, info, acctBank));
        }
        HashMap<String, Serializable> mapReturn = new HashMap<String, Serializable>();
        mapReturn.put("receivedBillId", receivedBill);
        mapReturn.put("errorMsg", errMsgBody);
        return mapReturn;
    }

    private void checkValid(Context ctx, UnDepositSeqInfoList allInfoList, CompUnTimeDepositBillInfo info) throws EASBizException, BOSException {
        for (int i = 0; i < allInfoList.size(); ++i) {
            UnDepositSeqInfo unDepositSeqInfo = allInfoList.getIndex(i);
            if (!unDepositSeqInfo.getDepositID().equals(info.getTimeDepositBill().getId().toString()) || !unDepositSeqInfo.getUnDepositID().equals(info.getId().toString()) || unDepositSeqInfo.getMaxSeq() >= info.getUnTimeDepositSeqNo()) continue;
            throw new TDException(TDException.RECEIVE_UNDE_ERROR1);
        }
        this.checkSourceBillReceived(ctx, info);
    }

    private void checkSourceBillReceived(Context ctx, CompUnTimeDepositBillInfo comp) throws BOSException, EASBizException {
        if (comp.getTimeDepositBill() == null) {
            throw new TDException(TDException.RECEIVE_UNDE_ERROR2);
        }
        String sql = "select fisreceived from t_fin_compdepositaccountbill  where fid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{comp.getTimeDepositBill().getId().toString()});
        try {
            int isreceived;
            if (rs.next() && (isreceived = rs.getInt(1)) == 0 && null == FMHelper.checkIsExistsTimeDeposit((Context)ctx, (String)comp.getTimeDepositBill().getId().toString())) {
                throw new TDException(TDException.RECEIVE_UNDE_ERROR2);
            }
        }
        catch (SQLException e) {
            throw new TDException(TDException.RECEIVE_UNDE_ERROR2);
        }
        if (comp.getCorpCurAcct() == null && (comp.getDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || comp.getDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) ? FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)comp.getCorpDepAcct()) == null : FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)comp.getCorpDepAcct()) == null || FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)comp.getCorpCurAcct()) == null) {
            throw new TDException(TDException.RECEIVE_ERROR_NO_BANKACCOUNT);
        }
    }

    private String innerReceive(Context ctx, CompUnTimeDepositBillInfo compUnDe, AccountBankInfo acctBank) throws BOSException, EASBizException {
        UnTimeDepositBillInfo utdbi = new UnTimeDepositBillInfo();
        this.copyProperties((CoreBaseInfo)utdbi, (CoreBaseInfo)compUnDe);
        utdbi.setMyBizDate(DateUtil.getDayBegin());
        this.setPayeeBankAccount(ctx, compUnDe, utdbi, acctBank);
        this.setOtherValueForUnTimeDeposit(utdbi);
        CompDepositAccountBillInfo sourceCompInfo = compUnDe.getTimeDepositBill();
        if (sourceCompInfo == null) {
            throw new TDException(TDException.RECEIVE_UNDE_ERROR3);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcBillID", (Object)compUnDe.getId().toString(), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        CompIntReceivedBillCollection col = CompIntReceivedBillFactory.getLocalInstance((Context)ctx).getCompIntReceivedBillCollection(evi);
        CompIntReceivedBillInfo compIntReceivedBillInfo = col.get(0);
        if (compIntReceivedBillInfo != null && compIntReceivedBillInfo.getEffectedStatus() != CompDepositBillStatusEnum.ACCEPTED) {
            throw new TDException(TDException.INTBILLUNACCEPT);
        }
        IntReceivedBillInfo intBillInfo = new IntReceivedBillInfo();
        if (compIntReceivedBillInfo != null) {
            AccountBankInfo accountBankInfo = FSHelper.getVirtualAcctBankByInnerAcct((Context)ctx, (InnerAccountInfo)compIntReceivedBillInfo.getCorpCurAcct());
            if (accountBankInfo == null) {
                throw new TDException(TDException.RECEIVE_ERROR_NO_BANKACCOUNT);
            }
            this.copyProperties((CoreBaseInfo)intBillInfo, (CoreBaseInfo)compIntReceivedBillInfo);
            intBillInfo.setCorpCurAcct(accountBankInfo);
        }
        this.setOriginalTimeDepositBill(ctx, (CoreBaseInfo)utdbi, intBillInfo, compUnDe.getTimeDepositBill().getId().toString());
        this.doReceive(ctx, (CoreBaseInfo)intBillInfo, utdbi, compIntReceivedBillInfo, (CoreBaseInfo)compUnDe);
        return utdbi.getId().toString();
    }

    private void setPayeeBankAccount(Context ctx, CompUnTimeDepositBillInfo compUnDe, UnTimeDepositBillInfo utdbi, AccountBankInfo acctBank) throws BOSException {
        if (compUnDe.getCorpCurAcct() == null && (compUnDe.getDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || compUnDe.getDepositType() == TimeDepositTypeEnum.CALLDEPOSIT_OUTER)) {
            utdbi.setPayeeBankAccount(acctBank);
        } else {
            utdbi.setPayeeBankAccount(this.getBankAccountByInnerAccount(ctx, compUnDe.getCorpCurAcct()));
        }
    }

    private void setOtherValueForUnTimeDeposit(UnTimeDepositBillInfo utdbi) {
    }

    private CompUnTimeDepositBillCollection getCompUnDepositToBeReceived(Context ctx, Set ids) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return CompUnTimeDepositBillFactory.getLocalInstance((Context)ctx).getCompUnTimeDepositBillCollection(evi);
    }

    @Override
    public Map receiveTest(Context ctx, Set ids) throws BOSException, EASBizException {
        UnDepositSeqInfoList allInfoList = ReceiveTestUtil.getMaxReceivedUnTimeDePosit(ctx, ids);
        StringBuffer errMsgBody = new StringBuffer();
        HashSet<String> receivedBill = new HashSet<String>();
        UnTimeDepositBillCollection col = ReceiveTestUtil.getUnCompDepositToBeReceived(ctx, ids);
        for (int i = 0; i < col.size(); ++i) {
            UnTimeDepositBillInfo comp = col.get(i);
            try {
                this.checkValid(allInfoList, comp);
                receivedBill.add(this.receiveTest(ctx, comp));
                continue;
            }
            catch (Exception e) {
                errMsgBody.append(comp.getNumber()).append(this.errorMsgHeader).append(e.getMessage()).append("\n");
            }
        }
        HashMap<String, Serializable> mapReturn = new HashMap<String, Serializable>();
        mapReturn.put("receivedBillId", receivedBill);
        mapReturn.put("errorMsg", errMsgBody);
        return mapReturn;
    }

    private void checkValid(UnDepositSeqInfoList allInfoList, UnTimeDepositBillInfo info) throws TDException {
        for (int i = 0; i < allInfoList.size(); ++i) {
            UnDepositSeqInfo unDepositSeqInfo = allInfoList.getIndex(i);
            if (!unDepositSeqInfo.getDepositID().equals(info.getTimeDepositBill().getId().toString()) || !unDepositSeqInfo.getUnDepositID().equals(info.getId().toString()) || unDepositSeqInfo.getMaxSeq() >= info.getUnTimeDepositSeqNo()) continue;
            throw new TDException(TDException.RECEIVE_UNDE_ERROR1);
        }
    }

    private String receiveTest(Context ctx, UnTimeDepositBillInfo comp) throws BOSException, EASBizException {
        UnTimeDepositBillInfo utdbi = new UnTimeDepositBillInfo();
        ReceiveTestUtil.copyProperties((CoreBaseInfo)utdbi, (CoreBaseInfo)comp);
        IntReceivedBillInfo compIntReceivedBillInfo = ReceiveTestUtil.getComIntReceivedBillInfoBySrcID(ctx, comp.getId().toString());
        if (compIntReceivedBillInfo == null) {
            return "";
        }
        IntReceivedBillInfo intBillInfo = new IntReceivedBillInfo();
        ReceiveTestUtil.copyProperties((CoreBaseInfo)intBillInfo, (CoreBaseInfo)compIntReceivedBillInfo);
        ReceiveTestUtil.setOtherValueForIntBill(intBillInfo, utdbi);
        String sql = "select fid from t_td_timedepositbill where fcomdepositbillid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{utdbi.getSourceBillId()});
        String id = null;
        try {
            if (rs.next()) {
                id = rs.getString(1);
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        TimeDepositBillInfo info = new TimeDepositBillInfo();
        info.setId(BOSUuid.read((String)id));
        intBillInfo.setTimeDepositBillID(info);
        intBillInfo.getTimeDepositBillInfo().setSourceBillId(id);
        utdbi.setTimeDepositBill(info);
        IntReceivedBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)intBillInfo);
        return utdbi.getId().toString();
    }
}

