/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fin.CompDepositAccountBillFactory;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.td.ApplyBillStatusEnum;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillCollection;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillInfo;
import com.kingdee.eas.fm.td.app.AbstractUnTimeDepositApplyBillControllerBean;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class UnTimeDepositApplyBillControllerBean
extends AbstractUnTimeDepositApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.td.app.UnTimeDepositApplyBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UnTimeDepositApplyBillInfo info = (UnTimeDepositApplyBillInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)info);
        this.checkApplyAmountMoreThanLimit(ctx, info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UnTimeDepositApplyBillInfo info = (UnTimeDepositApplyBillInfo)model;
        info.setBillState(ApplyBillStatusEnum.SUBMIT);
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        info = UnTimeDepositApplyBillFactory.getLocalInstance(ctx).getUnTimeDepositApplyBillInfo((IObjectPK)new ObjectUuidPK(info.getId()));
        this.checkNumberDup(ctx, (IObjectValue)info);
        this.checkApplyAmountMoreThanLimit(ctx, info);
        return pk;
    }

    private void checkApplyAmountMoreThanLimit(Context ctx, UnTimeDepositApplyBillInfo info) throws BOSException, EASBizException {
        EntityViewInfo viewBill = new EntityViewInfo();
        FilterInfo filterInfoBill = new FilterInfo();
        filterInfoBill.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getSourceBillId(), CompareType.EQUALS));
        filterInfoBill.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        viewBill.setFilter(filterInfoBill);
        UnTimeDepositApplyBillCollection applyBillCollection = UnTimeDepositApplyBillFactory.getLocalInstance(ctx).getUnTimeDepositApplyBillCollection(viewBill);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)applyBillCollection)) {
            TimeDepositBillInfo timeDepositBillInfo;
            CompDepositAccountBillInfo compDepAcctBillInfo;
            BigDecimal sumApplyAmount = info.getApplyAmount();
            for (int i = 0; i < applyBillCollection.size(); ++i) {
                sumApplyAmount = sumApplyAmount.add(applyBillCollection.get(0).getApplyAmount());
            }
            BOSUuid sbid = BOSUuid.read((String)info.getSourceBillId());
            BigDecimal amount = new BigDecimal(0);
            if (sbid.getType().equals((Object)new CompDepositAccountBillInfo().getBOSType()) && sumApplyAmount.compareTo(amount = (compDepAcctBillInfo = CompDepositAccountBillFactory.getLocalInstance((Context)ctx).getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()))).getAmount()) > 0) {
                throw new TDException(TDException.APPLY_AMOUNT_MORE_THAN_LIMIT);
            }
            if (sbid.getType().equals((Object)new TimeDepositBillInfo().getBOSType()) && sumApplyAmount.compareTo(amount = (timeDepositBillInfo = TimeDepositBillFactory.getLocalInstance(ctx).getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()))).getDepositAmt()) > 0) {
                throw new TDException(TDException.APPLY_AMOUNT_MORE_THAN_LIMIT);
            }
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UnTimeDepositApplyBillInfo info = (UnTimeDepositApplyBillInfo)model;
        if (info.getBillState() == null || !info.getBillState().equals((Object)ApplyBillStatusEnum.AUDITED)) {
            info.setBillState(ApplyBillStatusEnum.SAVE);
        }
        try {
            FMHelper.initNumber((Context)ctx, (BillBaseInfo)info, (AbstractCoreBaseControllerBean)this);
        }
        catch (Exception ex) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        this.checkNumberDup(ctx, (IObjectValue)info);
        this.checkApplyAmountMoreThanLimit(ctx, info);
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        return pk;
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UnTimeDepositApplyBillInfo applyInfo = (UnTimeDepositApplyBillInfo)UnTimeDepositApplyBillFactory.getLocalInstance(ctx).getValue(pk);
        if (applyInfo.isIsCreCmpUnTmDep() || applyInfo.isIsGenUnTDBill()) {
            throw new TDException(TDException.APPLYED);
        }
        if (applyInfo.getBillState() != ApplyBillStatusEnum.AUDITED) {
            throw new TDException(TDException.CANNOTUNAUDIT, new Object[]{applyInfo.getNumber()});
        }
        applyInfo.setBillState(ApplyBillStatusEnum.SAVE);
        this.update(ctx, pk, (CoreBaseInfo)applyInfo);
    }

    @Override
    protected void _antiAuditBatch(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator iterator = idSet.iterator();
        while (iterator.hasNext()) {
            this.antiAudit(ctx, (IObjectPK)new ObjectUuidPK(iterator.next().toString()));
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UnTimeDepositApplyBillInfo applyInfo = UnTimeDepositApplyBillFactory.getLocalInstance(ctx).getUnTimeDepositApplyBillInfo(pk);
        if (applyInfo.getBillState() != ApplyBillStatusEnum.SUBMIT) {
            throw new TDException(TDException.CANNOTAUDIT, new Object[]{applyInfo.getNumber()});
        }
        applyInfo.setBillState(ApplyBillStatusEnum.AUDITED);
        this.update(ctx, pk, (CoreBaseInfo)applyInfo);
    }

    @Override
    protected void _auditBatch(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator iterator = idSet.iterator();
        while (iterator.hasNext()) {
            this.audit(ctx, (IObjectPK)new ObjectUuidPK(iterator.next().toString()));
        }
    }

    @Override
    protected void _submitBank(Context ctx, IObjectPK pk) throws BOSException {
    }
}

