/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.td.UnTimeDepositBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;

public class UnTimeDepositBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        UnTimeDepositBillInfo unTtimeDepositBill = this.getUnTimeDepositBillInfo(ctx, billId);
        if (!unTtimeDepositBill.isIsHis()) {
            JournalInfo cJournal;
            JournalInfo dJournal;
            if (unTtimeDepositBill.getPayeeBankAccount() != null && (dJournal = this.createJournal(unTtimeDepositBill, "D")).getAccountBank().isIsBank()) {
                journalCollection.add(dJournal);
            }
            if (unTtimeDepositBill.getTimeDepositBill() != null && unTtimeDepositBill.getTimeDepositBill().getBankDepAcct() != null && (cJournal = this.createJournal(unTtimeDepositBill, "C")).getAccountBank().isIsBank()) {
                journalCollection.add(cJournal);
            }
        }
        return journalCollection;
    }

    private JournalInfo createJournal(UnTimeDepositBillInfo untimeDepositBill, String type) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        this.setDC(untimeDepositBill, journalInfo, type);
        journalInfo.setCurrency(untimeDepositBill.getCurrency());
        journalInfo.setCreateDate(untimeDepositBill.getMyBizDate());
        journalInfo.setBizDate(untimeDepositBill.getMyBizDate());
        journalInfo.setDescription(untimeDepositBill.getDescription());
        journalInfo.setCompany(untimeDepositBill.getCompany());
        journalInfo.setBillId(untimeDepositBill.getId().toString());
        journalInfo.setBillNumber(untimeDepositBill.getNumber());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillType(BillTypeEnum.UnDepositAccount);
        return journalInfo;
    }

    private void setDC(UnTimeDepositBillInfo untimeDepositBill, JournalInfo journalInfo, String type) {
        if ("D".equalsIgnoreCase(type)) {
            journalInfo.setAccountBank(untimeDepositBill.getPayeeBankAccount());
            journalInfo.setDebitAmount(untimeDepositBill.getUnDepositAmt());
            journalInfo.setAccountView(untimeDepositBill.getPayeeBankAccount().getAccount());
        } else {
            journalInfo.setAccountBank(untimeDepositBill.getTimeDepositBill().getBankDepAcct());
            journalInfo.setCreditAmount(untimeDepositBill.getUnDepositAmt());
            journalInfo.setAccountView(untimeDepositBill.getTimeDepositBill().getBankDepAcct().getAccount());
        }
    }

    private UnTimeDepositBillInfo getUnTimeDepositBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        return UnTimeDepositBillFactory.getLocalInstance(ctx).getUnTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("payeeBankAccount.id");
        cel.add("payeeBankAccount.isBank");
        cel.add("payeeBankAccount.account.id");
        cel.add("timeDepositBill.bankDepAcct.id");
        cel.add("timeDepositBill.bankDepAcct.isBank");
        cel.add("timeDepositBill.bankDepAcct.account.id");
        return cel;
    }
}

