/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.td.IntReceivedBillCollection;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillInfo;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;
import com.kingdee.eas.fm.td.app.AbstractUnTimeDepositBillControllerBean;
import com.kingdee.eas.fm.td.app.BillReceiver;
import com.kingdee.eas.fm.td.app.UnTimeDepositBillBookNotifyBuilder;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UnTimeDepositBillControllerBean
extends AbstractUnTimeDepositBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.td.app.UnTimeDepositBillControllerBean");

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            UnTimeDepositBillInfo info = (UnTimeDepositBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setFivouchered(true);
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    protected IntReceivedBillInfo findIntReceivedBillInfo(Context ctx, IObjectPK srcBillPK) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("srcBillID", (Object)srcBillPK.toString()));
        evi.setFilter(f);
        IntReceivedBillCollection intCol = IntReceivedBillFactory.getLocalInstance(ctx).getIntReceivedBillCollection(evi);
        if (intCol != null && intCol.size() > 0) {
            return intCol.get(0);
        }
        return null;
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        DAPTransformResult dAPTransformResult = super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"TD009")) {
            for (int i = 0; i < sourceBillCollection.size(); ++i) {
                ObjectUuidPK srcBillPK = new ObjectUuidPK(AccessHelper.getId((Object)sourceBillCollection.getObject(i)));
                IntReceivedBillInfo intRe = this.findIntReceivedBillInfo(ctx, (IObjectPK)srcBillPK);
                if (intRe == null || intRe.isFivouchered() || intRe.getCreInterest().compareTo(Constants.ZERO) == 0 && intRe.getDeInterest().compareTo(Constants.ZERO) == 0) continue;
                try {
                    IntReceivedBillFactory.getLocalInstance(ctx).generateVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
                    continue;
                }
                catch (EASBizException e) {
                    if (e instanceof BOTPException && "803".equals(((BOTPException)e).getSubCode())) {
                        throw new TDException(TDException.INTRECEIVEBILLNOMAPPING);
                    }
                    throw e;
                }
            }
        }
        return dAPTransformResult;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        IntReceivedBillInfo intRe;
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"TD009") && (intRe = this.findIntReceivedBillInfo(ctx, sourceBillPk)) != null && intRe.isFivouchered()) {
            IntReceivedBillFactory.getLocalInstance(ctx).deleteVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
        }
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UnTimeDepositBillInfo info = (UnTimeDepositBillInfo)model;
        try {
            FMHelper.initNumber((Context)ctx, (BillBaseInfo)info, (AbstractCoreBaseControllerBean)this);
        }
        catch (Exception ex) {
            throw new FMException(FMException.BOTP_ERROR);
        }
        this.checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected Map _getMaxUnDepositSeqAndAccumalateAmt(Context ctx, IObjectPK timeDepositBillID) throws BOSException {
        int maxUnDepositSeq = 0;
        BigDecimal accumulativeuntimedepostamt = null;
        Date maxBizDate = null;
        HashMap<String, Serializable> returnValue = new HashMap<String, Serializable>();
        String sql = "select max(funtimedepositseqno),max(faccumulativeuntimedepostamt),max(fbizdate) from t_td_untimedepositbill where ftimedepositbillid=? ";
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, timeDepositBillID.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                maxUnDepositSeq = rs.getInt(1);
                accumulativeuntimedepostamt = rs.getBigDecimal(2);
                maxBizDate = rs.getDate(3);
            }
            if (accumulativeuntimedepostamt == null) {
                accumulativeuntimedepostamt = Constants.ZERO;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        returnValue.clear();
        returnValue.put("UNDEPOSIT_MAX_SEQ", new Integer(maxUnDepositSeq));
        returnValue.put("UNDEPOSIT_ACCUMULATE_AMT", accumulativeuntimedepostamt);
        returnValue.put("maxBizDate", maxBizDate);
        return returnValue;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.submitCheck(ctx, (UnTimeDepositBillInfo)model);
        IObjectPK pkReturn = super._submit(ctx, model);
        UnTimeDepositBillInfo unTimeDepositBillInfo = (UnTimeDepositBillInfo)model;
        this.updateLastDateOfUnde(ctx, unTimeDepositBillInfo);
        int val = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS001", (IObjectPK)new ObjectUuidPK(unTimeDepositBillInfo.getCompany().getId()));
        boolean valTD008 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TD008", (IObjectPK)new ObjectUuidPK(unTimeDepositBillInfo.getCompany().getId()));
        if (val == 0 && valTD008 && !unTimeDepositBillInfo.isIsBooked()) {
            this.book(ctx, pkReturn);
        }
        this.saveBOTPRelations(ctx, pkReturn, unTimeDepositBillInfo);
        this.deductRemamt(ctx, unTimeDepositBillInfo.getUnDepositAmt(), unTimeDepositBillInfo.getTimeDepositBill().getId().toString());
        this.updateStatusToTimedePositAdd(ctx, unTimeDepositBillInfo);
        this.updateUnTimeDepositApply(ctx, unTimeDepositBillInfo, 1);
        return pkReturn;
    }

    protected void submitCheck(Context ctx, UnTimeDepositBillInfo info) throws BOSException, EASBizException {
        this.checkUnDepositSeq(ctx, info);
        this.checkDepositBalance(ctx, info);
    }

    private void checkDepositBalance(Context ctx, UnTimeDepositBillInfo info) throws BOSException, EASBizException {
        String sql = "select FRemAmt from t_td_timedepositbill where fid = ?";
        try {
            BigDecimal balance;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getTimeDepositBill().getId().toString()});
            if (rs.next() && (balance = rs.getBigDecimal(1)) != null && balance.compareTo(Constants.ZERO) == 0) {
                throw new TDException(TDException.NOT_UNDEPOSIT_REASON2);
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkUnDepositSeq(Context ctx, UnTimeDepositBillInfo info) throws BOSException, EASBizException {
        String sql = "select fid from t_td_untimedepositbill where ftimedepositbillid = ? and funtimedepositseqno = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getTimeDepositBill().getId().toString(), new Integer(info.getUnTimeDepositSeqNo())});
            if (rs.next()) {
                throw new TDException(TDException.UNDEPSOITSEQ_ERROR, new Object[]{new Integer(info.getUnTimeDepositSeqNo())});
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void updateLastDateOfUnde(Context ctx, UnTimeDepositBillInfo info) throws BOSException {
        String sql = "update t_td_untimedepositbill set FLastUnDepositDate= ( select FLastUnDepositDate from t_td_timedepositbill where fid = ?) where fid =? ".intern();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getTimeDepositBill().getId().toString(), info.getId().toString()});
    }

    protected void saveBOTPRelations(Context ctx, IObjectPK pkReturn, UnTimeDepositBillInfo unTimeDepositBillInfo) throws BOSException {
        String srcId;
        HashMap<String, String> botpRelationShip = new HashMap<String, String>();
        botpRelationShip.clear();
        String string = srcId = FMHelper.isEmpty((String)unTimeDepositBillInfo.getSourceBillId()) ? unTimeDepositBillInfo.getTimeDepositBill().getId().toString() : unTimeDepositBillInfo.getSourceBillId();
        if (FMHelper.isEmpty((String)srcId)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"303_LoanEditUI"));
        }
        botpRelationShip.put(srcId, pkReturn.toString());
        FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
    }

    private void book(Context ctx, IObjectPK pkReturn) throws BOSException, EASBizException {
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        facade.book(UnTimeDepositBillBookNotifyBuilder.class.getName(), pkReturn.toString());
        String sql = "update T_TD_UnTimeDepositBill set FIsBooked = 1 where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{pkReturn.toString()});
    }

    protected void deductRemamt(Context ctx, BigDecimal unDepositAmt, String timeBillid) throws BOSException {
        String sql = "update t_td_timedepositbill set fremamt = fremamt - ? where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{unDepositAmt, timeBillid});
    }

    protected void _delete(Context ctx, IObjectPK utdPk) throws EASBizException, BOSException {
        UnTimeDepositBillInfo utdBillInfo = this.getUnTimeDepositBillInfo(ctx, utdPk);
        String sourceBill = utdBillInfo.getTimeDepositBill().getId().toString();
        this.deleteRalatedIntBill(ctx, utdPk);
        this.deductRemamt(ctx, utdBillInfo.getUnDepositAmt().negate(), sourceBill);
        this.antiBook(ctx, utdPk);
        if (utdBillInfo.isIsAddedByReceive()) {
            this.updateCompDepositBillStatus(ctx, utdBillInfo, 0);
        }
        this.deleteBOTRelations(ctx, utdBillInfo);
        this.updateLastDateOfUnde(ctx, utdBillInfo);
        super._delete(ctx, utdPk);
        this.updateStatusToTimedePositDel(ctx, utdBillInfo);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)utdBillInfo, (String)utdBillInfo.getCompany().getId().toString());
        this.updateUnTimeDepositApply(ctx, utdBillInfo, 0);
    }

    protected void deleteBOTRelations(Context ctx, UnTimeDepositBillInfo billInfo) throws BOSException, BTPException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (!iBTPManager.ifHaveDestBills(billInfo.getTimeDepositBill().getId().toString())) {
            try {
                TimeDepositBillInfo info = new TimeDepositBillInfo();
                info.setId(billInfo.getTimeDepositBill().getId());
                iBTPManager.removeAllSRCRelation((CoreBillBaseInfo)billInfo);
            }
            catch (BTPException ex) {
                throw new BTPException(BTPException.RELATIONDELETEERROR);
            }
        }
    }

    protected void deleteRalatedIntBill(Context ctx, IObjectPK utdPk) throws EASBizException, BOSException {
        IntReceivedBillFactory.getLocalInstance(ctx).deleteRelated(utdPk);
    }

    private void updateUnTimeDepositApply(Context ctx, UnTimeDepositBillInfo billInfo, int oprtState) throws BOSException {
        String srcBillID = billInfo.getSourceBillId();
        if (!FMHelper.isEmpty((String)srcBillID) && FMHelper.isInstanceof((String)srcBillID, UnTimeDepositApplyBillInfo.class)) {
            String sql = "update T_TD_UnTimeDepositApplyBill set FIsGenUnTDBill=? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(oprtState), srcBillID});
        }
    }

    protected void updateCompDepositBillStatus(Context ctx, UnTimeDepositBillInfo billInfo, int i) throws BOSException {
        String sql = "update T_FIN_UnTimeDepositBill set fisreceived=? where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0), billInfo.getComUnDepositBillID().toString()});
    }

    protected void updateStatusToTimedePositAdd(Context ctx, UnTimeDepositBillInfo unTimeDepositBillInfo) throws BOSException {
        String sql = "update  t_td_timedepositbill set fisundeposit = 1 where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{unTimeDepositBillInfo.getTimeDepositBill().getId().toString()});
    }

    protected void updateStatusToTimedePositDel(Context ctx, UnTimeDepositBillInfo unTimeDepositBillInfo) throws BOSException {
        String sql = "update  t_td_timedepositbill set fisundeposit = 0 where not exists (select fid from t_td_untimedepositbill where ftimedepositbillid = ? ) and fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{unTimeDepositBillInfo.getTimeDepositBill().getId().toString(), unTimeDepositBillInfo.getTimeDepositBill().getId().toString()});
    }

    private void antiBook(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        facade.antiBook(pk.toString());
        String sql = "update t_td_untimedepositbill set FIsBooked = 0 where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
    }

    @Override
    protected java.util.Date _getMaxUnDepositDateByTiemDeposit(Context ctx, String timeDepositBillID) throws BOSException {
        java.util.Date returnDate = null;
        String sql = "select max(fbizdate) from t_td_untimedepositbill where ftimedepositbillid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{timeDepositBillID});
        try {
            Date sqlDate;
            if (rs.next() && (sqlDate = rs.getDate(1)) != null) {
                returnDate = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date(sqlDate.getTime()));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnDate;
    }

    @Override
    protected Map _receiveFromCompUnDeposit(Context ctx, Set ids, AccountBankInfo acctBank) throws BOSException, EASBizException {
        return BillReceiver.receive(ctx, ids, 1, acctBank);
    }
}

