/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.AffairBizHistoryFactory;
import com.kingdee.eas.hr.affair.AffairBizHistoryInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.IAffairBizCheckFacade;
import com.kingdee.eas.hr.affair.LoanInBizBillEntryInfo;
import com.kingdee.eas.hr.affair.app.HRAffairBillBizBean;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.LoanOwnerEnum;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.FluctuationInOutInfo;
import com.kingdee.eas.hr.emp.app.util.FluctuationInOutUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Map;

public class LoanInBillBizBean
extends HRAffairBillBizBean {
    @Override
    protected boolean isCheckPersonInPool() {
        return false;
    }

    @Override
    protected boolean isCheckPersonLoanOut() {
        return false;
    }

    @Override
    protected void saveAffairHistory(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        String billField = this.getBillField();
        String entryBizDate = this.getEntryEffectDateField();
        if (StringUtils.isEmpty((String)billField)) {
            return;
        }
        HRBillBaseInfo bill = (HRBillBaseInfo)entry.get(billField);
        if (bill != null) {
            AffairBizHistoryInfo historyInfo = new AffairBizHistoryInfo();
            historyInfo.setBillID(bill.getId());
            historyInfo.setBillBOSType(bill.getBOSType().toString());
            historyInfo.setBillAdmin(bill.getAdminOrg());
            historyInfo.setHrOrgUnit(bill.getHrOrgUnit());
            historyInfo.setEntryID(entry.getId());
            if (entry.get("owner") != null) {
                historyInfo.setOwner(LoanOwnerEnum.getEnum((String)entry.get("owner").toString()));
            }
            AdminOrgUnitInfo oldAdmin = null;
            AdminOrgUnitInfo newAdmin = null;
            PositionInfo oldPosition = null;
            PositionInfo newPosition = null;
            if (!StringUtils.isEmpty((String)entryBizDate)) {
                historyInfo.setEffectDate(entry.getDate(entryBizDate));
            }
            if (!StringUtils.isEmpty((String)this.getPersonField())) {
                historyInfo.setPerson((PersonInfo)entry.get(this.getPersonField()));
            }
            if (!StringUtils.isEmpty((String)this.getOldAdminField())) {
                oldAdmin = (AdminOrgUnitInfo)entry.get(this.getOldAdminField());
                historyInfo.setOldAdmin(oldAdmin);
            }
            if (!StringUtils.isEmpty((String)this.getNewAdminField())) {
                newAdmin = (AdminOrgUnitInfo)entry.get(this.getNewAdminField());
                historyInfo.setNewAdmin(newAdmin);
            }
            if (!StringUtils.isEmpty((String)this.getOldPositionField())) {
                oldPosition = (PositionInfo)entry.get(this.getOldPositionField());
                historyInfo.setOldPosition(oldPosition);
            }
            if (!StringUtils.isEmpty((String)this.getNewPositionField())) {
                newPosition = (PositionInfo)entry.get(this.getNewPositionField());
                historyInfo.setNewPosition(newPosition);
            }
            historyInfo.setTuned(false);
            this.setHistoryAdminInOut(historyInfo, oldAdmin, newAdmin, oldPosition, newPosition);
            AffairBizHistoryFactory.getLocalInstance(ctx).addnew(historyInfo);
        }
    }

    @Override
    protected void _check(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._check(ctx, entry);
        LoanInBizBillEntryInfo info = (LoanInBizBillEntryInfo)entry;
        FluctuationInOutInfo flucInOut = FluctuationInOutUtil.getPersonFlucInOutInfoNotCompleted((Context)ctx, (String)info.getPerson().getId().toString(), (boolean)true);
        if (flucInOut != null && flucInOut.getBizDate() != null && info.getBizDate() != null && DateTimeUtils.dayBefore((Date)info.getBizDate(), (Date)flucInOut.getBizDate())) {
            throw new HRAffairException(HRAffairException.LOANINDATE_BEFORE_PLANDATE, new Object[]{HRUtilExtend.getDateStringWithoutMininute((Date)flucInOut.getBizDate())});
        }
    }

    @Override
    protected BatchProcessedResult checkPersonInAffair(Context ctx, IAffairBizCheckFacade checkFacade, HRBillBaseInfo info, StringBuffer personIds, String billID, Map validMap) throws EASBizException, BOSException {
        validMap = this.getValidMapByBillInfo(ctx, info, validMap);
        validMap.put("uncheckedBillId", this.getUnCheckedBillIdBybosType(ctx, personIds, "6A86A84F"));
        BatchProcessedResult result = checkFacade.isPersonInAffairProcessByFlucIn(personIds.toString(), billID, validMap);
        return result;
    }
}

