/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.IServiceLocator;
import com.kingdee.bos.bsf.service.ServiceLocator;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.app.AbstractBudgetCompensationFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.IBgApi;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ObjectUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BudgetCompensationFacadeControllerBean
extends AbstractBudgetCompensationFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.BudgetCompensationFacadeControllerBean");
    private List noUsedItem = null;

    protected IObjectCollection _getBgScheme(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        CoreBaseCollection bgSchemeCols = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isFormal", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        ev.getSorter().add(new SorterItemInfo("number"));
        ev.setFilter(filter);
        if (orgUnitId != null) {
            IServiceLocator service = ServiceLocator.getInstance();
            IBgApi bgApi = (IBgApi)service.lookupService(ctx, "MA.BD.BgApi");
            bgSchemeCols = bgApi.getBgSchemeLocaleInstance(ctx).getCollection(ev);
        }
        return bgSchemeCols;
    }

    protected IObjectCollection _getBgData(Context ctx, BOSUuid bgFormId, BOSUuid bgPeriodId) throws BOSException, EASBizException {
        String sql = "select id,bgValue,formula where bgFormId.id = '" + bgFormId + "' and bgPeriod.id = '" + bgFormId + "'";
        IServiceLocator service = ServiceLocator.getInstance();
        IBgApi bgApi = (IBgApi)service.lookupService(ctx, "MA.BD.BgApi");
        CoreBaseCollection bgDatas = bgApi.getBgDataLocaleInstance(ctx).getCollection(sql);
        return bgDatas;
    }

    private String getHistoryTable(Context ctx, CmpSchemeInfo scheme) throws EASBizException, BOSException {
        String oql = "select horTableName,hisTableName where id = '" + scheme.getId().toString() + "'";
        CmpSchemeInfo schemeInfo = CmpSchemeFactory.getLocalInstance((Context)ctx).getCmpSchemeInfo(oql);
        String tableName = schemeInfo.getHorTableName() + "@" + schemeInfo.getHisTableName();
        return tableName;
    }

    protected Map _getCmpSchemeData(Context ctx, CmpSchemeInfo[] schemes, CmpPeriodInfo[] cmpPeriods, List cmpItems) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        String historyTableName = null;
        int schemeLen = schemes.length;
        CmpSchemeInfo scheme = null;
        List list = null;
        IRowSet rowSet = null;
        try {
            this.noUsedItem = (List)ObjectUtils.createCopy((Object)cmpItems);
        }
        catch (CloneNotSupportedException e1) {
            throw new BOSException();
        }
        String cmpItemNumber = null;
        BigDecimal money = null;
        String cmpPeriodNumber = null;
        for (int i = 0; i < schemeLen; ++i) {
            scheme = schemes[i];
            historyTableName = this.getHistoryTable(ctx, scheme);
            if (historyTableName == null) continue;
            String[] tableName = historyTableName.split("@");
            for (int m = 0; m < tableName.length; ++m) {
                int j;
                if (tableName[m] == null || tableName[m].equals("null")) continue;
                StringBuffer oql = new StringBuffer();
                oql.append("select ");
                list = this.getCmpItemInCmpScheme(ctx, scheme, cmpItems);
                if (list == null || list.size() <= 0) continue;
                for (j = 0; j < list.size(); ++j) {
                    oql.append("sum(");
                    oql.append(list.get(j));
                    oql.append(")");
                    oql.append(" as ");
                    oql.append(list.get(j));
                    oql.append(",");
                }
                oql.append("fperiod ");
                oql.append(" from ");
                oql.append(tableName[m]);
                oql.append(" where fperiod in (");
                for (j = 0; j < cmpPeriods.length; ++j) {
                    if (j < cmpPeriods.length - 1) {
                        oql.append("'");
                        oql.append(cmpPeriods[j].getId().toString());
                        oql.append("'");
                        oql.append(",");
                        continue;
                    }
                    oql.append("'");
                    oql.append(cmpPeriods[j].getId().toString());
                    oql.append("'");
                }
                oql.append(")");
                oql.append(" group by fperiod ");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
                try {
                    rowSet.beforeFirst();
                    while (rowSet.next()) {
                        cmpPeriodNumber = CmpPeriodFactory.getLocalInstance((Context)ctx).getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rowSet.getString("fperiod")))).getNumber();
                        for (j = 0; j < list.size(); ++j) {
                            cmpItemNumber = list.get(j).toString();
                            if (map.containsKey(cmpItemNumber + "@" + cmpPeriodNumber)) {
                                money = (BigDecimal)map.get(cmpItemNumber + "@" + cmpPeriodNumber);
                                money = money.add(rowSet.getBigDecimal(cmpItemNumber));
                                map.put(cmpItemNumber + "@" + cmpPeriodNumber, money == null ? new BigDecimal("0.00") : money);
                                continue;
                            }
                            money = rowSet.getBigDecimal(cmpItemNumber);
                            map.put(cmpItemNumber + "@" + cmpPeriodNumber, money == null ? new BigDecimal("0.00") : money);
                        }
                    }
                    continue;
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        List noUsedItem = this.getNoUsedItem();
        int noUsedItemSize = noUsedItem.size();
        int cmpPeriodsLen = cmpPeriods.length;
        CmpItemInfo noUsedCmpItemInfo = null;
        cmpPeriodNumber = null;
        for (int i = 0; i < noUsedItemSize; ++i) {
            noUsedCmpItemInfo = (CmpItemInfo)noUsedItem.get(i);
            for (int j = 0; j < cmpPeriodsLen; ++j) {
                cmpPeriodNumber = cmpPeriods[j].getNumber();
                map.put(noUsedCmpItemInfo.getNumber() + "@" + cmpPeriodNumber, new BigDecimal("0.00"));
            }
        }
        return map;
    }

    private List getCmpItemInCmpScheme(Context ctx, CmpSchemeInfo cmpScheme, List cmpItems) throws EASBizException, BOSException {
        CmpSchemeItemCollection c = cmpScheme.getItems();
        ArrayList<String> list = new ArrayList<String>();
        if (c != null && c.size() > 0) {
            for (int i = 0; i < c.size(); ++i) {
                for (int j = 0; j < cmpItems.size(); ++j) {
                    CmpItemInfo tmp = (CmpItemInfo)cmpItems.get(j);
                    if (this.getCmpItemInfo(ctx, c.get(i)) == null || !this.getCmpItemInfo(ctx, c.get(i)).getNumber().equals(tmp.getNumber())) continue;
                    list.add(tmp.getNumber());
                    if (!this.noUsedItem.contains(tmp)) continue;
                    this.noUsedItem.remove(tmp);
                }
            }
        }
        return list;
    }

    private List getNoUsedItem() {
        return this.noUsedItem;
    }

    private CmpItemInfo getCmpItemInfo(Context ctx, CmpSchemeItemInfo schemeItemInfo) throws EASBizException, BOSException {
        String oql = "select cmpItem.id,cmpItem.number,cmpItem.name,isBGStat where id = '" + schemeItemInfo.getId().toString() + "'";
        CmpSchemeItemInfo schemeItem = CmpSchemeItemFactory.getLocalInstance((Context)ctx).getCmpSchemeItemInfo(oql);
        if (schemeItem.isIsBGStat()) {
            return schemeItem.getCmpItem();
        }
        return null;
    }
}

