/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.IServiceLocator;
import com.kingdee.bos.bsf.service.ServiceLocator;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.app.AbstractCmpBudgetFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.ma.nbudget.BudgetData;
import com.kingdee.eas.ma.nbudget.IBgApi;
import com.kingdee.eas.ma.nbudget.IBgFormApiInfo;
import com.kingdee.eas.ma.nbudget.IBgPeriodApiInfo;
import com.kingdee.eas.ma.nbudget.IBgTreeDataForOther;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpBudgetFacadeControllerBean
extends AbstractCmpBudgetFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.CmpBudgetFacadeControllerBean");
    private List noUsedItem = null;

    protected IObjectCollection _getBgScheme(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        IServiceLocator service = ServiceLocator.getInstance();
        IBgApi bgApi = (IBgApi)service.lookupService(ctx, "MA.BD.BgApi");
        return bgApi.getAllBgScheme(ctx, orgUnitId);
    }

    protected IObjectCollection _getBgData(Context ctx, BOSUuid bgFormId, BOSUuid bgPeriodId) throws BOSException, EASBizException {
        String sql = "select id,bgValue,formula where bgFormId.id = '" + bgFormId + "' and bgPeriod.id = '" + bgFormId + "'";
        IServiceLocator service = ServiceLocator.getInstance();
        IBgApi bgApi = (IBgApi)service.lookupService(ctx, "MA.BD.BgApi");
        CoreBaseCollection bgDatas = bgApi.getBgDataLocaleInstance(ctx).getCollection(sql);
        return bgDatas;
    }

    private String getHistoryTable(Context ctx, CmpSchemeInfo scheme, boolean isFromBugetAlert) throws EASBizException, BOSException {
        String tableName = null;
        if (isFromBugetAlert) {
            String oql = "select horTableName,hisTableName where id = '" + scheme.getId().toString() + "'";
            CmpSchemeInfo schemeInfo = CmpSchemeFactory.getLocalInstance((Context)ctx).getCmpSchemeInfo(oql);
            tableName = schemeInfo.getHorTableName() + "@" + schemeInfo.getHisTableName();
        } else {
            String oql = "select hisTableName where id = '" + scheme.getId().toString() + "'";
            CmpSchemeInfo schemeInfo = CmpSchemeFactory.getLocalInstance((Context)ctx).getCmpSchemeInfo(oql);
            tableName = schemeInfo.getHisTableName();
        }
        return tableName;
    }

    private List getCmpItemInCmpScheme(Context ctx, CmpSchemeInfo cmpScheme, List cmpItems) throws EASBizException, BOSException {
        ArrayList<String> list = new ArrayList<String>();
        if (cmpItems == null || cmpItems.size() == 0) {
            return list;
        }
        StringBuffer itemNumStr = new StringBuffer();
        for (int i = 0; i < cmpItems.size(); ++i) {
            if (i != 0) {
                itemNumStr.append(",");
            }
            itemNumStr.append("'").append(((CmpItemInfo)cmpItems.get(i)).getNumber()).append("'");
        }
        String oql = "select cmpItem.number where cmpScheme.id='" + cmpScheme.getId().toString() + "' and cmpItem.number in(" + itemNumStr + ") and isBGStat= 1";
        CmpSchemeItemCollection schemeItem = CmpSchemeItemFactory.getLocalInstance((Context)ctx).getCmpSchemeItemCollection(oql);
        CmpItemInfo tmp = null;
        CmpItemInfo tmpInfo = null;
        block1: for (int i = 0; i < schemeItem.size(); ++i) {
            tmp = schemeItem.get(i).getCmpItem();
            list.add(tmp.getNumber());
            int size = this.noUsedItem.size();
            for (int j = 0; j < size; ++j) {
                tmpInfo = (CmpItemInfo)this.noUsedItem.get(j);
                if (!tmpInfo.getNumber().equals(tmp.getNumber())) continue;
                this.noUsedItem.remove(j);
                continue block1;
            }
        }
        return list;
    }

    private List getNoUsedItem() {
        return this.noUsedItem;
    }

    private CmpItemInfo getCmpItemInfo(Context ctx, CmpSchemeItemInfo schemeItemInfo) throws EASBizException, BOSException {
        String oql = "select cmpItem.id,cmpItem.number,cmpItem.name,isBGStat where id = '" + schemeItemInfo.getId().toString() + "'";
        CmpSchemeItemInfo schemeItem = CmpSchemeItemFactory.getLocalInstance((Context)ctx).getCmpSchemeItemInfo(oql);
        if (schemeItem.isIsBGStat()) {
            return schemeItem.getCmpItem();
        }
        return null;
    }

    protected Map _getCmpInfo(Context ctx, Map bgParams) throws BOSException, EASBizException {
        HashMap<String, Object> cmpInfoMap = new HashMap<String, Object>();
        List orgList = (List)bgParams.get("orgList");
        ArrayList<String> orgIdList = new ArrayList<String>();
        IBgFormApiInfo bgFormInfo = (IBgFormApiInfo)bgParams.get("bgFormInfo");
        CoreBaseInfo bgSchemeInfo = (CoreBaseInfo)bgParams.get("bgSchemeInfo");
        int n = orgList.size();
        for (int i = 0; i < n; ++i) {
            OrgUnitInfo org = (OrgUnitInfo)orgList.get(i);
            orgIdList.add(org.getId().toString());
        }
        String schemeId = bgSchemeInfo.getId().toString();
        String bgFormId = bgFormInfo.getId().toString();
        IServiceLocator service = ServiceLocator.getInstance();
        IBgTreeDataForOther bgTreeData = (IBgTreeDataForOther)service.lookupService(ctx, "MA.BD.BgTreeData");
        List cmpNumList = bgTreeData.getHasBudgetSalaryNumbers(ctx, orgIdList, schemeId, bgFormId, "79D5E4F7");
        cmpInfoMap.put("cmpNumList", cmpNumList);
        List hroIdList = (List)bgParams.get("hroIdList");
        try {
            List schmList = this.getCmpScheme(ctx, hroIdList, cmpNumList);
            cmpInfoMap.put("schmList", schmList);
            String rootHroId = this.getRootHRUnitID(ctx, hroIdList);
            cmpInfoMap.put("rootHroId", rootHroId);
            List itemList = this.getCmpItem(ctx, rootHroId, cmpNumList);
            cmpInfoMap.put("itemList", itemList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        List mainDim = bgTreeData.getMainDimTypes(ctx, orgIdList, schemeId, bgFormId);
        cmpInfoMap.put("mainDim", mainDim);
        return cmpInfoMap;
    }

    private List getCmpScheme(Context ctx, List hroIdList, List cmpNumList) throws BOSException, SQLException, EASBizException {
        HashSet hrIdSet = new HashSet();
        hrIdSet.addAll(hroIdList);
        ArrayList<CmpSchemeInfo> schmList = new ArrayList<CmpSchemeInfo>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0, CompareType.EQUALS));
        String adminRangeSql = HRSchemeUtils.getAdminByUserRange((Context)ctx);
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)adminRangeSql, CompareType.INNER));
        filterInfo.setMaskString("#0 and #1");
        SorterItemInfo sorterItem = new SorterItemInfo("name");
        sorterItem.setSortType(SortType.ASCEND);
        viewInfo.setFilter(filterInfo);
        viewInfo.getSorter().add(sorterItem);
        ICmpScheme scheme = CmpSchemeFactory.getLocalInstance((Context)ctx);
        CmpSchemeCollection schemeCollection = scheme.getSchemeCollNoDataPermission(viewInfo, hrIdSet);
        int n = schemeCollection.size();
        for (int i = 0; i < n; ++i) {
            schmList.add(schemeCollection.get(i));
        }
        return schmList;
    }

    private List getCmpItem(Context ctx, String hrOrgId, List cmpNumList) throws BOSException, SQLException {
        String language = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,fnumber,fname_").append(language).append(" from t_hr_cmpitem where ");
        ArrayList<CmpItemInfo> itemList = new ArrayList<CmpItemInfo>();
        if (cmpNumList == null || cmpNumList.size() <= 0) {
            return itemList;
        }
        sql.append(" fnumber in ").append(HRSchemeUtils.getStrFromList((List)cmpNumList)).append(" and ");
        sql.append(" fHROrgUnitID='").append(hrOrgId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            CmpItemInfo item = new CmpItemInfo();
            item.setId(BOSUuid.read((String)rs.getString("fid")));
            item.setNumber(rs.getString("fnumber"));
            item.setName(rs.getString("fname_" + language));
            itemList.add(item);
        }
        return itemList;
    }

    private String getRootHRUnitID(Context ctx, List hroIdList) throws BOSException, SQLException {
        ArrayList<HROrgUnitInfo> hroList = new ArrayList<HROrgUnitInfo>();
        IHROrgUnit ihro = HROrgUnitFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select id,number,name,longNumber where id in ");
        oql.append(HRSchemeUtils.getStrFromList((List)hroIdList));
        HROrgUnitCollection hroCollection = ihro.getHROrgUnitCollection(oql.toString());
        int n = hroCollection.size();
        for (int i = 0; i < n; ++i) {
            HROrgUnitInfo org = hroCollection.get(i);
            hroList.add(org);
        }
        String hrOrgId = HRUtils.getParentOrgId((Context)ctx, hroList, (int)1);
        return hrOrgId;
    }

    protected Map _getCmpSchemeData(Context ctx, Map cmpParams) throws BOSException, EASBizException {
        HashMap dataMap = new HashMap();
        HashSet schmSet = (HashSet)cmpParams.get("cmpSchemes");
        String dimBosType = (String)cmpParams.get("mainDimType");
        List mainDimList = (List)cmpParams.get("mainDimList");
        CmpSchemeInfo[] schemes = new CmpSchemeInfo[schmSet.size()];
        Iterator schmIter = schmSet.iterator();
        int v = 0;
        while (schmIter.hasNext()) {
            schemes[v] = (CmpSchemeInfo)schmIter.next();
            ++v;
        }
        IBgPeriodApiInfo bgBeginPeriod = (IBgPeriodApiInfo)cmpParams.get("bgBeginPeriod");
        IBgPeriodApiInfo bgEndPeriod = (IBgPeriodApiInfo)cmpParams.get("bgEndPeriod");
        String hroRootId = (String)cmpParams.get("hroRootId");
        boolean isFromBugetAlert = (Boolean)cmpParams.get("isFromBugetAlert");
        List cmpPeriodList = this.getCmpPeriodInfo(ctx, bgBeginPeriod, bgEndPeriod, hroRootId);
        if (cmpPeriodList.size() == 0) {
            return dataMap;
        }
        CmpPeriodInfo[] cmpPeriods = cmpPeriodList.toArray(new CmpPeriodInfo[0]);
        List orgList = (List)cmpParams.get("orgList");
        List hrOrgList = null;
        String orgInfoId = null;
        int n = orgList.size();
        for (int k = 0; k < n; ++k) {
            orgInfoId = ((OrgUnitInfo)orgList.get(k)).getId().toString();
            hrOrgList = this.getCenterToHROrg(ctx, orgInfoId);
            if (hrOrgList.size() <= 0) continue;
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            List centerOfAdminList = this.getAdminOrgUnitFromCostCenter(ctx, orgInfoId);
            String orgInfoSql = this.getAdminIncludeSql(ctx, centerOfAdminList);
            List cmpItems = (List)cmpParams.get("itemList");
            String historyTableName = null;
            int schemeLen = schemes.length;
            CmpSchemeInfo scheme = null;
            List list = null;
            IRowSet rowSet = null;
            try {
                this.noUsedItem = (List)ObjectUtils.createCopy((Object)cmpItems);
            }
            catch (CloneNotSupportedException e1) {
                throw new BOSException();
            }
            String cmpItemNumber = null;
            BigDecimal money = null;
            String cmpPeriodNumber = null;
            for (int i = 0; i < schemeLen; ++i) {
                scheme = schemes[i];
                if (!this.judgeIsCurHroScheme(scheme, hrOrgList) || (historyTableName = this.getHistoryTable(ctx, scheme, isFromBugetAlert)) == null) continue;
                String[] tableName = historyTableName.split("@");
                for (int m = 0; m < tableName.length; ++m) {
                    int j;
                    if (tableName[m] == null || tableName[m].equals("null")) continue;
                    StringBuffer oql = new StringBuffer();
                    oql.append("select ");
                    list = this.getCmpItemInCmpScheme(ctx, scheme, cmpItems);
                    if (list == null || list.size() <= 0) continue;
                    for (j = 0; j < list.size(); ++j) {
                        oql.append("sum(");
                        oql.append(list.get(j));
                        oql.append(")");
                        oql.append(" as ");
                        oql.append(list.get(j));
                        oql.append(",");
                    }
                    oql.append("period.fnumber as fnumber ");
                    oql.append(" from ");
                    oql.append(tableName[m]).append(" dataTbl");
                    oql.append(" inner join t_hr_cmpperiod period on period.fid=dataTbl.fPeriod");
                    oql.append(" where period.fnumber in (");
                    for (j = 0; j < cmpPeriods.length; ++j) {
                        if (j < cmpPeriods.length - 1) {
                            oql.append("'");
                            oql.append(cmpPeriods[j].getNumber());
                            oql.append("'");
                            oql.append(",");
                            continue;
                        }
                        oql.append("'");
                        oql.append(cmpPeriods[j].getNumber());
                        oql.append("'");
                    }
                    oql.append(") ");
                    if (mainDimList != null && mainDimList.size() > 0) {
                        String dimFilterSql = this.getDimFilterSql(ctx, dimBosType, mainDimList, tableName[m], orgInfoSql);
                        oql.append(" and FPERSONID in (").append(dimFilterSql).append(")");
                    } else {
                        oql.append(" and fAdminOrgUnitID in( ");
                        oql.append(orgInfoSql);
                        oql.append(")");
                    }
                    oql.append(" group by fnumber");
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
                    try {
                        rowSet.beforeFirst();
                        while (rowSet.next()) {
                            cmpPeriodNumber = rowSet.getString("fnumber");
                            for (int j2 = 0; j2 < list.size(); ++j2) {
                                cmpItemNumber = list.get(j2).toString();
                                if (map.containsKey(cmpItemNumber + "@" + cmpPeriodNumber)) {
                                    money = (BigDecimal)map.get(cmpItemNumber + "@" + cmpPeriodNumber);
                                    money = money.add(rowSet.getBigDecimal(cmpItemNumber) == null ? new BigDecimal("0.00") : rowSet.getBigDecimal(cmpItemNumber));
                                    map.put(cmpItemNumber + "@" + cmpPeriodNumber, money == null ? new BigDecimal("0.00") : money);
                                    continue;
                                }
                                money = rowSet.getBigDecimal(cmpItemNumber);
                                map.put(cmpItemNumber + "@" + cmpPeriodNumber, money == null ? new BigDecimal("0.00") : money);
                            }
                        }
                        continue;
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            List noUsedItem = this.getNoUsedItem();
            int noUsedItemSize = noUsedItem.size();
            int cmpPeriodsLen = cmpPeriods.length;
            CmpItemInfo noUsedCmpItemInfo = null;
            cmpPeriodNumber = null;
            for (int i = 0; i < noUsedItemSize; ++i) {
                noUsedCmpItemInfo = (CmpItemInfo)noUsedItem.get(i);
                for (int j = 0; j < cmpPeriodsLen; ++j) {
                    cmpPeriodNumber = cmpPeriods[j].getNumber();
                    map.put(noUsedCmpItemInfo.getNumber() + "@" + cmpPeriodNumber, new BigDecimal("0.00"));
                }
            }
            dataMap.put(orgInfoId, map);
        }
        return dataMap;
    }

    private boolean judgeIsCurHroScheme(CmpSchemeInfo scheme, List hrOrgList) {
        String schmHrId = scheme.getHrOrgUnit().getId().toString();
        boolean include = false;
        int n = hrOrgList.size();
        for (int i = 0; i < n; ++i) {
            String hroId = (String)hrOrgList.get(i);
            if (!hroId.equals(schmHrId)) continue;
            include = true;
        }
        return include;
    }

    private List getCenterToHROrg(Context ctx, String orgInfoId) throws BOSException {
        ArrayList<String> adminOrgList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID in (");
        sql.append(" select r.FToUnitID from T_ORG_UnitRelation r");
        sql.append(" where r.FTypeRelationID='00000000-0000-0000-0000-0000000000150FE9F8B5'");
        sql.append(" and r.fFromUnitID = '").append(orgInfoId).append("') and ");
        sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" union ");
        sql.append("select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID = '");
        sql.append(orgInfoId).append("' and ");
        sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" union ");
        sql.append(" select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID in (");
        sql.append(" select r.FFromUnitID from T_ORG_UnitRelation r");
        sql.append(" where r.FTypeRelationID='00000000-0000-0000-0000-0000000000410FE9F8B5'");
        sql.append(" and r.FToUnitID ='").append(orgInfoId).append("') and ");
        sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                adminOrgList.add(rs.getString("FToUnitID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminOrgList;
    }

    private List getCmpPeriodInfo(Context ctx, IBgPeriodApiInfo bgBeginPeriod, IBgPeriodApiInfo bgEndPeriod, String hroRootId) throws BOSException {
        String language = ctx.getLocale().getLanguage();
        ArrayList<CmpPeriodInfo> periodInfo = new ArrayList<CmpPeriodInfo>();
        Date beginDate = bgBeginPeriod.getBeginDate();
        Date endDate = bgEndPeriod.getEndDate();
        Object[] dates = new Object[]{beginDate, endDate, hroRootId};
        StringBuffer sql = new StringBuffer();
        CmpPeriodInfo period = null;
        sql.append("select fid,fnumber,fname_").append(language).append("  from t_hr_cmpPeriod where FBeginDate>=? and FEndDate<=?");
        sql.append(" and fHrOrgUnitID=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])dates);
        try {
            while (rs.next()) {
                period = new CmpPeriodInfo();
                period.setId(BOSUuid.read((String)rs.getString("fid")));
                period.setNumber(rs.getString("fnumber"));
                period.setName(rs.getString("fname_" + language));
                periodInfo.add(period);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodInfo;
    }

    protected Map _getBgDataByCondition(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        List orgList = (List)paramMap.get("orgList");
        ArrayList<String> orgIdList = new ArrayList<String>();
        int n = orgList.size();
        for (int i = 0; i < n; ++i) {
            orgIdList.add(((OrgUnitInfo)orgList.get(i)).getId().toString());
        }
        String schemeId = (String)paramMap.get("schemeId");
        String bgformId = (String)paramMap.get("bgformId");
        IObjectCollection bgPeriods = (IObjectCollection)paramMap.get("bgPeriodCollection");
        ArrayList<String> bgPeriodIdList = new ArrayList<String>();
        Iterator iter = bgPeriods.iterator();
        while (iter.hasNext()) {
            bgPeriodIdList.add(((IBgPeriodApiInfo)iter.next()).getId().toString());
        }
        List itemList = (List)paramMap.get("itemList");
        ArrayList<String> salaryList = new ArrayList<String>();
        int n2 = itemList.size();
        for (int i = 0; i < n2; ++i) {
            if (itemList.get(i) == null) continue;
            salaryList.add(((CmpItemInfo)itemList.get(i)).getNumber());
        }
        String salaryType = "79D5E4F7";
        List mainDimList = (List)paramMap.get("mainDimList");
        String mainDimType = (String)paramMap.get("mainDimType");
        IHRInit iHR = HRInitFactory.getLocalInstance((Context)ctx);
        String currencyId = iHR.getJXCurrency();
        String language = ctx.getLocale().getLanguage();
        String curSql = "select fid from t_bg_bgelement where fname_" + language + " = '" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"15_BIReportCmpFacadeControllerBean", (Locale)ctx.getLocale()) + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)curSql);
        String elementId = null;
        try {
            while (rs.next()) {
                elementId = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        IServiceLocator service = ServiceLocator.getInstance();
        IBgTreeDataForOther bgInstance = (IBgTreeDataForOther)service.lookupService(ctx, "MA.BD.BgTreeData");
        List dataList = null;
        Object fromCompareChart = paramMap.get("isFromBudgetCompareChartUI");
        if (fromCompareChart == null) {
            dataList = bgInstance.getBudgetData(ctx, orgIdList, schemeId, bgPeriodIdList, salaryList, salaryType, mainDimList, mainDimType, currencyId, elementId, bgformId);
            if (!StringUtils.isEmpty((String)mainDimType) && mainDimList != null && mainDimList.size() > 0 && dataList.size() > 0) {
                List bgDataList = this.mergeBgData(orgIdList, bgPeriodIdList, salaryList, dataList);
                dataMap.put("dataList", bgDataList);
            } else {
                dataMap.put("dataList", dataList);
            }
        } else {
            String salaryNumber = (String)salaryList.get(0);
            dataList = bgInstance.getAllBudgetData(ctx, orgIdList, schemeId, bgPeriodIdList, salaryNumber, salaryType, currencyId, elementId, bgformId);
            if (dataList.size() > 0) {
                List bgDataList = this.mergeBgData(orgIdList, bgPeriodIdList, salaryList, dataList);
                dataMap.put("dataList", bgDataList);
            } else {
                dataMap.put("dataList", dataList);
            }
        }
        String hroRootId = (String)paramMap.get("hroRootId");
        bgPeriods = (IObjectCollection)paramMap.get("bgPeriodCollection");
        Map periodMap = this.getBgPeriodMap(ctx, bgPeriods, hroRootId);
        dataMap.put("periodMap", periodMap);
        return dataMap;
    }

    private Map getBgPeriodMap(Context ctx, IObjectCollection bgPeriods, String hrOrgId) throws BOSException {
        IBgPeriodApiInfo bgPeriod2 = null;
        HashMap<IBgPeriodApiInfo, List> periodMap = new HashMap<IBgPeriodApiInfo, List>();
        for (IBgPeriodApiInfo bgPeriod2 : bgPeriods) {
            Date beginDate = bgPeriod2.getBeginDate();
            Date endDate = bgPeriod2.getEndDate();
            List periodList = HRReportUtils.getCmpPeriodByTime((Context)ctx, (Date)beginDate, (Date)endDate, (String)hrOrgId);
            periodMap.put(bgPeriod2, periodList);
        }
        return periodMap;
    }

    private Map getOrgIdLongNumberMap(Context ctx, List adminOrgIdList) throws BOSException {
        String orgIds = HRSchemeUtils.getStrFromList((List)adminOrgIdList);
        HashMap<String, String> idNumMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,flongNumber from t_org_admin orgAdmin where orgAdmin.fid in ");
        sql.append(orgIds);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                idNumMap.put(rs.getString("fid"), rs.getString("flongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return idNumMap;
    }

    private String getAdminIncludeSql(Context ctx, List adminOrgIdList) throws BOSException {
        Map idNumMap = this.getOrgIdLongNumberMap(ctx, adminOrgIdList);
        Iterator iterator = idNumMap.entrySet().iterator();
        StringBuffer sql = new StringBuffer();
        String id = null;
        String longNum = null;
        int i = 0;
        Map.Entry entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            id = (String)entry.getKey();
            longNum = (String)entry.getValue();
            if (i == 0) {
                sql.append(" select orgAdmin.fid from t_org_admin orgAdmin where (orgAdmin.fid = '");
                sql.append(id);
                sql.append("' or orgAdmin.flongnumber like '");
                sql.append(longNum);
                sql.append("!%')");
            } else {
                sql.append(" union select orgAdmin.fid from t_org_admin orgAdmin where (orgAdmin.fid = '");
                sql.append(id);
                sql.append("' or orgAdmin.flongnumber like '");
                sql.append(longNum);
                sql.append("!%')");
            }
            ++i;
        }
        return sql.toString();
    }

    private String getDimFilterSql(Context ctx, String dimBosType, List mainDimList, String dataTableName, String orgInfoSql) throws BOSException {
        StringBuffer filterSql = new StringBuffer();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.PersonInfoQuery"));
        String strTemp = exec.getSQL();
        strTemp = StringUtils.replace((String)strTemp, (String)"T_HR_CMPSCHEMEPERSON", (String)dataTableName);
        int wherePos = (strTemp = strTemp.substring(strTemp.indexOf("FROM"))).indexOf("WHERE");
        if (wherePos > 0) {
            strTemp = strTemp.substring(0, wherePos + 5);
        }
        filterSql.append("SELECT DISTINCT \"PERSON\".FID ");
        filterSql = filterSql.append(strTemp);
        String dimString = HRSchemeUtils.getStrFromList((List)mainDimList);
        StringBuffer dimNumSql = new StringBuffer();
        dimNumSql.append("select FItemNumber from T_BG_BGItem where FBosType = '");
        dimNumSql.append(dimBosType);
        dimNumSql.append("' and FNumber in ").append(dimString);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)dimNumSql.toString());
        ArrayList<String> numList = new ArrayList<String>();
        String number = null;
        try {
            while (rs.next()) {
                number = rs.getString("FItemNumber");
                numList.add(number);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        dimString = HRSchemeUtils.getStrFromList(numList);
        String finalSql = "";
        if (dimBosType.equals("9B3E5DD3")) {
            StringBuffer tempBuf = new StringBuffer();
            tempBuf.append(" select tPerson.fID from t_bd_person tPerson ");
            tempBuf.append("left join T_BD_HRDiploma tDiploma on tPerson.FHighestDegreeID=tDiploma.fID ");
            tempBuf.append("inner join " + dataTableName + " dataTable on dataTable.FPERSONID=tPerson.fid ");
            tempBuf.append("where tDiploma.fnumber in " + dimString);
            tempBuf.append(" and dataTable.FAdminOrgUnitID in (" + orgInfoSql + ")");
            finalSql = tempBuf.toString();
        } else if (dimBosType.equals("8AD80852")) {
            StringBuffer tempBuf = new StringBuffer();
            tempBuf.append(" select tPerson.fID from t_bd_person tPerson ");
            tempBuf.append("left join T_HR_BDTechnicalPost tTPost on tPerson.FHighestTechPostID =tTPost.fID ");
            tempBuf.append("inner join " + dataTableName + " dataTable on dataTable.FPERSONID=tPerson.fid ");
            tempBuf.append("where tTPost.fnumber in " + dimString);
            tempBuf.append(" and dataTable.FAdminOrgUnitID in (" + orgInfoSql + ")");
            finalSql = tempBuf.toString();
        } else if (dimBosType.equals("5C14FC3A")) {
            String tmpSql = filterSql.toString();
            wherePos = tmpSql.indexOf("WHERE");
            if (wherePos > 0) {
                tmpSql = tmpSql.substring(0, wherePos);
            }
            StringBuffer fenleiSql = new StringBuffer();
            fenleiSql.append("select FID from T_HR_EmployeeFenLei where fnumber in ").append(dimString);
            fenleiSql.append(" union ");
            fenleiSql.append("select FID from T_HR_EmployeeFenLei where FParentID in (select FID from T_HR_EmployeeFenLei where fnumber in ").append(dimString).append(")");
            tmpSql = tmpSql + " LEFT OUTER JOIN T_HR_EmployeeFenLei \"employeeFenLei\" on employeeFenLei.fid=\"EMPTYPE\".FEmployeeFenLeiID";
            filterSql = new StringBuffer();
            filterSql.append(tmpSql);
            filterSql.append(" WHERE \"employeeFenLei\".FID in (").append(fenleiSql).append(")").append(" and \"CMPSCHEMEPERSON\".FAdminOrgUnitID in (").append(orgInfoSql).append(")");
            finalSql = PersonInfoUtils.getOptimizeSql((String)filterSql.toString());
        } else if (dimBosType.equals("A29E85B3")) {
            String filterTbl = this.getTableByBosType(dimBosType);
            StringBuffer satateSql = new StringBuffer();
            satateSql.append("select FID from T_HR_BDEmployeeType where fnumber in ").append(dimString);
            satateSql.append(" union ");
            satateSql.append("select FID from T_HR_BDEmployeeType where FinService in (select FValue from T_HR_EmpTypeType where fnumber in ").append(dimString).append(")");
            filterSql.append("\"").append(filterTbl).append("\".FID in (").append(satateSql).append(")").append(" and \"CMPSCHEMEPERSON\".FAdminOrgUnitID in (").append(orgInfoSql).append(")");
            finalSql = PersonInfoUtils.getOptimizeSql((String)filterSql.toString());
        } else {
            String filterTbl = this.getTableByBosType(dimBosType);
            filterSql.append(" \"").append(filterTbl).append("\".fnumber in ").append(dimString).append(" and \"CMPSCHEMEPERSON\".FAdminOrgUnitID in (").append(orgInfoSql).append(")");
            finalSql = PersonInfoUtils.getOptimizeSql((String)filterSql.toString());
        }
        return finalSql;
    }

    private List getAdminOrgUnitFromCostCenter(Context ctx, String costCenterId) throws BOSException {
        ArrayList<String> adminOrgList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select r.fToUnitID as FID from T_ORG_UnitRelation r");
        sql.append(" where (r.FTypeRelationID='00000000-0000-0000-0000-0000000000150FE9F8B5'");
        sql.append(" and r.fFromUnitID = '").append(costCenterId).append("')");
        sql.append(" union ");
        sql.append(" select FID as FID  from T_ORG_CostCenter where fIsAdminOrgUnit=1 and ");
        sql.append(" FID='").append(costCenterId).append("'");
        sql.append(" union ");
        sql.append(" select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID in (");
        sql.append(" select r.FFromUnitID from T_ORG_UnitRelation r");
        sql.append(" where r.FTypeRelationID='00000000-0000-0000-0000-0000000000410FE9F8B5'");
        sql.append(" and r.FToUnitID ='").append(costCenterId).append("') and ");
        sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                adminOrgList.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminOrgList;
    }

    private String getTableByBosType(String bosType) {
        String tblAliasName = null;
        if (bosType.equals("67F02330")) {
            tblAliasName = "JOBGRADE";
        } else if (bosType.equals("6830FEDD")) {
            tblAliasName = "JOBLEVEL";
        } else if (bosType.equals("A29E85B3")) {
            tblAliasName = "EMPTYPE";
        } else if (bosType.equals("5C14FC3A")) {
            tblAliasName = "EMPCLASSIFY";
        } else if (bosType.equals("CCE7AED4")) {
            tblAliasName = "ATTACHDEPT";
        } else if (bosType.equals("75702498")) {
            tblAliasName = "JOB";
        } else if (bosType.equals("74AE612E")) {
            tblAliasName = "POSITION";
        }
        return tblAliasName;
    }

    private List mergeBgData(List orgIdList, List bgPeriodIdList, List salaryList, List dataList) {
        ArrayList<BudgetData> bgDataList = new ArrayList<BudgetData>();
        String curOrgUnitId = null;
        String currentPeriod = null;
        String curSalaryNum = null;
        BudgetData curBgData = null;
        int n = orgIdList.size();
        for (int i = 0; i < n; ++i) {
            curOrgUnitId = (String)orgIdList.get(i);
            int m = bgPeriodIdList.size();
            for (int j = 0; j < m; ++j) {
                currentPeriod = (String)bgPeriodIdList.get(j);
                int x = salaryList.size();
                for (int k = 0; k < x; ++k) {
                    curSalaryNum = (String)salaryList.get(k);
                    BigDecimal totalVal = new BigDecimal("0");
                    int y = dataList.size();
                    for (int l = 0; l < y; ++l) {
                        curBgData = (BudgetData)dataList.get(l);
                        if (!currentPeriod.equals(curBgData.getPeriodId()) || !curSalaryNum.equals(curBgData.getSarlaryNum()) || !curOrgUnitId.equals(curBgData.getOrgUnitId()) || curBgData.getBgValue() == null) continue;
                        totalVal = totalVal.add(curBgData.getBgValue());
                    }
                    BudgetData totalBgData = new BudgetData();
                    totalBgData.setBgValue(totalVal);
                    totalBgData.setOrgUnitId(curOrgUnitId);
                    totalBgData.setSarlaryNum(curSalaryNum);
                    totalBgData.setPeriodId(currentPeriod);
                    bgDataList.add(totalBgData);
                }
            }
        }
        return bgDataList;
    }
}

