/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.IServiceLocator;
import com.kingdee.bos.bsf.service.ServiceLocator;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.ma.nbudget.IBgApi;
import com.kingdee.eas.ma.nbudget.IBgDataApiInfo;
import com.kingdee.eas.ma.nbudget.IBgFormApiInfo;
import com.kingdee.eas.ma.nbudget.IBgPeriodApiInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class HRBudgetUtils {
    public static CoreBaseCollection getBgItemofBgForm(IBgFormApiInfo bgFormInfo) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("formula"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgFormId", (Object)bgFormInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)SysContext.getSysContext().getCurrentOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 ");
        ev.setFilter(filter);
        IServiceLocator service = ServiceLocator.getInstance();
        IBgApi bgApi = (IBgApi)service.lookupService("MA.BD.BgApi");
        CoreBaseCollection bgDataCols = bgApi.getBgDataRemoteInstance().getCollection(ev);
        if (bgDataCols.size() > 0) {
            for (int i = 0; i < bgDataCols.size(); ++i) {
                if (!(bgDataCols.get(i) instanceof IBgDataApiInfo)) continue;
                String tmp = ((IBgDataApiInfo)bgDataCols.get(i)).getFormula();
                set.add(HRUtils.getDataOfFirstDoubleQuotationofMarks((String)tmp));
            }
        }
        if (set.size() == 0) {
            return null;
        }
        EntityViewInfo itemViewInfo = new EntityViewInfo();
        itemViewInfo.getSelector().add(new SelectorItemInfo("id"));
        itemViewInfo.getSelector().add(new SelectorItemInfo("name"));
        itemViewInfo.getSelector().add(new SelectorItemInfo("number"));
        FilterInfo itemFilterInfo = new FilterInfo();
        itemFilterInfo.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        itemViewInfo.setFilter(itemFilterInfo);
        CoreBaseCollection bgItemCols = bgApi.getBgItemRemoteInstance().getCollection(itemViewInfo);
        return bgItemCols;
    }

    public static String getTblItemNumbers(KDTable table) {
        int rowCount = table.getRowCount();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rowCount; ++i) {
            if (table.getCell(i, "bgItem").getValue() == null || ((DataBaseInfo)table.getCell(i, "bgItem").getValue()).getNumber() == null) continue;
            sb.append(((DataBaseInfo)table.getCell(i, "bgItem").getValue()).getNumber());
            sb.append("@");
            sb.append(((DataBaseInfo)table.getCell(i, "bgItem").getValue()).getName());
            sb.append(",");
            if (table.getCell(i, "cmpItem").getValue() != null) {
                sb.append(((CmpItemInfo)table.getCell(i, "cmpItem").getValue()).getNumber());
            } else {
                sb.append("ISNULL");
            }
            sb.append("@");
            if (table.getCell(i, "cmpItem").getValue() != null) {
                sb.append(((CmpItemInfo)table.getCell(i, "cmpItem").getValue()).getName());
            } else {
                sb.append("ISNULL");
            }
            sb.append(":");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static DataBaseInfo getBgPeriodFromCustomerParams(String param) {
        if (param == null) {
            return null;
        }
        String[] ids = param.split(":");
        if (ids != null && ids.length > 0) {
            try {
                IServiceLocator service = ServiceLocator.getInstance();
                IBgApi bgApi = (IBgApi)service.lookupService("MA.BD.BgApi");
                return (DataBaseInfo)bgApi.getBgPeriodRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids[0])));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return null;
    }

    public static List getCmpPeriodInfo(Context ctx, IBgPeriodApiInfo bgBeginPeriod, IBgPeriodApiInfo bgEndPeriod, String hroId) throws BOSException {
        ArrayList<CmpPeriodInfo> periodInfo = new ArrayList<CmpPeriodInfo>();
        Date beginDate = bgBeginPeriod.getBeginDate();
        Date endDate = bgEndPeriod.getEndDate();
        Object[] dates = new Object[]{beginDate, endDate};
        StringBuffer sql = new StringBuffer();
        CmpPeriodInfo period = null;
        String fname = null;
        ISQLExecutor iSQLExec = null;
        fname = ctx == null ? "fname_" + SysContext.getSysContext().getLocale().getLanguage() : "fname_" + ctx.getLocale().getLanguage();
        sql.append("select fid,fnumber,").append(fname).append(" from t_hr_cmpPeriod where FBeginDate>={ts'").append(beginDate.toString());
        sql.append("'}  and FEndDate<={ts'").append(endDate.toString()).append("'}");
        sql.append(" and fHrOrgUnitID='").append(hroId).append("'");
        sql.append(" order by FBeginDate");
        iSQLExec = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql.toString()) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = iSQLExec.executeSQL();
        try {
            while (rs.next()) {
                period = new CmpPeriodInfo();
                period.setId(BOSUuid.read((String)rs.getString("fid")));
                period.setNumber(rs.getString("fnumber"));
                period.setName(rs.getString(fname));
                periodInfo.add(period);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodInfo;
    }
}

