/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.IHRAffairBizBillEntry;
import com.kingdee.eas.hr.affair.app.AffairTriggerInfo;
import com.kingdee.eas.hr.affair.app.HRAffairAppUtils;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.compensation.AffairFixedSalaryFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpAdjExecutorFactory;
import com.kingdee.eas.hr.compensation.CmpAdjustiveCauseFactory;
import com.kingdee.eas.hr.compensation.CmpAdjustiveCauseInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemePersonCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemePersonFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemePersonInfo;
import com.kingdee.eas.hr.compensation.IAffairFixedSalaryFacade;
import com.kingdee.eas.hr.compensation.IFixedCmpSchemePerson;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.PersonCmpCollection;
import com.kingdee.eas.hr.emp.PersonCmpFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AffairTriggerCompensationProcessor {
    public void processAffairFixedSalary(Context ctx, AffairTriggerInfo trigger) throws BOSException, EASBizException, SQLException {
        IAffairFixedSalaryFacade iAfs = AffairFixedSalaryFacadeFactory.getLocalInstance(ctx);
        PersonCmpCollection pcCol = iAfs.getPayPersonByPersonId(trigger.getEntryInfo().getPerson().getId().toString());
        if (pcCol.size() > 0) {
            HROrgUnitInfo hroInfo = iAfs.getHROByAdminId(trigger.getEntryInfo().getAdminOrg().getId().toString());
            if (hroInfo == null) {
                return;
            }
            String hrId = hroInfo.getId().toString();
            FixedCmpSchemeInfo fcsInfo = iAfs.getFixedCmpSchemeByHrId(hrId);
            if (fcsInfo != null) {
                FixedCmpSchemePersonCollection fcspCol = FixedCmpSchemePersonFactory.getLocalInstance(ctx).getFixedCmpSchemePersonCollection("select audited, enable where person = '" + trigger.getEntryInfo().getPerson().getId().toString() + "' and fixedCmpScheme = '" + fcsInfo.getId().toString() + "'");
                if (fcspCol.size() > 0) {
                    boolean audited = fcspCol.get(0).isAudited();
                    boolean enable = fcspCol.get(0).isEnable();
                    if (audited) {
                        if (enable) {
                            ArrayList<String> listPerson = new ArrayList<String>();
                            listPerson.add(trigger.getEntryInfo().getPerson().getId().toString());
                            HashMap mapAlreadyInAdjustScheme = CmpAdjExecutorFactory.getLocalInstance(ctx).getAlreadyInAdjustScheme(listPerson, null);
                            if (mapAlreadyInAdjustScheme.containsKey(trigger.getEntryInfo().getPerson().getId().toString())) {
                                return;
                            }
                            this.processCmpAdjustFirst(ctx, iAfs, fcsInfo, hrId, trigger);
                        }
                    } else {
                        this.processFixedSchemeFirst(ctx, iAfs, fcsInfo, hrId, trigger);
                    }
                } else {
                    String table = fcsInfo.getHorTableName();
                    String sqlSelect = "select FOTHERENABLEDATE from " + table + " where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSelect);
                    if (rs.size() == 0) {
                        String sqlAdd = "insert into " + table + "(FPersonID, FOTHERENABLEDATE) values ('" + trigger.getEntryInfo().getPerson().getId().toString() + "', {ts'" + HRUtils.convertUtilDateTOSqlDate(trigger.getEntryInfo().getBizDate()) + "'})";
                        DbUtil.execute((Context)ctx, (String)sqlAdd);
                        this.updateZeroClumnValueNull(ctx, trigger, table);
                    }
                    FixedCmpSchemePersonInfo fcspInfo = new FixedCmpSchemePersonInfo();
                    fcspInfo.setPerson(trigger.getEntryInfo().getPerson());
                    fcspInfo.setFixedCmpScheme(fcsInfo);
                    fcspInfo.setAudited(false);
                    fcspInfo.setEnable(false);
                    FixedCmpSchemePersonFactory.getLocalInstance(ctx).addnew(fcspInfo);
                    this.processFixedSchemeFirst(ctx, iAfs, fcsInfo, hrId, trigger);
                }
            }
        }
    }

    private void processCmpAdjustFirst(Context ctx, IAffairFixedSalaryFacade iAfs, FixedCmpSchemeInfo fcsInfo, String hrId, AffairTriggerInfo trigger) throws EASBizException, BOSException, SQLException {
        Date adjDate = iAfs.getSalAdjDate(trigger.getEntryInfo().getPerson().getId().toString(), hrId);
        if (adjDate == null) {
            String sql = "select fotherenabledate from " + fcsInfo.getHorTableName() + " where fpersonid = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                adjDate = rowSet.getDate("fotherenabledate");
            } else {
                return;
            }
        }
        if (!trigger.getEntryInfo().getBizDate().after(adjDate)) {
            return;
        }
        HashMap<String, Object> cmpItemMap = new HashMap<String, Object>();
        IRowSet rs = iAfs.getAffairFixedSalaryByAffairBiz(trigger.getAffairType(), hrId);
        if (rs.size() == 0) {
            return;
        }
        String[] billField = null;
        ArrayList columnList = null;
        String adjustStatus = null;
        boolean hr_cmp_005 = HRParamUtil.getParamOfHR((Context)ctx, (String)"hr_cmp_005", (String)hrId);
        boolean tempHrCmp005 = false;
        String salaryPointTable = iAfs.getSalaryPointTalbe(hrId);
        if (salaryPointTable != null) {
            columnList = iAfs.getDynTableColumn(salaryPointTable);
        }
        String sqlSel = null;
        IRowSet rowSet = null;
        String sqlUpdate = null;
        while (rs.next()) {
            billField = rs.getString("billfield").split("#");
            if (billField[0].equals("salaryPoint") && trigger.getSalaryPoint() == null) continue;
            tempHrCmp005 = columnList != null && columnList.contains(rs.getString("cmpItemNumber").toUpperCase()) ? hr_cmp_005 : false;
            if (!tempHrCmp005) {
                if (billField[0].equals("salaryPoint")) {
                    cmpItemMap.put(rs.getString("cmpItemNumber"), trigger.getSalaryPoint().getId().toString());
                } else {
                    cmpItemMap.put(rs.getString("cmpItemNumber"), trigger.getEntryInfo().get(billField[0]));
                }
            } else {
                sqlSel = "select " + rs.getString("cmpItemNumber") + " from " + salaryPointTable + " where FPointID = '" + trigger.getSalaryPoint().getId().toString() + "'";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSel);
                while (rowSet.next()) {
                    cmpItemMap.put(rs.getString("cmpItemNumber"), rowSet.getBigDecimal(1));
                }
            }
            adjustStatus = rs.getString("adjustStatus");
        }
        if (cmpItemMap == null || cmpItemMap.isEmpty() || cmpItemMap.size() == 0) {
            return;
        }
        cmpItemMap.put("effectDate", HRUtils.convertUtilDateTOSqlDate(trigger.getEntryInfo().getBizDate()));
        cmpItemMap.put("adjustStatus", adjustStatus);
        ArrayList<String> list = new ArrayList<String>();
        list.add(trigger.getEntryInfo().getPerson().getId().toString());
        iAfs.addCmpAdj(fcsInfo.getId().toString(), list, cmpItemMap, trigger.getAffairType(), hrId, trigger.getEntryInfo().getAdminOrg());
        if (adjustStatus != null && !adjustStatus.equals("0") && adjustStatus.equals("2")) {
            rs.beforeFirst();
            while (rs.next()) {
                billField = rs.getString("billfield").split("#");
                if (billField[0].equals("salaryPoint") && trigger.getSalaryPoint() == null) continue;
                tempHrCmp005 = columnList.contains(rs.getString("cmpItemNumber").toUpperCase()) ? hr_cmp_005 : false;
                if (!tempHrCmp005) {
                    if (billField[0].equals("salaryPoint")) {
                        if (trigger.getSalaryPoint() == null) continue;
                        sqlUpdate = "update " + fcsInfo.getHorTableName() + " set " + rs.getString("cmpItemNumber") + " = '" + trigger.getSalaryPoint().getId().toString() + "' where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'";
                    } else {
                        Object object = trigger.getEntryInfo().get(billField[0]);
                        sqlUpdate = object instanceof BigDecimal ? "update " + fcsInfo.getHorTableName() + " set " + rs.getString("cmpItemNumber") + " = " + ((BigDecimal)object).doubleValue() + " where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'" : "update " + fcsInfo.getHorTableName() + " set " + rs.getString("cmpItemNumber") + " = " + trigger.getEntryInfo().get(billField[0]) + " where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'";
                    }
                    DbUtil.execute((Context)ctx, (String)sqlUpdate);
                    continue;
                }
                sqlSel = "select " + rs.getString("cmpItemNumber") + " from " + salaryPointTable + " where FPointID = '" + trigger.getSalaryPoint().getId().toString() + "'";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSel);
                while (rowSet.next()) {
                    sqlUpdate = "update " + fcsInfo.getHorTableName() + " set " + rs.getString("cmpItemNumber") + " = " + rowSet.getBigDecimal(1) + " where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'";
                    DbUtil.execute((Context)ctx, (String)sqlUpdate);
                }
            }
            String oqlStringCause = "SELECT * WHERE NUMBER='EMP_SalAdj'";
            CmpAdjustiveCauseInfo cmpAdjCauseInfo = CmpAdjustiveCauseFactory.getLocalInstance(ctx).getCmpAdjustiveCauseInfo(oqlStringCause);
            columnList = iAfs.getDynTableColumn(fcsInfo.getHorTableName());
            sqlUpdate = "update " + fcsInfo.getHorTableName() + " set FOTHERENABLEDATE = {ts'" + HRUtils.convertUtilDateTOSqlDate(trigger.getEntryInfo().getBizDate()) + "'}";
            if (columnList != null && columnList.contains("FADJUSTCAUSE".toUpperCase())) {
                sqlUpdate = sqlUpdate + ", FADJUSTCAUSE = '" + cmpAdjCauseInfo.getId().toString() + "'";
            }
            sqlUpdate = sqlUpdate + " where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)sqlUpdate);
            if (trigger.isUpdateLastAdjustSalDate()) {
                PersonCmpFactory.getLocalInstance((Context)ctx).execUpdate(sqlUpdate, trigger.getEntryInfo().getPerson().getId().toString());
            }
        }
    }

    private void processFixedSchemeFirst(Context ctx, IAffairFixedSalaryFacade iAfs, FixedCmpSchemeInfo fcsInfo, String hrId, AffairTriggerInfo trigger) throws SQLException, EASBizException, BOSException {
        String[] billField = null;
        String fixedStatus = null;
        String adjustStatus = null;
        String sqlUpdate = "";
        ArrayList columnList = null;
        ArrayList<String> list = null;
        boolean hr_cmp_005 = HRParamUtil.getParamOfHR((Context)ctx, (String)"hr_cmp_005", (String)hrId);
        boolean tempHrCmp005 = false;
        String salaryPointTable = iAfs.getSalaryPointTalbe(hrId);
        if (salaryPointTable != null) {
            columnList = iAfs.getDynTableColumn(salaryPointTable);
        }
        HashMap<String, Object> cmpItemMap = new HashMap<String, Object>();
        IRowSet rs = iAfs.getAffairFixedSalaryByAffairBiz(trigger.getAffairType(), hrId);
        if (rs.size() == 0) {
            return;
        }
        String sqlSel = null;
        IRowSet rowSet = null;
        while (rs.next()) {
            billField = rs.getString("billfield").split("#");
            if (billField[0].equals("salaryPoint") && trigger.getSalaryPoint() == null) continue;
            tempHrCmp005 = columnList.contains(rs.getString("cmpItemNumber").toUpperCase()) ? hr_cmp_005 : false;
            if (!tempHrCmp005) {
                if (billField[0].equals("salaryPoint") && this.existFsal000InTable(ctx, fcsInfo.getHorTableName())) {
                    if (trigger.getSalaryPoint() == null) continue;
                    sqlUpdate = "update " + fcsInfo.getHorTableName() + " set " + rs.getString("cmpItemNumber") + " = '" + trigger.getSalaryPoint().getId().toString() + "' where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'";
                    cmpItemMap.put(rs.getString("cmpItemNumber"), trigger.getSalaryPoint().getId().toString());
                } else {
                    Object object = trigger.getEntryInfo().get(billField[0]);
                    sqlUpdate = object instanceof BigDecimal ? "update " + fcsInfo.getHorTableName() + " set " + rs.getString("cmpItemNumber") + " = " + ((BigDecimal)object).doubleValue() + " where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'" : "update " + fcsInfo.getHorTableName() + " set " + rs.getString("cmpItemNumber") + " = " + trigger.getEntryInfo().get(billField[0]) + " where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'";
                    cmpItemMap.put(rs.getString("cmpItemNumber"), trigger.getEntryInfo().get(billField[0]));
                }
                DbUtil.execute((Context)ctx, (String)sqlUpdate);
            } else {
                sqlSel = "select " + rs.getString("cmpItemNumber") + " from " + salaryPointTable + " where FPointID = '" + trigger.getSalaryPoint().getId().toString() + "'";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSel);
                while (rowSet.next()) {
                    sqlUpdate = "update " + fcsInfo.getHorTableName() + " set " + rs.getString("cmpItemNumber") + " = " + rowSet.getBigDecimal(1) + " where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'";
                    DbUtil.execute((Context)ctx, (String)sqlUpdate);
                    cmpItemMap.put(rs.getString("cmpItemNumber"), rowSet.getBigDecimal(1));
                }
            }
            fixedStatus = rs.getString("fixedStatus");
            adjustStatus = rs.getString("adjustStatus");
        }
        cmpItemMap.put("effectDate", trigger.getEntryInfo().getBizDate());
        cmpItemMap.put("adjustStatus", adjustStatus);
        cmpItemMap.put("isShowAdjScheme", false);
        String oqlStringCause = "SELECT * WHERE NUMBER='" + trigger.getCmpAdjCaurseNum() + "'";
        CmpAdjustiveCauseInfo cmpAdjCauseInfo = CmpAdjustiveCauseFactory.getLocalInstance(ctx).getCmpAdjustiveCauseInfo(oqlStringCause);
        columnList = iAfs.getDynTableColumn(fcsInfo.getHorTableName());
        sqlUpdate = "update " + fcsInfo.getHorTableName() + " set FOTHERENABLEDATE = {ts'" + HRUtils.convertUtilDateTOSqlDate(trigger.getEntryInfo().getBizDate()) + "'}";
        if (columnList.contains("FADJUSTCAUSE".toUpperCase())) {
            sqlUpdate = sqlUpdate + ", FADJUSTCAUSE = '" + cmpAdjCauseInfo.getId().toString() + "'";
        }
        sqlUpdate = sqlUpdate + " where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sqlUpdate);
        if (fixedStatus != null && !fixedStatus.equals("0")) {
            if (fixedStatus.equals("3")) {
                String updateStatusSql = "update T_HR_FixedCmpSchemePerson set FAudited = 1, FEnable = 1 where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "' and FFixedCmpSchemeID = '" + fcsInfo.getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)updateStatusSql);
                list = new ArrayList<String>();
                list.add(trigger.getEntryInfo().getPerson().getId().toString());
                iAfs.addCmpAdj(fcsInfo.getId().toString(), list, cmpItemMap, "EmpEnrollBizBill", hrId, trigger.getEntryInfo().getAdminOrg());
            } else if (fixedStatus.equals("2")) {
                String updateStatusSql = "update T_HR_FixedCmpSchemePerson set FAudited = 1 where FPersonID = '" + trigger.getEntryInfo().getPerson().getId().toString() + "' and FFixedCmpSchemeID = '" + fcsInfo.getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)updateStatusSql);
            }
        }
    }

    private boolean existFsal000InTable(Context ctx, String table) throws BOSException {
        String sql = " SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSAL000' AND KSQL_COL_TABNAME='" + table + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rs.size() != 0;
    }

    private void updateZeroClumnValueNull(Context ctx, AffairTriggerInfo trigger, String table) throws BOSException {
        ArrayList<String> columnNames = new ArrayList<String>();
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)("SELECT top 1 * FROM " + table));
        ResultSetMetaData columnMeta = null;
        try {
            columnMeta = iRowSet.getMetaData();
            if (columnMeta == null) {
                return;
            }
            int size = columnMeta.getColumnCount();
            for (int i = 1; i <= size; ++i) {
                if (!columnMeta.getColumnName(i).toUpperCase().startsWith("FSAL") || columnMeta.getColumnName(i).length() != 7) continue;
                columnNames.add(columnMeta.getColumnName(i).toUpperCase());
            }
            StringBuffer buf = new StringBuffer();
            buf.append("update " + table + " set ");
            for (int i = 0; i < columnNames.size(); ++i) {
                if (i == columnNames.size() - 1) {
                    buf.append(" " + columnNames.get(i) + "=null ");
                    continue;
                }
                buf.append(" " + columnNames.get(i) + "=null, ");
            }
            if (columnNames.size() > 0) {
                buf.append(" where FPersonID ='" + trigger.getEntryInfo().getPerson().getId().toString() + "'");
                DbUtil.execute((Context)ctx, (String)buf.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void processEmpEnrollAffairFixedSalary(Context ctx, AffairTriggerInfo trigger) throws BOSException {
        IAffairFixedSalaryFacade iAfs = AffairFixedSalaryFacadeFactory.getLocalInstance(ctx);
        try {
            HROrgUnitInfo hroInfo = iAfs.getHROByAdminId(trigger.getEntryInfo().getAdminOrg().getId().toString());
            if (hroInfo == null) {
                return;
            }
            String personID = trigger.getEntryInfo().getPerson().getId().toString();
            String hrId = hroInfo.getId().toString();
            FixedCmpSchemeInfo fcsInfo = iAfs.getFixedCmpSchemeByHrId(hrId);
            if (fcsInfo == null) {
                return;
            }
            String table = fcsInfo.getHorTableName();
            IRowSet rs = iAfs.getAffairFixedSalaryByAffairBiz("EmpEnrollBizBill", hrId);
            if (rs.size() == 0) {
                return;
            }
            String[] billField = null;
            String fixedStatus = null;
            String sqlUpdate = "";
            FixedCmpSchemePersonInfo fcspInfo = null;
            ArrayList columnList = null;
            IFixedCmpSchemePerson iFcsp = FixedCmpSchemePersonFactory.getLocalInstance(ctx);
            ArrayList<String> list = null;
            boolean hr_cmp_005 = HRParamUtil.getParamOfHR((Context)ctx, (String)"hr_cmp_005", (String)hrId);
            boolean tempHrCmp005 = false;
            String salaryPointTable = iAfs.getSalaryPointTalbe(hrId);
            if (salaryPointTable != null) {
                columnList = iAfs.getDynTableColumn(salaryPointTable);
            }
            String sqlAdd = "insert into " + table + "(FPersonID, FOTHERENABLEDATE) values ('" + personID + "', {ts'" + trigger.getEntryInfo().getBizDate() + "'})";
            DbUtil.execute((Context)ctx, (String)sqlAdd);
            this.updateZeroClumnValueNull(ctx, trigger, table);
            String sqlSel = null;
            IRowSet rowSet = null;
            while (rs.next()) {
                billField = rs.getString("billfield").split("#");
                if (billField[0].equals("xinDian") && trigger.getSalaryPoint() == null) continue;
                tempHrCmp005 = columnList != null && columnList.contains(rs.getString("cmpItemNumber").toUpperCase()) ? hr_cmp_005 : false;
                if (!tempHrCmp005) {
                    if (billField[0].equals("xinDian")) {
                        if (trigger.getSalaryPoint() == null) continue;
                        sqlUpdate = "update " + table + " set " + rs.getString("cmpItemNumber") + " = '" + trigger.getSalaryPoint().getId().toString() + "' where FPersonID = '" + personID + "'";
                    } else {
                        Object object = trigger.getEntryInfo().get(billField[0]);
                        sqlUpdate = object instanceof BigDecimal ? "update " + table + " set " + rs.getString("cmpItemNumber") + " = " + ((BigDecimal)object).doubleValue() + " where FPersonID = '" + personID + "'" : "update " + table + " set " + rs.getString("cmpItemNumber") + " = " + object + " where FPersonID = '" + personID + "'";
                    }
                    DbUtil.execute((Context)ctx, (String)sqlUpdate);
                } else if (trigger.getSalaryPoint() != null && trigger.getSalaryPoint().getId() != null) {
                    sqlSel = "select " + rs.getString("cmpItemNumber") + " from " + salaryPointTable + " where FPointID = '" + trigger.getSalaryPoint().getId().toString() + "'";
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSel);
                    while (rowSet.next()) {
                        sqlUpdate = "update " + table + " set " + rs.getString("cmpItemNumber") + " = " + rowSet.getBigDecimal(1) + " where FPersonID = '" + personID + "'";
                        DbUtil.execute((Context)ctx, (String)sqlUpdate);
                    }
                }
                fixedStatus = rs.getString("fixedStatus");
            }
            String oqlStringCause = "SELECT * WHERE NUMBER='Init_FixedScheme'";
            CmpAdjustiveCauseInfo cmpAdjCauseInfo = CmpAdjustiveCauseFactory.getLocalInstance(ctx).getCmpAdjustiveCauseInfo(oqlStringCause);
            columnList = iAfs.getDynTableColumn(fcsInfo.getHorTableName());
            if (columnList.contains("FADJUSTCAUSE".toUpperCase())) {
                sqlUpdate = "update " + fcsInfo.getHorTableName() + " set FADJUSTCAUSE = '" + cmpAdjCauseInfo.getId().toString() + "'";
                sqlUpdate = sqlUpdate + " where FPersonID = '" + personID + "'";
                DbUtil.execute((Context)ctx, (String)sqlUpdate);
            }
            if (fixedStatus != null && !fixedStatus.equals("0")) {
                fcspInfo = new FixedCmpSchemePersonInfo();
                fcspInfo.setPerson(trigger.getEntryInfo().getPerson());
                fcspInfo.setFixedCmpScheme(fcsInfo);
                if (fixedStatus.equals("3")) {
                    fcspInfo.setAudited(true);
                    fcspInfo.setEnable(true);
                } else if (fixedStatus.equals("2")) {
                    fcspInfo.setAudited(true);
                    fcspInfo.setEnable(false);
                } else {
                    fcspInfo.setAudited(false);
                    fcspInfo.setEnable(false);
                }
                iFcsp.addnew(fcspInfo);
                if (fixedStatus.equals("3")) {
                    list = new ArrayList<String>();
                    list.add(personID);
                    trigger.getEntryInfo().put("CU", (Object)trigger.getBillInfo().getCU());
                    ctx.put((Object)"CU_temp", (Object)trigger.getBillInfo().getCU());
                    iAfs.addCmpAdj(fcsInfo.getId().toString(), list, null, "EmpEnrollBizBill", hrId, trigger.getEntryInfo().getAdminOrg());
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void doWithEmpEnrollParPersonAndPointValue(Context ctx, IObjectPK empEnrollBizBillEntryId, String hrOrgUnitID) throws BOSException, EASBizException {
        if (empEnrollBizBillEntryId == null) {
            return;
        }
        if (HRInitFactory.getLocalInstance((Context)ctx).getSPSchema() != 1) {
            return;
        }
        BOSObjectType type = BOSUuid.read((String)empEnrollBizBillEntryId.toString()).getType();
        IHRAffairBizBillEntry enrollBillEntry = (IHRAffairBizBillEntry)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("resumeId"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.employeeType.id"));
        sic.add(new SelectorItemInfo("xinDian.id"));
        sic.add(new SelectorItemInfo("xinDian.scheme.id"));
        HRAffairBizBillEntryInfo billEntryInfo = (HRAffairBizBillEntryInfo)enrollBillEntry.getHRBillBaseEntryInfo(empEnrollBizBillEntryId, sic);
        try {
            this.addfixedcmpscheme(ctx, billEntryInfo, hrOrgUnitID);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void addfixedcmpscheme(Context ctx, HRAffairBizBillEntryInfo billEntryInfo, String hrOrgUnitID) throws Exception {
        SalariatHiberPropsInfo infoSal = (SalariatHiberPropsInfo)billEntryInfo.get("xinDian");
        if (infoSal == null) {
            return;
        }
        FixedCmpSchemeInfo fixedSchemeInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitID));
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)new Integer(1)));
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("enable"));
        evi.getSelector().add(new SelectorItemInfo("horTableName"));
        evi.setFilter(filterInfo);
        FixedCmpSchemeCollection col = FixedCmpSchemeFactory.getLocalInstance(ctx).getFixedCmpSchemeCollection(evi);
        if (col == null || col.size() <= 0) {
            return;
        }
        fixedSchemeInfo = col.get(0);
        if (fixedSchemeInfo == null) {
            return;
        }
        String tableName = fixedSchemeInfo.getHorTableName();
        if (tableName == null) {
            return;
        }
        String salSchemeID = infoSal.getScheme().getId().toString();
        String xindianID = infoSal.getId().toString();
        Map mapPoint = HRAffairAppUtils.getPointValueMap((Context)ctx, (String)salSchemeID, (String)xindianID);
        Map pointValueMap = (Map)mapPoint.get(xindianID);
        CmpItemCollection cmpItems = (CmpItemCollection)((Object)mapPoint.get("SalSchemeItems"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select fpersonid from " + tableName + " where FPERSONID ='" + billEntryInfo.getPerson().getId().toString() + "'"));
        StringBuffer oql = new StringBuffer();
        if (rs.next()) {
            Object[] params = new Object[cmpItems.size() + 2];
            oql.append("update ");
            oql.append(tableName);
            oql.append(" set FSAL000=? ");
            params[0] = xindianID;
            for (int i = 0; i < cmpItems.size(); ++i) {
                oql.append(",");
                oql.append(cmpItems.get(i).getNumber()).append("=?");
                if (pointValueMap == null) continue;
                params[i + 1] = pointValueMap.get(cmpItems.get(i).getNumber());
            }
            oql.append(" where FPERSONID = ?");
            params[cmpItems.size() + 1] = billEntryInfo.getPerson().getId().toString();
            DbUtil.execute((Context)ctx, (String)oql.toString(), (Object[])params);
        } else {
            int i;
            oql.append("insert into ");
            oql.append(tableName);
            oql.append("(FPERSONID,FOTHERENABLEDATE,FSAL000");
            for (i = 0; i < cmpItems.size(); ++i) {
                oql.append(",");
                oql.append(cmpItems.get(i).getNumber());
            }
            oql.append(") values(?,?,?");
            Object[] params = new Object[i + 3];
            params[0] = billEntryInfo.getPerson().getId().toString();
            params[1] = billEntryInfo.getDate("bizDate");
            params[2] = xindianID;
            for (int j = 0; j < cmpItems.size(); ++j) {
                oql.append(",?");
                if (pointValueMap == null) continue;
                params[j + 3] = pointValueMap.get(cmpItems.get(j).getNumber());
            }
            oql.append(")");
            DbUtil.execute((Context)ctx, (String)oql.toString(), (Object[])params);
        }
    }
}

