/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.app.HRDbUtil;
import com.kingdee.eas.hr.compensation.AuditTypeEnum;
import com.kingdee.eas.hr.compensation.BillStateEnum;
import com.kingdee.eas.hr.compensation.BranchCompBillFactory;
import com.kingdee.eas.hr.compensation.BranchCompBillInfo;
import com.kingdee.eas.hr.compensation.BranchCompEntryBillCollection;
import com.kingdee.eas.hr.compensation.BranchCompEntryBillFactory;
import com.kingdee.eas.hr.compensation.BranchCompEntryBillInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeCmpItemsCollection;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeCmpItemsFactory;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeException;
import com.kingdee.eas.hr.compensation.IBranchCompBill;
import com.kingdee.eas.hr.compensation.app.AbstractBranchCompBillControllerBean;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BranchCompBillControllerBean
extends AbstractBranchCompBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.BranchCompBillControllerBean");

    @Override
    protected void _auditPass(Context ctx, BOSUuid pk) throws BOSException, EASBizException {
        IBranchCompBill bill = BranchCompBillFactory.getLocalInstance(ctx);
        BranchCompBillInfo info = bill.getBranchCompBillInfo((IObjectPK)new ObjectStringPK(pk.toString()));
        CmpPeriodInfo cmpPeriodInfo = info.getCompensationPeriod();
        info.setBillState(BillStateEnum.audited);
        bill.save((CoreBaseInfo)info);
        if (info.getAuditType() != null && 1 == info.getAuditType().getValue()) {
            IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
            MultiApproveInfo mAInfo = new MultiApproveInfo();
            mAInfo.setIsPass(ApproveResult.PASS);
            mAInfo.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"17_BranchCompBillControllerBean", (Locale)ctx.getOriginLocale()));
            mAInfo.setBillId(pk);
            mAInfo.setBosTypeStr(pk.getType().toString());
            im.addnew((CoreBaseInfo)mAInfo);
        }
        String oql = "select schemeEntry.id where parent.id = '" + pk + "' and  (schemeEntry.isCollectAudit<>1 or schemeEntry.isCollectAudit is null) and schemeEntry.cmpPeriod.id = '" + cmpPeriodInfo.getId() + "'";
        BranchCompEntryBillCollection entryBillColl = BranchCompEntryBillFactory.getLocalInstance(ctx).getBranchCompEntryBillCollection(oql);
        if (entryBillColl == null || entryBillColl.size() == 0) {
            return;
        }
        BranchCompEntryBillInfo branchCompEntryBillInfo = null;
        ArrayList<String> list = new ArrayList<String>();
        int j = entryBillColl.size();
        for (int i = 0; i < j; ++i) {
            branchCompEntryBillInfo = entryBillColl.get(i);
            if (branchCompEntryBillInfo.getSchemeEntry() == null) continue;
            list.add(branchCompEntryBillInfo.getSchemeEntry().getId().toString());
            this._auditApproved(ctx, branchCompEntryBillInfo.getSchemeEntry().getId());
        }
        if (list.size() > 0) {
            String updateSql = "update T_HR_DeptSchemeEntry set FIsCollectAudit = 1 where fid in " + CompUtils.getStrFromList(list);
            HRDbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    @Override
    protected void _unAuditPass(Context ctx, BOSUuid pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_DeptSchemeEntry set FIsCollectAudit = 0 where fid in ").append("( select FSchemeEntryID from T_HR_BranchCompEntryBill where FParentID = ? )");
        HRDbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
        IBranchCompBill bill = BranchCompBillFactory.getLocalInstance(ctx);
        BranchCompBillInfo info = bill.getBranchCompBillInfo((IObjectPK)new ObjectStringPK(pk.toString()));
        info.setBillState(BillStateEnum.unAudited);
        bill.save((CoreBaseInfo)info);
    }

    @Override
    protected Set _getDeptSchemeByPeriod(Context ctx, String periodID) throws BOSException, EASBizException {
        HROrgUnitInfo hrOrg = ContextUtil.getCurrentHRUnit((Context)ctx);
        StringBuffer sb = new StringBuffer("select DISTINCT ").append(" deptScheme.fid as id from T_HR_DeptScheme as deptScheme ").append(" left join T_HR_DeptSchemeEntry as deptSchemeentry ").append(" on deptScheme.fid = deptSchemeentry.FDeptSchemeID ").append(" where deptScheme.fid IN ").append(" (select DISTINCT deptScheme.fid from T_HR_DeptScheme as deptScheme ").append(" left join T_HR_DeptSchemeEntry as deptSchemeentry ").append(" on deptScheme.fid = deptSchemeentry.FDeptSchemeID ").append(" left join T_HR_CMPPERIOD as cmpPeriod ").append(" on deptSchemeentry.FCmpPeriodID = cmpPeriod.fid ").append(" left join T_HR_DeptInnerScheme as innerScheme ").append(" on innerScheme.fid =deptSchemeentry.FDeptInnerSchemeID ").append(" where cmpPeriod.fid = '" + periodID + "' AND cmpPeriod.FHROrgUnitID = '" + hrOrg.getId() + "' ").append(" and innerScheme.FAudit = 40 ").append(" AND  (deptSchemeentry.FIsCollectAudit = 0 or deptSchemeentry.FIsCollectAudit is null) ").append(" AND  deptSchemeentry.fisparentnode = 0 ").append(" ) ").append(" and deptScheme.fid not IN ").append(" (select DISTINCT deptScheme.fid from T_HR_DeptScheme as deptScheme ").append(" left join T_HR_DeptSchemeEntry as deptSchemeentry ").append(" on deptScheme.fid = deptSchemeentry.FDeptSchemeID ").append(" left join T_HR_CMPPERIOD as cmpPeriod ").append(" on deptSchemeentry.FCmpPeriodID = cmpPeriod.fid ").append(" left join T_HR_DeptInnerScheme as innerScheme ").append(" on innerScheme.fid =deptSchemeentry.FDeptInnerSchemeID ").append(" where cmpPeriod.fid = '" + periodID + "' AND cmpPeriod.FHROrgUnitID = '" + hrOrg.getId() + "' ").append(" and (innerScheme.FAudit <> 40 ").append(" or innerScheme.fAudit is null) ").append(" AND (deptSchemeentry.FIsCollectAudit = 0 or deptSchemeentry.FIsCollectAudit is null)").append(" AND  deptSchemeentry.fisparentnode = 0 ").append(" )").append(" AND deptScheme.FCollectAudit = 1 ");
        IRowSet rs = HRDbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashSet<String> set = new HashSet<String>();
        try {
            while (rs.next()) {
                set.add(rs.getString("id").toString());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return set;
    }

    protected void _auditApproved(Context ctx, BOSUuid depEntryID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("sendRate"));
        selector.add(new SelectorItemInfo("cmpPeriod.id"));
        selector.add(new SelectorItemInfo("deptScheme.id"));
        selector.add(new SelectorItemInfo("time"));
        selector.add(new SelectorItemInfo("deptInnerScheme.*"));
        selector.add(new SelectorItemInfo("parentNode.id"));
        selector.add(new SelectorItemInfo("cmpScheme.id"));
        DeptSchemeEntryInfo deptSchemeEntryInfoGolTemp = DeptSchemeEntryFactory.getLocalInstance(ctx).getDeptSchemeEntryInfo((IObjectPK)new ObjectUuidPK(depEntryID), null);
        HashMap cmpItemsMap = this.getDeptInnerCmpItems(ctx, deptSchemeEntryInfoGolTemp);
        CmpPeriodInfo cmpPeriodInfoGol = deptSchemeEntryInfoGolTemp.getCmpPeriod();
        try {
            HashMap endInputMap = this.processPersonalCmpItemValue(ctx, deptSchemeEntryInfoGolTemp, cmpItemsMap);
            ArrayList<Serializable> endInputList = new ArrayList<Serializable>();
            endInputList.add(cmpPeriodInfoGol);
            endInputList.add(cmpItemsMap);
            endInputList.add(endInputMap);
            endInputList.add(deptSchemeEntryInfoGolTemp.getCmpScheme());
            DeptInnerSchemeEntryFactory.getLocalInstance(ctx).aduitAction((IObjectValue)deptSchemeEntryInfoGolTemp, null, null, endInputList, null);
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
    }

    private HashMap getDeptInnerCmpItems(Context ctx, DeptSchemeEntryInfo deptSchemeEntryInfo) throws BOSException {
        HashMap<String, CmpItemInfo> cmpItemsMap = new HashMap<String, CmpItemInfo>();
        String deptInnerSchemePKString = deptSchemeEntryInfo.getDeptInnerScheme().getId().toString();
        EntityViewInfo entTemp = new EntityViewInfo();
        entTemp.getSelector().add(new SelectorItemInfo("*"));
        entTemp.getSelector().add(new SelectorItemInfo("cmpItem.*"));
        FilterInfo filterInfoTemp = new FilterInfo();
        filterInfoTemp.getFilterItems().add(new FilterItemInfo("deptInnerScheme", (Object)deptInnerSchemePKString));
        entTemp.setFilter(filterInfoTemp);
        DeptInnerSchemeCmpItemsCollection depInnerCmpItemsCollection = DeptInnerSchemeCmpItemsFactory.getLocalInstance(ctx).getDeptInnerSchemeCmpItemsCollection(entTemp);
        int sizeTemp = depInnerCmpItemsCollection.size();
        for (int i = 0; i < sizeTemp; ++i) {
            CmpItemInfo cmpItemInfo = depInnerCmpItemsCollection.get(i).getCmpItem();
            cmpItemsMap.put(cmpItemInfo.getId().toString(), cmpItemInfo);
        }
        return cmpItemsMap;
    }

    private HashMap processPersonalCmpItemValue(Context ctx, DeptSchemeEntryInfo deptSchemeEntryInfo, HashMap cmpItemsMap) throws SQLException, DeptSchemeException, BOSException {
        HashMap<String, HashMap> endInputMap = new HashMap<String, HashMap>();
        IRowSet personRowSet = this.getPersonDeptInnerSchEntryData(ctx, deptSchemeEntryInfo);
        String cmpItemKey = null;
        HashMap hashDataMap = null;
        while (personRowSet.next()) {
            BigDecimal bg = personRowSet.getBigDecimal("FAmount");
            if (bg == null) continue;
            cmpItemKey = personRowSet.getString("FCmpItemID");
            if (StringUtils.isEmpty((String)cmpItemKey) || !cmpItemsMap.containsKey(cmpItemKey)) {
                throw new DeptSchemeException(DeptSchemeException.UNSUBMIT);
            }
            if (endInputMap.containsKey(cmpItemKey)) {
                hashDataMap = (HashMap)endInputMap.get(cmpItemKey);
            } else {
                hashDataMap = new HashMap();
                endInputMap.put(cmpItemKey, hashDataMap);
            }
            hashDataMap.put(personRowSet.getString("FPersonID"), bg);
        }
        return endInputMap;
    }

    private IRowSet getPersonDeptInnerSchEntryData(Context ctx, DeptSchemeEntryInfo deptSchemeEntryInfo) throws BOSException {
        IRowSet personRowSet = null;
        DeptInnerSchemeInfo deptInnerSchemeInfo = deptSchemeEntryInfo.getDeptInnerScheme();
        String sqlSelectStr = "SELECT * FROM T_HR_DeptInnerSchemeEntry WHERE FDeptInnerSchemeID ='" + deptInnerSchemeInfo.getId().toString() + "' ORDER BY FCmpItemID";
        personRowSet = HRDbUtil.executeQuery((Context)ctx, (String)sqlSelectStr);
        return personRowSet;
    }

    @Override
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        BranchCompBillInfo info = (BranchCompBillInfo)model;
        BranchCompEntryBillCollection entryBillColl = info.getEntry();
        if (entryBillColl == null || entryBillColl.size() == 0) {
            return super.submit(ctx, model);
        }
        BranchCompEntryBillInfo branchCompEntryBillInfo = null;
        ArrayList<String> list = new ArrayList<String>();
        int j = entryBillColl.size();
        for (int i = 0; i < j; ++i) {
            branchCompEntryBillInfo = entryBillColl.get(i);
            if (branchCompEntryBillInfo.getSchemeEntry() == null) continue;
            list.add(branchCompEntryBillInfo.getSchemeEntry().getId().toString());
        }
        this.checkEntryIsAudit(ctx, list);
        String fidStr = CompUtils.getStrFromList(list);
        String functionName = "com.kingdee.eas.hr.compensation.app.BranchCompBillFunction";
        String operationName = "submited";
        String userid = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String temp = EnactmentServiceProxy.getEnacementService((Context)ctx).findSubmitProcDef(userid, (IObjectValue)info, functionName, operationName);
        if (temp == null || temp.trim().equals("")) {
            throw new DeptSchemeException(DeptSchemeException.DEPT_SUM_WORKFLOW_ERROR);
        }
        IObjectPK pk = super.submit(ctx, model);
        if (list.size() > 0) {
            String updateSql = "update T_HR_DeptSchemeEntry set FIsCollectAudit = 2 where (FIsCollectAudit<>1 or FIsCollectAudit is null) and fid in " + fidStr;
            HRDbUtil.execute((Context)ctx, (String)updateSql);
        }
        return pk;
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        BranchCompBillInfo info = (BranchCompBillInfo)model;
        if (AuditTypeEnum.directAudit.equals((Object)info.getAuditType()) && BillStateEnum.auditing.equals((Object)info.getBillState())) {
            BranchCompEntryBillCollection entryBillColl = info.getEntry();
            if (entryBillColl == null || entryBillColl.size() == 0) {
                return super.save(ctx, model);
            }
            BranchCompEntryBillInfo branchCompEntryBillInfo = null;
            ArrayList<String> list = new ArrayList<String>();
            int j = entryBillColl.size();
            for (int i = 0; i < j; ++i) {
                branchCompEntryBillInfo = entryBillColl.get(i);
                if (branchCompEntryBillInfo.getSchemeEntry() == null) continue;
                list.add(branchCompEntryBillInfo.getSchemeEntry().getId().toString());
            }
            this.checkEntryIsAudit(ctx, list);
            String fidStr = CompUtils.getStrFromList(list);
            if (list.size() > 0) {
                String updateSql = "update T_HR_DeptSchemeEntry set FIsCollectAudit = 2 where (FIsCollectAudit<>1 or FIsCollectAudit is null) and fid in " + fidStr;
                HRDbUtil.execute((Context)ctx, (String)updateSql);
            }
        }
        return super.save(ctx, model);
    }

    private void checkEntryIsAudit(Context ctx, List entryIDs) throws BOSException, EASBizException {
        String language = ctx.getLocale().getLanguage();
        String fidStr = CompUtils.getStrFromList(entryIDs);
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct scheme.fname_").append(language).append(",cp.fname_").append(language).append(" from t_hr_deptScheme scheme ").append(" inner join t_hr_deptschemeentry en on scheme.fid= en.fdeptschemeid ").append(" inner join T_HR_DeptInnerScheme inn on inn.fid = en.FDeptInnerSchemeID").append(" inner join t_hr_cmpperiod cp on cp.fid = en.FCmpPeriodID").append(" where inn.FAudit<>40 and en.fid in ").append(fidStr);
        IRowSet rs = HRDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            Object[] obj = new Object[2];
            if (rs.next()) {
                obj[0] = rs.getString(1);
                obj[1] = rs.getString(2);
                throw new DeptSchemeException(DeptSchemeException.DEPT_INNER_UNAUDIT, obj);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
    }
}

