/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.EmpCompenseException;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.app.AbstractCmpAdjSchReportFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpAdjSchReportFacadeControllerBean
extends AbstractCmpAdjSchReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.CmpAdjSchReportFacadeControllerBean");

    @Override
    protected IRowSet _getEmpCmpData(Context ctx, EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        IRowSet rowSetPerson = null;
        if (entityViewInfo != null) {
            MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpAdjHRPersonInfoQuery");
            IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
            String tableNames = null;
            try {
                tableNames = HRSchemeUtils.getPermissionTableName(ctx);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
                logger.error((Object)e.getMessage());
            }
            if (tableNames != null) {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT FPersonId from ");
                sql.append(tableNames);
                FilterInfo tempFilterInfo = new FilterInfo();
                tempFilterInfo.getFilterItems().add(new FilterItemInfo("PERSON.id", (Object)sql.toString(), CompareType.INNER));
                entityViewInfo.getFilter().mergeFilter(tempFilterInfo, "AND");
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("PERSON.id"));
            sic.add(new SelectorItemInfo("PERSON.number"));
            sic.add(new SelectorItemInfo("PERSON.name"));
            sic.add(new SelectorItemInfo("deptAdmin.name"));
            sic.add(new SelectorItemInfo("priPosition.name"));
            sic.add(new SelectorItemInfo("PERSONEXTEND.enterDate"));
            sic.add(new SelectorItemInfo("CMPITEM.NUMBER"));
            sic.add(new SelectorItemInfo("CMPITEM.name"));
            sic.add(new SelectorItemInfo("newValue"));
            sic.add(new SelectorItemInfo("oldValue"));
            sic.add(new SelectorItemInfo("OLDSALP.NAME"));
            sic.add(new SelectorItemInfo("NEWSALP.NAME"));
            sic.add(new SelectorItemInfo("CMPADJSCHEME.effectDate"));
            sic.add(new SelectorItemInfo("effectDate"));
            sic.add(new SelectorItemInfo("CMPAC.NAME"));
            sic.add(new SelectorItemInfo("remark"));
            sic.add(new SelectorItemInfo("CMPITEM.dataType"));
            sic.add(new SelectorItemInfo("CMPITEM.decDigital"));
            sic.add(new SelectorItemInfo("CMPITEM.precisionType"));
            entityViewInfo.setSelector(sic);
            queryExec.setObjectView(entityViewInfo);
            rowSetPerson = queryExec.executeQuery();
        }
        return rowSetPerson;
    }

    @Override
    protected Map _getAdjNameListData(Context ctx, Map AdjParams) throws BOSException, EASBizException {
        List adjSchNumList = (List)AdjParams.get("adjSchNum");
        IRowSet rowSetPerson = null;
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpAdjustiveNameListQuery");
        EntityViewInfo entityViewInfo = (EntityViewInfo)AdjParams.get("filterEntityAll");
        HashMap<String, IRowSet> resultMap = new HashMap<String, IRowSet>();
        if (entityViewInfo != null) {
            String numbers;
            FilterInfo tempFilterInfo;
            IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
            String tableNames = null;
            try {
                tableNames = HRSchemeUtils.getPermissionTableName(ctx);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (tableNames != null) {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT FPersonId from ");
                sql.append(tableNames);
                FilterInfo tempFilterInfo2 = new FilterInfo();
                tempFilterInfo2.getFilterItems().add(new FilterItemInfo("PERSON.id", (Object)sql.toString(), CompareType.INNER));
                String numbers2 = HRSchemeUtils.getStrFromList(adjSchNumList);
                tempFilterInfo2.getFilterItems().add(new FilterItemInfo("CMPADJSCHEME.number", (Object)numbers2.substring(1, numbers2.length() - 1), CompareType.INNER));
                tempFilterInfo2.setMaskString("#0 and #1");
                if (entityViewInfo.getFilter() != null) {
                    entityViewInfo.getFilter().mergeFilter(tempFilterInfo2, "and");
                } else {
                    entityViewInfo.setFilter(tempFilterInfo2);
                }
            } else if (entityViewInfo.getFilter() == null) {
                tempFilterInfo = new FilterInfo();
                numbers = HRSchemeUtils.getStrFromList(adjSchNumList);
                tempFilterInfo.getFilterItems().add(new FilterItemInfo("CMPADJSCHEME.number", (Object)numbers.substring(1, numbers.length() - 1), CompareType.INNER));
                entityViewInfo.setFilter(tempFilterInfo);
            } else {
                tempFilterInfo = new FilterInfo();
                numbers = HRSchemeUtils.getStrFromList(adjSchNumList);
                tempFilterInfo.getFilterItems().add(new FilterItemInfo("CMPADJSCHEME.number", (Object)numbers.substring(1, numbers.length() - 1), CompareType.INNER));
                entityViewInfo.getFilter().mergeFilter(tempFilterInfo, "AND");
            }
            if (entityViewInfo.getFilter() != null && HRSchemeUtils.getServerHROrgUnitInfo(ctx) != null) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("HROrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString(), CompareType.EQUALS));
                entityViewInfo.getFilter().mergeFilter(filterInfo, "AND");
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("PERSON.id"));
            sic.add(new SelectorItemInfo("PERSON.number"));
            sic.add(new SelectorItemInfo("PERSON.name"));
            sic.add(new SelectorItemInfo("PERSON.birthday"));
            sic.add(new SelectorItemInfo("PERSON.gender"));
            sic.add(new SelectorItemInfo("deptAdmin.name"));
            sic.add(new SelectorItemInfo("priPosition.name"));
            sic.add(new SelectorItemInfo("PERSONEXTEND.enterDate"));
            sic.add(new SelectorItemInfo("CMPITEM.NUMBER"));
            sic.add(new SelectorItemInfo("CMPITEM.name"));
            sic.add(new SelectorItemInfo("newValue"));
            sic.add(new SelectorItemInfo("oldValue"));
            sic.add(new SelectorItemInfo("OLDSALP.NAME"));
            sic.add(new SelectorItemInfo("NEWSALP.NAME"));
            sic.add(new SelectorItemInfo("CMPADJSCHEME.effectDate"));
            sic.add(new SelectorItemInfo("effectDate"));
            sic.add(new SelectorItemInfo("CMPAC.NAME"));
            sic.add(new SelectorItemInfo("remark"));
            sic.add(new SelectorItemInfo("CMPITEM.dataType"));
            sic.add(new SelectorItemInfo("CMPITEM.decDigital"));
            sic.add(new SelectorItemInfo("CMPITEM.precisionType"));
            sic.add(new SelectorItemInfo("CMPADJSCHEME.number"));
            sic.add(new SelectorItemInfo("OLDDEPT.displayName"));
            sic.add(new SelectorItemInfo("newDept.displayName"));
            sic.add(new SelectorItemInfo("NEWPOSITION.NAME"));
            sic.add(new SelectorItemInfo("OLDPOSITION.NAME"));
            sic.add(new SelectorItemInfo("HROrgUnit.id"));
            entityViewInfo.setSelector(sic);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sorterInfo = new SorterItemInfo("PERSON.id");
            sorter.add(sorterInfo);
            sorterInfo = new SorterItemInfo("CMPADJSCHEME.number");
            sorter.add(sorterInfo);
            entityViewInfo.setSorter(sorter);
            queryExec.setObjectView(entityViewInfo);
            rowSetPerson = queryExec.executeQuery();
        }
        resultMap.put("rowSetPerson", rowSetPerson);
        return resultMap;
    }

    @Override
    protected Map _getAdjItemList(Context ctx, List adjParams) throws BOSException, EASBizException {
        String language = ctx.getLocale().getLanguage();
        String numbers = HRSchemeUtils.getStrFromList(adjParams);
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct cmpItem.fnumber as fnumber,cmpItem.fname_").append(language).append(" as fname,");
        sql.append(" cmpItem.fid as fid,cmpItem.FDataType,cmpItem.FDecDigital,cmpItem.fPrecisionType ");
        sql.append(" from T_HR_ADJSCHITEM adjSchItem inner join T_HR_CMPITEM cmpItem on adjSchItem.FAdjCmpItemID=cmpItem.fid ");
        sql.append(" inner join T_HR_ADJSCHEME adjScheme on adjScheme.fid=adjSchItem.fadjSchemeID where adjScheme.fnumber in ");
        sql.append(numbers);
        sql.append(" order by cmpItem.fnumber ");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, CmpItemInfo> numMap = new HashMap<String, CmpItemInfo>();
        try {
            while (iRowSet.next()) {
                String fid = iRowSet.getString("fid");
                String colNumber = iRowSet.getString("fnumber");
                String colName = iRowSet.getString("fname");
                int decDigital = iRowSet.getInt("FDecDigital");
                int precisionType = iRowSet.getInt("fPrecisionType");
                int dataType = iRowSet.getInt("FDataType");
                CmpItemInfo itemInfo = new CmpItemInfo();
                itemInfo.setId(BOSUuid.read((String)fid));
                itemInfo.setNumber(colNumber);
                itemInfo.setName(colName);
                itemInfo.setDataType(ItemDataTypeEnum.getEnum(dataType));
                itemInfo.setDecDigital(decDigital);
                itemInfo.setPrecisionType(CmpItemPrecisionTypeEnum.getEnum(precisionType));
                numMap.put(colNumber, itemInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return numMap;
    }

    @Override
    protected Map _getAdjEmpData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = (EntityViewInfo)paramMap.get("filterEntityInfo");
        EntityViewInfo filterUiInfo = (EntityViewInfo)paramMap.get("filterUiInfo");
        List adminOrgUnitList = (List)paramMap.get("adminOrgUnitList");
        boolean isShowSealUp = (Boolean)paramMap.get("isShowSealUp");
        String adminOrgTmpTabl = HRUtils.getAdminOrgTmpTbl(ctx, adminOrgUnitList, isShowSealUp);
        IRowSet rowSetPerson = null;
        ArrayList lstColumn = (ArrayList)paramMap.get("lstCmpItem");
        List hrOrgList = (List)paramMap.get("hrOrgList");
        if (entityViewInfo != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("FPERSONID"));
            SqlSelect sourceSelect = HRReportUtils.getFixedItemSQL(ctx, entityViewInfo);
            ArrayList orderedSelectors = this.buildSelectItemList(lstColumn, sourceSelect, entityViewInfo, ctx.getLocale().getLanguage());
            sourceSelect.selectList = orderedSelectors;
            StringBuffer sqlBuf = new StringBuffer();
            try {
                DrSQLFormater formater = new DrSQLFormater(sqlBuf);
                formater.formatSelect(sourceSelect);
            }
            catch (FormaterException e2) {
                throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
            }
            String fixedItemSql = this.addFixedAdjItem(sqlBuf.toString(), ctx.getLocale().getLanguage());
            String filterUiStr = filterUiInfo.toString();
            filterUiStr = StringUtils.replace((String)filterUiStr, (String)"'{ts''", (String)"{ts'");
            filterUiStr = StringUtils.replace((String)filterUiStr, (String)"''}'", (String)"'}");
            String finalSql = fixedItemSql + StringUtils.replace((String)filterUiStr, (String)"WHERE", (String)" AND ");
            if (hrOrgList != null && hrOrgList.size() <= 1) {
                HROrgUnitInfo info = (HROrgUnitInfo)hrOrgList.get(0);
                String hrId = info.getId().toString();
                finalSql = HRSchemeUtils.getReplaceQuerySQL(ctx, finalSql, hrId, false);
                finalSql = PersonInfoUtils.getOptimizeSql(finalSql);
                String tmpSql = finalSql.substring(0, finalSql.indexOf("ORDER BY"));
                String orderbyStr = finalSql.substring(finalSql.indexOf("ORDER BY"));
                orderbyStr = orderbyStr.replaceAll("\"PERSON\".FIndexOf", "INDEXOF");
                finalSql = tmpSql + " AND  \"ATTACHDEPT\".FID in (select fAdOrgUnitId from " + adminOrgTmpTabl + " orgTmpTbl )" + orderbyStr;
                rowSetPerson = HRUtils.executeQuery(ctx, finalSql);
            } else {
                String tmpSql = finalSql.substring(0, finalSql.indexOf("ORDER BY"));
                String exeSql = "";
                if (hrOrgList != null) {
                    for (int i = 0; i < hrOrgList.size(); ++i) {
                        HROrgUnitInfo info = (HROrgUnitInfo)hrOrgList.get(i);
                        String hrId = info.getId().toString();
                        exeSql = HRSchemeUtils.getReplaceQuerySQL(ctx, tmpSql, hrId, false);
                        exeSql = exeSql + " AND  \"ATTACHDEPT\".FID in (select fAdOrgUnitId from " + adminOrgTmpTabl + " orgTmpTbl )";
                        finalSql = i != 0 ? finalSql + " union " + exeSql : exeSql;
                    }
                }
                finalSql = PersonInfoUtils.getOptimizeSql(finalSql);
                finalSql = "select * from (" + finalSql + ") tbl  ORDER BY INDEXOF ASC, HROrgUnitID ASC";
                rowSetPerson = HRUtils.executeQuery(ctx, finalSql);
            }
        }
        HashMap<String, IRowSet> result = new HashMap<String, IRowSet>();
        result.put("empDataRowSet", rowSetPerson);
        return result;
    }

    private String addFixedAdjItem(String sql, String language) {
        StringBuffer fixedAdjSql = new StringBuffer(sql);
        int fromTag = sql.indexOf("FROM");
        StringBuffer adjItemSql = new StringBuffer();
        adjItemSql.append(",\"CMPITEM\".fNUMBER AS \"CMPITEM.NUMBER\",").append("\"CMPITEM\".fname_").append(language).append(" AS \"CMPITEM.name\",").append("\"CMPADJSCHITEM\".FNewValue AS newValue,").append("\"CMPADJSCHITEM\".FOldValue AS oldValue,").append("\"OLDSALP\".FName_").append(language).append(" AS \"OLDSALP.NAME\",").append("\"NEWSALP\".FName_").append(language).append(" AS \"NEWSALP.NAME\",").append("\"CMPADJSCHEME\".FEffectDate AS \"CMPADJSCHEME.effectDate\",").append("\"CMPADJSCHITEM\".FEffectDate AS effectDate,").append("\"CMPAC\".FName_").append(language).append(" AS \"CMPAC.NAME\",").append("\"CMPADJSCHITEM\".FRemark_").append(language).append(" AS remark,").append("\"CMPITEM\".fdataType AS \"CMPITEM.dataType\",").append("\"CMPITEM\".fdecDigital AS \"CMPITEM.decDigital\",").append("\"CMPITEM\".fprecisionType AS \"CMPITEM.precisionType\" ");
        fixedAdjSql = fixedAdjSql.insert(fromTag, adjItemSql);
        int whereFlag = fixedAdjSql.indexOf("WHERE");
        StringBuffer adjItemTblSql = new StringBuffer();
        adjItemTblSql.append(" INNER JOIN T_HR_ADJSCHITEM AS \"CMPADJSCHITEM\" ON \"PERSON\".FID = \"CMPADJSCHITEM\".FAdjEmpID\n");
        adjItemTblSql.append(" INNER JOIN T_HR_CMPITEM AS \"CMPITEM\" ON \"CMPADJSCHITEM\".FAdjCmpItemID = \"CMPITEM\".FID").append(" INNER JOIN T_HR_ADJSCHEME AS \"CMPADJSCHEME\" ON \"CMPADJSCHITEM\".FADJSCHEMEID = \"CMPADJSCHEME\".FID").append(" LEFT OUTER JOIN T_HR_CMPADJUESTIVECAUSE AS \"CMPAC\" ON \"CMPADJSCHITEM\".FAdjustReasonID = \"CMPAC\".FID").append(" LEFT OUTER JOIN T_HR_SALARIATTREE AS \"OLDSALP\" ON \"CMPADJSCHITEM\".FOldSalPoint = \"OLDSALP\".FID").append(" LEFT OUTER JOIN T_HR_SALARIATTREE AS \"NEWSALP\" ON \"CMPADJSCHITEM\".FNewSalPoint = \"NEWSALP\".FID ");
        fixedAdjSql.insert(whereFlag, adjItemTblSql);
        return fixedAdjSql.toString();
    }

    private ArrayList buildSelectItemList(List lstCmpItem, SqlSelect select, EntityViewInfo infoEntityView, String language) throws EmpCompenseException {
        List selectors = select.selectList;
        ArrayList<SqlSelectItem> orderedSelectors = new ArrayList<SqlSelectItem>();
        String itemNumber = "";
        SqlExprParser parser = null;
        SqlSelectItem item = null;
        int size = lstCmpItem.size();
        block2: for (int i = 0; i < size; ++i) {
            itemNumber = ((CmpItemInfo)lstCmpItem.get(i)).getNumber();
            item = null;
            int jsize = selectors.size();
            for (int j = 0; j < jsize; ++j) {
                if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equals(itemNumber.replaceAll("\"", "").trim())) continue;
                item = (SqlSelectItem)selectors.get(j);
                orderedSelectors.add(item);
                continue block2;
            }
        }
        try {
            itemNumber = "FPERSONID";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"PERSON\".FID");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
            itemNumber = "INDEXOF";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"PERSON\".FIndex");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
            itemNumber = "\"attachDept.fid\"";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"attachDept\".fid");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
            itemNumber = "HROrgUnitID";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"ATTACHTOUNIT\".FID");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
            itemNumber = "HROrgUnitName";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"ATTACHTOUNIT\".FName_" + language);
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        int jsize = selectors.size();
        for (int j = 0; j < jsize; ++j) {
            if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equalsIgnoreCase("FPER003")) continue;
            if (orderedSelectors.contains((SqlSelectItem)selectors.get(j))) break;
            orderedSelectors.add((SqlSelectItem)selectors.get(j));
            break;
        }
        return orderedSelectors;
    }
}

