/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.compensation.AdjStateEnum;
import com.kingdee.eas.hr.compensation.CalAdjustBalanceFactory;
import com.kingdee.eas.hr.compensation.CmpAdjExecutorFactory;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchDataPrvdFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.EMPsCmpScheme;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeException;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.ICalAdjustBalance;
import com.kingdee.eas.hr.compensation.ICmpAdjExecutor;
import com.kingdee.eas.hr.compensation.ICmpAdjustScheme;
import com.kingdee.eas.hr.compensation.ICmpSchDataPrvdFacade;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.IFixedCmpSchemeItem;
import com.kingdee.eas.hr.compensation.SchemeAuditedEnum;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.app.AbstractCmpAdjustFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CmpAdjustFacadeControllerBean
extends AbstractCmpAdjustFacadeControllerBean {
    @Override
    protected Map _getEmpsCmpScheme(Context ctx, List empIDList) throws EASDBException, EASBizException, BOSException {
        if (empIDList == null) {
            return null;
        }
        ICmpSchDataPrvdFacade dataPrvd = CmpSchDataPrvdFacadeFactory.getLocalInstance(ctx);
        CmpSchemeCollection cmpSchCol = dataPrvd.getValidCmpSch();
        HashMap<CmpSchemeInfo, List> empSch = new HashMap<CmpSchemeInfo, List>();
        int size = cmpSchCol.size();
        for (int i = 0; i < size; ++i) {
            CmpSchemeInfo info = cmpSchCol.get(i);
            empSch.put(info, dataPrvd.getCmpSchsEmp(info, empIDList));
        }
        HashMap<String, CmpSchemeCollection> rst = new HashMap<String, CmpSchemeCollection>();
        int size2 = empIDList.size();
        for (int i = 0; i < size2; ++i) {
            String empID = (String)empIDList.get(i);
            CmpSchemeCollection col = new CmpSchemeCollection();
            Iterator itl = empSch.entrySet().iterator();
            Map.Entry entry = null;
            while (itl.hasNext()) {
                List empList;
                entry = itl.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (value == null || !(empList = (List)value).contains(empID)) continue;
                col.add((CmpSchemeInfo)key);
            }
            rst.put(empID, col);
        }
        Connection con = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_AffairHistory SET FBelongCmpSch=? WHERE FIsTuned=0 AND FPersonID=?");
        PreparedStatement pstm = null;
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            int size3 = empIDList.size();
            for (int i = 0; i < size3; ++i) {
                String empID = (String)empIDList.get(i);
                Object value = rst.get(empID);
                StringBuffer belongSchID = new StringBuffer();
                if (value != null) {
                    CmpSchemeCollection schCol = (CmpSchemeCollection)((Object)value);
                    if (schCol.size() == 0) {
                        belongSchID.append("00000000-0000-0000-0000-00000000000000000000");
                    } else {
                        int jsize = schCol.size();
                        for (int j = 0; j < jsize; ++j) {
                            if (j != jsize - 1) {
                                belongSchID.append(schCol.get(j).getId());
                                belongSchID.append(";");
                                continue;
                            }
                            belongSchID.append(schCol.get(j).getId());
                        }
                    }
                }
                if (belongSchID.toString().equals("00000000-0000-0000-0000-00000000000000000000")) continue;
                pstm.setString(1, belongSchID.toString());
                pstm.setString(2, empID);
                pstm.executeUpdate();
            }
        }
        catch (Exception e) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)con);
        return rst;
    }

    @Override
    protected java.util.Date _getLastAdjEffDate(Context ctx, String cmpSchID, List empIDList, List cmpItemNumList) throws BOSException, EASBizException {
        int i;
        if (cmpSchID == null || empIDList == null || empIDList.size() == 0 || cmpItemNumList == null || cmpItemNumList.size() == 0) {
            return null;
        }
        Date lastDate = null;
        IQueryExecutor exec = null;
        IRowSet rs = null;
        StringBuffer oql = new StringBuffer();
        oql.append("select effectDate ");
        oql.append(" where ");
        int size = empIDList.size();
        for (i = 0; i < size; ++i) {
            if (i == 0) {
                oql.append(" ( adjEmp.id='");
                oql.append((String)empIDList.get(i));
                oql.append("'");
            } else {
                oql.append(" or adjEmp.id='");
                oql.append((String)empIDList.get(i));
                oql.append("'");
            }
            if (i != size - 1) continue;
            oql.append(")");
        }
        size = cmpItemNumList.size();
        for (i = 0; i < size; ++i) {
            if (i == 0) {
                oql.append(" and ( adjCmpItem.number='");
                oql.append((String)cmpItemNumList.get(i));
                oql.append("'");
            } else {
                oql.append(" or  adjCmpItem.number='");
                oql.append((String)cmpItemNumList.get(i));
                oql.append("'");
            }
            if (i != size - 1) continue;
            oql.append(")");
        }
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.GetLastAdjDateQuery"));
        exec.setObjectView(oql.toString());
        rs = exec.executeQuery();
        try {
            if (rs.next()) {
                lastDate = rs.getDate("effectDate");
            }
        }
        catch (SQLException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_ITEMNUM_EXEC, e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return lastDate;
    }

    @Override
    protected void _applyAdjScheme(Context ctx, String cmpSchID, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException, EASDBException {
        String adjSchID;
        int i;
        int size;
        if (cmpSchID == null) {
            return;
        }
        ICmpAdjExecutor exec = CmpAdjExecutorFactory.getLocalInstance(ctx);
        ICmpAdjustScheme adjSch = CmpAdjustSchemeFactory.getLocalInstance(ctx);
        CmpAdjustSchemeInfo adjSchInfo = null;
        List adjSchIDList = exec.getPrePeriodAdjSch(cmpSchID, startDate);
        if (adjSchIDList != null) {
            size = adjSchIDList.size();
            for (i = 0; i < size; ++i) {
                adjSchID = (String)adjSchIDList.get(i);
                ICalAdjustBalance adjBalance = CalAdjustBalanceFactory.getLocalInstance(ctx);
                Map empAdjMap = adjBalance.calAdjBalanceBySch(adjSchID);
                exec.updCmpSchBalance(adjSchID, empAdjMap);
                exec.updCmpSchDataBySch(adjSchID);
                ObjectUuidPK pk = new ObjectUuidPK(adjSchID);
                adjSchInfo = adjSch.getCmpAdjustSchemeInfo((IObjectPK)pk);
                adjSchInfo.setAdjSchemeState(AdjStateEnum.APPLIED);
                adjSch.submit((CoreBaseInfo)adjSchInfo);
            }
        }
        if ((adjSchIDList = exec.getPrePeriodAdjSch(cmpSchID, startDate, endDate)) != null) {
            size = adjSchIDList.size();
            for (i = 0; i < size; ++i) {
                adjSchID = (String)adjSchIDList.get(i);
                this._applyAdjScheme(ctx, adjSchID);
                ObjectUuidPK pk = new ObjectUuidPK(adjSchID);
                adjSchInfo = adjSch.getCmpAdjustSchemeInfo((IObjectPK)pk);
                adjSchInfo.setAdjSchemeState(AdjStateEnum.APPLIED);
                adjSch.submit((CoreBaseInfo)adjSchInfo);
            }
        }
    }

    @Override
    protected void _applyAdjScheme(Context ctx, String adjSchID) throws BOSException, EASBizException, EASDBException {
        if (adjSchID == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(adjSchID);
        ICmpAdjustScheme adjSch = CmpAdjustSchemeFactory.getLocalInstance(ctx);
        CmpAdjustSchemeInfo info = adjSch.getCmpAdjustSchemeInfo((IObjectPK)pk);
        info.setAdjSchemeState(AdjStateEnum.APPROVED);
        adjSch.submit((CoreBaseInfo)info);
        ICmpAdjExecutor exec = CmpAdjExecutorFactory.getLocalInstance(ctx);
        exec.updCmpSchDataBySch(adjSchID);
    }

    private boolean canCmpSchAdjusted(Context ctx, java.util.Date effDate, String cmpSchID) throws EASBizException, BOSException {
        java.util.Date curPeriodEndDate;
        boolean rst = true;
        String oql = "select *,cmpPeriod.* where id='" + cmpSchID + "'";
        ICmpScheme sch = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo info = sch.getCmpSchemeInfo(oql);
        if (!info.getEnable().equals((Object)StateEnum.ENABLE) || !info.getAudit().equals((Object)SchemeAuditedEnum.NOTAUDITED)) {
            rst = false;
        }
        if ((curPeriodEndDate = info.getCmpPeriod().getEndDate()) == null) {
            rst = false;
        }
        if (curPeriodEndDate != null && effDate.after(curPeriodEndDate)) {
            rst = false;
        }
        if (effDate.before(info.getCmpPeriod().getBeginDate())) {
            rst = false;
        }
        return rst;
    }

    @Override
    protected Map _getTransEmpsCmpScheme(Context ctx) throws BOSException, EASBizException, EASDBException {
        HashMap<String, EMPsCmpScheme> rst = new HashMap<String, EMPsCmpScheme>();
        Connection con = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID,FPersonID FROM T_HR_AffairHistory WHERE (FIsTuned=0 or FIsTuned is Null)");
        PreparedStatement pstm = null;
        ResultSet rs = null;
        HashSet<String> empSet = new HashSet<String>();
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            rs = pstm.executeQuery();
            while (rs.next()) {
                String fid = rs.getString(1);
                String personID = rs.getString(2);
                empSet.add(personID);
                EMPsCmpScheme value = new EMPsCmpScheme();
                value.empID = personID;
                rst.put(fid, value);
            }
        }
        catch (Exception e) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)con);
        ArrayList empIDList = new ArrayList();
        Iterator<Object> itl = empSet.iterator();
        while (itl.hasNext()) {
            empIDList.add(itl.next());
        }
        ICmpSchDataPrvdFacade dataPrvd = CmpSchDataPrvdFacadeFactory.getLocalInstance(ctx);
        CmpSchemeCollection cmpSchCol = dataPrvd.getValidCmpSch();
        HashMap empSch = new HashMap();
        int size = cmpSchCol.size();
        for (int i = 0; i < size; ++i) {
            CmpSchemeInfo info = cmpSchCol.get(i);
            rs = DbUtil.executeQuery((Context)ctx, (String)(" SELECT DISTINCT FPersonID FROM T_HR_AffairHistory WHERE (FIsTuned=0 or FIsTuned is Null)  AND FPERSONID IN ( SELECT FPERSONID FROM " + info.getHorTableName() + ")"));
            ArrayList<String> lstTemp = new ArrayList<String>();
            try {
                while (rs.next()) {
                    lstTemp.add(rs.getString("FPersonID"));
                }
            }
            catch (Exception e) {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs, null, null);
            }
            empSch.put(info, lstTemp);
        }
        HashMap<String, CmpSchemeCollection> empSchemMap = new HashMap<String, CmpSchemeCollection>();
        int size2 = empIDList.size();
        for (int i = 0; i < size2; ++i) {
            String empID = (String)empIDList.get(i);
            CmpSchemeCollection col = new CmpSchemeCollection();
            itl = empSch.entrySet().iterator();
            Map.Entry entry = null;
            while (itl.hasNext()) {
                List empList;
                entry = (Map.Entry)itl.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (value == null || !(empList = (List)value).contains(empID)) continue;
                col.add((CmpSchemeInfo)key);
            }
            empSchemMap.put(empID, col);
        }
        itl = rst.keySet().iterator();
        StringBuffer schemeIDBuff = new StringBuffer();
        StringBuffer schemeNameBuff = new StringBuffer();
        Map.Entry entry = null;
        while (itl.hasNext()) {
            entry = (Map.Entry)itl.next();
            EMPsCmpScheme value = (EMPsCmpScheme)entry.getValue();
            Object obj = empSchemMap.get(value.empID);
            if (obj != null && obj instanceof CmpSchemeCollection) {
                CmpSchemeCollection cols = (CmpSchemeCollection)((Object)obj);
                schemeIDBuff.delete(0, schemeIDBuff.length());
                schemeNameBuff.delete(0, schemeNameBuff.length());
                int size3 = cols.size();
                for (int i = 0; i < size3; ++i) {
                    schemeIDBuff.append(cols.get(i).getId().toString());
                    schemeNameBuff.append(cols.get(i).getName());
                    if (i == size3 - 1) continue;
                    schemeIDBuff.append(";");
                    schemeNameBuff.append(",");
                }
            }
            value.belongCmpScheme = schemeNameBuff.toString();
            value.belongCmpSchemeID = schemeIDBuff.toString();
        }
        return rst;
    }

    @Override
    protected Map _getEmpsCmpScheme(Context ctx) throws BOSException, EASBizException, EASDBException {
        HashMap<String, EMPsCmpScheme> rst = new HashMap<String, EMPsCmpScheme>();
        HashSet<String> newAdjEmp = new HashSet<String>();
        Connection con = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID,FPersonID,FBelongCmpSch,FTunedCmpSch FROM T_HR_AffairHistory WHERE FIsTuned=0");
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            rs = pstm.executeQuery();
            while (rs.next()) {
                String fid = rs.getString(1);
                String personID = rs.getString(2);
                String belongSchID = rs.getString(3);
                String tunedSchID = rs.getString(4);
                if (belongSchID == null) {
                    newAdjEmp.add(personID);
                }
                EMPsCmpScheme value = new EMPsCmpScheme();
                value.belongCmpSchemeID = belongSchID;
                value.tunedCmpSchemeID = tunedSchID;
                value.empID = personID;
                rst.put(fid, value);
            }
        }
        catch (Exception e) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)con);
        ICmpSchDataPrvdFacade dataPrvd = CmpSchDataPrvdFacadeFactory.getLocalInstance(ctx);
        CmpSchemeCollection validSchCol = dataPrvd.getValidCmpSch();
        HashMap<String, String> schemeMap = new HashMap<String, String>();
        int size = validSchCol.size();
        for (int i = 0; i < size; ++i) {
            schemeMap.put(validSchCol.get(i).getId().toString(), validSchCol.get(i).getName());
        }
        ArrayList empIDList = new ArrayList();
        Iterator<Object> itl = newAdjEmp.iterator();
        while (itl.hasNext()) {
            empIDList.add(itl.next());
        }
        Map newAdjEmpSch = this._getEmpsCmpScheme(ctx, empIDList);
        itl = rst.entrySet().iterator();
        StringBuffer buff = new StringBuffer();
        Map.Entry entry = null;
        while (itl.hasNext()) {
            entry = (Map.Entry)itl.next();
            EMPsCmpScheme value = (EMPsCmpScheme)entry.getValue();
            if ((value.belongCmpSchemeID == null || value.belongCmpSchemeID.length() == 0) && newAdjEmpSch != null) {
                buff.delete(0, buff.length());
                CmpSchemeCollection cols = (CmpSchemeCollection)((Object)newAdjEmpSch.get(value.empID));
                int size2 = cols.size();
                for (int i = 0; i < size2; ++i) {
                    buff.append(cols.get(i).getName());
                    if (i == size2 - 1) continue;
                    buff.append(",");
                }
                value.belongCmpScheme = buff.toString();
            } else {
                value.belongCmpScheme = this.idToName(value.belongCmpSchemeID, schemeMap);
            }
            if (value.tunedCmpSchemeID == null) continue;
            value.tunedCmpScheme = this.idToName(value.tunedCmpSchemeID, schemeMap);
        }
        return rst;
    }

    private String idToName(String cmpID, Map schMap) {
        if (cmpID == null || schMap == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        String[] idArray = cmpID.split(";");
        int size = idArray.length;
        for (int i = 0; i < size; ++i) {
            Object value = schMap.get(idArray[i]);
            if (value == null) continue;
            buff.append((String)value);
            if (i == size - 1) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    @Override
    protected Map _getSchAdjItemCollection(Context ctx, String fixedCmpSchID) throws BOSException, EASBizException, EASDBException {
        if (fixedCmpSchID == null) {
            return null;
        }
        IFixedCmpSchemeItem item = FixedCmpSchemeItemFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select cmpItem.*,cmpItem.cmpItemCatalog.* where fixedCmpScheme.id='");
        oql.append(fixedCmpSchID);
        oql.append("'");
        oql.append(" and (cmpItem.dataType=40 or cmpItem.dataType=50 or cmpItem.dataType=60)");
        oql.append(" and cmpItem.cmpItemCatalog.number != 'FPER'");
        FixedCmpSchemeItemCollection itemCol = item.getFixedCmpSchemeItemCollection(oql.toString());
        HashMap<String, CmpItemInfo> rst = new HashMap<String, CmpItemInfo>();
        int size = itemCol.size();
        for (int i = 0; i < size; ++i) {
            rst.put(itemCol.get(i).getCmpItem().getNumber(), itemCol.get(i).getCmpItem());
        }
        return rst;
    }

    @Override
    protected List _getCmpSchemePerson(Context ctx, String schemeID) throws BOSException, EASBizException, EASDBException {
        if (schemeID == null) {
            return null;
        }
        ICmpScheme sch = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo info = sch.getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(schemeID));
        String horTableName = info.getHorTableName();
        if (horTableName == null) {
            return null;
        }
        ArrayList<String> personsID = new ArrayList<String>();
        boolean i = false;
        Connection con = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FPERSONID FROM ");
        sql.append(horTableName);
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            rs = pstm.executeQuery();
            while (rs.next()) {
                String obj = rs.getString(1);
                if (obj == null || obj.length() != 44 && obj.length() != 28) continue;
                personsID.add(obj);
            }
        }
        catch (Exception e) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)con);
        return personsID;
    }

    @Override
    protected void _adjustFixedSalaryTable(Context ctx, Map mapNewValue, List lstItem) throws BOSException, EASBizException, EASDBException {
        Connection con = null;
        String sql = this.createAdjustFixedSalarySql("", lstItem);
        PreparedStatement pstm = null;
        int size = lstItem.size();
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            Iterator itor = mapNewValue.entrySet().iterator();
            Map.Entry entry = null;
            while (itor.hasNext()) {
                int i;
                entry = itor.next();
                String personid = (String)entry.getKey();
                Map mapItemValue = (Map)entry.getValue();
                for (i = 0; i < size; ++i) {
                    String number = (String)lstItem.get(i);
                    BigDecimal value = (BigDecimal)mapItemValue.get(number + "_NEW");
                    pstm.setBigDecimal(i + 1, value);
                }
                pstm.setString(i + 1, personid);
                pstm.addBatch();
            }
            pstm.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)con);
    }

    private String createAdjustFixedSalarySql(String tableName, List lstItem) {
        StringBuffer buff = new StringBuffer(1024);
        buff.append("update " + tableName + " set ");
        int size = lstItem.size();
        for (int i = 0; i < size; ++i) {
            String number = (String)lstItem.get(i);
            if (i != size - 1) {
                buff.append(number + "=?,");
                continue;
            }
            buff.append(number + "=? ");
        }
        buff.append(" where fpersonid = ? ");
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected PersonCollection _getPersonCollection(Context ctx, Map numbers) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tmpTable = null;
        PersonCollection personCollection = null;
        try {
            String persql = (String)numbers.get("isCmp009");
            numbers.remove("isCmp009");
            tmpTable = this.createIdTmpTable(ctx, pool, numbers);
            StringBuffer oql = new StringBuffer();
            oql.append("where number in (select FNumber from " + tmpTable + ") and id in (" + this.getAdminRangePersonIds(ctx) + ") ");
            if (persql != null && !persql.equals("")) {
                oql.append(" and id in (").append(persql).append(")");
            }
            personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(oql.toString());
            if (pool == null || tmpTable == null) return personCollection;
        }
        catch (Throwable throwable) {
            if (pool == null || tmpTable == null) throw throwable;
            pool.releaseTable(tmpTable);
            throw throwable;
        }
        pool.releaseTable(tmpTable);
        return personCollection;
    }

    private String createIdTmpTable(Context ctx, TempTablePool pool, Map numbers) throws BOSException {
        String cSql = " create TABLE  t1 (FNumber varchar(44) not null primary key) ";
        String tmpTableName = null;
        try {
            tmpTableName = pool.createTempTable(cSql);
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        StringBuffer sbInsert = new StringBuffer("insert into ");
        sbInsert.append(tmpTableName + " ( FNumber ) values (?) \n");
        Set idSet = numbers.keySet();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            list.add(new Object[]{it.next()});
        }
        HRUtil.executeBatch((Context)ctx, (String)sbInsert.toString(), list);
        return tmpTableName;
    }

    public String getAdminRangePersonIds(Context ctx) {
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select person.FID from T_BD_PERSON person ");
        sql.append(" inner join t_hr_personPosition pp on person.fid = pp.fPersonId");
        sql.append(" where pp.fpersonDep in ( ");
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE  ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append("))");
        return sql.toString();
    }
}

