/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.affair.AffairBizCheckFacadeFactory;
import com.kingdee.eas.hr.affair.FluctuationBillEntryFactory;
import com.kingdee.eas.hr.affair.FluctuationBillEntryInfo;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryFactory;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HireBillEntryFactory;
import com.kingdee.eas.hr.affair.HireBillEntryInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFacadeFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.compensation.AdjSchemeException;
import com.kingdee.eas.hr.compensation.AdjStateEnum;
import com.kingdee.eas.hr.compensation.CmpAdjExecutorFactory;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemCollection;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemFactory;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemInfo;
import com.kingdee.eas.hr.compensation.CmpAdjustFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpAdjustiveCauseCollection;
import com.kingdee.eas.hr.compensation.CmpAdjustiveCauseFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeException;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.ICmpAdjExecutor;
import com.kingdee.eas.hr.compensation.ICmpAdjustFacade;
import com.kingdee.eas.hr.compensation.ISalariatHiberProps;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.app.AbstractCmpAdjustSchemeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpAdjustSchemeControllerBean
extends AbstractCmpAdjustSchemeControllerBean {
    private static Logger logger = Logger.getLogger(CmpAdjustSchemeControllerBean.class);

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        String userid = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String functionName = "com.kingdee.eas.hr.compensation.CmpAdjSchemeFun";
        String operationName = "ActionSubmit";
        String temp = EnactmentServiceProxy.getEnacementService((Context)ctx).findSubmitProcDef(userid, (IObjectValue)model, functionName, operationName);
        if (temp == null || temp.trim().equals("")) {
            throw new AdjSchemeException(AdjSchemeException.CMP_WFNOTENABLE);
        }
        CmpAdjSchItemCollection coll = ((CmpAdjustSchemeInfo)model).getEntries();
        if (coll != null && coll.size() > 0) {
            CmpAdjSchItemInfo schItem = null;
            String updateSql = "";
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                schItem = coll.get(i);
                if (schItem.getFAffairHisID() == null) continue;
                updateSql = updateSql.length() < 1 ? updateSql + "'" + schItem.getFAffairHisID().toString() + "'" : updateSql + ",'" + schItem.getFAffairHisID().toString() + "'";
            }
            if (updateSql.length() > 0) {
                DbUtil.execute((Context)ctx, (String)("update T_HR_AffairBizHistory set ftuned = 1 where fid in (" + updateSql + ")"));
            }
        }
        ((CmpAdjustSchemeInfo)model).setAdjSchemeState(AdjStateEnum.APPROVING);
        return super.submit(ctx, model);
    }

    public void submit(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        String userid = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String functionName = "com.kingdee.eas.hr.compensation.CmpAdjSchemeFun";
        String operationName = "ActionSubmit";
        String temp = EnactmentServiceProxy.getEnacementService((Context)ctx).findSubmitProcDef(userid, (IObjectValue)model, functionName, operationName);
        if (temp == null || temp.trim().equals("")) {
            throw new AdjSchemeException(AdjSchemeException.CMP_WFNOTENABLE);
        }
        CmpAdjSchItemCollection coll = ((CmpAdjustSchemeInfo)model).getEntries();
        if (coll != null && coll.size() > 0) {
            CmpAdjSchItemInfo schItem = null;
            String updateSql = "";
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                schItem = coll.get(i);
                if (schItem.getFAffairHisID() == null) continue;
                updateSql = updateSql.length() < 1 ? updateSql + "'" + schItem.getFAffairHisID().toString() + "'" : updateSql + ",'" + schItem.getFAffairHisID().toString() + "'";
            }
            if (updateSql.length() > 0) {
                DbUtil.execute((Context)ctx, (String)("update T_HR_AffairBizHistory set ftuned = 1 where fid in (" + updateSql + ")"));
            }
        }
        ((CmpAdjustSchemeInfo)model).setAdjSchemeState(AdjStateEnum.APPROVING);
        super.submit(ctx, pk, model);
    }

    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _setAddNew(Context ctx, BOSUuid adjSchemeID) throws BOSException, EASBizException {
        this.setAdjSchemeState(ctx, adjSchemeID, AdjStateEnum.ADDNEW);
    }

    @Override
    protected void _setApproving(Context ctx, BOSUuid adjSchemeID) throws BOSException, EASBizException {
        this.setAdjSchemeState(ctx, adjSchemeID, AdjStateEnum.APPROVING);
    }

    protected void _setModify(Context ctx, BOSUuid adjSchemeID) throws BOSException, EASBizException {
        this.setAdjSchemeState(ctx, adjSchemeID, AdjStateEnum.MODIFY);
    }

    protected void _auditNotPass(Context ctx, BOSUuid adjSchemeID) throws BOSException, EASBizException {
        this.setAdjSchemeState(ctx, adjSchemeID, AdjStateEnum.NOTPASS);
    }

    @Override
    protected void _audit(Context ctx, BOSUuid adjSchID) throws BOSException, EASBizException, EASDBException {
        this.auditAdjScheme(ctx, adjSchID, true);
    }

    @Override
    protected void _wfAudit(Context ctx, BOSUuid adjSchID) throws BOSException, EASBizException, EASDBException {
        this.auditAdjScheme(ctx, adjSchID, false);
    }

    private void auditAdjScheme(Context ctx, BOSUuid adjSchID, boolean isIgnoreWF) throws BOSException, EASBizException, EASDBException {
        if (adjSchID == null) {
            return;
        }
        this.setAdjSchemeState(ctx, adjSchID, AdjStateEnum.APPROVED);
        ICmpAdjExecutor exec = CmpAdjExecutorFactory.getLocalInstance(ctx);
        exec.updCmpSchDataBySch(adjSchID.toString());
        StringBuffer deleteSQL = new StringBuffer("");
        deleteSQL.append(" DELETE T_HR_TryPeriodEndInput WHERE FAdjustSchemeID = '");
        deleteSQL.append(adjSchID.toString());
        deleteSQL.append("'");
        DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
        CmpAdjustSchemeInfo adjustscheme = this.getCmpAdjustSchemeInfo(ctx, (IObjectPK)new ObjectUuidPK(adjSchID));
        CmpAdjSchItemCollection coll = adjustscheme.getEntries();
        if (coll != null && coll.size() > 0) {
            CmpAdjSchItemInfo schItem = null;
            String updateSql = "";
            Object[] values = null;
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                schItem = coll.get(i);
                if (schItem.getFAffairHisID() != null) {
                    updateSql = updateSql.length() < 1 ? updateSql + "'" + schItem.getFAffairHisID().toString() + "'" : updateSql + ",'" + schItem.getFAffairHisID().toString() + "'";
                }
                if (schItem.getAdjEmp() == null) continue;
                values = new Object[]{schItem.getAdjEmp().getId().toString(), schItem.getAdjEmp().getId().toString()};
                paramList.add(values);
            }
            if (updateSql.length() > 0) {
                DbUtil.execute((Context)ctx, (String)("update T_HR_AffairBizHistory set ftuned = 1 where fid in (" + updateSql + ")"));
            }
        }
    }

    private void setAdjSchemeState(Context ctx, BOSUuid adjSchID, AdjStateEnum state) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().disableNextCallServices();
        if (adjSchID == null) {
            return;
        }
        DbUtil.execute((Context)ctx, (String)("update T_HR_ADJSCHEME set FAdjSchemeState = " + state.getValue() + " where fid = '" + adjSchID.toString() + "'"));
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CmpAdjustSchemeInfo casInfo = this.getCmpAdjustSchemeInfo(ctx, pk);
        if (casInfo.getAdjSchemeState().getValue() != 10) {
            throw new AdjSchemeException(AdjSchemeException.CANNT_DELETE);
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (casInfo.getCompany() != null && codingRuleManager.isExist((IObjectValue)casInfo, casInfo.getCompany().getId().toString()) && codingRuleManager.isUseIntermitNumber((IObjectValue)casInfo, casInfo.getCompany().getId().toString())) {
            codingRuleManager.recycleNumber((IObjectValue)casInfo, casInfo.getCompany().getId().toString(), casInfo.getString("number"));
        }
        StringBuffer deleteSQL = new StringBuffer("");
        deleteSQL.append(" DELETE T_HR_TryPeriodEndInput WHERE FAdjustSchemeID = '");
        deleteSQL.append(pk.toString());
        deleteSQL.append("'");
        DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
        ICodingRuleManager icrm = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String CuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (icrm.isExist((IObjectValue)casInfo, CuID) && icrm.isUseIntermitNumber((IObjectValue)casInfo, CuID)) {
            icrm.recycleNumber((IObjectValue)casInfo, CuID, casInfo.getNumber());
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _setDestory(Context ctx, BOSUuid adjSchemeID) throws BOSException, EASBizException {
        this.setAdjSchemeState(ctx, adjSchemeID, AdjStateEnum.DESTORY);
        ICmpAdjustFacade adjFacade = CmpAdjustFacadeFactory.getLocalInstance(ctx);
        try {
            adjFacade.applyAdjScheme(adjSchemeID.toString());
        }
        catch (EASDBException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException();
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CmpAdjustSchemeInfo info = (CmpAdjustSchemeInfo)model;
        if (info != null) {
            info.setCreateTime(null);
            if ("".equals(info.getNumber()) || info.getNumber() == null) {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                String newRuleNo = iCodingRuleManager.getNumber((IObjectValue)info, info.getHrOrgUnit().getId().toString());
                info.setNumber(newRuleNo);
            }
        }
        IObjectPK pk = super._addnew(ctx, model);
        this._checkNumberBlank(ctx, pk, (IObjectValue)info);
        this._checkNumberDup(ctx, pk, (IObjectValue)info);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 1);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            ObjectUuidPK retValue = new ObjectUuidPK(coreBaseInfo.getId());
            super.update(ctx, (IObjectPK)retValue, coreBaseInfo);
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)coreBaseInfo.getBOSType(), (IObjectPK)retValue, (String)((CmpAdjustSchemeInfo)coreBaseInfo).getNumber(), (String)"cmpadjSch_update");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            return retValue;
        }
        IObjectPK retValue = super.addnew(ctx, coreBaseInfo);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)coreBaseInfo.getBOSType(), (IObjectPK)retValue, (String)((CmpAdjustSchemeInfo)coreBaseInfo).getNumber(), (String)"cmpadjSch_addnew");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return retValue;
    }

    @Override
    protected HashMap _getFixedPersonsAndSalPointName(Context ctx, String salPointname, String fixedCmpSchemeID) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List lstPerson = this.getFixedPerson(ctx, fixedCmpSchemeID);
        map.put("personIdList", lstPerson);
        HashMap mapSalPointName = this.getSalPointName(ctx, salPointname);
        map.put("salPointNameMap", mapSalPointName);
        FixedCmpSchemeItemCollection colItem = this.getFixedCmpItems(ctx, fixedCmpSchemeID);
        map.put("fixedCmpItems", (Object)colItem);
        return map;
    }

    private HashMap getSalPointName(Context ctx, String salPointname) throws BOSException {
        StringBuffer salPointStrBuf = new StringBuffer();
        salPointStrBuf.append("select T1.fid,T1.");
        salPointStrBuf.append(salPointname);
        salPointStrBuf.append(",T1.FParentId,T2.");
        salPointStrBuf.append(salPointname);
        salPointStrBuf.append(" from T_HR_SALARIATTREE T1 inner join T_HR_SALARIATTREE T2 on T1.Fparentid = T2.Fid");
        HashMap<String, String> mapSalPointName = new HashMap<String, String>();
        IRowSet salPointRowSet = DbUtil.executeQuery((Context)ctx, (String)salPointStrBuf.toString());
        try {
            while (salPointRowSet.next()) {
                mapSalPointName.put(salPointRowSet.getString(1), salPointRowSet.getString(2) + "||" + salPointRowSet.getString(3) + "!!" + salPointRowSet.getString(4));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return mapSalPointName;
    }

    private List getFixedPerson(Context ctx, String fixedCmpSchemeID) throws BOSException {
        StringBuffer schemeStrBuf = new StringBuffer();
        ArrayList<String> lstPerson = new ArrayList<String>(1024);
        schemeStrBuf.append("select fpersonid from t_hr_fixedcmpschemeperson where ffixedcmpschemeid='");
        schemeStrBuf.append(fixedCmpSchemeID);
        schemeStrBuf.append("' and fenable = 1");
        if (fixedCmpSchemeID != null) {
            IRowSet personRowSet = DbUtil.executeQuery((Context)ctx, (String)schemeStrBuf.toString());
            try {
                while (personRowSet.next()) {
                    lstPerson.add(personRowSet.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            lstPerson.add("");
        }
        return lstPerson;
    }

    public FixedCmpSchemeItemCollection getFixedCmpItems(Context ctx, String fixedCmpSchemeID) throws BOSException {
        if (fixedCmpSchemeID != null) {
            StringBuffer oqlStrBuf = new StringBuffer();
            String cmpItemids = null;
            try {
                cmpItemids = HRUtils.getCmpItemIds(ctx);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            if (cmpItemids != null) {
                oqlStrBuf.append("select * ,cmpItem.*,cmpItem.hrOrgUnit.id,fixedCmpScheme.* where fixedCmpScheme.id='");
                oqlStrBuf.append(fixedCmpSchemeID);
                oqlStrBuf.append("' and cmpItem.id in (" + cmpItemids + ") and cmpItem.enable = 1");
            } else {
                oqlStrBuf.append("select * ,cmpItem.*,fixedCmpScheme.* where fixedCmpScheme.id='");
                oqlStrBuf.append(fixedCmpSchemeID);
                oqlStrBuf.append("' and cmpItem.enable = 1");
            }
            FixedCmpSchemeItemCollection colItem = FixedCmpSchemeItemFactory.getLocalInstance(ctx).getFixedCmpSchemeItemCollection(oqlStrBuf.toString());
            return colItem;
        }
        return null;
    }

    @Override
    protected HashMap _salInitInfo(Context ctx, EntityViewInfo empAdjustiveCauseEvi, String fixedCmpSchemeID) throws BOSException, EASBizException {
        HashMap<String, Object> salInfoMap = new HashMap<String, Object>();
        CmpAdjustiveCauseCollection coll = CmpAdjustiveCauseFactory.getLocalInstance(ctx).getCmpAdjustiveCauseCollection(empAdjustiveCauseEvi);
        salInfoMap.put("cmpAdjustiveCause", (Object)coll);
        FixedCmpSchemeInfo fixedInfo = null;
        fixedInfo = StringUtils.isEmpty((String)fixedCmpSchemeID) ? HRUtils.getFixedCmpScheme(ctx) : FixedCmpSchemeFactory.getLocalInstance(ctx).getFixedCmpSchemeInfo((IObjectPK)new ObjectUuidPK(fixedCmpSchemeID));
        if (fixedInfo == null) {
            return salInfoMap;
        }
        salInfoMap.put("FixedCmpSchemeInfo", fixedInfo);
        try {
            SalariatSchemeInfo info = fixedInfo.getSalariatScheme();
            if (info != null) {
                String salSchemeID = info.getId().toString();
                Map mapSal = this.getSalPointInfo(ctx, salSchemeID);
                Map mapPoint = HRUtils.getPointValueMap(ctx, salSchemeID);
                salInfoMap.put("SPSchema", 1);
                salInfoMap.put("schemeInfoIsNull", "false");
                salInfoMap.put("salSchemeID", salSchemeID);
                salInfoMap.put("mapSal", mapSal);
                salInfoMap.put("mapPoint", mapPoint);
            } else {
                salInfoMap.put("SPSchema", 0);
                salInfoMap.put("schemeInfoIsNull", "true");
            }
        }
        catch (FixedCmpSchemeException e) {
            throw new FixedCmpSchemeException(FixedCmpSchemeException.NOT_ENABLE_SALARIATSCHEME);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return salInfoMap;
    }

    private Map getSalPointInfo(Context ctx, String salSchemeID) throws Exception {
        if (salSchemeID == null) {
            return null;
        }
        HashMap<String, SalariatHiberPropsInfo> hst = new HashMap<String, SalariatHiberPropsInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme", (Object)salSchemeID));
        evi.setFilter(filterInfoItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("*"));
        ISalariatHiberProps iSalariatHiberProps = SalariatHiberPropsFactory.getLocalInstance(ctx);
        SalariatHiberPropsCollection col = iSalariatHiberProps.getSalariatHiberPropsCollection(evi);
        if (col == null || col.size() <= 0) {
            return null;
        }
        Iterator itr = col.iterator();
        SalariatHiberPropsInfo info = null;
        while (itr.hasNext()) {
            info = (SalariatHiberPropsInfo)itr.next();
            hst.put(info.getId().toString(), info);
        }
        return hst;
    }

    @Override
    protected IRowSet _getAdjustSchemePrint(Context ctx, String adjustNumber, Set setAdjEmpID) throws BOSException, EASBizException {
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpAdjustPrintQuery");
        IQueryExecutor queryExcu = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("PERSON.id", (Object)setAdjEmpID, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("CMPADJSCHEME.Number", (Object)adjustNumber));
        viewInfo.setFilter(fi);
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rs = queryExcu.executeQuery();
        return rs;
    }

    @Override
    protected IRowSet _getAdjustSchemePrintRowSet(Context ctx, String adjustNumber, String adjEmpNumber) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("adjEmp.Number", (Object)adjEmpNumber, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("adjScheme.Number", (Object)adjustNumber));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("adjCmpItem.id"));
        sic.add(new SelectorItemInfo("adjCmpItem.name"));
        sic.add(new SelectorItemInfo("adjCmpItem.number"));
        sic.add(new SelectorItemInfo("oldValue"));
        sic.add(new SelectorItemInfo("newValue"));
        sic.add(new SelectorItemInfo("adjEmp.Number"));
        sic.add(new SelectorItemInfo("oldSalPoint.name"));
        sic.add(new SelectorItemInfo("newSalPoint.name"));
        viewInfo.setSelector(sic);
        CmpAdjSchItemCollection adjSchItemCollection = CmpAdjSchItemFactory.getLocalInstance(ctx).getCmpAdjSchItemCollection(viewInfo);
        int len = 15;
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(4 * len + 4);
            for (int i = 0; i < len; ++i) {
                drs.setColInfo(4 * i + 1, new ColInfo("Field" + i, "Field" + i, 12, null));
                drs.setColInfo(4 * i + 2, new ColInfo("old" + i, "old" + i, 3, null));
                drs.setColInfo(4 * i + 3, new ColInfo("new" + i, "new" + i, 3, null));
                drs.setColInfo(4 * i + 4, new ColInfo("sum" + i, "sum" + i, 3, null));
            }
            drs.setColInfo(61, new ColInfo("empNumber", "empNumber", 12, null));
            drs.setColInfo(62, new ColInfo("SalPoint", "SalPoint", 12, null));
            drs.setColInfo(63, new ColInfo("oldSal", "oldSal", 12, null));
            drs.setColInfo(64, new ColInfo("newSal", "newSal", 12, null));
            int flag = 0;
            int mark = 0;
            drs.moveToInsertRow();
            for (int i = 0; i < adjSchItemCollection.size(); ++i) {
                drs.updateString("empNumber", adjSchItemCollection.get(i).getAdjEmp().getNumber());
                if ("FSAL000".equals(adjSchItemCollection.get(i).getAdjCmpItem().getNumber())) {
                    SalariatHiberPropsInfo newSal = adjSchItemCollection.get(i).getNewSalPoint();
                    SalariatHiberPropsInfo oldSal = adjSchItemCollection.get(i).getOldSalPoint();
                    if (newSal != null && oldSal != null) {
                        drs.updateString("SalPoint", adjSchItemCollection.get(i).getAdjCmpItem().getName());
                        drs.updateString("newSal", newSal.getName());
                        drs.updateString("oldSal", oldSal.getName());
                    } else if (newSal != null && oldSal == null) {
                        drs.updateString("SalPoint", adjSchItemCollection.get(i).getAdjCmpItem().getName());
                        drs.updateString("newSal", newSal.getName());
                        drs.updateNull("oldSal");
                    } else if (newSal == null && oldSal != null) {
                        drs.updateString("SalPoint", adjSchItemCollection.get(i).getAdjCmpItem().getName());
                        drs.updateNull("newSal");
                        drs.updateString("oldSal", oldSal.getName());
                    } else {
                        drs.updateNull("SalPoint");
                        drs.updateNull("newSal");
                        drs.updateNull("oldSal");
                    }
                    ++mark;
                    continue;
                }
                drs.updateString("Field" + flag, adjSchItemCollection.get(i).getAdjCmpItem().getName());
                if (adjSchItemCollection.get(i).getOldValue() != null) {
                    drs.updateBigDecimal("old" + flag, adjSchItemCollection.get(i).getOldValue());
                } else {
                    drs.updateString("old" + flag, "0");
                }
                if (adjSchItemCollection.get(i).getNewValue() != null) {
                    drs.updateBigDecimal("new" + flag, adjSchItemCollection.get(i).getNewValue());
                } else {
                    drs.updateString("new" + flag, "0");
                }
                BigDecimal newValue = adjSchItemCollection.get(i).getNewValue();
                BigDecimal oldValue = adjSchItemCollection.get(i).getOldValue();
                if (newValue != null && oldValue != null) {
                    drs.updateBigDecimal("sum" + flag, newValue.subtract(oldValue));
                } else if (newValue != null && oldValue == null) {
                    oldValue = new BigDecimal(0);
                    drs.updateBigDecimal("sum" + flag, newValue.subtract(oldValue));
                } else if (newValue == null && oldValue != null) {
                    newValue = new BigDecimal(0);
                    drs.updateBigDecimal("sum" + flag, newValue.subtract(oldValue));
                } else {
                    drs.updateString("sum" + flag, "0");
                }
                ++flag;
            }
            for (int k = flag; k < len; ++k) {
                drs.updateString("Field" + k, null);
                drs.updateNull("old" + k);
                drs.updateNull("new" + k);
                drs.updateNull("sum" + k);
            }
            if (mark == 0) {
                drs.updateNull("SalPoint");
                drs.updateNull("newSal");
                drs.updateNull("oldSal");
            }
            drs.insertRow();
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return drs;
    }

    @Override
    protected IRowSet _getAdjustSchemeAduit(Context ctx, String adjustNumber, String adjEmpNumber) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("adjEmp.Number", (Object)adjEmpNumber, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("adjScheme.Number", (Object)adjustNumber));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("adjCmpItem.id"));
        sic.add(new SelectorItemInfo("adjCmpItem.name"));
        sic.add(new SelectorItemInfo("adjCmpItem.number"));
        sic.add(new SelectorItemInfo("oldValue"));
        sic.add(new SelectorItemInfo("newValue"));
        sic.add(new SelectorItemInfo("adjEmp.Number"));
        sic.add(new SelectorItemInfo("effectDate"));
        sic.add(new SelectorItemInfo("dispatchNum"));
        viewInfo.setSelector(sic);
        CmpAdjSchItemCollection adjSchItemCollection = CmpAdjSchItemFactory.getLocalInstance(ctx).getCmpAdjSchItemCollection(viewInfo);
        DynamicRowSet drs = null;
        try {
            int length = adjSchItemCollection.size();
            drs = new DynamicRowSet(7);
            drs.setColInfo(1, new ColInfo("Field", "Field", 12, null));
            drs.setColInfo(2, new ColInfo("old", "old", 3, null));
            drs.setColInfo(3, new ColInfo("new", "new", 3, null));
            drs.setColInfo(4, new ColInfo("sum", "sum", 3, null));
            drs.setColInfo(5, new ColInfo("dispatchNum", "dispatchNum", 12, null));
            drs.setColInfo(6, new ColInfo("effectDate", "effectDate", 12, null));
            drs.setColInfo(7, new ColInfo("empNumber", "empNumber", 12, null));
            for (int i = 0; i < length; ++i) {
                drs.moveToInsertRow();
                if ("FSAL000".equals(adjSchItemCollection.get(i).getAdjCmpItem().getNumber())) continue;
                drs.updateString("Field", adjSchItemCollection.get(i).getAdjCmpItem().getName());
                if (adjSchItemCollection.get(i).getOldValue() != null) {
                    drs.updateBigDecimal("old", adjSchItemCollection.get(i).getOldValue());
                } else {
                    drs.updateString("old", "0");
                }
                if (adjSchItemCollection.get(i).getNewValue() != null) {
                    drs.updateBigDecimal("new", adjSchItemCollection.get(i).getNewValue());
                } else {
                    drs.updateString("new", "0");
                }
                BigDecimal newValue = adjSchItemCollection.get(i).getNewValue();
                BigDecimal oldValue = adjSchItemCollection.get(i).getOldValue();
                if (newValue != null && oldValue != null) {
                    drs.updateBigDecimal("sum", newValue.subtract(oldValue));
                } else if (newValue != null && oldValue == null) {
                    oldValue = new BigDecimal(0);
                    drs.updateBigDecimal("sum", newValue.subtract(oldValue));
                } else if (newValue == null && oldValue != null) {
                    newValue = new BigDecimal(0);
                    drs.updateBigDecimal("sum", newValue.subtract(oldValue));
                } else {
                    drs.updateString("sum", "0");
                }
                drs.updateString("empNumber", adjSchItemCollection.get(i).getAdjEmp().getNumber());
                drs.updateString("effectDate", adjSchItemCollection.get(i).getEffectDate().toString());
                drs.updateString("dispatchNum", adjSchItemCollection.get(i).getDispatchNum());
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return drs;
    }

    @Override
    protected IRowSet _getAdjustSchemePrintCount(Context ctx, String adjustNumber, String adjEmpNumber) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("adjEmp.Number", (Object)adjEmpNumber, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("adjScheme.Number", (Object)adjustNumber));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("adjCmpItem.number"));
        viewInfo.setSelector(sic);
        CmpAdjSchItemCollection adjSchItemCollection = CmpAdjSchItemFactory.getLocalInstance(ctx).getCmpAdjSchItemCollection(viewInfo);
        int countTotal = adjSchItemCollection.size();
        for (int i = 0; i < adjSchItemCollection.size(); ++i) {
            if (!"FSAL000".equals(adjSchItemCollection.get(i).getAdjCmpItem().getNumber())) continue;
            --countTotal;
        }
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(1);
            drs.setColInfo(1, new ColInfo("count", "count", 4, null));
            drs.moveToInsertRow();
            drs.updateInt("count", countTotal);
            drs.insertRow();
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return drs;
    }

    @Override
    protected void _cancelAudit(Context ctx, String adjustSchID) throws BOSException, EASBizException {
        if (adjustSchID == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(adjustSchID);
        CmpAdjustSchemeInfo adjScheme = this.getCmpAdjustSchemeInfo(ctx, (IObjectPK)pk);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)adjScheme.getBOSType(), (IObjectPK)pk, (String)adjScheme.getNumber(), (String)"cmpadjSch_cancelAudit");
        this.setAdjSchemeState(ctx, BOSUuid.read((String)adjustSchID), AdjStateEnum.ADDNEW);
        ICmpAdjExecutor exec = CmpAdjExecutorFactory.getLocalInstance(ctx);
        exec.cancelAuditAdjSch(adjustSchID);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected IRowSet _checkIsCanUnAudit(Context ctx, String adjustSchID) throws BOSException, EASBizException {
        String HROrgID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        String l = HRUtils.getShortCode(ctx);
        sql.append(" select  p.fnumber as perNum, p.fname_" + l + " as perName,").append(" item.fname_" + l + " as itemName,adjItem.feffectdate as effectdate,").append(" case when FDisplayFlag = 1 then adj.fnumber when FDisplayFlag = 0 then null end as adjSchemeNum, ").append(" case when FDisplayFlag = 1 then null when FDisplayFlag = 0 then fixdSch.fnumber end as fixedNumber").append(" from t_hr_adjscheme adj ").append(" inner join t_hr_adjschitem adjItem on adjItem.fadjschemeid = adj.fid ").append(" inner join t_bd_person p on p.fid = adjItem.fadjempid ").append(" inner join t_hr_cmpitem item on item.fid  = adjItem.fadjcmpitemid ").append(" inner join ( select entry1.fadjempid,entry1.fadjcmpitemid,entry1.feffectdate").append(" from t_hr_adjscheme a1 ").append(" inner join t_hr_adjschitem entry1 on entry1.fadjschemeid = a1.fid ").append(" where a1.fid = '").append(adjustSchID).append("' ").append(" and exists ( select a2.fid ").append(" from t_hr_adjscheme a2 ").append(" inner join t_hr_adjschitem entry2 on entry2.fadjschemeid = a2.fid ").append(" where a2.fhrorgunitid = '").append(HROrgID).append("' ").append(" and a2.fishistorydata = 0 ").append(" and a2.fadjschemestate = 30 ").append(" and entry2.fadjempid = entry1.fadjempid ").append(" and entry2.fadjcmpitemid = entry1.fadjcmpitemid ").append(" and entry1.feffectdate < entry2.feffectdate ) ").append(" ) TT ").append(" on ( TT.fadjempid = adjItem.fadjempid ").append(" and TT.fadjcmpitemid = adjItem.fadjcmpitemid ").append(" and TT.feffectdate < adjItem.feffectdate ) ").append(" left outer join T_HR_FixedCmpScheme fixdSch on fixdSch.fid = adjItem.FFixedCmpSchemeID").append(" where adj.fhrorgunitid = '").append(HROrgID).append("' ").append(" and adj.fishistorydata = 0 ").append(" and adj.fadjschemestate = 30 ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet.size() > 0) {
            return rowSet;
        }
        return null;
    }

    @Override
    protected Map _getCmpDataFromFluctuation(Context ctx, List personIDs) throws BOSException, EASBizException {
        if (personIDs == null || personIDs.size() == 0) {
            return null;
        }
        String personID = null;
        boolean isBillUpgrade = AffairBizCheckFacadeFactory.getLocalInstance((Context)ctx).isUpgradeToBiz();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemCollection sorterCollection = new SorterItemCollection();
        String sorterItem = "effectDate";
        if (isBillUpgrade) {
            sorterItem = "bizDate";
        }
        SorterItemInfo sortInfo = new SorterItemInfo(sorterItem);
        sortInfo.setSortType(SortType.DESCEND);
        sorterCollection.getSorter().add(sortInfo);
        viewInfo.setSorter(sorterCollection);
        SelectorItemCollection sic = new SelectorItemCollection();
        if (isBillUpgrade) {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("oldAdminOrg.id"));
            sic.add(new SelectorItemInfo("oldAdminOrg.name"));
            sic.add(new SelectorItemInfo("oldAdminOrg.number"));
            sic.add(new SelectorItemInfo("oldAdminOrg.displayName"));
            sic.add(new SelectorItemInfo("oldPosition.id"));
            sic.add(new SelectorItemInfo("oldPosition.name"));
            sic.add(new SelectorItemInfo("oldPosition.number"));
            sic.add(new SelectorItemInfo("oldPosition.PositionType.id"));
            sic.add(new SelectorItemInfo("oldPosition.PositionType.name"));
            sic.add(new SelectorItemInfo("oldPosition.PositionType.number"));
            sic.add(new SelectorItemInfo("oldJob.id"));
            sic.add(new SelectorItemInfo("oldJob.name"));
            sic.add(new SelectorItemInfo("oldJob.number"));
            sic.add(new SelectorItemInfo("oldJobLevel.id"));
            sic.add(new SelectorItemInfo("oldJobLevel.number"));
            sic.add(new SelectorItemInfo("oldJobLevel.name"));
            sic.add(new SelectorItemInfo("adminOrg.id"));
            sic.add(new SelectorItemInfo("adminOrg.number"));
            sic.add(new SelectorItemInfo("adminOrg.name"));
            sic.add(new SelectorItemInfo("adminOrg.displayName"));
            sic.add(new SelectorItemInfo("oldJobGrade.id"));
            sic.add(new SelectorItemInfo("oldJobGrade.number"));
            sic.add(new SelectorItemInfo("oldJobGrade.name"));
            sic.add(new SelectorItemInfo("position.id"));
            sic.add(new SelectorItemInfo("position.number"));
            sic.add(new SelectorItemInfo("position.name"));
            sic.add(new SelectorItemInfo("position.PositionType.id"));
            sic.add(new SelectorItemInfo("position.PositionType.name"));
            sic.add(new SelectorItemInfo("position.PositionType.number"));
            sic.add(new SelectorItemInfo("job.id"));
            sic.add(new SelectorItemInfo("job.number"));
            sic.add(new SelectorItemInfo("job.name"));
            sic.add(new SelectorItemInfo("jobLevel.id"));
            sic.add(new SelectorItemInfo("jobLevel.number"));
            sic.add(new SelectorItemInfo("jobLevel.name"));
            sic.add(new SelectorItemInfo("jobGrade.id"));
            sic.add(new SelectorItemInfo("jobGrade.number"));
            sic.add(new SelectorItemInfo("jobGrade.name"));
        } else {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("NewSalePoint.id"));
            sic.add(new SelectorItemInfo("NewSalePoint.name"));
            sic.add(new SelectorItemInfo("NewSalePoint.number"));
            sic.add(new SelectorItemInfo("NewSalePoint.parent.id"));
            sic.add(new SelectorItemInfo("NewSalePoint.parent.name"));
            sic.add(new SelectorItemInfo("NewSalePoint.parent.number"));
            sic.add(new SelectorItemInfo("NowSalePoint.id"));
            sic.add(new SelectorItemInfo("NowSalePoint.name"));
            sic.add(new SelectorItemInfo("NowSalePoint.number"));
            sic.add(new SelectorItemInfo("NowSalePoint.parent.id"));
            sic.add(new SelectorItemInfo("NowSalePoint.parent.name"));
            sic.add(new SelectorItemInfo("NowSalePoint.parent.number"));
            sic.add(new SelectorItemInfo("PointValue"));
            sic.add(new SelectorItemInfo("oldPosType.id"));
            sic.add(new SelectorItemInfo("oldPosType.name"));
            sic.add(new SelectorItemInfo("oldPosType.number"));
            sic.add(new SelectorItemInfo("newPosType.id"));
            sic.add(new SelectorItemInfo("newPosType.name"));
            sic.add(new SelectorItemInfo("newPosType.number"));
            sic.add(new SelectorItemInfo("oldPosition.id"));
            sic.add(new SelectorItemInfo("oldPosition.name"));
            sic.add(new SelectorItemInfo("oldPosition.number"));
            sic.add(new SelectorItemInfo("oldJob.id"));
            sic.add(new SelectorItemInfo("oldJob.name"));
            sic.add(new SelectorItemInfo("oldJob.number"));
            sic.add(new SelectorItemInfo("oldJobLevel.id"));
            sic.add(new SelectorItemInfo("oldJobLevel.number"));
            sic.add(new SelectorItemInfo("oldJobLevel.name"));
            sic.add(new SelectorItemInfo("newPosition.id"));
            sic.add(new SelectorItemInfo("newPosition.number"));
            sic.add(new SelectorItemInfo("newPosition.name"));
            sic.add(new SelectorItemInfo("newJob.id"));
            sic.add(new SelectorItemInfo("newJob.number"));
            sic.add(new SelectorItemInfo("newJob.name"));
            sic.add(new SelectorItemInfo("newJobLevel.id"));
            sic.add(new SelectorItemInfo("newJobLevel.number"));
            sic.add(new SelectorItemInfo("newJobLevel.name"));
            sic.add(new SelectorItemInfo("salPointSalGradeID"));
            sic.add(new SelectorItemInfo("oldSalPointSalGradeID"));
            sic.add(new SelectorItemInfo("oldPosition.adminOrgUnit.id"));
            sic.add(new SelectorItemInfo("oldPosition.adminOrgUnit.name"));
            sic.add(new SelectorItemInfo("oldPosition.adminOrgUnit.displayName"));
            sic.add(new SelectorItemInfo("newAdminOrg.id"));
            sic.add(new SelectorItemInfo("newAdminOrg.name"));
            sic.add(new SelectorItemInfo("newAdminOrg.displayName"));
        }
        viewInfo.setSelector(sic);
        EntityViewInfo hireBillviewInfo = new EntityViewInfo();
        SelectorItemCollection hireBillSic = new SelectorItemCollection();
        hireBillSic.add(new SelectorItemInfo("id"));
        hireBillSic.add(new SelectorItemInfo("person.id"));
        hireBillSic.add(new SelectorItemInfo("eposition.id"));
        hireBillSic.add(new SelectorItemInfo("eposition.name"));
        hireBillSic.add(new SelectorItemInfo("eposition.adminOrgUnit.id"));
        hireBillSic.add(new SelectorItemInfo("eposition.adminOrgUnit.name"));
        hireBillSic.add(new SelectorItemInfo("eposition.adminOrgUnit.displayName"));
        hireBillSic.add(new SelectorItemInfo("newSalePoint.parent.name"));
        hireBillSic.add(new SelectorItemInfo("newSalePoint.parent.number"));
        hireBillSic.add(new SelectorItemInfo("newSalePoint.*"));
        hireBillSic.add(new SelectorItemInfo("jobLevel.id"));
        hireBillSic.add(new SelectorItemInfo("jobLevel.name"));
        hireBillSic.add(new SelectorItemInfo("newJobLevel.id"));
        hireBillSic.add(new SelectorItemInfo("newJobLevel.name"));
        hireBillSic.add(new SelectorItemInfo("positionType.id"));
        hireBillSic.add(new SelectorItemInfo("positionType.name"));
        hireBillSic.add(new SelectorItemInfo("salPointSalGradeID"));
        hireBillSic.add(new SelectorItemInfo("oldSalPointSalGradeID"));
        hireBillviewInfo.setSelector(hireBillSic);
        HashMap<String, Object> mapAdjData = new HashMap<String, Object>();
        HashSet<String> set = new HashSet<String>();
        CoreBaseInfo coreBaseInfo = null;
        CoreBaseCollection CoreBaseCol = null;
        for (int i = 0; i < personIDs.size(); ++i) {
            personID = personIDs.get(i).toString();
            FilterInfo filterInfo = new FilterInfo();
            if (isBillUpgrade) {
                filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)3));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("bill.bizState", (Object)3));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
            viewInfo.setFilter(filterInfo);
            CoreBaseCol = isBillUpgrade ? FluctuationBizBillEntryFactory.getLocalInstance((Context)ctx).getCollection(viewInfo) : FluctuationBillEntryFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
            if (CoreBaseCol != null && CoreBaseCol.size() > 0) {
                coreBaseInfo = CoreBaseCol.get(0);
                if (isBillUpgrade) {
                    FluctuationBizBillEntryInfo fbbeInfo = (FluctuationBizBillEntryInfo)coreBaseInfo;
                    mapAdjData.put(personID, fbbeInfo);
                    continue;
                }
                FluctuationBillEntryInfo fbeInfo = (FluctuationBillEntryInfo)coreBaseInfo;
                mapAdjData.put(personID, fbeInfo);
                continue;
            }
            CoreBaseCol = null;
            if (isBillUpgrade) {
                set.add(personID);
                continue;
            }
            hireBillviewInfo.setFilter(filterInfo);
            CoreBaseCol = HireBillEntryFactory.getLocalInstance((Context)ctx).getCollection(hireBillviewInfo);
            if (CoreBaseCol == null || CoreBaseCol.size() <= 0) continue;
            coreBaseInfo = CoreBaseCol.get(0);
            HireBillEntryInfo hbeInfo = (HireBillEntryInfo)coreBaseInfo;
            mapAdjData.put(personID, hbeInfo);
        }
        HashSet<String> setHis = new HashSet<String>();
        EmpPosOrgRelationCollection empPosOrgRelation = EmpPosOrgRelationFacadeFactory.getLocalInstance((Context)ctx).getCurrentMainlinePositonCollection(set);
        if (empPosOrgRelation != null && empPosOrgRelation.size() > 0) {
            int size = empPosOrgRelation.size();
            for (int i = 0; i < size; ++i) {
                mapAdjData.put(empPosOrgRelation.get(i).getPerson().getId().toString(), empPosOrgRelation.get(i));
                if (empPosOrgRelation.get(i).getParent() == null) continue;
                setHis.add(empPosOrgRelation.get(i).getParent().getId().toString());
            }
        }
        HashMap<String, HashMap> map = new HashMap<String, HashMap>();
        String HROrgID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select top 1 adjItem.FAdjEmpID,adjItem.FEffectDate from T_HR_ADJSCHITEM adjItem \n");
        sb.append("inner join T_HR_ADJSCHEME adjSche on adjItem.FADJSCHEMEID = adjSche.fid \n");
        sb.append("where adjSche.FHROrgUnitID = '").append(HROrgID).append("'");
        sb.append(" and adjSche.FAdjSchemeState = 30 ");
        String orderStr = " order by adjItem.FEffectDate DESC";
        IRowSet rows = null;
        HashMap<String, Date> effDateMap = new HashMap<String, Date>();
        int size = personIDs.size();
        for (int i = 0; i < size; ++i) {
            String sql = sb.toString() + " and adjItem.FAdjEmpID = '" + personIDs.get(i).toString() + "' " + orderStr;
            rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (!rows.next()) continue;
                effDateMap.put(rows.getString("FAdjEmpID"), rows.getDate("FEffectDate"));
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        HashMap personPositionMap = this.getPersonPositionMap(ctx, personIDs);
        HashMap personWorkExpCurMap = this.getPersonWorkExpCurMap(ctx, setHis);
        map.put("effDateMap", effDateMap);
        map.put("personPositionMap", mapAdjData);
        map.put("personWorkExpCurMap", personWorkExpCurMap);
        map.put("personPositionMap_Real_Affair", personPositionMap);
        return map;
    }

    private HashMap getPersonPositionMap(Context ctx, List personIDs) throws BOSException {
        HashMap<String, PersonPositionInfo> personPositionMap = new HashMap<String, PersonPositionInfo>();
        IPersonPosition iPerson = PersonPositionFactory.getLocalInstance((Context)ctx);
        PersonPositionCollection ppCollection = null;
        int size = personIDs.size();
        for (int i = 0; i < size; ++i) {
            ppCollection = iPerson.getPersonPositionCollection("select primaryPosition.adminOrgUnit.displayName,primaryPosition.adminOrgUnit.id,primaryPosition.adminOrgUnit.name,primaryPosition.PositionType.name,primaryPosition.name,person.id,jobLevel.name where person = '" + personIDs.get(i).toString() + "'");
            if (ppCollection == null || ppCollection.size() <= 0) continue;
            personPositionMap.put(personIDs.get(i).toString(), ppCollection.get(0));
        }
        return personPositionMap;
    }

    private HashMap getPersonWorkExpCurMap(Context ctx, Set setHis) throws BOSException {
        HashMap<String, EmpPosOrgRelationInfo> personWorkExpCurMap = new HashMap<String, EmpPosOrgRelationInfo>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)setHis, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(this.getSelector());
        EmpPosOrgRelationCollection empPosOrgRelation = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(viewInfo);
        if (empPosOrgRelation != null && empPosOrgRelation.size() > 0) {
            int size = empPosOrgRelation.size();
            for (int i = 0; i < size; ++i) {
                personWorkExpCurMap.put(empPosOrgRelation.get(i).getPerson().getId().toString(), empPosOrgRelation.get(i));
            }
        }
        return personWorkExpCurMap;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("adminOrg.displayName"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("position.PositionType.id"));
        sic.add(new SelectorItemInfo("position.PositionType.name"));
        sic.add(new SelectorItemInfo("position.PositionType.number"));
        sic.add(new SelectorItemInfo("relateAdmin.id"));
        sic.add(new SelectorItemInfo("relateAdmin.name"));
        sic.add(new SelectorItemInfo("relateAdmin.number"));
        sic.add(new SelectorItemInfo("affairActDef.id"));
        sic.add(new SelectorItemInfo("affairActDef.name"));
        sic.add(new SelectorItemInfo("affairActDef.number"));
        sic.add(new SelectorItemInfo("employeeType.id"));
        sic.add(new SelectorItemInfo("employeeType.name"));
        sic.add(new SelectorItemInfo("employeeType.number"));
        sic.add(new SelectorItemInfo("positionstate.id"));
        sic.add(new SelectorItemInfo("positionstate.name"));
        sic.add(new SelectorItemInfo("positionstate.number"));
        sic.add(new SelectorItemInfo("hrbizDefine.id"));
        sic.add(new SelectorItemInfo("hrbizDefine.name"));
        sic.add(new SelectorItemInfo("hrbizDefine.number"));
        sic.add(new SelectorItemInfo("mainline"));
        sic.add(new SelectorItemInfo("isPartTime"));
        sic.add(new SelectorItemInfo("effectStartDate"));
        sic.add(new SelectorItemInfo("effectEndDate"));
        sic.add(new SelectorItemInfo("flowInAffairID"));
        sic.add(new SelectorItemInfo("flowOutAffairID"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }

    @Override
    protected HashMap _getPersonLastAdjDate(Context ctx, HashSet personSet) throws BOSException, EASBizException {
        HashMap<String, Date> effDateMap = new HashMap<String, Date>();
        String HROrgID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select top 1 adjItem.FAdjEmpID,adjItem.FEffectDate from T_HR_ADJSCHITEM adjItem \n");
        sb.append("inner join T_HR_ADJSCHEME adjSche on adjItem.FADJSCHEMEID = adjSche.fid \n");
        sb.append("where adjSche.FHROrgUnitID = '").append(HROrgID).append("'");
        sb.append(" and adjSche.FAdjSchemeState = 30 ");
        String orderStr = " order by adjItem.FEffectDate DESC";
        IRowSet rows = null;
        Iterator ite = personSet.iterator();
        String personId = null;
        while (ite.hasNext()) {
            personId = ite.next().toString();
            String sql = sb.toString() + " and adjItem.FAdjEmpID = '" + personId + "' " + orderStr;
            rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (!rows.next()) continue;
                effDateMap.put(rows.getString("FAdjEmpID"), rows.getDate("FEffectDate"));
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return effDateMap;
    }

    @Override
    protected Map _getFulctuationData(Context ctx, Uuid entryId) throws BOSException {
        return null;
    }

    @Override
    protected HashMap _salInitInfo(Context ctx, EntityViewInfo empAdjustiveCauseEvi) throws BOSException, EASBizException {
        HashMap<String, Object> salInfoMap = new HashMap<String, Object>();
        CmpAdjustiveCauseCollection coll = CmpAdjustiveCauseFactory.getLocalInstance(ctx).getCmpAdjustiveCauseCollection(empAdjustiveCauseEvi);
        salInfoMap.put("cmpAdjustiveCause", (Object)coll);
        FixedCmpSchemeInfo fixedInfo = HRUtils.getFixedCmpScheme(ctx);
        if (fixedInfo == null) {
            return salInfoMap;
        }
        try {
            SalariatSchemeInfo info = fixedInfo.getSalariatScheme();
            if (info != null) {
                String salSchemeID = info.getId().toString();
                Map mapSal = this.getSalPointInfo(ctx, salSchemeID);
                Map mapPoint = HRUtils.getSalPointValueMap(ctx, salSchemeID);
                salInfoMap.put("SPSchema", new Integer(1));
                salInfoMap.put("schemeInfoIsNull", "false");
                salInfoMap.put("salSchemeID", salSchemeID);
                salInfoMap.put("mapSal", mapSal);
                salInfoMap.put("mapPoint", mapPoint);
            } else {
                salInfoMap.put("SPSchema", new Integer(0));
                salInfoMap.put("schemeInfoIsNull", "true");
            }
        }
        catch (FixedCmpSchemeException e) {
            throw new FixedCmpSchemeException(FixedCmpSchemeException.NOT_ENABLE_SALARIATSCHEME);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return salInfoMap;
    }

    @Override
    protected void _updateTuned(Context ctx, String sql) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)sql);
    }
}

