/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemException;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.compensation.ItemTypeEnum;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.app.AbstractCmpItemControllerBean;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.SalarySlipUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpItemControllerBean
extends AbstractCmpItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.CmpItemControllerBean");

    @Override
    protected boolean _deleteAble(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean isDeleteAble = false;
        if (pk == null) {
            return isDeleteAble;
        }
        CmpItemInfo infoCmpItem = this.getCmpItemInfo(ctx, pk);
        if (infoCmpItem.getSubject().getValue() == 10) {
            throw new CmpItemException(CmpItemException.CMPITEM_INIT_NOT_DELETE);
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpSchemeItemQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        String oqlCmpScheme = " select id where cmpItem.id ='" + pk.toString() + "'";
        exec.setObjectView(oqlCmpScheme);
        if (exec.hasResult()) {
            throw new CmpItemException(CmpItemException.CMPITEM_REFERENCE_BY_CMPSCHEME);
        }
        if (this._isReferencedByFormula(ctx, infoCmpItem.getNumber())) {
            throw new CmpItemException(CmpItemException.CMPITEM_REFERENCE_BY_FORMULA);
        }
        return true;
    }

    @Override
    protected boolean _isReferencedByFormula(Context ctx, String strCmpItemNum) throws BOSException, EASBizException {
        boolean isReferenced = false;
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(*) from  T_HR_Formula ");
        sql.append(" where fhrorgunitid = '" + HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString() + "' and ");
        sql.append(" (fispublic = 1 or (fispublic = 0 and FCmpShemeID in (select fid from t_hr_cmpscheme where fisdelete = 0)))");
        sql.append(" and fformula like '%" + strCmpItemNum + "%'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getInt(1) <= 0) continue;
                isReferenced = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isReferenced;
    }

    @Override
    protected boolean _canDisable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean canDisable = false;
        return canDisable;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((CmpItemInfo)model).getHrOrgUnit() == null) {
            ((CmpItemInfo)model).setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        }
        this._checkNameDup(ctx, model);
        this._checkNumberDup(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((CmpItemInfo)model).getHrOrgUnit() == null) {
            ((CmpItemInfo)model).setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        }
        this._checkNameDup(ctx, model);
        this._checkNumberDup(ctx, model);
        if (((CmpItemInfo)model).getId() != null && !((CmpItemInfo)model).isCollectFlag()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_CMPSCHEMEITEM SET FIsCollect = 0 WHERE FCMPITEMID='" + ((CmpItemInfo)model).getId() + "'"));
        }
        return super._submit(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this._deleteAble(ctx, pk)) {
            super._delete(ctx, pk);
        }
    }

    @Override
    protected void _sortOrder(Context ctx, Object obj) throws BOSException {
        if (obj == null || !(obj instanceof CmpItemCollection)) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        CmpItemCollection col = (CmpItemCollection)((Object)obj);
        if (col == null || col.size() == 0) {
            return;
        }
        String sql = "UPDATE T_HR_CMPITEM SET FDefaultOrder=? WHERE FID=?";
        CmpItemInfo info = null;
        Object objTemp = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                info = col.get(i);
                ps.setInt(1, info.getDefaultOrder());
                ps.setString(2, info.getId().toString());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected void _syncPrintData(Context ctx) throws BOSException, EASBizException {
        try {
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new CmpItemInfo().getBOSType(), null, null, (String)"cmpitem_syn");
            SalarySlipUtils.syncCmpItemData(ctx);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
            throw new CmpItemException(CmpItemException.CMPITEM_SYNCPRINTDATA_FAIL, e);
        }
    }

    protected FilterInfo getFilterForCheckNumber(IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        CmpItemInfo info = (CmpItemInfo)model;
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getHrOrgUnit().getId().toString()));
        return filter;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("hrOrgUnit.id", (Object)((CmpItemInfo)model).getHrOrgUnit().getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem2);
        filter.setMaskString("#0 and #1 ");
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1 and #2");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("hrOrgUnit.id", (Object)((CmpItemInfo)model).getHrOrgUnit().getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem2);
        filter.setMaskString("#0 and #1 ");
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1 and #2");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    @Override
    protected void _assignItem(Context ctx, String strCurrentHROrgUnitID, List lstHROrgUnit, List lstCmpItem) throws BOSException, EASBizException {
        if (lstHROrgUnit == null || lstHROrgUnit.size() < 1) {
            return;
        }
        if (lstCmpItem == null || lstCmpItem.size() < 1) {
            return;
        }
        String strNumber = null;
        String strHROrgUnitID = null;
        int size = lstHROrgUnit.size();
        for (int i = 0; i < size; ++i) {
            strHROrgUnitID = lstHROrgUnit.get(i).toString();
            int n = lstCmpItem.size();
            for (int m = 0; m < n; ++m) {
                strNumber = lstCmpItem.get(m).toString();
                IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new CmpItemInfo().getBOSType(), null, (String)strNumber, (String)"cmpitem_assign");
                this.doAssignItem(ctx, strCurrentHROrgUnitID, strHROrgUnitID, strNumber);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
    }

    private void doAssignItem(Context ctx, String strCurrentHROrgUnitID, String strHROrgUnitID, String strCmpItemNumber) throws BOSException, EASBizException {
        String sql = " select fid,fnumber,FSubject from t_hr_cmpItem where fnumber=? and fhrorgunitid=? ";
        Object[] param = new Object[]{strCmpItemNumber, strHROrgUnitID};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        CmpItemInfo info = new CmpItemInfo();
        boolean isHas = false;
        try {
            while (rs.next()) {
                isHas = true;
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setNumber(rs.getString("fnumber"));
                info.setSubject(ItemSubjectEnum.getEnum(rs.getInt("FSubject")));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (isHas) {
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                sql = KSqlUtil.getDbType((Connection)conn) == 3 ? "/*dialect*/ UPDATE A SET fisgroupcontrol = 1, fname_l1 = b.fname_l1, fname_l2 = b.fname_l2, fname_l3 = b.fname_l3 FROM t_hr_cmpitem a,t_hr_cmpitem b      WHERE ((a.fnumber = b.fnumber AND b.fnumber = 'FSAL004') AND b.fhrorgunitid = '00000000-0000-0000-0000-000000000000CCE7AED4') AND (a.fhrorgunitid = '+/AVjwETEADgAKVMwKgQDcznrtQ=' AND a.fnumber ='FSAL004')UPDATE A SET fisgroupcontrol = 1, fname_l1 = b.fname_l1, fname_l2 = b.fname_l2, fname_l3 = b.fname_l3,fenable=b.fenable FROM t_hr_cmpitem a,t_hr_cmpitem b      WHERE ((a.fnumber = b.fnumber AND b.fnumber = '" + strCmpItemNumber + "') AND b.fhrorgunitid = '" + strCurrentHROrgUnitID + "') AND (a.fhrorgunitid = '" + strHROrgUnitID + "' AND a.fnumber ='" + strCmpItemNumber + "')" : "  update t_hr_cmpitem as a  set (fisgroupcontrol,fname_l1,fname_l2,fname_l3,fenable) =   ( select 1,b.fname_l1,b.fname_l2,b.fname_l3,fenable from t_hr_cmpitem b   where a.fnumber = b.fnumber   and b.fnumber ='" + strCmpItemNumber + "'   and b.fhrorgunitid ='" + strCurrentHROrgUnitID + "'   )   where a.fhrorgunitid ='" + strHROrgUnitID + "' and a.fnumber='" + strCmpItemNumber + "'";
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            DbUtil.execute((Context)ctx, (String)sql);
        } else {
            CmpItemInfo cmpitemTem;
            info = cmpitemTem = this.getCmpItemSomeInfo(ctx, strCmpItemNumber, strCurrentHROrgUnitID);
            String idCmpItemCata = this.getCmpItemCatalogId(ctx, cmpitemTem, strHROrgUnitID);
            if (idCmpItemCata == null) {
                return;
            }
            String fid = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
            StringBuffer str = new StringBuffer(" INSERT INTO T_HR_CMPITEM(FID,FName_l1,FName_l2,FName_l3").append(",FNumber,FEnable,FLength,FDecDigital").append(",FItemValue,FDefaultOrder,FType,FDataType,FSubject,FUsed").append(",FCmpItemCatalogID,FControlUnitID,FHROrgUnitID,FISGroupControl,fCollectFlag, FEnableDate,FDisableDate,fprecisiontype) ").append(" SELECT '" + fid + "' ,FName_l1,FName_l2,FName_l3").append(" ,FNumber,FEnable,FLength,FDecDigital").append(",FItemValue,FDefaultOrder,FType,FDataType,FSubject,FUsed").append(",'" + idCmpItemCata + "','" + strHROrgUnitID + "','" + strHROrgUnitID + "',1,fCollectFlag, FEnableDate,FDisableDate,fprecisiontype FROM T_HR_CMPITEM b ").append(" WHERE b.fhrorgunitid='" + strCurrentHROrgUnitID + "' and b.fnumber='" + strCmpItemNumber + "' ");
            DbUtil.execute((Context)ctx, (String)str.toString());
        }
        if (!info.getNumber().startsWith("FPER") || 20 == info.getSubject().getValue()) {
            // empty if block
        }
    }

    private CmpItemInfo getCmpItemSomeInfo(Context ctx, String cmpItemNumber, String strCurrentHROrgUnitID) throws BOSException {
        CmpItemInfo cmpitemRet = null;
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("*"));
        ev.getSelector().add(new SelectorItemInfo("cmpItemCatalog.*"));
        ev.getSelector().add(new SelectorItemInfo("hrOrgUnit.*"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)strCurrentHROrgUnitID));
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)cmpItemNumber));
        ev.setFilter(fi);
        CmpItemCollection cmpitemColl = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(ev);
        if (cmpitemColl != null && cmpitemColl.size() > 0) {
            cmpitemRet = cmpitemColl.get(0);
        }
        return cmpitemRet;
    }

    private String getCmpItemCatalogId(Context ctx, CmpItemInfo cmpitem, String strHROrgUnitID) throws BOSException {
        if (cmpitem == null || cmpitem.getCmpItemCatalog() == null || cmpitem.getCmpItemCatalog().getNumber() == null) {
            return null;
        }
        String idCmpItemCata = null;
        String sql = " select fid from t_hr_cmpitemcat where fnumber=? and FHROrgUnitID=? ";
        Object[] param1 = new Object[]{cmpitem.getCmpItemCatalog().getNumber(), strHROrgUnitID};
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)" select fid from t_hr_cmpitemcat where fnumber=? and FHROrgUnitID=? ", (Object[])param1);
        try {
            while (rs1.next()) {
                idCmpItemCata = rs1.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return idCmpItemCata;
    }

    @Override
    protected boolean _isFinishHROrgUnit(Context ctx, String strHROrgUnitID) throws BOSException, EASBizException {
        String sql = "select * from t_hr_hrinit where fhrOrgUnitid=? AND Fkey='JX_CURRENCY'";
        Object[] param = new Object[]{strHROrgUnitID};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new SQLDataException(e);
        }
        return false;
    }

    @Override
    protected void _saveCmpItemDynquery(Context ctx, int type, String dynSolutionId, String hroId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer("SELECT 1 FROM T_HR_CmpitemDynquery WHERE ");
        sb.append("FType=");
        sb.append(type);
        sb.append(" AND FDynSolutionID='");
        sb.append(dynSolutionId);
        sb.append("' AND FHROrgUnitID='");
        sb.append(hroId);
        sb.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rows.next()) {
                return;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sb = new StringBuffer("INSERT INTO T_HR_CmpitemDynquery ");
        sb.append("(FType,FDynSolutionID,FHROrgUnitID) VALUES (");
        sb.append(type);
        sb.append(",'");
        sb.append(dynSolutionId);
        sb.append("','");
        sb.append(hroId);
        sb.append("')");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected void _disableItem(Context ctx, List ids, StateEnum state) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        HashSet set = new HashSet();
        set.addAll(ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("cmpItem.id", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("cmpScheme.isDelete", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("cmpScheme.enable", (Object)3, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("cmpItem.number"));
        selector.add(new SelectorItemInfo("cmpItem.name"));
        selector.add(new SelectorItemInfo("cmpScheme.name"));
        view.setFilter(filter);
        view.setSelector(selector);
        CmpSchemeItemCollection itemColl = CmpSchemeItemFactory.getLocalInstance(ctx).getCmpSchemeItemCollection(view);
        if (itemColl != null && itemColl.size() > 0) {
            String number = itemColl.get(0).getCmpItem().getNumber();
            String itemName = itemColl.get(0).getCmpItem().getName();
            String schemeName = itemColl.get(0).getCmpScheme().getName();
            throw new CmpItemException(CmpItemException.CMPITEM_ITEM_SCHEME, new Object[]{" " + itemName + "(" + number + ")", schemeName});
        }
        String IDs = HRSchemeUtils.getStrFromList(ids);
        String sql = "update t_hr_cmpitem set fenable = ? where  fid in " + IDs;
        Object[] param = new Object[]{state.getValue()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
    }

    @Override
    protected IObjectCollection _getForNotDataAuthority(Context ctx, Set cmpIds) throws BOSException, EASBizException {
        if (cmpIds == null || cmpIds != null && cmpIds.size() == 0) {
            return null;
        }
        EntityViewInfo entityViewInfoTmp = new EntityViewInfo();
        FilterInfo fitlerInfoTmp = new FilterInfo();
        fitlerInfoTmp.getFilterItems().add(new FilterItemInfo("id", (Object)cmpIds, CompareType.INCLUDE));
        entityViewInfoTmp.setFilter(fitlerInfoTmp);
        IQueryExecutor exec = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpItemForNotDataAuthorityQuery"));
        exec.setObjectView(entityViewInfoTmp);
        IRowSet rowSet = exec.executeQuery();
        CmpItemInfo cmpItemInfo = null;
        CmpItemCatalogInfo cmpItemCatalogInfo = null;
        CmpItemCollection cmpItemCollection = new CmpItemCollection();
        try {
            while (rowSet.next()) {
                cmpItemInfo = new CmpItemInfo();
                cmpItemInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                cmpItemInfo.setNumber(rowSet.getString("number"));
                cmpItemInfo.setName(rowSet.getString("name"));
                cmpItemInfo.setEnable(StateEnum.getEnum(rowSet.getInt("enable")));
                cmpItemInfo.setLength(rowSet.getInt("length"));
                cmpItemInfo.setDecDigital(rowSet.getInt("decDigital"));
                cmpItemInfo.setType(ItemTypeEnum.getEnum(rowSet.getInt("type")));
                cmpItemInfo.setDataType(ItemDataTypeEnum.getEnum(rowSet.getInt("dataType")));
                cmpItemInfo.setSubject(ItemSubjectEnum.getEnum(rowSet.getInt("subject")));
                cmpItemInfo.setPrecisionType(CmpItemPrecisionTypeEnum.getEnum(rowSet.getInt("precisionType")));
                cmpItemInfo.setCollectFlag(rowSet.getBoolean("collectFlag"));
                cmpItemCatalogInfo = new CmpItemCatalogInfo();
                cmpItemCatalogInfo.setId(BOSUuid.read((String)rowSet.getString("cmpItemCatalog.id")));
                cmpItemCatalogInfo.setNumber(rowSet.getString("cmpItemCatalog.number"));
                cmpItemCatalogInfo.setName(rowSet.getString("cmpItemCatalog.name"));
                cmpItemInfo.setCmpItemCatalog(cmpItemCatalogInfo);
                cmpItemCollection.add(cmpItemInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return cmpItemCollection;
    }
}

