/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.DeptCmpImportException;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeEntryCollection;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeEntryInfo;
import com.kingdee.eas.hr.compensation.IDeptInnerSchemeEntry;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;

public class DepCmpInnerAssignmentDataTransmission
extends AbstractDataTransmission {
    public static final String PERSON_NUMBER = "number";
    public static final String PERSON_NAME = "name";
    public static final String CMP_ITEM = "cmpItem";
    public static final String DEP_NEED_PAY = "depNeedPay";
    public static final String DEP_AMOUNT_ADD = "depAmountAdd";
    public static final String DEP_AMOUNT_SUB = "depAmountSub";
    private String deptInnerScheme = null;
    private Boolean isUsingStandard = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return DeptInnerSchemeEntryFactory.getLocalInstance(ctx);
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        FilterInfo filter = null;
        if (this.deptInnerScheme == null) {
            this.deptInnerScheme = (String)this.getContextParameter().get("deptInnerScheme");
        }
        if (this.isUsingStandard == null) {
            this.isUsingStandard = (Boolean)this.getContextParameter().get("isUsingStandard");
        }
        Object obj = null;
        try {
            obj = hsData.get(PERSON_NUMBER);
            String number = null;
            if (obj != null) {
                number = obj.toString().trim();
            }
            if (null == number || "".equals(number)) {
                throw new DeptCmpImportException(DeptCmpImportException.NULL_PERSON_NUMBER);
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(PERSON_NUMBER, (Object)number));
            if (!PersonFactory.getLocalInstance((Context)ctx).exists(filter)) {
                throw new DeptCmpImportException(DeptCmpImportException.ERROR_PERSON_NUMBER, new Object[]{number});
            }
            obj = hsData.get(PERSON_NAME);
            String name = null;
            if (obj != null) {
                name = obj.toString().trim();
            }
            if (null != name && !"".equals(name.trim())) {
                filter.getFilterItems().add(new FilterItemInfo(PERSON_NAME, (Object)name));
                if (!PersonFactory.getLocalInstance((Context)ctx).exists(filter)) {
                    throw new DeptCmpImportException(DeptCmpImportException.ERROR_NUMBER_NAME, new Object[]{number, name});
                }
            }
            if (!this.isHasAuth(ctx, "person.fnumber='" + number + "'")) {
                throw new DeptCmpImportException(DeptCmpImportException.ERROR_NOT_AUTH, new Object[]{number});
            }
            obj = hsData.get(CMP_ITEM);
            String cmpItem = null;
            if (obj != null) {
                cmpItem = obj.toString().trim();
            }
            if (null == cmpItem || "".equals(cmpItem)) {
                throw new DeptCmpImportException(DeptCmpImportException.NULL_CMP_ITEM);
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(PERSON_NAME, (Object)cmpItem.trim()));
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
            if (!CmpItemFactory.getLocalInstance(ctx).exists(filter)) {
                throw new DeptCmpImportException(DeptCmpImportException.ERROR_CMP_ITEM, new Object[]{cmpItem});
            }
            obj = hsData.get(DEP_NEED_PAY);
            String depNeedPay = null;
            if (obj != null) {
                depNeedPay = obj.toString().trim();
            }
            BigDecimal depNeedPayValue = null;
            if (null != depNeedPay && !"".equals(depNeedPay)) {
                try {
                    depNeedPayValue = new BigDecimal(depNeedPay);
                }
                catch (NumberFormatException ex) {
                    throw new DeptCmpImportException(DeptCmpImportException.ERROR_NEED_PAY, new Object[]{depNeedPay});
                }
            }
            obj = hsData.get(DEP_AMOUNT_ADD);
            String depAmountAdd = null;
            if (obj != null) {
                depAmountAdd = obj.toString();
            }
            BigDecimal depAmountAddValue = null;
            if (null != depAmountAdd && !"".equals(depAmountAdd.trim())) {
                try {
                    depAmountAddValue = new BigDecimal(depAmountAdd);
                }
                catch (NumberFormatException ex) {
                    throw new DeptCmpImportException(DeptCmpImportException.ERROR_ADD_PAY, new Object[]{depAmountAdd});
                }
            }
            obj = hsData.get(DEP_AMOUNT_SUB);
            String depAmountSub = null;
            if (obj != null) {
                depAmountSub = obj.toString();
            }
            BigDecimal depAmountSubValue = null;
            if (null != depAmountSub && !"".equals(depAmountSub.trim())) {
                try {
                    depAmountSubValue = new BigDecimal(depAmountSub);
                }
                catch (NumberFormatException ex) {
                    throw new DeptCmpImportException(DeptCmpImportException.ERROR_SUB_PAY, new Object[]{depAmountSub});
                }
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)number));
            filter.getFilterItems().add(new FilterItemInfo("cmpItem.name", (Object)cmpItem));
            filter.getFilterItems().add(new FilterItemInfo("deptInnerScheme.id", (Object)this.deptInnerScheme));
            filter.getFilterItems().add(new FilterItemInfo("cmpItem.hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("cmpItem.id"));
            sic.add(new SelectorItemInfo("deptInnerScheme.id"));
            DeptInnerSchemeEntryCollection coll = DeptInnerSchemeEntryFactory.getLocalInstance(ctx).getDeptInnerSchemeEntryCollection(viewInfo);
            if (coll == null || coll.size() == 0) {
                throw new DeptCmpImportException(DeptCmpImportException.ERROR_DATA, new Object[]{number, cmpItem});
            }
            DeptInnerSchemeEntryInfo info = coll.get(0);
            if (this.isSltImportUpdate()) {
                if (!this.isUsingStandard.booleanValue()) {
                    info.setDepNeedPay(depNeedPayValue);
                }
                info.setDepAmountAdd(depAmountAddValue);
                info.setDepAmountSub(depAmountSubValue);
            } else {
                if (info.getDepNeedPay() == null && !this.isUsingStandard.booleanValue()) {
                    info.setDepNeedPay(depNeedPayValue);
                }
                if (info.getDepAmountAdd() == null) {
                    info.setDepAmountAdd(depAmountAddValue);
                }
                if (info.getDepAmountSub() == null) {
                    info.setDepAmountSub(depAmountSubValue);
                }
            }
            return info;
        }
        catch (DeptCmpImportException ex) {
            throw new TaskExternalException(ex.getMessage(ctx.getLocale()), ex.getCause());
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        DeptInnerSchemeEntryInfo info = (DeptInnerSchemeEntryInfo)coreBaseInfo;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo(DEP_NEED_PAY));
        sic.add(new SelectorItemInfo(DEP_AMOUNT_ADD));
        sic.add(new SelectorItemInfo(DEP_AMOUNT_SUB));
        try {
            IDeptInnerSchemeEntry idise = DeptInnerSchemeEntryFactory.getLocalInstance(ctx);
            idise.submit(info);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private boolean isHasAuth(Context ctx, String tj) throws Exception {
        int i;
        String sql = "select count(*) from\tT_BD_Person Person  INNER JOIN T_HR_PersonPosition  PersonPosition on PersonPosition.FPersonID=Person.fid  INNER JOIN T_ORG_Admin Admin ON Admin.fid=PersonPosition.FPersonDep  INNER JOIN  T_PM_OrgRange OrgRange ON OrgRange.FOrgID=Admin.fid  INNER JOIN  T_PM_User u ON u.fid=OrgRange.FUserID  INNER JOIN T_ORG_UNITRELATION R ON r.FFromUnitID=Admin.fid where OrgRange.FType=20  and u.fid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' and  R.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000100FE9F8B5'  and  R.FToUnitID='" + ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString() + "' and " + tj;
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return irs.next() && (i = irs.getInt(1)) >= 1;
    }
}

