/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.benefit.util.HrExDbUtil;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.DepCmpStandSchemeEntryCollection;
import com.kingdee.eas.hr.compensation.DepCmpStandSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DepCmpStandSchemeEntryInfo;
import com.kingdee.eas.hr.compensation.DepCmpStandardAmountEnum;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeCmpItemCollection;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeCmpItemFactory;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeCmpItemInfo;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeCollection;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeFactory;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeInfo;
import com.kingdee.eas.hr.compensation.IDepCmpStandSchemeEntry;
import com.kingdee.eas.hr.compensation.IDepCmpStandradSchemeCmpItem;
import com.kingdee.eas.hr.compensation.app.AbstractDepCmpStandradSchemeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DepCmpStandradSchemeControllerBean
extends AbstractDepCmpStandradSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.DepCmpStandradSchemeControllerBean");

    @Override
    protected IRowSet _getPersonalItemCol(Context ctx, DepCmpStandardAmountEnum pesonalItemType, IObjectValue filterInfo) throws BOSException, EASBizException {
        String queryURLStr = null;
        IRowSet rowSetPerson = null;
        FilterInfo filterInfoTemp = new FilterInfo();
        switch (pesonalItemType.getValue()) {
            case 20: {
                queryURLStr = "com.kingdee.eas.hr.org.app.PositionHRListQuery";
                filterInfoTemp = this.getPositionFilter(ctx);
                break;
            }
            case 10: {
                queryURLStr = "com.kingdee.eas.hr.org.app.JobGradeListOfDepSchQuery";
                filterInfoTemp = null;
                break;
            }
            case 30: {
                queryURLStr = "com.kingdee.eas.basedata.hraux.app.DiplomaQuery";
                filterInfoTemp = this.getDiplomaFilter(ctx);
                break;
            }
            default: {
                queryURLStr = null;
            }
        }
        if (queryURLStr == null) {
            throw new BOSException("Error QueryInfo!");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (filterInfo != null) {
            FilterInfo filterInfoTempPara = (FilterInfo)filterInfo;
            if (filterInfoTemp != null) {
                filterInfoTemp.mergeFilter(filterInfoTempPara, "AND");
            } else {
                filterInfoTemp = filterInfoTempPara;
            }
        }
        entityViewInfo.setFilter(filterInfoTemp);
        SorterItemInfo sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sortInfo);
        MetaDataPK metadataPK = new MetaDataPK(queryURLStr);
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        queryExec.setObjectView(entityViewInfo);
        String sql = queryExec.getSQL();
        try {
            sql = KSqlUtil.optimize((String)sql);
        }
        catch (SqlTranslateException e) {
            logger.error((Object)e.getMessage());
        }
        rowSetPerson = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rowSetPerson;
    }

    private FilterInfo getJobGradeFilter(Context ctx) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("jobGradeModule.enable", (Object)"1"));
        return filter;
    }

    private FilterInfo getPositionFilter(Context ctx) {
        FilterInfo filter = new FilterInfo();
        HROrgUnitInfo hrOrgUnitInfo = HRSchemeUtils.getServerHROrgUnitInfo(ctx);
        filter.getFilterItems().add(new FilterItemInfo("ToUnit.id", (Object)hrOrgUnitInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("PMUser.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
        filter.setMaskString("#0 and #1");
        return filter;
    }

    private FilterInfo getDiplomaFilter(Context ctx) {
        FilterInfo filter = new FilterInfo();
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        return filter;
    }

    private void addNewEntry(Context ctx, HashMap addNewMap, String schemeID) throws EASBizException, BOSException {
        if (addNewMap.isEmpty()) {
            return;
        }
        IDepCmpStandSchemeEntry iDepStandSchEntry = DepCmpStandSchemeEntryFactory.getLocalInstance(ctx);
        Set keySet = null;
        String keyString = "";
        keySet = addNewMap.keySet();
        Iterator iter = keySet.iterator();
        String[] stringArray = null;
        CoreBaseCollection colls = new CoreBaseCollection();
        while (iter.hasNext()) {
            keyString = iter.next().toString();
            stringArray = keyString.split("#");
            DepCmpStandSchemeEntryInfo depCmpStandSchemeEntryInfo = new DepCmpStandSchemeEntryInfo();
            DepCmpStandradSchemeInfo depCmpStandSchInfoTmp = new DepCmpStandradSchemeInfo();
            depCmpStandSchInfoTmp.setId(BOSUuid.read((String)schemeID));
            depCmpStandSchemeEntryInfo.setDepCmpStardScheme(depCmpStandSchInfoTmp);
            depCmpStandSchemeEntryInfo.setPersonalItemType(stringArray[0]);
            CmpItemInfo cmpItemInfoTmp = new CmpItemInfo();
            cmpItemInfoTmp.setId(BOSUuid.read((String)stringArray[1]));
            depCmpStandSchemeEntryInfo.setCmpItem(cmpItemInfoTmp);
            depCmpStandSchemeEntryInfo.setMoney(new BigDecimal(addNewMap.get(keyString).toString()));
            colls.add((CoreBaseInfo)depCmpStandSchemeEntryInfo);
        }
        if (colls.size() > 0) {
            iDepStandSchEntry.addnewBatchData(colls);
        }
    }

    private void modifyData(Context ctx, HashMap modifyMap, String schemeID, HashMap hashCmpItemTemp) throws BOSException, EASBizException {
        if (modifyMap.isEmpty()) {
            return;
        }
        Set keySet = modifyMap.keySet();
        String keyString = "";
        Iterator iter = keySet.iterator();
        Object sqlStringBuffer = null;
        String[] stringArray = null;
        CmpItemInfo itemInfo = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" UPDATE T_HR_DepCmpStandSchemeEntry SET Fmoney=? WHERE FDepCmpStardScheme=? and FPersonalItemType=? and FCmpItemID=?");
        while (iter.hasNext()) {
            keyString = iter.next().toString();
            stringArray = keyString.split("#");
            int scale = 2;
            itemInfo = (CmpItemInfo)hashCmpItemTemp.get(stringArray[1]);
            if (itemInfo != null && itemInfo.getDecDigital() != 0) {
                scale = itemInfo.getDecDigital();
            }
            params = new Object[]{new BigDecimal(modifyMap.get(keyString).toString()).setScale(scale, 4), schemeID, stringArray[0], stringArray[1]};
            paramList.add(params);
        }
        HrExDbUtil.executeBatch((Context)ctx, (String)sbSql.toString(), paramList);
    }

    private void updateCmpItems(Context ctx, HashMap hashCmpItem, String schemeID) throws BOSException, EASBizException {
        if (hashCmpItem.isEmpty()) {
            return;
        }
        String sqlDel = "DELETE FROM  T_HR_DepCmpStandSchCmpItem WHERE FDepCmpStandSchemeID='" + schemeID + "' ";
        DbUtil.execute((Context)ctx, (String)sqlDel);
        StringBuffer deleteDepInnSchEnt = new StringBuffer();
        deleteDepInnSchEnt.append("DELETE FROM T_HR_DepCmpStandSchemeEntry WHERE FDepCmpStardScheme='");
        deleteDepInnSchEnt.append(schemeID + "' AND ");
        Set keySet = hashCmpItem.keySet();
        Iterator iter = keySet.iterator();
        String keyString = "";
        CmpItemInfo cmpItemInfo = null;
        IDepCmpStandradSchemeCmpItem iDepCmpStandSchemeCmpItem = DepCmpStandradSchemeCmpItemFactory.getLocalInstance(ctx);
        DepCmpStandradSchemeInfo depCmpStandradSchemeInfo = new DepCmpStandradSchemeInfo();
        depCmpStandradSchemeInfo.setId(BOSUuid.read((String)schemeID));
        CoreBaseCollection colls = new CoreBaseCollection();
        while (iter.hasNext()) {
            DepCmpStandradSchemeCmpItemInfo depCmpStandSchCmpItemInfo = new DepCmpStandradSchemeCmpItemInfo();
            keyString = iter.next().toString();
            cmpItemInfo = (CmpItemInfo)hashCmpItem.get(keyString);
            depCmpStandSchCmpItemInfo.setCmpItem(cmpItemInfo);
            depCmpStandSchCmpItemInfo.setDepCmpStandScheme(depCmpStandradSchemeInfo);
            colls.add((CoreBaseInfo)depCmpStandSchCmpItemInfo);
            if (iter.hasNext()) {
                deleteDepInnSchEnt.append("FCmpItemID <> '" + cmpItemInfo.getId().toString() + "'  AND ");
                continue;
            }
            deleteDepInnSchEnt.append("FCmpItemID <> '" + cmpItemInfo.getId().toString() + "'");
        }
        if (colls.size() > 0) {
            iDepCmpStandSchemeCmpItem.addnewBatchData(colls);
        }
        DbUtil.execute((Context)ctx, (String)deleteDepInnSchEnt.toString());
    }

    private void deletePersonalItemDate(Context ctx, HashSet hashDelSet, String schemeID) throws BOSException {
        if (hashDelSet.isEmpty()) {
            return;
        }
        Iterator iter = hashDelSet.iterator();
        StringBuffer deleteDepInnSchEnt = new StringBuffer();
        deleteDepInnSchEnt.append("DELETE FROM T_HR_DepCmpStandSchemeEntry WHERE FDepCmpStardScheme='");
        deleteDepInnSchEnt.append(schemeID + "' AND (");
        String personalItemTypeStr = "";
        while (iter.hasNext()) {
            personalItemTypeStr = iter.next().toString();
            if (iter.hasNext()) {
                deleteDepInnSchEnt.append("FPersonalItemType ='" + personalItemTypeStr + "'  OR ");
                continue;
            }
            deleteDepInnSchEnt.append("FPersonalItemType ='" + personalItemTypeStr + "'");
        }
        deleteDepInnSchEnt.append(")");
        DbUtil.execute((Context)ctx, (String)deleteDepInnSchEnt.toString());
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sqlString = "DELETE FROM T_HR_DepCmpStandSchCmpItem WHERE fDepcmpstandSchemeid='" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)sqlString);
        super.delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        DepCmpStandradSchemeInfo depCmpStandSchInfoGol = (DepCmpStandradSchemeInfo)model;
        HashMap hashAddDataMapTemp = (HashMap)depCmpStandSchInfoGol.get("hashAddDataMap");
        HashMap hashUpdateDataMapTemp = (HashMap)depCmpStandSchInfoGol.get("hashUpdateDataMap");
        HashMap hashCmpItemTemp = (HashMap)depCmpStandSchInfoGol.get("hashCmpItem");
        HashSet hashDelSet = (HashSet)depCmpStandSchInfoGol.get("hashDelSet");
        depCmpStandSchInfoGol.remove("hashAddDataMap");
        depCmpStandSchInfoGol.remove("hashUpdateDataMap");
        depCmpStandSchInfoGol.remove("hashCmpItem");
        depCmpStandSchInfoGol.remove("hashDelSet");
        pk = super._submit(ctx, model);
        this.deletePersonalItemDate(ctx, hashDelSet, pk.toString());
        this.addNewEntry(ctx, hashAddDataMapTemp, pk.toString());
        this.modifyData(ctx, hashUpdateDataMapTemp, pk.toString(), hashCmpItemTemp);
        this.updateCmpItems(ctx, hashCmpItemTemp, pk.toString());
        return pk;
    }

    private HashMap getCmpItemMap(Context ctx, DepCmpStandradSchemeInfo info) throws BOSException {
        HashMap<String, CmpItemInfo> cmpItemMap = new HashMap<String, CmpItemInfo>();
        IDepCmpStandradSchemeCmpItem iDepCmpStandCmpItem = DepCmpStandradSchemeCmpItemFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("cmpItem.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("depCmpStandScheme.id", (Object)info.getId().toString()));
        viewInfo.setFilter(filter);
        DepCmpStandradSchemeCmpItemCollection depCmpStandCmpItemCol = iDepCmpStandCmpItem.getDepCmpStandradSchemeCmpItemCollection(viewInfo);
        DepCmpStandradSchemeCmpItemInfo depCmpStandSchCmpItemInfo = null;
        CmpItemInfo cmpItemInfo = null;
        int size = depCmpStandCmpItemCol.size();
        for (int i = 0; i < size; ++i) {
            depCmpStandSchCmpItemInfo = depCmpStandCmpItemCol.get(i);
            cmpItemInfo = depCmpStandSchCmpItemInfo.getCmpItem();
            cmpItemMap.put(cmpItemInfo.getId().toString(), cmpItemInfo);
        }
        return cmpItemMap;
    }

    private HashMap getPersonalItemAndValue(Context ctx, DepCmpStandradSchemeInfo info) throws BOSException {
        HashMap<String, HashMap> personalItemValueMap = new HashMap<String, HashMap>();
        IDepCmpStandSchemeEntry iDepStandEntry = DepCmpStandSchemeEntryFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("depCmpStardScheme.id", (Object)info.getId().toString()));
        viewInfo.setFilter(filter);
        DepCmpStandSchemeEntryCollection depStandEntryCol = iDepStandEntry.getDepCmpStandSchemeEntryCollection(viewInfo);
        DepCmpStandSchemeEntryInfo depCmpStandEntryInfo = null;
        CmpItemInfo cmpItemInfo = null;
        String keyString = null;
        BigDecimal amountValue = HRSchemeUtils.BD_ZERO;
        int size = depStandEntryCol.size();
        for (int i = 0; i < size; ++i) {
            HashMap cmpItemValueMap;
            depCmpStandEntryInfo = depStandEntryCol.get(i);
            cmpItemInfo = depCmpStandEntryInfo.getCmpItem();
            amountValue = depCmpStandEntryInfo.getMoney();
            keyString = depCmpStandEntryInfo.getPersonalItemType().toString();
            if (!personalItemValueMap.containsKey(keyString)) {
                cmpItemValueMap = new HashMap();
                cmpItemValueMap.put(cmpItemInfo.getId().toString(), amountValue);
                personalItemValueMap.put(keyString, cmpItemValueMap);
                continue;
            }
            cmpItemValueMap = (HashMap)personalItemValueMap.get(keyString);
            cmpItemValueMap.put(cmpItemInfo.getId().toString(), amountValue);
        }
        return personalItemValueMap;
    }

    @Override
    protected HashMap _getCmpItemMapIF(Context ctx, IObjectValue depStandradScheme) throws BOSException, EASBizException {
        return this.getCmpItemMap(ctx, (DepCmpStandradSchemeInfo)depStandradScheme);
    }

    @Override
    protected HashMap _getPersonalItemAndValue(Context ctx, IObjectValue depStandradScheme) throws BOSException, EASBizException {
        return this.getPersonalItemAndValue(ctx, (DepCmpStandradSchemeInfo)depStandradScheme);
    }

    @Override
    protected Map _getGroupEmployMoney(Context ctx, String depCmpStandardScheme) throws BOSException {
        StringBuffer stbsql;
        HashMap<String, BigDecimal> groupEM = new HashMap<String, BigDecimal>();
        HROrgUnitInfo currHR = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (currHR == null) {
            return groupEM;
        }
        DepCmpStandradSchemeInfo depCmpStandradSchemeInfo = this.getInfoById(ctx, depCmpStandardScheme);
        if (depCmpStandradSchemeInfo == null) {
            return groupEM;
        }
        StringBuffer sql = new StringBuffer();
        if (depCmpStandradSchemeInfo.getPersonalItemType().equals((Object)DepCmpStandardAmountEnum.POSITION)) {
            stbsql = new StringBuffer();
            stbsql.append(" select person.fnumber AS empNumber,entry.fmoney as Money ");
            stbsql.append(" from T_BD_Person as person ");
            stbsql.append(" left join T_ORG_PositionMember pm on pm.FPersonID = person.fid ");
            stbsql.append(" left join T_ORG_Position pt on pm.fpositionid = pt.fid ");
            stbsql.append(" left join T_ORG_Admin orgAdmin on pt.FAdminOrgUnitID = orgAdmin.fid ");
            stbsql.append(" left join T_HR_DepCmpStandSchemeEntry entry on entry.FPersonalItemType = pt.fid ");
            stbsql.append(" left join T_HR_DepCmpStandradScheme scheme on entry.FDepCmpStardScheme = scheme.fid ");
            stbsql.append(" left join T_HR_CMPITEM cmp on entry.FCmpItemID = cmp.fid ");
            stbsql.append(" where scheme.fid = '" + depCmpStandardScheme + "' and cmp.fnumber = 'FOTH2166' ");
            stbsql.append(" and cmp.FHROrgUnitID = '" + currHR.getId().toString() + "' ");
            stbsql.append(" and pm.FIsPrimary = 1");
            sql = stbsql;
        } else if (depCmpStandradSchemeInfo.getPersonalItemType().equals((Object)DepCmpStandardAmountEnum.JOBGRADE)) {
            stbsql = new StringBuffer();
            stbsql.append(" select person.fnumber as empNumber,entry.fmoney as money from t_bd_person as person  ");
            stbsql.append(" left join T_HR_PersonPosition as personPosition on personPosition.fpersonId = person.fid ");
            stbsql.append(" left join T_HR_JobGrade as jobGrade on personPosition.FJobGrade = jobGrade.fid ");
            stbsql.append(" left join T_HR_DepCmpStandSchemeEntry as entry on entry.FPersonalItemType = jobGrade.fid ");
            stbsql.append(" left join T_HR_DepCmpStandradScheme as scheme on entry.FDepCmpStardScheme = scheme.fid ");
            stbsql.append(" left join T_HR_CMPITEM as cmp on entry.FCmpItemID = cmp.fid  ");
            stbsql.append(" where scheme.fid = '" + depCmpStandardScheme + "' and cmp.fnumber = 'FOTH2166' ");
            stbsql.append(" and cmp.FHROrgUnitID = '" + currHR.getId().toString() + "' ");
            sql = stbsql;
        } else if (depCmpStandradSchemeInfo.getPersonalItemType().equals((Object)DepCmpStandardAmountEnum.DIPLOMA)) {
            stbsql = new StringBuffer();
            stbsql.append(" select person.fnumber as empNumber,entry.fmoney as money from t_bd_person as person ");
            stbsql.append(" left join T_HR_PersonDegree as personDegree on personDegree.FPersonId = person.fid ");
            stbsql.append(" left join T_BD_HRDiploma as diploma on personDegree.FDiploma = diploma.fid ");
            stbsql.append(" left join T_HR_DepCmpStandSchemeEntry as entry on entry.FPersonalItemType = diploma.fid ");
            stbsql.append(" left join T_HR_DepCmpStandradScheme as scheme on entry.FDepCmpStardScheme = scheme.fid ");
            stbsql.append(" left join T_HR_CMPITEM as cmp on entry.FCmpItemID = cmp.fid  ");
            stbsql.append(" where scheme.fid = '" + depCmpStandardScheme + "' and cmp.fnumber = 'FOTH2166' ");
            stbsql.append(" and cmp.FHROrgUnitID = '" + currHR.getId().toString() + "' ");
            sql = stbsql;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                groupEM.put(rs.getString("empNumber"), rs.getBigDecimal("Money"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return groupEM;
    }

    private DepCmpStandradSchemeInfo getInfoById(Context ctx, String id) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        evi.setFilter(filter);
        DepCmpStandradSchemeCollection coll = DepCmpStandradSchemeFactory.getLocalInstance(ctx).getDepCmpStandradSchemeCollection(evi);
        DepCmpStandradSchemeInfo info = null;
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }
}

