/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeFactory;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryCollection;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeException;
import com.kingdee.eas.hr.compensation.DeptSchemeFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.IDeptScheme;
import com.kingdee.eas.hr.compensation.IDeptSchemeEntry;
import com.kingdee.eas.hr.compensation.TeamGroupCollection;
import com.kingdee.eas.hr.compensation.TeamGroupFactory;
import com.kingdee.eas.hr.compensation.TeamGroupInfo;
import com.kingdee.eas.hr.compensation.app.AbstractDeptSchemeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DeptSchemeControllerBean
extends AbstractDeptSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.DeptSchemeControllerBean");

    @Override
    protected boolean _canDisable(Context ctx, IObjectPK pk) throws BOSException, DeptSchemeException, EASBizException {
        String strSql = " SELECT COUNT(*) AS EXPR1 FROM T_HR_DeptSchemeEntry WHERE FDeptInnerSchemeID IS NOT NULL AND FDeptSchemeID=?  ";
        Connection conn = null;
        PreparedStatement ps1 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps1 = conn.prepareStatement(strSql);
            ps1.setString(1, pk.toString());
            ResultSet rs = ps1.executeQuery();
            if (rs.next() && rs.getInt("EXPR1") > 0) {
                throw new DeptSchemeException(DeptSchemeException.DISSCHEME_NOT);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps1, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps1, (Connection)conn);
        return true;
    }

    @Override
    protected void _disableDeptScheme(Context ctx, IObjectPK pk) throws BOSException, DeptSchemeException, EASBizException {
        String sql = " SELECT * FROM T_HR_DEPTSCHEMEENTRY WHERE  FDeptSchemeID = '" + pk.toString() + "' AND FDeptInnerSchemeID IS NOT NULL ";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (iRowSet == null || iRowSet.size() > 0) {
            throw new DeptSchemeException(DeptSchemeException.DISSCHEME_NOT);
        }
        String sqlEnable = " UPDATE T_HR_DEPTSCHEME SET FENABLE=0 WHERE FID=?";
        Connection conn = null;
        PreparedStatement ps1 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps1 = conn.prepareStatement(sqlEnable);
            ps1.setString(1, pk.toString());
            ps1.execute();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps1, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps1, (Connection)conn);
    }

    @Override
    protected void _enableDeptScheme(Context ctx, IObjectPK pk) throws BOSException, DeptSchemeException, EASBizException {
        String sqlEnable = " UPDATE T_HR_DEPTSCHEME SET FENABLE=1 WHERE FID=?";
        Connection conn = null;
        PreparedStatement ps1 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps1 = conn.prepareStatement(sqlEnable);
            ps1.setString(1, pk.toString());
            ps1.execute();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps1, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps1, (Connection)conn);
    }

    @Override
    protected IObjectValue _getDeptSchemeInfo(Context ctx, boolean isAllData, IObjectPK pk) throws BOSException, DeptSchemeException, EASBizException {
        DeptSchemeInfo infoDeptScheme = null;
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        EntityViewInfo infoEntityView1 = new EntityViewInfo();
        FilterInfo infoFilter1 = new FilterInfo();
        infoFilter1.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()));
        infoEntityView1.setFilter(infoFilter1);
        SorterItemInfo sorterOrderItem1 = new SorterItemInfo("beginDate");
        sorterOrderItem1.setSortType(SortType.ASCEND);
        infoEntityView1.getSorter().add(sorterOrderItem1);
        CmpPeriodCollection colAllCmpPeriod = iCmpPeriod.getCmpPeriodCollection(infoEntityView1);
        String ksqlString = "SELECT *,cmpScheme.* WHERE id='" + pk.toString() + "'";
        IDeptScheme iDeptScheme = DeptSchemeFactory.getLocalInstance(ctx);
        infoDeptScheme = (DeptSchemeInfo)iDeptScheme.getValue(ksqlString);
        IDeptSchemeEntry iDeptSchemeEntry = DeptSchemeEntryFactory.getLocalInstance(ctx);
        EntityViewInfo infoEntityView = new EntityViewInfo();
        FilterInfo infoFilter = this.getFilterInfoForInfo(isAllData, pk.toString());
        infoEntityView.setFilter(infoFilter);
        infoEntityView.getSelector().add(new SelectorItemInfo("*"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpPeriod.*"));
        infoEntityView.getSelector().add(new SelectorItemInfo("deptInnerScheme.*"));
        infoEntityView.getSelector().add(new SelectorItemInfo("adminOrgUnit.*"));
        infoEntityView.getSelector().add(new SelectorItemInfo("teamGroup.*"));
        infoEntityView.getSelector().add(new SelectorItemInfo("depCmpStandrad.*"));
        SorterItemInfo sorterOrderItem = new SorterItemInfo("cmpPeriod.beginDate");
        sorterOrderItem.setSortType(SortType.ASCEND);
        infoEntityView.getSorter().add(sorterOrderItem);
        DeptSchemeEntryCollection colEntry = iDeptSchemeEntry.getDeptSchemeEntryCollection(infoEntityView);
        if (colEntry == null || colEntry.size() <= 0) {
            return infoDeptScheme;
        }
        HashMap<String, AdminOrgUnitInfo> hspDept = new HashMap<String, AdminOrgUnitInfo>();
        HashMap<String, CmpPeriodInfo> hspCmpPeriod = new HashMap<String, CmpPeriodInfo>();
        CmpPeriodCollection colCmpPeriod = new CmpPeriodCollection();
        HashSet<String> teamGroupSet = new HashSet<String>();
        BigDecimal bdPlan = null;
        BigDecimal bdFact = null;
        BigDecimal bdBalance = null;
        BigDecimal bdDepPay = null;
        DeptSchemeEntryInfo infoEntry = null;
        AdminOrgUnitCollection colDept = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminOrgInfoTemp = null;
        int size = colEntry.size();
        for (int i = 0; i < size; ++i) {
            infoEntry = colEntry.get(i);
            if (infoDeptScheme.getAssignType() != null && 2 == infoDeptScheme.getAssignType().getValue()) {
                if (infoEntry.getTeamGroup() != null && !teamGroupSet.contains(infoEntry.getTeamGroup().getId().toString())) {
                    teamGroupSet.add(infoEntry.getTeamGroup().getId().toString());
                }
            } else if (hspDept.get(infoEntry.getAdminOrgUnit().getId().toString()) == null) {
                adminOrgInfoTemp = infoEntry.getAdminOrgUnit();
                adminOrgInfoTemp.put("hasSubDepkey", (Object)infoEntry.isHasSubDept());
                hspDept.put(adminOrgInfoTemp.getId().toString(), adminOrgInfoTemp);
                colDept.add(adminOrgInfoTemp);
            }
            if (hspCmpPeriod.get(infoEntry.getCmpPeriod().getId().toString()) == null) {
                hspCmpPeriod.put(infoEntry.getCmpPeriod().getId().toString(), infoEntry.getCmpPeriod());
            }
            bdPlan = HRSchemeUtils.addData(bdPlan, infoEntry.getAmountPlan());
            bdFact = HRSchemeUtils.addData(bdFact, infoEntry.getAmountFact());
            bdBalance = HRSchemeUtils.addData(bdBalance, infoEntry.getAmountBalance());
            bdDepPay = HRSchemeUtils.addData(bdDepPay, infoEntry.getAmountDeptPay());
        }
        String id = null;
        int size2 = colAllCmpPeriod.size();
        for (int i = 0; i < size2; ++i) {
            id = colAllCmpPeriod.get(i).getId().toString();
            if (hspCmpPeriod.get(id) == null) continue;
            colCmpPeriod.add(colAllCmpPeriod.get(i));
        }
        infoDeptScheme.setTeamGroupCollection(this.getTeamGroupCollByIDSet(ctx, teamGroupSet));
        infoDeptScheme.setDeptCollection(colDept);
        infoDeptScheme.setCmpPeriodCollection(colCmpPeriod);
        int decDigital = infoDeptScheme.getDecDigital();
        if (bdPlan != null) {
            infoDeptScheme.setAmountPlan(bdPlan.setScale(decDigital, 4));
        }
        if (bdFact != null) {
            infoDeptScheme.setAmountFact(bdFact.setScale(decDigital, 4));
        }
        if (bdBalance != null) {
            infoDeptScheme.setAmountBalance(bdBalance.setScale(decDigital, 4));
        }
        if (bdDepPay != null) {
            infoDeptScheme.setAmountDeptPay(bdDepPay.setScale(decDigital, 4));
        }
        if (infoDeptScheme.isUseDepCmpStandrad()) {
            ObjectUuidPK pkDepStandScheme = new ObjectUuidPK(infoDeptScheme.getDepCmpStandrad().getId().toString());
            DepCmpStandradSchemeInfo depCmpS = DepCmpStandradSchemeFactory.getLocalInstance(ctx).getDepCmpStandradSchemeInfo((IObjectPK)pkDepStandScheme);
            infoDeptScheme.setDepCmpStandrad(depCmpS);
            Integer maxPrec = HRCmpItemUtils.getcmpItemPrecisionByDepCmpStand(ctx, depCmpS);
            infoDeptScheme.setMaxPrecision(maxPrec);
        }
        return infoDeptScheme;
    }

    private TeamGroupCollection getTeamGroupCollByIDSet(Context ctx, Set set) throws BOSException {
        if (set == null || set.size() < 1) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("state"));
        evi.getSelector().add(new SelectorItemInfo("auditPerson.person.id"));
        evi.getSelector().add(new SelectorItemInfo("description"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        SorterItemInfo sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.ASCEND);
        evi.setFilter(fi);
        evi.getSorter().add(sortInfo);
        TeamGroupCollection tgcoll = TeamGroupFactory.getLocalInstance(ctx).getTeamGroupCollection(evi);
        Iterator iter = set.iterator();
        StringBuffer deleteSql = new StringBuffer("delete from t_hr_deptschemeentry where fteamgroupid in(");
        StringBuffer deleteIDs = new StringBuffer();
        int flag = 0;
        while (iter.hasNext()) {
            String bTeamGroupID = iter.next().toString();
            String aTeamGroupID = null;
            boolean hasDelete = true;
            if (tgcoll != null) {
                for (int i = 0; i < tgcoll.size(); ++i) {
                    aTeamGroupID = tgcoll.get(i).getId().toString();
                    if (bTeamGroupID.equals(aTeamGroupID)) {
                        hasDelete = false;
                        break;
                    }
                    hasDelete = true;
                }
            }
            if (!hasDelete) continue;
            if (flag != 0) {
                deleteIDs.append(",");
            }
            deleteIDs.append("'").append(bTeamGroupID).append("'");
            ++flag;
        }
        deleteSql.append(deleteIDs).append(")");
        if (deleteIDs.length() > 0) {
            DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        }
        return tgcoll;
    }

    private FilterInfo getFilterInfoForInfo(boolean isAllDataFlag, String pk) {
        FilterInfo infoFilter = new FilterInfo();
        if (isAllDataFlag) {
            infoFilter.getFilterItems().add(new FilterItemInfo("deptScheme.id", (Object)pk));
        } else {
            infoFilter.getFilterItems().add(new FilterItemInfo("deptScheme.id", (Object)pk));
            infoFilter.getFilterItems().add(new FilterItemInfo("isMulSentFlag", (Object)false));
            infoFilter.getFilterItems().add(new FilterItemInfo("isMulSentFlag", (Object)true));
            infoFilter.getFilterItems().add(new FilterItemInfo("isParentNode", (Object)true));
            infoFilter.setMaskString("#0 AND (#1 OR (#2 AND #3))");
        }
        return infoFilter;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((DeptSchemeInfo)model).setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        IObjectPK pk = null;
        DeptSchemeInfo infoDeptScheme = (DeptSchemeInfo)model;
        infoDeptScheme.setCU(HRSchemeUtils.getServerCUInfo(ctx));
        infoDeptScheme.setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        infoDeptScheme.setEntries(null);
        pk = super._addnew(ctx, (IObjectValue)infoDeptScheme);
        return pk;
    }

    private void getTeamGroupAllTypeData(TeamGroupCollection teamGroupColl, List teamGroupAdd, List teamGroupDel, List teamGroupLeave) {
        if (teamGroupColl == null) {
            return;
        }
        Integer state = null;
        TeamGroupInfo tgi = null;
        int size = teamGroupColl.size();
        for (int i = 0; i < size; ++i) {
            tgi = teamGroupColl.get(i);
            state = (Integer)tgi.get("state");
            if (state == 10) {
                teamGroupAdd.add(tgi);
                teamGroupLeave.add(tgi);
                continue;
            }
            if (state == 20) {
                teamGroupDel.add(tgi);
                continue;
            }
            teamGroupLeave.add(tgi);
        }
    }

    private void doDeptScheme(Context ctx, DeptSchemeInfo infoDeptScheme) throws BOSException, EASBizException {
        int i;
        CmpPeriodCollection colCmpPeriod = infoDeptScheme.getCmpPeriodCollection();
        AdminOrgUnitCollection colDept = infoDeptScheme.getDeptCollection();
        TeamGroupCollection teamGroupColl = infoDeptScheme.getTeamGroupCollection();
        if (2 == infoDeptScheme.getAssignType().getValue() && (colCmpPeriod == null || colCmpPeriod.size() <= 0 || teamGroupColl == null || teamGroupColl.size() <= 0)) {
            return;
        }
        if (1 == infoDeptScheme.getAssignType().getValue() && (colCmpPeriod == null || colCmpPeriod.size() <= 0 || colDept == null || colDept.size() <= 0)) {
            return;
        }
        CmpPeriodInfo infoCmpPeriod = null;
        AdminOrgUnitInfo infoDept = null;
        Integer state = null;
        ArrayList<CmpPeriodInfo> lstAddCmpPeriod = new ArrayList<CmpPeriodInfo>();
        ArrayList<AdminOrgUnitInfo> lstAddDept = new ArrayList<AdminOrgUnitInfo>();
        ArrayList<CmpPeriodInfo> lstDelCmpPeriod = new ArrayList<CmpPeriodInfo>();
        ArrayList<AdminOrgUnitInfo> lstDelDept = new ArrayList<AdminOrgUnitInfo>();
        ArrayList<CmpPeriodInfo> lstNOchangeCmpPeriod = new ArrayList<CmpPeriodInfo>();
        ArrayList<AdminOrgUnitInfo> lstLeaveDept = new ArrayList<AdminOrgUnitInfo>();
        int size = colCmpPeriod.size();
        for (i = 0; i < size; ++i) {
            infoCmpPeriod = colCmpPeriod.get(i);
            state = (Integer)infoCmpPeriod.get("state");
            if (state == 10) {
                lstAddCmpPeriod.add(infoCmpPeriod);
                continue;
            }
            if (state == 20) {
                lstDelCmpPeriod.add(infoCmpPeriod);
                continue;
            }
            lstNOchangeCmpPeriod.add(infoCmpPeriod);
        }
        size = colDept.size();
        for (i = 0; i < size; ++i) {
            infoDept = colDept.get(i);
            state = (Integer)infoDept.get("state");
            if (state == 10) {
                lstAddDept.add(infoDept);
                lstLeaveDept.add(infoDept);
                continue;
            }
            if (state == 20) {
                lstDelDept.add(infoDept);
                continue;
            }
            lstLeaveDept.add(infoDept);
        }
        ArrayList teamGroupAdd = new ArrayList();
        ArrayList teamGroupDel = new ArrayList();
        ArrayList teamGroupLeave = new ArrayList();
        this.getTeamGroupAllTypeData(teamGroupColl, teamGroupAdd, teamGroupDel, teamGroupLeave);
        if (lstDelCmpPeriod.size() > 0 || lstDelDept.size() > 0 || teamGroupDel.size() > 0) {
            int i2;
            int size2;
            StringBuffer sbSql = new StringBuffer(" DELETE FROM T_HR_DeptSchemeEntry WHERE ");
            if (lstDelCmpPeriod.size() > 0) {
                sbSql.append(" FCmpPeriodID IN(");
                size2 = lstDelCmpPeriod.size();
                for (i2 = 0; i2 < size2; ++i2) {
                    if (i2 != 0) {
                        sbSql.append(",");
                    }
                    infoCmpPeriod = (CmpPeriodInfo)lstDelCmpPeriod.get(i2);
                    sbSql.append("'");
                    sbSql.append(infoCmpPeriod.getId().toString());
                    sbSql.append("'");
                }
                sbSql.append(") ");
                if (lstDelDept.size() > 0) {
                    sbSql.append(" OR ");
                }
            }
            if (lstDelDept.size() > 0) {
                sbSql.append(" FAdminOrgUnitID IN(");
                size2 = lstDelDept.size();
                for (i2 = 0; i2 < size2; ++i2) {
                    if (i2 != 0) {
                        sbSql.append(",");
                    }
                    infoDept = (AdminOrgUnitInfo)lstDelDept.get(i2);
                    sbSql.append("'");
                    sbSql.append(infoDept.getId().toString());
                    sbSql.append("'");
                }
                sbSql.append(") ");
            }
            TeamGroupInfo tgi = null;
            if (teamGroupDel.size() > 0) {
                if (sbSql.lastIndexOf("FCmpPeriodID") > 0 || sbSql.lastIndexOf("FAdminOrgUnitID") > 0) {
                    sbSql.append(" OR ");
                }
                sbSql.append("  FTeamGroupID IN(");
                int size3 = teamGroupDel.size();
                for (int i3 = 0; i3 < size3; ++i3) {
                    if (i3 != 0) {
                        sbSql.append(",");
                    }
                    tgi = (TeamGroupInfo)teamGroupDel.get(i3);
                    sbSql.append("'");
                    sbSql.append(tgi.getId().toString());
                    sbSql.append("'");
                }
                sbSql.append(") ");
            }
            sbSql.append(" AND FDeptSchemeID='" + infoDeptScheme.getId().toString() + "' ");
            DbUtil.execute((Context)ctx, (String)sbSql.toString());
        }
        if (2 == infoDeptScheme.getAssignType().getValue()) {
            this.procAddNewOfByTeamG(ctx, infoDeptScheme, lstAddCmpPeriod, teamGroupLeave, teamGroupAdd, lstNOchangeCmpPeriod);
        } else {
            this.procAddNewOfByAdmin(ctx, infoDeptScheme, colCmpPeriod, lstAddCmpPeriod, lstAddDept, lstLeaveDept, lstNOchangeCmpPeriod);
        }
    }

    private void procAddNewOfByTeamG(Context ctx, DeptSchemeInfo infoDeptScheme, List lstAddCmpPeriod, List teamGroupLeave, List teamGroupAdd, List lstNOchangeCmpPeriod) throws SQLDataException {
        CmpPeriodInfo infoCmpPeriod = null;
        String fCmpPeriodID = null;
        String fTeamGroupID = null;
        String fid = null;
        String fDeptSchemeID = infoDeptScheme.getId().toString();
        TeamGroupInfo tgi = null;
        if (lstAddCmpPeriod.size() > 0 || teamGroupAdd.size() > 0) {
            Connection conn = null;
            PreparedStatement ps1 = null;
            DeptSchemeEntryInfo infoEntry = new DeptSchemeEntryInfo();
            String sqlInsert = " INSERT INTO T_HR_DeptSchemeEntry(FID,FCmpPeriodID,FTeamGroupID,FDeptSchemeID,FhasSubDept,FISMULSENTFLAG,FISPARENTNODE,FISMULRELSEASE,FIsCollectAudit) VALUES(?,?,?,?,?,?,?,?,?) ";
            try {
                int j;
                int length;
                int i;
                conn = EJBFactory.getConnection((Context)ctx);
                ps1 = conn.prepareStatement(sqlInsert);
                int size = lstAddCmpPeriod.size();
                for (i = 0; i < size; ++i) {
                    infoCmpPeriod = (CmpPeriodInfo)lstAddCmpPeriod.get(i);
                    fCmpPeriodID = infoCmpPeriod.getId().toString();
                    length = teamGroupLeave.size();
                    for (j = 0; j < length; ++j) {
                        tgi = (TeamGroupInfo)teamGroupLeave.get(j);
                        fTeamGroupID = tgi.getId().toString();
                        fid = BOSUuid.create((BOSObjectType)infoEntry.getBOSType()).toString();
                        ps1.setString(1, fid);
                        ps1.setString(2, fCmpPeriodID);
                        ps1.setString(3, fTeamGroupID);
                        ps1.setString(4, fDeptSchemeID);
                        ps1.setInt(5, 0);
                        ps1.setInt(6, 0);
                        ps1.setInt(7, 0);
                        ps1.setInt(8, 0);
                        ps1.setInt(9, 0);
                        ps1.addBatch();
                    }
                }
                size = lstNOchangeCmpPeriod.size();
                for (i = 0; i < size; ++i) {
                    infoCmpPeriod = (CmpPeriodInfo)lstNOchangeCmpPeriod.get(i);
                    fCmpPeriodID = infoCmpPeriod.getId().toString();
                    length = teamGroupAdd.size();
                    for (j = 0; j < length; ++j) {
                        tgi = (TeamGroupInfo)teamGroupAdd.get(j);
                        fTeamGroupID = tgi.getId().toString();
                        fid = BOSUuid.create((BOSObjectType)infoEntry.getBOSType()).toString();
                        ps1.setString(1, fid);
                        ps1.setString(2, fCmpPeriodID);
                        ps1.setString(3, fTeamGroupID);
                        ps1.setString(4, fDeptSchemeID);
                        ps1.setInt(5, 0);
                        ps1.setInt(6, 0);
                        ps1.setInt(7, 0);
                        ps1.setInt(8, 0);
                        ps1.setInt(9, 0);
                        ps1.addBatch();
                    }
                }
                ps1.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps1, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps1, (Connection)conn);
        }
    }

    private void procAddNewOfByAdmin(Context ctx, DeptSchemeInfo infoDeptScheme, CmpPeriodCollection colCmpPeriod, List lstAddCmpPeriod, List lstAddDept, List lstLeaveDept, List lstNOchangeCmpPeriod) throws BOSException {
        CmpPeriodInfo infoCmpPeriod = null;
        String fCmpPeriodID = null;
        String fAdminOrgUnitID = null;
        String fid = null;
        String fDeptSchemeID = infoDeptScheme.getId().toString();
        AdminOrgUnitInfo infoDept = null;
        Map deptSchemeLastReleasedCmpPeriod = this.getDeptSchemeLastReleasedCmpPeriod(ctx, infoDeptScheme);
        lstAddCmpPeriod = this.getPeriodOfInfo(ctx, lstAddCmpPeriod);
        Date lastReleasedCmpPeriodBeginDate = null;
        int hasSubDeptInt = 0;
        Boolean hasSubFlag = null;
        if (lstAddCmpPeriod.size() > 0 || lstAddDept.size() > 0) {
            Connection conn = null;
            PreparedStatement ps1 = null;
            DeptSchemeEntryInfo infoEntry = new DeptSchemeEntryInfo();
            String sqlInsert = " INSERT INTO T_HR_DeptSchemeEntry(FID,FCmpPeriodID,FAdminOrgUnitID,FDeptSchemeID,FhasSubDept,FISMULSENTFLAG,FISPARENTNODE,FISMULRELSEASE,FIsCollectAudit) VALUES(?,?,?,?,?,?,?,?,?) ";
            try {
                int j;
                int length;
                int i;
                conn = EJBFactory.getConnection((Context)ctx);
                ps1 = conn.prepareStatement(sqlInsert);
                int size = lstAddCmpPeriod.size();
                for (i = 0; i < size; ++i) {
                    infoCmpPeriod = (CmpPeriodInfo)lstAddCmpPeriod.get(i);
                    fCmpPeriodID = infoCmpPeriod.getId().toString();
                    length = lstLeaveDept.size();
                    for (j = 0; j < length; ++j) {
                        infoDept = (AdminOrgUnitInfo)lstLeaveDept.get(j);
                        fAdminOrgUnitID = infoDept.getId().toString();
                        lastReleasedCmpPeriodBeginDate = (Date)deptSchemeLastReleasedCmpPeriod.get(fAdminOrgUnitID);
                        if (lastReleasedCmpPeriodBeginDate != null && !lastReleasedCmpPeriodBeginDate.before(infoCmpPeriod.getBeginDate())) continue;
                        hasSubFlag = (Boolean)infoDept.get("hasSubDepkey");
                        hasSubDeptInt = hasSubFlag != false ? 1 : 0;
                        fid = BOSUuid.create((BOSObjectType)infoEntry.getBOSType()).toString();
                        ps1.setString(1, fid);
                        ps1.setString(2, fCmpPeriodID);
                        ps1.setString(3, fAdminOrgUnitID);
                        ps1.setString(4, fDeptSchemeID);
                        ps1.setInt(5, hasSubDeptInt);
                        ps1.setInt(6, 0);
                        ps1.setInt(7, 0);
                        ps1.setInt(8, 0);
                        ps1.setInt(9, 0);
                        ps1.addBatch();
                    }
                }
                size = lstNOchangeCmpPeriod.size();
                for (i = 0; i < size; ++i) {
                    infoCmpPeriod = (CmpPeriodInfo)lstNOchangeCmpPeriod.get(i);
                    fCmpPeriodID = infoCmpPeriod.getId().toString();
                    length = lstAddDept.size();
                    for (j = 0; j < length; ++j) {
                        infoDept = (AdminOrgUnitInfo)lstAddDept.get(j);
                        fAdminOrgUnitID = infoDept.getId().toString();
                        fid = BOSUuid.create((BOSObjectType)infoEntry.getBOSType()).toString();
                        hasSubFlag = (Boolean)infoDept.get("hasSubDepkey");
                        hasSubDeptInt = hasSubFlag != false ? 1 : 0;
                        ps1.setString(1, fid);
                        ps1.setString(2, fCmpPeriodID);
                        ps1.setString(3, fAdminOrgUnitID);
                        ps1.setString(4, fDeptSchemeID);
                        ps1.setInt(5, hasSubDeptInt);
                        ps1.setInt(6, 0);
                        ps1.setInt(7, 0);
                        ps1.setInt(8, 0);
                        ps1.setInt(9, 0);
                        ps1.addBatch();
                    }
                }
                ps1.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps1, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps1, (Connection)conn);
        }
        StringBuffer sbSqlTemp = new StringBuffer("FCmpPeriodID IN(");
        boolean lightFlag = false;
        int sizeCmp = colCmpPeriod.size();
        for (int j = 0; j < sizeCmp; ++j) {
            infoCmpPeriod = colCmpPeriod.get(j);
            Integer state = (Integer)infoCmpPeriod.get("state");
            if (state == 20) continue;
            if (lightFlag) {
                sbSqlTemp.append(",");
                lightFlag = false;
            }
            sbSqlTemp.append("'");
            sbSqlTemp.append(infoCmpPeriod.getId().toString());
            sbSqlTemp.append("'");
            lightFlag = true;
        }
        sbSqlTemp.append(") ");
        int size = lstLeaveDept.size();
        for (int i = 0; i < size; ++i) {
            infoDept = (AdminOrgUnitInfo)lstLeaveDept.get(i);
            fAdminOrgUnitID = infoDept.getId().toString();
            hasSubFlag = (Boolean)infoDept.get("hasSubDepkey");
            StringBuffer sbSql = new StringBuffer(" UPDATE T_HR_DeptSchemeEntry SET FhasSubDept=");
            hasSubDeptInt = hasSubFlag != false ? 1 : 0;
            sbSql.append(hasSubDeptInt);
            sbSql.append(" WHERE " + sbSqlTemp.toString());
            sbSql.append(" AND FDeptSchemeID='" + infoDeptScheme.getId().toString() + "' ");
            sbSql.append(" AND FAdminOrgUnitID='" + fAdminOrgUnitID + "' ");
            DbUtil.execute((Context)ctx, (String)sbSql.toString());
        }
    }

    private Map getDeptSchemeLastReleasedCmpPeriod(Context ctx, DeptSchemeInfo infoDeptScheme) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select DeptSchemeEntry.FAdminOrgUnitID as adminId,max(CmpPeriod.FBeginDate) as lastReleaseCmpPeriod");
        sql.append(" from T_HR_DeptSchemeEntry  as DeptSchemeEntry ");
        sql.append(" inner join T_HR_CMPPERIOD as CmpPeriod on  CmpPeriod.fid=DeptSchemeEntry.FCmpPeriodID ");
        sql.append(" where DeptSchemeEntry.FDeptSchemeID='" + infoDeptScheme.getId().toString() + "' ");
        sql.append(" and DeptSchemeEntry.FDeptInnerSchemeID is not null");
        sql.append(" group by DeptSchemeEntry.FAdminOrgUnitID ");
        HashMap<String, Date> retMap = new HashMap<String, Date>();
        String adminIdTem = null;
        Date beginDate = null;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                adminIdTem = rowSet.getString("adminId");
                beginDate = new Date(rowSet.getDate("lastReleaseCmpPeriod").getTime());
                retMap.put(adminIdTem, beginDate);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return retMap;
    }

    private List getPeriodOfInfo(Context ctx, List lstCmpPeriod) throws BOSException {
        if (lstCmpPeriod == null || lstCmpPeriod.size() == 0) {
            return lstCmpPeriod;
        }
        HashSet<String> set = new HashSet<String>();
        CmpPeriodInfo infoCmpPeriod = null;
        int size = lstCmpPeriod.size();
        for (int i = 0; i < size; ++i) {
            infoCmpPeriod = (CmpPeriodInfo)lstCmpPeriod.get(i);
            set.add(infoCmpPeriod.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("beginDate"));
        view.getSelector().add(new SelectorItemInfo("endDate"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        CmpPeriodCollection cmpPeriodColl = CmpPeriodFactory.getLocalInstance(ctx).getCmpPeriodCollection(view);
        ArrayList<CmpPeriodInfo> retCmpPeriod = new ArrayList<CmpPeriodInfo>();
        int size2 = cmpPeriodColl.size();
        for (int i = 0; i < size2; ++i) {
            retCmpPeriod.add(cmpPeriodColl.get(i));
        }
        return retCmpPeriod;
    }

    @Override
    public DeptSchemeInfo getDeptSchemeInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return (DeptSchemeInfo)this._getDeptSchemeInfo(ctx, true, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((DeptSchemeInfo)model).setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        IObjectPK pk = null;
        DeptSchemeInfo infoDeptScheme = (DeptSchemeInfo)model;
        CmpPeriodCollection colCmpPeriod = infoDeptScheme.getCmpPeriodCollection();
        AdminOrgUnitCollection colDept = infoDeptScheme.getDeptCollection();
        TeamGroupCollection colGroup = infoDeptScheme.getTeamGroupCollection();
        infoDeptScheme.setEntries(null);
        pk = super._submit(ctx, (IObjectValue)infoDeptScheme);
        infoDeptScheme.setCmpPeriodCollection(colCmpPeriod);
        infoDeptScheme.setDeptCollection(colDept);
        infoDeptScheme.setTeamGroupCollection(colGroup);
        this.doDeptScheme(ctx, infoDeptScheme);
        return pk;
    }

    @Override
    protected boolean _canDelDept(Context ctx, String strDeptScheme, String strDept) throws BOSException, DeptSchemeException, EASBizException {
        String strSql = " SELECT COUNT(*) AS EXPR1 FROM T_HR_DeptSchemeEntry WHERE FDeptInnerSchemeID IS NOT NULL AND FDeptSchemeID=? AND FAdminOrgUnitID=? ";
        Connection conn = null;
        PreparedStatement ps1 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps1 = conn.prepareStatement(strSql);
            ps1.setString(1, strDeptScheme);
            ps1.setString(2, strDept);
            ResultSet rs = ps1.executeQuery();
            if (rs.next() && rs.getInt("EXPR1") > 0) {
                throw new DeptSchemeException(DeptSchemeException.RELEASEDEPT_NOT_DELETE);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps1, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps1, (Connection)conn);
        return true;
    }

    @Override
    protected boolean _canDelCmpPeriod(Context ctx, String strDeptScheme, String strCmpPeriod) throws BOSException, DeptSchemeException, EASBizException {
        String strSql = " SELECT COUNT(*) AS EXPR1 FROM T_HR_DeptSchemeEntry WHERE FDeptInnerSchemeID IS NOT NULL AND FDeptSchemeID=? AND FCmpPeriodID=? ";
        Connection conn = null;
        PreparedStatement ps1 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps1 = conn.prepareStatement(strSql);
            ps1.setString(1, strDeptScheme);
            ps1.setString(2, strCmpPeriod);
            ResultSet rs = ps1.executeQuery();
            if (rs.next() && rs.getInt("EXPR1") > 0) {
                throw new DeptSchemeException(DeptSchemeException.RELEASECMPPERIOD_NOT_DELETE);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps1, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps1, (Connection)conn);
        return true;
    }

    @Override
    protected boolean _canAddDept(Context ctx, String strDeptScheme, String strDept, List lstExitDept) throws BOSException, DeptSchemeException, EASBizException {
        return true;
    }

    protected FilterInfo getFilterForCheckNumber(IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        DeptSchemeInfo info = (DeptSchemeInfo)model;
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getHrOrgUnit().getId().toString()));
        return filter;
    }

    @Override
    protected boolean _isRefStandrad(Context ctx, IObjectValue filterInfo) throws BOSException, EASBizException {
        return DeptSchemeFactory.getLocalInstance(ctx).exists((FilterInfo)filterInfo);
    }

    @Override
    protected IObjectValue _getDeptSchemeInfoByOrg(Context ctx, IObjectPK depSchemePk, AdminOrgUnitInfo adminorg) throws BOSException, EASBizException {
        DeptSchemeInfo infoDeptScheme = null;
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        EntityViewInfo infoEntityView1 = new EntityViewInfo();
        FilterInfo infoFilter1 = new FilterInfo();
        infoFilter1.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()));
        infoEntityView1.setFilter(infoFilter1);
        SorterItemInfo sorterOrderItem1 = new SorterItemInfo("beginDate");
        sorterOrderItem1.setSortType(SortType.ASCEND);
        infoEntityView1.getSorter().add(sorterOrderItem1);
        CmpPeriodCollection colAllCmpPeriod = iCmpPeriod.getCmpPeriodCollection(infoEntityView1);
        String ksqlString = "SELECT id,name,number,amountPlan,amountFact,amountBalance,amountDeptPay,useDepCmpStandrad,hrOrgUnit.id,decDigital, depCmpStandrad.id,cmpScheme.id,cmpScheme.name,isBalance,isAssignment WHERE id='" + depSchemePk.toString() + "'";
        IDeptScheme iDeptScheme = DeptSchemeFactory.getLocalInstance(ctx);
        infoDeptScheme = (DeptSchemeInfo)iDeptScheme.getValue(ksqlString);
        IDeptSchemeEntry iDeptSchemeEntry = DeptSchemeEntryFactory.getLocalInstance(ctx);
        EntityViewInfo infoEntityView = new EntityViewInfo();
        FilterInfo infoFilter = new FilterInfo();
        infoFilter.getFilterItems().add(new FilterItemInfo("deptScheme.id", (Object)depSchemePk.toString()));
        infoFilter.getFilterItems().add(new FilterItemInfo("isMulSentFlag", (Object)false));
        infoFilter.getFilterItems().add(new FilterItemInfo("isMulSentFlag", (Object)true));
        infoFilter.getFilterItems().add(new FilterItemInfo("isParentNode", (Object)true));
        infoFilter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)adminorg.getId().toString()));
        infoFilter.setMaskString("#0 AND (#1 OR (#2 AND #3)) and #4");
        infoEntityView.setFilter(infoFilter);
        infoEntityView.getSelector().add(new SelectorItemInfo("*"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpPeriod.id"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpPeriod.beginDate"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpPeriod.endDate"));
        infoEntityView.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
        SorterItemInfo sorterOrderItem = new SorterItemInfo("cmpPeriod.beginDate");
        sorterOrderItem.setSortType(SortType.ASCEND);
        infoEntityView.getSorter().add(sorterOrderItem);
        DeptSchemeEntryCollection colEntry = iDeptSchemeEntry.getDeptSchemeEntryCollection(infoEntityView);
        if (colEntry == null || colEntry.size() <= 0) {
            return infoDeptScheme;
        }
        HashMap<String, AdminOrgUnitInfo> hspDept = new HashMap<String, AdminOrgUnitInfo>();
        HashMap<String, CmpPeriodInfo> hspCmpPeriod = new HashMap<String, CmpPeriodInfo>();
        CmpPeriodCollection colCmpPeriod = new CmpPeriodCollection();
        BigDecimal bdPlan = null;
        BigDecimal bdFact = null;
        BigDecimal bdBalance = null;
        BigDecimal bdDepPay = null;
        DeptSchemeEntryInfo infoEntry = null;
        AdminOrgUnitCollection colDept = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminOrgInfoTemp = null;
        int size = colEntry.size();
        for (int i = 0; i < size; ++i) {
            infoEntry = colEntry.get(i);
            if (hspDept.get(infoEntry.getAdminOrgUnit().getId().toString()) == null) {
                adminOrgInfoTemp = infoEntry.getAdminOrgUnit();
                adminOrgInfoTemp.put("hasSubDepkey", (Object)infoEntry.isHasSubDept());
                hspDept.put(adminOrgInfoTemp.getId().toString(), adminOrgInfoTemp);
                colDept.add(adminOrgInfoTemp);
            }
            if (hspCmpPeriod.get(infoEntry.getCmpPeriod().getId().toString()) == null) {
                hspCmpPeriod.put(infoEntry.getCmpPeriod().getId().toString(), infoEntry.getCmpPeriod());
            }
            bdPlan = HRSchemeUtils.addData(bdPlan, infoEntry.getAmountPlan());
            bdFact = HRSchemeUtils.addData(bdFact, infoEntry.getAmountFact());
            bdBalance = HRSchemeUtils.addData(bdBalance, infoEntry.getAmountBalance());
            bdDepPay = HRSchemeUtils.addData(bdDepPay, infoEntry.getAmountDeptPay());
        }
        String id = null;
        int size2 = colAllCmpPeriod.size();
        for (int i = 0; i < size2; ++i) {
            id = colAllCmpPeriod.get(i).getId().toString();
            if (hspCmpPeriod.get(id) == null) continue;
            colCmpPeriod.add(colAllCmpPeriod.get(i));
        }
        infoDeptScheme.setDeptCollection(colDept);
        infoDeptScheme.setCmpPeriodCollection(colCmpPeriod);
        if (bdPlan != null) {
            infoDeptScheme.setAmountPlan(bdPlan.setScale(2, 4));
        }
        if (bdFact != null) {
            infoDeptScheme.setAmountFact(bdFact.setScale(2, 4));
        }
        if (bdBalance != null) {
            infoDeptScheme.setAmountBalance(bdBalance.setScale(2, 4));
        }
        if (bdDepPay != null) {
            infoDeptScheme.setAmountDeptPay(bdDepPay.setScale(2, 4));
        }
        if (infoDeptScheme.isUseDepCmpStandrad()) {
            ObjectUuidPK pkDepStandScheme = new ObjectUuidPK(infoDeptScheme.getDepCmpStandrad().getId().toString());
            DepCmpStandradSchemeInfo depCmpS = DepCmpStandradSchemeFactory.getLocalInstance(ctx).getDepCmpStandradSchemeInfo((IObjectPK)pkDepStandScheme);
            infoDeptScheme.setDepCmpStandrad(depCmpS);
        }
        return infoDeptScheme;
    }

    @Override
    protected IObjectValue _getDeptSchemeInfoByOrgOfInner(Context ctx, IObjectPK depSchemePk, AdminOrgUnitInfo adminOrg) throws BOSException, EASBizException {
        if (depSchemePk == null || adminOrg == null) {
            return null;
        }
        DeptSchemeInfo infoDeptScheme = null;
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        EntityViewInfo infoEntityView1 = new EntityViewInfo();
        FilterInfo infoFilter1 = new FilterInfo();
        infoFilter1.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()));
        infoEntityView1.setFilter(infoFilter1);
        infoEntityView1.getSelector().add(new SelectorItemInfo("id"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("name"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("number"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("beginDate"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("endDate"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("enableState"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
        SorterItemInfo sorterOrderItem1 = new SorterItemInfo("beginDate");
        sorterOrderItem1.setSortType(SortType.ASCEND);
        infoEntityView1.getSorter().add(sorterOrderItem1);
        CmpPeriodCollection colAllCmpPeriod = iCmpPeriod.getCmpPeriodCollection(infoEntityView1);
        String ksqlString = "SELECT id,name,number,amountPlan,amountFact,amountBalance,amountDeptPay,useDepCmpStandrad,hrOrgUnit.id,decDigital, depCmpStandrad.id,cmpScheme.id,cmpScheme.name,isBalance,isAssignment,collectAudit WHERE id='" + depSchemePk.toString() + "'";
        IDeptScheme iDeptScheme = DeptSchemeFactory.getLocalInstance(ctx);
        infoDeptScheme = (DeptSchemeInfo)iDeptScheme.getValue(ksqlString);
        IDeptSchemeEntry iDeptSchemeEntry = DeptSchemeEntryFactory.getLocalInstance(ctx);
        EntityViewInfo infoEntityView = new EntityViewInfo();
        FilterInfo infoFilter = new FilterInfo();
        infoFilter.getFilterItems().add(new FilterItemInfo("deptScheme.id", (Object)depSchemePk.toString()));
        infoEntityView.setFilter(infoFilter);
        infoEntityView.getSelector().add(new SelectorItemInfo("*"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpPeriod.id"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpPeriod.beginDate"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpPeriod.endDate"));
        infoEntityView.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
        SorterItemInfo sorterOrderItem = new SorterItemInfo("cmpPeriod.beginDate");
        sorterOrderItem.setSortType(SortType.ASCEND);
        infoEntityView.getSorter().add(sorterOrderItem);
        DeptSchemeEntryCollection colEntry = iDeptSchemeEntry.getDeptSchemeEntryCollection(infoEntityView);
        if (colEntry == null || colEntry.size() <= 0) {
            return infoDeptScheme;
        }
        HashMap<String, AdminOrgUnitInfo> hspDept = new HashMap<String, AdminOrgUnitInfo>();
        HashMap<String, CmpPeriodInfo> hspCmpPeriod = new HashMap<String, CmpPeriodInfo>();
        CmpPeriodCollection colCmpPeriod = new CmpPeriodCollection();
        BigDecimal bdPlan = null;
        BigDecimal bdFact = null;
        BigDecimal bdBalance = null;
        BigDecimal bdDepPay = null;
        DeptSchemeEntryInfo infoEntry = null;
        AdminOrgUnitCollection colDept = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminOrgInfoTemp = null;
        int size = colEntry.size();
        for (int i = 0; i < size; ++i) {
            infoEntry = colEntry.get(i);
            if (hspDept.get(infoEntry.getAdminOrgUnit().getId().toString()) == null) {
                adminOrgInfoTemp = infoEntry.getAdminOrgUnit();
                adminOrgInfoTemp.put("hasSubDepkey", (Object)infoEntry.isHasSubDept());
                hspDept.put(adminOrgInfoTemp.getId().toString(), adminOrgInfoTemp);
                colDept.add(adminOrgInfoTemp);
            }
            if (hspCmpPeriod.get(infoEntry.getCmpPeriod().getId().toString()) == null) {
                hspCmpPeriod.put(infoEntry.getCmpPeriod().getId().toString(), infoEntry.getCmpPeriod());
            }
            bdPlan = HRSchemeUtils.addData(bdPlan, infoEntry.getAmountPlan());
            bdFact = HRSchemeUtils.addData(bdFact, infoEntry.getAmountFact());
            bdBalance = HRSchemeUtils.addData(bdBalance, infoEntry.getAmountBalance());
            bdDepPay = HRSchemeUtils.addData(bdDepPay, infoEntry.getAmountDeptPay());
        }
        String id = null;
        int size2 = colAllCmpPeriod.size();
        for (int i = 0; i < size2; ++i) {
            id = colAllCmpPeriod.get(i).getId().toString();
            if (hspCmpPeriod.get(id) == null) continue;
            colCmpPeriod.add(colAllCmpPeriod.get(i));
        }
        infoDeptScheme.setDeptCollection(colDept);
        infoDeptScheme.setCmpPeriodCollection(colCmpPeriod);
        if (bdPlan != null) {
            infoDeptScheme.setAmountPlan(bdPlan.setScale(2, 4));
        }
        if (bdFact != null) {
            infoDeptScheme.setAmountFact(bdFact.setScale(2, 4));
        }
        if (bdBalance != null) {
            infoDeptScheme.setAmountBalance(bdBalance.setScale(2, 4));
        }
        if (bdDepPay != null) {
            infoDeptScheme.setAmountDeptPay(bdDepPay.setScale(2, 4));
        }
        if (infoDeptScheme.isUseDepCmpStandrad()) {
            ObjectUuidPK pkDepStandScheme = new ObjectUuidPK(infoDeptScheme.getDepCmpStandrad().getId().toString());
            DepCmpStandradSchemeInfo depCmpS = DepCmpStandradSchemeFactory.getLocalInstance(ctx).getDepCmpStandradSchemeInfo((IObjectPK)pkDepStandScheme);
            infoDeptScheme.setDepCmpStandrad(depCmpS);
            Integer maxPrec = HRCmpItemUtils.getcmpItemPrecisionByDepCmpStand(ctx, depCmpS);
            infoDeptScheme.setMaxPrecision(maxPrec);
        }
        return infoDeptScheme;
    }

    @Override
    protected IObjectValue _getDeptSchemeInfoByTeamOfInner(Context ctx, IObjectPK depSchemePk, TeamGroupInfo teamGroup) throws BOSException, EASBizException {
        if (depSchemePk == null || teamGroup == null) {
            return null;
        }
        DeptSchemeInfo infoDeptScheme = null;
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        EntityViewInfo infoEntityView1 = new EntityViewInfo();
        FilterInfo infoFilter1 = new FilterInfo();
        infoFilter1.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()));
        infoEntityView1.setFilter(infoFilter1);
        infoEntityView1.getSelector().add(new SelectorItemInfo("id"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("name"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("number"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("beginDate"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("endDate"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("enableState"));
        infoEntityView1.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
        SorterItemInfo sorterOrderItem1 = new SorterItemInfo("beginDate");
        sorterOrderItem1.setSortType(SortType.ASCEND);
        infoEntityView1.getSorter().add(sorterOrderItem1);
        CmpPeriodCollection colAllCmpPeriod = iCmpPeriod.getCmpPeriodCollection(infoEntityView1);
        String ksqlString = "SELECT id,name,number,amountPlan,amountFact,amountBalance,amountDeptPay,useDepCmpStandrad,hrOrgUnit.id,decDigital, depCmpStandrad.id,cmpScheme.id,cmpScheme.name,isBalance,isAssignment,collectAudit WHERE id='" + depSchemePk.toString() + "'";
        IDeptScheme iDeptScheme = DeptSchemeFactory.getLocalInstance(ctx);
        infoDeptScheme = (DeptSchemeInfo)iDeptScheme.getValue(ksqlString);
        IDeptSchemeEntry iDeptSchemeEntry = DeptSchemeEntryFactory.getLocalInstance(ctx);
        EntityViewInfo infoEntityView = new EntityViewInfo();
        FilterInfo infoFilter = new FilterInfo();
        infoFilter.getFilterItems().add(new FilterItemInfo("deptScheme.id", (Object)depSchemePk.toString()));
        infoEntityView.setFilter(infoFilter);
        infoEntityView.getSelector().add(new SelectorItemInfo("*"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpPeriod.id"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpPeriod.beginDate"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpPeriod.endDate"));
        infoEntityView.getSelector().add(new SelectorItemInfo("teamGroup.id"));
        SorterItemInfo sorterOrderItem = new SorterItemInfo("cmpPeriod.beginDate");
        sorterOrderItem.setSortType(SortType.ASCEND);
        infoEntityView.getSorter().add(sorterOrderItem);
        DeptSchemeEntryCollection colEntry = iDeptSchemeEntry.getDeptSchemeEntryCollection(infoEntityView);
        if (colEntry == null || colEntry.size() <= 0) {
            return infoDeptScheme;
        }
        HashMap<String, TeamGroupInfo> hspDept = new HashMap<String, TeamGroupInfo>();
        HashMap<String, CmpPeriodInfo> hspCmpPeriod = new HashMap<String, CmpPeriodInfo>();
        CmpPeriodCollection colCmpPeriod = new CmpPeriodCollection();
        BigDecimal bdPlan = null;
        BigDecimal bdFact = null;
        BigDecimal bdBalance = null;
        BigDecimal bdDepPay = null;
        DeptSchemeEntryInfo infoEntry = null;
        TeamGroupCollection colTeamGroup = new TeamGroupCollection();
        TeamGroupInfo tgiTemp = null;
        int size = colEntry.size();
        for (int i = 0; i < size; ++i) {
            infoEntry = colEntry.get(i);
            if (hspDept.get(infoEntry.getTeamGroup().getId().toString()) == null && (tgiTemp = infoEntry.getTeamGroup()) != null) {
                hspDept.put(tgiTemp.getId().toString(), tgiTemp);
                colTeamGroup.add(tgiTemp);
            }
            if (hspCmpPeriod.get(infoEntry.getCmpPeriod().getId().toString()) == null) {
                hspCmpPeriod.put(infoEntry.getCmpPeriod().getId().toString(), infoEntry.getCmpPeriod());
            }
            bdPlan = HRSchemeUtils.addData(bdPlan, infoEntry.getAmountPlan());
            bdFact = HRSchemeUtils.addData(bdFact, infoEntry.getAmountFact());
            bdBalance = HRSchemeUtils.addData(bdBalance, infoEntry.getAmountBalance());
            bdDepPay = HRSchemeUtils.addData(bdDepPay, infoEntry.getAmountDeptPay());
        }
        String id = null;
        int size2 = colAllCmpPeriod.size();
        for (int i = 0; i < size2; ++i) {
            id = colAllCmpPeriod.get(i).getId().toString();
            if (hspCmpPeriod.get(id) == null) continue;
            colCmpPeriod.add(colAllCmpPeriod.get(i));
        }
        infoDeptScheme.setTeamGroupCollection(colTeamGroup);
        infoDeptScheme.setCmpPeriodCollection(colCmpPeriod);
        if (bdPlan != null) {
            infoDeptScheme.setAmountPlan(bdPlan.setScale(2, 4));
        }
        if (bdFact != null) {
            infoDeptScheme.setAmountFact(bdFact.setScale(2, 4));
        }
        if (bdBalance != null) {
            infoDeptScheme.setAmountBalance(bdBalance.setScale(2, 4));
        }
        if (bdDepPay != null) {
            infoDeptScheme.setAmountDeptPay(bdDepPay.setScale(2, 4));
        }
        if (infoDeptScheme.isUseDepCmpStandrad()) {
            ObjectUuidPK pkDepStandScheme = new ObjectUuidPK(infoDeptScheme.getDepCmpStandrad().getId().toString());
            DepCmpStandradSchemeInfo depCmpS = DepCmpStandradSchemeFactory.getLocalInstance(ctx).getDepCmpStandradSchemeInfo((IObjectPK)pkDepStandScheme);
            infoDeptScheme.setDepCmpStandrad(depCmpS);
            Integer maxPrec = HRCmpItemUtils.getcmpItemPrecisionByDepCmpStand(ctx, depCmpS);
            infoDeptScheme.setMaxPrecision(maxPrec);
        }
        return infoDeptScheme;
    }
}

