/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.app.AbstractHRCmpDataAuditFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRCmpIndexUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class HRCmpDataAuditFacadeControllerBean
extends AbstractHRCmpDataAuditFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.HRCmpDataAuditFacadeControllerBean");
    private int ERRORDATA_INIT_SHOWCOUNT = 10000;

    @Override
    protected HashMap _auditCmpData(Context ctx, String[] tableTypes) throws BOSException, EASBizException {
        HashMap<String, HashMap> rtnMap = new HashMap<String, HashMap>();
        HashMap mapTemp = null;
        int size = tableTypes.length;
        for (int i = 0; i < size; ++i) {
            if (tableTypes[i].equals("schemePerson")) {
                mapTemp = this.auditSchemePerson(ctx);
                if (mapTemp == null) continue;
                rtnMap.put("schemePerson", mapTemp);
                continue;
            }
            if (tableTypes[i].equals("periodEndInput")) {
                mapTemp = this.auditPeriodEndInput(ctx);
                if (mapTemp == null) continue;
                rtnMap.put("periodEndInput", mapTemp);
                continue;
            }
            if (tableTypes[i].equals("tryPeriodEndInput")) continue;
            if (tableTypes[i].equals("allSchemeHorTable")) {
                this.auditAllHorTable(ctx, rtnMap);
                continue;
            }
            if (tableTypes[i].equals("allSchemeHisTable")) {
                this.auditAllHisTable(ctx, rtnMap);
                continue;
            }
            if (tableTypes[i].toUpperCase().indexOf("T_HR_SCHM_") >= 0) {
                mapTemp = this.auditOneHorTable(ctx, tableTypes[i], null);
                if (mapTemp == null) continue;
                rtnMap.put(tableTypes[i], mapTemp);
                continue;
            }
            if (tableTypes[i].toUpperCase().indexOf("T_HR_SCHMHIS_") >= 0) {
                mapTemp = this.auditOneHisTable(ctx, tableTypes[i], null);
                if (mapTemp == null) continue;
                rtnMap.put(tableTypes[i], mapTemp);
                continue;
            }
            if (tableTypes[i].equals("fixedSchemePerson")) {
                mapTemp = this.auditFixedSchemePerson(ctx);
                if (mapTemp == null) continue;
                rtnMap.put(tableTypes[i], mapTemp);
                continue;
            }
            if (tableTypes[i].equals("allFixedSchemeHorTable")) {
                this.auditAllFixedHorTable(ctx, rtnMap);
                continue;
            }
            if (tableTypes[i].toUpperCase().indexOf("T_HR_FCS_") < 0 || (mapTemp = this.auditOneFixedHorTable(ctx, tableTypes[i], null, null)) == null) continue;
            rtnMap.put(tableTypes[i], mapTemp);
        }
        return rtnMap;
    }

    @Override
    protected void _fixCmpData(Context ctx, String tableType, HashMap errorData) throws BOSException, EASBizException {
        if (tableType == null) {
            return;
        }
        StringBuffer sqlDelete = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (tableType.equals("schemePerson")) {
                sqlDelete = new StringBuffer();
                if (KSqlUtil.getDbType((Connection)conn) == 3) {
                    sqlDelete.append("/*dialect*/ delete t_hr_cmpschemeperson from t_hr_cmpschemeperson T1 ");
                    sqlDelete.append(" where T1.Fid <> (");
                    sqlDelete.append(" select max(T2.fid) from t_hr_cmpschemeperson T2");
                    sqlDelete.append(" where T2.fcmpschemeid=T1.fcmpschemeid and T2.fpersonid=T1.fpersonid ");
                    sqlDelete.append(" and T2.FAdminOrgUnitID = T1.FAdminOrgUnitID and T2.FPositionID = T1.FPositionID");
                    sqlDelete.append(" )");
                } else {
                    sqlDelete.append(" delete from t_hr_cmpschemeperson T1 ");
                    sqlDelete.append(" where T1.Fid <> (");
                    sqlDelete.append(" select max(T2.fid) from t_hr_cmpschemeperson T2");
                    sqlDelete.append(" where T2.fcmpschemeid=T1.fcmpschemeid and T2.fpersonid=T1.fpersonid ");
                    sqlDelete.append(" and T2.FAdminOrgUnitID = T1.FAdminOrgUnitID and T2.FPositionID = T1.FPositionID");
                    sqlDelete.append(" )");
                }
                DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            } else if (tableType.equals("periodEndInput")) {
                this.fixPeriodEndInputTable(ctx, KSqlUtil.getDbType((Connection)conn));
            } else if (tableType.indexOf("T_HR_SCHM_") >= 0) {
                this.fixOneSchemeHorTable(ctx, tableType);
            } else if (tableType.indexOf("T_HR_SCHMHIS_") >= 0) {
                this.fixOneSchemeHisTable(ctx, tableType);
            } else if (tableType.equals("fixedSchemePerson")) {
                sqlDelete = new StringBuffer();
                if (KSqlUtil.getDbType((Connection)conn) == 3) {
                    sqlDelete.append("/*dialect*/ delete T_HR_FixedCmpSchemePerson from T_HR_FixedCmpSchemePerson T1 ");
                    sqlDelete.append(" where T1.Fid <> (");
                    sqlDelete.append(" select max(T2.fid) from T_HR_FixedCmpSchemePerson T2");
                    sqlDelete.append(" where T2.FFixedCmpSchemeID=T1.FFixedCmpSchemeID and T2.fpersonid=T1.fpersonid ");
                    sqlDelete.append(" and T2.FEnable = T1.FEnable and T2.FAudited = T1.FAudited");
                    sqlDelete.append(" )");
                } else {
                    sqlDelete.append(" delete from T_HR_FixedCmpSchemePerson T1 ");
                    sqlDelete.append(" where T1.Fid <> (");
                    sqlDelete.append(" select max(T2.fid) from T_HR_FixedCmpSchemePerson T2");
                    sqlDelete.append(" where T2.FFixedCmpSchemeID=T1.FFixedCmpSchemeID and T2.fpersonid=T1.fpersonid ");
                    sqlDelete.append(" and T2.FEnable = T1.FEnable and T2.FAudited = T1.FAudited");
                    sqlDelete.append(" )");
                }
                DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            } else if (tableType.indexOf("T_HR_FCS_") >= 0) {
                this.fixOneFixedSchemeHorTable(ctx, tableType);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void fixPeriodEndInputTable(Context ctx, int curDBType) throws BOSException {
        StringBuffer sqlDelete = new StringBuffer();
        if (curDBType == 3) {
            sqlDelete.append("/*dialect*/ delete t_hr_periodEndInput from t_hr_periodEndInput T1 ");
            sqlDelete.append(" where (T1.FFLOATVALUE is null) and (T1.FINTVALUE is null) and (T1.FSTRINGVALUE is null) and (T1.FDATEVALUE is null) ");
            sqlDelete.append(" and T1.fid <> (");
            sqlDelete.append(" select max(T2.fid) from t_hr_periodEndInput T2 ");
            sqlDelete.append(" where T2.fcmpschemeid = T1.fcmpschemeid and T2.fcmpperiodid = T1.fcmpperiodid");
            sqlDelete.append(" and T2.fpersonid=T1.fpersonid and T2.fcmpitemid=T1.fcmpitemid and T2.fValue=T1.fValue");
            sqlDelete.append(" and (T2.FFLOATVALUE is null) and (T2.FINTVALUE is null)");
            sqlDelete.append(" and (T2.FSTRINGVALUE is null) and (T2.FDATEVALUE is null)");
            sqlDelete.append(" and T2.FTime = T1.FTime)");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            sqlDelete.append("/*dialect*/ delete t_hr_periodEndInput from t_hr_periodEndInput T1 ");
            sqlDelete.append(" where (T1.FVALUE is null) and (T1.FINTVALUE is null) and (T1.FSTRINGVALUE is null) and (T1.FDATEVALUE is null) ");
            sqlDelete.append(" and T1.fid <> (");
            sqlDelete.append(" select max(T2.fid) from t_hr_periodEndInput T2 ");
            sqlDelete.append(" where T2.fcmpschemeid = T1.fcmpschemeid and T2.fcmpperiodid = T1.fcmpperiodid and T2.FTime = T1.FTime");
            sqlDelete.append(" and T2.fpersonid=T1.fpersonid and T2.fcmpitemid=T1.fcmpitemid and T2.FFLOATVALUE=T1.FFLOATVALUE");
            sqlDelete.append(" and (T2.FVALUE is null) and (T2.FINTVALUE is null)");
            sqlDelete.append(" and (T2.FSTRINGVALUE is null) and (T2.FDATEVALUE is null)");
            sqlDelete.append(" )");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            sqlDelete.append("/*dialect*/ delete t_hr_periodEndInput from t_hr_periodEndInput T1 ");
            sqlDelete.append(" where (T1.FFLOATVALUE is null) and (T1.FVALUE is null) and (T1.FSTRINGVALUE is null) and (T1.FDATEVALUE is null) ");
            sqlDelete.append(" and T1.fid <> (");
            sqlDelete.append(" select max(T2.fid) from t_hr_periodEndInput T2 ");
            sqlDelete.append(" where T2.fcmpschemeid = T1.fcmpschemeid and T2.fcmpperiodid = T1.fcmpperiodid and T2.FTime = T1.FTime");
            sqlDelete.append(" and T2.fpersonid=T1.fpersonid and T2.fcmpitemid=T1.fcmpitemid and T2.FINTVALUE=T1.FINTVALUE");
            sqlDelete.append(" and (T2.FFLOATVALUE is null) and (T2.FVALUE is null)");
            sqlDelete.append(" and (T2.FSTRINGVALUE is null) and (T2.FDATEVALUE is null)");
            sqlDelete.append(" )");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            sqlDelete.append("/*dialect*/ delete t_hr_periodEndInput from t_hr_periodEndInput T1 ");
            sqlDelete.append(" where (T1.FFLOATVALUE is null) and (T1.FINTVALUE is null) and (T1.FVALUE is null) and (T1.FDATEVALUE is null) ");
            sqlDelete.append(" and T1.fid <> (");
            sqlDelete.append(" select max(T2.fid) from t_hr_periodEndInput T2 ");
            sqlDelete.append(" where T2.fcmpschemeid = T1.fcmpschemeid and T2.fcmpperiodid = T1.fcmpperiodid and T2.FTime = T1.FTime");
            sqlDelete.append(" and T2.fpersonid=T1.fpersonid and T2.fcmpitemid=T1.fcmpitemid and T2.FSTRINGVALUE=T1.FSTRINGVALUE");
            sqlDelete.append(" and (T2.FFLOATVALUE is null) and (T2.FINTVALUE is null)");
            sqlDelete.append(" and (T2.FVALUE is null) and (T2.FDATEVALUE is null)");
            sqlDelete.append(" )");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            sqlDelete.append("/*dialect*/ delete t_hr_periodEndInput from t_hr_periodEndInput T1 ");
            sqlDelete.append(" where (T1.FFLOATVALUE is null) and (T1.FINTVALUE is null) and (T1.FSTRINGVALUE is null) and (T1.FVALUE is null) ");
            sqlDelete.append(" and T1.fid <> (");
            sqlDelete.append(" select max(T2.fid) from t_hr_periodEndInput T2 ");
            sqlDelete.append(" where T2.fcmpschemeid = T1.fcmpschemeid and T2.fcmpperiodid = T1.fcmpperiodid and T2.FTime = T1.FTime");
            sqlDelete.append(" and T2.fpersonid=T1.fpersonid and T2.fcmpitemid=T1.fcmpitemid and T2.FDATEVALUE=T1.FDATEVALUE");
            sqlDelete.append(" and (T2.FFLOATVALUE is null) and (T2.FINTVALUE is null)");
            sqlDelete.append(" and (T2.FSTRINGVALUE is null) and (T2.FVALUE is null)");
            sqlDelete.append(" )");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
        } else {
            sqlDelete.append(" delete from t_hr_periodEndInput T1 ");
            sqlDelete.append(" where (T1.FFLOATVALUE is null) and (T1.FINTVALUE is null) and (T1.FSTRINGVALUE is null) and (T1.FDATEVALUE is null) ");
            sqlDelete.append(" and T1.fid <> (");
            sqlDelete.append(" select max(T2.fid) from t_hr_periodEndInput T2 ");
            sqlDelete.append(" where T2.fcmpschemeid = T1.fcmpschemeid and T2.fcmpperiodid = T1.fcmpperiodid ");
            sqlDelete.append(" and T2.fpersonid=T1.fpersonid and T2.fcmpitemid=T1.fcmpitemid and T2.fValue=T1.fValue and T2.FTime = T1.FTime ");
            sqlDelete.append(" and (T2.FFLOATVALUE is null) and (T2.FINTVALUE is null)");
            sqlDelete.append(" and (T2.FSTRINGVALUE is null) and (T2.FDATEVALUE is null)");
            sqlDelete.append(" )");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            sqlDelete.append(" delete from t_hr_periodEndInput T1 ");
            sqlDelete.append(" where (T1.FVALUE is null) and (T1.FINTVALUE is null) and (T1.FSTRINGVALUE is null) and (T1.FDATEVALUE is null) ");
            sqlDelete.append(" and T1.fid <> (");
            sqlDelete.append(" select max(T2.fid) from t_hr_periodEndInput T2 ");
            sqlDelete.append(" where T2.fcmpschemeid = T1.fcmpschemeid and T2.fcmpperiodid = T1.fcmpperiodid");
            sqlDelete.append(" and T2.fpersonid=T1.fpersonid and T2.fcmpitemid=T1.fcmpitemid and T2.FFLOATVALUE=T1.FFLOATVALUE and T2.FTime = T1.FTime");
            sqlDelete.append(" and (T2.FVALUE is null) and (T2.FINTVALUE is null)");
            sqlDelete.append(" and (T2.FSTRINGVALUE is null) and (T2.FDATEVALUE is null)");
            sqlDelete.append(" )");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            sqlDelete.append(" delete from t_hr_periodEndInput T1 ");
            sqlDelete.append(" where (T1.FFLOATVALUE is null) and (T1.FVALUE is null) and (T1.FSTRINGVALUE is null) and (T1.FDATEVALUE is null) ");
            sqlDelete.append(" and T1.fid <> (");
            sqlDelete.append(" select max(T2.fid) from t_hr_periodEndInput T2 ");
            sqlDelete.append(" where T2.fcmpschemeid = T1.fcmpschemeid and T2.fcmpperiodid = T1.fcmpperiodid");
            sqlDelete.append(" and T2.fpersonid=T1.fpersonid and T2.fcmpitemid=T1.fcmpitemid and T2.FINTVALUE=T1.FINTVALUE and T2.FTime = T1.FTime");
            sqlDelete.append(" and (T2.FFLOATVALUE is null) and (T2.FVALUE is null)");
            sqlDelete.append(" and (T2.FSTRINGVALUE is null) and (T2.FDATEVALUE is null)");
            sqlDelete.append(" )");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            sqlDelete.append(" delete from t_hr_periodEndInput T1 ");
            sqlDelete.append(" where (T1.FFLOATVALUE is null) and (T1.FINTVALUE is null) and (T1.FVALUE is null) and (T1.FDATEVALUE is null) ");
            sqlDelete.append(" and T1.fid <> (");
            sqlDelete.append(" select max(T2.fid) from t_hr_periodEndInput T2 ");
            sqlDelete.append(" where T2.fcmpschemeid = T1.fcmpschemeid and T2.fcmpperiodid = T1.fcmpperiodid");
            sqlDelete.append(" and T2.fpersonid=T1.fpersonid and T2.fcmpitemid=T1.fcmpitemid and T2.FSTRINGVALUE=T1.FSTRINGVALUE and T2.FTime = T1.FTime");
            sqlDelete.append(" and (T2.FFLOATVALUE is null) and (T2.FINTVALUE is null)");
            sqlDelete.append(" and (T2.FVALUE is null) and (T2.FDATEVALUE is null)");
            sqlDelete.append(" )");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            sqlDelete.append(" delete from t_hr_periodEndInput T1 ");
            sqlDelete.append(" where (T1.FFLOATVALUE is null) and (T1.FINTVALUE is null) and (T1.FSTRINGVALUE is null) and (T1.FVALUE is null) ");
            sqlDelete.append(" and T1.fid <> (");
            sqlDelete.append(" select max(T2.fid) from t_hr_periodEndInput T2 ");
            sqlDelete.append(" where T2.fcmpschemeid = T1.fcmpschemeid and T2.fcmpperiodid = T1.fcmpperiodid");
            sqlDelete.append(" and T2.fpersonid=T1.fpersonid and T2.fcmpitemid=T1.fcmpitemid and T2.FDATEVALUE=T1.FDATEVALUE and T2.FTime = T1.FTime");
            sqlDelete.append(" and (T2.FFLOATVALUE is null) and (T2.FINTVALUE is null)");
            sqlDelete.append(" and (T2.FSTRINGVALUE is null) and (T2.FVALUE is null)");
            sqlDelete.append(" )");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
        }
    }

    private void fixOneFixedSchemeHorTable(Context ctx, String strFixedHorTableName) throws BOSException {
        Connection conn = null;
        StringBuffer deleteSql = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (KSqlUtil.getDbType((Connection)conn) == 3) {
                deleteSql.append(" declare @max integer,@fpersonid varchar(44),@fotherenabledate dateTime ");
                deleteSql.append(" declare cur_rows cursor local for select fpersonid,fotherenabledate,count(*) from " + strFixedHorTableName);
                deleteSql.append(" group by fpersonid,fotherenabledate  having count(*) > 1");
                deleteSql.append(" open cur_rows ");
                deleteSql.append(" fetch cur_rows into @fpersonid,@fotherenabledate,@max   ");
                deleteSql.append(" while @@fetch_status=0 ");
                deleteSql.append(" begin ");
                deleteSql.append(" select @max = @max -1 ");
                deleteSql.append(" set rowcount @max ");
                deleteSql.append(" delete from  " + strFixedHorTableName + " where fpersonid = @fpersonid and fotherenabledate = @fotherenabledate ");
                deleteSql.append(" fetch cur_rows into  @fpersonid,@fotherenabledate,@max  ");
                deleteSql.append(" end ");
                deleteSql.append(" close cur_rows ");
                deleteSql.append(" set rowcount 0 ");
            } else if (KSqlUtil.getDbType((Connection)conn) == 2 || KSqlUtil.getDbType((Connection)conn) == 8 || KSqlUtil.getDbType((Connection)conn) == 7) {
                deleteSql.append(" delete from " + strFixedHorTableName + " T1 ");
                deleteSql.append(" where T1.rowid != (");
                deleteSql.append(" select max(T2.rowid) from " + strFixedHorTableName + " T2 where T2.fpersonid = T1.fpersonid");
                deleteSql.append(" and T2.fotherenabledate = T1.fotherenabledate");
                deleteSql.append(" )");
            } else if (KSqlUtil.getDbType((Connection)conn) == 1) {
                deleteSql.append(" delete from ");
                deleteSql.append(" (SELECT row_number() OVER(PARTITION BY fpersonid,fotherenabledate) as seq from " + strFixedHorTableName + ") T1");
                deleteSql.append(" where T1.seq > 1");
            }
            if (deleteSql.toString().length() > 5) {
                DbUtil.execute((Context)ctx, (String)("/*dialect*/" + deleteSql.toString()));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void fixOneSchemeHorTable(Context ctx, String strHorTableName) throws BOSException {
        Connection conn = null;
        StringBuffer deleteSql = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (KSqlUtil.getDbType((Connection)conn) == 3) {
                deleteSql.append(" declare @max integer,@fpersonid varchar(44),@FAdminOrgUnitID varchar(44),@FPositionID varchar(44) ");
                deleteSql.append(" declare cur_rows cursor local for select fpersonid,FAdminOrgUnitID,FPositionID,count(*) from " + strHorTableName);
                deleteSql.append(" group by fpersonid,FAdminOrgUnitID,FPositionID  having count(*) > 1");
                deleteSql.append(" open cur_rows ");
                deleteSql.append(" fetch cur_rows into @fpersonid,@FAdminOrgUnitID,@FPositionID,@max   ");
                deleteSql.append(" while @@fetch_status=0 ");
                deleteSql.append(" begin ");
                deleteSql.append(" select @max = @max -1 ");
                deleteSql.append(" set rowcount @max ");
                deleteSql.append(" delete from  " + strHorTableName + " where fpersonid = @fpersonid and FAdminOrgUnitID = @FAdminOrgUnitID and FPositionID = @FPositionID");
                deleteSql.append(" fetch cur_rows into  @fpersonid,@FAdminOrgUnitID,@FPositionID,@max  ");
                deleteSql.append(" end ");
                deleteSql.append(" close cur_rows ");
                deleteSql.append(" set rowcount 0 ");
            } else if (KSqlUtil.getDbType((Connection)conn) == 2 || KSqlUtil.getDbType((Connection)conn) == 8 || KSqlUtil.getDbType((Connection)conn) == 7) {
                deleteSql.append(" delete from " + strHorTableName + " T1 ");
                deleteSql.append(" where T1.rowid != (");
                deleteSql.append(" select max(T2.rowid) from " + strHorTableName + " T2 where T2.fpersonid = T1.fpersonid");
                deleteSql.append(" and T2.FAdminOrgUnitID = T1.FAdminOrgUnitID and T2.FPositionID = T1.FPositionID");
                deleteSql.append(" )");
            } else if (KSqlUtil.getDbType((Connection)conn) == 1) {
                deleteSql.append(" delete from ");
                deleteSql.append(" (SELECT row_number() OVER(PARTITION BY fpersonid,FAdminOrgUnitID,FPositionID) as seq from " + strHorTableName + ") T1");
                deleteSql.append(" where T1.seq > 1");
            }
            if (deleteSql.toString().length() > 5) {
                DbUtil.execute((Context)ctx, (String)("/*dialect*/" + deleteSql.toString()));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void fixOneSchemeHisTable(Context ctx, String strHisTableName) throws BOSException {
        Connection conn = null;
        StringBuffer deleteSql = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (KSqlUtil.getDbType((Connection)conn) == 3) {
                deleteSql.append(" declare @max integer,@fperiod varchar(44),@fpersonid varchar(44),@FAdminOrgUnitID varchar(44),@FPositionID varchar(44) ");
                deleteSql.append(" declare cur_rows cursor local for select fperiod,fpersonid,FAdminOrgUnitID,FPositionID,Ftime,count(*) from " + strHisTableName);
                deleteSql.append(" group by fperiod,fpersonid,FAdminOrgUnitID,FPositionID,Ftime having count(*) > 1");
                deleteSql.append(" open cur_rows ");
                deleteSql.append(" fetch cur_rows into @fperiod,@fpersonid,@FAdminOrgUnitID,@FPositionID,@max ");
                deleteSql.append(" while @@fetch_status=0 ");
                deleteSql.append(" begin ");
                deleteSql.append(" select @max = @max -1 ");
                deleteSql.append(" set rowcount @max ");
                deleteSql.append(" delete from  " + strHisTableName + " where fperiod=@fperiod and fpersonid = @fpersonid");
                deleteSql.append(" and FAdminOrgUnitID = @FAdminOrgUnitID and FPositionID = @FPositionID");
                deleteSql.append(" fetch cur_rows into @fperiod,@fpersonid,@FAdminOrgUnitID,@FPositionID,@max  ");
                deleteSql.append(" end ");
                deleteSql.append(" close cur_rows ");
                deleteSql.append(" set rowcount 0 ");
            } else if (KSqlUtil.getDbType((Connection)conn) == 2 || KSqlUtil.getDbType((Connection)conn) == 8 || KSqlUtil.getDbType((Connection)conn) == 7) {
                deleteSql.append(" delete from " + strHisTableName + " T1 ");
                deleteSql.append(" where T1.rowid != (");
                deleteSql.append(" select max(T2.rowid) from " + strHisTableName + " T2 ");
                deleteSql.append(" where T2.fperiod=T1.fperiod and T2.fpersonid = T1.fpersonid and T2.ftime=T1.ftime");
                deleteSql.append(" and T2.FAdminOrgUnitID = T1.FAdminOrgUnitID and T2.FPositionID = T1.FPositionID");
                deleteSql.append(" )");
            } else if (KSqlUtil.getDbType((Connection)conn) == 1) {
                deleteSql.append(" delete from ");
                deleteSql.append(" (SELECT row_number() OVER(PARTITION BY fperiod,fpersonid,FAdminOrgUnitID,FPositionID,ftime) as seq from " + strHisTableName + ") T1");
                deleteSql.append(" where T1.seq > 1");
            }
            if (deleteSql.toString().length() > 5) {
                DbUtil.execute((Context)ctx, (String)("/*dialect*/" + deleteSql.toString()));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private HashMap auditFixedSchemePerson(Context ctx) throws BOSException {
        HashMap<String, String> mapSchemePerson = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select  top " + this.ERRORDATA_INIT_SHOWCOUNT + " T1.Fid as FID,T1.FFixedCmpSchemeID as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"50_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T1.fpersonid as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"51_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",");
        sql.append(" T3.fnumber as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"52_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T1.FEnable as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"53_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T1.FAudited ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"54_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append("");
        sql.append(" from T_HR_FixedCmpSchemePerson T1");
        sql.append(" inner join t_bd_person T3 on T3.fid = T1.fpersonid");
        sql.append(" inner join (select FFixedCmpSchemeID,fpersonid from T_HR_FixedCmpSchemePerson group by FFixedCmpSchemeID,fpersonid having count(*) > 1) T11 ");
        sql.append(" on T11.FFixedCmpSchemeID=T1.FFixedCmpSchemeID and T11.fpersonid=T1.fpersonid");
        sql.append(" order by T1.FFixedCmpSchemeID,T1.fpersonid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() > 0) {
            mapSchemePerson.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"55_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            mapSchemePerson.put("errorData", (String)rs);
            return mapSchemePerson;
        }
        return null;
    }

    private HashMap auditSchemePerson(Context ctx) throws BOSException {
        if (!HRCmpIndexUtils.isExistSameIndex(ctx, "UX_HR_CmpSchPer")) {
            String language = ctx.getLocale().getLanguage();
            HashMap<String, String> mapSchemePerson = new HashMap<String, String>();
            StringBuffer sql = new StringBuffer();
            sql.append("select top " + this.ERRORDATA_INIT_SHOWCOUNT + " T1.Fid as FID,T1.fcmpschemeid as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"56_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T2.fname_").append(language).append(" as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"57_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T1.fpersonid as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"51_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",");
            sql.append(" T3.fnumber as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"52_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(" ,T4.Fname_").append(language).append(" as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"58_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T5.FName_").append(language).append("  as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"59_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append("");
            sql.append(" from t_hr_cmpschemeperson T1");
            sql.append(" inner join t_hr_cmpscheme T2 on T2.fid = T1.fcmpSchemeId");
            sql.append(" inner join t_bd_person T3 on T3.fid = T1.fpersonid");
            sql.append(" inner join t_org_admin T4 on T4.fid = T1.FAdminOrgUnitID");
            sql.append(" inner join t_org_position T5 on T5.fid = T1.FPositionId");
            sql.append(" inner join (select fcmpschemeid,fpersonid from t_hr_cmpschemeperson group by fcmpschemeid,fpersonid having count(*) > 1) T11 ");
            sql.append(" on T11.fcmpschemeid=T1.fcmpschemeid and T11.fpersonid=T1.fpersonid");
            sql.append(" order by T1.fcmpschemeid,T1.fpersonid");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.size() > 0) {
                mapSchemePerson.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"60_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                mapSchemePerson.put("errorData", (String)rs);
                return mapSchemePerson;
            }
            sql = new StringBuffer();
            sql.append(" CREATE UNIQUE INDEX UX_HR_CmpSchPer ON T_HR_CmpSchemePerson(FCmpSchemeID ,FPersonID)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return null;
    }

    private HashMap auditPeriodEndInput(Context ctx) throws BOSException {
        if (!HRCmpIndexUtils.isExistSameIndex(ctx, "UX_HR_PEndInput")) {
            String language = ctx.getLocale().getLanguage();
            HashMap<String, String> mapPeriodEndInput = new HashMap<String, String>();
            StringBuffer sql = new StringBuffer();
            sql.append("select top " + this.ERRORDATA_INIT_SHOWCOUNT + " T1.Fid as FID,T1.fcmpSchemeid,T2.fname_").append(language).append(" as schemeName,T1.fcmpperiodid,T3.fname_").append(language).append(" as periodName,");
            sql.append(" t1.fpersonid,T4.fnumber,t1.fcmpitemid,T5.fname_").append(language).append(" as itemName,T1.ftime as time,T1.fvalue,");
            sql.append(" T1.FFLOATVALUE,T1.FINTVALUE,T1.FSTRINGVALUE,T1.FDATEVALUE");
            sql.append(" from t_hr_periodEndInput T1");
            sql.append(" inner join t_hr_cmpscheme T2 on T2.fid = T1.Fcmpschemeid");
            sql.append(" inner join t_hr_cmpperiod T3 on T3.fid = T1.fcmpperiodid");
            sql.append(" inner join t_bd_person T4 on T4.fid = T1.fpersonid");
            sql.append(" inner join T_hr_cmpitem T5 on T5.fid = T1.fcmpItemId");
            sql.append(" inner join (");
            sql.append(" select fcmpschemeid,fcmpperiodid,fpersonid,fcmpitemid,ftime from t_hr_periodEndInput");
            sql.append(" group by fcmpschemeid,fcmpperiodid,fpersonid,fcmpitemid,ftime having count(*) > 1");
            sql.append(" ) TRep on TRep.fcmpschemeid = T1.fcmpschemeid and TRep.fcmpperiodid = T1.fcmpperiodid");
            sql.append(" and TRep.fpersonid=T1.fpersonid and TRep.fcmpitemid=T1.fcmpitemid and TRep.ftime=T1.ftime");
            sql.append(" order by T1.fcmpschemeid,T1.fcmpperiodid,T1.fpersonid,T1.fcmpitemid,ftime");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.size() > 0) {
                mapPeriodEndInput.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"61_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                mapPeriodEndInput.put("errorData", (String)rs);
                return mapPeriodEndInput;
            }
            sql = new StringBuffer();
            sql.append(" CREATE UNIQUE INDEX UX_HR_PEndInput ON T_HR_PeriodEndInput(FCmpSchemeID,FCmpPeriodId,FPersonID,FCmpItemId,Ftime)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return null;
    }

    private HashMap auditTryPeriodEndInput(Context ctx) throws BOSException {
        if (!HRCmpIndexUtils.isExistSameIndex(ctx, "UX_HR_TryPEndInput")) {
            HashMap<String, String> mapPeriodEndInput = new HashMap<String, String>();
            StringBuffer sql = new StringBuffer();
            String l = HRUtils.getShortCode(ctx);
            sql.append("select T1.Fid as FID,T1.fcmpSchemeid,T2.fname_" + l + " as schemeName,T1.fcmpperiodid,T3.fname_" + l + " as periodName,");
            sql.append(" t1.fpersonid,T4.fnumber,t1.fcmpitemid,T5.fname_" + l + " as itemName,T1.fvalue");
            sql.append(" from t_hr_tryPeriodEndInput T1");
            sql.append(" inner join t_hr_cmpscheme T2 on T2.fid = T1.Fcmpschemeid");
            sql.append(" inner join t_hr_cmpperiod T3 on T3.fid = T1.fcmpperiodid");
            sql.append(" inner join t_bd_person T4 on T4.fid = T1.fpersonid");
            sql.append(" inner join T_hr_cmpitem T5 on T5.fid = T1.fcmpItemId");
            sql.append(" inner join (");
            sql.append(" select fcmpschemeid,fcmpperiodid,fpersonid,fcmpitemid from t_hr_tryPeriodEndInput");
            sql.append(" group by fcmpschemeid,fcmpperiodid,fpersonid,fcmpitemid having count(*) > 1");
            sql.append(" ) TRep on TRep.fcmpschemeid = T1.fcmpschemeid and TRep.fcmpperiodid = T1.fcmpperiodid");
            sql.append(" and TRep.fpersonid=T1.fpersonid and TRep.fcmpitemid=T1.fcmpitemid");
            sql.append(" order by T1.fcmpschemeid,T1.fcmpperiodid,T1.fpersonid,T1.fcmpitemid");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.size() > 0) {
                mapPeriodEndInput.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"62_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                mapPeriodEndInput.put("errorData", (String)rs);
                return mapPeriodEndInput;
            }
            sql = new StringBuffer();
            sql.append(" CREATE UNIQUE INDEX UX_HR_TryPEndInput ON T_HR_TryPeriodEndInput(FCmpSchemeID,FAdjustSchemeID,FCmpPeriodId,FPersonID,FCmpItemId)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return null;
    }

    private void auditAllFixedHorTable(Context ctx, HashMap rtnMap) throws BOSException {
        String fixedSchemeID = null;
        String language = ctx.getLocale().getLanguage();
        String sqlFxiedScheme = "select T2.fname_" + language + ",T2.fid,T1.FHorTableName from T_HR_FixedCmpScheme T1 inner join t_org_hro T2 on T1.FHROrgUnitID=T2.fid";
        IRowSet rsFixedScheme = DbUtil.executeQuery((Context)ctx, (String)sqlFxiedScheme);
        try {
            while (rsFixedScheme.next()) {
                String strHorTableName = rsFixedScheme.getString("FHorTableName");
                HashMap mapHorTable = this.auditOneFixedHorTable(ctx, strHorTableName, fixedSchemeID = rsFixedScheme.getString("fid"), rsFixedScheme.getString("fname_" + language));
                if (mapHorTable == null) continue;
                rtnMap.put(strHorTableName, mapHorTable);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rsFixedScheme);
        }
    }

    private HashMap auditOneFixedHorTable(Context ctx, String curFixedHorTablename, String fixedSchemeName, String strFixedSchemeHROrgName) throws BOSException {
        if (curFixedHorTablename == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select T2.fnumber as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"52_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T1.fotherenabledate,T1.*");
        sql.append(" from " + curFixedHorTablename + " T1");
        sql.append(" inner join t_bd_person T2 on T2.fid = T1.fpersonid");
        sql.append(" inner join (select fpersonid from " + curFixedHorTablename + " group by fpersonid having count(*) > 1");
        sql.append(" ) T11 on T11.fpersonid = T1.fpersonid");
        sql.append(" order by T1.fpersonid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() > 0) {
            HashMap<String, String> mapHorTable = new HashMap<String, String>();
            if (strFixedSchemeHROrgName == null) {
                mapHorTable.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"63_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + curFixedHorTablename + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"64_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            } else {
                mapHorTable.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"65_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + strFixedSchemeHROrgName + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"66_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + fixedSchemeName + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"67_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()) + curFixedHorTablename + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"64_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            }
            mapHorTable.put("errorData", (String)rs);
            return mapHorTable;
        }
        return null;
    }

    private void auditAllHorTable(Context ctx, HashMap rtnMap) throws BOSException {
        ResultSet rs = null;
        String language = ctx.getLocale().getLanguage();
        String sqlScheme = "select fid,fnumber,fname_" + language + ",fhortableName,fhistableName from t_hr_cmpscheme where fisdelete = 0";
        IRowSet rsScheme = DbUtil.executeQuery((Context)ctx, (String)sqlScheme);
        try {
            while (rsScheme.next()) {
                String strHorTableName = rsScheme.getString("fhortableName");
                HashMap mapHorTable = this.auditOneHorTable(ctx, strHorTableName, rsScheme.getString("fname_" + language));
                if (mapHorTable == null) continue;
                rtnMap.put(strHorTableName, mapHorTable);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rsScheme);
            SQLUtils.cleanup(rs);
        }
    }

    private HashMap auditOneHorTable(Context ctx, String curHorTablename, String strSchemeName) throws BOSException {
        if (curHorTablename == null) {
            return null;
        }
        if (!HRCmpIndexUtils.isExistSameIndex(ctx, HRCmpIndexUtils.getDynamicTableUniqueIndexName(curHorTablename, "M"))) {
            String language = ctx.getLocale().getLanguage();
            StringBuffer sql = new StringBuffer();
            sql.append("select T2.fnumber as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"52_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T3.fname_").append(language).append(" as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"58_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T4.fname_").append(language).append(" as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"59_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T1.*");
            sql.append(" from " + curHorTablename + " T1");
            sql.append(" inner join t_bd_person T2 on T2.fid = T1.fpersonid");
            sql.append(" inner join t_org_admin T3 on T3.fid = T1.FAdminOrgUnitID");
            sql.append(" inner join t_org_position T4 on T4.fid = T1.FPositionId");
            sql.append(" inner join (select fpersonid from " + curHorTablename + " group by fpersonid having count(*) > 1");
            sql.append(" ) T11 on T11.fpersonid = T1.fpersonid");
            sql.append(" order by T1.fpersonid");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.size() > 0) {
                HashMap<String, String> mapHorTable = new HashMap<String, String>();
                if (strSchemeName == null) {
                    mapHorTable.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"68_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + curHorTablename + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"64_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                } else {
                    mapHorTable.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"69_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + strSchemeName + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"68_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + curHorTablename + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"64_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                }
                mapHorTable.put("errorData", (String)rs);
                return mapHorTable;
            }
            sql = new StringBuffer();
            sql.append(" CREATE UNIQUE INDEX " + HRCmpIndexUtils.getDynamicTableUniqueIndexName(curHorTablename, "M") + " ON " + curHorTablename + "(FPersonID)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return null;
    }

    private void auditAllHisTable(Context ctx, HashMap rtnMap) throws BOSException {
        ResultSet rs = null;
        String language = ctx.getLocale().getLanguage();
        String sqlScheme = "select fid,fnumber,fname_" + language + ",fhortableName,fhistableName from t_hr_cmpscheme where fisdelete = 0";
        IRowSet rsScheme = DbUtil.executeQuery((Context)ctx, (String)sqlScheme);
        try {
            while (rsScheme.next()) {
                String strHisTableName = rsScheme.getString("fhistableName");
                HashMap mapHisTable = this.auditOneHisTable(ctx, strHisTableName, rsScheme.getString("fname_" + language));
                if (mapHisTable == null) continue;
                rtnMap.put(strHisTableName, mapHisTable);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rsScheme);
            SQLUtils.cleanup(rs);
        }
    }

    private HashMap auditOneHisTable(Context ctx, String curHisTableName, String strSchemeName) throws BOSException {
        if (curHisTableName == null) {
            return null;
        }
        if (!HRCmpIndexUtils.isExistSameIndex(ctx, HRCmpIndexUtils.getDynamicTableUniqueIndexName(curHisTableName, "M"))) {
            StringBuffer sql = this.pingHisTableAuditSql(curHisTableName, ctx);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.size() > 0) {
                HashMap<String, String> mapHisTable = new HashMap<String, String>();
                if (strSchemeName == null) {
                    mapHisTable.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"70_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + curHisTableName + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"64_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                } else {
                    mapHisTable.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"69_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + strSchemeName + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"70_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + curHisTableName + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"64_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                }
                mapHisTable.put("errorData", (String)rs);
                return mapHisTable;
            }
            sql = new StringBuffer();
            sql.append(" CREATE UNIQUE INDEX " + HRCmpIndexUtils.getDynamicTableUniqueIndexName(curHisTableName, "M") + " ON " + curHisTableName + "(FPeriod,FPersonID,ftime)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return null;
    }

    private StringBuffer pingHisTableAuditSql(String strHisTableName, Context ctx) {
        String language = ctx.getLocale().getLanguage();
        String l = HRUtils.getShortCode(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select T3.fname_").append(language).append(" as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"71_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T1.ftime as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"72_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T2.fnumber as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"52_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T4.fname_" + l + " as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"58_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T5.fname_l2 as ").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"59_HRCmpDataAuditFacadeControllerBean", (Locale)ctx.getOriginLocale())).append(",T1.*");
        sql.append(" from " + strHisTableName + " T1");
        sql.append(" inner join t_bd_person T2 on T2.fid = T1.fpersonid");
        sql.append(" inner join t_hr_cmpperiod T3 on T3.fid = T1.fperiod");
        sql.append(" inner join t_org_admin T4 on T4.fid = T1.FAdminOrgUnitID");
        sql.append(" inner join t_org_position T5 on T5.fid = T1.FPositionId");
        sql.append(" inner join (");
        sql.append(" select fperiod,fpersonid,ftime from " + strHisTableName + " group by fperiod,fpersonid,ftime having count(*) > 1");
        sql.append(" ) T22 on T22.fperiod = T1.fperiod and T22.fpersonid=T1.fpersonid and T22.ftime=T1.ftime ");
        sql.append(" order by T1.fperiod,T1.fpersonid,ftime");
        return sql;
    }

    @Override
    protected void _preserveCmpData(Context ctx, String tableType, String condition) throws BOSException, EASBizException {
        if (tableType == null) {
            return;
        }
        if (tableType.equals("schemePerson")) {
            StringBuffer sql = new StringBuffer();
            sql.append("delete from t_hr_cmpschemeperson where fid in ");
            sql.append(" (select T1.fid from t_hr_cmpschemeperson T1");
            sql.append(" inner join (");
            sql.append("     select distinct fcmpschemeid,fpersonid from t_hr_cmpschemeperson ");
            sql.append("     where " + condition);
            sql.append(" ) T11 on T11.fcmpschemeid=T1.fcmpschemeid and T11.fpersonid=T1.fpersonid");
            sql.append(" where not exists (select fid from t_hr_cmpschemeperson where T1.fid = fid and " + condition + ")");
            sql.append(" )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else if (tableType.equals("periodEndInput")) {
            StringBuffer sql = new StringBuffer();
            sql.append(" delete from t_hr_periodEndInput where fid in ");
            sql.append(" (select T1.fid from t_hr_periodEndInput T1");
            sql.append(" inner join (");
            sql.append(" select distinct fcmpschemeid,fcmpperiodid,fpersonid,fcmpitemid,ftime from t_hr_periodEndInput");
            sql.append(" where " + condition);
            sql.append(" ) TRep on TRep.fcmpschemeid = T1.fcmpschemeid and TRep.fcmpperiodid = T1.fcmpperiodid");
            sql.append(" and TRep.fpersonid=T1.fpersonid and TRep.fcmpitemid=T1.fcmpitemid");
            sql.append(" where not exists (select fid from t_hr_periodEndInput where fid = T1.fid and " + condition + ")");
            sql.append(" )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else if (tableType.equals("fixedSchemePerson")) {
            StringBuffer sql = new StringBuffer();
            sql.append("delete from T_HR_FixedCmpSchemePerson where fid in ");
            sql.append(" (select T1.fid from T_HR_FixedCmpSchemePerson T1");
            sql.append(" inner join (");
            sql.append("     select distinct FFixedCmpSchemeID,fpersonid from T_HR_FixedCmpSchemePerson ");
            sql.append("     where " + condition);
            sql.append(" ) T11 on T11.FFixedCmpSchemeID=T1.FFixedCmpSchemeID and T11.fpersonid=T1.fpersonid");
            sql.append(" where not exists (select fid from T_HR_FixedCmpSchemePerson where T1.fid = fid and " + condition + ")");
            sql.append(" )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }
}

