/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.tools.datatask.task.util.IAccountingDataInterface;
import com.kingdee.eas.tools.datatask.task.util.XMLGenerator;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class HRXMLGenerator
extends XMLGenerator
implements IAccountingDataInterface {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.HRXMLGenerator");
    private Locale local;
    private List hrOrgUnitList;
    private String HRXMLResourse = "com.kingdee.eas.hr.compensation.HRXMLGeneratorResource.";
    private Map cmpPeriodMap;
    private List personData = null;
    private String hrOrgUnitIDs;

    public Document generateXML(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) {
        this.local = ctx.getLocale();
        String type = this.getTypeName(ctx);
        Element root = this.initHeadAndFileName(ctx, companyInfo, type);
        this.personData = new ArrayList();
        this.hrOrgUnitList = this.getHROrgUnitByCompany(ctx, companyInfo);
        this.cmpPeriodMap = this.getCmpPeriodInfo(ctx, periodInfo);
        this.hrOrgUnitIDs = this.hrOrgUnitMerge(this.hrOrgUnitList);
        Document document = null;
        if (this.hrOrgUnitIDs == null) {
            return document;
        }
        this.generateCmpPeriodInfo(ctx, root);
        this.generateCmpItemInfo(ctx, root);
        this.generateCmpSchemeDataInfo(ctx, root);
        return document;
    }

    public String getTypeName(Context ctx) {
        return ResourceBase.getString((String)(this.HRXMLResourse + "PERSON_CMP"), (Locale)this.local);
    }

    public List getHROrgUnitByCompany(Context ctx, CompanyOrgUnitInfo companyInfo) {
        if (companyInfo == null || companyInfo.getId() == null) {
            return null;
        }
        StringBuffer sqlGetHROrgUnit = new StringBuffer("select distinct FFromUnitID ");
        sqlGetHROrgUnit.append(" from T_ORG_UnitRelation ");
        sqlGetHROrgUnit.append(" where FToUnitID='" + companyInfo.getId().toString() + "' ");
        sqlGetHROrgUnit.append("and FTypeRelationID = '00000000-0000-0000-0000-0000000000130FE9F8B5' ");
        IRowSet rowSet = null;
        ArrayList<String> hrOrgUnitList = new ArrayList<String>();
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlGetHROrgUnit.toString());
            while (rowSet.next()) {
                hrOrgUnitList.add(rowSet.getString("FFromUnitID"));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        return hrOrgUnitList;
    }

    public Map getCmpPeriodInfo(Context ctx, PeriodInfo periodInfo) {
        if (periodInfo == null || periodInfo.getId() == null) {
            return null;
        }
        StringBuffer sqlGetCmpPeriod = new StringBuffer("select FID,Fhrorgunitid,FName_").append(this.local);
        sqlGetCmpPeriod.append(" from T_HR_CMPPERIOD ");
        sqlGetCmpPeriod.append(" where FFiscalPeriod='" + periodInfo.getId().toString() + "'");
        IRowSet rowSet = null;
        HashMap<String, Object> cmpPeriodMap = new HashMap<String, Object>();
        cmpPeriodMap.put("periodInfo", periodInfo);
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlGetCmpPeriod.toString());
            String hrOrgUnitID = null;
            while (rowSet.next()) {
                hrOrgUnitID = rowSet.getString("Fhrorgunitid");
                CmpPeriodInfo cmpPeriodInfo = new CmpPeriodInfo();
                cmpPeriodInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                cmpPeriodInfo.setName(rowSet.getString("FName_" + this.local));
                cmpPeriodMap.put(hrOrgUnitID, cmpPeriodInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        return cmpPeriodMap;
    }

    protected void generateCmpItemInfo(Context ctx, Element root) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select distinct t1.fhrorgunitid,t.FSortOrder,t1.fnumber as Snumber,t1.fname_").append(this.local).append(" as fname,t2.fnumber,t2.fname_").append(this.local);
        sqlBuffer.append(" from t_hr_cmpSchemeItem t ");
        sqlBuffer.append(" inner join t_hr_cmpScheme t1 on t.fcmpschemeid = t1.fid ");
        sqlBuffer.append(" inner join t_hr_cmpItem t2 on t.fcmpItemid = t2.fid ");
        sqlBuffer.append(" where t1.fhrorgunitid in ('").append(this.hrOrgUnitIDs).append("')");
        sqlBuffer.append(" and (t2.FNumber like '%FSAL%' or t2.FNumber like '%FWEL%') ");
        sqlBuffer.append(" and t2.fdataType =60 and t1.FIsTryScheme = 0 and t1.FEnable = 1");
        sqlBuffer.append(" order by t1.fhrorgunitid,t1.fnumber,t.FSortOrder");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            while (rowset.next()) {
                String schemeName = rowset.getString("fname");
                String itemNumber = rowset.getString("fnumber");
                String itemName = rowset.getString("fname_" + this.local);
                Element itemRoot = root.addElement(ResourceBase.getString((String)(this.HRXMLResourse + "CMP_ITEM"), (Locale)this.local));
                this.addStringElement(itemRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_SCHEME_NAME"), (Locale)this.local), schemeName, 60, false);
                this.addStringElement(itemRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_ITEM_NUMBER"), (Locale)this.local), itemNumber, 60, false);
                this.addStringElement(itemRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_ITEM_NAME"), (Locale)this.local), itemName, 60, false);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
    }

    protected void generateCmpPeriodInfo(Context ctx, Element root) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select FCmpPeriodYear,FCmpPeriod,FBeginDate,FEndDate ");
        sqlBuffer.append(" from T_HR_CmpPeriod ");
        sqlBuffer.append(" where FHROrgUnitID in('" + this.hrOrgUnitIDs + "')");
        sqlBuffer.append(" order by FHROrgUnitID,FBeginDate ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            while (rowSet.next()) {
                String cmpPeriodYear = rowSet.getString("FCmpPeriodYear");
                String cmpPeriod = rowSet.getString("FCmpPeriod");
                Date beginDate = rowSet.getDate("FBeginDate");
                Date endDate = rowSet.getDate("FEndDate");
                Element periodRoot = root.addElement(ResourceBase.getString((String)(this.HRXMLResourse + "CMP_PERIOD"), (Locale)this.local));
                if (cmpPeriodYear == null || "0".equals(cmpPeriodYear)) {
                    this.addStringElement(periodRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_YEAR"), (Locale)this.local), null, 4, true);
                } else {
                    this.addStringElement(periodRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_YEAR"), (Locale)this.local), cmpPeriodYear, 4, true);
                }
                if (cmpPeriod == null || "0".equals(cmpPeriod)) {
                    this.addStringElement(periodRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_PERIOD_NUM"), (Locale)this.local), null, 2, false);
                } else {
                    this.addStringElement(periodRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_PERIOD_NUM"), (Locale)this.local), cmpPeriod, 2, false);
                }
                this.addDateElement(periodRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_PERIOD_BEGIN"), (Locale)this.local), beginDate);
                this.addDateElement(periodRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_PERIOD_END"), (Locale)this.local), endDate);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
    }

    protected void generateCmpSchemePersonInfo(Context ctx, Element root) {
        if (this.personData == null || this.personData.size() == 0) {
            return;
        }
        int size = this.personData.size();
        Object cmpSchemeId = null;
        Object rowSetHis = null;
        SchemePersonInfo personInfo = null;
        for (int i = 0; i < size; ++i) {
            personInfo = (SchemePersonInfo)this.personData.get(i);
            if (personInfo == null) continue;
            Element cmpRoot = root.addElement(ResourceBase.getString((String)(this.HRXMLResourse + "PERSON_CMP_RECORD"), (Locale)this.local));
            this.addStringElement(cmpRoot, ResourceBase.getString((String)(this.HRXMLResourse + "PERSON_NUMBER"), (Locale)this.local), personInfo.getNumber(), 60, false);
            this.addStringElement(cmpRoot, ResourceBase.getString((String)(this.HRXMLResourse + "PERSON_TYPE"), (Locale)this.local), personInfo.getPersonType(), 60, false);
            this.addStringElement(cmpRoot, ResourceBase.getString((String)(this.HRXMLResourse + "ADMIN_NUMBER"), (Locale)this.local), personInfo.getAdminNumber(), 60, false);
            this.addStringElement(cmpRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_SCHEME_NAME"), (Locale)this.local), personInfo.getSchemeName(), 60, false);
            this.addStringElement(cmpRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_YEAR"), (Locale)this.local), personInfo.getYear(), 4, true);
            this.addStringElement(cmpRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_PERIOD_NUM"), (Locale)this.local), personInfo.getMonth(), 2, false);
            this.addStringElement(cmpRoot, ResourceBase.getString((String)(this.HRXMLResourse + "FISCAL_PERIOD_YEAR"), (Locale)this.local), personInfo.getFiscalPeriodYear(), 4, true);
            this.addStringElement(cmpRoot, ResourceBase.getString((String)(this.HRXMLResourse + "FISCAL_PERIOD_NUMBER"), (Locale)this.local), personInfo.getFiscalPeriodNumber(), 15, false);
            this.addStringElement(cmpRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CURRENCY_TYPE"), (Locale)this.local), personInfo.getCurrency(), 10, false);
        }
    }

    protected void generateCmpSchemeDataInfo(Context ctx, Element root) {
        if (this.cmpPeriodMap == null || this.cmpPeriodMap.size() <= 0) {
            return;
        }
        StringBuffer sqlSchemeBuffer = new StringBuffer();
        sqlSchemeBuffer.append(" select t.FID,t.fnumber,t.FName_").append(this.local).append(",t.FHisTableName,t.FHROrgUnitID,t1.FNumber ");
        sqlSchemeBuffer.append(" from T_HR_CMPSCHEME t ");
        sqlSchemeBuffer.append(" inner join T_BD_Currency t1 on t.FCurrencyID = t1.FID ");
        sqlSchemeBuffer.append(" WHERE FHisTableName is not null and FEnable = 1 and FIsTryScheme = 0 ");
        sqlSchemeBuffer.append(" and FHROrgUnitID in ('" + this.hrOrgUnitIDs + "')");
        sqlSchemeBuffer.append(" order by FHROrgUnitID,t.fnumber ");
        ArrayList recordCmpDetail = new ArrayList();
        DecimalFormat dataFormat = new DecimalFormat("#0.00");
        try {
            String hrOrgunitID = null;
            CmpPeriodInfo periodInfo = null;
            IRowSet schemeRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSchemeBuffer.toString());
            SchemePersonInfo personInfo = null;
            PeriodInfo period = (PeriodInfo)this.cmpPeriodMap.get("periodInfo");
            while (schemeRowSet.next()) {
                hrOrgunitID = schemeRowSet.getString("FHROrgUnitID");
                periodInfo = (CmpPeriodInfo)this.cmpPeriodMap.get(hrOrgunitID);
                if (periodInfo == null || periodInfo.getId() == null) continue;
                StringBuffer sqlItemBuffer = new StringBuffer(" select t1.FNumber,t.FSortOrder ");
                sqlItemBuffer.append(" from T_HR_CMPSCHEMEITEM t ");
                sqlItemBuffer.append(" inner join T_HR_CMPITEM t1 on t.FCmpItemID = t1.FID ");
                sqlItemBuffer.append(" where FCmpSchemeID = '" + schemeRowSet.getString("FID") + "' ");
                sqlItemBuffer.append(" and t1.FDataType = 60 ");
                sqlItemBuffer.append(" and (t1.FNumber like '%FSAL%' or t1.FNumber like '%FWEL%')  order by t.FSortOrder ");
                IRowSet itemRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlItemBuffer.toString());
                StringBuffer itemString = new StringBuffer();
                StringBuffer itemStringTwo = new StringBuffer();
                while (itemRowSet.next()) {
                    itemString.append(",sum(" + itemRowSet.getString("FNumber") + ") as " + itemRowSet.getString("FNumber"));
                    itemStringTwo.append("," + itemRowSet.getString("FNumber"));
                }
                StringBuffer sqlDataHis = new StringBuffer(" select t.FPeriod,t1.FNumber,t2.FCmpPeriodYear,t2.FCmpPeriod,t3.FNumber as AdminNumber,t6.FName_").append(this.local).append(itemStringTwo);
                sqlDataHis.append(" from (select FPersonID,FPeriod,FAdminOrgUnitID").append(itemString);
                sqlDataHis.append(" from " + schemeRowSet.getString("FHisTableName") + " where FPeriod='").append(periodInfo.getId()).append("' ");
                sqlDataHis.append(" group by FPersonID,FPeriod,FAdminOrgUnitID) t ");
                sqlDataHis.append(" inner join T_BD_PERSON t1 on t.FPersonID = t1.FID ");
                sqlDataHis.append(" inner join T_HR_CMPPERIOD t2 on t.FPeriod = t2.FID ");
                sqlDataHis.append(" inner join T_ORG_Admin t3 on t.FAdminOrgUnitID = t3.FID ");
                sqlDataHis.append(" inner join T_HR_BDEmployeeType t5 on t1.FEmployeeTypeID = t5.FID ");
                sqlDataHis.append(" inner join T_HR_EmployeeFenLei t6 on t5.FEmployeeFenLeiID = t6.FID ");
                sqlDataHis.append(" where FPeriod = '").append(periodInfo.getId()).append("' ");
                sqlDataHis.append(" order by t1.FNumber ");
                IRowSet dataHisRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlDataHis.toString());
                while (dataHisRowSet.next()) {
                    personInfo = new SchemePersonInfo();
                    personInfo.setNumber(dataHisRowSet.getString("FNumber"));
                    personInfo.setPersonType(dataHisRowSet.getString("FName_" + this.local));
                    personInfo.setAdminNumber(dataHisRowSet.getString("AdminNumber"));
                    personInfo.setSchemeName(schemeRowSet.getString("FName_" + this.local));
                    if (dataHisRowSet.getString("FCmpPeriodYear") != null && !"0".equals(dataHisRowSet.getString("FCmpPeriodYear"))) {
                        personInfo.setYear(dataHisRowSet.getString("FCmpPeriodYear"));
                    }
                    if (dataHisRowSet.getString("FCmpPeriod") != null && !"0".equals(dataHisRowSet.getString("FCmpPeriod"))) {
                        personInfo.setMonth(dataHisRowSet.getString("FCmpPeriod"));
                    }
                    personInfo.setFiscalPeriodNumber(period.getPeriodNumber() + "");
                    personInfo.setFiscalPeriodYear(period.getPeriodYear() + "");
                    personInfo.setCurrency(schemeRowSet.getString("FNumber"));
                    this.personData.add(personInfo);
                    itemRowSet.beforeFirst();
                    while (itemRowSet.next()) {
                        ArrayList<Object> personCmpDetail = new ArrayList<Object>();
                        personCmpDetail.add(0, dataHisRowSet.getString("FNumber"));
                        personCmpDetail.add(1, schemeRowSet.getString("FName_" + this.local));
                        personCmpDetail.add(2, dataHisRowSet.getString("FCmpPeriodYear"));
                        personCmpDetail.add(3, dataHisRowSet.getString("FCmpPeriod"));
                        personCmpDetail.add(4, itemRowSet.getString("FNumber"));
                        personCmpDetail.add(5, dataHisRowSet.getBigDecimal(itemRowSet.getString("FNumber")));
                        recordCmpDetail.add(personCmpDetail);
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        this.generateCmpSchemePersonInfo(ctx, root);
        int size = recordCmpDetail.size();
        for (int i = 0; i < size; ++i) {
            ArrayList personCmpDetail = (ArrayList)recordCmpDetail.get(i);
            if (personCmpDetail == null || personCmpDetail.size() == 0) continue;
            Element cmpDataRoot = root.addElement(ResourceBase.getString((String)(this.HRXMLResourse + "PERSON_CMP_REC_DETAIL"), (Locale)this.local));
            this.addStringElement(cmpDataRoot, ResourceBase.getString((String)(this.HRXMLResourse + "PERSON_NUMBER"), (Locale)this.local), personCmpDetail.get(0).toString(), 60, false);
            this.addStringElement(cmpDataRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_SCHEME_NAME"), (Locale)this.local), personCmpDetail.get(1).toString(), 60, false);
            if (personCmpDetail.get(2) == null || "0".equals(personCmpDetail.get(2).toString())) {
                this.addStringElement(cmpDataRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_YEAR"), (Locale)this.local), null, 4, true);
            } else {
                this.addStringElement(cmpDataRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_YEAR"), (Locale)this.local), personCmpDetail.get(2).toString(), 4, true);
            }
            if (personCmpDetail.get(3) == null || "0".equals(personCmpDetail.get(3).toString())) {
                this.addStringElement(cmpDataRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_PERIOD_NUM"), (Locale)this.local), null, 2, false);
            } else {
                this.addStringElement(cmpDataRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_PERIOD_NUM"), (Locale)this.local), personCmpDetail.get(3).toString(), 2, false);
            }
            this.addStringElement(cmpDataRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_ITEM_NUMBER"), (Locale)this.local), personCmpDetail.get(4).toString(), 60, false);
            BigDecimal decimal = (BigDecimal)personCmpDetail.get(5);
            if (decimal == null) {
                this.addNumberElement(cmpDataRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_SUM"), (Locale)this.local), null);
                continue;
            }
            String data = dataFormat.format(decimal);
            if (data.length() > 20) {
                this.addNumberElement(cmpDataRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_SUM"), (Locale)this.local), data.substring(data.length() - 20));
                continue;
            }
            this.addNumberElement(cmpDataRoot, ResourceBase.getString((String)(this.HRXMLResourse + "CMP_SUM"), (Locale)this.local), data);
        }
    }

    protected String hrOrgUnitMerge(List hrOrgUnitList) {
        StringBuffer hrOrgUnitIDs = null;
        if (hrOrgUnitList == null || hrOrgUnitList.size() <= 0) {
            return null;
        }
        hrOrgUnitIDs = new StringBuffer(hrOrgUnitList.get(0).toString());
        int size = hrOrgUnitList.size();
        for (int i = 1; i < size; ++i) {
            hrOrgUnitIDs.append("','" + hrOrgUnitList.get(i));
        }
        return hrOrgUnitIDs.toString();
    }

    public File generate(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        return null;
    }

    static class SchemePersonInfo {
        String schemeName = null;
        String number = null;
        String personType = null;
        String AdminNumber = null;
        String periodNumber = null;
        String year = null;
        String month = null;
        String currency = null;
        String fiscalPeriodNumber;
        String fiscalPeriodYear;

        SchemePersonInfo() {
        }

        public String getSchemeName() {
            return this.schemeName;
        }

        public void setSchemeName(String schemeName) {
            this.schemeName = schemeName;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getAdminNumber() {
            return this.AdminNumber;
        }

        public void setAdminNumber(String adminNumber) {
            this.AdminNumber = adminNumber;
        }

        public String getPeriodNumber() {
            return this.periodNumber;
        }

        public void setPeriodNumber(String periodNumber) {
            this.periodNumber = periodNumber;
        }

        public String getYear() {
            return this.year;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public String getMonth() {
            return this.month;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public String getFiscalPeriodYear() {
            return this.fiscalPeriodYear;
        }

        public void setFiscalPeriodYear(String fiscalPeriodYear) {
            this.fiscalPeriodYear = fiscalPeriodYear;
        }

        public String getFiscalPeriodNumber() {
            return this.fiscalPeriodNumber;
        }

        public void setFiscalPeriodNumber(String fiscalPeriodNumber) {
            this.fiscalPeriodNumber = fiscalPeriodNumber;
        }

        public String getPersonType() {
            return this.personType;
        }

        public void setPersonType(String personType) {
            this.personType = personType;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }
    }
}

