/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.FillFillException;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.PeriodEndInputException;
import com.kingdee.eas.hr.compensation.SchemeAuditedEnum;
import com.kingdee.eas.hr.compensation.app.AbstractPEndInStatusControllerBean;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PEndInStatusControllerBean
extends AbstractPEndInStatusControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.PEndInStatusControllerBean");

    @Override
    protected void _updatePeriodEndInputAuditData(Context ctx) throws BOSException, EASBizException {
        IRowSet rows = null;
        boolean updateState = this.checkPeriodUpdate(ctx);
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement psAdd = null;
        try {
            if (!updateState) {
                ArrayList schemeInfoList = new ArrayList();
                sql.append("select Fid,FCmpSchemeId,FCmpPerioidId,fTime from T_HR_PEndInputState where FCheckState=1");
                rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rows.next()) {
                    HashMap<String, String> dataMap = new HashMap<String, String>();
                    schemeInfoList.add(dataMap);
                    dataMap.put("FCmpSchemeID", rows.getString("FCmpSchemeId"));
                    dataMap.put("FCmpPeriodID", rows.getString("FCmpPerioidId"));
                    dataMap.put("fTime", rows.getString("fTime"));
                }
                int psAddCount = 0;
                conn = EJBFactory.getConnection((Context)ctx);
                StringBuffer updateSql = new StringBuffer();
                updateSql.append("insert into T_HR_PEndInStatus(FCmpSchemeID,FCmpPeriodID,FPersonID,fTime)").append(" select distinct FCmpSchemeID, FCmpPeriodID, FPersonID,fTime from T_HR_PeriodEndInput ").append(" where FCmpSchemeID=? and FCmpPeriodID=? and fTime=?");
                psAdd = conn.prepareStatement(updateSql.toString());
                int size = schemeInfoList.size();
                for (int i = 0; i < size; ++i) {
                    Map dataMap = (Map)schemeInfoList.get(i);
                    psAdd.setString(1, (String)dataMap.get("FCmpSchemeID"));
                    psAdd.setString(2, (String)dataMap.get("FCmpPeriodID"));
                    psAdd.setInt(3, Integer.parseInt((String)dataMap.get("fTime")));
                    psAdd.addBatch();
                    if (++psAddCount != 1000) continue;
                    psAddCount = 0;
                    psAdd.executeBatch();
                    psAdd.clearBatch();
                }
                if (psAddCount > 0) {
                    psAdd.executeBatch();
                }
                StringBuffer completeSql = new StringBuffer();
                completeSql.append("insert into T_HR_PEndInStatus(FCmpSchemeID,FCmpPeriodID,FPersonID,fTime)").append(" values('1','1','1',1)");
                DbUtil.execute((Context)ctx, (String)completeSql.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(psAdd, conn);
        }
    }

    @Override
    protected boolean _getEmpAuditState(Context ctx, String schemeId, String periodId, int time, List empIdList) throws BOSException, EASBizException {
        boolean auditState = true;
        StringBuffer countAuditSql = new StringBuffer();
        String personTable = null;
        if (empIdList == null || empIdList != null && empIdList.size() == 0) {
            countAuditSql.append("select count(*) as personCount from T_HR_PEndInStatus where").append(" FCmpSchemeID='").append(schemeId).append("'").append(" and FCmpPeriodID='").append(periodId).append("'").append(" and fTime=").append(time).append(" and fEmpAuditFlag=0");
        } else {
            String empIds = HRSchemeUtils.getStrFromList(empIdList);
            if (empIdList.size() > 100) {
                try {
                    personTable = this.getPersonIdTmpTable(ctx, empIdList);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                countAuditSql.append("select count(*) as personCount from T_HR_PEndInStatus where").append(" FCmpSchemeID='").append(schemeId).append("'").append(" and FCmpPeriodID='").append(periodId).append("'").append(" and fTime=").append(time).append(" and fEmpAuditFlag=0").append(" and FPersonID in ").append(" (select FPersonID from ").append(personTable).append(")");
            } else {
                countAuditSql.append("select count(*) as personCount from T_HR_PEndInStatus where").append(" FCmpSchemeID='").append(schemeId).append("'").append(" and FCmpPeriodID='").append(periodId).append("'").append(" and fTime=").append(time).append(" and fEmpAuditFlag=0").append(" and FPersonID in ").append(empIds);
            }
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)countAuditSql.toString());
        try {
            while (rows.next()) {
                int count = rows.getInt(1);
                if (count == 0) {
                    auditState = true;
                    continue;
                }
                auditState = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.realeasTmpTable(ctx, personTable);
        }
        return auditState;
    }

    @Override
    protected void _updateEmpAuditState(Context ctx, String cmpSchemeId, String periodId, int time, List empIdList, boolean state) throws BOSException, EASBizException {
        boolean updateState = this.checkPeriodUpdate(ctx);
        if (!updateState) {
            throw new PeriodEndInputException(PeriodEndInputException.PERIOD_UPDATE);
        }
        String empIds = HRSchemeUtils.getStrFromList(empIdList);
        if (state) {
            String personTable;
            block23: {
                String tableName = HRTableTools.getEndInputTableName(ctx, cmpSchemeId);
                StringBuffer auditSql = new StringBuffer();
                auditSql.append("SELECT fillfill.fid FROM").append(" T_HR_FillFill fillfill inner join ").append(tableName).append(" endInput").append(" on endInput.fid = fillfill.FPeriodEndInputID").append(" where endInput.FCmpSchemeID='").append(cmpSchemeId).append("' and endInput.FCmpPeriodID='").append(periodId).append("' and endInput.FSupply= 20 ").append(" and endInput.fTime=").append(time);
                personTable = null;
                if (empIdList != null && empIdList.size() > 0) {
                    if (empIdList.size() > 100) {
                        try {
                            personTable = this.getPersonIdTmpTable(ctx, empIdList);
                            auditSql.append(" and endInput.FPersonID in ").append(" (select FPersonID from ").append(personTable).append(")");
                        }
                        catch (Exception e) {
                            throw new BOSException((Throwable)e);
                        }
                    } else {
                        auditSql.append(" and endInput.FPersonID in ").append(empIds);
                    }
                }
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)auditSql.toString());
                try {
                    if (!rowSet.next()) break block23;
                    throw new FillFillException(FillFillException.DATA_NOT_AUDIT);
                }
                catch (SQLException e1) {
                    try {
                        throw new BOSException((Throwable)e1);
                    }
                    catch (Throwable throwable) {
                        this.realeasTmpTable(ctx, personTable);
                        throw throwable;
                    }
                }
            }
            this.realeasTmpTable(ctx, personTable);
        }
        StringBuffer delAuditSql = new StringBuffer();
        delAuditSql.append("delete from T_HR_PEndInStatus where ").append(" FCmpSchemeID='").append(cmpSchemeId).append("'").append(" and FCmpPeriodID='").append(periodId).append("'").append(" and fTime=").append(time).append(" and FPersonID in ").append(empIds);
        DbUtil.execute((Context)ctx, (String)delAuditSql.toString());
        Connection conn = null;
        PreparedStatement psAdd = null;
        String updateAuditSql = null;
        try {
            int psAddCount = 0;
            conn = EJBFactory.getConnection((Context)ctx);
            if (state) {
                updateAuditSql = "insert into T_HR_PEndInStatus(FCmpSchemeID,FCmpPeriodID,fTime,FPersonID,fEmpAuditFlag) values (?,?,?,?,?)";
                psAdd = conn.prepareStatement(updateAuditSql);
                if (empIdList != null) {
                    int size = empIdList.size();
                    for (int i = 0; i < size; ++i) {
                        psAdd.setString(1, cmpSchemeId);
                        psAdd.setString(2, periodId);
                        psAdd.setInt(3, time);
                        psAdd.setString(4, (String)empIdList.get(i));
                        psAdd.setInt(5, 1);
                        psAdd.addBatch();
                        if (++psAddCount != 1000) continue;
                        psAddCount = 0;
                        psAdd.executeBatch();
                        psAdd.clearBatch();
                    }
                }
                if (psAddCount > 0) {
                    psAdd.executeBatch();
                }
            } else {
                updateAuditSql = "insert into T_HR_PEndInStatus(FCmpSchemeID,FCmpPeriodID,fTime,FPersonID,fEmpAuditFlag) values (?,?,?,?,?)";
                psAdd = conn.prepareStatement(updateAuditSql.toString());
                if (empIdList != null) {
                    int size = empIdList.size();
                    for (int i = 0; i < size; ++i) {
                        psAdd.setString(1, cmpSchemeId);
                        psAdd.setString(2, periodId);
                        psAdd.setInt(3, time);
                        psAdd.setString(4, (String)empIdList.get(i));
                        psAdd.setInt(5, 0);
                        psAdd.addBatch();
                        if (++psAddCount != 1000) continue;
                        psAddCount = 0;
                        psAdd.executeBatch();
                        psAdd.clearBatch();
                    }
                }
                if (psAddCount > 0) {
                    psAdd.executeBatch();
                    psAdd.clearBatch();
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psAdd);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psAdd);
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    protected Map _getEmpAuditStateMap(Context ctx, String cmpSchemeId, String periodId, int time, List empIdList) throws BOSException {
        HashMap<String, String> personAuditMap = new HashMap<String, String>();
        StringBuffer auditSql = new StringBuffer();
        auditSql.append("SELECT person.fNumber,fEmpAuditFlag FROM").append(" T_HR_PEndInStatus eStatus inner join T_BD_PERSON person on eStatus.fPersonID=person.fid").append(" where FCmpSchemeID='").append(cmpSchemeId).append("' and FCmpPeriodID='").append(periodId).append("' and fTime=").append(time);
        String personTable = null;
        if (empIdList != null && empIdList.size() > 0) {
            if (empIdList.size() > 100) {
                try {
                    personTable = this.getPersonIdTmpTable(ctx, empIdList);
                    auditSql.append(" and FPersonID in ").append(" (select FPersonID from ").append(personTable).append(")");
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                String empIds = HRSchemeUtils.getStrFromList(empIdList);
                auditSql.append(" and FPersonID in ").append(empIds);
            }
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)auditSql.toString());
        try {
            while (rowSet.next()) {
                personAuditMap.put(rowSet.getString(1), rowSet.getString(2));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.realeasTmpTable(ctx, personTable);
                throw throwable;
            }
        }
        this.realeasTmpTable(ctx, personTable);
        return personAuditMap;
    }

    @Override
    protected Map _getEmpAuditStateMap(Context ctx, String cmpSchemeId, String periodId, int time, String personTable) throws BOSException {
        HashMap<String, String> personAuditMap = new HashMap<String, String>();
        StringBuffer auditSql = new StringBuffer();
        auditSql.append("SELECT eStatus.FPersonID,fEmpAuditFlag FROM").append(" T_HR_PEndInStatus eStatus ").append(" where FCmpSchemeID='").append(cmpSchemeId).append("' and FCmpPeriodID='").append(periodId).append("' and fTime=").append(time).append(" and FPersonID in ").append(" (select FPersonID from ").append(personTable).append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)auditSql.toString());
        try {
            while (rowSet.next()) {
                personAuditMap.put(rowSet.getString(1), rowSet.getString(2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return personAuditMap;
    }

    @Override
    protected Map _getEmpAuditDetailMap(Context ctx, Map parmMaps) throws BOSException, EASBizException {
        HashMap allDataMap = new HashMap();
        String cmpSchemeId = (String)parmMaps.get("cmpSchemeId");
        OrgUnitInfo orgUnit = (OrgUnitInfo)parmMaps.get("orgUnit");
        String periodId = (String)parmMaps.get("periodId");
        String time = (String)parmMaps.get("time");
        boolean isInclude = (Boolean)parmMaps.get("isInclude");
        boolean stateType = (Boolean)parmMaps.get("displayAudit");
        Boolean displayAllEmp = (Boolean)parmMaps.get("displayAllEmp");
        StringBuffer auditSql = new StringBuffer();
        String personIdTmpTable = null;
        String language = ctx.getLocale().getLanguage();
        try {
            personIdTmpTable = displayAllEmp == null ? this.getTemporaryTable(ctx, orgUnit, isInclude, cmpSchemeId) : HRSchemeUtils.getCmpSchemeHorTableName(ctx, cmpSchemeId);
            if (stateType) {
                auditSql.append("SELECT distinct person.FID,person.fnumber as personNumber,person.fName_").append(language).append(" as personName FROM ").append(personIdTmpTable).append(" perTmpTbl").append(" inner join T_BD_Person person on person.fid=perTmpTbl.FPersonID").append(" where perTmpTbl.FPersonID in (select FPersonID from T_HR_PEndInStatus data").append(" where data.FCmpSchemeID='").append(cmpSchemeId).append("'").append(" and data.FCmpPeriodID='").append(periodId).append("'").append(" and data.fTime=").append(time);
                auditSql.append(" and data.fEmpAuditFlag=1)");
            } else {
                auditSql.append("SELECT distinct person.FID,person.fnumber as personNumber,person.fName_").append(language).append(" as personName FROM ").append(personIdTmpTable).append(" perTmpTbl").append(" inner join T_BD_Person person on person.fid=perTmpTbl.FPersonID").append(" where perTmpTbl.FPersonID not in (select FPersonID from T_HR_PEndInStatus data").append(" where data.FCmpSchemeID='").append(cmpSchemeId).append("'").append(" and data.FCmpPeriodID='").append(periodId).append("'").append(" and data.fTime=").append(time);
                auditSql.append(" and data.fEmpAuditFlag=1)");
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)auditSql.toString());
            while (rowSet.next()) {
                HashMap<String, String> personDataMap = new HashMap<String, String>();
                personDataMap.put("personNumber", rowSet.getString(2));
                personDataMap.put("personName", rowSet.getString(3));
                allDataMap.put(rowSet.getString(1), personDataMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.realeasTmpTable(ctx, personIdTmpTable);
        }
        return allDataMap;
    }

    private boolean checkPeriodUpdate(Context ctx) throws BOSException {
        StringBuffer hasUpdateSql = new StringBuffer();
        hasUpdateSql.append("select * from T_HR_PEndInStatus where FCmpSchemeID='1' ").append(" and FCmpPeriodID='1' and FPersonID='1' and fTime=1");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)hasUpdateSql.toString());
        boolean updateState = false;
        try {
            updateState = rows.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return updateState;
    }

    private String getTemporaryTable(Context ctx, OrgUnitInfo infoAdmin, boolean isIncluding, String cmpSchemeId) throws SQLDataException, SQLException, BOSException {
        String hrSelectPersonTempTable = null;
        String sql = " create TABLE aa (FPersonid varchar(44) not null primary key) ";
        try {
            hrSelectPersonTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException();
        }
        StringBuffer sbInsert = new StringBuffer(" INSERT INTO ").append(hrSelectPersonTempTable).append(" SELECT distinct CMPSCHEMEPERSON.FPERSONID ").append(" FROM T_HR_CMPSCHEMEPERSON  CMPSCHEMEPERSON ").append(" LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSIT ON CMPSCHEMEPERSON.FPositionID = PERSONPOSIT.FID").append(" LEFT OUTER JOIN T_HR_PersonCmp  PERSONCMP ON CMPSCHEMEPERSON.FPERSONID = PERSONCMP.FPersonID ").append(" LEFT OUTER JOIN T_ORG_Admin  ATTACHDEPT ON CMPSCHEMEPERSON.FAdminOrgUnitID = ATTACHDEPT.FID").append(" LEFT OUTER JOIN T_PM_OrgRange  ATTACHORGRANGE ON ATTACHDEPT.FID = ATTACHORGRANGE.FOrgID").append(" LEFT OUTER JOIN T_PM_User  ATTACHPMUSER ON ATTACHORGRANGE.FUserID = ATTACHPMUSER.FID").append(" WHERE (PERSONCMP.FIsPayPerson = 1 ").append(" AND ATTACHORGRANGE.FType = 20 ").append(" AND ATTACHORGRANGE.FUserID = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' )");
        sbInsert.append(" AND CMPSCHEMEPERSON.FCMPSCHEMEID ='" + cmpSchemeId + "'  and CMPSCHEMEPERSON.FISDELETE = 0");
        sql = this.getReplaceQuerySQL(ctx, sbInsert.toString());
        if (infoAdmin != null) {
            sql = isIncluding ? sql + " AND (ATTACHDEPT.FLONGNUMBER like '" + infoAdmin.getLongNumber() + "!%'  or ATTACHDEPT.FLONGNUMBER = '" + infoAdmin.getLongNumber() + "') " : sql + " AND ATTACHDEPT.FLONGNUMBER ='" + infoAdmin.getLongNumber() + "' ";
        }
        DbUtil.execute((Context)ctx, (String)sql);
        return hrSelectPersonTempTable;
    }

    private String getReplaceQuerySQL(Context ctx, String sql) throws BOSException {
        sql = HRSchemeUtils.getReplaceQuerySQL(ctx, sql);
        sql = StringUtils.replace((String)sql, (String)"PERSON.FGender = '1'", (String)"PERSON.FGender = 1");
        sql = StringUtils.replace((String)sql, (String)"PERSON.FGender = '2'", (String)"PERSON.FGender = 2");
        sql = StringUtils.replace((String)sql, (String)"\"PERSON\".FGender = '1'", (String)"PERSON.FGender = 1");
        sql = StringUtils.replace((String)sql, (String)"\"PERSON\".FGender = '2'", (String)"PERSON.FGender = 2");
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPersonIdTmpTable(Context ctx, List empIdList) throws BOSException {
        String hrSelectPersonTempTable;
        block9: {
            hrSelectPersonTempTable = null;
            String sql = " create TABLE aa (FPersonid varchar(44) not null primary key) ";
            try {
                hrSelectPersonTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql);
            }
            catch (Exception e) {
                throw new BOSException();
            }
            int psAddCount = 0;
            Connection conn = null;
            PreparedStatement psAdd = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                StringBuffer insertSql = new StringBuffer();
                insertSql.append("insert into ").append(hrSelectPersonTempTable).append("(FPersonID)").append(" values (?)");
                psAdd = conn.prepareStatement(insertSql.toString());
                int size = empIdList.size();
                for (int i = 0; i < size; ++i) {
                    if (empIdList.get(i) == null) continue;
                    psAdd.setString(1, (String)empIdList.get(i));
                    psAdd.addBatch();
                    if (++psAddCount != 1000) continue;
                    psAddCount = 0;
                    psAdd.executeBatch();
                    psAdd.clearBatch();
                }
                if (psAddCount > 0) {
                    psAdd.executeBatch();
                    psAdd.clearBatch();
                }
                SQLUtils.cleanup((Statement)psAdd);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block9;
            }
            finally {
                SQLUtils.cleanup(psAdd);
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
        return hrSelectPersonTempTable;
    }

    private void realeasTmpTable(Context ctx, String tableName) throws BOSException {
        if (!StringUtils.isEmpty((String)tableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
        }
    }

    @Override
    protected Map _getEmpsAuditDetailMap(Context ctx, Map parmMaps) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        HashMap allDataMap = new HashMap();
        HashMap showMap = new HashMap();
        StringBuffer auditSql = new StringBuffer();
        String personIdTmpTable = null;
        String language = ctx.getLocale().getLanguage();
        ICmpScheme cmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        ICmpPeriod cmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
        Set set = parmMaps.keySet();
        String key2 = null;
        String[] keys = null;
        String cmpSchemeId = null;
        String periodId = null;
        String time = null;
        String person2 = null;
        Set personSet = null;
        for (String key2 : set) {
            HashMap<String, HashMap<String, String>> personMap;
            HashMap<String, String> personDataMap;
            PersonInfo personInfo;
            keys = key2.split("@@");
            cmpSchemeId = keys[0];
            periodId = keys[1];
            time = keys[2];
            personSet = (Set)parmMaps.get(key2);
            CmpSchemeInfo info = cmpScheme.getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(cmpSchemeId));
            CmpPeriodInfo curPeriodInfo = cmpPeriod.getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(info.getCmpPeriod().getId().toString()));
            CmpPeriodInfo periodInfo = cmpPeriod.getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
            if (curPeriodInfo.getBeginDate().after(periodInfo.getEndDate()) || info.getCmpPeriod().getId().toString().equals(periodId) && Integer.parseInt(time) < info.getTime()) {
                for (String person2 : personSet) {
                    personInfo = iperson.getPersonInfo((IObjectPK)new ObjectUuidPK(person2));
                    personDataMap = new HashMap<String, String>();
                    personMap = new HashMap<String, HashMap<String, String>>();
                    personDataMap.put("personNumber", personInfo.getNumber());
                    personDataMap.put("personName", personInfo.getName());
                    allDataMap.put(person2, personDataMap);
                    personMap.put(person2, personDataMap);
                    this.getErrorPersonInfo(ctx, personMap, cmpSchemeId, showMap);
                }
                continue;
            }
            if (info.getCmpPeriod().getId().toString().equals(periodId) && Integer.parseInt(time) == info.getTime() && (SchemeAuditedEnum.AUDITING.equals((Object)info.getAudit()) || SchemeAuditedEnum.AUDITEDPASS.equals((Object)info.getAudit()))) {
                for (String person2 : personSet) {
                    personInfo = iperson.getPersonInfo((IObjectPK)new ObjectUuidPK(person2));
                    personDataMap = new HashMap();
                    personMap = new HashMap();
                    personDataMap.put("personNumber", personInfo.getNumber());
                    personDataMap.put("personName", personInfo.getName());
                    allDataMap.put(person2, personDataMap);
                    personMap.put(person2, personDataMap);
                    this.getErrorPersonInfo(ctx, personMap, cmpSchemeId, showMap);
                }
                continue;
            }
            if (HRSchemeUtils.getPeriodAuditCase(ctx)) continue;
            try {
                personIdTmpTable = HRSchemeUtils.getCmpSchemeHorTableName(ctx, cmpSchemeId);
                auditSql.append("SELECT distinct person.FID,person.fnumber as personNumber,person.fName_").append(language).append(" as personName FROM ").append(personIdTmpTable).append(" perTmpTbl").append(" inner join T_BD_Person person on person.fid=perTmpTbl.FPersonID").append(" where perTmpTbl.FPersonID in (select FPersonID from T_HR_PEndInStatus data").append(" where data.FCmpSchemeID='").append(cmpSchemeId).append("'").append(" and data.FCmpPeriodID='").append(periodId).append("'").append(" and data.fTime=").append(time);
                auditSql.append(" and data.fEmpAuditFlag=1) and perTmpTbl.FPersonID in ").append(CompUtils.getStrFromSet(personSet));
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)auditSql.toString());
                while (rowSet.next()) {
                    HashMap<String, String> personDataMap2 = new HashMap<String, String>();
                    HashMap<String, HashMap<String, String>> personMap2 = new HashMap<String, HashMap<String, String>>();
                    personDataMap2.put("personNumber", rowSet.getString(2));
                    personDataMap2.put("personName", rowSet.getString(3));
                    allDataMap.put(rowSet.getString(1), personDataMap2);
                    personMap2.put(rowSet.getString(1), personDataMap2);
                    this.getErrorPersonInfo(ctx, personMap2, cmpSchemeId, showMap);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                this.realeasTmpTable(ctx, personIdTmpTable);
            }
        }
        map.put("personDataMap", allDataMap);
        map.put("showMap", showMap);
        return map;
    }

    private void getErrorPersonInfo(Context ctx, Map personMap, String cmpSchemeId, Map showMap) throws BOSException {
        HashSet<String> personIDs = new HashSet<String>();
        String personId2 = null;
        for (String personId2 : personMap.keySet()) {
            personIDs.add(personId2);
        }
        if (personIDs.size() == 0) {
            return;
        }
        String tableName = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("select cmp.FHorTableName as tableName from T_HR_CMPSCHEME cmp where cmp.fid = '").append(cmpSchemeId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        try {
            while (rs.next()) {
                tableName = rs.getString("tableName");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (tableName == null) {
            return;
        }
        String personID = null;
        String name = null;
        String adminName = null;
        String number = null;
        Locale local = ContextUtils.getLocaleFromEnv();
        buffer = new StringBuffer();
        buffer.append(" select cmp.FPersonID as personID, person.").append(BenefitUtils.getLocaleStr((Locale)local, (String)"FName")).append(" as name \n");
        buffer.append(" ,person.FNumber as number \n");
        buffer.append(" ,admin.").append(BenefitUtils.getLocaleStr((Locale)local, (String)"FName")).append(" as adminName \n");
        buffer.append("from ");
        buffer.append(tableName);
        buffer.append(" cmp ");
        buffer.append("inner join t_bd_person person on cmp.FPersonID = person.fid \n");
        buffer.append("inner join t_org_admin admin on cmp.FAdminOrgUnitID = admin.fid \n");
        buffer.append("where cmp.FPersonID in ");
        buffer.append(CompUtils.getStrFromSet(personIDs));
        rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        ArrayList<String> list = null;
        try {
            while (rs.next()) {
                personID = rs.getString("personID");
                name = rs.getString("name");
                number = rs.getString("number");
                adminName = rs.getString("adminName");
                list = new ArrayList<String>();
                list.add(name);
                list.add(adminName);
                list.add(number);
                showMap.put(personID, list);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

