/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.compensation.AdjSchemeException;
import com.kingdee.eas.hr.compensation.AdjStateEnum;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.IPartJobFixedAdjust;
import com.kingdee.eas.hr.compensation.ISelectPartJobAdjCmpItem;
import com.kingdee.eas.hr.compensation.PartJobFixedAdjustEntryCollection;
import com.kingdee.eas.hr.compensation.PartJobFixedAdjustEntryFactory;
import com.kingdee.eas.hr.compensation.PartJobFixedAdjustFactory;
import com.kingdee.eas.hr.compensation.PartJobFixedAdjustInfo;
import com.kingdee.eas.hr.compensation.SelectPartJobAdjCmpItemFactory;
import com.kingdee.eas.hr.compensation.SelectPartJobAdjCmpItemInfo;
import com.kingdee.eas.hr.compensation.app.AbstractPartJobFixedAdjustControllerBean;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PartJobFixedAdjustControllerBean
extends AbstractPartJobFixedAdjustControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.PartJobFixedAdjustControllerBean");

    @Override
    protected HashMap _getAlreadyInPartJobFixedA(Context ctx, ArrayList strPersonIds, String partJobFixedAdjustID) throws BOSException, EASBizException {
        HashMap<String, String> mapEmpnumberAlreadyIn = new HashMap<String, String>();
        String strMsg = "";
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct TPerson.fid,TPerson.FNumber,TPerson.FName_" + ctx.getLocale().toString());
        sql.append(" from T_HR_PartJobFixedAdjust TPartJob");
        sql.append(" inner join T_HR_PartJobFixedAdjustEntry TPartJobEntry on TPartJobEntry.FPartJobFixedAdjustID = TPartJob.Fid");
        sql.append(" inner join T_bd_person TPerson on TPerson.fid = TPartJobEntry.FAdjEmpID");
        sql.append(" where TPartJob.FAdjSchemeState in (10,20,70)");
        sql.append(" and TPartJob.FHROrgUnitID ='" + HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString() + "' ");
        sql.append(" and TPerson.fid in ");
        if (strPersonIds == null) {
            sql.append("(select distinct FAdjEmpID from T_HR_PartJobFixedAdjustEntry where FPartJobFixedAdjustID ='").append(partJobFixedAdjustID).append("')");
        } else if (strPersonIds.size() != 0) {
            sql.append(CompUtils.getStrFromList(strPersonIds));
        } else {
            return mapEmpnumberAlreadyIn;
        }
        if (partJobFixedAdjustID != null) {
            sql.append(" and TPartJob.fid <> '" + partJobFixedAdjustID + "'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                strMsg = rs.getString(2) + "(" + rs.getString(3) + ")";
                mapEmpnumberAlreadyIn.put(rs.getString(1), strMsg);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return mapEmpnumberAlreadyIn;
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        String userid = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String functionName = "com.kingdee.eas.hr.compensation.PartJobFixedAdjustFunction";
        String operationName = "ActionSubmit";
        String temp = EnactmentServiceProxy.getEnacementService((Context)ctx).findSubmitProcDef(userid, (IObjectValue)model, functionName, operationName);
        if (temp == null || temp.trim().equals("")) {
            throw new AdjSchemeException(AdjSchemeException.CMP_PART_WFNOTENABLE);
        }
        PartJobFixedAdjustInfo info = (PartJobFixedAdjustInfo)model;
        IObjectPK retValue = super.submit(ctx, model);
        this.saveSelectPartJobCmpItem(ctx, retValue, info);
        return retValue;
    }

    public void submit(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        String userid = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String functionName = "com.kingdee.eas.hr.compensation.PartJobFixedAdjustFunction";
        String operationName = "ActionSubmit";
        super.submit(ctx, pk, model);
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        PartJobFixedAdjustInfo info = (PartJobFixedAdjustInfo)model;
        IObjectPK retValue = super.save(ctx, model);
        this.saveSelectPartJobCmpItem(ctx, retValue, info);
        return retValue;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 1);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            ObjectUuidPK retValue = new ObjectUuidPK(coreBaseInfo.getId());
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)coreBaseInfo.getBOSType(), (IObjectPK)retValue, (String)((PartJobFixedAdjustInfo)coreBaseInfo).getNumber(), (String)"partJobFixedAdjust_update");
            super.update(ctx, (IObjectPK)retValue, coreBaseInfo);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            return retValue;
        }
        IObjectPK retValue = super.addnew(ctx, coreBaseInfo);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)coreBaseInfo.getBOSType(), (IObjectPK)retValue, (String)((PartJobFixedAdjustInfo)coreBaseInfo).getNumber(), (String)"partJobFixedAdjust_addnew");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return retValue;
    }

    private void saveSelectPartJobCmpItem(Context ctx, IObjectPK retValue, PartJobFixedAdjustInfo info) throws BOSException, EASBizException {
        int i;
        List allItemList = (List)info.get("allItemList");
        List cmpItemList = (List)info.get("cmpItemList");
        String deleteSQL = "delete from T_HR_SelectPartJobAdjCmpItem where FPartJobFixedAdjustID ='" + retValue.toString() + "'";
        DbUtil.execute((Context)ctx, (String)deleteSQL);
        ISelectPartJobAdjCmpItem selectCmp = SelectPartJobAdjCmpItemFactory.getLocalInstance(ctx);
        SelectPartJobAdjCmpItemInfo selectCmpInfo = null;
        int size = allItemList.size();
        for (i = 0; i < size; ++i) {
            selectCmpInfo = new SelectPartJobAdjCmpItemInfo();
            selectCmpInfo.setPartJobFixedAdjust(info);
            selectCmpInfo.setCmpItem((CmpItemInfo)allItemList.get(i));
            selectCmpInfo.setIsVisible(false);
            selectCmp.addnew(selectCmpInfo);
        }
        size = cmpItemList.size();
        for (i = 0; i < size; ++i) {
            selectCmpInfo = new SelectPartJobAdjCmpItemInfo();
            selectCmpInfo.setPartJobFixedAdjust(info);
            selectCmpInfo.setCmpItem((CmpItemInfo)cmpItemList.get(i));
            selectCmpInfo.setIsVisible(true);
            selectCmp.addnew(selectCmpInfo);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PartJobFixedAdjustInfo Info = this.getPartJobFixedAdjustInfo(ctx, pk);
        if (Info.getAdjSchemeState().getValue() != 10) {
            throw new AdjSchemeException(AdjSchemeException.CANNT_DELETE);
        }
        StringBuffer deleteSQL = new StringBuffer("");
        deleteSQL.append(" DELETE T_HR_SelectPartJobAdjCmpItem WHERE FPartJobFixedAdjustID = '");
        deleteSQL.append(pk.toString());
        deleteSQL.append("'");
        DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
        super._delete(ctx, pk);
        CodingRuleInfo codeRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)Info, HRSchemeUtils.getCurrentServerCUID(ctx));
        if (codeRule != null && (codeRule.isIsaddnewbreak() || CodingRuleManagerFactory.getLocalInstance((Context)ctx).isUseIntermitNumber((IObjectValue)Info, HRSchemeUtils.getCurrentServerCUID(ctx)))) {
            CodingRuleManagerFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)Info, HRSchemeUtils.getCurrentServerCUID(ctx), Info.getNumber());
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PartJobFixedAdjustInfo info = (PartJobFixedAdjustInfo)model;
        IObjectPK pk = super._addnew(ctx, model);
        this._checkNumberBlank(ctx, pk, (IObjectValue)info);
        this._checkNumberDup(ctx, pk, (IObjectValue)info);
        return pk;
    }

    @Override
    protected void _audit(Context ctx, BOSUuid partJobFixedID) throws BOSException, EASBizException {
        this.auditPartJobFixed(ctx, partJobFixedID, false);
    }

    @Override
    protected void _checkEffectDate(Context ctx, BOSUuid partJobFixedID) throws BOSException, EASBizException {
        if (partJobFixedID == null) {
            return;
        }
        PartJobFixedAdjustEntryCollection entrys = PartJobFixedAdjustEntryFactory.getLocalInstance(ctx).getPartJobFixedAdjustEntryCollection("select adjEmp,adjEmp.name,effectDate where partJobFixedAdjust = '" + partJobFixedID + "'");
        if (entrys == null || entrys.size() < 1) {
            return;
        }
        ArrayList<String> personIDs = new ArrayList<String>();
        HashMap<String, String> personNames = new HashMap<String, String>();
        HashMap<String, Date> mapEffectDate = new HashMap<String, Date>();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            personIDs.add(entrys.get(i).getAdjEmp().getId().toString());
            mapEffectDate.put(entrys.get(i).getAdjEmp().getId().toString(), entrys.get(i).getEffectDate());
            personNames.put(entrys.get(i).getAdjEmp().getId().toString(), entrys.get(i).getAdjEmp().getName());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from ");
        sql.append("( ");
        sql.append("select T1.fid,T1.FEffectDate from T_HR_PartJobFixedAdjustEntry T1 ");
        sql.append("inner join ");
        sql.append("( ");
        sql.append("select entry.FAdjEmpID ,max(entry.FEffectDate ) effdate from T_HR_PartJobFixedAdjustEntry entry ");
        sql.append("inner join T_HR_PartJobFixedAdjust partjob on partjob.fid = entry.FPartJobFixedAdjustID ");
        sql.append("where partjob.FAdjSchemeState = 30 ");
        sql.append("and entry.FAdjEmpID in " + CompUtils.getStrFromList(personIDs) + " ");
        sql.append("and partjob.FHROrgUnitID ='" + HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString() + "' ");
        sql.append("and partjob.FID !='" + partJobFixedID + "' ");
        sql.append("group by entry.FAdjEmpID ");
        sql.append(") T ");
        sql.append("on T.FAdjEmpID = T1.FAdjEmpID  and T.effdate = T1.FEffectDate ");
        sql.append(") T2 ");
        PartJobFixedAdjustEntryCollection entryColl = PartJobFixedAdjustEntryFactory.getLocalInstance(ctx).getPartJobFixedAdjustEntryCollection("select adjEmp.name,effectDate where id in (" + sql + ")");
        Date effectDate = null;
        Date effectOldDate = null;
        if (entryColl != null && entryColl.size() > 0) {
            int size2 = entryColl.size();
            for (int i = 0; i < size2; ++i) {
                effectDate = (Date)mapEffectDate.get(entryColl.get(i).getAdjEmp().getId().toString());
                effectOldDate = entryColl.get(i).getEffectDate();
                if (effectDate == null) {
                    throw new AdjSchemeException(AdjSchemeException.EFFECTDATE_NOT_NULL);
                }
                if (effectOldDate == null || !DateTimeUtils.dayBefore((Date)effectDate, (Date)effectOldDate) && !DateTimeUtils.dayEquals((Date)effectDate, (Date)effectOldDate)) continue;
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"674_PartJobFixedAdjustControllerBean", (Locale)ctx.getOriginLocale()) + entryColl.get(i).getAdjEmp().getName() + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"675_PartJobFixedAdjustControllerBean", (Locale)ctx.getOriginLocale()));
            }
        }
        StringBuffer sqlBuff = new StringBuffer("select distinct pm.fpersonid as fpersonid ");
        sqlBuff.append("from t_org_positionmember pm ");
        sqlBuff.append("inner join t_org_position p on pm.fpositionid = p.fid ");
        sqlBuff.append("inner join t_org_admin a on p.fadminOrgUnitID = a.fid ");
        sqlBuff.append("inner join T_ORG_UNITRELATION r on r.ffromunitid = a.fid ");
        sqlBuff.append("inner join T_ORG_HRO h on h.fid = r.ftounitid ");
        sqlBuff.append("INNER JOIN T_PM_ORGRANGE UR ON UR.FORGID = A.FID ");
        sqlBuff.append("where fisprimary = 0 ");
        sqlBuff.append("and R.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        sqlBuff.append("and UR.FTYPE = 20 ");
        sqlBuff.append("AND UR.FUSERID = '" + ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString() + "' ");
        sqlBuff.append("and r.ftounitid ='" + HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString() + "' ");
        sqlBuff.append("and pm.fpersonid not in  ");
        sqlBuff.append("( ");
        sqlBuff.append("select fpersonid from t_hr_personposition pp ");
        sqlBuff.append("inner join T_ORG_UNITRELATION r on  r.ffromunitid = pp.fpersondep ");
        sqlBuff.append("where  R.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        sqlBuff.append("and r.ftounitid ='" + HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString() + "' ");
        sqlBuff.append(") ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        HashMap<String, String> personIds = new HashMap<String, String>();
        try {
            while (rowSet.next()) {
                personIds.put(rowSet.getString("fpersonid"), rowSet.getString("fpersonid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        int size3 = personIDs.size();
        for (int i = 0; i < size3; ++i) {
            if (personIds.containsKey(personIDs.get(i).toString())) continue;
            throw new BOSException(personNames.get(personIDs.get(i).toString()) + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"676_PartJobFixedAdjustControllerBean", (Locale)ctx.getOriginLocale()));
        }
    }

    @Override
    protected void _cancelAudit(Context ctx, String partJobFixedID) throws BOSException, EASBizException {
        if (partJobFixedID == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(partJobFixedID);
        PartJobFixedAdjustInfo fixedAdjust = this.getPartJobFixedAdjustInfo(ctx, (IObjectPK)pk);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)fixedAdjust.getBOSType(), (IObjectPK)pk, (String)fixedAdjust.getNumber(), (String)"partJobFixedAdjust_cancelAudit");
        this.setPartJobFixedState(ctx, BOSUuid.read((String)partJobFixedID), AdjStateEnum.ADDNEW);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void auditPartJobFixed(Context ctx, BOSUuid partJobFixedID, boolean isIgnoreWF) throws BOSException, EASBizException {
        if (partJobFixedID == null) {
            return;
        }
        if (isIgnoreWF) {
            this.setPartJobFixedState(ctx, partJobFixedID, AdjStateEnum.APPROVED);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(partJobFixedID);
            IPartJobFixedAdjust Ipart = PartJobFixedAdjustFactory.getLocalInstance(ctx);
            PartJobFixedAdjustInfo info = Ipart.getPartJobFixedAdjustInfo((IObjectPK)pk);
            info.setAdjSchemeState(AdjStateEnum.APPROVED);
            Ipart.submit((IObjectPK)pk, (CoreBaseInfo)info);
        }
    }

    private void setPartJobFixedState(Context ctx, BOSUuid partJobFixedID, AdjStateEnum state) throws BOSException, EASBizException {
        if (partJobFixedID == null) {
            return;
        }
        DbUtil.execute((Context)ctx, (String)("update T_HR_PartJobFixedAdjust set FAdjSchemeState = " + state.getValue() + " where fid = '" + partJobFixedID.toString() + "'"));
    }

    @Override
    protected void _auditNotPass(Context ctx, BOSUuid partJobFixedID) throws BOSException, EASBizException {
        this.setPartJobFixedState(ctx, partJobFixedID, AdjStateEnum.NOTPASS);
    }

    @Override
    protected void _setAddNew(Context ctx, BOSUuid partJobFixedID) throws BOSException, EASBizException {
        this.setPartJobFixedState(ctx, partJobFixedID, AdjStateEnum.ADDNEW);
    }

    @Override
    protected void _setApproving(Context ctx, BOSUuid partJobFixedID) throws BOSException, EASBizException {
        this.setPartJobFixedState(ctx, partJobFixedID, AdjStateEnum.APPROVING);
    }

    @Override
    protected void _setDestory(Context ctx, BOSUuid partJobFixedID) throws BOSException, EASBizException {
        this.setPartJobFixedState(ctx, partJobFixedID, AdjStateEnum.DESTORY);
    }

    @Override
    protected void _setModify(Context ctx, BOSUuid partJobFixedID) throws BOSException, EASBizException {
        this.setPartJobFixedState(ctx, partJobFixedID, AdjStateEnum.MODIFY);
    }

    @Override
    protected void _wfAudit(Context ctx, BOSUuid partJobFixedID) throws BOSException, EASBizException {
        this.auditPartJobFixed(ctx, partJobFixedID, false);
    }

    @Override
    protected HashMap _checkCanUnaudit(Context ctx, String partJobFixedID) throws BOSException, EASBizException {
        if (partJobFixedID == null) {
            return null;
        }
        StringBuffer checkSql = new StringBuffer();
        checkSql.append(" select entry.FAdjEmpID,entry.FEffectDate as FEffectDate,person.fnumber as pernumber,fixed.fnumber ").append(" from T_HR_PartJobFixedAdjustEntry entry ").append(" inner join t_bd_person person ").append(" on entry.FAdjEmpID = person.fid ").append(" inner join ( ").append(" select entry.FAdjEmpID as FAdjEmpID,entry.FEffectDate as FEffectDate ").append(" from T_HR_PartJobFixedAdjustEntry entry ").append(" inner join T_HR_PartJobFixedAdjust adjust ").append(" on entry.FPartJobFixedAdjustID = adjust.FID ").append(" where adjust.FAdjSchemeState = 30 and adjust.FID = ? ").append(" ) temp ").append(" on entry.FAdjEmpID = temp.FAdjEmpID ").append(" inner join T_HR_PartJobFixedAdjust fixed ").append(" on entry.FPartJobFixedAdjustID = fixed.FID ").append(" where entry.FEffectDate > temp.FEffectDate ").append(" and fixed.FAdjSchemeState = 30 and  fixed.FID <> ? ").append(" order by entry.FEffectDate desc ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])new Object[]{partJobFixedID, partJobFixedID});
        HashMap<String, String> values = new HashMap<String, String>();
        try {
            if (rowSet.next()) {
                values.put(rowSet.getString("pernumber"), rowSet.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return values;
    }
}

