/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.app.AbstractSHReportFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SHReportFacadeControllerBean
extends AbstractSHReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.SHReportFacadeControllerBean");

    @Override
    protected HashMap _getTotalData(Context ctx, HashMap paramMap) throws BOSException, EASBizException {
        String flag = paramMap.get("operationkey").toString();
        HashMap<String, IRowSet> dataMap = new HashMap<String, IRowSet>();
        if (flag.equals("personalFlag")) {
            IRowSet rowSet = this.getPersonalTotalData(ctx, paramMap);
            dataMap.put("fillData", rowSet);
        } else if (flag.equals("departmentFlag")) {
            IRowSet rowSet = this.getDepartmentTotalData(ctx, paramMap);
            dataMap.put("fillData", rowSet);
        } else if (flag.equals("companyFlag")) {
            IRowSet rowSet = this.getCompanyWithDeptTotalData(ctx, paramMap);
            dataMap.put("fillData", rowSet);
        } else {
            return null;
        }
        return dataMap;
    }

    private HashMap getHisTableCollection(Context ctx) throws BOSException {
        HashMap<String, String> historyTableMap = new HashMap<String, String>();
        String oql = "SELECT number,hisTableName WHERE hrOrgUnit.id='" + ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString() + "' AND (number='" + "001" + "' OR number='" + "002" + "' OR number='" + "003" + "')";
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeCollection cmpSchemeCollection = iCmpScheme.getCmpSchemeCollection(oql);
        int size = cmpSchemeCollection.size();
        if (size == 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            CmpSchemeInfo cmpSchemeInfo = cmpSchemeCollection.get(i);
            historyTableMap.put(cmpSchemeInfo.getNumber(), cmpSchemeInfo.getHisTableName());
        }
        return historyTableMap;
    }

    private IRowSet getDepartmentTotalData(Context ctx, HashMap paramMap) throws BOSException {
        IRowSet departmentTotalSet = null;
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)paramMap.get("adminInfo");
        String adminLongNumber = adminInfo.getLongNumber();
        List periodList = (List)paramMap.get("periodList");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT                                         ");
        sqlBuffer.append(" Fperiod,                                       ");
        sqlBuffer.append(" sum(JSGZ) AS JSGZ,                             ");
        sqlBuffer.append(" sum(GNGZ) AS GNGZ,                             ");
        sqlBuffer.append(" sum(FFSAL209) AS FFSAL209,                     ");
        sqlBuffer.append(" sum(FFSAL211) AS FFSAL211,                     ");
        sqlBuffer.append(" sum(FFSAL238) AS FFSAL238,                     ");
        sqlBuffer.append(" sum(FFSAL240) AS FFSAL240,                     ");
        sqlBuffer.append(" sum(FFSAL242) AS FFSAL242,                     ");
        sqlBuffer.append(" sum(FFSAL244) AS FFSAL244,                     ");
        sqlBuffer.append(" sum(FFSAL246) AS FFSAL246,                     ");
        sqlBuffer.append(" sum(FFSAL284) AS FFSAL284,                     ");
        sqlBuffer.append(" sum(FSAL002) AS FSAL002,                       ");
        sqlBuffer.append(" sum(FFSAL253) AS FFSAL253,                     ");
        sqlBuffer.append(" sum(FFSAL224) AS FFSAL224,                     ");
        sqlBuffer.append(" count(DISTINCT SHREP.FPERSONID) AS PERSONNUMBER");
        sqlBuffer.append(" from                                           ");
        sqlBuffer.append(" (                                              ");
        sqlBuffer.append(this.getUnionSql(ctx));
        sqlBuffer.append(" ) SHREP Left outer join                               ");
        sqlBuffer.append(" T_ORG_Admin on SHREP.FADMINORGUNITID = T_ORG_Admin.Fid        ");
        sqlBuffer.append(" WHERE ");
        sqlBuffer.append("   T_ORG_Admin.Flongnumber like '" + adminLongNumber + "%' ");
        if (periodList.size() > 0) {
            sqlBuffer.append(" AND " + this.getPeriodConditionSql(periodList));
        }
        sqlBuffer.append("   group by Fperiod");
        departmentTotalSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        return departmentTotalSet;
    }

    private IRowSet getCompanyWithDeptTotalData(Context ctx, HashMap paramMap) throws BOSException {
        IRowSet departmentTotalSet = null;
        List periodList = (List)paramMap.get("periodList");
        StringBuffer sqlBuffer = new StringBuffer();
        String languageLocal = HRUtils.getLocalLang(ctx);
        sqlBuffer.append(" SELECT                                         ");
        sqlBuffer.append(" Fperiod,                                       ");
        sqlBuffer.append(" T_ORG_Admin.Fid , T_ORG_Admin.Flevel,          ");
        sqlBuffer.append(" T_ORG_Admin.fname_" + languageLocal + " FName,           ");
        sqlBuffer.append(" T_ORG_Admin.Fdisplayname_" + languageLocal + ",   ");
        sqlBuffer.append(" T_ORG_Admin.Flongnumber,                       ");
        sqlBuffer.append(" t_org_unitlayer.fname_" + languageLocal + " unitlayerName,       ");
        sqlBuffer.append(" t_org_unitlayer.fid unitlayerid,                          ");
        sqlBuffer.append(" sum(JSGZ) AS JSGZ,                             ");
        sqlBuffer.append(" sum(GNGZ) AS GNGZ,                             ");
        sqlBuffer.append(" sum(FFSAL209) AS FFSAL209,                     ");
        sqlBuffer.append(" sum(FFSAL211) AS FFSAL211,                     ");
        sqlBuffer.append(" sum(FFSAL238) AS FFSAL238,                     ");
        sqlBuffer.append(" sum(FFSAL240) AS FFSAL240,                     ");
        sqlBuffer.append(" sum(FFSAL242) AS FFSAL242,                     ");
        sqlBuffer.append(" sum(FFSAL244) AS FFSAL244,                     ");
        sqlBuffer.append(" sum(FFSAL246) AS FFSAL246,                     ");
        sqlBuffer.append(" sum(FFSAL284) AS FFSAL284,                     ");
        sqlBuffer.append(" sum(FSAL002) AS FSAL002,                       ");
        sqlBuffer.append(" sum(FFSAL253) AS FFSAL253,                     ");
        sqlBuffer.append(" sum(FFSAL224) AS FFSAL224,                     ");
        sqlBuffer.append(" count(DISTINCT SHREP.FPERSONID) AS PERSONNUMBER");
        sqlBuffer.append(" from                                           ");
        sqlBuffer.append(" (                                              ");
        sqlBuffer.append(this.getUnionSql(ctx));
        sqlBuffer.append(" ) SHREP Left outer join                               ");
        sqlBuffer.append(" T_ORG_Admin on SHREP.FADMINORGUNITID = T_ORG_Admin.Fid Left outer join        ");
        sqlBuffer.append(" T_ORG_UnitLayer ON t_Org_Admin.Flayerid = T_ORG_UnitLayer.fid ");
        sqlBuffer.append(" WHERE ");
        sqlBuffer.append("   T_ORG_Admin.Flongnumber like '00!01!%' ");
        if (periodList.size() > 0) {
            sqlBuffer.append(" AND " + this.getPeriodConditionSql(periodList));
        }
        sqlBuffer.append(" group by Fperiod,T_ORG_Admin.Fid,T_ORG_Admin.Flevel,");
        sqlBuffer.append(" T_ORG_Admin.fname_" + languageLocal + ",");
        sqlBuffer.append(" T_ORG_Admin.Fdisplayname_" + languageLocal + ",");
        sqlBuffer.append(" T_ORG_Admin.Flongnumber,");
        sqlBuffer.append(" t_org_unitlayer.fname_" + languageLocal + ",");
        sqlBuffer.append(" t_org_unitlayer.fid ");
        sqlBuffer.append(" order by T_ORG_Admin.Flevel asc,T_ORG_Admin.FLONGNUMBER asc ");
        departmentTotalSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        return departmentTotalSet;
    }

    private List enCloseCompanyWithDeptDate(IRowSet departmentTotalSet, Context ctx) throws BOSException {
        ArrayList dataList = new ArrayList();
        HashMap onMainDeptMap = new HashMap();
        HashMap onOtherDeptMap = new HashMap();
        if (departmentTotalSet.size() == 0) {
            return dataList;
        }
        String otherDeptLongNumber = "00!01!99";
        String sentToLongNumber = "00!01!65";
        String workOutLongNumber = "workOutKey";
        String workOutlayerId = "wO/cOwENEADgAj3bCgrIEgzgjS4=";
        String currentDeptLayerID = "";
        String currentDeptId = "";
        String currentDeptLongNumber = "";
        int currentDeptLevel = 0;
        ArrayList<Object> dataListTemp = new ArrayList<Object>();
        List saveListTemp = new ArrayList();
        List cmpItemList = this.getCmpItemList();
        int cmpItemSize = cmpItemList.size();
        BigDecimal valueTemp = HRSchemeUtils.BD_ZERO;
        String cmpKeyString = "";
        String languageLocal = HRUtils.getLocalLang(ctx);
        try {
            while (departmentTotalSet.next()) {
                currentDeptLevel = departmentTotalSet.getInt("T_ORG_Admin.Flevel");
                currentDeptLongNumber = departmentTotalSet.getString("T_ORG_Admin.Flongnumber");
                currentDeptLongNumber = departmentTotalSet.getString("T_ORG_Admin.Flongnumber");
                currentDeptLayerID = departmentTotalSet.getString("t_org_unitlayer.fid") != null ? departmentTotalSet.getString("t_org_unitlayer.fid") : "";
                dataListTemp.add(departmentTotalSet.getString("T_ORG_Admin.Fname_" + languageLocal));
                if (currentDeptLongNumber.startsWith(otherDeptLongNumber) && currentDeptLevel == 4) {
                    onOtherDeptMap.put(currentDeptLongNumber, dataListTemp);
                } else if (currentDeptLongNumber.equals(sentToLongNumber) && currentDeptLevel == 3) {
                    onOtherDeptMap.put(currentDeptLongNumber, dataListTemp);
                } else if (currentDeptLevel == 3) {
                    onMainDeptMap.put(currentDeptLongNumber, dataListTemp);
                }
                onOtherDeptMap.put(workOutLongNumber, dataListTemp);
            }
            departmentTotalSet.beforeFirst();
            while (departmentTotalSet.next()) {
                Set keySet;
                saveListTemp.clear();
                dataListTemp.clear();
                currentDeptLevel = departmentTotalSet.getInt("T_ORG_Admin.Flevel");
                currentDeptLongNumber = departmentTotalSet.getString("T_ORG_Admin.Flongnumber");
                if (departmentTotalSet.getString("t_org_unitlayer.fid") != null) {
                    currentDeptLayerID = departmentTotalSet.getString("t_org_unitlayer.fid");
                    if (currentDeptLayerID.equals(workOutlayerId)) {
                        currentDeptLongNumber = workOutLongNumber;
                    }
                } else {
                    currentDeptLayerID = "";
                }
                if ((keySet = onMainDeptMap.keySet()).contains(currentDeptLongNumber)) {
                    saveListTemp = !currentDeptLongNumber.startsWith(otherDeptLongNumber) && !currentDeptLongNumber.startsWith(sentToLongNumber) && !currentDeptLayerID.equals(workOutlayerId) ? (List)onMainDeptMap.get(currentDeptLongNumber) : (List)onOtherDeptMap.get(currentDeptLongNumber);
                }
                for (int i = 0; i < cmpItemSize; ++i) {
                    cmpKeyString = cmpItemList.get(i).toString();
                    if (saveListTemp.size() == 0) {
                        dataListTemp.add(departmentTotalSet.getBigDecimal(cmpKeyString));
                        continue;
                    }
                    valueTemp = HRSchemeUtils.BD_ZERO;
                    if (saveListTemp.get(i) != null) {
                        valueTemp = (BigDecimal)saveListTemp.get(i);
                    }
                    valueTemp = departmentTotalSet.getBigDecimal(cmpKeyString).add(valueTemp);
                    dataListTemp.add(valueTemp);
                }
                if (currentDeptLevel != 3 || currentDeptLongNumber.startsWith(otherDeptLongNumber)) continue;
                if (!onMainDeptMap.containsKey(currentDeptLongNumber)) {
                    onMainDeptMap.put(currentDeptLongNumber, dataListTemp);
                    continue;
                }
                onOtherDeptMap.put(currentDeptLongNumber, dataListTemp);
            }
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        return dataList;
    }

    private List getCmpItemList() {
        ArrayList<String> cmpItemList = new ArrayList<String>();
        cmpItemList.add("JSGZ");
        cmpItemList.add("GNGZ");
        cmpItemList.add("FSAL002");
        cmpItemList.add("FFSAL253");
        cmpItemList.add("FFSAL224");
        cmpItemList.add("FFSAL240");
        cmpItemList.add("FFSAL209");
        cmpItemList.add("FFSAL238");
        cmpItemList.add("FFSAL244");
        cmpItemList.add("FFSAL246");
        cmpItemList.add("FFSAL211");
        cmpItemList.add("FFSAL242");
        cmpItemList.add("FFSAL284");
        cmpItemList.add("PERSONNUMBER");
        return cmpItemList;
    }

    private IRowSet getPersonalTotalData(Context ctx, HashMap paramMap) throws BOSException {
        IRowSet personalTotalData = null;
        StringBuffer sqlBuffer = new StringBuffer();
        PersonInfo personInfo = (PersonInfo)paramMap.get("personalInfo");
        String personID = personInfo.getId().toString();
        List periodList = (List)paramMap.get("periodList");
        sqlBuffer.append("SELECT FPERSONID,           ");
        sqlBuffer.append("FPERIOD,                  ");
        sqlBuffer.append("sum(JSGZ) AS JSGZ,        ");
        sqlBuffer.append("sum(GNGZ) AS GNGZ,        ");
        sqlBuffer.append("sum(FFSAL209) AS FFSAL209,");
        sqlBuffer.append("sum(FFSAL211) AS FFSAL211,");
        sqlBuffer.append("sum(FFSAL238) AS FFSAL238,");
        sqlBuffer.append("sum(FFSAL240) AS FFSAL240,");
        sqlBuffer.append("sum(FFSAL242) AS FFSAL242,");
        sqlBuffer.append("sum(FFSAL244) AS FFSAL244,");
        sqlBuffer.append("sum(FFSAL246) AS FFSAL246,");
        sqlBuffer.append("sum(FFSAL284) AS FFSAL284,");
        sqlBuffer.append("sum(FSAL002) AS FSAL002,  ");
        sqlBuffer.append("sum(FFSAL253) AS FFSAL253,");
        sqlBuffer.append("sum(FFSAL224) AS FFSAL224, ");
        sqlBuffer.append(" count(DISTINCT FPERSONID) AS PERSONNUMBER  ");
        sqlBuffer.append("FROM                      ");
        sqlBuffer.append("(                         ");
        sqlBuffer.append(this.getUnionSql(ctx));
        sqlBuffer.append(" ) B ");
        sqlBuffer.append("  WHERE FPERSONID ='" + personID + "' ");
        if (periodList.size() > 0) {
            sqlBuffer.append(" AND " + this.getPeriodConditionSql(periodList));
        }
        sqlBuffer.append("  group by Fpersonid,Fperiod");
        personalTotalData = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        return personalTotalData;
    }

    private String getUnionSql(Context ctx) throws BOSException {
        HashMap historyTableMap = this.getHisTableCollection(ctx);
        String historyTableNameTemp = "";
        StringBuffer sqlBuffer = new StringBuffer();
        if (historyTableMap.get("001") != null) {
            historyTableNameTemp = historyTableMap.get("001").toString();
            sqlBuffer.append("  SELECT FPERSONID,                                   ");
            sqlBuffer.append("  FPERIOD,                                            ");
            sqlBuffer.append("  FADMINORGUNITID,                                    ");
            sqlBuffer.append("  FPOSITIONID,                                        ");
            sqlBuffer.append("  ISNULL(FFSAL207,0)+ISNULL(FSAL031,0)+ISNULL(FFSAL205,0)+ISNULL(FFSAL206,0)+ISNULL(FFSAL208,0)-ISNULL(FFSAL295,0) AS JSGZ,");
            sqlBuffer.append("  ISNULL(FFSAL200,0)+ISNULL(FFSAL202,0) AS GNGZ,      ");
            sqlBuffer.append("  ISNULL(FFSAL209,0) AS FFSAL209,                     ");
            sqlBuffer.append("  ISNULL(FFSAL211,0) AS FFSAL211,                     ");
            sqlBuffer.append("  0 AS FFSAL238,                                      ");
            sqlBuffer.append("  0 AS FFSAL240,                                      ");
            sqlBuffer.append("  0 AS FFSAL242,                                      ");
            sqlBuffer.append("  0 AS FFSAL244,                                      ");
            sqlBuffer.append("  0 AS FFSAL246,                                      ");
            sqlBuffer.append("  0 AS FFSAL284,                                      ");
            sqlBuffer.append("  0 AS FSAL002,                                       ");
            sqlBuffer.append("  0 AS FFSAL253,                                      ");
            sqlBuffer.append("  0 AS FFSAL224                                       ");
            sqlBuffer.append("  FROM " + historyTableNameTemp + "                   ");
        }
        if (historyTableMap.get("002") != null) {
            historyTableNameTemp = historyTableMap.get("002").toString();
            sqlBuffer.append("  Union ALL                                           ");
            sqlBuffer.append("  SELECT FPERSONID,                                   ");
            sqlBuffer.append("  FPERIOD,                                            ");
            sqlBuffer.append("  FADMINORGUNITID,                                    ");
            sqlBuffer.append("  FPOSITIONID,                                        ");
            sqlBuffer.append("  0 AS JSGZ,                                          ");
            sqlBuffer.append("  0 AS GNGZ,                                          ");
            sqlBuffer.append("  0 AS FFSAL209,                                      ");
            sqlBuffer.append("  0 AS FFSAL211,                                      ");
            sqlBuffer.append("  ISNULL(FFSAL238,0) AS FFSAL238,                               ");
            sqlBuffer.append("  ISNULL(FFSAL240,0) AS FFSAL240,                               ");
            sqlBuffer.append("  ISNULL(FFSAL242,0) AS FFSAL242,                               ");
            sqlBuffer.append("  ISNULL(FFSAL244,0) AS FFSAL244,                               ");
            sqlBuffer.append("  ISNULL(FFSAL246,0) AS FFSAL246,                               ");
            sqlBuffer.append("  ISNULL(FFSAL284,0) AS FFSAL284,                               ");
            sqlBuffer.append("  ISNULL(FSAL002,0) AS FSAL002,                                 ");
            sqlBuffer.append("  ISNULL(FFSAL253,0) AS FFSAL253,                               ");
            sqlBuffer.append("  0 AS FFSAL224                                       ");
            sqlBuffer.append("  FROM " + historyTableNameTemp + "                   ");
        }
        if (historyTableMap.get("003") != null) {
            historyTableNameTemp = historyTableMap.get("003").toString();
            sqlBuffer.append("  Union ALL                                           ");
            sqlBuffer.append("  select FPERSONID,                                   ");
            sqlBuffer.append("  FPERIOD,                                            ");
            sqlBuffer.append("  FADMINORGUNITID,                                    ");
            sqlBuffer.append("  FPOSITIONID,                                        ");
            sqlBuffer.append("  0 AS JSGZ,                                          ");
            sqlBuffer.append("  0 AS GNGZ,                                          ");
            sqlBuffer.append("  0 AS FFSAL209,                                      ");
            sqlBuffer.append("  0 AS FFSAL211,                                      ");
            sqlBuffer.append("  0 AS FFSAL238,                                      ");
            sqlBuffer.append("  0 AS FFSAL240,                                      ");
            sqlBuffer.append("  0 AS FFSAL242,                                      ");
            sqlBuffer.append("  0 AS FFSAL244,                                      ");
            sqlBuffer.append("  0 AS FFSAL246,                                      ");
            sqlBuffer.append("  0 AS FFSAL284,                                  \t");
            sqlBuffer.append("  0 AS FSAL002,                      \t\t            ");
            sqlBuffer.append("  0 AS FFSAL253,                                      ");
            sqlBuffer.append("  ISNULL(FFSAL224,0) AS FFSAL224                                ");
            sqlBuffer.append("  FROM " + historyTableNameTemp + "                   ");
        }
        return sqlBuffer.toString();
    }

    private String getPeriodConditionSql(List periodList) {
        StringBuffer conditionSql = new StringBuffer();
        int listSize = periodList.size();
        if (listSize > 0) {
            conditionSql.append(" FPERIOD in( ");
            for (int i = 0; i < listSize; ++i) {
                CmpPeriodInfo cmpPeriodInfoTemp = (CmpPeriodInfo)periodList.get(i);
                String cmpPeriodId = cmpPeriodInfoTemp.getId().toString();
                conditionSql.append("'").append(cmpPeriodId).append("'");
                if (i == listSize - 1) continue;
                conditionSql.append(", ");
            }
            conditionSql.append(")");
        }
        return conditionSql.toString();
    }
}

