/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.TaxRateListInfo;
import com.kingdee.eas.hr.compensation.TaxReportParamsInfo;
import com.kingdee.eas.hr.compensation.TaxReportResultInfo;
import com.kingdee.eas.hr.compensation.app.AbstractTaxReportFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxReportFacadeControllerBean
extends AbstractTaxReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.TaxReportFacadeControllerBean");
    private final MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.PersonInfoQuery");

    @Override
    protected Map _getTaxDetailReportData(Context ctx, TaxReportParamsInfo paramsInfo) throws BOSException, EASBizException {
        IRowSet row;
        ctx.put((Object)"schemeDataTable", null);
        List schemeInfos = paramsInfo.getSchemeInfos();
        List cmpItemColl = paramsInfo.getCmpItemColl();
        if (cmpItemColl == null || cmpItemColl.size() == 0) {
            return null;
        }
        List taxRateList = paramsInfo.getTaxRateList();
        boolean isShowTaxRate = paramsInfo.isShowTaxRate();
        HashMap mapAllSchemeItems = paramsInfo.getMapAllSchemeItems();
        this.addShouldTaxAmount(cmpItemColl);
        String totalDataTable = null;
        HashMap<String, String> schemePrefixMap = null;
        if (schemeInfos.size() > 1) {
            StringBuffer strSelectors = new StringBuffer();
            strSelectors.append(" create TABLE aa ").append(" (FPersonId varchar(44),FAdminOrgUnitID varchar(44),FPositionID varchar(44),");
            strSelectors.append(this.getSelectorStr(cmpItemColl, isShowTaxRate, null));
            schemePrefixMap = new HashMap<String, String>();
            String column_prefix = null;
            for (int i = 0; i < schemeInfos.size(); ++i) {
                column_prefix = "F" + i;
                schemePrefixMap.put(((CmpSchemeInfo)schemeInfos.get(i)).getId().toString(), column_prefix);
                strSelectors.append(",");
                strSelectors.append(this.getSelectorStr(cmpItemColl, isShowTaxRate, column_prefix));
            }
            strSelectors.append(" )");
            try {
                totalDataTable = TempTablePool.getInstance((Context)ctx).createTempTable(strSelectors.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if ((row = this.getTaxDetailReportDatas(ctx, paramsInfo, schemePrefixMap, totalDataTable)) == null) {
            return null;
        }
        if (totalDataTable == null) {
            totalDataTable = ctx.get((Object)"schemeDataTable").toString();
        }
        IRowSet totalResult = this.totalUpData(ctx, schemePrefixMap, cmpItemColl, taxRateList, totalDataTable);
        ArrayList<TaxReportResultInfo> resultList = new ArrayList<TaxReportResultInfo>();
        TaxReportResultInfo resultInfo = null;
        Map itemValueMap = null;
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        String schemeID = ((CmpSchemeInfo)schemeInfos.get(0)).getId().toString();
        try {
            List personItemList = paramsInfo.getPersonItemColl();
            while (row.next()) {
                resultInfo = new TaxReportResultInfo();
                resultInfo.setPersonID(row.getString("FPERSONID"));
                this.setResultInfo(resultInfo, row, personItemList);
                resultInfo.setNationality(row.getString("NATIONALITY.NAME"));
                itemValueMap = this.getRowData(row, schemeInfos, cmpItemColl, isShowTaxRate, schemePrefixMap, mapAllSchemeItems);
                if (isShowTaxRate && row.getBigDecimal("FtaxRate") != null) {
                    resultInfo.setTaxRate(row.getBigDecimal("FtaxRate").divide(new BigDecimal("100"), 4, 4));
                }
                resultInfo.setItemValueMap(itemValueMap);
                resultList.add(resultInfo);
            }
            if (totalResult != null) {
                Object taxRateKey = null;
                int key = 0;
                HashMap<Integer, Map> totalRowMap = new HashMap<Integer, Map>();
                int personCount = 0;
                while (totalResult.next()) {
                    personCount = totalResult.getInt("personcount");
                    itemValueMap = this.getRowData(totalResult, schemeInfos, cmpItemColl, false, schemePrefixMap, mapAllSchemeItems);
                    itemValueMap.put("personCount", personCount);
                    totalRowMap.put(key, itemValueMap);
                    ++key;
                }
                map.put("totalPersonCount", totalRowMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        map.put("resultDataList", resultList);
        return map;
    }

    private void setResultInfo(TaxReportResultInfo resultInfo, IRowSet row, List personItemList) throws BOSException {
        try {
            Class<?> c = resultInfo.getClass();
            Method m = null;
            CmpItemInfo itemInfo = null;
            String itemNumber = null;
            int size = personItemList.size();
            for (int i = 0; i < size; ++i) {
                itemInfo = (CmpItemInfo)personItemList.get(i);
                itemNumber = itemInfo.getNumber();
                if ("FPER040".equals(itemNumber)) {
                    m = c.getMethod("set" + itemNumber, Boolean.TYPE);
                    m.invoke((Object)resultInfo, row.getBoolean(itemNumber));
                    continue;
                }
                m = c.getMethod("set" + itemNumber, String.class);
                m.invoke((Object)resultInfo, row.getString(itemNumber));
            }
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map getRowData(IRowSet row, List schemeInfos, List cmpItemColl, boolean isShowTaxRate, Map schemePrefixMap, HashMap mapAllSchemeItems) throws SQLException {
        String schemeID = ((CmpSchemeInfo)schemeInfos.get(0)).getId().toString();
        HashMap<String, BigDecimal> itemValueMap = new HashMap<String, BigDecimal>();
        if (schemeInfos.size() == 1) {
            CmpItemInfo cmpItem = null;
            for (int i = 0; i < cmpItemColl.size(); ++i) {
                cmpItem = (CmpItemInfo)cmpItemColl.get(i);
                itemValueMap.put(cmpItem.getNumber() + "~" + schemeID, row.getBigDecimal(cmpItem.getNumber()));
            }
            if (isShowTaxRate) {
                itemValueMap.put("taxRate_" + schemeID, row.getBigDecimal("FtaxRate"));
                itemValueMap.put("fastSub_" + schemeID, row.getBigDecimal("FfastSub"));
            }
        } else {
            CmpItemInfo cmpItem = null;
            for (int i = 0; i < cmpItemColl.size(); ++i) {
                cmpItem = (CmpItemInfo)cmpItemColl.get(i);
                itemValueMap.put(cmpItem.getNumber(), row.getBigDecimal(cmpItem.getNumber()));
            }
            if (isShowTaxRate) {
                itemValueMap.put("taxRate", row.getBigDecimal("FtaxRate"));
                itemValueMap.put("fastSub", row.getBigDecimal("FfastSub"));
            }
            Iterator iter = mapAllSchemeItems.keySet().iterator();
            List schemItemList = null;
            while (iter.hasNext()) {
                schemeID = iter.next().toString();
                schemItemList = (List)mapAllSchemeItems.get(schemeID);
                for (int i = 0; i < schemItemList.size(); ++i) {
                    cmpItem = (CmpItemInfo)schemItemList.get(i);
                    itemValueMap.put(cmpItem.getNumber() + "~" + schemeID, row.getBigDecimal(schemePrefixMap.get(schemeID) + "_" + cmpItem.getNumber()));
                }
                if (!isShowTaxRate) continue;
                itemValueMap.put("taxRate_" + schemeID, row.getBigDecimal(schemePrefixMap.get(schemeID) + "_FtaxRate"));
                itemValueMap.put("fastSub_" + schemeID, row.getBigDecimal(schemePrefixMap.get(schemeID) + "_FfastSub"));
            }
        }
        return itemValueMap;
    }

    private IRowSet totalUpData(Context ctx, Map schemePrefixMap, List cmpItemColl, List taxRateList, String totalDataTable) throws BOSException {
        int i;
        if (taxRateList == null || taxRateList.size() == 0) {
            return null;
        }
        CmpItemInfo itemInfo = null;
        StringBuffer selector = new StringBuffer();
        selector.append("select ftaxrate,count(fpersonid) as personcount ");
        int size = cmpItemColl.size();
        for (i = 0; i < size; ++i) {
            itemInfo = (CmpItemInfo)cmpItemColl.get(i);
            if ("FSAL029".equals(itemInfo.getNumber())) {
                // empty if block
            }
            selector.append(",sum(isnull(").append(itemInfo.getNumber()).append(",0)) as ").append(itemInfo.getNumber());
        }
        if (schemePrefixMap != null) {
            Iterator iter = schemePrefixMap.keySet().iterator();
            String key = null;
            String value = null;
            while (iter.hasNext()) {
                key = iter.next().toString();
                value = schemePrefixMap.get(key).toString();
                String columnName = null;
                int size2 = cmpItemColl.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    itemInfo = (CmpItemInfo)cmpItemColl.get(i2);
                    if ("FSAL029".equals(itemInfo.getNumber())) {
                        // empty if block
                    }
                    columnName = value + "_" + itemInfo.getNumber();
                    selector.append(",sum(isnull(").append(columnName).append(",0)) as ").append(columnName);
                }
            }
        }
        selector.append(" from ").append(totalDataTable);
        selector.append(" where ftaxrate in (");
        for (i = 0; i < taxRateList.size(); ++i) {
            if (i != 0) {
                selector.append(",");
            }
            selector.append(((TaxRateListInfo)taxRateList.get(i)).getTaxRate().toString());
        }
        selector.append(") group by ftaxrate order by ftaxrate ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selector.toString());
        return rowSet;
    }

    private void addShouldTaxAmount(List cmpItemColl) {
        boolean hasFSAL014 = false;
        if (cmpItemColl == null || cmpItemColl.size() == 0) {
            return;
        }
        CmpItemInfo itemInfo = null;
        int size = cmpItemColl.size();
        for (int i = 0; i < size; ++i) {
            itemInfo = (CmpItemInfo)cmpItemColl.get(i);
            if ("FSAL014".equals(itemInfo.getNumber())) {
                hasFSAL014 = true;
            }
            if (!"FSAL029".equals(itemInfo.getNumber())) continue;
        }
        if (!hasFSAL014) {
            itemInfo = new CmpItemInfo();
            itemInfo.setNumber("FSAL014");
            cmpItemColl.add(itemInfo);
        }
    }

    private IRowSet getTaxDetailReportDatas(Context ctx, TaxReportParamsInfo paramInfo, Map schemePrefixMap, String totalDataTable) throws BOSException, EASBizException {
        HashMap<String, String> tempTableName = new HashMap<String, String>();
        try {
            CmpPeriodInfo cmpPeriod = paramInfo.getCmpPeriod();
            List schemeInfos = paramInfo.getSchemeInfos();
            List cmpItemColl = paramInfo.getCmpItemColl();
            List taxRateList = paramInfo.getTaxRateList();
            List adminColl = paramInfo.getAdminColl();
            EntityViewInfo infoEntityView = paramInfo.getInfoEntityView();
            HashMap mapAllSchemeItems = paramInfo.getMapAllSchemeItems();
            boolean isShowTaxRate = paramInfo.isShowTaxRate();
            boolean isYearbonus = paramInfo.isYearbonus();
            boolean hasBasePoint = false;
            if (cmpItemColl == null || cmpItemColl.size() == 0) {
                IRowSet iRowSet = null;
                return iRowSet;
            }
            CmpItemInfo itemInfo = null;
            int size2 = cmpItemColl.size();
            for (int i = 0; i < size2; ++i) {
                itemInfo = (CmpItemInfo)cmpItemColl.get(i);
                if (!"FSAL029".equals(itemInfo.getNumber())) continue;
                hasBasePoint = true;
            }
            String tempPersonTable = this.createPersonTempTable(ctx, infoEntityView, adminColl, cmpPeriod, schemeInfos);
            if (tempPersonTable == null) {
                IRowSet size2 = null;
                return size2;
            }
            tempTableName.put("tempPersonTable", tempPersonTable);
            String schemeDataTable = this.createTaxTempTable(ctx, paramInfo, tempPersonTable, cmpItemColl, mapAllSchemeItems, cmpPeriod, schemeInfos, isShowTaxRate, isYearbonus);
            tempTableName.put("schemeDataTable", schemeDataTable);
            ctx.put((Object)"schemeDataTable", (Object)schemeDataTable);
            if (schemeInfos.size() == 1) {
                StringBuffer update = new StringBuffer();
                update.append(" update ").append(schemeDataTable).append(" set (FAdminOrgUnitID,FPositionID)").append(" = (select distinct T2.fpersondep,T2.FPrimaryPositionID ").append(" From ").append(tempPersonTable).append(" T1 ").append(" left outer join T_HR_PersonPosition T2 on t1.fpersonid = T2.fpersonid ").append(" where ").append(schemeDataTable).append(".FPersonID = t2.FPersonID )");
                DbUtil.execute((Context)ctx, (String)update.toString());
                IRowSet iRowSet = this.getTaxQueryResult(ctx, paramInfo, infoEntityView, taxRateList, schemeDataTable);
                return iRowSet;
            }
            tempTableName.put("totalDataTable", totalDataTable);
            StringBuffer insertSql = new StringBuffer();
            insertSql.append(" insert into ").append(totalDataTable).append("(FPersonId,FAdminOrgUnitID,FPositionID)").append(" select distinct T1.FPERSONID,T2.fpersondep,T2.FPrimaryPositionID ").append(" From ").append(tempPersonTable).append(" T1 ").append(" left outer join T_HR_PersonPosition T2 on t1.fpersonid = T2.fpersonid ");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            StringBuffer updateSql = new StringBuffer();
            String itemSelector = this.getItemStr(cmpItemColl, isShowTaxRate, "Fi");
            Iterator iter = schemePrefixMap.keySet().iterator();
            String key = null;
            String value = null;
            updateSql = new StringBuffer();
            updateSql.append(" update ").append(totalDataTable).append(" set (").append(itemSelector).append(") = (").append(" select ").append(itemSelector.replaceAll("Fi_", schemeDataTable + ".")).append(" from ").append(schemeDataTable).append(" where fcmpschemeid=? and ").append(schemeDataTable).append(".fpersonid = ").append(totalDataTable).append(".fpersonid)");
            while (iter.hasNext()) {
                key = iter.next().toString();
                value = schemePrefixMap.get(key).toString();
                String updateStr = updateSql.toString().replaceAll("Fi", value);
                DbUtil.execute((Context)ctx, (String)updateStr, (Object[])new Object[]{key});
            }
            StringBuffer itemSumSb = new StringBuffer();
            int size3 = schemePrefixMap.size();
            for (int k = 0; k < cmpItemColl.size(); ++k) {
                itemInfo = (CmpItemInfo)cmpItemColl.get(k);
                if ("FSAL029".equals(itemInfo.getNumber()) || "FSAL014".equals(itemInfo.getNumber())) continue;
                if (itemSumSb.length() > 0) {
                    itemSumSb.append(",");
                }
                itemSumSb.append(itemInfo.getNumber()).append("=");
                String itemStr = null;
                for (int i = 0; i < size3; ++i) {
                    itemStr = "F" + i + "_" + itemInfo.getNumber();
                    if (i != 0) {
                        itemSumSb.append("+");
                    }
                    itemSumSb.append("isnull(").append(itemStr).append(",0)");
                }
            }
            updateSql = new StringBuffer();
            updateSql.append(" update ").append(totalDataTable).append(" set ").append(itemSumSb);
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
            updateSql = new StringBuffer();
            updateSql.append(" update ").append(totalDataTable).append(" set ").append("FSAL014=(select MAX(FSAL014) from ").append(schemeDataTable).append(" where ").append(totalDataTable).append(".fpersonid = ").append(schemeDataTable).append(".fpersonid ").append(" )");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
            if (hasBasePoint) {
                updateSql = new StringBuffer();
                updateSql.append(" update ").append(totalDataTable).append(" set FSAL029 =( select FSAL029  ").append(" from(select distinct T2.fpersonid, FSAL029").append(" from ").append(schemeDataTable).append(" T2 ").append(" inner join (select T.fpersonid from( ").append(" select fpersonid,FSAL029").append(" from ").append(schemeDataTable).append(" where FSAL029 is not null and FSAL029 <>0").append(" group by fpersonid,FSAL029").append(" )T ").append(" group by T.fpersonid ").append(" having (count(T.fpersonid))=1 ").append(" )T1").append(" on T1.fpersonid = T2.fpersonid)T3 ").append(" where T3.fpersonid = ").append(totalDataTable).append(".fpersonid ").append(" and T3.FSAL029 is not null and T3.FSAL029 <>0)");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
            if (isShowTaxRate) {
                updateSql = new StringBuffer();
                updateSql.append(" update ").append(totalDataTable).append(" set (FTaxRate,FFastSub) =( select FTaxRate,FFastSub ").append(" from(select distinct T2.fpersonid, FTaxRate,FFastSub").append(" from ").append(schemeDataTable).append(" T2 ").append(" inner join (select T.fpersonid from( ").append(" select fpersonid,FTaxRate").append(" from ").append(schemeDataTable).append(" where FTaxRate is not null and FTaxRate <>0").append(" group by fpersonid,FTaxRate").append(" )T ").append(" group by T.fpersonid ").append(" having (count(T.fpersonid))=1 ").append(" )T1").append(" on T1.fpersonid = T2.fpersonid)T3 ").append(" where T3.fpersonid = ").append(totalDataTable).append(".fpersonid ").append(" and T3.FTaxRate is not null and T3.FTaxRate <>0)");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
                updateSql = new StringBuffer();
                updateSql.append(" update ").append(totalDataTable).append(" set ").append(" FTaxRate = (select max(FTaxRate) from ").append(schemeDataTable).append(" where ").append(totalDataTable).append(".fpersonid = ").append(schemeDataTable).append(".fpersonid ").append(" ),FFastSub = (select max(FFastSub) from ").append(schemeDataTable).append(" where ").append(totalDataTable).append(".fpersonid = ").append(schemeDataTable).append(".fpersonid ").append(" )");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
            IRowSet iRowSet = this.getTaxQueryResult(ctx, paramInfo, infoEntityView, taxRateList, totalDataTable);
            return iRowSet;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            if (tempTableName.get("tempPersonTable") != null) {
                pool.releaseTable(tempTableName.get("tempPersonTable").toString());
            }
            if (tempTableName.get("schemeDataTable") != null) {
                pool.releaseTable(tempTableName.get("schemeDataTable").toString());
            }
            if (tempTableName.get("totalDataTable") != null) {
                pool.releaseTable(tempTableName.get("totalDataTable").toString());
            }
        }
    }

    private IRowSet getTaxQueryResult(Context ctx, TaxReportParamsInfo paramInfo, EntityViewInfo infoEntityView, List rateTaxList, String dataTableName) throws BOSException {
        EntityViewInfo newViewInfo = new EntityViewInfo();
        if (infoEntityView != null && infoEntityView.getSorter() != null) {
            newViewInfo.setSorter(infoEntityView.getSorter());
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.metaDataPK);
        exec.setObjectView(newViewInfo);
        String sql = exec.getSQL();
        sql = HRSchemeUtils.getReplaceQuerySQL(ctx, sql);
        int orderIndex = sql.indexOf(" ORDER BY");
        String orderByStr = null;
        if (orderIndex > -1) {
            orderByStr = sql.substring(orderIndex, sql.length());
            sql = sql.substring(0, orderIndex);
        }
        if (rateTaxList != null) {
            orderByStr = orderByStr != null ? " ORDER BY Temp.FTaxRate asc," + orderByStr.replaceAll("ORDER BY", "") : " ORDER BY Temp.FTaxRate asc,\"PERSON\".FIndex asc";
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < rateTaxList.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(((TaxRateListInfo)rateTaxList.get(i)).getTaxRate().toString());
            }
            sql = sql + " and Temp.FTaxRate in(" + sb + ")";
        }
        sql = orderByStr != null ? sql + orderByStr : sql + " ORDER BY \"PERSON\".FIndex";
        if (dataTableName != null) {
            sql = StringUtils.replaceIgnoreCase((String)sql, (String)"T_HR_CMPSCHEMEPERSON".toLowerCase(), (String)dataTableName);
            while (sql.indexOf("\"CMPSCHEMEPERSON\"") > -1) {
                sql = StringUtils.replaceIgnoreCase((String)sql, (String)"\"CMPSCHEMEPERSON\"".toLowerCase(), (String)"Temp");
            }
        }
        int fromPos = sql.indexOf("FROM");
        String selectSql = sql.substring(0, fromPos);
        String language = ctx.getLocale().getLanguage();
        selectSql = this.getSelectPerItemString(ctx, paramInfo, language);
        String fromSql = sql.substring(fromPos);
        sql = selectSql + ",Temp.* " + fromSql;
        sql = PersonInfoUtils.getOptimizeSql(sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rs;
    }

    private String getItemStr(List cmpItemColl, boolean isShowTaxRate, String prefix) {
        CmpItemInfo itemInfo = null;
        StringBuffer strSelectors = new StringBuffer();
        int size = cmpItemColl.size();
        for (int i = 0; i < size; ++i) {
            itemInfo = (CmpItemInfo)cmpItemColl.get(i);
            if (itemInfo == null) continue;
            if (i != 0) {
                strSelectors.append(",");
            }
            if (prefix != null) {
                strSelectors.append(prefix).append("_");
            }
            strSelectors.append(itemInfo.getNumber());
        }
        if (isShowTaxRate) {
            if (prefix != null) {
                strSelectors.append(",").append(prefix).append("_FTaxRate ").append(",").append(prefix).append("_FFastSub ");
            } else {
                strSelectors.append(",FTaxRate,FFastSub");
            }
        }
        return strSelectors.toString();
    }

    private String createTaxTempTable(Context ctx, TaxReportParamsInfo paramInfo, String tempPersonTable, List cmpItemColl, HashMap mapAllSchemeItems, CmpPeriodInfo cmpPeriod, List schemeInfos, boolean isShowTaxRate, boolean isYearbonus) throws BOSException {
        StringBuffer strSelectors = new StringBuffer();
        String temporaryTableName = null;
        strSelectors.append(" create TABLE aa ").append(" (FCmpSchemeId varchar(44),FPersonId varchar(44),FAdminOrgUnitID varchar(44),FPositionID varchar(44),");
        strSelectors.append(this.getSelectorStr(cmpItemColl, isShowTaxRate, null));
        strSelectors.append(" )");
        try {
            temporaryTableName = TempTablePool.getInstance((Context)ctx).createTempTable(strSelectors.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        CmpSchemeItemCollection schemeItemColl = null;
        Object schemeItemList = null;
        CmpSchemeInfo schemeInfo = null;
        StringBuffer updateSql = null;
        String hisTblName = null;
        String horTblName = null;
        boolean isYearSalary = false;
        String strCmpSchemeID = null;
        for (int i = 0; i < schemeInfos.size(); ++i) {
            StringBuffer itemSb = new StringBuffer();
            StringBuffer itemSumSb = new StringBuffer();
            StringBuffer selectSb = new StringBuffer();
            schemeInfo = (CmpSchemeInfo)schemeInfos.get(i);
            schemeItemColl = CmpSchemeItemFactory.getLocalInstance(ctx).getCmpSchemeItemCollection("select cmpItem.number where cmpScheme.id='" + schemeInfo.getId() + "'");
            String number = null;
            strCmpSchemeID = schemeInfo.getId().toString();
            CmpItemInfo itemInfo = null;
            for (int k = 0; k < cmpItemColl.size(); ++k) {
                boolean contains = false;
                itemInfo = (CmpItemInfo)cmpItemColl.get(k);
                for (int j = 0; j < schemeItemColl.size(); ++j) {
                    number = schemeItemColl.get(j).getCmpItem().getNumber();
                    if (number == null || !number.equals(itemInfo.getNumber())) continue;
                    contains = true;
                    break;
                }
                if (!contains) continue;
                if (itemSb.length() > 0) {
                    itemSb.append(",");
                    itemSumSb.append(",");
                }
                if ("FSAL029".equals(itemInfo.getNumber())) {
                    itemSumSb.append("max(isnull(T.").append(number).append(",0))").append(" as ").append(number);
                } else if ("FSAL014".equals(itemInfo.getNumber())) {
                    itemSumSb.append("max(isnull(T.").append(number).append(",0))").append(" as ").append(number);
                } else {
                    itemSumSb.append("sum(isnull(T.").append(number).append(",0))").append(" as ").append(number);
                }
                itemSb.append(number);
            }
            if (itemSb.length() <= 0) continue;
            hisTblName = schemeInfo.getHisTableName();
            horTblName = schemeInfo.getHorTableName();
            selectSb.append(" select '").append(strCmpSchemeID).append("' as FCmpSchemeId,T.FPersonId ,").append(itemSumSb);
            if (DateTimeUtils.dayAfter((Date)schemeInfo.getCmpPeriod().getBeginDate(), (Date)cmpPeriod.getBeginDate()) && hisTblName != null) {
                selectSb.append(" from ").append(hisTblName).append(" T ").append(" inner join t_hr_cmpperiod p on p.fid = T.fperiod ").append(" inner join ").append(tempPersonTable).append(" personTab on personTab.fpersonid = T.FPersonId  and T.FAdminOrgUnitID = personTab.FAdminOrgUnitID").append(" where p.fnumber = '").append(cmpPeriod.getNumber()).append("'");
                selectSb.append(" and ((t.FPositionID is null and personTab.FPositionID is null) or (t.FPositionID = personTab.FPositionID)) ");
            } else {
                if (!DateTimeUtils.dayEquals((Date)schemeInfo.getCmpPeriod().getBeginDate(), (Date)cmpPeriod.getBeginDate()) || horTblName == null) continue;
                if (schemeInfo.getTime() > 1) {
                    selectSb.append(" from t_hr_cmpperiod p ").append(" inner join  ").append(" (select FPersonId,FAdminOrgUnitID,FPositionID,fperiod,").append(itemSb).append(" from ").append(hisTblName).append(" union all select FPersonId,FAdminOrgUnitID,FPositionID,fperiod,").append(itemSb).append(" from ").append(horTblName).append(") T on p.fid = T.fperiod");
                    selectSb.append(" inner join ").append(tempPersonTable).append(" personTab on personTab.fpersonid = T.FPersonId ").append(" and T.FAdminOrgUnitID = personTab.FAdminOrgUnitID ").append(" where p.fnumber = '").append(cmpPeriod.getNumber()).append("'");
                    selectSb.append(" and ((t.FPositionID is null and personTab.FPositionID is null) or (T.FPositionID = personTab.FPositionID)) ");
                } else {
                    selectSb.append(" from ").append(horTblName).append(" T ");
                    selectSb.append(" inner join ").append(tempPersonTable).append(" personTab on personTab.fpersonid = T.FPersonId ").append(" and T.FAdminOrgUnitID = personTab.FAdminOrgUnitID ");
                    selectSb.append(" and ((T.FPositionID is null and personTab.FPositionID is null) or (T.FPositionID = personTab.FPositionID)) ");
                }
            }
            selectSb.append(" group by T.FPersonId ");
            StringBuffer insertSql = new StringBuffer();
            insertSql.append(" insert into ").append(temporaryTableName).append(" (FCmpSchemeId,FPersonId,").append(itemSb).append(")").append(selectSb);
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            if (!isShowTaxRate) continue;
            isYearSalary = this.isYearSalary(schemeItemColl);
            updateSql = new StringBuffer();
            String strTemp = "horTb.FSAL014";
            if (isYearSalary && isYearbonus) {
                strTemp = "horTb.FSAL014/12.0";
            }
            String strFieldName = "(select top 1 T_HR_TAXRATELIST.ftaxrate,T_HR_TAXRATELIST.ffastSub from T_HR_TAXRATELIST where FUsePeriod = '" + paramInfo.GetUsePeriod() + "'  and fbeginpoint <" + strTemp + " and fendpoint >= " + strTemp + ")";
            updateSql.append(" update ").append(temporaryTableName).append(" as horTb set (FTaxRate,FFastSub) = ").append(strFieldName).append(" where fpersonid in(").append(" select T1.fpersonid from v_hr_taxperson T1 inner join ").append(tempPersonTable).append(" T2 on t2.fpersonid = t1.fpersonid ").append("where t1.fcmpschemeid ='" + strCmpSchemeID + "' ").append(")");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        return temporaryTableName;
    }

    private String createPersonTempTable(Context ctx, EntityViewInfo personViewInfo, List adminColl, CmpPeriodInfo cmpPeriod, List schemeInfos) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        CmpSchemeInfo schemeInfo = null;
        String hisTblName = null;
        String horTblName = null;
        for (int i = 0; i < schemeInfos.size(); ++i) {
            schemeInfo = (CmpSchemeInfo)schemeInfos.get(i);
            hisTblName = schemeInfo.getHisTableName();
            horTblName = schemeInfo.getHorTableName();
            String tableName = null;
            String horSql = " select fpersonid,fadminorgunitid,FPositionID,fperiod from " + schemeInfo.getHorTableName();
            String hisSql = null;
            if (hisTblName != null) {
                hisSql = " select fpersonid,fadminorgunitid,FPositionID ,fperiod from " + schemeInfo.getHisTableName();
            }
            if (DateTimeUtils.dayAfter((Date)schemeInfo.getCmpPeriod().getBeginDate(), (Date)cmpPeriod.getBeginDate()) && hisTblName != null) {
                tableName = hisSql;
            } else if (DateTimeUtils.dayEquals((Date)schemeInfo.getCmpPeriod().getBeginDate(), (Date)cmpPeriod.getBeginDate()) && horTblName != null) {
                tableName = schemeInfo.getTime() > 1 ? horSql + " UNION all " + hisSql : horSql;
            }
            if (tableName == null) continue;
            if (sb.length() > 0) {
                sb.append(" UNION ALL ");
            }
            sb.append(tableName);
        }
        if (sb == null || sb.length() <= 0) {
            return null;
        }
        String sql = null;
        MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.PersonInfoQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        exec.setObjectView(personViewInfo);
        sql = exec.getSQL();
        sql = HRSchemeUtils.getReplaceQuerySQL(ctx, sql.toString());
        if (sb != null) {
            sql = StringUtils.replaceIgnoreCase((String)sql, (String)"T_HR_CMPSCHEMEPERSON".toLowerCase(), (String)("(" + sb + ")"));
            while (sql.indexOf("\"CMPSCHEMEPERSON\"") > -1) {
                sql = StringUtils.replaceIgnoreCase((String)sql, (String)"\"CMPSCHEMEPERSON\"".toLowerCase(), (String)"Temp");
            }
        }
        StringBuffer adminIDs = new StringBuffer();
        if (adminColl != null) {
            AdminOrgUnitInfo adminInfo = null;
            for (int i = 0; i < adminColl.size(); ++i) {
                adminInfo = (AdminOrgUnitInfo)adminColl.get(i);
                if (adminIDs.length() > 0) {
                    adminIDs.append(",");
                }
                adminIDs.append("'").append(adminInfo.getId()).append("'");
            }
        }
        if (adminColl == null || adminColl.size() == 0) {
            adminIDs.append("''");
        }
        int fromPos = sql.indexOf("FROM");
        int wherePos = sql.indexOf("WHERE");
        String whereSql = sql.substring(wherePos);
        String fromSubSql = sql.substring(fromPos, wherePos);
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select distinct \"PERSON\".FID AS FPERSONID ").append(",\"ATTACHDEPT\".FID AS fAdminOrgUnitID,\"POSITION\".FID as fpositionID ").append(fromSubSql).append(" left outer join t_hr_cmpperiod cp on cp.fid= Temp.fperiod ").append(whereSql).append(" and cp.fnumber = '").append(cmpPeriod.getNumber()).append("'").append(" and Temp.fadminorgunitid in(").append(adminIDs).append(")");
        String tempPersonDataTable = null;
        try {
            StringBuffer strSelectors = new StringBuffer();
            tempPersonDataTable = null;
            strSelectors.append(" create TABLE aa ").append(" (FPersonId varchar(44)").append(",FAdminOrgUnitID varchar(44),FpositionID varchar(44))");
            tempPersonDataTable = TempTablePool.getInstance((Context)ctx).createTempTable(strSelectors.toString());
            StringBuffer insertSql = new StringBuffer();
            insertSql.append(" insert INTO ");
            insertSql.append(tempPersonDataTable);
            insertSql.append(" ");
            insertSql.append(PersonInfoUtils.getOptimizeSql(selectSql.toString()));
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempPersonDataTable;
    }

    private boolean isYearSalary(CmpSchemeItemCollection schemeItemColl) throws BOSException {
        if (schemeItemColl == null || schemeItemColl.size() == 0) {
            return false;
        }
        boolean monthShout = false;
        boolean yearBouns = false;
        CmpItemInfo cmpItemInfo = null;
        for (int i = 0; i < schemeItemColl.size(); ++i) {
            cmpItemInfo = schemeItemColl.get(i).getCmpItem();
            if ("FSAL015".equals(cmpItemInfo.getNumber())) {
                monthShout = true;
            }
            if (!"FSAL012".equals(cmpItemInfo.getNumber())) continue;
            yearBouns = true;
        }
        return monthShout && yearBouns;
    }

    private String getSelectorStr(List cmpItemColl, boolean isShowTaxRate, String prefix) {
        CmpItemInfo itemInfo = null;
        StringBuffer strSelectors = new StringBuffer();
        int size = cmpItemColl.size();
        for (int i = 0; i < size; ++i) {
            itemInfo = (CmpItemInfo)cmpItemColl.get(i);
            if (itemInfo == null) continue;
            if (i != 0) {
                strSelectors.append(",");
            }
            if (prefix != null) {
                strSelectors.append(prefix).append("_");
            }
            strSelectors.append(itemInfo.getNumber());
            strSelectors.append(" Decimal(22,8)");
        }
        if (isShowTaxRate) {
            if (prefix != null) {
                strSelectors.append(",").append(prefix).append("_FTaxRate Decimal(22,8)").append(",").append(prefix).append("_FFastSub Decimal(22,8)");
            } else {
                strSelectors.append(",FTaxRate Decimal(22,8),FFastSub Decimal(22,8)");
            }
        }
        return strSelectors.toString();
    }

    private String getSelectPerItemString(Context ctx, TaxReportParamsInfo paramInfo, String language) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        QueryInfo query = loader.getQuery((IMetaDataPK)this.metaDataPK);
        SelectorInfo selectorInfo = query.getSelector();
        CmpItemInfo cmpItem = null;
        QueryFieldInfo filedInfo = null;
        List list = paramInfo.getPersonItemColl();
        StringBuffer selectItem = new StringBuffer();
        selectItem.append("select ");
        int size = list.size();
        block0: for (int i = 0; i < size; ++i) {
            cmpItem = (CmpItemInfo)list.get(i);
            int num = selectorInfo.size();
            for (int j = 0; j < num; ++j) {
                filedInfo = selectorInfo.get(j);
                if (!cmpItem.getNumber().equalsIgnoreCase(filedInfo.getName())) continue;
                selectItem.append(filedInfo.getShowValue()).append(" AS \"").append(filedInfo.getName()).append("\",");
                continue block0;
            }
        }
        selectItem.append("\"NATIONALITY\".FName_" + language + " AS \"NATIONALITY.NAME\"");
        return selectItem.toString();
    }
}

