/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.perf.web.PerfWebUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class CompensationWebUtils {
    private static final Logger logger = Logger.getLogger(CompensationWebUtils.class);

    public static String getCmpPeriodListXML(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int COLS = 8;
        int pageCount = Integer.parseInt(request.getParameter("pageCount"));
        int pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
        int start = (pageNumber - 1) * pageCount;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)CompensationWebUtils.getHROUnitID(ctx)));
        try {
            FilterInfo filter = new FilterInfo("shutMyCmp = 0 or shutMyCmp is null");
            filterInfo.mergeFilter(filter, "and");
        }
        catch (ParserException e1) {
            logger.error((Object)e1.getMessage(), e1.getCause());
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), e1.getCause());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("description"));
        viewInfo.getSelector().add(new SelectorItemInfo("beginDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("endDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("fiscalPeriod"));
        String xmlData = null;
        ArrayList<Object> list = null;
        try {
            IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery"));
            iqec.setObjectView(viewInfo);
            int number = iqec.getRowCount();
            IRowSet rowSet = iqec.executeQuery(start, pageCount);
            list = new ArrayList<Object>(rowSet.size() + 1);
            list.add("" + number);
            int index = 0;
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = "" + ++index;
                array[1] = rowSet.getString("id");
                array[2] = rowSet.getString("number");
                array[3] = rowSet.getString("name");
                array[4] = rowSet.getString("description");
                array[5] = rowSet.getDate("beginDate") != null ? rowSet.getDate("beginDate").toString() : "";
                array[6] = rowSet.getDate("endDate") != null ? rowSet.getDate("endDate").toString() : "";
                array[7] = rowSet.getString("fiscalPeriod");
                list.add(array);
            }
            xmlData = PerfWebUtils.makeProcDataToXMLData(list, (int)COLS);
        }
        catch (Exception e) {
            xmlData = PerfWebUtils.makeErrorProcDataToXMLData((Context)ctx, (int)COLS);
        }
        return xmlData;
    }

    private static String getHROUnitID(Context ctx) {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
            return ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        }
        HROrgUnitInfo info = new HROrgUnitInfo();
        return BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
    }

    public static String getPrimaryAdminOrgUnit(Context ctx) {
        PersonPositionInfo ppInfo;
        AdminOrgUnitInfo infoAdmin = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("primaryPosition.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("primaryPosition.adminOrgUnit.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()));
        entityViewInfo.setFilter(filterInfo);
        PersonPositionCollection ppcoll = null;
        try {
            ppcoll = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(entityViewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), e.getCause());
            return "";
        }
        if (ppcoll != null && ppcoll.size() > 0 && (ppInfo = ppcoll.get(0)).getPrimaryPosition() != null) {
            infoAdmin = ppInfo.getPrimaryPosition().getAdminOrgUnit();
        }
        if (infoAdmin != null) {
            return infoAdmin.getName();
        }
        return "";
    }
}

