/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeFactory;
import com.kingdee.eas.hr.compensation.IEmpCmpSchmFacade;
import com.kingdee.eas.hr.compensation.ISalariatHiberProps;
import com.kingdee.eas.hr.compensation.ISchemeFacade;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CmpSchmTable {
    private List lstSequence = null;
    private DynamicTableInfo infoDynamicTable = null;
    private IEmpCmpSchmFacade iEmpCmpSchmFacade = null;
    private IObjectPK pk = null;
    private String strCmpSchemeID = null;
    private String strSalSchemeID = null;
    private KDTable table = null;
    private int iSchemeType = 0;
    private Hashtable hst = new Hashtable();
    private Map pointMap = null;
    private Map salMap = null;

    public CmpSchmTable(String strCmpSchemeID, String strSalSchemeID, KDTable table, int iSchemeType) throws Exception {
        this.strCmpSchemeID = strCmpSchemeID;
        this.strSalSchemeID = strSalSchemeID;
        this.table = table;
        this.iSchemeType = iSchemeType;
        this.createDynamicTable();
    }

    public void createDynamicTable() throws Exception {
        this.table.setRefresh(false);
        this.infoDynamicTable = HRDynamicTableUtils.getCmpSchemeDynamicTableInfo(this.strCmpSchemeID, this.iSchemeType);
        HRDynamicTableUtils.createTableHead(this.table, this.infoDynamicTable);
        this.initData();
        this.table.getDataRequestManager().setPageRowCount(HRDynamicTableUtils.getVirtualModePageSize());
        this.fillTableData(0, HRDynamicTableUtils.getVirtualModePageSize());
        this.initTableListener();
        this.table.setRefresh(true);
    }

    private void initData() throws Exception {
        this.iEmpCmpSchmFacade = EmpCmpSchmFacadeFactory.getRemoteInstance();
        this.pk = new ObjectUuidPK(BOSUuid.read((String)this.strCmpSchemeID));
        this.lstSequence = this.iEmpCmpSchmFacade.getEmpCompenseDataPKs(this.pk, null);
        this.pointMap = HRUtils.getPointValueMap(this.strSalSchemeID);
        this.salMap = this.getSalPointInfo();
    }

    public void initTableListener() throws Exception {
        this.table.getSelectManager().setSelectMode(10);
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){
            private int currentRow = -1;

            public void editValueChanged(KDTEditEvent e) {
                IRow iRow = CmpSchmTable.this.table.getRow(this.currentRow);
                if (iRow == null) {
                    return;
                }
                ICell iCell = iRow.getCell("FPersonID");
                String id = iCell.getValue().toString();
                CmpSchmTable.this.hst.put(id, this.currentRow);
                HRDynamicTableUtils.setEditedCellColor(e);
            }

            public void editStarting(KDTEditEvent e) {
                ICellEditor editor;
                Component component;
                super.editStarting(e);
                KDTable table = (KDTable)e.getSource();
                IColumn iColumn1 = table.getColumn("FSAL000");
                if (iColumn1 != null && CmpSchmTable.this.strSalSchemeID != null && (component = (editor = table.getEditManager().getEditor()).getComponent()) instanceof KDBizPromptBox) {
                    KDBizPromptBox kdBiz = (KDBizPromptBox)component;
                    SalariatPointPromptBox pointPromtBox = (SalariatPointPromptBox)kdBiz.getSelector();
                    if (pointPromtBox == null) {
                        pointPromtBox = new SalariatPointPromptBox();
                        kdBiz.setSelector((KDPromptSelector)pointPromtBox);
                    }
                    pointPromtBox.putParameter("schemeID", CmpSchmTable.this.strSalSchemeID);
                }
            }

            public void editStopping(KDTEditEvent e) {
                this.currentRow = CmpSchmTable.this.table.getEditManager().getEditRowIndex();
                if (e.getOldValue() != e.getValue()) {
                    this.editValueChanged(e);
                }
            }
        });
        this.table.getMouseListeners();
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    e.getRowIndex();
                }
            }
        });
    }

    private void fillTableData(int firstRow, int lastRow) {
        Object obj;
        if (this.lstSequence == null) {
            return;
        }
        ArrayList lstTemp = new ArrayList();
        int count = this.lstSequence.size();
        for (int i = firstRow; i <= lastRow && i < count && (obj = this.lstSequence.get(i)) != null; ++i) {
            lstTemp.add(this.lstSequence.get(i));
        }
        try {
            if (lstTemp.isEmpty()) {
                return;
            }
            IRowSet iRowSet = this.iEmpCmpSchmFacade.getEmpCompenseData(this.pk, lstTemp, null);
            HRDynamicTableUtils.fillDynamicTableData(this.strCmpSchemeID, this.strSalSchemeID, this.table, this.infoDynamicTable, iRowSet, this.salMap, this.iSchemeType);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e);
        }
    }

    public void saveData() throws Exception {
        if (this.hst.isEmpty()) {
            return;
        }
        if (this.infoDynamicTable == null) {
            return;
        }
        ArrayList<Object[]> lstValue = new ArrayList<Object[]>();
        ArrayList<DynamicTableInfo.ColumnInfo> lstColumn = new ArrayList<DynamicTableInfo.ColumnInfo>();
        DynamicTableInfo.ColumnInfo[] infosColumn = this.infoDynamicTable.getInfosColumn();
        DynamicTableInfo.ColumnInfo infoColumn2 = null;
        for (DynamicTableInfo.ColumnInfo infoColumn2 : infosColumn) {
            infoColumn2.setEditor(null);
            infoColumn2.setRenderer(null);
            if (infoColumn2.isReadOnly()) continue;
            lstColumn.add(infoColumn2);
        }
        int countRow = this.hst.size();
        int countColumn = lstColumn.size();
        Object[] objRow = this.hst.values().toArray();
        Object[] objValue = null;
        IRow iRow = null;
        for (int i = 0; i < countRow; ++i) {
            objValue = new Object[countColumn];
            int index = (Integer)objRow[i];
            iRow = this.table.getRow(index);
            String number = null;
            ICell iCell = null;
            for (int j = 0; j < countColumn; ++j) {
                Object obj;
                number = ((DynamicTableInfo.ColumnInfo)lstColumn.get(j)).getColumnNumber();
                iCell = iRow.getCell(number);
                objValue[j] = iCell.getValue();
                if (!number.equalsIgnoreCase("FSAL000") || (obj = iCell.getValue()) == null) continue;
                SalariatHiberPropsInfo infoSal = (SalariatHiberPropsInfo)obj;
                objValue[j] = infoSal.getId();
            }
            lstValue.add(objValue);
        }
        ISchemeFacade iSchemeFacade = SchemeFacadeFactory.getRemoteInstance();
        iSchemeFacade.updateEmpCmpSchmTable(this.infoDynamicTable.getName(), lstColumn, lstValue);
        HRSchemeUtils.showSubmitSuccess();
    }

    public void refresh() throws Exception {
        int index = this.table.getSelectManager().getActiveRowIndex();
        this.table.getSelectManager().select(index, 0);
        this.hst.clear();
    }

    public void matchingSal() throws Exception {
        Object sequence;
        if (this.strSalSchemeID == null) {
            return;
        }
        this.iEmpCmpSchmFacade = EmpCmpSchmFacadeFactory.getRemoteInstance();
        Hashtable<Object, Object> hst = new Hashtable<Object, Object>();
        ArrayList empSeqList = new ArrayList();
        KDTSelectBlock sb = null;
        int size = this.table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.table.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                sequence = this.lstSequence.get(j);
                hst.put(j, sequence);
                empSeqList.add(sequence);
            }
        }
        if (hst.isEmpty()) {
            return;
        }
        Map map = this.iEmpCmpSchmFacade.getEmpSalariatPoint(this.strCmpSchemeID, this.strSalSchemeID, empSeqList, null);
        if (map == null || map.isEmpty()) {
            return;
        }
        Enumeration enum0 = hst.keys();
        while (enum0.hasMoreElements()) {
            Integer rowCount = (Integer)enum0.nextElement();
            sequence = (Integer)hst.get(rowCount);
            Object objSalPointID = map.get(sequence);
            if (objSalPointID == null) continue;
            if (this.pointMap == null) {
                this.pointMap = HRUtils.getPointValueMap(this.strSalSchemeID);
            }
            IRow iRow = this.table.getRow(rowCount.intValue());
            ICell iCell = iRow.getCell("FPersonID");
            Object objPersonID = iCell.getValue();
            iCell = iRow.getCell("FSAL000");
            Object objSalPoint = this.pointMap.get(objSalPointID);
            if (objSalPoint == null) continue;
            iCell.setValue(objSalPoint);
            hst.put(objPersonID, rowCount);
        }
    }

    public void synchSalData() throws Exception {
        KDTSelectBlock sb = null;
        int size = this.table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.table.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                this.setSalPointItemValue(j);
            }
        }
    }

    private void setSalPointItemValue(int indexRow) throws Exception {
        SalariatHiberPropsInfo infoSal;
        String id;
        Object obj = HRTableTools.getTableSelectCellValue(this.table, "FSAL000", indexRow);
        if (obj != null && this.pointMap.get(id = (infoSal = (SalariatHiberPropsInfo)obj).getId().toString()) != null) {
            IRow iRow = this.table.getRow(indexRow);
            Map pointValueMap = (Map)this.pointMap.get(id);
            Iterator itr = pointValueMap.keySet().iterator();
            String number = null;
            ICell iCell = null;
            while (itr.hasNext()) {
                number = itr.next().toString();
                iCell = iRow.getCell(number);
                if (iCell == null) continue;
                iCell.setValue(pointValueMap.get(number));
            }
        }
    }

    private Hashtable getSalPointInfo() throws Exception {
        Hashtable<String, SalariatHiberPropsInfo> hst = new Hashtable<String, SalariatHiberPropsInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme", (Object)this.strSalSchemeID));
        evi.setFilter(filterInfoItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("id"));
        ISalariatHiberProps iSalariatHiberProps = SalariatHiberPropsFactory.getRemoteInstance();
        SalariatHiberPropsCollection col = iSalariatHiberProps.getSalariatHiberPropsCollection(evi);
        if (col == null || col.size() <= 0) {
            return null;
        }
        Iterator itr = col.iterator();
        SalariatHiberPropsInfo info = null;
        while (itr.hasNext()) {
            info = (SalariatHiberPropsInfo)itr.next();
            hst.put(info.getId().toString(), info);
        }
        return hst;
    }
}

