/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.contract.ContractAttachmentException;
import com.kingdee.eas.hr.contract.ContractAttachmentReverseFactory;
import com.kingdee.eas.hr.contract.ContractAttachmentReverseInfo;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.IContractAttachmentReverse;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtCollection;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class SHRContractUploadAttachmentUtils {
    private static final ReentrantLock lock = new ReentrantLock();
    private static volatile Map<String, String> contractAttachUipk = null;
    private static Map<String, IContractAttachmentReverse> ContractAttachmentReverse;

    public static Map<String, String> getContractAttachUipk() {
        return contractAttachUipk;
    }

    public static void setContractAttachUipk(Map<String, String> contractAttachUipk) {
        SHRContractUploadAttachmentUtils.contractAttachUipk = contractAttachUipk;
    }

    public static AttachmentInfo copyAttachmentInfoAndBoAttchAssoInfo(Context ctx, AttachmentInfo attachment, IAttachment attachmentInstance) throws BOSException, EASBizException {
        AttachmentInfo attachmentClone = (AttachmentInfo)attachment.clone();
        BOSUuid attachmentID = BOSUuid.create((String)attachment.getBOSType().toString());
        attachmentClone.setId(attachmentID);
        attachmentClone.setAttachID("" + System.currentTimeMillis());
        attachmentClone.put("boAttchAsso", null);
        attachmentInstance.save((CoreBaseInfo)attachmentClone);
        return attachmentClone;
    }

    public static SelectorItemCollection getSHRAttachmentExtSelectorItemCollection() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("description"));
        selectors.add(new SelectorItemInfo("simpleName"));
        selectors.add(new SelectorItemInfo("propertyName"));
        selectors.add(new SelectorItemInfo("type"));
        selectors.add(new SelectorItemInfo("state"));
        selectors.add(new SelectorItemInfo("bunding"));
        selectors.add(new SelectorItemInfo("boID"));
        selectors.add(new SelectorItemInfo("attachment.*"));
        return selectors;
    }

    public static String getReverseUipk(Context ctx, String bosType) throws BOSException, ContractAttachmentException {
        lock.lock();
        try {
            if (contractAttachUipk == null) {
                contractAttachUipk = new HashMap<String, String>();
                String sql = "select FBosType,FUipk from T_HR_ContractAttachmentUipk";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rs.next()) {
                    contractAttachUipk.put(rs.getString(1), rs.getString(2));
                }
                if (contractAttachUipk != null && StringUtils.isEmpty((String)contractAttachUipk.get(bosType))) {
                    throw new ContractAttachmentException(ContractAttachmentException.CONTRACT_REVERSE_LINK_UIPK);
                }
                String string = contractAttachUipk.get(bosType);
                return string;
            }
            String sql = contractAttachUipk.get(bosType);
            return sql;
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public static Boolean IsContractAttachmentReverse(Context ctx, String billEntryId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("billEntryId", (Object)billEntryId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        boolean iSReverse = SHRContractUploadAttachmentUtils.getContractAttachmentReverseInterface(ctx).exists(filter);
        return iSReverse;
    }

    public static void saveContractAttachmentReverse(Context ctx, String billEntryId) throws EASBizException, BOSException {
        Boolean isContractAttachmentReverse = SHRContractUploadAttachmentUtils.IsContractAttachmentReverse(ctx, billEntryId);
        if (isContractAttachmentReverse.booleanValue()) {
            return;
        }
        ContractAttachmentReverseInfo contractAttachmentReverseInfo = new ContractAttachmentReverseInfo();
        String bosType = BOSUuid.read((String)billEntryId).getType().toString();
        contractAttachmentReverseInfo.setBillEntryId(billEntryId);
        contractAttachmentReverseInfo.setBosType(bosType);
        SHRContractUploadAttachmentUtils.getContractAttachmentReverseInterface(ctx).addnew(contractAttachmentReverseInfo);
    }

    public static void deleteContractAttachmentReverse(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billID.getType());
        HRBillBaseInfo model = (HRBillBaseInfo)iCoreBillBase.getValue((IObjectPK)new ObjectUuidPK(billID));
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        HRBillBaseEntryInfo entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (HRBillBaseEntryInfo)entries.getObject(i);
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("billEntryId", (Object)entry.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            SHRContractUploadAttachmentUtils.getContractAttachmentReverseInterface(ctx).delete(filter);
        }
    }

    public static void deleteContractAttachment(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billID.getType());
        HRBillBaseInfo model = (HRBillBaseInfo)iCoreBillBase.getValue((IObjectPK)new ObjectUuidPK(billID));
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        ISHRAttachmentExt attachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        FilterInfo entryFilter = new FilterInfo();
        entryFilter.getFilterItems().add(new FilterItemInfo("boID", (Object)billID.toString()));
        EntityViewInfo entryEntityView = new EntityViewInfo();
        entryEntityView.setFilter(entryFilter);
        entryEntityView.setSelector(SHRContractUploadAttachmentUtils.getSHRAttachmentExtSelectorItemCollection());
        SHRAttachmentExtCollection collection = attachmentExt.getSHRAttachmentExtCollection(entryEntityView);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            SHRAttachmentExtInfo shrAttachmentExtInfo = collection.get(i);
            AttachmentInfo attachment = shrAttachmentExtInfo.getAttachment();
            if (attachment == null || attachment.getId() == null || arrayList.contains(attachment.getId().toString())) continue;
            arrayList.add(attachment.getId().toString());
        }
        HRBillBaseEntryInfo entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (HRBillBaseEntryInfo)entries.getObject(i);
            FilterInfo hrContractFilter = new FilterInfo();
            hrContractFilter.getFilterItems().add(new FilterItemInfo("entryID", (Object)entry.getId().toString(), CompareType.EQUALS));
            EntityViewInfo hrContractEntityView = new EntityViewInfo();
            hrContractEntityView.setFilter(hrContractFilter);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("employeeContract.id"));
            hrContractEntityView.setSelector(selectors);
            HRContractInfoCollection hrContractInfoCollection = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection(hrContractEntityView);
            for (int j = 0; j < hrContractInfoCollection.size(); ++j) {
                HRContractInfoInfo hrContractInfoInfo = hrContractInfoCollection.get(j);
                EmployeeContractInfo employeeContract = hrContractInfoInfo.getEmployeeContract();
                String contractId = "";
                if (employeeContract != null && employeeContract.getId() != null) {
                    contractId = employeeContract.getId().toString();
                }
                FilterInfo contractFilter = new FilterInfo();
                contractFilter.getFilterItems().add(new FilterItemInfo("boID", (Object)contractId));
                EntityViewInfo contractEntityViewInfo = new EntityViewInfo();
                contractEntityViewInfo.setFilter(contractFilter);
                contractEntityViewInfo.setSelector(SHRContractUploadAttachmentUtils.getSHRAttachmentExtSelectorItemCollection());
                SHRAttachmentExtCollection contractCollection = attachmentExt.getSHRAttachmentExtCollection(contractEntityViewInfo);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int k = 0; k < contractCollection.size(); ++k) {
                    SHRAttachmentExtInfo shrAttachmentExtInfo = contractCollection.get(k);
                    AttachmentInfo attachment = shrAttachmentExtInfo.getAttachment();
                    if (attachment == null || attachment.getId() == null || !arrayList.contains(attachment.getId().toString())) continue;
                    hashMap.put(attachment.getId().toString(), shrAttachmentExtInfo.getBoID());
                }
                for (Map.Entry entryAttchemt : hashMap.entrySet()) {
                    SHRContractUploadAttachmentUtils.deleteSHRAttachmentExtAndBoAttchAsso(ctx, (String)entryAttchemt.getKey(), (String)entryAttchemt.getValue());
                }
            }
        }
    }

    public static void deleteSHRAttachmentExtAndBoAttchAsso(Context ctx, String attachmentId, String boid) throws BOSException {
        String deleteAttachmentSql = "delete from T_HR_SHRAttachmentExt where FBoID = '" + boid + "' and FAttachment = '" + attachmentId + "'";
        deleteAttachmentSql = deleteAttachmentSql + "; delete from T_BAS_BoAttchAsso where FBoID = '" + boid + "' and FAttachmentID = '" + attachmentId + "'";
        DbUtil.execute((Context)ctx, (String)deleteAttachmentSql);
    }

    private static IContractAttachmentReverse getContractAttachmentReverseInterface(Context ctx) throws BOSException {
        IContractAttachmentReverse IContractAttachmentReverse2;
        if (ContractAttachmentReverse == null) {
            ContractAttachmentReverse = new HashMap<String, IContractAttachmentReverse>();
        }
        if ((IContractAttachmentReverse2 = ContractAttachmentReverse.get("com.kingdee.eas.hr.contract.app.ContractAttachmentReverse")) == null) {
            try {
                IContractAttachmentReverse2 = ContractAttachmentReverseFactory.getLocalInstance(ctx);
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw e;
            }
            ContractAttachmentReverse.put("com.kingdee.eas.hr.contract.app.ContractAttachmentReverse", IContractAttachmentReverse2);
        }
        return IContractAttachmentReverse2;
    }
}

