/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonHisCollection;
import com.kingdee.eas.basedata.person.PersonHisFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairUnAuditException;
import com.kingdee.eas.hr.affair.RiseBizBillEntryCollection;
import com.kingdee.eas.hr.affair.RiseBizBillEntryFactory;
import com.kingdee.eas.hr.affair.RiseBizBillEntryInfo;
import com.kingdee.eas.hr.affair.RiseBizBillInfo;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPostRankChangeInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmpPosJobGradeRelationCollection;
import com.kingdee.eas.hr.emp.EmpPosJobGradeRelationFactory;
import com.kingdee.eas.hr.emp.EmpPosJobGradeRelationInfo;
import com.kingdee.eas.hr.emp.EmpPostRankCollection;
import com.kingdee.eas.hr.emp.EmpPostRankException;
import com.kingdee.eas.hr.emp.EmpPostRankFactory;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.hr.emp.EmpPostRankSourceEnum;
import com.kingdee.eas.hr.emp.EmployeeBosBizException;
import com.kingdee.eas.hr.emp.IEmpPostRank;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.AbstractEmpPostRankOptFacadeControllerBean;
import com.kingdee.eas.hr.emp.app.util.EmpPostRankUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpOrgRelationTool;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpPostRankUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class EmpPostRankOptFacadeControllerBean
extends AbstractEmpPostRankOptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpPostRankOptFacadeControllerBean");
    private EmpPostRankChangeInfo empPostRankChangeInfo = null;
    private HRBizDefineInfo hrBizDefineInfo = null;
    private HRBizData hrbizData = null;
    private boolean isUseOldEmpPostRank;
    private boolean isSupplementBill = false;

    @Override
    protected void _updateNewestEmpPostRank(Context ctx, EmpPostRankInfo empPostRankInfo) throws BOSException, EASBizException {
        IEmpPostRank eprBean = EmpPostRankFactory.getLocalInstance(ctx);
        if (empPostRankInfo.getId() != null && eprBean.exists((IObjectPK)new ObjectUuidPK(empPostRankInfo.getId()))) {
            EmpPostRankInfo eprInfo = eprBean.getEmpPostRankInfo((IObjectPK)new ObjectUuidPK(empPostRankInfo.getId()));
            if (empPostRankInfo.get("bizDate") != null) {
                Date bizDate = (Date)empPostRankInfo.get("bizDate");
                if (eprInfo.getEFFDT().equals(bizDate)) {
                    eprBean.update((IObjectPK)new ObjectUuidPK(empPostRankInfo.getId()), empPostRankInfo);
                }
            } else if (eprInfo.isIsLatest()) {
                eprBean.update((IObjectPK)new ObjectUuidPK(empPostRankInfo.getId()), empPostRankInfo);
            }
        }
    }

    @Override
    protected void _deleteNewestEmpPostRank(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IEmpPostRank iEmpPostRank = EmpPostRankFactory.getLocalInstance(ctx);
        EmpPostRankInfo empPostRankInfo = iEmpPostRank.getEmpPostRankInfo(pk);
        EmpPostRankSourceEnum sourceEnum = empPostRankInfo.getSource();
        if (!empPostRankInfo.isIsLatest()) {
            throw new EmployeeBosBizException(EmployeeBosBizException.ONLY_SUP_NEW);
        }
        EmpPosOrgRelationCollection posCollection = null;
        String oql = "select empPosOrgRelation.* where empPostRank.id ='" + empPostRankInfo.getId().toString() + "'";
        EmpPosJobGradeRelationCollection relationColl = EmpPosJobGradeRelationFactory.getLocalInstance(ctx).getEmpPosJobGradeRelationCollection(oql);
        if (relationColl.size() > 0) {
            posCollection = new EmpPosOrgRelationCollection();
            int size = relationColl.size();
            for (int i = 0; i < size; ++i) {
                EmpPosJobGradeRelationInfo jobGradeRelationInfo = relationColl.get(i);
                EmpPosOrgRelationInfo posOrgInfo = jobGradeRelationInfo.getEmpPosOrgRelation();
                EmpPosJobGradeRelationFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(jobGradeRelationInfo.getId()));
                posCollection.add(posOrgInfo);
            }
        }
        iEmpPostRank.delete(pk);
        HRBizDefineInfo hrBizDefineInfo = null;
        if (sourceEnum.equals((Object)EmpPostRankSourceEnum.personChange) || sourceEnum.equals((Object)EmpPostRankSourceEnum.personRise)) {
            Date effdt = empPostRankInfo.getEFFDT();
            EmpPostRankInfo lastEmpPostRankInfo = EmpPostRankUtil.getPersonBeforeAppointDateEmpPostRankInfo(ctx, empPostRankInfo.getPerson().getId().toString(), effdt);
            if (lastEmpPostRankInfo != null) {
                lastEmpPostRankInfo.setIsLatest(Boolean.TRUE);
                oql = "select empPosOrgRelation.* where empPostRank.id ='" + lastEmpPostRankInfo.getId().toString() + "' order by startDateTime desc";
                relationColl = EmpPosJobGradeRelationFactory.getLocalInstance(ctx).getEmpPosJobGradeRelationCollection(oql);
                if (relationColl.size() > 0) {
                    EmpPosJobGradeRelationInfo jobGradeRelationInfo = relationColl.get(0);
                    EmpPosOrgRelationInfo posOrgInfo = jobGradeRelationInfo.getEmpPosOrgRelation();
                    hrBizDefineInfo = posOrgInfo.getAction();
                    hrBizDefineInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(hrBizDefineInfo.getId()));
                }
                EmpPostRankSourceEnum lastsourceEnum = lastEmpPostRankInfo.getSource();
                if ((lastEmpPostRankInfo.getLEFFDT().equals(DateUtil.getBeforeDay((Date)effdt)) || lastEmpPostRankInfo.getLEFFDT().equals(effdt)) && !lastsourceEnum.equals((Object)EmpPostRankSourceEnum.init)) {
                    lastEmpPostRankInfo.setLEFFDT(HistoryUtil.getMaxDate());
                    Date rankEndDate = this.getRankEndDate(ctx, empPostRankInfo.getPerson());
                    if (!com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayBefore((Date)lastEmpPostRankInfo.getEFFDT(), (Date)rankEndDate)) {
                        rankEndDate = HistoryUtil.getMaxDate();
                    }
                    lastEmpPostRankInfo.setRankEndDate(rankEndDate);
                }
                EmpPostRankFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(lastEmpPostRankInfo.getId().toString()), lastEmpPostRankInfo);
                if (posCollection != null) {
                    int size = posCollection.size();
                    for (int i = 0; i < size; ++i) {
                        EmpPosOrgRelationInfo posOrgInfo = posCollection.get(i);
                        EmpPosJobGradeRelationInfo jobGradeRelationInfo = new EmpPosJobGradeRelationInfo();
                        jobGradeRelationInfo.setEmpPosOrgRelation(posOrgInfo);
                        jobGradeRelationInfo.setEmpPostRank(lastEmpPostRankInfo);
                        jobGradeRelationInfo.setEffdt(posOrgInfo.getEFFDT());
                        jobGradeRelationInfo.setPerson(lastEmpPostRankInfo.getPerson());
                        jobGradeRelationInfo.setStartDateTime(posOrgInfo.getStartDateTime());
                        EmpPosJobGradeRelationFactory.getLocalInstance(ctx).addnew(jobGradeRelationInfo);
                    }
                }
            }
        }
    }

    private boolean isEndDateAction(HRBizDefineTypeEnum type) {
        return HRBizDefineTypeEnum.RESIGN.equals((Object)type) || HRBizDefineTypeEnum.RETIRE.equals((Object)type) || HRBizDefineTypeEnum.REINVITEFIRE.equals((Object)type);
    }

    @Override
    protected IObjectPK _addNewEmpPostRank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isEquals;
        EmpPostRankInfo lastEmpPostRankInfo;
        EmpPostRankInfo empPostRankInfo = (EmpPostRankInfo)model;
        PersonInfo personInfo = empPostRankInfo.getPerson();
        IObjectPK pk = null;
        this.validateInfo(ctx, empPostRankInfo);
        Date effdt = empPostRankInfo.getEFFDT();
        EmpPostRankSourceEnum sourceEnum = empPostRankInfo.getSource();
        if (sourceEnum.equals((Object)EmpPostRankSourceEnum.personChange) && (lastEmpPostRankInfo = this.getAppointDateEmpPostRank(ctx, personInfo, effdt)) != null && !(isEquals = this.isEqualsTwoEmpPostRankInfo(lastEmpPostRankInfo, empPostRankInfo))) {
            this.endPreEmpPostRankInfo(ctx, lastEmpPostRankInfo, empPostRankInfo, true);
        }
        pk = EmpPostRankFactory.getLocalInstance(ctx).addnew(empPostRankInfo);
        return pk;
    }

    private EmpPostRankInfo getAppointDateEmpPostRank(Context ctx, PersonInfo personInfo, Date effdt) throws BOSException {
        String oql = " where person = '" + personInfo.getId().toString() + "' and effdt <= " + HRUtilExtend.getDateStringWithoutMininuteTs((Date)effdt) + "and leffdt >= " + HRUtilExtend.getDateStringWithoutMininuteTs((Date)effdt);
        EmpPostRankCollection empPostRankCollection = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(oql);
        EmpPostRankInfo lastEmpPostRankInfo = null;
        if (empPostRankCollection != null && empPostRankCollection.size() > 0) {
            lastEmpPostRankInfo = empPostRankCollection.get(0);
        }
        return lastEmpPostRankInfo;
    }

    private void endPreEmpPostRankInfo(Context ctx, EmpPostRankInfo lastEmpPostRankInfo, EmpPostRankInfo empPostRankInfo, boolean updateEndDate) throws EASBizException, BOSException {
        Date effdt = empPostRankInfo.getEFFDT();
        Date endDate = DateUtil.getBeforeDay((Date)effdt);
        lastEmpPostRankInfo.setLEFFDT(endDate);
        SelectorItemCollection selectors = new SelectorItemCollection();
        SelectorItemInfo selectorItem1 = new SelectorItemInfo("LEFFDT");
        selectors.add(selectorItem1);
        if (updateEndDate || com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayEquals((Date)lastEmpPostRankInfo.getRankEndDate(), (Date)HRUtil.getMaxEndDate())) {
            SelectorItemInfo selectorItem2 = new SelectorItemInfo("rankEndDate");
            lastEmpPostRankInfo.setRankEndDate(endDate);
            selectors.add(selectorItem2);
        }
        EmpPostRankFactory.getLocalInstance(ctx).updatePartial(lastEmpPostRankInfo, selectors);
    }

    private void validateInfo(Context ctx, EmpPostRankInfo empPostRankInfo) throws EmpPostRankException {
        if (empPostRankInfo.getEFFDT() == null) {
            throw new EmpPostRankException(EmpPostRankException.EFFDT_NULL);
        }
        if (empPostRankInfo.getLEFFDT() == null) {
            throw new EmpPostRankException(EmpPostRankException.LEFFDT_NULL);
        }
    }

    private boolean isEqualsTwoEmpPostRankInfo(EmpPostRankInfo lastEmpPostRankInfo, EmpPostRankInfo empPostRankInfo) throws EmpPostRankException {
        if (lastEmpPostRankInfo == null && empPostRankInfo != null) {
            return false;
        }
        if (lastEmpPostRankInfo != null && empPostRankInfo == null) {
            return false;
        }
        if (lastEmpPostRankInfo != null && empPostRankInfo != null) {
            return HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)lastEmpPostRankInfo.getJobLevel(), (CoreBaseInfo)empPostRankInfo.getJobLevel()) && HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)lastEmpPostRankInfo.getJobGrade(), (CoreBaseInfo)empPostRankInfo.getJobGrade()) && HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)lastEmpPostRankInfo.getHrOrgUnit(), (CoreBaseInfo)empPostRankInfo.getHrOrgUnit());
        }
        return false;
    }

    @Override
    protected IObjectValue _personChangeToEmpPostRank(Context ctx, EmpPostRankChangeInfo empPostRankChangeInfo) throws BOSException, EASBizException {
        this.empPostRankChangeInfo = empPostRankChangeInfo;
        this.hrBizDefineInfo = empPostRankChangeInfo.getHrBizDefineInfo();
        this.hrbizData = empPostRankChangeInfo.getHrBizData();
        EmpPostRankInfo empPostRankInfoFromBill = empPostRankChangeInfo.getEmpPostRankInfo();
        EmpPostRankInfo empPostRankInfoProcess = null;
        IObjectPK pk = null;
        HRBizDefineTypeEnum typeEnum = this.hrBizDefineInfo.getBizDefineType();
        if (typeEnum == null) {
            throw new EmpPostRankException(EmpPostRankException.ACTION_BIZTYPE_NULL);
        }
        switch (typeEnum.getValue()) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 16: {
                pk = this.addEmpPostRankInfoWithEFFDT(ctx, empPostRankInfoFromBill);
                break;
            }
            case 10: {
                pk = this.addEmpPostRankInfoWhenFlucIn(ctx, empPostRankInfoFromBill);
                break;
            }
            case 13: {
                empPostRankInfoFromBill.setSource(EmpPostRankSourceEnum.personRise);
                pk = this.addEmpPostRankInfoWithEFFDT(ctx, empPostRankInfoFromBill);
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                this.isUseOldEmpPostRank = true;
                this.endLatestEmpPostRankEndDate(ctx, empPostRankInfoFromBill);
                break;
            }
            case 11: {
                break;
            }
            case 9: {
                this.isUseOldEmpPostRank = true;
            }
            case 14: {
                this.isUseOldEmpPostRank = true;
            }
        }
        if (StringUtils.equals((String)this.hrBizDefineInfo.getId().toString(), (String)"8r0AAAADbujmaL7Z")) {
            this.isUseOldEmpPostRank = true;
        }
        if (pk != null) {
            EmpPostRankInfo empPostRankInfo = this.getLatestEmpPostRankInfo(ctx, empPostRankChangeInfo.getEmpPostRankInfo());
            this.updateOtherPostRankInfosNotLatest(ctx, empPostRankInfo);
            empPostRankInfoProcess = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankInfo(pk);
        }
        if (!this.isSupplementBill) {
            this.createEmpPosJobGradeRelation(ctx, empPostRankInfoProcess);
        }
        return empPostRankInfoProcess;
    }

    private IObjectPK addEmpPostRankInfoWhenFlucIn(Context ctx, EmpPostRankInfo empPostRankInfoFromBill) throws EASBizException, BOSException {
        if (empPostRankInfoFromBill.getJobGrade() == null && empPostRankInfoFromBill.getJobLevel() == null) {
            this.isUseOldEmpPostRank = true;
            return null;
        }
        this.isUseOldEmpPostRank = false;
        IObjectPK pk = null;
        Date latestEFFDT = null;
        Date nowEFFDT = empPostRankInfoFromBill.getEFFDT();
        EmpPostRankInfo empPostRankInfoLatest = this.getLatestEmpPostRankInfo(ctx, empPostRankInfoFromBill);
        if (empPostRankInfoLatest == null) {
            pk = this.appendAftertheLatestNode(ctx, empPostRankInfoLatest, empPostRankInfoFromBill);
        }
        if (empPostRankInfoLatest != null) {
            latestEFFDT = empPostRankInfoLatest.getEFFDT();
            if (latestEFFDT.before(nowEFFDT)) {
                if (empPostRankInfoFromBill.getJobGrade() == null && empPostRankInfoFromBill.getJobLevel() == null) {
                    empPostRankInfoFromBill.setJobGrade(empPostRankInfoLatest.getJobGrade());
                    empPostRankInfoFromBill.setJobLevel(empPostRankInfoLatest.getJobLevel());
                }
                pk = this.appendAftertheLatestNode(ctx, empPostRankInfoLatest, empPostRankInfoFromBill);
            } else {
                throw new EmployeeBosBizException(EmployeeBosBizException.NOW_NOT_SUP_LAYER_OPTION);
            }
        }
        return pk;
    }

    private void endLatestEmpPostRankEndDate(Context ctx, EmpPostRankInfo empPostRankInfoFromBill) throws EASBizException, BOSException {
        if (empPostRankInfoFromBill.getJobGrade() == null && empPostRankInfoFromBill.getJobLevel() == null) {
            return;
        }
        EmpPostRankInfo empPostRankInfoLatest = this.getAppointDateEmpPostRank(ctx, empPostRankInfoFromBill.getPerson(), empPostRankInfoFromBill.getEFFDT());
        Date endDate = null;
        if (empPostRankInfoLatest != null) {
            boolean isSameDatePersonChange = this.hrbizData.isSameDatePersonChange();
            endDate = isSameDatePersonChange ? this.hrbizData.getStartDate() : DateUtil.getBeforeDay((Date)this.hrbizData.getStartDate());
            Date leffdt = empPostRankInfoLatest.getLEFFDT();
            Date rankEndDate = empPostRankInfoLatest.getRankEndDate();
            if (rankEndDate == null || rankEndDate != null && com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayBefore((Date)endDate, (Date)rankEndDate)) {
                empPostRankInfoLatest.setRankEndDate(endDate);
                SelectorItemCollection selectors = new SelectorItemCollection();
                SelectorItemInfo selectorItem2 = new SelectorItemInfo("rankEndDate");
                selectors.add(selectorItem2);
                EmpPostRankFactory.getLocalInstance(ctx).updatePartial(empPostRankInfoLatest, selectors);
            }
        }
    }

    private void updateOtherPostRankInfosNotLatest(Context ctx, EmpPostRankInfo empPostRankInfoLatest) throws BOSException {
        String lastestId = empPostRankInfoLatest.getId().toString();
        PersonInfo personInfo = empPostRankInfoLatest.getPerson();
        String updateSql1 = "update t_hr_empPostRank set fisLatest = 0 where  fpersonid ='" + personInfo.getId().toString() + "' and fisLatest = 1";
        DbUtil.execute((Context)ctx, (String)updateSql1);
        String updateSql2 = "update t_hr_empPostRank set fisLatest = 1 where  fid  = '" + lastestId + "'";
        DbUtil.execute((Context)ctx, (String)updateSql2);
    }

    private IObjectPK addEmpPostRankInfoWithEFFDT(Context ctx, EmpPostRankInfo empPostRankInfoFromBill) throws EASBizException, BOSException {
        if (empPostRankInfoFromBill.getJobGrade() == null && empPostRankInfoFromBill.getJobLevel() == null) {
            this.isUseOldEmpPostRank = true;
            return null;
        }
        Object pk = null;
        Date latestEFFDT = null;
        Date nowEFFDT = empPostRankInfoFromBill.getEFFDT();
        PersonInfo personInfo = empPostRankInfoFromBill.getPerson();
        EmpPostRankInfo empPostRankInfoLatest = this.getLatestEmpPostRankInfo(ctx, empPostRankInfoFromBill);
        Date rankEndDate = this.getRankEndDate(ctx, personInfo);
        if (com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayAfter((Date)nowEFFDT, (Date)rankEndDate)) {
            rankEndDate = HRUtil.getMaxEndDate();
        }
        empPostRankInfoFromBill.setRankEndDate(rankEndDate);
        if (empPostRankInfoLatest != null && (latestEFFDT = empPostRankInfoLatest.getEFFDT()) == null) {
            Object[] params = new Object[1];
            String personId = personInfo.getId().toString();
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            params[0] = personInfo.getNumber();
            throw new EmpPostRankException(EmpPostRankException.ERROR_DATA, params);
        }
        if (empPostRankInfoLatest == null) {
            pk = this.appendAftertheLatestNode(ctx, empPostRankInfoLatest, empPostRankInfoFromBill);
        } else if (nowEFFDT.equals(latestEFFDT)) {
            EmpPostRankInfo empPostRankInfoAppointDate = this.getAppointDateEmpPostRank(ctx, personInfo, nowEFFDT);
            boolean isAppointEquals = this.isEqualsTwoEmpPostRankInfo(empPostRankInfoAppointDate, empPostRankInfoFromBill);
            if (!isAppointEquals) {
                pk = this.appendAftertheLatestNodeInSameday(ctx, empPostRankInfoLatest, empPostRankInfoFromBill);
            }
        } else if (latestEFFDT.before(nowEFFDT)) {
            boolean isEquals;
            pk = this.isEnrollAgainAction(this.hrBizDefineInfo) ? this.appendAftertheLatestNode(ctx, empPostRankInfoLatest, empPostRankInfoFromBill) : (!(isEquals = this.isEqualsTwoEmpPostRankInfo(empPostRankInfoLatest, empPostRankInfoFromBill)) || EmpPostRankSourceEnum.init.equals((Object)empPostRankInfoLatest.getSource()) ? this.appendAftertheLatestNode(ctx, empPostRankInfoLatest, empPostRankInfoFromBill) : new ObjectUuidPK(empPostRankInfoLatest.getId().toString()));
        } else if (nowEFFDT.before(latestEFFDT)) {
            this.isSupplementBill = true;
            EmpPostRankInfo empPostRankInfoFirst = this.getEmpPostRankInfoFirst(ctx, personInfo);
            EmpPostRankInfo empPostRankInfoAppointDate = this.getAppointDateEmpPostRank(ctx, personInfo, nowEFFDT);
            if (empPostRankInfoAppointDate == null) {
                boolean isEquals = this.isEqualsTwoEmpPostRankInfo(empPostRankInfoFirst, empPostRankInfoFromBill);
                if (isEquals) {
                    this.changeFirstNodeEFFDT(ctx, empPostRankInfoFirst, empPostRankInfoFromBill, nowEFFDT);
                    pk = new ObjectUuidPK(empPostRankInfoFirst.getId().toString());
                } else {
                    pk = this.insertBeforeFirstNode(ctx, empPostRankInfoFirst, empPostRankInfoFromBill);
                }
            } else if (empPostRankInfoAppointDate != null) {
                EmpPostRankInfo empPostRankAppointDateNext = this.getNextEmpPostRankInfo(ctx, empPostRankInfoAppointDate);
                boolean isAppointEquals = this.isEqualsTwoEmpPostRankInfo(empPostRankInfoAppointDate, empPostRankInfoFromBill);
                boolean isAppointNextEquals = this.isEqualsTwoEmpPostRankInfo(empPostRankAppointDateNext, empPostRankInfoFromBill);
                if (!isAppointEquals && !isAppointNextEquals) {
                    pk = this.insertAfterAppointDateNode(ctx, empPostRankInfoAppointDate, empPostRankInfoFromBill);
                } else if (!isAppointEquals && isAppointNextEquals) {
                    this.changeAppointDateNextNodeEFFDT(ctx, empPostRankAppointDateNext, nowEFFDT);
                    this.changeAppointDateNodeLEFFDT(ctx, empPostRankInfoAppointDate, DateUtil.getBeforeDay((Date)nowEFFDT));
                    pk = new ObjectUuidPK(empPostRankInfoAppointDate.getId().toString());
                } else if (isAppointEquals && !isAppointNextEquals) {
                    pk = new ObjectUuidPK(empPostRankInfoAppointDate.getId().toString());
                }
            }
            if (null == pk) {
                pk = new ObjectUuidPK(empPostRankInfoLatest.getId().toString());
            }
        }
        return pk;
    }

    private IObjectPK appendAftertheLatestNodeInSameday(Context ctx, EmpPostRankInfo empPostRankInfoLatest, EmpPostRankInfo empPostRankInfoFromBill) throws EASBizException, BOSException {
        empPostRankInfoFromBill.setIsLatest(true);
        IObjectPK pk = EmpPostRankFactory.getLocalInstance(ctx).addnew(empPostRankInfoFromBill);
        empPostRankInfoFromBill.setId(BOSUuid.read((String)pk.toString()));
        if (empPostRankInfoLatest != null) {
            this.endPreEmpPostRankInfoInSameday(ctx, empPostRankInfoLatest, empPostRankInfoFromBill);
        }
        return pk;
    }

    private void endPreEmpPostRankInfoInSameday(Context ctx, EmpPostRankInfo lastEmpPostRankInfo, EmpPostRankInfo empPostRankInfoFromBill) throws EASBizException, BOSException {
        Date effdt = empPostRankInfoFromBill.getEFFDT();
        lastEmpPostRankInfo.setLEFFDT(effdt);
        lastEmpPostRankInfo.setIsLatest(false);
        lastEmpPostRankInfo.setRankEndDate(effdt);
        SelectorItemCollection selectors = new SelectorItemCollection();
        SelectorItemInfo selectorItem1 = new SelectorItemInfo("LEFFDT");
        selectors.add(selectorItem1);
        SelectorItemInfo selectorItem2 = new SelectorItemInfo("rankEndDate");
        selectors.add(selectorItem2);
        SelectorItemInfo selectorItem3 = new SelectorItemInfo("isLatest");
        selectors.add(selectorItem3);
        EmpPostRankFactory.getLocalInstance(ctx).updatePartial(lastEmpPostRankInfo, selectors);
    }

    private void changeAppointDateNextNodeEFFDT(Context ctx, EmpPostRankInfo empPostRankAppointDateNext, Date nowEFFDT) throws EASBizException, BOSException {
        empPostRankAppointDateNext.setEFFDT(nowEFFDT);
        SelectorItemCollection selectItems = new SelectorItemCollection();
        SelectorItemInfo selector = new SelectorItemInfo("EFFDT");
        selectItems.add(selector);
        EmpPostRankFactory.getLocalInstance(ctx).updatePartial(empPostRankAppointDateNext, selectItems);
    }

    private void changeAppointDateNodeLEFFDT(Context ctx, EmpPostRankInfo empPostRankAppointDate, Date LEFFDT) throws EASBizException, BOSException {
        empPostRankAppointDate.setLEFFDT(LEFFDT);
        empPostRankAppointDate.setRankEndDate(LEFFDT);
        SelectorItemCollection selectItems = new SelectorItemCollection();
        SelectorItemInfo selector1 = new SelectorItemInfo("LEFFDT");
        SelectorItemInfo selector2 = new SelectorItemInfo("rankEndDate");
        selectItems.add(selector1);
        selectItems.add(selector2);
        EmpPostRankFactory.getLocalInstance(ctx).updatePartial(empPostRankAppointDate, selectItems);
    }

    private IObjectPK insertAfterAppointDateNode(Context ctx, EmpPostRankInfo empPostRankInfoAppointDate, EmpPostRankInfo empPostRankInfoFromBill) throws EASBizException, BOSException {
        if (HRUtil.getMaxEndDate().equals(empPostRankInfoAppointDate.getLEFFDT())) {
            empPostRankInfoFromBill.setIsLatest(true);
        } else {
            empPostRankInfoFromBill.setIsLatest(false);
        }
        empPostRankInfoFromBill.setRankEndDate(empPostRankInfoAppointDate.getLEFFDT());
        empPostRankInfoFromBill.setLEFFDT(empPostRankInfoAppointDate.getLEFFDT());
        IObjectPK pk = EmpPostRankFactory.getLocalInstance(ctx).addnew(empPostRankInfoFromBill);
        this.endPreEmpPostRankInfo(ctx, empPostRankInfoAppointDate, empPostRankInfoFromBill, true);
        return pk;
    }

    private IObjectPK appendAftertheLatestNode(Context ctx, EmpPostRankInfo empPostRankInfoLatest, EmpPostRankInfo empPostRankInfoFromBill) throws EASBizException, BOSException {
        empPostRankInfoFromBill.setIsLatest(true);
        IObjectPK pk = EmpPostRankFactory.getLocalInstance(ctx).addnew(empPostRankInfoFromBill);
        empPostRankInfoFromBill.setId(BOSUuid.read((String)pk.toString()));
        PersonInfo personInfo = empPostRankInfoFromBill.getPerson();
        EmpPosOrgRelationInfo empPosInfo = SHREmpOptEmpOrgRelationTool.getCurrntMainEmpOrgRelationInfo(ctx, personInfo.getId().toString());
        if (!(empPostRankInfoLatest == null || EmpPostRankSourceEnum.init.equals((Object)empPostRankInfoLatest.getSource()) && com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayBefore((Date)empPostRankInfoLatest.getLEFFDT(), (Date)empPostRankInfoFromBill.getEFFDT()))) {
            if (this.isEnrollAgainAction(this.hrBizDefineInfo) || this.isEnrollAgainAction(empPosInfo.getAction())) {
                this.endPreEmpPostRankInfo(ctx, empPostRankInfoLatest, empPostRankInfoFromBill, false);
            } else {
                this.endPreEmpPostRankInfo(ctx, empPostRankInfoLatest, empPostRankInfoFromBill, true);
            }
        }
        return pk;
    }

    private IObjectPK insertBeforeFirstNode(Context ctx, EmpPostRankInfo empPostRankInfoFirst, EmpPostRankInfo empPostRankInfoFromBill) throws EASBizException, BOSException {
        Date firstEFFDT = empPostRankInfoFirst.getEFFDT();
        Date theDayBeforeFirstEFFDT = DateUtil.getBeforeDay((Date)firstEFFDT);
        empPostRankInfoFromBill.setLEFFDT(theDayBeforeFirstEFFDT);
        empPostRankInfoFromBill.setRankEndDate(theDayBeforeFirstEFFDT);
        empPostRankInfoFromBill.setIsLatest(false);
        IObjectPK pk = EmpPostRankFactory.getLocalInstance(ctx).addnew(empPostRankInfoFromBill);
        empPostRankInfoFromBill.setId(BOSUuid.read((String)pk.toString()));
        return pk;
    }

    private void changeFirstNodeEFFDT(Context ctx, EmpPostRankInfo empPostRankInfoFirst, EmpPostRankInfo empPostRankInfoFromBill, Date nowEFFDT) throws EASBizException, BOSException {
        empPostRankInfoFirst.setEFFDT(nowEFFDT);
        empPostRankInfoFirst.setSource(empPostRankInfoFromBill.getSource());
        SelectorItemCollection selectItems = new SelectorItemCollection();
        SelectorItemInfo selector = new SelectorItemInfo("EFFDT");
        SelectorItemInfo selector2 = new SelectorItemInfo("source");
        selectItems.add(selector);
        selectItems.add(selector2);
        EmpPostRankFactory.getLocalInstance(ctx).updatePartial(empPostRankInfoFirst, selectItems);
    }

    private EmpPostRankInfo getEmpPostRankInfoFirst(Context ctx, PersonInfo personInfo) throws BOSException {
        String oql = "where person ='" + personInfo.getId().toString() + "' order by EFFDT ASC";
        EmpPostRankCollection collection = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(oql);
        EmpPostRankInfo empPostRankInfoFirst = null;
        if (collection.size() > 0) {
            empPostRankInfoFirst = collection.get(0);
        }
        return empPostRankInfoFirst;
    }

    private EmpPostRankInfo getNextEmpPostRankInfo(Context ctx, EmpPostRankInfo empPostRankInfoCurrent) throws EASBizException {
        Date LEFFDT = empPostRankInfoCurrent.getLEFFDT();
        EmpPostRankInfo nextEmpPostRankInfo = null;
        if (LEFFDT != null && DateUtil.dateDiff((Date)HRUtil.getMaxEndDate(), (Date)LEFFDT) == 0L) {
            return null;
        }
        Date nextEFFFDT = DateUtil.getAfterDay((Date)LEFFDT);
        PersonInfo personInfo = empPostRankInfoCurrent.getPerson();
        String oql = "where EFFDT = " + HRUtilExtend.getDateStringWithoutMininuteTs((Date)nextEFFFDT) + "and person ='" + personInfo.getId().toString() + "'";
        try {
            nextEmpPostRankInfo = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankInfo(oql);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw e;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        return nextEmpPostRankInfo;
    }

    private EmpPostRankInfo getLatestEmpPostRankInfo(Context ctx, EmpPostRankInfo empPostRankInfoFromBill) throws EASBizException, BOSException {
        EmpPostRankInfo lastRecord = null;
        EmpPostRankCollection collection = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection("where person = '" + empPostRankInfoFromBill.getPerson().getId().toString() + "'order by leffdt desc");
        lastRecord = collection.get(0);
        return lastRecord;
    }

    private boolean isEnrollAgainAction(HRBizDefineInfo action) {
        return action.getBizDefineType().equals((Object)HRBizDefineTypeEnum.ENROLLAGAIN) || HRBizDefineTypeEnum.ENROLLAGAIN.equals((Object)action.getBizDefineType()) || action.getBizDefineType().equals((Object)HRBizDefineTypeEnum.REINVITE);
    }

    @Override
    protected void _recoveryEmpPostRank(Context ctx, EmpPosOrgRelationInfo empPosOrgRelationInfo, String type) throws BOSException, EASBizException {
        PersonInfo personInfo = empPosOrgRelationInfo.getPerson();
        String EmpPoslinkSQL = "select * ,empPostRank.id,empPostRank.source where empPosOrgRelation.id ='" + empPosOrgRelationInfo.getId().toString() + "' order by startDateTime desc";
        EmpPosJobGradeRelationCollection relationColl = EmpPosJobGradeRelationFactory.getLocalInstance(ctx).getEmpPosJobGradeRelationCollection(EmpPoslinkSQL);
        EmpPostRankInfo linkRankInfo = null;
        if (relationColl.size() == 0) {
            return;
        }
        if ("IN_TYPE".equals(type)) {
            if (relationColl.size() == 1) {
                EmpPosJobGradeRelationInfo relationInfo = relationColl.get(0);
                linkRankInfo = relationInfo.getEmpPostRank();
                String postRanklinkSQL = "where empPostRank.id ='" + linkRankInfo.getId().toString() + "' and id <>'" + relationInfo.getId().toString() + "'";
                EmpPosJobGradeRelationCollection relationRelativeColl = EmpPosJobGradeRelationFactory.getLocalInstance(ctx).getEmpPosJobGradeRelationCollection(postRanklinkSQL);
                if (relationRelativeColl.size() == 0) {
                    EmpPosJobGradeRelationFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(relationInfo.getId()));
                    if (EmpPostRankSourceEnum.personChange.equals((Object)linkRankInfo.getSource())) {
                        EmpPostRankFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(linkRankInfo.getId()));
                    }
                } else {
                    EmpPosJobGradeRelationFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(relationInfo.getId()));
                }
            } else if (relationColl.size() > 1) {
                RiseBizBillEntryInfo mostNewEntryInfo;
                EmpPosJobGradeRelationInfo tempInfo = null;
                int size = relationColl.size();
                for (int i = 0; i < size && (tempInfo = relationColl.get(i)).getAffairId().equals(empPosOrgRelationInfo.getFlowInAffairID()); ++i) {
                }
                String billOQL = "select bill.* where id ='" + (tempInfo == null ? "" : tempInfo.getAffairId()) + "'";
                RiseBizBillEntryCollection riseCollection = RiseBizBillEntryFactory.getLocalInstance((Context)ctx).getRiseBizBillEntryCollection(billOQL);
                if (riseCollection != null && riseCollection.size() > 0 && (mostNewEntryInfo = riseCollection.get(0)) != null) {
                    RiseBizBillInfo mostNewBillInfo = mostNewEntryInfo.getBill();
                    Object[] params = new Object[]{personInfo.getNumber(), personInfo.getName(), mostNewBillInfo.getNumber()};
                    throw new AffairUnAuditException(AffairUnAuditException.ERROR_HASEMPJOBGRADE_BEHIND, params);
                }
            }
        } else if ("OUT_TYPE".equals(type)) {
            EmpPosJobGradeRelationInfo relationInfo = relationColl.get(0);
            linkRankInfo = relationInfo.getEmpPostRank();
            EmpPostRankInfo rankInfo = EmpPostRankUtil.getPersonAppointDateEmpPostRankInfo(ctx, personInfo.getId().toString(), null);
            if (rankInfo != null && rankInfo.isIsLatest() && DateTimeUtils.dayEquals((Date)HistoryUtil.getMaxDate(), (Date)rankInfo.getRankEndDate())) {
                return;
            }
            HRBizDefineInfo action = empPosOrgRelationInfo.getAction();
            if (HRBizDefineTypeEnum.RESIGN.equals((Object)action.getBizDefineType()) || HRBizDefineTypeEnum.RETIRE.equals((Object)action.getBizDefineType())) {
                EmpPosOrgRelationInfo parentInfo;
                Date leftCompanyDate = com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.addDay((Date)empPosOrgRelationInfo.getEFFDT(), (long)-1L);
                linkRankInfo.setRankEndDate(leftCompanyDate);
                EmpPosOrgRelationInfo tempInfo = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationInfo("select parent.id where id='" + empPosOrgRelationInfo.getId().toString() + "'");
                if (tempInfo.getParent() != null && (parentInfo = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationInfo("select leffdt where id='" + tempInfo.getParent().getId().toString() + "'")).getLEFFDT().equals(empPosOrgRelationInfo.getEFFDT())) {
                    linkRankInfo.setRankEndDate(empPosOrgRelationInfo.getLEFFDT());
                }
            } else {
                linkRankInfo.setRankEndDate(HistoryUtil.getMaxDate());
            }
            linkRankInfo.setLEFFDT(HistoryUtil.getMaxDate());
            linkRankInfo.setIsLatest(Boolean.TRUE);
            EmpPostRankFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(linkRankInfo.getId().toString()), linkRankInfo);
        }
    }

    public void setEmpPostRankChangeInfo(EmpPostRankChangeInfo empPostRankChangeInfo) {
        this.empPostRankChangeInfo = empPostRankChangeInfo;
    }

    public EmpPostRankChangeInfo getEmpPostRankChangeInfo() {
        return this.empPostRankChangeInfo;
    }

    private void createEmpPosJobGradeRelation(Context ctx, EmpPostRankInfo empPostRankInfoProcess) throws BOSException, EASBizException {
        EmpPosOrgRelationInfo info;
        List posPKList = this.getEmpPostRankChangeInfo().getPosPKList();
        HRBizData bizData = this.getEmpPostRankChangeInfo().getHrBizData();
        String logPK = bizData.getHRAffairActionTransactionLogID();
        Date effdt = bizData.getStartDate();
        PersonInfo personInfo = bizData.getPersonInfo();
        if (personInfo == null) {
            return;
        }
        EmpPosOrgRelationCollection posCollection = null;
        if (posPKList != null && empPostRankInfoProcess == null && this.isUseOldEmpPostRank) {
            empPostRankInfoProcess = SHREmpOptEmpPostRankUtil.getAppointDateEmpPostRank(ctx, personInfo.getId().toString(), effdt);
            if (empPostRankInfoProcess == null) {
                return;
            }
            posCollection = new EmpPosOrgRelationCollection();
            for (IObjectPK pk : posPKList) {
                if (pk == null || (info = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationInfo(pk)).getAssignType().equals((Object)AssignTypeEnum.PARTTIME)) continue;
                info.setId(BOSUuid.read((String)pk.toString()));
                posCollection.add(info);
            }
        } else if ((posPKList == null || posPKList.size() == 0) && empPostRankInfoProcess != null) {
            posCollection = SHREmpOptEmpOrgRelationTool.getAppointDateEmpOrgRelationColl(ctx, personInfo.getId().toString(), effdt, AssignTypeEnum.MAIN);
            if (posCollection.size() == 0) {
                throw new EmpPostRankException(EmpPostRankException.ERROR_EMPPOSDATA);
            }
            if (posCollection.size() > 0 && empPostRankInfoProcess != null) {
                int size = posCollection.size();
                for (int i = 0; i < size; ++i) {
                    info = posCollection.get(i);
                    EmpPosJobGradeRelationFactory.getLocalInstance(ctx).delete("where empPosOrgRelation.id ='" + info.getId().toString() + "'");
                }
            }
        } else if (posPKList != null && empPostRankInfoProcess != null) {
            posCollection = new EmpPosOrgRelationCollection();
            for (IObjectPK pk : posPKList) {
                if (pk == null || (info = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationInfo(pk)).getAssignType().equals((Object)AssignTypeEnum.PARTTIME)) continue;
                info.setId(BOSUuid.read((String)pk.toString()));
                posCollection.add(info);
            }
        }
        if (posCollection != null && posCollection.size() > 0 && empPostRankInfoProcess != null) {
            int size = posCollection.size();
            for (int i = 0; i < size; ++i) {
                EmpPosJobGradeRelationInfo relationInfo = new EmpPosJobGradeRelationInfo();
                relationInfo.setAffairId(logPK);
                relationInfo.setEmpPosOrgRelation(posCollection.get(i));
                relationInfo.setEmpPostRank(empPostRankInfoProcess);
                relationInfo.setEffdt(effdt);
                relationInfo.setPerson(personInfo);
                relationInfo.setStartDateTime(bizData.getStartDateTime());
                EmpPosJobGradeRelationFactory.getLocalInstance(ctx).addnew(relationInfo);
            }
        }
    }

    private Date getRankEndDate(Context ctx, PersonInfo personInfo) throws EASBizException, BOSException {
        Date rankEndDate = HRUtil.getMaxEndDate();
        String personId = personInfo.getId().toString();
        EmployeeTypeInfo employeeTypeInfo = HRUtilExtend.getEmployeTypeInInfo((Context)ctx, (String)personId);
        PersonPositionInfo personPositionInfo = HRUtilExtend.getPersonPositionInfoByPersonInfo((Context)ctx, (PersonInfo)personInfo);
        switch (employeeTypeInfo.getInService().getValue()) {
            case 2: 
            case 3: {
                rankEndDate = personPositionInfo.getLeftCompanyDate();
                if (rankEndDate == null) {
                    rankEndDate = personPositionInfo.getLeftDate();
                }
                if (rankEndDate != null) break;
                rankEndDate = HRUtil.getMaxEndDate();
                break;
            }
        }
        return rankEndDate;
    }

    @Override
    protected void _deleteInitEmpPostRank(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EmpPostRankInfo lastempPostRankInfo;
        IEmpPostRank iEmpPostRank = EmpPostRankFactory.getLocalInstance(ctx);
        EmpPostRankInfo empPostRankInfo = iEmpPostRank.getEmpPostRankInfo(pk);
        iEmpPostRank.delete(pk);
        if (empPostRankInfo.isIsLatest() && empPostRankInfo.getPerson() != null && empPostRankInfo.getPerson().getId() != null && (lastempPostRankInfo = this.getLatestEmpPostRankInfo(ctx, empPostRankInfo)) != null) {
            lastempPostRankInfo.setIsLatest(true);
            iEmpPostRank.update((IObjectPK)new ObjectUuidPK(lastempPostRankInfo.getId()), lastempPostRankInfo);
        }
    }

    @Override
    protected void _updateEmpPostRank(Context ctx, EmpPostRankInfo empPostRankInfo, SelectorItemCollection selectors) throws BOSException, EASBizException {
        if (selectors == null) {
            selectors = new SelectorItemCollection();
        }
        this.checkAndUpdateEmpPostRank(ctx, empPostRankInfo);
        EmpPostRankFactory.getLocalInstance(ctx).updatePartial(empPostRankInfo, selectors);
    }

    private void checkAndUpdateEmpPostRank(Context ctx, EmpPostRankInfo empPostRankInfo) throws BOSException, EASBizException {
        IEmpPostRank iEmpPostRank = EmpPostRankFactory.getLocalInstance(ctx);
        this.validateInfo(ctx, empPostRankInfo);
        if (empPostRankInfo.getRankEndDate() == null) {
            throw new EmpPostRankException(EmpPostRankException.LEFFDT_NULL);
        }
        if (empPostRankInfo.getEFFDT().after(empPostRankInfo.getRankEndDate())) {
            throw new EmpPostRankException(EmpPostRankException.ERROR_EFFDT_1);
        }
        PersonHisCollection personColl = PersonHisFactory.getLocalInstance((Context)ctx).getPersonHisCollection("where historyRelateID = '" + empPostRankInfo.getPerson().getId().toString() + "' order by effdt asc");
        if (personColl.size() > 0 && com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayBefore((Date)empPostRankInfo.getEFFDT(), (Date)personColl.get(0).getEFFDT())) {
            throw new EmpPostRankException(EmpPostRankException.ERROR_EFFDT_2, new Object[]{personColl.get(0).getEFFDT()});
        }
        if (com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayAfter((Date)empPostRankInfo.getEFFDT(), (Date)com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.truncateDate((Date)new Date()))) {
            throw new EmpPostRankException(EmpPostRankException.ERROR_EFFDT_3);
        }
        String personId = empPostRankInfo.getPerson().getId().toString();
        EmpPostRankInfo oldEmpPostRankInfo = iEmpPostRank.getEmpPostRankInfo((IObjectPK)new ObjectUuidPK(empPostRankInfo.getId().toString()));
        EmpPostRankSourceEnum source = empPostRankInfo.getSource();
        EmpPostRankInfo previousPostRankInfo = EmpPostRankUtil.getPersonPreviousAppointDateEmpPostRankInfo(ctx, personId, oldEmpPostRankInfo.getEFFDT());
        if (previousPostRankInfo == null) {
            return;
        }
        if (EmpPostRankSourceEnum.init.equals((Object)source)) {
            String effdt = HRUtilExtend.getDateStringWithoutMininuteTs((Date)empPostRankInfo.getEFFDT());
            String leffdt = HRUtilExtend.getDateStringWithoutMininuteTs((Date)empPostRankInfo.getRankEndDate());
            StringBuilder oql = new StringBuilder("where").append("  person.id='" + personId).append("'").append(" and (").append("(EFFDT<=").append(effdt).append(" and LEFFDT>=").append(effdt).append(")").append(" or (EFFDT<=").append(leffdt).append(" and leffdt>=").append(leffdt).append(")").append(" or (EFFDT>=").append(effdt).append(" and LEFFDT<=").append(leffdt).append(")").append(" or (EFFDT<=").append(effdt).append(" and LEFFDT>=").append(leffdt).append(")").append(")");
            if (empPostRankInfo.getId() != null) {
                oql.append(" and id != '" + empPostRankInfo.getId().toString() + "'");
            }
            if (EmpPostRankFactory.getLocalInstance(ctx).exists(oql.toString())) {
                throw new EmpPostRankException(EmpPostRankException.ERROR_DATE_COMPLEX);
            }
            empPostRankInfo.setLEFFDT(empPostRankInfo.getRankEndDate());
        }
        if (EmpPostRankSourceEnum.personRise.equals((Object)source)) {
            if (EmpPostRankSourceEnum.init.equals((Object)previousPostRankInfo.getSource())) {
                if (!com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayBefore((Date)previousPostRankInfo.getRankEndDate(), (Date)empPostRankInfo.getEFFDT())) {
                    throw new EmpPostRankException(EmpPostRankException.ERROR_EFFDT_5, new Object[]{com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.truncateDate((Date)previousPostRankInfo.getRankEndDate())});
                }
            } else {
                if (!com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayBefore((Date)previousPostRankInfo.getEFFDT(), (Date)empPostRankInfo.getEFFDT())) {
                    throw new EmpPostRankException(EmpPostRankException.ERROR_EFFDT_4, new Object[]{com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.truncateDate((Date)previousPostRankInfo.getEFFDT())});
                }
                if (com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayEquals((Date)previousPostRankInfo.getRankEndDate(), (Date)previousPostRankInfo.getLEFFDT()) || !com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayEquals((Date)previousPostRankInfo.getRankEndDate(), (Date)previousPostRankInfo.getLEFFDT()) && !com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils.dayBefore((Date)previousPostRankInfo.getRankEndDate(), (Date)empPostRankInfo.getEFFDT())) {
                    previousPostRankInfo.setRankEndDate(DateUtil.getBeforeDay((Date)empPostRankInfo.getEFFDT()));
                }
                previousPostRankInfo.setLEFFDT(DateUtil.getBeforeDay((Date)empPostRankInfo.getEFFDT()));
                iEmpPostRank.update((IObjectPK)new ObjectUuidPK(previousPostRankInfo.getId().toString()), previousPostRankInfo);
            }
        }
    }
}

