/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.app.AbstractEmpRosterFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EmpRosterFacadeControllerBean
extends AbstractEmpRosterFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpRosterFacadeControllerBean");

    @Override
    protected IRowSet _getEmployeeBaseInfoRowSet(Context ctx, FilterInfo empFilter) throws BOSException, EASBizException {
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app.EmployeeBaseInfoQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (empFilter != null) {
            viewInfo.setFilter(empFilter);
        }
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rs = queryExcu.executeQuery();
        return rs;
    }

    @Override
    protected IRowSet _getEmployeeDetailRowSetByQuery(Context ctx, String strQueryPK, String filterFieldName, String employeeId) throws BOSException, EASBizException {
        HROrgUnitInfo hrOrgInfo;
        if (employeeId == null || employeeId.equals("")) {
            return null;
        }
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK(strQueryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if ("com.kingdee.eas.hr.benefit.app.EmpBenefitQuery".equals(strQueryPK) && (hrOrgInfo = ContextUtil.getCurrentHRUnit((Context)ctx)) != null) {
            fi.getFilterItems().add(new FilterItemInfo("HRORGUNIT.id", (Object)hrOrgInfo.getId()));
            fi.getFilterItems().add(new FilterItemInfo("ACCOUNTTYPEHR.id", (Object)hrOrgInfo.getId()));
            fi.getFilterItems().add(new FilterItemInfo("BENEFITHR.id", (Object)hrOrgInfo.getId()));
        }
        fi.getFilterItems().add(new FilterItemInfo(filterFieldName, (Object)employeeId));
        viewInfo.setFilter(fi);
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rs = queryExcu.executeQuery();
        return rs;
    }

    @Override
    protected IRowSet _getEmployeeDetailRowSetByQuery2(Context ctx, String strQueryPK, String filterFieldName, String employeeId, HashMap map) throws BOSException, EASBizException {
        if (employeeId == null || employeeId.equals("")) {
            return null;
        }
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK(strQueryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo(filterFieldName, (Object)employeeId));
        viewInfo.setFilter(fi);
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rs = queryExcu.executeQuery();
        try {
            if (map.get("btnSelected") == null || map.get("btnSelected").equals("radiobtn0")) {
                while (rs.next()) {
                    String fullName = rs.getString("AdminOrgUnit.displayName");
                    rs.updateString("adminOrgUnit", fullName);
                }
            } else if (map.get("btnSelected").equals("radiobtn1")) {
                if (map.get("adminName") != null) {
                    String adminName = map.get("adminName").toString();
                    while (rs.next()) {
                        String oldAdminName = rs.getString("AdminOrgUnit.displayName");
                        String newAdminName = this.setAdminNameFromCurAdmin(adminName, oldAdminName);
                        rs.updateString("adminOrgUnit", newAdminName);
                    }
                }
            } else if (map.get("btnSelected").equals("radiobtn2")) {
                int level = 0;
                String levelStr = map.get("level").toString();
                if (levelStr != null) {
                    level = Integer.parseInt(levelStr);
                }
                while (rs.next()) {
                    String oldAdminName = rs.getString("AdminOrgUnit.displayName");
                    String newAdminName = this.setAdminNameByLevel(level, oldAdminName);
                    rs.updateString("adminOrgUnit", newAdminName);
                }
            }
            rs.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rs;
    }

    @Override
    protected IRowSet _getEmployeeLanguageRowSet(Context ctx, String employeeId) throws BOSException, EASBizException {
        String localLanguage = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" select T1.FPersonID as empID,T2.FName_" + localLanguage + " as language,T3.FName_" + localLanguage + " as grade ");
        sql.append(" from t_hr_personLanguage T1 ");
        sql.append(" inner join t_bd_language T2 on T2.FID = T1.FLanguage ");
        sql.append(" inner join t_hr_bdlangGrade T3 on T3.FID = T1.FGrade ");
        sql.append(" where T1.FPersonID = '" + employeeId + "'");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getEmployeeRewardPunishRowSet(Context ctx, String employeeId) throws BOSException, EASBizException {
        String localLanguage = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" select T1.FPersonID as empID,T1.FTitle as occurTitle,T2.FName_" + localLanguage + " as occurType, ");
        sql.append("        T1.FContent as occurContent,to_char(T1.FOccurDate,'yyyy-mm-dd') as occurDate ");
        sql.append(" from t_hr_PersonRewardPunish T1 ");
        sql.append(" LEFT OUTER JOIN  T_HR_BDRewPubType T2 on T2.FID = T1.FType ");
        sql.append(" where T1.FPersonID = '" + employeeId + "'");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getEmployeeArchivesRowSet(Context ctx, String employeeId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FPersonID as empID,FNumber as \"number\",FType as \"type\",FArchivesPlace as archivesPlace, ");
        sql.append("        FSource as \"source\",FDestination as destination,FInDate as inDate,FOutDate as outDate, ");
        sql.append("        FRemark as \"remark\" ");
        sql.append(" from T_HR_PersonArchives ");
        sql.append(" where FPersonID = '" + employeeId + "'");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getEmployeeLinkManRowSet(Context ctx, String employeeId) throws BOSException, EASBizException {
        String localLanguage = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" select FPersonID as empID,FName as linkManName,FPhoneNumber as phoneNumber, ");
        sql.append("        CASE FBloodType WHEN 10 THEN 'A' WHEN 20 THEN 'B' WHEN 30 THEN 'AB' WHEN 40 THEN 'O' WHEN 90 THEN '");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"34_BiReportJyglFacadeControllerBean", (Locale)ctx.getLocale()));
        sql.append("' WHEN 0 THEN '");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"80_EmpRosterFacadeControllerBean", (Locale)ctx.getLocale()));
        sql.append("' END as bloodType, ");
        sql.append("        FDescription_" + localLanguage + " as remark ");
        sql.append(" from T_HR_PersonLinkman ");
        sql.append(" where FPersonID = '" + employeeId + "'");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getEmployeeCertificateRowSet(Context ctx, String employeeId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FPersonID as empID,FCertificateNumber as certificateNumber,FCertificateName as certificateName, ");
        sql.append("        FCertifyDate as certificateDate,FPeriodValidity as certificateValidityYear,FOrgan as certificateOrgan, ");
        sql.append("        FLevel as certificateLevel ");
        sql.append(" from T_HR_PersonCertify ");
        sql.append(" where FPersonID = '" + employeeId + "'");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getEmployeeCommunistRowSet(Context ctx, String employeeId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FPersonID as empID,FJoinDate as joinDate,FTransDate as transDate, ");
        sql.append("        FDepUnit as depUnit,FDepYear as depYear,FJoinCircs as joinCircs, ");
        sql.append("        FCommunistDuty as communistDuty,FFirstCircs as firstCircs ");
        sql.append(" from T_HR_PersonCommunist ");
        sql.append(" where FPersonID = '" + employeeId + "'");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getEmployeeResourceRowSet(Context ctx, String employeeId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FPersonID as empID,FNumber as resourceNumber,FName as resourceName,FDescription as remark ");
        sql.append(" from T_HR_PersonResource ");
        sql.append(" where FPersonID = '" + employeeId + "'");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getEmployeeContactMethodRowSet(Context ctx, String employeeId) throws BOSException, EASBizException {
        String localLanguage = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" select T1.FPersonID as empID,T1.FHomePlace as homeplace,T1.FHomeAddress as homeAddress, T1.FidCardAddress as idCardAddress ,");
        sql.append("        T2.FAddress_" + localLanguage + " as address,T1.FPostalcode as postalcode,T2.FEmail as email, ");
        sql.append("        T2.FHomePhone as homePhone,T2.FCell as mobile,T2.FOfficePhone as officePhone ");
        sql.append(" from T_HR_PersonContactMethod T1,T_BD_Person T2");
        sql.append(" where T1.FPersonID = '" + employeeId + "' and T2.FID = '" + employeeId + "'");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getEmployeeWorkExpDetailRowSet(Context ctx, String strQueryPK, String filterFieldName, String employeeId, String dateSort) throws BOSException, EASBizException {
        if (employeeId == null || employeeId.equals("")) {
            return null;
        }
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK(strQueryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo(filterFieldName, (Object)employeeId));
        viewInfo.setFilter(fi);
        if (!StringUtils.isEmpty((String)dateSort)) {
            SorterItemInfo sorterItemInfo = new SorterItemInfo("beginDate");
            if ("DESC".equalsIgnoreCase(dateSort)) {
                sorterItemInfo.setSortType(SortType.DESCEND);
            } else {
                sorterItemInfo.setSortType(SortType.ASCEND);
            }
            viewInfo.getSorter().add(sorterItemInfo);
        }
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rs = queryExcu.executeQuery();
        return rs;
    }

    private String setAdminNameFromCurAdmin(String CurAdminName, String oldAdminName) {
        int index;
        String newAdminName = null;
        String[] names = oldAdminName.split("_");
        for (index = 0; index < names.length && !CurAdminName.equals(names[index]); ++index) {
        }
        StringBuffer sb = new StringBuffer(names[index]);
        for (int i = index + 1; i < names.length; ++i) {
            sb.append("_").append(names[i]);
        }
        newAdminName = sb.toString();
        return newAdminName;
    }

    private String setAdminNameByLevel(int levelNum, String oldAdminName) {
        String newAdminName = null;
        String[] names = oldAdminName.split("_");
        int num = names.length - levelNum;
        if (num <= 0) {
            return oldAdminName;
        }
        StringBuffer sb = new StringBuffer(names[num]);
        for (int i = num + 1; i < names.length; ++i) {
            sb.append("_").append(names[i]);
        }
        newAdminName = sb.toString();
        return newAdminName;
    }
}

