/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.PersonBankRecordCollection;
import com.kingdee.eas.hr.emp.PersonBankRecordDeleteFactory;
import com.kingdee.eas.hr.emp.PersonBankRecordDeleteInfo;
import com.kingdee.eas.hr.emp.PersonBankRecordInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonBankRecordControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.osf.service.ServiceLocator;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonBankRecordControllerBean
extends AbstractPersonBankRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.PersonBankRecordControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            PersonBankRecordInfo info = (PersonBankRecordInfo)model;
            if (info.getHrOrgUnit() == null) {
                info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            }
            IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
            this.callPersonBankService(ctx, pk, "add");
            return pk;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.callPersonBankService(ctx, pk, "del");
            PersonBankRecordInfo bankRecordInfo = this.getPersonBankRecordInfo(ctx, pk);
            super._delete(ctx, pk);
            PersonBankRecordDeleteInfo bankRecordDeleteInfo = new PersonBankRecordDeleteInfo();
            bankRecordDeleteInfo.setAccountNum(bankRecordInfo.getAccountNum());
            bankRecordDeleteInfo.setPerson(bankRecordInfo.getPerson());
            bankRecordDeleteInfo.setPersonBankRecord(bankRecordInfo);
            PersonBankRecordDeleteFactory.getLocalInstance(ctx).addnew(bankRecordDeleteInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        PersonBankRecordCollection col = this.getPersonBankRecordCollection(ctx, oql);
        ObjectUuidPK pk = null;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                PersonBankRecordInfo info = col.get(i);
                if (info.getId() == null) continue;
                pk = new ObjectUuidPK(info.getId().toString());
                this._delete(ctx, (IObjectPK)pk);
            }
        }
        return null;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        try {
            PersonBankRecordInfo info = (PersonBankRecordInfo)model;
            super._update(ctx, pk, (IObjectValue)info);
            this.callPersonBankService(ctx, pk, "upd");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void callPersonBankService(Context ctx, IObjectPK pk, String method) throws BOSException, EASBizException {
        Map res;
        Object result = null;
        IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "personBankHandlerService");
        HashMap<String, String> parm = new HashMap<String, String>();
        parm.put("opt", method);
        parm.put("billId", pk.toString());
        result = imsf.process(ctx, parm);
        if (null != result && (res = (Map)result).get("code") != "100" && res.get("msg") != null) {
            throw new BOSException(res.get("msg").toString());
        }
    }
}

