/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IKAClassfication;
import com.kingdee.eas.basedata.assistant.KAClassficationCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.hraux.util.HRMulCUChangeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.BasePersonConstraints;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.DimissionReasonCollection;
import com.kingdee.eas.hr.base.DimissionReasonFactory;
import com.kingdee.eas.hr.base.EmployeeClassifyCollection;
import com.kingdee.eas.hr.base.EmployeeClassifyFactory;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.IDimissionReason;
import com.kingdee.eas.hr.base.IEmployeeClassify;
import com.kingdee.eas.hr.base.IEmployeeType;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.benefit.util.ExportUtil;
import com.kingdee.eas.hr.benefit.util.HrLocaleUtil;
import com.kingdee.eas.hr.emp.EmpInnerFacadeFactory;
import com.kingdee.eas.hr.emp.HRImportConstraints;
import com.kingdee.eas.hr.emp.IEmpInnerFacade;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.org.IJobGrade;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

public class PersonDataImport
extends AbstractDataTransmission {
    private ArrayList adminRangeList = null;

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            String personID = null;
            IEmpInnerFacade empFacd = EmpInnerFacadeFactory.getLocalInstance(ctx);
            coreBaseInfo.put("IS_FROM_SHR_OPT_CURD", (Object)"false");
            if (coreBaseInfo.getId() == null) {
                personID = empFacd.personAddNew((PersonInfo)coreBaseInfo).toString();
            } else {
                personID = coreBaseInfo.getId().toString();
                empFacd.personUpdate((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), (PersonInfo)coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    private ArrayList getAdminRange(Context ctx) throws TaskExternalException {
        ArrayList<String> list = new ArrayList<String>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo.getId().toString().equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT T_ORG_Admin.FID AS FID");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        sql.append("WHERE T_PM_OrgRange.FType = 20 AND T_ORG_Admin.FIsSealUp = 0 AND T_PM_OrgRange.FUserID='");
        sql.append(userInfo.getId().toString());
        sql.append("'");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rows.next()) {
                list.add(rows.getString("FID"));
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return list;
    }

    private Date parseDate(String date, String format, Context ctx) throws ParseException {
        try {
            return DateTimeUtils.parseDate((String)date, (String)format);
        }
        catch (ParseException pe) {
            throw new ParseException(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"69_EmployeeDataImport", (Locale)ctx.getLocale()) + format + "'" + ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"70_EmployeeDataImport", (Locale)ctx.getLocale()) + date, -1);
        }
    }

    private boolean checkPermission(String permissionItem, PersonInfo pInfo, Context ctx) {
        try {
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            ObjectUuidPK orgPk = new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
            boolean haspermission = permission.hasDataPermission((IObjectPK)userPk, (IObjectPK)orgPk, permissionItem, (IObjectValue)pInfo);
            if (!haspermission) {
                return false;
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PersonInfo info;
        block66: {
            if (this.adminRangeList == null) {
                this.adminRangeList = this.getAdminRange(ctx);
            }
            info = new PersonInfo();
            PersonCollection personColl = null;
            IPerson iPerson = null;
            String resStr = "com.kingdee.eas.hr.emp.EmployeeInputResource.";
            String str = "";
            str = (String)((DataToken)hsData.get((Object)"FNumber")).data;
            Locale locale = ctx.getLocale();
            try {
                EntityViewInfo viewInfo;
                Set set;
                iPerson = PersonFactory.getLocalInstance((Context)ctx);
                personColl = iPerson.getPersonCollection("where number = '" + str.trim() + "'");
                if (personColl != null && personColl.size() > 0) {
                    if ((Integer)this.getContextParameter().get("DATATASKMODE") == 8) {
                        throw new TaskExternalException(ResourceBase.getString((String)(resStr + "PERSON_IS_EXIST"), (Locale)locale));
                    }
                    info = personColl.get(0);
                }
                info.put("notNeedGenerateObjectNumber", (Object)"notNeedGenerateObjectNumber");
                if (!StringUtils.isEmpty((String)str)) {
                    info.setNumber(str);
                }
                str = (String)((DataToken)hsData.get((Object)"FName_L1")).data;
                info.setName(str, new Locale("L1"));
                str = (String)((DataToken)hsData.get((Object)"FName_L2")).data;
                info.setName(str, new Locale("L2"));
                str = (String)((DataToken)hsData.get((Object)"FName_L3")).data;
                info.setName(str, new Locale("L3"));
                str = (String)((DataToken)hsData.get((Object)"FDescription_L1")).data;
                info.setDescription(str, new Locale("L1"));
                str = (String)((DataToken)hsData.get((Object)"FDescription_L2")).data;
                info.setDescription(str, new Locale("L2"));
                str = (String)((DataToken)hsData.get((Object)"FDescription_L3")).data;
                info.setDescription(str, new Locale("L3"));
                String gender = str = (String)((DataToken)hsData.get((Object)"FGender")).data;
                if (!StringUtils.isEmpty((String)str)) {
                    if (str.equals(Genders.Male.getAlias())) {
                        info.setGender(Genders.Male);
                    } else {
                        if (!str.equals(Genders.Female.getAlias())) throw new TaskExternalException(ResourceBase.getString((String)(resStr + "EMP_GENDER"), (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)(resStr + "NOT_FOUND"), (Locale)locale));
                        info.setGender(Genders.Female);
                    }
                }
                Date date = null;
                String birthday = str = (String)((DataToken)hsData.get((Object)"FBirthday")).data;
                if (!StringUtils.isEmpty((String)str)) {
                    date = this.parseDate(str, "yyyy-MM-dd", ctx);
                    info.setBirthday(date);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FWorkTime")).data))) {
                    try {
                        Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(ResourceBase.getString((String)(resStr + "WorkTime_ERROR"), (Locale)locale));
                    }
                    info.put("FWorkTime", (Object)str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FExtWorkTime")).data))) {
                    try {
                        Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(ResourceBase.getString((String)(resStr + "ExtWorkTime_ERROR"), (Locale)locale));
                    }
                    info.put("FExtWorkTime", (Object)str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FLenOfActualService")).data))) {
                    try {
                        Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(ResourceBase.getString((String)(resStr + "LenOfActualService_ERROR"), (Locale)locale));
                    }
                    info.put("FLenOfActualService", (Object)str);
                }
                if (StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FEmployeeTypeID")).data))) {
                    throw new TaskExternalException(ResourceBase.getString((String)(resStr + "EMP_TYPE_IS_NULL"), (Locale)locale));
                }
                IEmployeeType iEmpType = EmployeeTypeFactory.getLocalInstance((Context)ctx);
                EmployeeTypeCollection empTypeColl = iEmpType.getEmployeeTypeCollection("where number = '" + str.trim() + "'");
                if (empTypeColl == null || empTypeColl.size() <= 0) throw new TaskExternalException(ResourceBase.getString((String)(resStr + "PERSON_TYPE_ERROR"), (Locale)locale));
                EmployeeTypeInfo typeInfo = empTypeColl.get(0);
                if (typeInfo.getInService().getValue() != 1 && hsData.get("FPositionID") != null) {
                    throw new TaskExternalException(ResourceBase.getString((String)(resStr + "EMPTYPE_ERROR"), (Locale)locale));
                }
                info.setEmployeeType(typeInfo);
                PersonPositionInfo ppInfo = new PersonPositionInfo();
                str = (String)((DataToken)hsData.get((Object)"FINDate")).data;
                if (!StringUtils.isEmpty((String)str)) {
                    date = this.parseDate(str, "yyyy-MM-dd", ctx);
                    ppInfo.setEnterDate(date);
                }
                HROrgUnitInfo hrOrgUnit = null;
                CtrlUnitInfo gkAdminCU = null;
                str = (String)((DataToken)hsData.get((Object)"FPersonDep")).data;
                if (StringUtils.isEmpty((String)str)) {
                    throw new TaskExternalException(ResourceBase.getString((String)(resStr + "PERSON_DEP_IS_NULL"), (Locale)locale));
                }
                IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                AdminOrgUnitCollection adminColl = iAdminOrgUnit.getAdminOrgUnitCollection("select id,name,number,isCompanyOrgUnit,CU.id,CU.name,CU.number,CU.longNumber where number = '" + str.trim() + "'");
                if (adminColl == null || adminColl.size() == 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)(resStr + "PERSON_DEP_NOT_EXIST"), (Locale)locale));
                }
                ppInfo.setGkAdmin(adminColl.get(0));
                ppInfo.setPersonDep(adminColl.get(0));
                info.put(BasePersonConstraints.GKADMIN, (Object)adminColl.get(0));
                gkAdminCU = adminColl.get(0).getCU();
                String kaNumber = (String)((DataToken)hsData.get((Object)"FClassfication")).data;
                if (!StringUtils.isEmpty((String)kaNumber)) {
                    IKAClassfication iKAClassfication = KAClassficationFactory.getLocalInstance((Context)ctx);
                    String oql = null;
                    boolean isCompany = adminColl.get(0).isIsCompanyOrgUnit();
                    if (!isCompany) {
                        throw new TaskExternalException(ResourceBase.getString((String)(resStr + "KACLASSFICATION_ERROR"), (Locale)locale));
                    }
                    oql = "where number ='" + kaNumber + "' and currencyCompany ='" + adminColl.get(0).getId().toString() + "'";
                    KAClassficationCollection kaColl = iKAClassfication.getKAClassficationCollection(oql);
                    if (kaColl == null || kaColl.size() <= 0) throw new TaskExternalException(ResourceBase.getString((String)(resStr + "KACLASSFICATION_ERROR"), (Locale)locale));
                    info.setKaClassfication(kaColl.get(0));
                } else {
                    info.setKaClassfication(null);
                }
                if (info.getId() == null) {
                    try {
                        hrOrgUnit = HROrgContextManagerFacadeFactory.getLocalInstance((Context)ctx).getHROByAdminOrgUnitID(adminColl.get(0).getId().toString());
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                    if (hrOrgUnit != null) {
                        info.setCU(hrOrgUnit.getCU());
                    } else {
                        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                    }
                }
                if (this.adminRangeList != null && !this.adminRangeList.contains(adminColl.get(0).getId().toString())) {
                    throw new TaskExternalException(ResourceBase.getString((String)(resStr + "NO_PERMISSON_MODIFY_PERSON"), (Locale)locale));
                }
                HashSet<CtrlUnitInfo> hashSet = new HashSet<CtrlUnitInfo>();
                hashSet.add(gkAdminCU);
                try {
                    set = HRMulCUChangeUtil.getParentCU(hashSet);
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(ResourceBase.getString((String)(resStr + "EMPCLASSIFY_ERROR"), (Locale)locale));
                }
                str = (String)((DataToken)hsData.get((Object)"FEmployeeClassifyID")).data;
                if (!StringUtils.isEmpty((String)str)) {
                    EmployeeClassifyCollection empClassifyColl = null;
                    IEmployeeClassify iEC = EmployeeClassifyFactory.getLocalInstance((Context)ctx);
                    FilterInfo filter = new FilterInfo();
                    viewInfo = new EntityViewInfo();
                    filter.getFilterItems().add(new FilterItemInfo("CU.number", (Object)set, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0 and #1");
                    viewInfo.setFilter(filter);
                    empClassifyColl = iEC.getEmployeeClassifyCollection(viewInfo);
                    if (empClassifyColl == null || empClassifyColl.size() <= 0) throw new TaskExternalException(ResourceBase.getString((String)(resStr + "EMPCLASSIFY_ERROR"), (Locale)locale));
                    info.setEmployeeClassify(empClassifyColl.get(0));
                }
                if (hsData.get("FDimissionReason") != null && (str = (String)((DataToken)hsData.get((Object)"FDimissionReason")).data) != null && str.trim().length() > 0) {
                    FilterInfo filter = new FilterInfo();
                    EntityViewInfo viewInfo2 = new EntityViewInfo();
                    filter.getFilterItems().add(new FilterItemInfo("CU.number", (Object)set, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0 and #1");
                    viewInfo2.setFilter(filter);
                    IDimissionReason dr = DimissionReasonFactory.getLocalInstance((Context)ctx);
                    DimissionReasonCollection drCol = dr.getDimissionReasonCollection(viewInfo2);
                    if (drCol == null || drCol.size() == 0) {
                        throw new TaskExternalException(ResourceBase.getString((String)(resStr + "NO_DIMMISIONREASON_NOT_EXISTS"), (Locale)locale));
                    }
                    ppInfo.setDimissionReason(drCol.get(0));
                }
                info.put("personPosition", (Object)ppInfo);
                str = hsData.get("FPositionID") == null ? "" : (String)((DataToken)hsData.get((Object)"FPositionID")).data;
                if (!StringUtils.isEmpty((String)str)) {
                    PositionCollection posiColl = null;
                    IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
                    posiColl = iPosition.getPositionCollection("select id,adminOrgUnit.CU where number = '" + str.trim() + "'");
                    if (posiColl == null || posiColl.size() <= 0) throw new TaskExternalException(ResourceBase.getString((String)(resStr + "NOT_FOUND_POSITION"), (Locale)locale));
                    PositionMemberCollection pmColl = null;
                    PositionMemberInfo pmInfo = null;
                    if (info.getId() != null) {
                        IPositionMember iPM = PositionMemberFactory.getLocalInstance((Context)ctx);
                        pmColl = iPM.getPositionMemberCollection("where person='" + info.getId() + "' and position='" + posiColl.get(0).getId() + "'");
                        if (pmColl.size() > 0) {
                            pmInfo = pmColl.get(0);
                        }
                    } else {
                        try {
                            hrOrgUnit = HROrgContextManagerFacadeFactory.getLocalInstance((Context)ctx).getHROByAdminOrgUnitID(posiColl.get(0).getAdminOrgUnit().getId().toString());
                        }
                        catch (Exception e) {
                            throw new TaskExternalException(e.getMessage(), (Throwable)e);
                        }
                        if (hrOrgUnit != null) {
                            info.setCU(hrOrgUnit.getCU());
                        } else {
                            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                        }
                    }
                    if (pmInfo == null) {
                        pmInfo = new PositionMemberInfo();
                        pmInfo.setPosition(posiColl.get(0));
                        str = (String)((DataToken)hsData.get((Object)"FIsPrimary")).data;
                        pmInfo.setIsPrimary(this.getBooleanFromAlias(str).booleanValue());
                    }
                    if (this.adminRangeList != null && !this.adminRangeList.contains(posiColl.get(0).getAdminOrgUnit().getId().toString())) {
                        throw new TaskExternalException(ResourceBase.getString((String)(resStr + "NO_PERMISSON_MODIFY_PERSON"), (Locale)locale));
                    }
                    pmColl = new PositionMemberCollection();
                    pmColl.add(pmInfo);
                    info.put("PositionList", (Object)pmColl);
                } else if (info.getEmployeeType().getInService().getValue() == 1) {
                    throw new TaskExternalException(ResourceBase.getString((String)(resStr + "NOT_IMPORT_INSERVICE"), (Locale)locale));
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FPassportNO")).data))) {
                    info.setPassportNO(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FIDCardNO")).data))) {
                    info.setIdCardNO(str);
                    try {
                        String paramNum = "IS_IDCARD_VERIFY";
                        String hrOrgId = null;
                        if (hrOrgUnit == null) {
                            hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx);
                        }
                        if (hrOrgUnit != null) {
                            hrOrgId = hrOrgUnit.getId().toString();
                        }
                        info.setHrOrgUnit(hrOrgUnit);
                        boolean isIDCardVerify = HRParamUtil.getParamOfHR((Context)ctx, (String)paramNum, (String)hrOrgId);
                        if (isIDCardVerify) {
                            IDCardCommonUtil idcard = new IDCardCommonUtil(str, isIDCardVerify);
                            info.setGender(idcard.getGenders());
                            Date birth = this.parseDate(idcard.getBirthday(), "yyyy-MM-dd", ctx);
                            info.setBirthday(birth);
                        }
                    }
                    catch (BaseException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                    catch (EASBizException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                }
                str = (String)((DataToken)hsData.get((Object)"FJobGrade")).data;
                int grade = 0;
                if (StringUtils.isEmpty((String)str) || info.getCU() == null) break block66;
                try {
                    grade = Integer.parseInt(str);
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)(resStr + "JOBGRADE_ERROR"), (Locale)locale));
                }
                MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.JobGradeListQuery");
                IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
                viewInfo = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("grade", (Object)grade));
                fi.getFilterItems().add(new FilterItemInfo("toAdminCU.id", (Object)info.getCU().getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("jobGradeModuleState.enable", (Object)"1"));
                viewInfo.setFilter(fi);
                queryExcu.setObjectView(viewInfo);
                IRowSet rows = queryExcu.executeQuery();
                String jobGradeID = null;
                boolean jobGradeResult = false;
                try {
                    if (rows.next()) {
                        jobGradeID = rows.getString("id");
                    } else {
                        jobGradeResult = true;
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (jobGradeResult) {
                    throw new TaskExternalException(ResourceBase.getString((String)(resStr + "NOT_FOUND_JOBGRADE"), (Locale)locale));
                }
                IJobGrade iJobGrade = JobGradeFactory.getLocalInstance((Context)ctx);
                JobGradeCollection jobGradeColl = null;
                jobGradeColl = iJobGrade.getJobGradeCollection("where id = '" + jobGradeID + "'");
                if (jobGradeColl.size() <= 0) throw new TaskExternalException(ResourceBase.getString((String)(resStr + "NOT_FOUND_JOBGRADE"), (Locale)locale));
                info.put("JobGrade", (Object)jobGradeColl.get(0));
            }
            catch (BOSException e1) {
                throw new TaskExternalException(e1.getMessage(), e1.getCause());
            }
            catch (ParseException e) {
                throw new TaskExternalException(ResourceBase.getString((String)(resStr + "DATE_ERROR"), (Locale)locale), (Throwable)e);
            }
        }
        info.put(HRImportConstraints.IMPORTFROMFLAG, this.getContextParameter().get("from"));
        if (this.checkPermission("noposition_emp_import", info, ctx)) return info;
        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.NOIMPORTPERMISSION", (Locale)ctx.getLocale()));
    }

    private Boolean getBooleanFromAlias(String isPrimary) {
        if ("Y".equalsIgnoreCase(isPrimary)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, String[]> exportMap = new HashMap<String, String[]>();
        exportMap.put("queryFiled", new String[]{"number", "name", "admin.number", "et.number", "pp.newWorkTime", "pp.extWorkTime", "pp.lenOfActualService", "birthday", "pp.enterDate", "gender", "passportNO", "idCardNO", "description", "creator.createTime"});
        exportMap.put("excelFiled", new String[]{"FNumber", "FName" + HrLocaleUtil.getLocal((Context)ctx), "FPersonDep", "FEmployeeTypeID", "FWorkTime", "FExtWorkTime", "FLenOfActualService", "FBirthday", "FINDate", "FGender", "FPassportNO", "FIDCardNO", "FDescription" + HrLocaleUtil.getLocal((Context)ctx), "FCreateTime"});
        exportMap.put("FiledType", new String[0]);
        return ExportUtil.transeExport((IRowSet)rs, exportMap);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("position.number", null, CompareType.EQUALS));
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.person.app.PersonExportQuery";
    }
}

