/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.IPersonPositionExtend;
import com.kingdee.eas.hr.emp.PersonDegreeCollection;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionExtendCollection;
import com.kingdee.eas.hr.emp.PersonPositionExtendFactory;
import com.kingdee.eas.hr.emp.PersonPositionExtendInfo;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonDegreeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

public class PersonDegreeControllerBean
extends AbstractPersonDegreeControllerBean {
    @Override
    protected IObjectCollection _getDegreeByPerson(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return this.getPersonDegreeCollection(ctx, evi);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PersonDegreeInfo info = this.getPersonDegreeInfo(ctx, pk);
        if (info.isIsHighest()) {
            IPersonPositionExtend iPPEX;
            String personId = info.getPerson().getId().toString();
            String id = info.getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
            if (this._exists(ctx, filter)) {
                throw new EmployeeException(EmployeeException.MUST_EXIST_ONE_LESS_DEGREE);
            }
            IPerson iP = PersonFactory.getLocalInstance((Context)ctx);
            PersonInfo pInfo = iP.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
            pInfo.put("IS_UPDATE_HIGHESTDEGREE", (Object)Boolean.TRUE);
            pInfo.setHighestDegree(null);
            pInfo.setHighestSubDegree(null);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("highestDegree"));
            selector.add(new SelectorItemInfo("highestSubDegree"));
            iP.updatePartial((CoreBaseInfo)pInfo, selector);
            IPersonPosition iPP = PersonPositionFactory.getLocalInstance(ctx);
            if (iPP.exists("where person.id='" + pInfo.getId() + "'")) {
                PersonPositionCollection ppColl = iPP.getPersonPositionCollection("where person.id='" + pInfo.getId() + "'");
                PersonPositionInfo ppInfo = ppColl.get(0);
                ppInfo.setHighestDegreeDate(null);
                ppInfo.setHighestPersonDegree(null);
                selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("highestDegreeDate"));
                selector.add(new SelectorItemInfo("highestPersonDegree"));
                iPP.updatePartial(ppInfo, selector);
            }
            if ((iPPEX = PersonPositionExtendFactory.getLocalInstance(ctx)).exists("where person.id='" + pInfo.getId() + "'")) {
                PersonPositionExtendCollection ppEXColl = iPPEX.getPersonPositionExtendCollection("where person.id='" + pInfo.getId() + "'");
                PersonPositionExtendInfo ppExInfo = ppEXColl.get(0);
                ppExInfo.setHighestDegreeDate(null);
                ppExInfo.setHighestPersonDegree(null);
                selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("highestDegreeDate"));
                selector.add(new SelectorItemInfo("highestPersonDegree"));
                iPPEX.updatePartial(ppExInfo, selector);
            }
        }
        if (info.isIsHighestDegree()) {
            IPerson iP = PersonFactory.getLocalInstance((Context)ctx);
            PersonInfo pInfo = iP.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
            pInfo.setHighestSubDegree(null);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("highestSubDegree"));
            iP.updatePartial((CoreBaseInfo)pInfo, selector);
        }
        super._delete(ctx, pk);
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        PersonDegreeInfo degreeInfo = (PersonDegreeInfo)model;
        if (degreeInfo.getPerson() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(degreeInfo.getPerson().getId());
            if (degreeInfo.getPerson().getName() == null || degreeInfo.getPerson().getNumber() == null) {
                PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)pk);
                degreeInfo.setPerson(personInfo);
            }
        }
        return super.addnew(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection selector;
        PersonInfo pInfo;
        this._checkIsNull(ctx, (PersonDegreeInfo)model);
        IPerson iP = PersonFactory.getLocalInstance((Context)ctx);
        PersonDegreeInfo info = (PersonDegreeInfo)model;
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (info.get("FROM_IMPORT_SYSTEM") != null) {
            HRUtil.canUpdateEmployee((Context)ctx, (PersonInfo)info.getPerson());
        }
        if (!this._exists(ctx, "where person.id='" + info.getPerson().getId() + "' and isHighest = 1") && !info.isIsHighest()) {
            throw new EmployeeException(EmployeeException.MUST_EXIST_ONE_LESS_DEGREE);
        }
        if (info.isIsHighest() && info.getDiploma() == null) {
            throw new EmployeeException(EmployeeException.ISHIGHT_DIPLOMA_CAN_NOT_NULL);
        }
        if (info.isIsHighestDegree() && info.getDegree() == null) {
            throw new EmployeeException(EmployeeException.ISHIGHT_DEGREE_CAN_NOT_NULL);
        }
        if (info.isIsHighest()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonDegree SET FIsHighest = 0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
        }
        if (info.isIsHighestBefore()) {
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PersonDegree SET FIsHighestBefore=0 WHERE FPersonId=?", (Object[])new Object[]{info.getPerson().getId().toString()});
        }
        if (info.isIsHighestDegree()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonDegree SET FIsHighestDegree = 0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
        }
        if (info.isIsHighAllDegree()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonDegree SET FIsHighAllDegree=0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
        }
        if (info.isIsHighWorkDeg()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonDegree SET FIsHighWorkDeg=0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
        }
        if (info.isIsHighestDegree()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonDegree SET FIsHighWorkDip=0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        Date effectDate = (Date)info.getPerson().get(HistoryConstant.EFFDT);
        if (info.isIsHighest()) {
            pInfo = iP.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
            pInfo.setHighestDegree(info.getDiploma());
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("highestDegree"));
            selector.add(new SelectorItemInfo(HistoryConstant.EFFDT));
            iP.updatePartial((CoreBaseInfo)pInfo, selector);
        }
        if (info.isIsHighestDegree() && info.getDegree() != null) {
            pInfo = iP.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
            pInfo.setHighestSubDegree(info.getDegree());
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("highestSubDegree"));
            selector.add(new SelectorItemInfo(HistoryConstant.EFFDT));
            iP.updatePartial((CoreBaseInfo)pInfo, selector);
        }
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection selector;
        PersonInfo pInfo;
        IPerson iP;
        this._checkIsNull(ctx, (PersonDegreeInfo)model);
        PersonDegreeInfo info = (PersonDegreeInfo)model;
        Date effectDate = (Date)info.getPerson().get(HistoryConstant.EFFDT);
        PersonDegreeInfo oldInfo = this.getPersonDegreeInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        if (info.get("FROM_IMPORT_SYSTEM") != null) {
            HRUtil.canUpdateEmployee((Context)ctx, (PersonInfo)info.getPerson());
        }
        String oql = "select id where isHighest = 1 and person.id = '" + info.getPerson().getId().toString() + "' and id <> '" + pk.toString() + "'";
        if (info.getDiploma() instanceof DiplomaInfo && !info.isIsHighest() && !this._exists(ctx, oql)) {
            throw new EmployeeException(EmployeeException.MUST_EXIST_ONE_LESS_DEGREE);
        }
        if (oldInfo.isIsHighest() && (!info.isIsHighest() || info.getDiploma() == null)) {
            throw new EmployeeException(EmployeeException.MUST_EXIST_ONE_LESS_DEGREE);
        }
        if (info.isIsHighestDegree() && info.getDegree() == null) {
            throw new EmployeeException(EmployeeException.ISHIGHT_DEGREE_CAN_NOT_NULL);
        }
        if (info.isIsHighest()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonDegree SET FIsHighest = 0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
        }
        if (info.isIsHighestBefore()) {
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PersonDegree SET FIsHighestBefore=0 WHERE FPersonId=?", (Object[])new Object[]{info.getPerson().getId().toString()});
        }
        if (info.isIsHighestDegree()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonDegree SET FIsHighestDegree = 0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
        }
        if (info.isIsHighAllDegree()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonDegree SET FIsHighAllDegree=0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
        }
        if (info.isIsHighWorkDeg()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonDegree SET FIsHighWorkDeg=0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
        }
        if (info.isIsHighestDegree()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonDegree SET FIsHighWorkDip=0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
        }
        super._update(ctx, pk, model);
        if (info.isIsHighest()) {
            iP = PersonFactory.getLocalInstance((Context)ctx);
            pInfo = iP.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
            pInfo.setHighestDegree(info.getDiploma());
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("highestDegree"));
            selector.add(new SelectorItemInfo(HistoryConstant.EFFDT));
            iP.updatePartial((CoreBaseInfo)pInfo, selector);
        }
        if (info.isIsHighestDegree()) {
            iP = PersonFactory.getLocalInstance((Context)ctx);
            pInfo = iP.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
            pInfo.setHighestSubDegree(info.getDegree());
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("highestSubDegree"));
            selector.add(new SelectorItemInfo(HistoryConstant.EFFDT));
            iP.updatePartial((CoreBaseInfo)pInfo, selector);
        } else if (oldInfo.isIsHighestDegree()) {
            iP = PersonFactory.getLocalInstance((Context)ctx);
            pInfo = iP.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
            pInfo.setHighestSubDegree(null);
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("highestSubDegree"));
            selector.add(new SelectorItemInfo(HistoryConstant.EFFDT));
            iP.updatePartial((CoreBaseInfo)pInfo, selector);
        }
    }

    @Override
    protected IObjectValue _getHighestDegree(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        String oql = "select *, degree.id, degree.number, degree.name where isHighest = 1 and person.id = '" + personId.toString() + "'";
        PersonDegreeCollection pc = this.getPersonDegreeCollection(ctx, oql);
        if (pc.size() > 0) {
            return pc.get(0);
        }
        return null;
    }

    void _checkIsNull(Context ctx, PersonDegreeInfo info) throws EmployeeException {
    }

    void _checkDiplomaIsNull(Context ctx, PersonDegreeInfo degreeInfo) throws EmployeeException {
        if (degreeInfo.getDiploma() == null) {
            throw new EmployeeException(EmployeeException.DISPLO_CAN_NOT_NULL);
        }
    }

    void _checkSpecialtyTypeIsNull(Context ctx, PersonDegreeInfo degreeInfo) throws EmployeeException {
        if (degreeInfo.getSpecialtyType() == null) {
            throw new EmployeeException(EmployeeException.SPECIALTYTYPE_CAN_NOT_NULL);
        }
    }

    private void isMultiHighDegree(Context ctx, PersonDegreeInfo info) throws EASBizException, BOSException {
        if (info.isIsHighest()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isHighest", (Object)1, CompareType.EQUALS));
            if (info.getPerson() != null && info.getPerson().getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getPerson().getId().toString(), CompareType.EQUALS));
            }
            if (info.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            }
            if (this._exists(ctx, filter)) {
                throw new EmployeeException(EmployeeException.EMPLOYEE_DEGREE_HIGHDEGREEDUP);
            }
        }
    }

    private boolean isDegreeDup(Context ctx, PersonDegreeInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("degree.id", (Object)(info.getDegree() != null ? info.getDegree().getId() : null), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("diploma.id", (Object)(info.getDiploma() != null ? info.getDiploma().getId() : null), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("specialtyType.id", (Object)(info.getSpecialtyType() != null ? info.getSpecialtyType().getId() : null), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("degreeCountry", (Object)info.getDegreeCountry(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getPerson().getId(), CompareType.EQUALS));
        int maskNum = 5;
        StringBuffer maskStr = new StringBuffer();
        String degreeUnit = info.getDegreeUnit();
        String specialty = info.getSpecialty();
        if (StringUtils.isEmpty((String)degreeUnit)) {
            filter.getFilterItems().add(new FilterItemInfo("degreeUnit", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("degreeUnit", (Object)"", CompareType.EQUALS));
            maskStr.append(" and (#" + maskNum + " or #" + (maskNum + 1) + ")");
            maskNum += 2;
        } else {
            filter.getFilterItems().add(new FilterItemInfo("degreeUnit", (Object)degreeUnit, CompareType.EQUALS));
            maskStr.append(" and #" + maskNum);
            ++maskNum;
        }
        if (StringUtils.isEmpty((String)specialty)) {
            filter.getFilterItems().add(new FilterItemInfo("specialty", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("specialty", (Object)"", CompareType.EQUALS));
            maskStr.append(" and (#" + maskNum + " or #" + (maskNum + 1) + ")");
            maskNum += 2;
        } else {
            filter.getFilterItems().add(new FilterItemInfo("specialty", (Object)specialty, CompareType.EQUALS));
            maskStr.append(" and #" + maskNum);
            ++maskNum;
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            maskStr.append(" and #" + maskNum);
            ++maskNum;
        }
        filter.setMaskString("#0 and #1 and #2 and #3 and #4 " + maskStr.toString());
        return !this._exists(ctx, filter);
    }

    @Override
    protected IObjectPK[] _saveAll(Context ctx, IObjectCollection degreeColl, IObjectPK[] deleteList) throws BOSException, EASBizException {
        for (int i = 0; i < deleteList.length; ++i) {
            this._delete(ctx, deleteList[i]);
        }
        return this.addAndUpdate(ctx, (PersonDegreeCollection)degreeColl);
    }

    private IObjectPK[] addAndUpdate(Context ctx, PersonDegreeCollection degreeColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        for (int i = 0; i < degreeColl.size(); ++i) {
            if (degreeColl.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)degreeColl.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(degreeColl.get(i).getId()), (IObjectValue)degreeColl.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    private void deleteList(Context ctx, IObjectPK[] deleteList) throws EASBizException, BOSException {
        if (deleteList == null || deleteList.length == 0) {
            return;
        }
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < deleteList.length; ++i) {
            set.add(deleteList[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        this._delete(ctx, filter);
    }

    @Override
    protected boolean _isDegreeRepeat(Context ctx, IObjectValue personDegreeInfo) throws BOSException, EASBizException {
        return this.isDegreeDup(ctx, (PersonDegreeInfo)personDegreeInfo);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        PersonDegreeInfo info = (PersonDegreeInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }
}

