/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qing.data.util.DateUtils;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AgentUserManagerFacadeFactory;
import com.kingdee.eas.base.permission.IAgentUserManagerFacade;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.basedata.assistant.util.TimeZoneUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryFactory;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.ConstellationInfo;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpSalaryItemDataCollection;
import com.kingdee.eas.hr.base.EmpSalaryItemDataFactory;
import com.kingdee.eas.hr.base.EmpSalaryItemDataPartFactory;
import com.kingdee.eas.hr.base.EmpSignFeeFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.VariationReasonInfo;
import com.kingdee.eas.hr.base.ZodiacInfo;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAppUtils;
import com.kingdee.eas.hr.base.timezone.TimeZoneEventEnum;
import com.kingdee.eas.hr.base.util.EmpEnrollUserPermHelper;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.base.util.IntegratedPatternCheckUtil;
import com.kingdee.eas.hr.base.util.SHRMathUtils;
import com.kingdee.eas.hr.base.util.SystemInitUtil;
import com.kingdee.eas.hr.emp.CheckInState;
import com.kingdee.eas.hr.emp.EmpInnerFacadeFactory;
import com.kingdee.eas.hr.emp.EmployeeBizException;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.INewEmployee;
import com.kingdee.eas.hr.emp.IPersonChange;
import com.kingdee.eas.hr.emp.IPersonContactMethod;
import com.kingdee.eas.hr.emp.IPersonOtherInfo;
import com.kingdee.eas.hr.emp.IPrePerson;
import com.kingdee.eas.hr.emp.ISocialInsurance;
import com.kingdee.eas.hr.emp.NewEmployeeFactory;
import com.kingdee.eas.hr.emp.NewEmployeeInfo;
import com.kingdee.eas.hr.emp.PersonChangeFactory;
import com.kingdee.eas.hr.emp.PersonChangeInfo;
import com.kingdee.eas.hr.emp.PersonContactMethodCollection;
import com.kingdee.eas.hr.emp.PersonContactMethodFactory;
import com.kingdee.eas.hr.emp.PersonContactMethodInfo;
import com.kingdee.eas.hr.emp.PersonInfoIntegrityFactory;
import com.kingdee.eas.hr.emp.PersonInfoIntegrityInfo;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonPositionOptFacadeFactory;
import com.kingdee.eas.hr.emp.PrePersonCollection;
import com.kingdee.eas.hr.emp.PrePersonFactory;
import com.kingdee.eas.hr.emp.PrePersonHISCollection;
import com.kingdee.eas.hr.emp.PrePersonHISFactory;
import com.kingdee.eas.hr.emp.PrePersonHISInfo;
import com.kingdee.eas.hr.emp.PrePersonInfo;
import com.kingdee.eas.hr.emp.SocialInsuranceCollection;
import com.kingdee.eas.hr.emp.SocialInsuranceFactory;
import com.kingdee.eas.hr.emp.SocialInsuranceInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonOptFacadeControllerBean;
import com.kingdee.eas.hr.emp.app.PersonOptBaseInfo;
import com.kingdee.eas.hr.emp.app.util.HREmpCommonUtil;
import com.kingdee.eas.hr.emp.app.util.RecEntryServiceUtil;
import com.kingdee.eas.hr.emp.app.util.SHRBizManageRelationUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.hr.org.HRAdminOrgException;
import com.kingdee.eas.hr.org.HRVerifyModelFacadeFactory;
import com.kingdee.eas.hr.org.JobSequenceCollection;
import com.kingdee.eas.hr.org.JobSequenceFactory;
import com.kingdee.eas.hr.org.OrgAdjustEnableException;
import com.kingdee.eas.hr.org.util.OrgAdjLockManager;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.PersonBizManageFacadeFactory;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PersonOptFacadeControllerBean
extends AbstractPersonOptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.PersonOptFacadeControllerBean");

    @Override
    protected IObjectPK _personAddNew(Context ctx, Date EFFDT, PersonOptBaseInfo personOptBaseInfo) throws BOSException, EASBizException {
        SystemInitUtil.checkInitState((Context)ctx);
        PersonInfo pInfo = personOptBaseInfo.getPerson();
        if (StringUtils.isEmpty((String)pInfo.getName())) {
            throw new EmployeeBizException(EmployeeBizException.EMPNAME_NOT_NULL);
        }
        pInfo.setName(pInfo.getName().trim());
        this.upperIdCardNo(pInfo);
        PersonPositionInfo ppInfo = personOptBaseInfo.getPersonPosition();
        if (ppInfo.getPrimaryPosition() != null) {
            SHRBizManageRelationUtil.checkPositionOfAdminBizManageDelegated(ctx, ppInfo.getPrimaryPosition().getId().toString());
            AdminOrgUnitInfo adminOrg = ppInfo.getPersonDep();
            AdminOrgUnitInfo cuAdminOrg = HRUtilExtend.getCuByOrg((Context)ctx, (AdminOrgUnitInfo)adminOrg);
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(cuAdminOrg.getId());
            pInfo.setCU(cu);
        }
        pInfo.setEFFDT(EFFDT);
        HashMap<String, PersonInfo> param = new HashMap<String, PersonInfo>();
        pInfo.put("personposition", (Object)ppInfo);
        param.put("pinfo", pInfo);
        try {
            OSFAppUtil.callService((Context)ctx, (String)"getPersonCodingRuleStr", param);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        pInfo.put("IS_FROM_SHR_OPTAction", (Object)Boolean.TRUE);
        HRUtilExtend.assableCell((CoreBaseInfo)pInfo, (String)"cell");
        ServiceStateManager.getInstance().enableNextCallServices();
        IObjectPK pk = PersonFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)pInfo);
        this.checkEffdt(ctx, pInfo.getEFFDT(), pInfo, null);
        pInfo.setId(BOSUuid.read((String)pk.toString()));
        try {
            com.kingdee.eas.hr.base.timezone.TimeZoneUtil.updateTimeZone((Context)ctx, (Object)pInfo, (TimeZoneInfo)TimeZoneUtil.getServerTimeZoneInfo((Context)ctx, null), (Object)TimeZoneEventEnum.BIZ_MANAGE_MSG, (Object)pInfo.getEFFDT(), (Object)pInfo.getLEFFDT());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
        }
        this.addNewPersonPositionInfo(ctx, pInfo, ppInfo);
        this.syncPersonToPersonInfoIntegrity(ctx, pInfo);
        if (pInfo.get("isOverrideImportPerson") == null) {
            PersonPhotoInfo photoInfo = personOptBaseInfo.getPersonPhoto();
            if (photoInfo != null) {
                photoInfo.setPerson(pInfo);
                PersonPhotoFactory.getLocalInstance(ctx).addnew(photoInfo);
            }
            this.addPersonSocialInsuranceInfo(ctx, pInfo);
            this.addNewEmployeeInfo(ctx, pInfo);
            EmpEnrollUserPermHelper.autoCreateUser((Context)ctx, (PersonInfo)pInfo, (String)((String)pInfo.get("userNumber")), (boolean)false, (Date)EFFDT, (AdminOrgUnitInfo)ppInfo.getPersonDep());
        }
        if (pInfo.get("isOverrideImportPerson") != null && !UserFactory.getLocalInstance((Context)ctx).exists("select id where person.id='" + pk + "'")) {
            EmpEnrollUserPermHelper.autoCreateUser((Context)ctx, (PersonInfo)pInfo, (boolean)false, (Date)EFFDT, (AdminOrgUnitInfo)ppInfo.getPersonDep());
        }
        this.doWhthPersonOtherInfo(ctx, pInfo);
        if (!personOptBaseInfo.isFromInitialize() && personOptBaseInfo.isFromSSC()) {
            this._doWithSyncSSCInfo(ctx, pk.toString(), pInfo.getString("entryid"));
        } else if (!personOptBaseInfo.isFromInitialize()) {
            this._doWithResumeInfo(ctx, pInfo);
        }
        this.doWithPersonContactMethod(ctx, pInfo);
        this.setPrePersonEnrolled(ctx, pk);
        String className = "com.kingdee.eas.hr.emp.app.PersonOptFacadeControllerBean";
        HREmpCommonUtil.executeOther(ctx, className, "_personAddNew", "after", pInfo);
        return pk;
    }

    private void addNewPersonPositionInfo(Context ctx, PersonInfo pInfo, PersonPositionInfo ppInfo) throws EASBizException, BOSException {
        ppInfo.setPerson(pInfo);
        PersonPositionOptFacadeFactory.getLocalInstance(ctx).addNewPersonPosition(ppInfo);
    }

    @Override
    protected void _doWithResumeInfo(Context ctx, PersonInfo pInfo) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)pInfo.getIdCardNO()) || !StringUtils.isEmpty((String)pInfo.getPassportNO())) {
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "recEntryService");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("entryDate", HRUtilExtend.getDateStringWithoutMininute((Date)pInfo.getEFFDT()));
            if (!StringUtils.isEmpty((String)pInfo.getIdCardNO())) {
                param.put("idcardNo", pInfo.getIdCardNO());
            }
            if (!StringUtils.isEmpty((String)pInfo.getPassportNO())) {
                param.put("passportNo", pInfo.getPassportNO());
            }
            param.put("entryID", pInfo.getId().toString());
            param.put("affairId", pInfo.getString("entryid"));
            imsf.process(ctx, param);
        }
    }

    private void undoWithResumeInfo(Context ctx, PrePersonInfo pInfo) throws BOSException, EASBizException {
        try {
            if (pInfo == null) {
                return;
            }
            pInfo = PrePersonFactory.getLocalInstance(ctx).getPrePersonInfo((IObjectPK)new ObjectUuidPK(pInfo.getId().toString()));
            String resumeId = pInfo.getResumeID();
            if (!StringUtils.isEmpty((String)resumeId)) {
                IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "unRecEntryService");
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("resumeId", resumeId);
                imsf.process(ctx, param);
            }
        }
        catch (Exception e) {
            System.out.println("unRecEntryService(OSF) exception");
            e.printStackTrace();
        }
    }

    @Deprecated
    private void setJobSequenceInfo(Context ctx, PersonPositionInfo posInfo) throws BOSException {
        PositionInfo primaryPosInfo = posInfo.getPrimaryPosition();
        if (posInfo.getJobGrade() != null) {
            JobInfo jobInfo;
            String oql = "select job.id where id='" + primaryPosInfo.getId().toString() + "'";
            PositionCollection posColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(oql);
            if (posColl.size() > 0 && (jobInfo = posColl.get(0).getJob()) != null) {
                oql = "select id,name where job.id='" + jobInfo.getId() + "' and jobGrade.id='" + posInfo.getJobGrade().getId() + "'";
                JobSequenceCollection jobSeqColl = JobSequenceFactory.getLocalInstance((Context)ctx).getJobSequenceCollection(oql);
                if (jobSeqColl.size() > 0) {
                    posInfo.setJobSequence(jobSeqColl.get(0));
                }
            }
        }
    }

    @Override
    protected void _personUpdate(Context ctx, Date EFFDT, PersonOptBaseInfo personOptBaseInfo) throws BOSException, EASBizException {
        PersonPhotoInfo photoInfo;
        PersonPositionInfo ppInfo;
        PersonInfo pInfo = personOptBaseInfo.getPerson();
        if (StringUtils.isEmpty((String)pInfo.getName())) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
        pInfo.setName(pInfo.getName().trim());
        EmpHRORelationHisInfo personBURelationInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo(ctx, pInfo.getId().toString());
        if (personBURelationInfo != null) {
            pInfo.setHrOrgUnit(personBURelationInfo.getHrOrgUnit());
        }
        this.upperIdCardNo(pInfo);
        if (personOptBaseInfo.getPersonPosition() == null || !personOptBaseInfo.getPersonPosition().isIsEnrollAgain()) {
            EmpInnerFacadeFactory.getLocalInstance(ctx).checkPersonValid(pInfo, pInfo.getIdCardNO(), pInfo.getPassportNO());
        }
        if ((ppInfo = personOptBaseInfo.getPersonPosition()) != null && ppInfo.getPrimaryPosition() != null) {
            SHRBizManageRelationUtil.checkPositionOfAdminBizManageDelegated(ctx, ppInfo.getPrimaryPosition().getId().toString());
            AdminOrgUnitInfo adminOrg = ppInfo.getPersonDep();
            AdminOrgUnitInfo cuAdminOrg = HRUtilExtend.getCuByOrg((Context)ctx, (AdminOrgUnitInfo)adminOrg);
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(cuAdminOrg.getId());
            pInfo.setCU(cu);
        }
        pInfo.setEFFDT(EFFDT);
        String historyOperateState = pInfo.getExtendedProperty("historyOperateState");
        this.checkEffdt(ctx, pInfo.getEFFDT(), pInfo, historyOperateState);
        if ("revise".equals(historyOperateState)) {
            this.deletePersonHisWhenRevise(ctx, pInfo.getId().toString(), pInfo.getEFFDT());
        } else if ("change".equals(historyOperateState)) {
            pInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            pInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        }
        if (!"true".equals(pInfo.get("isEnrollAgain"))) {
            this.checkPersonHireDateIsChanged(ctx, pInfo);
        }
        if (pInfo.containsKey("employeeType")) {
            pInfo.remove("employeeType");
        }
        pInfo.put("IS_FROM_SHR_OPTAction", (Object)Boolean.TRUE);
        HRUtilExtend.assableCell((CoreBaseInfo)pInfo, (String)"cell");
        ServiceStateManager.getInstance().enableNextCallServices();
        PersonFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(pInfo.getId().toString()), (CoreBaseInfo)pInfo);
        if (ppInfo != null) {
            ppInfo.setPerson(pInfo);
            ppInfo.setEFFDT(EFFDT);
            PersonPositionFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(ppInfo.getId().toString()), ppInfo);
        }
        if ((photoInfo = personOptBaseInfo.getPersonPhoto()) != null) {
            photoInfo.setPerson(pInfo);
            PersonPhotoFactory.getLocalInstance(ctx).addnew(photoInfo);
        }
        this.doWhthPersonOtherInfo(ctx, pInfo);
        if (null != pInfo.getString("entryId")) {
            if (!personOptBaseInfo.isFromInitialize() && personOptBaseInfo.isFromSSC()) {
                this._doWithSyncSSCInfo(ctx, pInfo.getId().toString(), pInfo.getString("entryId"));
            } else if (!personOptBaseInfo.isFromInitialize()) {
                this._doWithResumeInfo(ctx, pInfo);
            }
        }
        this.doWithPersonContactMethod(ctx, pInfo);
    }

    @Override
    protected void _personDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean flag = false;
        String oql = "select position.id where person.id='" + pk + "'";
        PositionMemberCollection pmColl = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(oql);
        int size = pmColl.size();
        for (int i = 0; i < size; ++i) {
            OrgAdjLockManager.checkIfOrgLocked((Context)ctx, null, (String)pmColl.get(i).getPosition().getId().toString());
        }
        IntegratedPatternCheckUtil.checkIsShr2Cloud((Context)ctx, (String)SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label73", (Context)ctx));
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo(pk);
        PrePersonCollection prePersonColl = RecEntryServiceUtil.getPrePersonInfoByEnrolledPersonId(ctx, personInfo);
        if (null != prePersonColl && prePersonColl.size() != 0 && null != prePersonColl.get(0)) {
            flag = true;
        }
        this._unenrolledPreentryState(ctx, pk.toString());
        this._deletePersonData(ctx, pk);
        RecEntryServiceUtil.undoWithResumeInfo(ctx, flag, pk.toString());
    }

    private void _unenrolledPreentryState(Context ctx, String personId) throws BOSException, EASBizException {
        String personBillId = "";
        String sqlStr = "SELECT FID FROM T_HR_EMPENROLLBIZBILLENTRY WHERE FPERSONID = '" + personId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
        try {
            if (rs.size() > 0) {
                while (rs.next()) {
                    personBillId = rs.getString("FID");
                    PreEntryCollection coll = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection("select isGenerateEntryBill,checkInState where personBillId = '" + personBillId + "'");
                    if (coll.size() <= 0) continue;
                    PreEntryInfo preEntryInfo = coll.get(0);
                    preEntryInfo.setCheckInState(CheckInState.NOT_CHECKED_IN);
                    preEntryInfo.setIsGenerateEntryBill(false);
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    selectors.add(new SelectorItemInfo("checkInState"));
                    selectors.add(new SelectorItemInfo("isGenerateEntryBill"));
                    PreEntryFactory.getLocalInstance((Context)ctx).updatePartial(preEntryInfo, selectors);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }

    private void _deletePersonData(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String personId = pk.toString();
        PersonInfo info = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo(pk);
        this.deletePersonBuRelation(ctx, personId);
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonInfoIntegrity where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonPosition where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_ORG_PositionMember where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpInnerWorkExp where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpOrgRelation where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpLaborRelation where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_NewEmployee where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonContactMethod where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from t_hr_personotherinfo where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_AffairBizHistory where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_AffairBizDetail where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_HRAffairBiz where fpersonid='" + personId + "'"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT FID  from T_HR_EmpEnrollBizBillEntry where FBillID in (select FBillID from T_HR_EmpEnrollBizBillEntry where fpersonid = '" + personId + "')"));
        if (rs.size() < 2) {
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpEnrollBizBill where fid in (select FBillID from T_HR_EmpEnrollBizBillEntry where fpersonid = '" + personId + "')"));
        }
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpEnrollBizBillEntry where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_SPersonCmp where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonCmp where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonCertify where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonLinkman where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_SocialInsurance where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonWorkExp where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonWorkExpCur where fpersonid='" + personId + "'"));
        this.deleteOtherBizInfo(ctx, personId);
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonPositionHis where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpLaborRelationHis where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpPostExperienceHis where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpFlowInOut where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from t_bd_personHis where FHistoryRelateID='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from t_hr_personfact where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from t_hr_personotherinfohis where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonPhoto SET FPERSONID =''  WHERE  FPERSONID ='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonBUBrowse where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpSalaryAdjustment where fpersonid='" + personId + "'"));
        this.deleteSalaryItemData(ctx, personId);
        IAgentUserManagerFacade iAgentUser = AgentUserManagerFacadeFactory.getLocalInstance((Context)ctx);
        iAgentUser.deleteAgentUser(info.getNumber());
        this.deleteUserInfo(ctx, personId);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("personId", personId);
        OSFAppUtil.callService((Context)ctx, (String)"deletePersonPageInfoService", param);
        PersonFactory.getLocalInstance((Context)ctx).isReferenced((IObjectPK)new ObjectUuidPK(personId));
        ServiceStateManager.getInstance().enableNextCallServices();
        PersonFactory.getLocalInstance((Context)ctx).delete(pk);
        DbUtil.execute((Context)ctx, (String)("delete from t_bd_person where fid='" + personId + "'"));
        RecEntryServiceUtil.deletePersonForRecService(ctx, pk.toString());
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PERSONENROLLHISTORY where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonCredentialsType where fpersonid='" + personId + "'"));
    }

    private void deleteOtherBizInfo(Context ctx, String personId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        view.setFilter(filter);
        ISocialInsurance iSocialInsurance = SocialInsuranceFactory.getLocalInstance(ctx);
        SocialInsuranceCollection coll = iSocialInsurance.getSocialInsuranceCollection(view);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            iSocialInsurance.delete((IObjectPK)new ObjectUuidPK(coll.get(i).getId().toString()));
        }
        String sql = "delete from T_HR_SPersonCmp where FPersonId='" + personId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void deleteUserInfo(Context ctx, String personId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        view.setFilter(filter);
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userColl = iUser.getUserCollection(view);
        int size = userColl.size();
        for (int i = 0; i < size; ++i) {
            UserInfo userInfo = userColl.get(i);
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId().toString());
            StringBuffer sbSQL = new StringBuffer();
            sbSQL = new StringBuffer();
            sbSQL.append("DELETE FROM T_PM_UserRoleOrg WHERE FUserID ='").append(userPK).append("'");
            DbUtil.execute((Context)ctx, (String)sbSQL.toString());
            sbSQL = new StringBuffer();
            sbSQL.append("DELETE FROM T_PM_UserOrgPerm WHERE FOwner = '").append(userPK).append("'");
            DbUtil.execute((Context)ctx, (String)sbSQL.toString());
            sbSQL = new StringBuffer();
            sbSQL.append("DELETE FROM T_PM_OrgRange WHERE FUserID = '").append(userPK).append("'");
            DbUtil.execute((Context)ctx, (String)sbSQL.toString());
            sbSQL = new StringBuffer();
            sbSQL.append("DELETE FROM T_PM_OrgRangeIncludeSubOrg WHERE FUserID = '").append(userPK).append("'");
            DbUtil.execute((Context)ctx, (String)sbSQL.toString());
            this.abandonedUserNumber(ctx, userInfo, personId);
            IObjectPK[] objs = new IObjectPK[]{userPK};
            iUser.delete(objs);
        }
    }

    private void abandonedUserNumber(Context ctx, UserInfo userInfo, String personId) throws EASBizException, BOSException {
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        String number = userInfo.getNumber();
        number = number + "-exp";
        number = EmpEnrollUserPermHelper.getUserNumber((Context)ctx, (String)number, (String)personId, (int)0);
        userInfo.setNumber(number);
        userInfo.setPerson(null);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("person"));
        iUser.updatePartial((CoreBaseInfo)userInfo, selector);
    }

    @Override
    protected void _personUpdatePartial(Context ctx, CoreBaseInfo model, SelectorItemCollection selector) throws BOSException, EASBizException {
        PersonFactory.getLocalInstance((Context)ctx).updatePartial(model, selector);
        this.doWithPersonContactMethod(ctx, (PersonInfo)model);
    }

    @Override
    protected void _updatePersonAdmin(Context ctx, String positionID, String adminOrgUnitID, Date effectDate, AssignTypeEnum assignType) throws BOSException, EASBizException {
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection invaidEmpColl = helper.getPersonAfterEffDT(ctx, positionID, effectDate, assignType);
        if (invaidEmpColl != null && invaidEmpColl.size() > 0) {
            throw new OrgAdjustEnableException(OrgAdjustEnableException.PERSONVALIDFAILD);
        }
        EmpPosOrgRelationCollection empPosOrgColl = helper.getAppointDateActivePerson(ctx, positionID, effectDate, assignType);
        if (empPosOrgColl == null || empPosOrgColl.size() <= 0) {
            return;
        }
        HRBizDefineInfo onPosBizDefInfo = HRBizDefineAppUtils.getHRBizDefineInfo((Context)ctx, (String)"8r0AAAADbujmaL7Z");
        AffairActionReasonInfo onPosBizDefReason = null;
        if (onPosBizDefInfo != null && onPosBizDefInfo.getActionReasons() != null && onPosBizDefInfo.getActionReasons().size() > 0) {
            onPosBizDefReason = onPosBizDefInfo.getActionReasons().get(0).getActionReason();
        }
        VariationReasonInfo actionReasonInfo = null;
        if (onPosBizDefInfo != null && onPosBizDefInfo.getVariationReasons() != null && onPosBizDefInfo.getVariationReasons().size() > 0) {
            actionReasonInfo = onPosBizDefInfo.getVariationReasons().get(0).getVariationReason();
        }
        HRBizDefineInfo partTimeDefineInfo = HRBizDefineAppUtils.getHRBizDefineInfo((Context)ctx, (String)"cM5s6yPmTba5BXMKa6+h8uZovtk=");
        AffairActionReasonInfo partPosBizDefReason = null;
        if (partTimeDefineInfo != null && partTimeDefineInfo.getActionReasons() != null && partTimeDefineInfo.getActionReasons().size() > 0) {
            partPosBizDefReason = partTimeDefineInfo.getActionReasons().get(0).getActionReason();
        }
        VariationReasonInfo partActionReasonInfo = null;
        if (partTimeDefineInfo != null && partTimeDefineInfo.getVariationReasons() != null && partTimeDefineInfo.getVariationReasons().size() > 0) {
            partActionReasonInfo = partTimeDefineInfo.getVariationReasons().get(0).getVariationReason();
        }
        AdminOrgUnitInfo newAdminInfo = new AdminOrgUnitInfo();
        newAdminInfo.setId(BOSUuid.read((String)adminOrgUnitID));
        PersonChangeInfo changeInfo = null;
        EmpPosOrgRelationInfo empOrgInfo = null;
        IPersonChange iPersonChange = PersonChangeFactory.getLocalInstance(ctx);
        for (int i = 0; i < empPosOrgColl.size(); ++i) {
            changeInfo = new PersonChangeInfo();
            empOrgInfo = empPosOrgColl.get(i);
            changeInfo.setEFFDT(effectDate);
            changeInfo.setEmpPosOrgRelation(empOrgInfo);
            if (empOrgInfo.getAssignType().getValue() == 0) {
                changeInfo.setActionDef(partTimeDefineInfo);
                changeInfo.setActionReason(partActionReasonInfo);
                changeInfo.setActionType(partPosBizDefReason);
            } else {
                changeInfo.setActionDef(onPosBizDefInfo);
                changeInfo.setActionReason(actionReasonInfo);
                changeInfo.setActionType(onPosBizDefReason);
            }
            changeInfo.setPerson(empOrgInfo.getPerson());
            changeInfo.setOldAdmin(empOrgInfo.getAdminOrg());
            changeInfo.setOldPosition(empOrgInfo.getPosition());
            changeInfo.setOldLaborRelState(empOrgInfo.getLaborRelation().getLaborRelationState());
            changeInfo.setNewAdmin(newAdminInfo);
            changeInfo.setNewPosition(empOrgInfo.getPosition());
            changeInfo.setNewLaborRelState(empOrgInfo.getLaborRelation().getLaborRelationState());
            iPersonChange.save(changeInfo);
        }
    }

    private void doWithPersonContactMethod(Context ctx, PersonInfo info) throws BOSException, EASBizException {
        IPersonContactMethod iPCM = PersonContactMethodFactory.getLocalInstance(ctx);
        if (iPCM.exists("where person.id='" + info.getId() + "'")) {
            PersonContactMethodCollection pcmColl = iPCM.getPersonContactMethodCollection("where person.id='" + info.getId() + "'");
            PersonContactMethodInfo pcmInfo = pcmColl.get(0);
            if (info.containsKey("email") && info.getEmail() != null) {
                pcmInfo.setEmail(info.getEmail().trim());
            }
            if (info.containsKey("backupEMail")) {
                pcmInfo.setBackupEMail(info.getBackupEMail());
            }
            if (info.containsKey("cell") && info.getCell() != null) {
                pcmInfo.setMobile(info.getCell().trim());
            }
            if (info.containsKey("nCell") && info.getNCell() != null) {
                pcmInfo.setNCell(info.getNCell().trim());
            }
            if (info.containsKey("globalRoaming") && info.getGlobalRoaming() != null) {
                pcmInfo.setGlobalRoaming(info.getGlobalRoaming().trim());
            }
            if (info.containsKey("hrOrgUnit") && info.getHrOrgUnit() != null) {
                pcmInfo.setHrOrgUnit(info.getHrOrgUnit());
            }
            if (info.containsKey("backupCell")) {
                pcmInfo.setBackupMobile(info.getBackupCell());
            }
            if (info.containsKey("homePhone")) {
                pcmInfo.setHomePhone(info.getHomePhone());
            }
            if (info.containsKey("officePhone")) {
                pcmInfo.setOfficePhone(info.getOfficePhone());
            }
            if (info.containsKey("addressTX")) {
                pcmInfo.setAddressTX(info.getAddressTX());
            }
            if (info.containsKey("idCardAddress")) {
                pcmInfo.setIdCardAddress(info.getIdCardAddress());
            }
            if (info.containsKey("homeplace")) {
                pcmInfo.setHomeplace(info.getHomeplace());
            }
            if (info.containsKey("hjAddress")) {
                pcmInfo.setHjAddress(info.getHjAddress());
            }
            pcmInfo.put(HistoryConstant.EFFDT, info.get(HistoryConstant.EFFDT));
            pcmInfo.put("hasVerify", info.get("hasVerify"));
            pcmInfo.put("isEnrollAgain", info.get("isEnrollAgain"));
            iPCM.update((IObjectPK)new ObjectUuidPK(pcmInfo.getId()), pcmInfo);
        } else {
            PersonContactMethodInfo pcmInfo = new PersonContactMethodInfo();
            if (info.getEmail() != null) {
                pcmInfo.setEmail(info.getEmail().trim());
            }
            pcmInfo.setBackupEMail(info.getBackupEMail());
            if (info.getCell() != null) {
                pcmInfo.setMobile(info.getCell().trim());
            }
            if (info.getNCell() != null) {
                pcmInfo.setNCell(info.getNCell().trim());
            }
            if (info.getGlobalRoaming() != null) {
                pcmInfo.setGlobalRoaming(info.getGlobalRoaming().trim());
            }
            if (info.getHrOrgUnit() != null) {
                pcmInfo.setHrOrgUnit(info.getHrOrgUnit());
            }
            pcmInfo.setBackupMobile(info.getBackupCell());
            pcmInfo.setHomePhone(info.getHomePhone());
            pcmInfo.setOfficePhone(info.getOfficePhone());
            pcmInfo.setAddressTX(info.getAddressTX());
            pcmInfo.setIdCardAddress(info.getIdCardAddress());
            pcmInfo.setHomeplace(info.getHomeplace());
            pcmInfo.setHjAddress(info.getHjAddress());
            pcmInfo.setPerson(info);
            pcmInfo.put(HistoryConstant.EFFDT, info.get(HistoryConstant.EFFDT));
            pcmInfo.put("isEnrollAgain", info.get("isEnrollAgain"));
            iPCM.addnew(pcmInfo);
        }
    }

    private void addPersonSocialInsuranceInfo(Context ctx, PersonInfo info) throws EASBizException, BOSException {
        ISocialInsurance iSocialInsurance = SocialInsuranceFactory.getLocalInstance(ctx);
        SocialInsuranceInfo socialInsuranceInfo = new SocialInsuranceInfo();
        socialInsuranceInfo.setIsSocialInsu(false);
        socialInsuranceInfo.setPerson(info);
        socialInsuranceInfo.put(HistoryConstant.EFFDT, info.get(HistoryConstant.EFFDT));
        iSocialInsurance.addnew((CoreBaseInfo)socialInsuranceInfo);
    }

    private void addNewEmployeeInfo(Context ctx, PersonInfo info) throws EASBizException, BOSException {
        INewEmployee iNewEmp = NewEmployeeFactory.getLocalInstance(ctx);
        NewEmployeeInfo newEmpInfo = new NewEmployeeInfo();
        newEmpInfo.setPerson(info);
        newEmpInfo.put(HistoryConstant.EFFDT, info.get(HistoryConstant.EFFDT));
        iNewEmp.addnew(newEmpInfo);
    }

    @Override
    protected void _synchPrePerson(Context ctx) throws BOSException, EASBizException {
        PrePersonCollection ppCol = new PrePersonCollection();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getPrePersonSelector(true));
        view.setFilter(this.getPrePersonFilter());
        IPrePerson ipp = PrePersonFactory.getLocalInstance(ctx);
        ppCol = ipp.getPrePersonCollection(view);
        if (ppCol.size() > 0) {
            int size = ppCol.size();
            for (int i = 0; i < size; ++i) {
                PersonInfo pInfo = new PersonInfo();
                pInfo = this.getPersonInfoByIDCardNo(ctx, ppCol.get(i).getIdCardNo(), ppCol.get(i).getPassportNO());
                if (pInfo == null) continue;
                PersonPositionCollection ppInfoCol = PersonPositionFactory.getLocalInstance(ctx).getPersonPositionCollection(this.getPersonPositionEntryView(pInfo.getId().toString()));
                if (ppInfoCol.size() > 0) {
                    ppCol.get(i).setPerson(ppInfoCol.get(0).getPerson());
                    ppCol.get(i).setCurEnterDate(ppInfoCol.get(0).getEnterDate());
                    ppCol.get(i).setIsEnrolled(true);
                }
                ipp.updatePartial(ppCol.get(i), this.getPrePersonSelector(true));
            }
        }
        try {
            this.synchHisData(ctx);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void synchHisData(Context ctx) throws BOSException, EASBizException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        EntityViewInfo pView = new EntityViewInfo();
        pView.setFilter(this.getHisFilter());
        PrePersonCollection pCol = new PrePersonCollection();
        pCol = PrePersonFactory.getLocalInstance(ctx).getPrePersonCollection(pView);
        PrePersonHISCollection hCol = new PrePersonHISCollection();
        hCol = this.assembleHIS(pCol);
        for (int i = 0; i < hCol.size(); ++i) {
            PrePersonHISFactory.getLocalInstance(ctx).addnew(hCol.get(i));
            PrePersonFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(hCol.get(i).get("deleteID").toString()));
        }
    }

    private PrePersonHISCollection assembleHIS(PrePersonCollection col) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, BOSException {
        PrePersonHISCollection hCol = new PrePersonHISCollection();
        PrePersonHISInfo hInfo = null;
        for (int i = 0; i < col.size(); ++i) {
            hInfo = new PrePersonHISInfo();
            PrePersonInfo preInfo = col.get(i);
            BOSUuid id = hInfo.getId();
            PersonOptFacadeControllerBean.cloneInfo((IObjectValue)preInfo, (IObjectValue)hInfo);
            hInfo.setId(id);
            hInfo.put("deleteID", preInfo.getId());
            hCol.add(hInfo);
        }
        return hCol;
    }

    public static IObjectValue cloneInfo(IObjectValue fromVO, IObjectValue toVO) {
        Enumeration e = fromVO.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            toVO.put(key, fromVO.get(key));
        }
        return toVO;
    }

    private EntityViewInfo getPersonPositionEntryView(String personID) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("enterDate"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        view.setSelector(sic);
        view.setFilter(filter);
        return view;
    }

    private PersonInfo getPersonInfoByIDCardNo(Context ctx, String idCardNO, String passportNO) throws BOSException {
        PersonCollection pCol = new PersonCollection();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getPrePersonSelector(false));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employeeType.isInCount", (Object)true));
        if (!StringUtils.isEmpty((String)idCardNO)) {
            filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)idCardNO));
        }
        if (!StringUtils.isEmpty((String)passportNO)) {
            filter.getFilterItems().add(new FilterItemInfo("passportNO", (Object)passportNO));
        }
        if (!StringUtils.isEmpty((String)idCardNO) && !StringUtils.isEmpty((String)passportNO)) {
            filter.setMaskString(" #0 and (#1 or #2)");
        }
        view.setFilter(filter);
        pCol = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
        if (pCol.size() > 0) {
            return pCol.get(0);
        }
        return null;
    }

    private SelectorItemCollection getPrePersonSelector(boolean isPrePerson) {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (isPrePerson) {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("idCardNo"));
            sic.add(new SelectorItemInfo("passportNO"));
            sic.add(new SelectorItemInfo("curEnterDate"));
            sic.add(new SelectorItemInfo("curAdminOrg"));
            sic.add(new SelectorItemInfo("checkInState"));
            sic.add(new SelectorItemInfo("curPosition"));
            sic.add(new SelectorItemInfo("isEnrolled"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
        } else {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("employee.id"));
            sic.add(new SelectorItemInfo("employee.isInCount"));
        }
        return sic;
    }

    private FilterInfo getPrePersonFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isAbandon", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isEnrolled", (Object)false));
        return filter;
    }

    private FilterInfo getHisFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkInState", (Object)CheckInState.NOT_CHECKED_IN, CompareType.NOTEQUALS));
        filter.setMaskString("#0 ");
        return filter;
    }

    @Override
    protected void _untiCheckEnrollBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._deletePersonData(ctx, pk);
    }

    private void doWhthPersonOtherInfo(Context ctx, PersonInfo info) throws BOSException, EASBizException {
        PersonOtherInfoInfo otherInfo = this.getPersonOtherInfoInfo(ctx, info);
        if (otherInfo == null) {
            otherInfo = new PersonOtherInfoInfo();
            otherInfo.setPerson(info);
            this.assemblePersonOtherInfo(ctx, info, otherInfo);
            PersonOtherInfoFactory.getLocalInstance(ctx).addnew(otherInfo);
        } else {
            this.assemblePersonOtherInfo(ctx, info, otherInfo);
            PersonOtherInfoFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(otherInfo.getId().toString()), otherInfo);
        }
    }

    private void assemblePersonOtherInfo(Context ctx, PersonInfo personInfo, PersonOtherInfoInfo otherInfo) throws EASBizException, BOSException {
        String entityName = "com.kingdee.eas.hr.emp.app.PersonOtherInfo";
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection propColl = entityInfo.getPropertiesRuntime();
        int size = propColl.size();
        for (int i = 0; i < size; ++i) {
            String propName = propColl.get(i).getName();
            Enumeration e = personInfo.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!propName.equalsIgnoreCase(key) || this.isPersonOtherInfoExcludeField(key)) continue;
                if (propName.equalsIgnoreCase("zodiac") && personInfo.get("zodiac") != null) {
                    ZodiacInfo z = new ZodiacInfo();
                    if (personInfo.get("zodiac") instanceof ZodiacInfo) {
                        z = (ZodiacInfo)personInfo.get("zodiac");
                    } else {
                        z.setId(BOSUuid.read((String)personInfo.get("zodiac").toString()));
                    }
                    otherInfo.put(propColl.get(i).getName(), z);
                    continue;
                }
                if (propName.equalsIgnoreCase("constellation") && personInfo.get("constellation") != null) {
                    ConstellationInfo c = new ConstellationInfo();
                    if (personInfo.get("constellation") instanceof ConstellationInfo) {
                        c = (ConstellationInfo)personInfo.get("constellation");
                    } else {
                        c.setId(BOSUuid.read((String)personInfo.get("constellation").toString()));
                    }
                    otherInfo.put(propColl.get(i).getName(), c);
                    continue;
                }
                otherInfo.put(propColl.get(i).getName(), personInfo.get(propName));
            }
        }
        otherInfo.setPerson(personInfo);
        otherInfo.setEFFDT(personInfo.getEFFDT());
        if (!personInfo.containsKey("age") && personInfo.getBirthday() != null) {
            this.calculateAge(personInfo, otherInfo);
        }
        if (otherInfo.getSocialServiceYears() == 0.0 && otherInfo.getJobStartDate() != null) {
            this.calculateSocialServiceYears(ctx, otherInfo);
        }
        if (personInfo.getBirthday() != null) {
            String[] birthDay = DateUtils.DateToString((Date)personInfo.getBirthday(), (String)"yyyy-MM-dd").split("-");
            otherInfo.setBornYear(Integer.valueOf(birthDay[0]));
            otherInfo.setBornMonth(Integer.valueOf(birthDay[1]));
            otherInfo.setBornDay(Integer.valueOf(birthDay[2]));
        } else {
            otherInfo.put("bornYear", null);
            otherInfo.put("bornMonth", null);
            otherInfo.put("bornDay", null);
        }
    }

    private void calculateAge(PersonInfo personInfo, PersonOtherInfoInfo otherInfo) {
        Date birthDate = personInfo.getBirthday();
        Date endDate = otherInfo.getDeathDate();
        if (endDate == null) {
            endDate = DateTimeUtils.truncateDate((Date)new Date());
        }
        int yearValue = DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)birthDate);
        int tempValue = 0;
        int birthMonth = DateTimeUtils.getMonth((Date)birthDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int birthDay = DateTimeUtils.getDay((Date)birthDate);
        int endDay = DateTimeUtils.getDay((Date)endDate);
        tempValue = endMonth < birthMonth ? -1 : (endMonth > birthMonth ? 0 : (endDay < birthDay ? -1 : 0));
        otherInfo.setAge(yearValue + tempValue);
    }

    private void calculateSocialServiceYears(Context ctx, PersonOtherInfoInfo otherInfo) throws EASBizException, BOSException {
        int dayValue;
        int monthValue;
        int yearValue;
        double workTime;
        Date beginDate = otherInfo.getJobStartDate();
        Date endDate = otherInfo.getRetireDate();
        double adjustValue = otherInfo.getAdjustSerVal();
        if (endDate == null) {
            endDate = DateTimeUtils.truncateDate((Date)new Date());
        }
        if ((workTime = (double)(yearValue = DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)beginDate)) + (double)(monthValue = DateTimeUtils.getMonth((Date)endDate) - DateTimeUtils.getMonth((Date)beginDate)) / 12.0 + (double)((float)(dayValue = DateTimeUtils.getDay((Date)endDate) - DateTimeUtils.getDay((Date)beginDate)) / 365.0f) - adjustValue) < 0.0) {
            workTime = 0.0;
        }
        workTime = SHRMathUtils.getRoundValueBySysParam((Context)ctx, (double)workTime);
        otherInfo.setSocialServiceYears(workTime);
    }

    private boolean isPersonOtherInfoExcludeField(String key) {
        return key.equals("id") || key.equals("person") || key.equals("hasBURelation");
    }

    private PersonOtherInfoInfo getPersonOtherInfoInfo(Context ctx, PersonInfo info) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getId().toString()));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.birthday"));
        selector.add(new SelectorItemInfo("age"));
        IPersonOtherInfo iPersonOtherInfo = PersonOtherInfoFactory.getLocalInstance(ctx);
        PersonOtherInfoCollection coll = iPersonOtherInfo.getPersonOtherInfoCollection(viewInfo);
        PersonOtherInfoInfo otherInfo = null;
        if (coll.size() > 0) {
            otherInfo = coll.get(0);
        }
        return otherInfo;
    }

    private void deletePersonHisWhenRevise(Context ctx, String pk, Date effdt) throws BOSException, EASBizException {
        String sql = "delete from T_BD_PersonHis where fhistoryrelateid = '" + pk + "' and feffdt >= {ts'" + HRUtilExtend.getDateStringWithoutMininute((Date)effdt) + "'} and fleffdt <> {ts'2199-12-31'}";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void checkEffdt(Context ctx, Date effdt, PersonInfo personInfo, String historyOperateState) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select min(feffdt) from t_bd_personhis where fHistoryRelateId='").append(personInfo.getId()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        java.sql.Date earlyEffdt = null;
        try {
            if (rs.next()) {
                earlyEffdt = rs.getDate(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Date oldEffdt = HRVerifyModelFacadeFactory.getLocalInstance((Context)ctx).getOldEffdt((CoreBaseInfo)personInfo);
        if (effdt == null) {
            if (historyOperateState == null) {
                personInfo.setEFFDT((Date)earlyEffdt);
            } else if (historyOperateState.equals("change")) {
                personInfo.setEFFDT(DateTimeUtils.truncateDate((Date)new Date()));
            } else if (historyOperateState.equals("revise")) {
                personInfo.setEFFDT(oldEffdt);
            }
        } else {
            if (historyOperateState != null && historyOperateState.equals("revise") && effdt.after(oldEffdt)) {
                Object[] params = new String[]{HRUtilExtend.getDateStringWithoutMininute((Date)oldEffdt)};
                throw new HRAdminOrgException(HRAdminOrgException.ERROR_REVISE_EFFDT, params);
            }
            if (historyOperateState != null && historyOperateState.equals("change") && !effdt.after(oldEffdt)) {
                Object[] params = new String[]{HRUtilExtend.getDateStringWithoutMininute((Date)oldEffdt)};
                throw new HRAdminOrgException(HRAdminOrgException.ERROR_CHANGE_EFFDT, params);
            }
        }
    }

    @Override
    protected void _setPrePersonEnrolled(Context ctx, IObjectPK personId) throws BOSException, EASBizException {
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo(personId);
        PersonPositionCollection ppInfoCol = PersonPositionFactory.getLocalInstance(ctx).getPersonPositionCollection(this.getPersonPositionEntryView(personId.toString()));
        Date curEnterDate = null;
        if (ppInfoCol.size() > 0) {
            curEnterDate = ppInfoCol.get(0).getEnterDate();
        }
        PrePersonCollection prePersonColl = this.getPrePersonInfoByEnrolledPersonId(ctx, personInfo);
        int size = prePersonColl.size();
        for (int i = 0; i < size; ++i) {
            PrePersonInfo prePersonInfo = prePersonColl.get(i);
            prePersonInfo.setIsEnrolled(Boolean.TRUE);
            prePersonInfo.setCheckInState(CheckInState.HAS_CHECKED_IN);
            prePersonInfo.setPerson(personInfo);
            prePersonInfo.setCurEnterDate(curEnterDate);
            this.savePrePersonInfo(ctx, prePersonInfo);
        }
    }

    private void savePrePersonInfo(Context ctx, PrePersonInfo prePersonInfo) throws EASBizException, BOSException {
        PrePersonFactory.getLocalInstance(ctx).updatePartial(prePersonInfo, this.getPrePersonSelector(true));
    }

    private PrePersonCollection getPrePersonInfoByEnrolledPersonId(Context ctx, PersonInfo personInfo) throws BOSException {
        String idcardno = personInfo.getIdCardNO();
        String passportno = personInfo.getPassportNO();
        PrePersonCollection ppCol = new PrePersonCollection();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getPrePersonSelector(true));
        FilterInfo filterInfo = new FilterInfo();
        IPrePerson ipp = PrePersonFactory.getLocalInstance(ctx);
        if (!StringUtils.isEmpty((String)idcardno)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("idCardNo", (Object)idcardno));
            view.setFilter(filterInfo);
            ppCol.addCollection(ipp.getPrePersonCollection(view));
        }
        if (!StringUtils.isEmpty((String)passportno)) {
            filterInfo.appendFilterItem("passportno", (Object)passportno);
            view.setFilter(filterInfo);
            ppCol.addCollection(ipp.getPrePersonCollection(view));
        }
        return ppCol;
    }

    @Override
    protected void _setPrePersonUnenrolled(Context ctx, IObjectPK personId) throws BOSException, EASBizException {
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo(personId);
        PrePersonCollection prePersonColl = this.getPrePersonInfoByEnrolledPersonId(ctx, personInfo);
        int size = prePersonColl.size();
        for (int i = 0; i < size; ++i) {
            PrePersonInfo prePersonInfo = prePersonColl.get(i);
            prePersonInfo.setIsEnrolled(Boolean.FALSE);
            prePersonInfo.setPerson(null);
            prePersonInfo.setCurEnterDate(null);
            prePersonInfo.setCheckInState(CheckInState.NOT_CHECKED_IN);
            this.savePrePersonInfo(ctx, prePersonInfo);
        }
    }

    private void deletePersonBuRelation(Context ctx, String personId) throws BOSException, EASBizException {
        ArrayList<String> personIdList = new ArrayList<String>();
        personIdList.add(personId);
        PersonBizManageFacadeFactory.getLocalInstance((Context)ctx).deletePersonBizManageByPerson(personIdList, false);
    }

    private void upperIdCardNo(PersonInfo personInfo) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)personInfo.getIdCardNO())) {
            String idCardNo = IDCardCommonUtil.upperIdCardNo((String)personInfo.getIdCardNO());
            personInfo.setIdCardNO(idCardNo);
        }
    }

    @Override
    protected void _doWithSyncSSCInfo(Context ctx, String personId, String entryId) throws BOSException, EASBizException {
        IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "sscSynPrePersonArchiveService");
        HashMap<String, String> personParam = new HashMap<String, String>();
        personParam.put("personId", personId);
        personParam.put("entryId", entryId);
        HashMap yearfirstMap = (HashMap)imsf.process(ctx, personParam);
    }

    protected void deleteSalaryItemData(Context ctx, String personId) throws BOSException, EASBizException {
        EmpSalaryItemDataCollection coll = EmpSalaryItemDataFactory.getLocalInstance((Context)ctx).getEmpSalaryItemDataCollection("select id,entryId where person = '" + personId + "'");
        if (coll != null && coll.size() > 0) {
            HashSet<String> salaryItemDataIdSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                EntityViewInfo enrollView = new EntityViewInfo();
                FilterInfo enrollfilter = new FilterInfo();
                enrollfilter.getFilterItems().add(new FilterItemInfo("id", (Object)coll.get(i).getEntryId()));
                enrollView.setFilter(enrollfilter);
                int count = EmpEnrollBizBillEntryFactory.getLocalInstance((Context)ctx).getCount(enrollView);
                if (count > 0) continue;
                salaryItemDataIdSet.add(coll.get(i).getId().toString());
            }
            if (salaryItemDataIdSet.size() > 0) {
                FilterInfo deletefilter = new FilterInfo();
                deletefilter.getFilterItems().add(new FilterItemInfo("empsalaryItemData", (Object)((Object)salaryItemDataIdSet).toString(), CompareType.INCLUDE));
                EmpSalaryItemDataPartFactory.getLocalInstance((Context)ctx).delete(deletefilter);
                EmpSignFeeFactory.getLocalInstance((Context)ctx).delete(deletefilter);
                deletefilter.getFilterItems().clear();
                deletefilter.getFilterItems().add(new FilterItemInfo("id", (Object)((Object)salaryItemDataIdSet).toString(), CompareType.INCLUDE));
                EmpSalaryItemDataFactory.getLocalInstance((Context)ctx).delete(deletefilter);
            }
        }
    }

    private void syncPersonToPersonInfoIntegrity(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException {
        PersonInfoIntegrityInfo personInfoIntegrityInfo = new PersonInfoIntegrityInfo();
        personInfoIntegrityInfo.setPerson(personInfo);
        personInfoIntegrityInfo.setPerOfIntegrity(0.0f);
        PersonInfoIntegrityFactory.getLocalInstance(ctx).addnew(personInfoIntegrityInfo);
    }

    private void checkPersonHireDateIsChanged(Context ctx, PersonInfo pInfo) throws EASBizException, BOSException {
        PersonInfo oldPersonInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(pInfo.getId().toString()));
        Date oldHireDate = oldPersonInfo.getHireDate();
        if (oldHireDate != null && pInfo.containsKey("hiredate") && !oldHireDate.equals(pInfo.getHireDate()) || oldHireDate == null && pInfo.containsKey("hiredate") && pInfo.getHireDate() != null) {
            throw new EmployeeException(EmployeeException.PERSON_HIREDATE_CANNOT_CHANGGE);
        }
    }
}

