/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryFactory;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.IEmpEnrollBizBillEntry;
import com.kingdee.eas.hr.base.RoundModeEnum;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.util.File2ObsUtils;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.PersonHistoryRelateCheckUtil;
import com.kingdee.eas.hr.base.util.SHRMathUtils;
import com.kingdee.eas.hr.emp.EmpQuickAddNewInfoFactory;
import com.kingdee.eas.hr.emp.IEmpQuickAddNewInfo;
import com.kingdee.eas.hr.emp.INewEmployee;
import com.kingdee.eas.hr.emp.IPersonContactMethod;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.NewEmployeeFactory;
import com.kingdee.eas.hr.emp.NewEmployeeInfo;
import com.kingdee.eas.hr.emp.PersonContactMethodFactory;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonWorkExpCollection;
import com.kingdee.eas.hr.emp.PersonWorkExpFactory;
import com.kingdee.eas.hr.emp.app.AbstractPersonPositionControllerBean;
import com.kingdee.eas.hr.emp.app.util.PersonPhotoUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptPersonPositionUtil;
import com.kingdee.eas.hr.emp.app.workyear.IPersonPositionWorkYear;
import com.kingdee.eas.hr.emp.app.workyear.IPersonWorkYearService;
import com.kingdee.eas.hr.emp.app.workyear.PersonLeaveWorkYear;
import com.kingdee.eas.hr.emp.app.workyear.PersonOtherWorkYear;
import com.kingdee.eas.hr.emp.app.workyear.PersonRetireWorkYear;
import com.kingdee.eas.hr.emp.app.workyear.PersonWorkYearService;
import com.kingdee.eas.hr.org.HRVerifyModelFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.preentry.IPEPersonContact;
import com.kingdee.shr.preentry.IPreEntry;
import com.kingdee.shr.preentry.PEPersonContactFactory;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class PersonPositionControllerBean
extends AbstractPersonPositionControllerBean {
    private static Logger logger = Logger.getLogger(PersonPositionControllerBean.class);
    private static int GLOBAL_NUM = 100;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonPositionCollection ppColl;
        PersonPositionInfo pInfo = (PersonPositionInfo)model;
        if (pInfo.get("FROM_IMPORT_SYSTEM") != null) {
            HRUtil.canUpdateEmployee((Context)ctx, (PersonInfo)pInfo.getPerson());
        }
        this.checkEffdt(ctx, pInfo.getEFFDT(), pInfo, null);
        if (this._exists(ctx, "where person.id='" + pInfo.getPerson().getId() + "'") && (ppColl = this.getPersonPositionCollection(ctx, "where person.id='" + pInfo.getPerson().getId() + "'")).size() > 0) {
            BOSUuid id = ppColl.get(0).getId();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            pInfo.setId(id);
            this._update(ctx, (IObjectPK)pk, model);
            return pk;
        }
        if (pInfo.getGkAdmin() != null) {
            pInfo.setPersonDep(pInfo.getGkAdmin());
            this.changeUserCuByPer(ctx, pInfo);
        }
        this.setRelatedYears(ctx, pInfo);
        if (pInfo.getCU() == null) {
            pInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (pInfo.getLEFFDT() == null) {
            pInfo.setLEFFDT(HistoryUtil.getMaxDate());
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)pInfo);
        if (pInfo.isIsEnrollAgain()) {
            INewEmployee iNewEmp = NewEmployeeFactory.getLocalInstance(ctx);
            NewEmployeeInfo newEmpInfo = new NewEmployeeInfo();
            newEmpInfo.setPerson(pInfo.getPerson());
            iNewEmp.addnew(newEmpInfo);
        }
        return pk;
    }

    private void setRelatedYears(Context ctx, PersonPositionInfo model) throws BOSException, EASBizException {
        float adjust = 0.0f;
        float adjustGroupCurVal = 0.0f;
        Date nowDate = new Date();
        Date dateBegin = model.getJoinGroupDate();
        Date dateEnd = model.getLeftCompanyDate();
        Date joinGroupDateCur = model.getJoinGroupDateCur();
        if (dateBegin != null && dateEnd == null) {
            adjust = model.getAdjustGroupVal();
            this.calJoinGroupYears(ctx, model, adjust, nowDate, dateBegin);
            adjustGroupCurVal = model.getAdjustGroupCurVal();
            model.setJoinGroupCurYears(SHREmpOptPersonPositionUtil.calWorkTimeYears(ctx, joinGroupDateCur, nowDate, adjustGroupCurVal));
        } else if (dateBegin != null && dateEnd != null) {
            this.calJoinGroupYears(ctx, model, adjust, dateEnd, dateBegin);
            model.setJoinGroupCurYears(SHREmpOptPersonPositionUtil.calWorkTimeYears(ctx, joinGroupDateCur, dateEnd, adjustGroupCurVal));
        }
    }

    private void calJoinGroupYears(Context ctx, PersonPositionInfo model, float adjust, Date nowDate, Date dateBegin) throws EASBizException, BOSException {
        boolean isCalculateOutPersonParam = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_CALCULATE_PERIOD_OF_RESIGNATION_PARAM", null);
        if (isCalculateOutPersonParam) {
            model.setJoinGroupYears(SHREmpOptPersonPositionUtil.calWorkTimeYears(ctx, dateBegin, nowDate, adjust));
        } else {
            model.setJoinGroupYears(this.calJoinGroupYearsByPersonPositionHis(ctx, model, adjust).floatValue());
        }
    }

    private Float calJoinGroupYearsByPersonPositionHis(Context ctx, PersonPositionInfo model, float adjust) throws BOSException, EASBizException {
        Float joinGroupYears = Float.valueOf(0.0f);
        String personId = model.getPerson().getId().toString();
        String hisFjoingroupyearsSqlByPersonId = "SELECT isnull(sum(his.FJoinCompanyYears),0.0) as joinCompanyYearsSum FROM T_HR_PersonPositionhis his inner join T_HR_PersonPosition cur on his.FHISTORYRELATEID =cur.fid where his.FPERSONID ='" + personId + "' and his.FLEFFDT<>{ts'2199-12-31'}";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)hisFjoingroupyearsSqlByPersonId);
        try {
            Float joinCompanyYearsSum = Float.valueOf(0.0f);
            if (rowSet.next()) {
                joinCompanyYearsSum = Float.valueOf(rowSet.getFloat("joinCompanyYearsSum"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("joinCompanyYearsSum******" + joinCompanyYearsSum + "*****personId******" + personId));
                }
            }
            joinGroupYears = Float.valueOf(model.getJoinCompanyYears() + joinCompanyYearsSum.floatValue() - adjust < 0.0f ? 0.0f : model.getJoinCompanyYears() + joinCompanyYearsSum.floatValue() - adjust);
            joinGroupYears = Float.valueOf(SHRMathUtils.getRoundValueBySysParam((Context)ctx, (float)joinGroupYears.floatValue()));
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return joinGroupYears;
    }

    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        PersonPositionInfo pInfo = (PersonPositionInfo)model;
        this.checkHistoryCanModify(ctx, pInfo);
        super._updatePartial(ctx, model, selector);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonPositionInfo pInfo = (PersonPositionInfo)model;
        PersonPositionInfo oldInfo = super.getPersonPositionInfo(ctx, pk);
        if (pInfo.getGkAdmin() != null && oldInfo.getGkAdmin() != null && !pInfo.getGkAdmin().getId().toString().equals(oldInfo.getGkAdmin().getId().toString()) || pInfo.getGkAdmin() == null && oldInfo.getGkAdmin() != null || pInfo.getGkAdmin() != null && oldInfo.getGkAdmin() == null) {
            pInfo.setPersonDep(pInfo.getGkAdmin());
            this.changeUserCuByPer(ctx, pInfo);
        }
        if (pInfo.getPersonDep() == null) {
            pInfo.setPersonDep(oldInfo.getPersonDep());
        }
        this.setRelatedYears(ctx, pInfo);
        String historyOperateState = pInfo.getExtendedProperty("historyOperateState");
        this.checkEffdt(ctx, pInfo.getEFFDT(), pInfo, historyOperateState);
        this.checkHistoryCanModify(ctx, pInfo);
        super._update(ctx, pk, model);
        if (pInfo.isIsEnrollAgain()) {
            INewEmployee iNewEmp = NewEmployeeFactory.getLocalInstance(ctx);
            NewEmployeeInfo newEmpInfo = new NewEmployeeInfo();
            newEmpInfo.setPerson(pInfo.getPerson());
            iNewEmp.addnew(newEmpInfo);
        }
    }

    private void checkHistoryCanModify(Context ctx, PersonPositionInfo pInfo) throws EASBizException, BOSException {
        String personId = null;
        if (pInfo.getPerson() != null) {
            personId = pInfo.getPerson().getId().toString();
        }
        if ("change".equals(pInfo.getExtendedProperty("historyOperateState"))) {
            PersonHistoryRelateCheckUtil.checkPersonInAffair((Context)ctx, (String)personId, (String)pInfo.getId().toString(), (Date)pInfo.getEFFDT());
        }
    }

    private void changeUserCuByPer(Context ctx, PersonPositionInfo ppInfo) throws BOSException, EASBizException {
        AdminOrgUnitInfo gkAdmin = ppInfo.getGkAdmin();
        if (gkAdmin == null) {
            return;
        }
        BOSUuid cuID = null;
        if (gkAdmin.getCU() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("CU.id"));
            gkAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(gkAdmin.getId()), selector);
        }
        cuID = gkAdmin.getCU().getId();
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        String oql = "select id where person.id = '" + ppInfo.getPerson().getId().toString() + "'";
        UserCollection userColl = iUser.getUserCollection(oql);
        ObjectUuidPK userPk = null;
        ObjectUuidPK cuPk = new ObjectUuidPK(cuID);
        int size = userColl.size();
        for (int i = 0; i < size; ++i) {
            userPk = new ObjectUuidPK(userColl.get(i).getId());
            iUser.changeCtrlUnit((IObjectPK)cuPk, (IObjectPK)userPk);
        }
    }

    protected IPersonWorkYearService getPersonWorkYearService(int scale, RoundModeEnum roundMode, Context ctx) {
        return new PersonWorkYearService(scale, roundMode, ctx);
    }

    protected IPersonPositionWorkYear getPersonOtherWorkYear(int scale, RoundModeEnum roundMode, Context ctx) {
        return new PersonOtherWorkYear(scale, roundMode, ctx);
    }

    protected IPersonPositionWorkYear getPersonLeaveWorkYear(int scale, RoundModeEnum roundMode, Context ctx) {
        return new PersonLeaveWorkYear(scale, roundMode, ctx);
    }

    protected IPersonPositionWorkYear getPersonRetireWorkYear(int scale, RoundModeEnum roundMode, Context ctx) {
        return new PersonRetireWorkYear(scale, roundMode, ctx);
    }

    @Override
    protected void _calWorkTime(Context ctx) throws BOSException, EASBizException {
        int scale = Integer.parseInt((String)HRParamUtil.getParamByKey((Context)ctx, null, (String)"SHR_WORKTIME_SCALE"));
        RoundModeEnum roundMode = RoundModeEnum.getEnum((int)Integer.parseInt((String)HRParamUtil.getParamByKey((Context)ctx, null, (String)"SHR_WORKTIME_ROUNDMODE")));
        IPersonWorkYearService service = this.getPersonWorkYearService(scale, roundMode, ctx);
        service.deleteWorkYearTemp();
        long start = System.currentTimeMillis();
        IPersonPositionWorkYear workYear = this.getPersonOtherWorkYear(scale, roundMode, ctx);
        workYear.savePersonPositionToTemp();
        workYear = this.getPersonLeaveWorkYear(scale, roundMode, ctx);
        workYear.savePersonPositionToTemp();
        workYear = this.getPersonRetireWorkYear(scale, roundMode, ctx);
        workYear.savePersonPositionToTemp();
        long end3 = System.currentTimeMillis();
        logger.info((Object)("_calWorkTime Process the working years of retired employees, insert the temporary time in milliseconds " + (end3 - start)));
        service.updatePersonPositionWorkYear();
        service.updatePositionFromEmpOrgRelation();
        this.updateGroupYearByCompanySum(ctx);
        service.updatePersonPositionHis();
        service.updatePersonAge();
        service.updateSocialYears();
        long end8 = System.currentTimeMillis();
        logger.info((Object)("_calWorkTime\u6279\u5904\u7406\u603b\u8017\u65f6\u6beb\u79d2" + (end8 - start)));
    }

    private void updateGroupYearByCompanySum(Context ctx) throws EASBizException, BOSException {
        boolean isCalculateOutPersonParam = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_CALCULATE_PERIOD_OF_RESIGNATION_PARAM", null);
        if (!isCalculateOutPersonParam) {
            String calculateFjoingroupyearsSql = "update T_HR_PersonPosition personposition set fjoingroupyears= (SELECT temp2.fjoingroupyears FROM ( SELECT temp1.fpersonId,temp1.FJoinCompanyYears-isnull(cur.FAdjustGroupVal,0.0)  as fjoingroupyears FROM (SELECT his.FPERSONID,sum(his.FJoinCompanyYears) as FJoinCompanyYears FROM T_HR_PersonPositionHis his group by his.FPERSONID)temp1 inner join T_HR_PersonPosition cur on temp1.fpersonId=cur.fpersonId)temp2 where temp2.FPERSONID=personposition.fpersonid)";
            logger.info((Object)("hr_calworkTime-calculateFjoingroupyearsSql:" + calculateFjoingroupyearsSql));
            DbUtil.execute((Context)ctx, (String)calculateFjoingroupyearsSql);
        }
    }

    @Deprecated
    protected void _calWorkTimexxx(Context ctx) throws BOSException, EASBizException {
        int scale = Integer.parseInt((String)HRParamUtil.getParamByKey((Context)ctx, null, (String)"SHR_WORKTIME_SCALE"));
        RoundModeEnum roundMode = RoundModeEnum.getEnum((int)Integer.parseInt((String)HRParamUtil.getParamByKey((Context)ctx, null, (String)"SHR_WORKTIME_ROUNDMODE")));
        String onWorkSql = " update T_HR_PersonPosition set fjoingroupyears = " + this.getRoundSelector(scale, roundMode, "YEAR(getdate())-YEAR(isnull(fjoingroupdate,getdate())) + ((MONTH(getdate())-MONTH(isnull(fjoingroupdate,getdate())))/12.0 + (DAYOFMONTH(getdate()) - DAYOFMONTH (isnull(fjoingroupdate,getdate())))/365.0 - isnull(FAdjustGroupVal,0.0))") + ", \tFJoinGroupCurYears = " + this.getRoundSelector(scale, roundMode, "YEAR(getdate())-YEAR(isnull(FJoinGroupDateCur,getdate())) + ((MONTH(getdate())-MONTH(isnull(FJoinGroupDateCur,getdate())))/12.0 +(DAYOFMONTH(getdate())-DAYOFMONTH (isnull(FJoinGroupDateCur,getdate())))/365.0 - isnull(FAdjustGroupCurVal,0.0))") + ",  fjoincompanyyears = " + this.getRoundSelector(scale, roundMode, "YEAR(getdate()) - YEAR(isnull(fjoindate,getdate())) + ((MONTH(getdate())-MONTH(isnull(fjoindate,getdate())))/12.0 + (DAYOFMONTH(getdate()) - DAYOFMONTH (isnull(fjoindate,getdate())))/365.0 - isnull(fadjustcovalue,0.0))") + ",  fsysserviceyears = YEAR(getdate()) - YEAR(isnull(fjoinsystemdate,getdate())) + ((MONTH(getdate())-MONTH(isnull(fjoinsystemdate,getdate())))/12.0 - isnull(fadjustsysvalue,0.0)), fworktime = YEAR(getdate()) - YEAR(isnull(fjobStartDate,getdate())) + ((MONTH(getdate())-MONTH(isnull(fjobStartDate,getdate())))/12 - isnull(fadjustworkvalue,0.0)), fnewworktime = YEAR(getdate()) - YEAR(isnull(fjobStartDate,getdate())) + ((MONTH(getdate())-MONTH(isnull(fjobStartDate,getdate())))/12.0 - isnull(fadjustworkvalue,0.0)) where fpersonid in (select person.fid from t_bd_person person inner join t_hr_bdemployeetype emptype on person.femployeetypeid = emptype.fid where (emptype.FinService = 1 or emptype.FinService = 0 or emptype.FinService = 4) and person.FEmployeeTypeID!='00000000-0000-0000-0000-000000000031A29E85B3')";
        String onWorkLaborHisSql = " update T_HR_EmpLaborRelationHis labor set fenteryears = " + this.getRoundSelector(scale, roundMode, "YEAR(getdate())-YEAR(isnull(labor.fenterdate,getdate())) + ((MONTH(getdate())-MONTH(isnull(labor.fenterdate,getdate())))/12.0 - isnull(labor.FAdjustEnterValue,0.0))") + " where fpersonid in (select person.fid from t_bd_person person inner join t_hr_bdemployeetype emptype on person.femployeetypeid = emptype.fid where (emptype.FinService = 1  or emptype.FinService = 0 or emptype.FinService = 4) and person.FEmployeeTypeID!='00000000-0000-0000-0000-000000000031A29E85B3') and fendDateTime >= " + HistoryVersionUtil.getMaxEndDateTs();
        String leftSql = " update T_HR_PersonPosition set fjoingroupyears = " + this.getRoundSelector(scale, roundMode, "YEAR(isnull(FLeftDate,getdate()))-YEAR(isnull(fjoingroupdate,isnull(FLeftDate,getdate()))) + ((MONTH(isnull(FLeftDate,getdate()))-MONTH(isnull(fjoingroupdate,isnull(FLeftDate,getdate()))))/12.0 + (DAYOFMONTH(isnull(FLeftDate,getdate())) - DAYOFMONTH (isnull(fjoingroupdate,isnull(FLeftDate,getdate()))))/365.0 - isnull(FAdjustGroupVal,0.0))") + ",  FJoinGroupCurYears = " + this.getRoundSelector(scale, roundMode, "YEAR(isnull(FLeftDate,getdate()))-YEAR(isnull(FJoinGroupDateCur,isnull(FLeftDate,getdate()))) + ((MONTH(isnull(FLeftDate,getdate()))-MONTH(isnull(FJoinGroupDateCur,isnull(FLeftDate,getdate()))))/12.0 + (DAYOFMONTH(isnull(FLeftDate,getdate()))-DAYOFMONTH(isnull(FJoinGroupDateCur,isnull(FLeftDate,getdate()))))/365.0 - isnull(FAdjustGroupCurVal,0.0))") + ",  fjoincompanyyears = " + this.getRoundSelector(scale, roundMode, "YEAR(isnull(FLeftCompanyDate,getdate())) - YEAR(isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))) + ((MONTH(isnull(FLeftCompanyDate,getdate()))-MONTH(isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))))/12.0 + (DAYOFMONTH(isnull(FLeftCompanyDate,getdate())) - DAYOFMONTH (isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))))/365.0 - isnull(fadjustcovalue,0.0))") + ",  fsysserviceyears = YEAR(isnull(FLeftDate,getdate())) - YEAR(isnull(fjoinsystemdate,isnull(FLeftDate,getdate()))) + ((MONTH(isnull(FLeftDate,getdate()))-MONTH(isnull(fjoinsystemdate,isnull(FLeftDate,getdate()))))/12.0 - isnull(fadjustsysvalue,0.0)), fworktime = YEAR(isnull(FLeftDate,getdate())) - YEAR(isnull(fjobStartDate,isnull(FLeftDate,getdate()))) + ((MONTH(isnull(FLeftDate,getdate()))-MONTH(isnull(fjobStartDate,isnull(FLeftDate,getdate()))))/12 - isnull(fadjustworkvalue,0.0)), fnewworktime = YEAR(isnull(FLeftDate,getdate())) - YEAR(isnull(fjobStartDate,isnull(FLeftDate,getdate()))) + ((MONTH(isnull(FLeftDate,getdate()))-MONTH(isnull(fjobStartDate,isnull(FLeftDate,getdate()))))/12.0 - isnull(fadjustworkvalue,0.0)) where fpersonid in (select person.fid from t_bd_person person inner join t_hr_bdemployeetype emptype on person.femployeetypeid = emptype.fid where emptype.FinService = 2)";
        String leftLaborHisSql = " update T_HR_EmpLaborRelationHis labor set fenteryears = (select " + this.getRoundSelector(scale, roundMode, "YEAR(isnull(FLeftDate,getdate()))-YEAR(isnull(labor.fenterdate,isnull(FLeftDate,getdate()))) + ((MONTH(isnull(FLeftDate,getdate()))-MONTH(isnull(labor.fenterdate,isnull(FLeftDate,getdate()))))/12.0 - isnull(labor.FAdjustEnterValue,0.0))") + " from T_HR_PersonPosition where Fpersonid = labor.Fpersonid ) where fpersonid in (select person.fid from t_bd_person person inner join t_hr_bdemployeetype emptype on person.femployeetypeid = emptype.fid where emptype.FinService = 2) and fendDateTime >= " + HistoryVersionUtil.getMaxEndDateTs();
        String retireSql = " update T_HR_PersonPosition set fjoingroupyears = " + this.getRoundSelector(scale, roundMode, "YEAR(isnull(FRetireDate,getdate()))-YEAR(isnull(fjoingroupdate,isnull(FRetireDate,getdate()))) + ((MONTH(isnull(FRetireDate,getdate()))-MONTH(isnull(fjoingroupdate,isnull(FRetireDate,getdate()))))/12.0 + (DAYOFMONTH(isnull(FRetireDate,getdate())) - DAYOFMONTH (isnull(fjoingroupdate,isnull(FRetireDate,getdate()))))/365.0 - isnull(FAdjustGroupVal,0.0))") + ",  FJoinGroupCurYears = " + this.getRoundSelector(scale, roundMode, "YEAR(isnull(FRetireDate,getdate()))-YEAR(isnull(FJoinGroupDateCur,isnull(FRetireDate,getdate()))) + ((MONTH(isnull(FRetireDate,getdate()))-MONTH(isnull(FJoinGroupDateCur,isnull(FRetireDate,getdate()))))/12.0 + (DAYOFMONTH(isnull(FRetireDate,getdate()))-DAYOFMONTH(isnull(FJoinGroupDateCur,isnull(FRetireDate,getdate()))))/12.0 - isnull(FAdjustGroupCurVal,0.0))") + ",  fjoincompanyyears = " + this.getRoundSelector(scale, roundMode, "YEAR(isnull(FLeftCompanyDate,getdate())) - YEAR(isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))) + ((MONTH(isnull(FLeftCompanyDate,getdate()))-MONTH(isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))))/12.0 + (DAYOFMONTH(isnull(FLeftCompanyDate,getdate())) - DAYOFMONTH (isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))))/365.0 - isnull(fadjustcovalue,0.0))") + ",  fsysserviceyears = YEAR(isnull(FRetireDate,getdate())) - YEAR(isnull(fjoinsystemdate,isnull(FRetireDate,getdate()))) + ((MONTH(isnull(FRetireDate,getdate()))-MONTH(isnull(fjoinsystemdate,isnull(FRetireDate,getdate()))))/12.0 - isnull(fadjustsysvalue,0.0)), fworktime = YEAR(isnull(FRetireDate,getdate())) - YEAR(isnull(fjobStartDate,isnull(FRetireDate,getdate()))) + ((MONTH(isnull(FRetireDate,getdate()))-MONTH(isnull(fjobStartDate,isnull(FRetireDate,getdate()))))/12 - isnull(fadjustworkvalue,0.0)), fnewworktime = YEAR(isnull(FRetireDate,getdate())) - YEAR(isnull(fjobStartDate,isnull(FRetireDate,getdate()))) + ((MONTH(isnull(FRetireDate,getdate()))-MONTH(isnull(fjobStartDate,isnull(FRetireDate,getdate()))))/12.0 - isnull(fadjustworkvalue,0.0)) where fpersonid in (select person.fid from t_bd_person person inner join t_hr_bdemployeetype emptype on person.femployeetypeid = emptype.fid where emptype.FinService = 3)";
        String retireLaborHisSql = " update T_HR_EmpLaborRelationHis labor set fenteryears = (select " + this.getRoundSelector(scale, roundMode, "YEAR(isnull(FRetireDate,getdate()))-YEAR(isnull(labor.fenterDate,isnull(FRetireDate,getdate()))) + ((MONTH(isnull(FRetireDate,getdate()))-MONTH(isnull(labor.fenterDate,isnull(FRetireDate,getdate()))))/12.0 - isnull(labor.FAdjustEnterValue,0.0))") + " from T_HR_PersonPosition where Fpersonid = labor.Fpersonid ) where fpersonid in (select person.fid from t_bd_person person inner join t_hr_bdemployeetype emptype on person.femployeetypeid = emptype.fid where emptype.FinService = 3)and fendDateTime >= " + HistoryVersionUtil.getMaxEndDateTs();
        String laborHisSync2labor = "update T_HR_EmpLaborRelation labor set fenteryears = (select fenteryears from T_HR_EmpLaborRelationHis where labor.Fpersonid = Fpersonid and FisInner=1 and fendDateTime >= " + HistoryVersionUtil.getMaxEndDateTs() + ")where exists(select fenteryears from T_HR_EmpLaborRelationHis where labor.Fpersonid = Fpersonid and FisInner=1 and fendDateTime >= " + HistoryVersionUtil.getMaxEndDateTs() + ")";
        String companyYearsSql = " update T_HR_PersonPositionHis set fjoincompanyyears = " + this.getRoundSelector(scale, roundMode, "YEAR(isnull(FLeftCompanyDate,getdate())) - YEAR(isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))) + ((MONTH(isnull(FLeftCompanyDate,getdate())) - MONTH(isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))))/12.0 + (DAYOFMONTH(isnull(FLeftCompanyDate,getdate())) - DAYOFMONTH (isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))))/365.0 - isnull(fadjustcovalue,0.0))") + " where fpersonid in (select fid from t_bd_person where FEmployeeTypeID!='00000000-0000-0000-0000-000000000031A29E85B3')";
        String fixGroupYearsSql = "update T_HR_PersonPosition set fjoingroupyears = 0 where fjoingroupyears is not null and fjoingroupyears < 0";
        String fixGroupCurYearsSql = "update T_HR_PersonPosition set FJoinGroupCurYears = 0 where FJoinGroupCurYears is not null and FJoinGroupCurYears < 0";
        String fixCompanyYearsSql = "update T_HR_PersonPosition set fjoincompanyyears = 0 where fjoincompanyyears is not null and fjoincompanyyears < 0";
        String fixSysServiceYearsSql = "update T_HR_PersonPosition set fsysserviceyears = 0 where fsysserviceyears is not null and fsysserviceyears < 0";
        String fixWorkTimeSql = "update T_HR_PersonPosition set fworktime = 0 where fworktime is not null and fworktime < 0";
        String fixNewWorkTimeSql = "update T_HR_PersonPosition set fnewworktime = 0 where fnewworktime is not null and fnewworktime < 0";
        String fixCompanyYearsHisSql = "update T_HR_PersonPositionHis set fjoincompanyyears = 0 where fjoincompanyyears is not null and fjoincompanyyears < 0";
        String fixSocialServiceYearsSql = "update T_HR_PersonOtherInfo set fsocialServiceYears = 0 where fsocialServiceYears is not null and fsocialServiceYears < 0";
        String fixSocialServiceYearsHisSql = "update T_HR_PersonOtherInfohis set fsocialServiceYears = 0 where fsocialServiceYears is not null and fsocialServiceYears < 0";
        String fixEnteryearsSql = "update T_HR_EmpLaborRelation set fenteryears = 0 where fenteryears is not null and fenteryears < 0";
        String fixEnteryearsHisSql = "update T_HR_EmpLaborRelationHis set fenteryears = 0 where fenteryears is not null and fenteryears < 0";
        logger.info((Object)("hr_calworkTime-onWorkSql:" + onWorkSql));
        DbUtil.execute((Context)ctx, (String)onWorkSql);
        logger.info((Object)("hr_calworkTime-leftSql:" + leftSql));
        DbUtil.execute((Context)ctx, (String)leftSql);
        logger.info((Object)("hr_calworkTime-retireSql:" + retireSql));
        DbUtil.execute((Context)ctx, (String)retireSql);
        logger.info((Object)("hr_calworkTime-companyYearsSql:" + companyYearsSql));
        DbUtil.execute((Context)ctx, (String)companyYearsSql);
        logger.info((Object)("hr_calworkTime-onWorkLaborHisSql:" + onWorkLaborHisSql));
        DbUtil.execute((Context)ctx, (String)onWorkLaborHisSql);
        logger.info((Object)("hr_calworkTime-leftLaborHisSql:" + leftLaborHisSql));
        DbUtil.execute((Context)ctx, (String)leftLaborHisSql);
        logger.info((Object)("hr_calworkTime-retireLaborHisSql:" + retireLaborHisSql));
        DbUtil.execute((Context)ctx, (String)retireLaborHisSql);
        logger.info((Object)("hr_calworkTime-laborHisSync2labor:" + laborHisSync2labor));
        DbUtil.execute((Context)ctx, (String)laborHisSync2labor);
        DbUtil.execute((Context)ctx, (String)fixGroupYearsSql);
        DbUtil.execute((Context)ctx, (String)fixGroupCurYearsSql);
        DbUtil.execute((Context)ctx, (String)fixCompanyYearsSql);
        DbUtil.execute((Context)ctx, (String)fixSysServiceYearsSql);
        DbUtil.execute((Context)ctx, (String)fixWorkTimeSql);
        DbUtil.execute((Context)ctx, (String)fixNewWorkTimeSql);
        DbUtil.execute((Context)ctx, (String)fixCompanyYearsHisSql);
        DbUtil.execute((Context)ctx, (String)fixEnteryearsSql);
        DbUtil.execute((Context)ctx, (String)fixEnteryearsHisSql);
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_HR_PersonPositionhis ppHis set ").append(this.getSetFieldString("fjoingroupyears")).append(",").append(this.getSetFieldString("FJoinGroupCurYears")).append(",").append(this.getSetFieldString("fsysserviceyears")).append(",").append(this.getSetFieldString("fworktime")).append(",").append(this.getSetFieldString("fnewworktime")).append(" where ppHis.fleffdt={ts'2199-12-31'}");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer updatePersonAgeSql = new StringBuffer();
        updatePersonAgeSql.append("update T_HR_PersonOtherInfo otherInfo set ").append(" FAge=select ISNULL ( ( ( YEAR ( GETDATE ( ) ) - YEAR ( person.FBirthday ) ) - ( CASE WHEN ( MONTH ( person.FBirthday ) - MONTH ( GETDATE ( ) ) ) > 0").append(" THEN 1 WHEN ( MONTH ( person.FBirthday ) - MONTH ( GETDATE ( ) ) < 0 ) THEN 0 WHEN ( DAYOFMONTH ( person.FBirthday ) - DAYOFMONTH ( GETDATE ( ) ) ) <= 0").append(" THEN 0 ELSE 1 END ) ) , 0 ) ").append(" from t_bd_person person").append(" where person.FBirthday is not null and person.fid=otherInfo.FPersonID").append("  where FPersonId in (select fid from t_bd_person where FEmployeeTypeID!='00000000-0000-0000-0000-000000000031A29E85B3') and FDeathDate is null");
        DbUtil.execute((Context)ctx, (String)updatePersonAgeSql.toString());
        StringBuffer updatePersonHisAgeSql = new StringBuffer();
        updatePersonHisAgeSql.append("update T_HR_PERSONOTHERINFOHIS otherInfohis set ").append(" FAge=select ISNULL ( ( ( YEAR ( GETDATE ( ) ) - YEAR ( person.FBirthday ) ) - ( CASE WHEN ( MONTH ( person.FBirthday ) - MONTH ( GETDATE ( ) ) ) > 0").append(" THEN 1 WHEN ( MONTH ( person.FBirthday ) - MONTH ( GETDATE ( ) ) < 0 ) THEN 0 WHEN ( DAYOFMONTH ( person.FBirthday ) - DAYOFMONTH ( GETDATE ( ) ) ) <= 0").append(" THEN 0 ELSE 1 END ) ) , 0 ) ").append(" from t_bd_person person").append(" where person.FBirthday is not null and person.fid=otherInfohis.FPersonID").append("  where FPersonId in (select fid from t_bd_person where FEmployeeTypeID!='00000000-0000-0000-0000-000000000031A29E85B3') and FDeathDate is null and FLEFFDT = {ts '2199-12-31 00:00:00'}");
        DbUtil.execute((Context)ctx, (String)updatePersonHisAgeSql.toString());
        String updateSocialServiceYearsSQL = "update T_HR_PersonOtherInfo set  fsocialServiceYears = " + this.getRoundSelector(scale, roundMode, "YEAR(isnull(FRetireDate,getdate())) - YEAR(isnull(fjobStartDate,getdate())) + ((MONTH(isnull(FRetireDate,getdate()))-MONTH(isnull(fjobStartDate,getdate())))/12.0 + (DAYOFMONTH(isnull(FRetireDate,getdate()))-DAYOFMONTH(isnull(fjobStartDate,getdate())))/365.0 - isnull(fadjustSerVal,0.0))");
        DbUtil.execute((Context)ctx, (String)updateSocialServiceYearsSQL);
        DbUtil.execute((Context)ctx, (String)fixSocialServiceYearsSql);
        String updateSocialServiceYearsHisSQL = "update T_HR_PersonOtherInfohis set  fsocialServiceYears = " + this.getRoundSelector(scale, roundMode, "YEAR(isnull(FRetireDate,getdate())) - YEAR(isnull(fjobStartDate,getdate())) + ((MONTH(isnull(FRetireDate,getdate()))-MONTH(isnull(fjobStartDate,getdate())))/12.0 + (DAYOFMONTH(isnull(FRetireDate,getdate()))-DAYOFMONTH(isnull(fjobStartDate,getdate())))/365.0 - isnull(fadjustSerVal,0.0))");
        DbUtil.execute((Context)ctx, (String)updateSocialServiceYearsHisSQL);
        DbUtil.execute((Context)ctx, (String)fixSocialServiceYearsHisSql);
        StringBuffer updateJobGradeSql = new StringBuffer();
        updateJobGradeSql.append("update t_hr_emporgrelation emporg set fjobgradeid = ").append("(select top 1 pp.fjobgrade from t_hr_personpositionhis pp where pp.fpersonid = emporg.fpersonid and pp.feffdt<=emporg.feffdt and pp.fleffdt >= emporg.feffdt) where fassignType = 1");
        DbUtil.execute((Context)ctx, (String)updateJobGradeSql.toString());
        PersonPhotoUtil.cleanPersonPhotoInDB(ctx);
        boolean isUseOSB = File2ObsUtils.isUseOBS((Context)ctx);
        if (!isUseOSB) {
            try {
                int doPhoto = 0;
                String personPhotoSql = "select count(*) count from t_hr_hrinit where fkey = 'IS_Generate_PhotoFile' and fvalue = 'true'";
                IRowSet personPhotoRowSet = DbUtil.executeQuery((Context)ctx, (String)personPhotoSql);
                while (personPhotoRowSet.next()) {
                    doPhoto = personPhotoRowSet.getInt("count");
                }
                if (doPhoto > 0) {
                    PersonPhotoUtil.allPhoto2File(ctx);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            int doDelete = 0;
            String delectGoJSSql = "select count(*) count from t_hr_hrinit where fkey = 'IS_Delect_GoJS' and fvalue = 'true'";
            IRowSet delectGoJSRowSet = DbUtil.executeQuery((Context)ctx, (String)delectGoJSSql);
            while (delectGoJSRowSet.next()) {
                doDelete = delectGoJSRowSet.getInt("count");
            }
            if (doDelete > 0) {
                StringBuffer rootPathSb = new StringBuffer();
                rootPathSb.append(SHRSyssettingUtil.getShrWebWarPath());
                rootPathSb.append(File.separator).append("addon");
                rootPathSb.append(File.separator).append("orgchart");
                rootPathSb.append(File.separator).append("web");
                String rootPath = rootPathSb.toString();
                ArrayList<String> delectFileList = new ArrayList<String>();
                delectFileList.add(rootPath + File.separator + "tmp" + File.separator + "a.css");
                delectFileList.add(rootPath + File.separator + "tmp" + File.separator + "shrGojsdeploy.js");
                delectFileList.add(rootPath + File.separator + "webviews" + File.separator + "jslib" + File.separator + "GoJS" + File.separator + "go.js");
                delectFileList.add(rootPath + File.separator + "jslib" + File.separator + "js" + File.separator + "go.js");
                delectFileList.add(rootPath + File.separator + "jslib" + File.separator + "js" + File.separator + "go-debug.js");
                String fileName = null;
                int count = delectFileList.size();
                for (int i = 0; i < count; ++i) {
                    fileName = (String)delectFileList.get(i);
                    File file = new File(fileName);
                    if (!file.exists()) continue;
                    file.delete();
                }
                String initGoJSSql = "update t_hr_hrinit set fvalue = 'false' where fkey = 'IS_Delect_GoJS'";
                DbUtil.execute((Context)ctx, (String)initGoJSSql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.validRemarkLength(ctx);
        this.dowithReference(ctx);
        this.dowithPersoTel(ctx);
    }

    private void dowithPersoTel(Context ctx) throws BOSException, EASBizException {
        IPersonContactMethod iPersonContactMethod = PersonContactMethodFactory.getLocalInstance(ctx);
        this.upgradeTel(ctx, (ICoreBase)iPersonContactMethod, "mobile", GLOBAL_NUM);
        IEmpEnrollBizBillEntry iEmpEnrollBizBillEntry = EmpEnrollBizBillEntryFactory.getLocalInstance((Context)ctx);
        this.upgradeTel(ctx, (ICoreBase)iEmpEnrollBizBillEntry, "telNum", GLOBAL_NUM);
        IEmpQuickAddNewInfo iEmpQuickAddNewInfo = EmpQuickAddNewInfoFactory.getLocalInstance(ctx);
        this.upgradeTel(ctx, (ICoreBase)iEmpQuickAddNewInfo, "telNum", GLOBAL_NUM);
        IPreEntry iPreEntry = PreEntryFactory.getLocalInstance((Context)ctx);
        this.upgradeTel(ctx, (ICoreBase)iPreEntry, "cellPhone", GLOBAL_NUM);
        IPEPersonContact iPEPersonContact = PEPersonContactFactory.getLocalInstance((Context)ctx);
        this.upgradeTel(ctx, (ICoreBase)iPEPersonContact, "mobile", GLOBAL_NUM);
    }

    private void upgradeTel(Context ctx, ICoreBase iCoreBase, String telField, int gLOBAL_NUM) throws BOSException, EASBizException {
        CoreBaseCollection pcmColl = null;
        do {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setTopCount(gLOBAL_NUM);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(telField, null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("globalRoaming", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("nCell", null, CompareType.EQUALS));
            filter.setMaskString("#0 and (#1 or #2)");
            entityViewInfo.setFilter(filter);
            pcmColl = iCoreBase.getCollection(entityViewInfo);
            if (pcmColl == null || pcmColl.size() == 0) break;
            for (int i = 0; i < pcmColl.size(); ++i) {
                String mobile;
                CoreBaseInfo pcmInfo = pcmColl.get(i);
                String string = mobile = pcmInfo.get(telField) != null ? pcmInfo.get(telField).toString() : "";
                if (StringUtils.isEmpty((String)mobile)) continue;
                String[] t = mobile.split("-");
                if (t.length > 1) {
                    pcmInfo.put("globalRoaming", (Object)t[0]);
                    pcmInfo.put("nCell", (Object)t[1]);
                    continue;
                }
                pcmInfo.put("globalRoaming", (Object)"+86");
                pcmInfo.put("nCell", (Object)t[0]);
            }
            iCoreBase.saveBatchData(pcmColl);
        } while (pcmColl.size() >= gLOBAL_NUM);
    }

    private String getRoundSelector(int scale, RoundModeEnum roundMode, String selector) {
        if (scale < 0 || scale > 2) {
            scale = 2;
        }
        double factor = Math.pow(10.0, scale);
        StringBuffer roundSelector = new StringBuffer();
        switch (roundMode.getValue()) {
            case 0: {
                roundSelector.append("ROUND((").append(selector).append("),").append(scale).append(")");
                break;
            }
            case 1: {
                roundSelector.append("CEILING((").append(selector).append(")*").append(factor).append(")/").append(factor);
                break;
            }
            case 2: {
                roundSelector.append("FLOOR((").append(selector).append(")*").append(factor).append(")/").append(factor);
                break;
            }
            default: {
                roundSelector.append("ROUND(").append(selector).append(",").append(scale).append(")");
            }
        }
        return roundSelector.toString();
    }

    private String getSetFieldString(String fieldName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" ").append(fieldName).append("=(select ").append(fieldName).append(" from T_HR_PersonPosition pp where pp.fid=ppHis.FHistoryRelateID and ppHis.fleffdt={ts'2199-12-31'})");
        return sql.toString();
    }

    private Float computeDateYear(Date oldDate, float adjustValue) {
        Date nowDate = new Date();
        if (oldDate == null || !DateTimeUtils.dayBefore((Date)oldDate, (Date)nowDate)) {
            return new Float(0.0);
        }
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(oldDate);
        Calendar nowCal = Calendar.getInstance();
        nowCal.setTime(nowDate);
        nowCal.add(5, 1);
        int dateYear = dateCal.get(1);
        int nowYear = nowCal.get(1);
        int dateMonth = dateCal.get(2) + 1;
        int nowMonth = nowCal.get(2) + 1;
        int dateDay = dateCal.get(5);
        int nowDay = nowCal.get(5);
        int tempYear = nowYear - dateYear;
        int tempMonth = nowMonth - dateMonth;
        int tempDay = nowDay - dateDay;
        if (tempDay < 0) {
            --tempMonth;
        }
        int totalMonth = tempYear * 12 + tempMonth - Math.round(adjustValue * 12.0f);
        int YY = 0;
        int MM = 0;
        if (totalMonth > 0) {
            YY = totalMonth / 12;
            MM = totalMonth % 12;
        }
        return new Float((float)YY + (float)MM / 12.0f);
    }

    @Override
    protected void _checkEnrollDate(Context ctx, List isEnrollLs, List personIdLs, List enrollDateLs) throws BOSException, HRAffairException {
        for (int i = 0; i < isEnrollLs.size(); ++i) {
            boolean isEnroll = false;
            if (null != isEnrollLs.get(i)) {
                isEnroll = (Boolean)isEnrollLs.get(i);
            }
            String personId = null;
            if (null != personIdLs.get(i)) {
                personId = (String)personIdLs.get(i);
            }
            Date enrollDate = null;
            if (null != enrollDateLs.get(i)) {
                enrollDate = (Date)enrollDateLs.get(i);
            }
            this._checkEnrollDate(ctx, isEnroll, personId, enrollDate);
        }
    }

    @Override
    protected void _checkEnrollDate(Context ctx, boolean isEnroll, String personId, Date enrollDate) throws BOSException, HRAffairException {
        Date leftDate;
        PersonPositionCollection pc;
        if (isEnroll && personId != null && (pc = this.getPersonPositionCollection(ctx, "select leftDate where person.id = '" + personId + "'")).size() > 0 && (leftDate = pc.get(0).getLeftDate()) != null && enrollDate != null && leftDate != null && leftDate.getTime() > enrollDate.getTime()) {
            throw new HRAffairException(HRAffairException.REENROLLDATE_LESS_LEFTDATE, new Object[]{leftDate});
        }
    }

    @Override
    protected void _updateJobFirstDate(Context ctx, String personId) throws BOSException, EASBizException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select begindate where person.id='").append(personId).append("' order by begindate asc");
        PersonWorkExpCollection personExp = PersonWorkExpFactory.getLocalInstance(ctx).getPersonWorkExpCollection(selectSql.toString());
        if (personExp.size() > 0) {
            IPersonPosition ipp = PersonPositionFactory.getLocalInstance(ctx);
            selectSql = new StringBuffer();
            selectSql.append("select jobStartDate where person.id='").append(personId).append("'");
            PersonPositionCollection ppColl = ipp.getPersonPositionCollection(selectSql.toString());
            if (ppColl.size() > 0) {
                PersonPositionInfo ppInfo = ppColl.get(0);
                ppInfo.setJobStartDate(personExp.get(0).getBeginDate());
                ppInfo.setEFFDT(DateTimeUtils.truncateDate((Date)new Date()));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("jobStartDate"));
                ipp.updatePartial(ppInfo, selector);
            }
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        PersonPositionInfo info = (PersonPositionInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }

    @Deprecated
    private void deletePersonPostionHisWhenRevise(Context ctx, String pk, Date effdt) throws BOSException, EASBizException {
        if (effdt != null) {
            String sql = "delete from T_HR_PersonPositionHis where fhistoryrelateid = '" + pk + "' and feffdt >= {ts'" + HRUtilExtend.getDateStringWithoutMininute((Date)effdt) + "'} and fleffdt <> {ts'2199-12-31'}";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private void checkEffdt(Context ctx, Date effdt, PersonPositionInfo ppInfo, String historyOperateState) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select min(feffdt) from t_bd_personhis where fHistoryRelateId='").append(ppInfo.getPerson().getId()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Date earlyEffdt = null;
        try {
            if (rs.next()) {
                earlyEffdt = rs.getDate(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Date oldEffdt = HRVerifyModelFacadeFactory.getLocalInstance((Context)ctx).getOldEffdt((CoreBaseInfo)ppInfo);
        if (effdt == null) {
            if (historyOperateState == null) {
                if (earlyEffdt == null) {
                    earlyEffdt = DateTimeUtils.truncateDate((Date)new Date());
                }
                ppInfo.setEFFDT(earlyEffdt);
            } else if (historyOperateState.equals("change")) {
                ppInfo.setEFFDT(DateTimeUtils.truncateDate((Date)new Date()));
            } else if (historyOperateState.equals("revise")) {
                ppInfo.setEFFDT(oldEffdt);
            }
        }
    }

    private void validRemarkLength(Context ctx) throws BOSException {
        String[] targetTables = new String[]{"T_HR_EMPFLOWINOUT", "T_HR_EmpOrgRelation"};
        String[] billTables = new String[]{"T_HR_EmpEnrollBizBillEntry", "T_HR_EmpHireBizBillEntry", "T_HR_FluctuationBizBillEntry", "T_HR_FlucOutBizBillEntry", "T_HR_FlucInBizBillEntry", "T_HR_LoanBizBillEntry", "T_HR_LoanOutBizBillEntry", "T_HR_LoanInBizBillEntry", "T_HR_LoanBackBizBillEntry", "T_HR_ResignBizBillEntry", "T_HR_RetireBizBillEntry", "T_HR_ReinviteBizBillEntry", "T_HR_ReinviteFireBizBillEntry", "T_HR_PluralityAddBizBillEntry", "T_HR_PluralityDelBizBillEntry", "T_HR_PluralityRBBE"};
        int maxLength = 0;
        int tempLength = 0;
        for (String billTable : billTables) {
            tempLength = this.getColLength(ctx, billTable, "FDescription");
            if (maxLength >= tempLength) continue;
            maxLength = tempLength;
        }
        for (String targetTable : targetTables) {
            tempLength = this.getColLength(ctx, targetTable, "FRemark");
            String columnType = this.getTableColumnType(ctx, targetTable, "FRemark");
            if (maxLength <= tempLength && (columnType == null || "NVARCHAR".equalsIgnoreCase(columnType) || "NVARCHAR2".equalsIgnoreCase(columnType))) continue;
            this.alterTableColumnLength(ctx, targetTable, "FRemark", maxLength);
        }
    }

    private String getTableColumnType(Context ctx, String tblName, String columnName) throws BOSException {
        String dataType = null;
        String sql = null;
        String dbType = (String)ctx.get((Object)"dbType");
        if ("Oracle".equals(dbType)) {
            sql = "SELECT COLUMN_NAME, DATA_TYPE, CHAR_LENGTH FROM USER_TAB_COLUMNS WHERE  (COLUMN_NAME='" + columnName + "' or COLUMN_NAME='" + columnName.toUpperCase() + "') and ( TABLE_NAME = '" + tblName + "' or TABLE_NAME = '" + tblName.toUpperCase() + "')";
        } else if ("MS SQL Server".equals(dbType)) {
            sql = "SELECT syscol.name,systype.name,syscol.prec,syscol.xprec,syscol.xscale FROM syscolumns syscol left join sysobjects sysobj on syscol.id = sysobj.id left join systypes systype on syscol.xtype=systype.xtype WHERE  systype.name!='sysname' and (SYSOBJ.NAME = '" + tblName + "' or SYSOBJ.NAME = '" + tblName.toUpperCase() + "' ) and ( syscol.name='" + columnName + "' or syscol.name='" + columnName.toUpperCase() + "')";
        }
        if (sql != null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, sql);
            try {
                if (rs.next()) {
                    dataType = rs.getString(2);
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        return dataType;
    }

    private int getColLength(Context ctx, String tbName, String colName) throws BOSException {
        int length = 0;
        String lengthCol = "length";
        String dbType = (String)ctx.get((Object)"dbType");
        StringBuffer sb = new StringBuffer();
        if ("Oracle".equalsIgnoreCase(dbType)) {
            sb.append("select DATA_LENGTH from KSQL_USERCOLUMNS where KSQL_COL_NAME ='").append(colName).append("' and KSQL_COL_TABNAME='").append(tbName).append("'");
            lengthCol = "DATA_LENGTH";
        } else {
            sb.append("select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='").append(colName).append("' and KSQL_COL_TABNAME='").append(tbName).append("'");
            lengthCol = "length";
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                length = rs.getInt(lengthCol);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return length;
    }

    private void alterTableColumnLength(Context ctx, String tbName, String colName, int maxLength) {
        StringBuffer sb = new StringBuffer("If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='").append(colName).append("' and KSQL_COL_TABNAME='").append(tbName).append("')").append(" ALTER TABLE ").append(tbName).append(" ALTER COLUMN ").append(colName).append(" NVARCHAR(").append(maxLength).append(")");
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void dowithReference(Context ctx) throws BOSException {
        StringBuffer positionref = new StringBuffer();
        positionref.append("if not exists(SELECT * from t_sys_entityref where FBOSType = '74AE612E'  and FRefTableName='T_HR_EmpOrgRelation')").append("insert into t_sys_entityref(FBOSType, FRefTableName, FRefFieldName, FOrder, FIsBOSFK, FEntityName, FEntityAlias_L1, FEntityAlias_L2, FEntityAlias_L3, FRefEntityName, FRefEntityAlias_L1, FRefEntityAlias_L2, FRefEntityAlias_L3)").append("values").append("('74AE612E', 'T_HR_EmpOrgRelation', 'FPositionID', 1, 1, 'Position', 'Position', '\u804c\u4f4d', '\u8077\u4f4d', 'EmpPosOrgRelation', 'EmpPosOrgRelation', '\u5458\u5de5\u53d8\u52a8\u8bb0\u5f55', '\u54e1\u5de5\u8b8a\u52d5\u8a18\u9304');");
        DbUtil.execute((Context)ctx, (String)positionref.toString());
        StringBuffer personref = new StringBuffer();
        personref.append("if not exists(SELECT * from t_sys_entityref where FBOSType = '80EF7DED'  and FRefTableName='T_HR_EmpOrgRelation')").append("insert into t_sys_entityref(FBOSType, FRefTableName, FRefFieldName, FOrder, FIsBOSFK, FEntityName, FEntityAlias_L1, FEntityAlias_L2, FEntityAlias_L3, FRefEntityName, FRefEntityAlias_L1, FRefEntityAlias_L2, FRefEntityAlias_L3)").append("values").append("('80EF7DED', 'T_HR_EmpOrgRelation', 'FPersonID', 1, 1, 'Person', 'Person', '\u5458\u5de5_\u4e2a\u4eba\u4fe1\u606f', '\u54e1\u5de5_\u500b\u4eba\u4fe1\u606f', 'EmpPosOrgRelation', 'EmpPosOrgRelation', '\u5458\u5de5\u53d8\u52a8\u8bb0\u5f55', '\u54e1\u5de5\u8b8a\u52d5\u8a18\u9304');");
        DbUtil.execute((Context)ctx, (String)personref.toString());
    }
}

