/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.hr.emp.PersonResourceCollection;
import com.kingdee.eas.hr.emp.PersonResourceInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonResourceControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashSet;

public class PersonResourceControllerBean
extends AbstractPersonResourceControllerBean {
    protected IObjectPK _addnew(Context arg0, IObjectValue arg1) throws BOSException, EASBizException {
        this._checkNameBlank(arg0, arg1);
        this._checkNumberBlank(arg0, arg1);
        PersonResourceInfo pInfo = (PersonResourceInfo)arg1;
        if (pInfo.getHrOrgUnit() == null) {
            pInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)arg0));
        }
        return super._addnew(arg0, (IObjectValue)pInfo);
    }

    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonResourceInfo dataBaseInfo = (PersonResourceInfo)model;
        String name = dataBaseInfo.getName();
        if (name == null || name.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
    }

    protected void _checkNumberBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonResourceInfo dataBaseInfo = (PersonResourceInfo)model;
        String number = dataBaseInfo.getNumber();
        if (number == null || number.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
    }

    protected void _update(Context arg0, IObjectPK arg1, IObjectValue arg2) throws BOSException, EASBizException {
        this._checkNameBlank(arg0, arg2);
        this._checkNumberBlank(arg0, arg2);
        super._update(arg0, arg1, arg2);
    }

    private IObjectPK[] addAndUpdate(Context ctx, PersonResourceCollection rsColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        for (int i = 0; i < rsColl.size(); ++i) {
            if (rsColl.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)rsColl.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(rsColl.get(i).getId()), (IObjectValue)rsColl.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    private void deleteList(Context ctx, IObjectPK[] deleteList) throws EASBizException, BOSException {
        if (deleteList == null || deleteList.length == 0) {
            return;
        }
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < deleteList.length; ++i) {
            set.add(deleteList[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        this._delete(ctx, filter);
    }

    @Override
    protected IObjectPK[] _saveAll(Context ctx, IObjectCollection rsColl, IObjectPK[] deleteList) throws BOSException, EASBizException {
        this.deleteList(ctx, deleteList);
        return this.addAndUpdate(ctx, (PersonResourceCollection)rsColl);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        PersonResourceInfo info = (PersonResourceInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }
}

