/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.preentry.PEBankRecordInfo;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.preentry.PreEntryPersonFactory;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankAccountNumDuplicateValidateUtil {
    private static Logger logger = Logger.getLogger(BankAccountNumDuplicateValidateUtil.class);

    public static void checkBankAccountNumDup(Context ctx, String bankCardNum, String excludeBillId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)bankCardNum)) {
            return;
        }
        String personId = (String)ctx.remove((Object)"bankAccountPersonId");
        String realPersonId = null;
        String prePersonId = null;
        String l = LocaleUtils.getShortCode((Context)ctx);
        try {
            StringBuffer oql = new StringBuffer();
            oql.append("SELECT pep.FRealPersonId as realPersonId,pep.fid as prePersonId,br.fid as bid,pep.FName_" + l + " as name,pep.FNumber as number,pep.FIDCardNO as idCardNum,pep.FPassportNO as passportNo,pbr.FAccountNum as bankCardNum FROM T_HR_PEBankRecord pbr");
            oql.append(" left join T_HR_PreEntryPerson pep on pbr.ftalentid=pep.fid");
            oql.append(" left join T_HR_PersonBankRecord br on br.FAccountNum=pbr.FAccountNum");
            oql.append(" left join T_HR_PreEntry pre on pep.fid=pre.ftalentid");
            oql.append(" where pbr.FAccountNum = '").append(bankCardNum).append("'");
            oql.append(" and pre.fid is not null");
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            while (executeQuery.next()) {
                realPersonId = executeQuery.getString("realPersonId");
                prePersonId = executeQuery.getString("prePersonId");
                if (StringUtils.isEmpty((String)realPersonId)) {
                    Boolean isNotDuplicate;
                    PreEntryPersonInfo preEntryPersonInfo = null;
                    if (!StringUtils.isEmpty((String)prePersonId)) {
                        preEntryPersonInfo = PreEntryPersonFactory.getLocalInstance((Context)ctx).getPreEntryPersonInfo("select id where id='" + prePersonId + "'");
                    }
                    if (!(isNotDuplicate = BankAccountNumDuplicateValidateUtil.isNotDuplicate(ctx, preEntryPersonInfo)).booleanValue()) continue;
                    throw new EmployeeException(EmployeeException.EMP_PREPERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("name")});
                }
                if (!(StringUtils.isEmpty((String)excludeBillId) ? !StringUtils.isEmpty((String)executeQuery.getString("bid")) || !StringUtils.isEmpty((String)realPersonId) && !realPersonId.equals(personId) : (!StringUtils.isEmpty((String)executeQuery.getString("bid")) ? !excludeBillId.equals(executeQuery.getString("bid")) : !StringUtils.isEmpty((String)realPersonId) && !realPersonId.equals(personId)))) continue;
                throw new EmployeeException(EmployeeException.EMP_PREPERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("name")});
            }
            oql = new StringBuffer();
            oql.append("select person.FName_" + l + " as name,person.FNumber as number from t_bd_person person");
            oql.append(" left join  T_HR_PersonBankRecord pbr on pbr.fpersonid = person.fid");
            oql.append(" where pbr.FAccountNum ='").append(bankCardNum).append("'");
            if (!StringUtils.isEmpty((String)excludeBillId)) {
                oql.append(" and pbr.fid<>'").append(excludeBillId).append("'");
            }
            if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString())).next()) {
                throw new EmployeeException(EmployeeException.EMP_PERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("number"), executeQuery.getString("name")});
            }
            String curDate = BankAccountNumDuplicateValidateUtil.getCurrentDate();
            oql = new StringBuffer();
            oql.append("select FNUMBER as number from T_HR_EmpEnrollBizBill empEnroll");
            oql.append(" left join T_HR_EmpEnrollBizBillEntry entry on entry.FBillID = empEnroll.FID");
            oql.append(" where (empEnroll.FBillState in (0,1,2) or (empEnroll.FBillState = 3 and entry.FBizDate>").append(curDate).append(")) and entry.FAccountNum = '").append(bankCardNum).append("'");
            if (!StringUtils.isEmpty((String)excludeBillId)) {
                oql.append(" and empEnroll.fid<>'").append(excludeBillId).append("'");
            }
            if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString())).next()) {
                throw new EmployeeException(EmployeeException.EMP_BILL_EXIST_BANKCARD, new Object[]{executeQuery.getString("number")});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static void checkBankAccountNumDup(Context ctx, PEBankRecordInfo bankCardInfo, String personId, String prePersonId) throws EASBizException, BOSException, SQLException {
        IRowSet executeQuery;
        StringBuffer oql;
        if (bankCardInfo == null || StringUtils.isEmpty((String)bankCardInfo.getAccountNum())) {
            return;
        }
        String bankCardNum = bankCardInfo.getAccountNum();
        PreEntryPersonInfo preEntryPersonInfo = null;
        if (preEntryPersonInfo == null && !StringUtils.isEmpty((String)personId)) {
            preEntryPersonInfo = PreEntryPersonFactory.getLocalInstance((Context)ctx).getPreEntryPersonInfo("where person.id='" + personId + "'");
        } else if (preEntryPersonInfo == null && !StringUtils.isEmpty((String)prePersonId)) {
            preEntryPersonInfo = PreEntryPersonFactory.getLocalInstance((Context)ctx).getPreEntryPersonInfo("where id='" + prePersonId + "'");
        }
        String idCardNum = null;
        String passportNum = null;
        boolean isExist = false;
        String l = LocaleUtils.getShortCode((Context)ctx);
        if (preEntryPersonInfo != null) {
            oql = new StringBuffer();
            oql.append("SELECT pep.Fid as id,pep.FName_" + l + " as name,pep.FNumber as number,pep.FIDCardNO as idCardNum,pep.FPassportNO as passportNo,pbr.FAccountNum as bankCardNum,pbr.Fid as bankCardNumId FROM T_HR_PEBankRecord pbr");
            oql.append(" left join T_HR_PreEntryPerson pep on pbr.ftalentid=pep.fid");
            oql.append(" left join T_HR_PreEntry pre on pep.fid=pre.ftalentid");
            oql.append(" where pbr.FAccountNum = '").append(bankCardNum).append("'");
            oql.append(" and pre.fid is not null");
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            String bankCardNumId = null;
            while (executeQuery.next()) {
                Boolean isNotDuplicate;
                idCardNum = executeQuery.getString("idCardNum");
                passportNum = executeQuery.getString("passportNo");
                bankCardNumId = executeQuery.getString("bankCardNumId");
                String prPersonId = executeQuery.getString("id");
                if (!StringUtils.isEmpty((String)idCardNum) && !idCardNum.equals(preEntryPersonInfo.getIdCardNO())) {
                    isExist = true;
                } else if (!StringUtils.isEmpty((String)passportNum) && !passportNum.equals(preEntryPersonInfo.getPassportNO())) {
                    isExist = true;
                } else if (preEntryPersonInfo.getId().toString().equals(executeQuery.getString("id"))) {
                    if (bankCardInfo.getId() == null) {
                        isExist = true;
                    } else if (bankCardInfo.getId() != null && !bankCardInfo.getId().toString().equals(bankCardNumId)) {
                        isExist = true;
                    }
                }
                if (!isExist) continue;
                PreEntryPersonInfo prEntryPersonInfo = null;
                if (!StringUtils.isEmpty((String)prPersonId)) {
                    prEntryPersonInfo = PreEntryPersonFactory.getLocalInstance((Context)ctx).getPreEntryPersonInfo("select id where id='" + prPersonId + "'");
                }
                if (!(isNotDuplicate = BankAccountNumDuplicateValidateUtil.isNotDuplicate(ctx, prEntryPersonInfo)).booleanValue()) continue;
                throw new EmployeeException(EmployeeException.EMP_PREPERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("name")});
            }
        }
        oql = new StringBuffer();
        oql.append("select person.FName_" + l + " as name,person.FNumber as number,person.FIDCARDNO as idCardNum,person.FPASSPORTNO as passportNo,bet.FinService as inService from t_bd_person person");
        oql.append(" left join  T_HR_PersonBankRecord pbr on pbr.fpersonid = person.fid");
        oql.append(" left join  T_HR_BDEmployeeType bet on person.FemployeeTypeId = bet.fid");
        oql.append(" where pbr.FAccountNum ='").append(bankCardNum).append("'");
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        Integer inService = null;
        while (executeQuery.next()) {
            idCardNum = executeQuery.getString("idCardNum");
            passportNum = executeQuery.getString("passportNo");
            inService = executeQuery.getInt("inService");
            if (!StringUtils.isEmpty((String)idCardNum) && preEntryPersonInfo != null && !idCardNum.equals(preEntryPersonInfo.getIdCardNO())) {
                isExist = true;
            } else if (!StringUtils.isEmpty((String)passportNum) && preEntryPersonInfo != null && !passportNum.equals(preEntryPersonInfo.getPassportNO())) {
                isExist = true;
            } else if (inService == null || inService == 1 || inService == 4) {
                isExist = true;
            }
            if (!isExist) continue;
            throw new EmployeeException(EmployeeException.EMP_PERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("number"), executeQuery.getString("name")});
        }
        String curDate = BankAccountNumDuplicateValidateUtil.getCurrentDate();
        oql = new StringBuffer();
        oql.append("select FNUMBER as number from T_HR_EmpEnrollBizBill empEnroll");
        oql.append(" left join T_HR_EmpEnrollBizBillEntry entry on entry.FBillID = empEnroll.FID");
        oql.append(" where (empEnroll.FBillState in (0,1,2) or (empEnroll.FBillState = 3 and entry.FBizDate>").append(curDate).append(")) and entry.FAccountNum = '").append(bankCardNum).append("'");
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        if (executeQuery.next()) {
            throw new EmployeeException(EmployeeException.EMP_BILL_EXIST_BANKCARD, new Object[]{executeQuery.getString("number")});
        }
    }

    public static void checkBankAccountNumDup(Context ctx, PEBankRecordInfo bankCardInfo, String personId, PreEntryPersonInfo preEntryPersonInfo) throws EASBizException, BOSException, SQLException {
        IRowSet executeQuery;
        StringBuffer oql;
        if (bankCardInfo == null || StringUtils.isEmpty((String)bankCardInfo.getAccountNum())) {
            return;
        }
        String bankCardNum = bankCardInfo.getAccountNum();
        String idCardNum = null;
        String passportNum = null;
        boolean isExist = false;
        String l = LocaleUtils.getShortCode((Context)ctx);
        if (preEntryPersonInfo != null) {
            oql = new StringBuffer();
            oql.append("SELECT pep.Fid as id,pep.FName_" + l + " as name,pep.FNumber as number,pep.FIDCardNO as idCardNum,pep.FPassportNO as passportNo,pbr.FAccountNum as bankCardNum,pbr.Fid as bankCardNumId FROM T_HR_PEBankRecord pbr");
            oql.append(" left join T_HR_PreEntryPerson pep on pbr.ftalentid=pep.fid");
            oql.append(" where pbr.FAccountNum = '").append(bankCardNum).append("'").append(" and pep.fid is not null and pbr.ftalentid <> '" + preEntryPersonInfo.getId().toString() + "'");
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            String bankCardNumId = null;
            while (executeQuery.next()) {
                idCardNum = executeQuery.getString("idCardNum");
                passportNum = executeQuery.getString("passportNo");
                bankCardNumId = executeQuery.getString("bankCardNumId");
                if (!StringUtils.isEmpty((String)idCardNum) && !idCardNum.equals(preEntryPersonInfo.getIdCardNO())) {
                    isExist = true;
                } else if (!StringUtils.isEmpty((String)passportNum) && !passportNum.equals(preEntryPersonInfo.getPassportNO())) {
                    isExist = true;
                } else if (executeQuery.getString("id").equals(preEntryPersonInfo.getId().toString())) {
                    if (bankCardInfo.getId() == null) {
                        isExist = true;
                    } else if (bankCardInfo.getId() != null && !bankCardInfo.getId().toString().equals(bankCardNumId)) {
                        isExist = true;
                    }
                }
                if (!isExist) continue;
                throw new EmployeeException(EmployeeException.EMP_PREPERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("name")});
            }
        }
        oql = new StringBuffer();
        oql.append("select person.FName_" + l + " as name,person.FNumber as number,person.FIDCARDNO as idCardNum,person.FPASSPORTNO as passportNo,bet.FinService as inService from t_bd_person person");
        oql.append(" left join  T_HR_PersonBankRecord pbr on pbr.fpersonid = person.fid");
        oql.append(" left join  T_HR_BDEmployeeType bet on person.FemployeeTypeId = bet.fid");
        oql.append(" where pbr.FAccountNum ='").append(bankCardNum).append("'");
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        Integer inService = null;
        while (executeQuery.next()) {
            idCardNum = executeQuery.getString("idCardNum");
            passportNum = executeQuery.getString("passportNo");
            inService = executeQuery.getInt("inService");
            if (!StringUtils.isEmpty((String)idCardNum) && !idCardNum.equals(preEntryPersonInfo.getIdCardNO())) {
                isExist = true;
            } else if (!StringUtils.isEmpty((String)passportNum) && !passportNum.equals(preEntryPersonInfo.getPassportNO())) {
                isExist = true;
            } else if (inService == null || inService == 1 || inService == 4) {
                isExist = true;
            }
            if (!isExist) continue;
            throw new EmployeeException(EmployeeException.EMP_PERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("number"), executeQuery.getString("name")});
        }
        String curDate = BankAccountNumDuplicateValidateUtil.getCurrentDate();
        oql = new StringBuffer();
        oql.append("select FNUMBER as number from T_HR_EmpEnrollBizBill empEnroll");
        oql.append(" left join T_HR_EmpEnrollBizBillEntry entry on entry.FBillID = empEnroll.FID");
        oql.append(" where (empEnroll.FBillState in (0,1,2) or (empEnroll.FBillState = 3 and entry.FBizDate>").append(curDate).append(")) and entry.FAccountNum = '").append(bankCardNum).append("'");
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        if (executeQuery.next()) {
            throw new EmployeeException(EmployeeException.EMP_BILL_EXIST_BANKCARD, new Object[]{executeQuery.getString("number")});
        }
    }

    public static void checkAccountNumDupByPersonInfos(Context ctx, String bankCardNum, String excludeBillId) throws EASBizException, BOSException {
        String personId = (String)ctx.remove((Object)"bankAccountPersonId");
        if (StringUtils.isEmpty((String)bankCardNum)) {
            return;
        }
        String realPersonId = null;
        String prePersonId = null;
        String idCardNum = null;
        String passportNum = null;
        String l = LocaleUtils.getShortCode((Context)ctx);
        try {
            StringBuffer oql = new StringBuffer();
            oql.append("SELECT pep.FRealPersonId as realPersonId,pep.fid as prePersonId,br.fid as bid,pep.FName_" + l + " as name,pep.FNumber as number,pep.FIDCardNO as idCardNum,pep.FPassportNO as passportNo,pbr.FAccountNum as bankCardNum FROM T_HR_PEBankRecord pbr");
            oql.append(" left join T_HR_PreEntryPerson pep on pbr.ftalentid=pep.fid");
            oql.append(" left join T_HR_PreEntry pre on pep.fid=pre.ftalentid");
            oql.append(" left join T_HR_PersonBankRecord br on br.FAccountNum=pbr.FAccountNum");
            oql.append(" where pbr.FAccountNum = '").append(bankCardNum).append("'");
            oql.append(" and pre.fid is not null");
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            while (executeQuery.next()) {
                realPersonId = executeQuery.getString("realPersonId");
                prePersonId = executeQuery.getString("prePersonId");
                idCardNum = executeQuery.getString("idCardNum");
                passportNum = executeQuery.getString("passportNo");
                if (StringUtils.isEmpty((String)realPersonId)) {
                    PreEntryPersonInfo preEntryPersonInfo = null;
                    if (!StringUtils.isEmpty((String)prePersonId)) {
                        preEntryPersonInfo = PreEntryPersonFactory.getLocalInstance((Context)ctx).getPreEntryPersonInfo("select id where id='" + prePersonId + "'");
                    }
                    Boolean isNotDuplicate = BankAccountNumDuplicateValidateUtil.isNotDuplicate(ctx, preEntryPersonInfo);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("idCardNum", idCardNum);
                    params.put("passportNum", passportNum);
                    params.put("personId", personId);
                    Boolean isSamePerson = BankAccountNumDuplicateValidateUtil.isSamePerson(ctx, preEntryPersonInfo, params);
                    if (!isNotDuplicate.booleanValue() || isSamePerson.booleanValue()) continue;
                    throw new EmployeeException(EmployeeException.EMP_PREPERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("name")});
                }
                if (!(StringUtils.isEmpty((String)excludeBillId) ? !StringUtils.isEmpty((String)executeQuery.getString("bid")) || !StringUtils.isEmpty((String)realPersonId) && !realPersonId.equals(personId) : (!StringUtils.isEmpty((String)executeQuery.getString("bid")) ? !excludeBillId.equals(executeQuery.getString("bid")) : !StringUtils.isEmpty((String)realPersonId) && !realPersonId.equals(personId)))) continue;
                throw new EmployeeException(EmployeeException.EMP_PREPERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("name")});
            }
            oql = new StringBuffer();
            oql.append("select person.FName_" + l + " as name,person.FNumber as number from t_bd_person person");
            oql.append(" left join  T_HR_PersonBankRecord pbr on pbr.fpersonid = person.fid");
            oql.append(" where pbr.FAccountNum ='").append(bankCardNum).append("'");
            if (!StringUtils.isEmpty((String)excludeBillId)) {
                oql.append(" and pbr.fid<>'").append(excludeBillId).append("'");
            }
            if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString())).next()) {
                throw new EmployeeException(EmployeeException.EMP_PERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("number"), executeQuery.getString("name")});
            }
            String curDate = BankAccountNumDuplicateValidateUtil.getCurrentDate();
            oql = new StringBuffer();
            oql.append("select FNUMBER as number from T_HR_EmpEnrollBizBill empEnroll");
            oql.append(" left join T_HR_EmpEnrollBizBillEntry entry on entry.FBillID = empEnroll.FID");
            oql.append(" where (empEnroll.FBillState in (0,1,2) or (empEnroll.FBillState = 3 and entry.FBizDate>").append(curDate).append(")) and entry.FAccountNum = '").append(bankCardNum).append("'");
            if (!StringUtils.isEmpty((String)excludeBillId)) {
                oql.append(" and empEnroll.fid<>'").append(excludeBillId).append("'");
            }
            if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString())).next()) {
                throw new EmployeeException(EmployeeException.EMP_BILL_EXIST_BANKCARD, new Object[]{executeQuery.getString("number")});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static void checkPreToEmpAccountNumDup(Context ctx, String bankCardNum, String excludeBillId, String entryId, String preEntryId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)bankCardNum)) {
            return;
        }
        String personId = (String)ctx.remove((Object)"bankAccountPersonId");
        String realPersonId = null;
        String prePersonId = null;
        String idCardNum = null;
        String passportNum = null;
        String l = LocaleUtils.getShortCode((Context)ctx);
        try {
            StringBuffer oql = new StringBuffer();
            oql.append("SELECT pep.FRealPersonId as realPersonId,pep.fid as prePersonId,br.fid as bid,pep.FName_" + l + " as name,pep.FNumber as number, ");
            oql.append(" pep.FIDCardNO as idCardNum,pep.FPassportNO as passportNo,pbr.FAccountNum as bankCardNum FROM T_HR_PEBankRecord pbr");
            oql.append(" left join T_HR_PreEntryPerson pep on pbr.ftalentid=pep.fid");
            oql.append(" left join T_HR_PreEntry pre on pep.fid=pre.ftalentid");
            oql.append(" left join T_HR_PersonBankRecord br on br.FAccountNum=pbr.FAccountNum");
            oql.append(" where pbr.FAccountNum = '").append(bankCardNum).append("'");
            oql.append(" and pre.fid is not null");
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            while (executeQuery.next()) {
                realPersonId = executeQuery.getString("realPersonId");
                prePersonId = executeQuery.getString("prePersonId");
                idCardNum = executeQuery.getString("idCardNum");
                passportNum = executeQuery.getString("passportNo");
                if (StringUtils.isEmpty((String)realPersonId)) {
                    PreEntryPersonInfo preEntryPersonInfo = null;
                    if (!StringUtils.isEmpty((String)prePersonId)) {
                        preEntryPersonInfo = PreEntryPersonFactory.getLocalInstance((Context)ctx).getPreEntryPersonInfo("select id where id='" + prePersonId + "'");
                    }
                    Boolean isNotDuplicate = BankAccountNumDuplicateValidateUtil.isNotDuplicate(ctx, preEntryPersonInfo);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("idCardNum", idCardNum);
                    params.put("passportNum", passportNum);
                    params.put("personId", personId);
                    Boolean isSamePerson = BankAccountNumDuplicateValidateUtil.isSamePerson(ctx, preEntryPersonInfo, params);
                    Boolean isPreToEmp = BankAccountNumDuplicateValidateUtil.isPreToEmp(ctx, preEntryPersonInfo, excludeBillId, entryId, preEntryId);
                    if (!isNotDuplicate.booleanValue() || isSamePerson.booleanValue() || isPreToEmp.booleanValue()) continue;
                    throw new EmployeeException(EmployeeException.EMP_PREPERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("name")});
                }
                if (!(StringUtils.isEmpty((String)excludeBillId) ? !StringUtils.isEmpty((String)executeQuery.getString("bid")) || !StringUtils.isEmpty((String)realPersonId) && !realPersonId.equals(personId) : (!StringUtils.isEmpty((String)executeQuery.getString("bid")) ? !excludeBillId.equals(executeQuery.getString("bid")) : !StringUtils.isEmpty((String)realPersonId) && !realPersonId.equals(personId)))) continue;
                throw new EmployeeException(EmployeeException.EMP_PREPERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("name")});
            }
            oql = new StringBuffer();
            oql.append("select person.FName_" + l + " as name,person.FNumber as number from t_bd_person person");
            oql.append(" left join  T_HR_PersonBankRecord pbr on pbr.fpersonid = person.fid");
            oql.append(" where pbr.FAccountNum ='").append(bankCardNum).append("'");
            if (!StringUtils.isEmpty((String)excludeBillId)) {
                oql.append(" and pbr.fid<>'").append(excludeBillId).append("'");
            }
            if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString())).next()) {
                throw new EmployeeException(EmployeeException.EMP_PERSON_BANKCARD_EXIST, new Object[]{executeQuery.getString("number"), executeQuery.getString("name")});
            }
            String curDate = BankAccountNumDuplicateValidateUtil.getCurrentDate();
            oql = new StringBuffer();
            oql.append("select FNUMBER as number from T_HR_EmpEnrollBizBill empEnroll");
            oql.append(" left join T_HR_EmpEnrollBizBillEntry entry on entry.FBillID = empEnroll.FID");
            oql.append(" where (empEnroll.FBillState in (0,1,2) or (empEnroll.FBillState = 3 and entry.FBizDate>").append(curDate).append(")) and entry.FAccountNum = '").append(bankCardNum).append("'");
            if (!StringUtils.isEmpty((String)excludeBillId)) {
                oql.append(" and empEnroll.fid<>'").append(excludeBillId).append("'");
            }
            if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)oql.toString())).next()) {
                throw new EmployeeException(EmployeeException.EMP_BILL_EXIST_BANKCARD, new Object[]{executeQuery.getString("number")});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }

    public static Boolean isNotDuplicate(Context ctx, PreEntryPersonInfo preEntryPersonInfo) throws BOSException {
        String prePersonId;
        Boolean isNotDuplicate = true;
        PreEntryInfo preEntryInfo = null;
        String string = prePersonId = preEntryPersonInfo != null ? preEntryPersonInfo.getId().toString() : "";
        if (!StringUtils.isEmpty((String)prePersonId)) {
            PreEntryCollection preEntryCollection = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection("select checkInState, billState where talent.id = '" + prePersonId + "'");
            if (preEntryCollection.size() == 1) {
                preEntryInfo = preEntryCollection.get(0);
                if ("1".equals(preEntryInfo.getCheckInState().getValue()) || "2".equals(preEntryInfo.getCheckInState().getValue()) || 4 == preEntryInfo.getBillState().getValue()) {
                    isNotDuplicate = false;
                }
            } else if (preEntryCollection.size() > 1) {
                // empty if block
            }
        }
        return isNotDuplicate;
    }

    protected static Boolean isPreToEmp(Context ctx, PreEntryPersonInfo preEntryPersonInfo, String empEnrollBizBillId, String entryId, String preEntryId) throws BOSException {
        String prePersonId;
        Boolean isPreToEmp = false;
        PreEntryInfo preEntryInfo = null;
        String string = prePersonId = preEntryPersonInfo != null ? preEntryPersonInfo.getId().toString() : "";
        if (!StringUtils.isEmpty((String)prePersonId)) {
            PreEntryCollection preEntryCollection = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection("select id, personBillId where talent.id = '" + prePersonId + "'");
            if (!StringUtils.isEmpty((String)preEntryId) && preEntryCollection.size() > 0) {
                preEntryInfo = preEntryCollection.get(0);
                if (preEntryId.equals(preEntryInfo.getId().toString())) {
                    isPreToEmp = true;
                }
            } else if (!StringUtils.isEmpty((String)entryId) && preEntryCollection.size() > 0) {
                String personBillId;
                preEntryInfo = preEntryCollection.get(0);
                String string2 = personBillId = preEntryInfo.getPersonBillId() != null ? preEntryInfo.getPersonBillId().toString() : "";
                if (entryId.equals(personBillId)) {
                    isPreToEmp = true;
                }
            }
        }
        return isPreToEmp;
    }

    protected static Boolean isSamePerson(Context ctx, PreEntryPersonInfo preEntryPersonInfo, Map<String, String> params) throws BOSException {
        String personId;
        Boolean isSamePerson = false;
        String idCardNum = params.get("idCardNum") != null ? params.get("idCardNum") : "";
        String passportNum = params.get("passportNum") != null ? params.get("passportNum") : "";
        String string = personId = params.get("personId") != null ? params.get("personId") : "";
        if (StringUtils.isEmpty((String)personId)) {
            return false;
        }
        String oql = "select id, idCardNO, passportNO  where id = '" + personId + "'";
        PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(oql);
        if (personColl != null && personColl.size() > 0) {
            PersonInfo personInfo = personColl.get(0);
            if (!StringUtils.isEmpty((String)idCardNum) && idCardNum.equals(personInfo.getIdCardNO())) {
                isSamePerson = true;
            } else if (!StringUtils.isEmpty((String)passportNum) && passportNum.equals(personInfo.getPassportNO())) {
                isSamePerson = true;
            }
        }
        return isSamePerson;
    }
}

