/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.message.util.sendmsg.util.StringUtil;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AffairActionReasonFactory;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.BlackListEnum;
import com.kingdee.eas.hr.base.BlackListReasonFactory;
import com.kingdee.eas.hr.base.BlackListReasonInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.IPersonBlackList;
import com.kingdee.eas.hr.base.PersonBlackListCollection;
import com.kingdee.eas.hr.base.PersonBlackListFactory;
import com.kingdee.eas.hr.base.PersonBlackListInfo;
import com.kingdee.eas.hr.base.SourceEnum;
import com.kingdee.eas.hr.base.StateEnum;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;

public class PersonBlackListUtil {
    public static void addToBlackList(Context ctx, HRBizData hrBizData) throws EASBizException, BOSException {
        AffairActionReasonInfo actionReason = hrBizData.getActionType();
        if (actionReason == null) {
            return;
        }
        actionReason = AffairActionReasonFactory.getLocalInstance((Context)ctx).getAffairActionReasonInfo((IObjectPK)new ObjectUuidPK(actionReason.getId()));
        PersonInfo srcPersonInfo = hrBizData.getNewPosition().getPersonInfo();
        HRBizDefineTypeEnum bizDefineType = hrBizData.getHrbizDefine().getBizDefineType();
        if (bizDefineType == null) {
            HRBizDefineInfo defineInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(hrBizData.getHrbizDefine().getId().toString()));
            bizDefineType = defineInfo.getBizDefineType();
        }
        if (bizDefineType != null && bizDefineType == HRBizDefineTypeEnum.RESIGN && actionReason.getBlackList() == BlackListEnum.AddBlackList) {
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(srcPersonInfo.getId()));
            String oql = PersonBlackListUtil.getBlackListWhereSql(personInfo.getIdCardNO(), personInfo.getPassportNO());
            oql = StringUtils.isEmpty((String)oql) ? " " : " where " + oql;
            PersonBlackListInfo blackListInfo = null;
            blackListInfo = StringUtils.isEmpty((String)oql) || !PersonBlackListFactory.getLocalInstance((Context)ctx).exists(oql) ? new PersonBlackListInfo() : PersonBlackListFactory.getLocalInstance((Context)ctx).getPersonBlackListInfo(oql);
            if (hrBizData.getNewPosition().getAdminInfo() != null) {
                blackListInfo.setAdminOrg(hrBizData.getNewPosition().getAdminInfo());
            } else {
                blackListInfo.setAdminOrg(hrBizData.getOldPosition().getAdminInfo());
            }
            if (hrBizData.getNewPosition().getPositionInfo() != null) {
                blackListInfo.setPosition(hrBizData.getNewPosition().getPositionInfo());
            } else {
                blackListInfo.setPosition(hrBizData.getOldPosition().getPositionInfo());
            }
            BlackListReasonInfo reason = null;
            if (BlackListReasonFactory.getLocalInstance((Context)ctx).exists("where id='POyKtoNnex/gU6hCqMCz4hOSU1Y='")) {
                reason = BlackListReasonFactory.getLocalInstance((Context)ctx).getBlackListReasonInfo("where id='POyKtoNnex/gU6hCqMCz4hOSU1Y='");
            }
            if (reason == null) {
                String sql = "If not exists (select * from T_HR_BlackListReason where fid='POyKtoNnex/gU6hCqMCz4hOSU1Y=') insert into T_HR_BlackListReason(FINDEX, FSTATE, FNAME_L1, FNAME_L2, FNAME_L3, FNUMBER, FDESCRIPTION_L1, FDESCRIPTION_L2, FDESCRIPTION_L3, FSIMPLENAME, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME, FCONTROLUNITID, FID)  values  (5, 1, null, N'\u79bb\u804c\u81ea\u52a8\u8f6c\u9ed1\u540d\u5355', null, N'0005', null, N'\u79bb\u804c\u81ea\u52a8\u8f6c\u9ed1\u540d\u5355', null, null, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2015-08-20 11:04:15'}, '00000000-0000-0000-0000-00000000000013B7DE7F', {ts'2015-08-20 11:04:15'}, '11111111-1111-1111-1111-111111111111CCE7AED4', 'POyKtoNnex/gU6hCqMCz4hOSU1Y=')";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            if (BlackListReasonFactory.getLocalInstance((Context)ctx).exists("where id='POyKtoNnex/gU6hCqMCz4hOSU1Y='")) {
                reason = BlackListReasonFactory.getLocalInstance((Context)ctx).getBlackListReasonInfo("where id='POyKtoNnex/gU6hCqMCz4hOSU1Y='");
            }
            blackListInfo.setJoinReason(reason);
            blackListInfo.setPerson(personInfo);
            blackListInfo.setPassportNO(personInfo.getPassportNO());
            blackListInfo.setIdCardNO(personInfo.getIdCardNO());
            blackListInfo.setAffairActionReason(hrBizData.getActionReason());
            blackListInfo.setStateModifier(ContextUtil.getCurrentUserInfo((Context)ctx));
            if (hrBizData.isLeftConpanyDateFalg() && !hrBizData.isSameDatePersonChange()) {
                blackListInfo.setLeftDate(HRUtil.getBeforeDate((Date)hrBizData.getStartDate()));
            } else {
                blackListInfo.setLeftDate(hrBizData.getStartDate());
            }
            blackListInfo.setSource(SourceEnum.SYSTEM_ADD);
            blackListInfo.setState(StateEnum.ENABLE);
            if (hrBizData.getEntryID() != null) {
                blackListInfo.setEntryId(hrBizData.getEntryID());
            }
            Date date = new Date();
            blackListInfo.setJoinDate(date);
            IObjectPK pk = PersonBlackListFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)blackListInfo);
            String blackId = pk.getKeyValue("id").toString();
            if (StringUtil.isNotEmpty((String)blackId)) {
                PersonBlackListUtil.setRecBlacklistOSF(ctx, true, blackId);
            }
        }
    }

    public static boolean isInBlackList(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException {
        if (personInfo == null || StringUtils.isEmpty((String)personInfo.getPassportNO()) && StringUtils.isEmpty((String)personInfo.getIdCardNO())) {
            return false;
        }
        String oql = PersonBlackListUtil.getSelectBlackListSql(personInfo);
        boolean isInBlackList = PersonBlackListFactory.getLocalInstance((Context)ctx).exists(oql);
        return isInBlackList;
    }

    private static String getSelectBlackListSql(PersonInfo personInfo) {
        StringBuffer oql = new StringBuffer();
        oql.append("select * where state=1 and source in (1,2,4,5)");
        if (!StringUtils.isEmpty((String)personInfo.getIdCardNO()) && StringUtils.isEmpty((String)personInfo.getPassportNO())) {
            oql.append(" and idCardNO='").append(personInfo.getIdCardNO()).append("'");
        } else if (StringUtils.isEmpty((String)personInfo.getIdCardNO()) && !StringUtils.isEmpty((String)personInfo.getPassportNO())) {
            oql.append(" and passportNO='").append(personInfo.getPassportNO()).append("'");
        } else if (!StringUtils.isEmpty((String)personInfo.getIdCardNO()) && !StringUtils.isEmpty((String)personInfo.getPassportNO())) {
            oql.append(" and ( idCardNO='").append(personInfo.getIdCardNO()).append("'").append(" or passportNO='").append(personInfo.getPassportNO()).append("' ) ");
        }
        return oql.toString();
    }

    public static String getBlackListWhereSql(String idCardNO, String passportNO) {
        StringBuffer oql = new StringBuffer(" ");
        if (!StringUtils.isEmpty((String)idCardNO) && StringUtils.isEmpty((String)passportNO)) {
            oql.append(" idCardNO='").append(idCardNO).append("'");
        } else if (StringUtils.isEmpty((String)idCardNO) && !StringUtils.isEmpty((String)passportNO)) {
            oql.append(" passportNO='").append(passportNO).append("'");
        } else if (!StringUtils.isEmpty((String)idCardNO) && !StringUtils.isEmpty((String)passportNO)) {
            oql.append(" ( idCardNO='").append(idCardNO).append("'").append(" or passportNO='").append(passportNO).append("' ) ");
        }
        return oql.toString();
    }

    public static void setRecBlacklistOSF(Context ctx, boolean flag, String personids) throws BOSException, EASBizException {
        if (!StringUtil.isEmpty((String)personids)) {
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "setRecBlacklistOSF");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("personBlackId", personids);
            if (flag) {
                param.put("opType", "1");
            } else {
                param.put("opType", "2");
            }
            imsf.process(ctx, param);
        }
    }

    public static void removeFromPersonBlackList(Context ctx, String entryId) throws EASBizException, BOSException {
        IPersonBlackList iPersonBlackList = PersonBlackListFactory.getLocalInstance((Context)ctx);
        PersonBlackListCollection PersonBlackListCollection2 = iPersonBlackList.getPersonBlackListCollection("select id  where entryId = '" + entryId + "'");
        if (PersonBlackListCollection2 != null & PersonBlackListCollection2.size() > 0) {
            for (int i = 0; i < PersonBlackListCollection2.size(); ++i) {
                PersonBlackListInfo personBlackListInfo = PersonBlackListCollection2.get(i);
                iPersonBlackList.delete("where id = '" + personBlackListInfo.getId().toString() + "'");
                PersonBlackListUtil.setRecBlacklistOSF(ctx, false, personBlackListInfo.getId().toString());
            }
        }
    }
}

