/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpHRORelationHisCollection;
import com.kingdee.eas.hr.base.EmpHRORelationHisFactory;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationCollection;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationFactory;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationInfo;
import com.kingdee.shr.base.bizmanage.AdminOrgChangeMsgFactory;
import com.kingdee.shr.base.bizmanage.AdminOrgChangeMsgInfo;
import com.kingdee.shr.base.bizmanage.BizManageMessageFacadeFactory;
import com.kingdee.shr.base.bizmanage.HRBizDefineTypeEnum;
import com.kingdee.shr.base.bizmanage.ISHRBizManageMsgManage;
import com.kingdee.shr.base.bizmanage.ModifyTypeEnum;
import com.kingdee.shr.base.bizmanage.PersonChangeMsgInfo;
import com.kingdee.shr.base.bizmanage.SHRBizManageMsgManageFactory;
import com.kingdee.shr.base.bizmanage.app.BizManageMessageFacadeControllerBean;
import com.kingdee.shr.base.bizmanage.constant.BizManageMsgConstants;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageCommonTool;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageHelpUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SHREmpOptBizManageTool {
    public static final String BizManageType_EMP_ID = "SGuJm3nXW0GshQfKRXenomWJ1dE=";
    public static final int Batch_Max_Count = 500;

    public void writePersonEmpOrgChangeMsgData(Context ctx, HRBizData bizData) throws EASBizException, BOSException {
        String affairEntryId = bizData.getHRAffairActionTransactionLogID();
        String curPersonId = bizData.getNewPosition().getPersonInfo().getId().toString();
        String hrBizDefineId = bizData.getHrbizDefine().getId().toString();
        PersonChangeMsgInfo changeMsgInfo = new PersonChangeMsgInfo();
        changeMsgInfo.setHrBizDefine(hrBizDefineId);
        HRBizDefineInfo bizDefineInfo = bizData.getHrbizDefine();
        changeMsgInfo.setBizDefineType(HRBizDefineTypeEnum.getEnum((int)bizDefineInfo.getBizDefineType().getValue()));
        changeMsgInfo.setChangeDate(bizData.getStartDate());
        changeMsgInfo.setPerson(curPersonId);
        if (bizData.getActionType() != null) {
            changeMsgInfo.setAffairActionReason(bizData.getActionType().getId().toString());
        }
        this.assembleFlowInPersonChangeMsgInfo(ctx, affairEntryId, changeMsgInfo);
        if (StringUtils.isEmpty((String)changeMsgInfo.getOldEmpOrgRelation()) && StringUtils.isEmpty((String)changeMsgInfo.getNewEmpOrgRelation())) {
            this.assemblePureFlowOutPersonChangeMsgInfo(ctx, bizData, affairEntryId, changeMsgInfo);
        }
        changeMsgInfo.setDealState(false);
        changeMsgInfo.setAffairActionTransId(affairEntryId);
        if (!bizData.isSupplementBill()) {
            if (hrBizDefineId.equals("P/OSDCPfQXqU0TB/LQoA6uZovtk=")) {
                changeMsgInfo.setIsEmpInit(true);
            }
            BizManageMessageFacadeFactory.getLocalInstance((Context)ctx).addDefaultBURelationForNewPerson(changeMsgInfo);
        } else {
            changeMsgInfo.put("isSupplementBill", (Object)"true");
            BizManageMessageFacadeFactory.getLocalInstance((Context)ctx).addDefaultBURelationForNewPerson(changeMsgInfo);
        }
    }

    public void batchWritePersonEmpOrgChangeMsgData(Context ctx, List<String> personIdList, boolean isEmpInit) throws EASBizException, BOSException {
        int commit_count = 500;
        HashSet<String> idSet = new HashSet<String>();
        int initCount = 0;
        int size = personIdList.size();
        for (int i = 0; i < size; ++i) {
            if (initCount >= commit_count) {
                this.batchWritePersonEmpOrgChangeMsgData(ctx, idSet, isEmpInit);
                idSet = new HashSet();
                initCount = 0;
            }
            idSet.add(personIdList.get(i));
            ++initCount;
        }
        if (initCount > 0) {
            this.batchWritePersonEmpOrgChangeMsgData(ctx, idSet, isEmpInit);
        }
    }

    public void batchWritePersonConfirmMsgData(Context ctx) throws EASBizException, BOSException {
        List bizManageTypeIdList = SHRBizManageCommonTool.getEnableBizManageTypeIdList((Context)ctx);
        HashMap<String, String> param = new HashMap<String, String>();
        String tempTblName = null;
        try {
            tempTblName = TempTablePool.getInstance((Context)ctx).createTempTable("create table T_HR_PERSONCHGMSGTMPTBL (FID varchar(44))");
            StringBuffer insertSqlBuf = new StringBuffer();
            insertSqlBuf.append("insert into ").append(tempTblName).append("(FID) ").append("select fid from T_HR_PersonChangeMsg where FIsEmpInit=1 and fDealState=0");
            DbUtil.execute((Context)ctx, (String)insertSqlBuf.toString());
            param.put(BizManageMsgConstants.PARAM_PERSON_INIT_MSGTBL_NAME, tempTblName);
            DbUtil.execute((Context)ctx, (String)("update T_HR_PersonChangeMsg set fDealState=1 where FID in (select fid from " + tempTblName + ")"));
            for (String bizManageTypeId : bizManageTypeIdList) {
                ISHRBizManageMsgManage instance = SHRBizManageMsgManageFactory.getInstance((Context)ctx, (String)bizManageTypeId, (int)0);
                instance.batchAddPersonInitConfirmMsgByBizType(ctx, param);
            }
        }
        catch (Exception e) {
            DbUtil.execute((Context)ctx, (String)("update T_HR_PersonChangeMsg set fDealState=0 where FID in (select fid from " + tempTblName + ")"));
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty(tempTblName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTblName);
            }
        }
    }

    public void batchWriteDisableAdminPersonConfirmMsgData(Context ctx, List<String> personIdList, HashSet<String> adminIdSet) throws EASBizException, BOSException {
        int commit_count = 500;
        HashSet<String> idSet = new HashSet<String>();
        int initCount = 0;
        int size = personIdList.size();
        for (int i = 0; i < size; ++i) {
            if (initCount >= commit_count) {
                this.batchWriteDisableAdminPersonConfirmMsgDataDo(ctx, idSet, adminIdSet);
                idSet = new HashSet();
                initCount = 0;
            }
            idSet.add(personIdList.get(i));
            ++initCount;
        }
        if (initCount > 0) {
            this.batchWriteDisableAdminPersonConfirmMsgDataDo(ctx, idSet, adminIdSet);
        }
    }

    public void batchWriteDisableAdminPersonConfirmMsgDataDo(Context ctx, Set<String> personIdSet, HashSet<String> adminIdSet) throws EASBizException, BOSException {
        String personIdStr = HRUtil.getStrFromSet(personIdSet);
        String personChangeFilter = "SELECT FID FROM T_HR_PersonChangeMsg WHERE FDealState = 0 AND FIsEmpInit = 1 AND FPersonID IN " + personIdStr;
        if (personIdSet != null && personIdSet.size() > 0) {
            String tempTblName = null;
            try {
                tempTblName = TempTablePool.getInstance((Context)ctx).createTempTable("create table T_HR_DisableAdminBuRelation (FID varchar(44),FManageHrOrgID varchar(44),FBizManageTypeID varchar(44))");
                for (String adminOrgID : adminIdSet) {
                    HROrgUnitInfo hrOrgUnitInfo = SHREmpOptBizManageTool.getAddnewAdminDefaultManageOrg(ctx, adminOrgID, BizManageType_EMP_ID);
                    String hrOrgUnitID = "";
                    hrOrgUnitID = hrOrgUnitInfo != null ? hrOrgUnitInfo.getId().toString() : "00000000-0000-0000-0000-000000000000CCE7AED4";
                    StringBuffer insertSqlBuf = new StringBuffer();
                    insertSqlBuf.append("insert into ").append(tempTblName).append("(FID,FManageHrOrgID,FBizManageTypeID) VALUES ('").append(adminOrgID).append("','").append(hrOrgUnitID).append("','").append(BizManageType_EMP_ID).append("')");
                    DbUtil.execute((Context)ctx, (String)insertSqlBuf.toString());
                }
                StringBuffer initConfirmInsertSql = new StringBuffer();
                initConfirmInsertSql.append("insert into t_hr_personburelaconfirm(FPersonID, FHRBizDefineID, FBizDefineType, FChangeDate,").append("FNewEmpOrgRelationID, FNewEmpPostExpHisID, FCurEmpOrgRelationID,").append("FBizManageTypeID, FNewHrOrgUnitID, FDefaultHrOrgUnitID, FAffairActionReasonID, FAffairActionTransId,").append("FDealState, FChangeMsgId, FbizDefineEntrySeq, FVersion,").append(" FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID,").append(" FID, FAffairActionOperate, FIsEmpInit)");
                initConfirmInsertSql.append(" select perChgMsg.FPersonID,perChgMsg.fHrBizDefineId,perChgMsg.fBizDefineType,perChgMsg.FChangeDate,").append("perChgMsg.fNewEmpOrgRelationID,empExpHis.fid,perChgMsg.fNewEmpOrgRelationID,").append("orgBuRela.FBizManageTypeID,orgBuRela.FManageHrOrgID,orgBuRela.FManageHrOrgID,perChgMsg.FAffairActionReasonID,perChgMsg.FAffairActionTransId,").append("0,perChgMsg.FID,1,1,").append("perChgMsg.FCreatorID,perChgMsg.FCreateTime,perChgMsg.FLastUpdateUserID,perChgMsg.FLastUpdateTime,perChgMsg.FControlUnitID,").append("newbosid('701C1F8F'),defineEntry.FAffairActionOperate,1").append(" from T_HR_PersonChangeMsg perChgMsg  ").append(" inner join T_HR_EmpOrgRelation empPosRela on perChgMsg.FNewEmpOrgRelationID=empPosRela.FID").append(" left join T_HR_EmpPostExperienceHis empExpHis on empExpHis.fPersonID=perChgMsg.fPersonID and empPosRela.fPositionID=empExpHis.FPositionID").append(" inner join T_HR_HRBizDefineEntry defineEntry on defineEntry.FParentID=perChgMsg.fHrBizDefineId").append(" inner join ").append(tempTblName).append(" orgBuRela on orgBuRela.FID = empPosRela.FAdminOrgID").append(" where perChgMsg.FID in (").append(personChangeFilter).append(")");
                DbUtil.execute((Context)ctx, (String)initConfirmInsertSql.toString());
                DbUtil.execute((Context)ctx, (String)("update T_HR_PersonChangeMsg set fDealState = 1 where FID in (" + personChangeFilter + ")"));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            finally {
                if (!StringUtils.isEmpty(tempTblName)) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTblName);
                }
            }
        }
    }

    public void batchWritePersonBuRelationMsgData(Context ctx) throws EASBizException, BOSException {
        int commit_count = 250;
        int initCount = 0;
        String idString = "";
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> existUpdateList = new ArrayList<String>();
        BizManageMessageFacadeControllerBean bizManageMessageFacadeControllerBean = new BizManageMessageFacadeControllerBean();
        ISHRBizManageMsgManage instance = SHRBizManageMsgManageFactory.getInstance((Context)ctx, (String)BizManageType_EMP_ID, (int)0);
        try {
            String sql = "SELECT FID,FNewEmpOrgRelationID FROM T_HR_PersonBURelaConfirm WHERE FIsEmpInit = 1 AND FDealState = 0 AND FBizManageTypeID = 'SGuJm3nXW0GshQfKRXenomWJ1dE=' AND FAffairActionOperate is not null order by fchangeDate,fcreateTime,FbizDefineEntrySeq";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String empOrgRelationID = rs.getString(2);
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT FID FROM T_HR_PersonBURelation WHERE FEMPORGRELATIONID = '" + empOrgRelationID + "' AND FBIZMANAGETYPEID = '" + BizManageType_EMP_ID + "' AND FSTATE = 1"));
                if (executeQuery.size() > 0) {
                    existUpdateList.add("UPDATE T_HR_PersonBURelaConfirm SET FDealState = 1 WHERE FID = '" + rs.getString(1) + "'");
                    continue;
                }
                idString = idString + ",'" + rs.getString(1) + "'";
                list.add(rs.getString(1));
                if (++initCount < commit_count) continue;
                String insertSql = bizManageMessageFacadeControllerBean.getInitPersonInsertSql(ctx, BizManageType_EMP_ID, idString.substring(1));
                DbUtil.execute((Context)ctx, (String)insertSql);
                instance.addInitFileEnablePersonManageInfo(ctx, list);
                DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonBURelaConfirm SET FDealState = 1 WHERE FID IN (" + idString.substring(1) + ")"));
                initCount = 0;
                idString = "";
                list = new ArrayList();
            }
            if (initCount > 0 && !idString.equals("")) {
                String insertSql = bizManageMessageFacadeControllerBean.getInitPersonInsertSql(ctx, BizManageType_EMP_ID, idString.substring(1));
                DbUtil.execute((Context)ctx, (String)insertSql);
                instance.addInitFileEnablePersonManageInfo(ctx, list);
                DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonBURelaConfirm SET FDealState = 1 WHERE FID IN (" + idString.substring(1) + ")"));
            }
            if (existUpdateList.size() > 0) {
                SHRBizManageHelpUtil.insertByBatch((Context)ctx, existUpdateList, (int)250);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void batchWritePersonEmpOrgChangeMsgData(Context ctx, Set<String> personIdSet, boolean isEmpInit) throws EASBizException, BOSException {
        if (personIdSet != null && personIdSet.size() > 0) {
            String personIdStr = HRUtil.getStrFromSet(personIdSet);
            String userId = ctx.getCaller().toString();
            String curDateTime = HRUtilExtend.getCurrentDate();
            CtrlUnitInfo curCUInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String curCuId = "";
            if (curCUInfo != null) {
                curCuId = curCUInfo.getId().toString();
            }
            StringBuffer sql = new StringBuffer();
            sql.append("insert into T_HR_PersonChangeMsg(fid,FPersonID,fHrBizDefineId,fBizDefineType,fChangeDate,fNewEmpOrgRelationID,fDealState,FAffairActionTransId,FAffairActionReasonID").append(" ,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID");
            if (isEmpInit) {
                sql.append(",FIsEmpInit)");
            }
            sql.append(" select newbosid('2D5ED5BB'),rela.FPersonID,rela.FActionID,bizDefine.FBizDefineType,rela.FEFFDT,rela.FID,0,rela.FFlowInAffairID,rela.FActionTypeID ").append(" ,'").append(userId).append("',").append(curDateTime).append(",'").append(userId).append("',").append(curDateTime).append(",'").append(curCuId).append("'");
            if (isEmpInit) {
                sql.append(",1");
            } else {
                sql.append(",0");
            }
            sql.append(" from T_HR_EmpOrgRelation rela inner join T_HR_HRBizDefine bizDefine on rela.FActionID=bizDefine.fid ").append(" where rela.FPersonID in ").append(personIdStr).append(" and rela.FID NOT IN (SELECT FNewEmpOrgRelationID FROM T_HR_PersonChangeMsg WHERE FDEALSTATE = 0)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void assembleFlowInPersonChangeMsgInfo(Context ctx, String affairEntryId, PersonChangeMsgInfo changeMsgInfo) throws BOSException, EASBizException {
        EmpPosOrgRelationCollection empPosColl = this.getEmpPosRelationCollByFlowInAffairID(ctx, affairEntryId);
        EmpPosOrgRelationInfo empPosRelaInfo = null;
        if (empPosColl.size() > 0) {
            empPosRelaInfo = empPosColl.get(0);
        }
        if (empPosRelaInfo != null && empPosRelaInfo.getParent() != null && empPosRelaInfo.getParent().getId() != null) {
            changeMsgInfo.setOldEmpOrgRelation(empPosRelaInfo.getParent().getId().toString());
        }
        if (empPosRelaInfo != null) {
            changeMsgInfo.setNewEmpOrgRelation(empPosRelaInfo.getId().toString());
        }
    }

    private void assemblePureFlowOutPersonChangeMsgInfo(Context ctx, HRBizData bizData, String affairEntryId, PersonChangeMsgInfo changeMsgInfo) throws BOSException, EASBizException {
        EmpPosOrgRelationInfo empPosRelaInfo = null;
        EmpPosOrgRelationCollection empPosColl = this.getEmpPosRelationCollByFlowOoutAffairID(ctx, affairEntryId);
        if (empPosColl.size() > 0) {
            empPosRelaInfo = empPosColl.get(0);
        }
        if (empPosRelaInfo != null) {
            changeMsgInfo.setOldEmpOrgRelation(empPosRelaInfo.getId().toString());
        }
    }

    private EmpPosOrgRelationCollection getEmpPosRelationCollByFlowInAffairID(Context ctx, String affairEntryId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("flowInAffairID", (Object)affairEntryId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        EmpPosOrgRelationCollection empPosColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(viewInfo);
        return empPosColl;
    }

    private EmpPosOrgRelationCollection getEmpPosRelationCollByFlowOoutAffairID(Context ctx, String affairEntryId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("flowOutAffairID", (Object)affairEntryId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sorterItemColl = new SorterItemCollection();
        SorterItemInfo sorterInfo = new SorterItemInfo("assignType");
        sorterInfo.setSortType(SortType.DESCEND);
        viewInfo.setSorter(sorterItemColl);
        EmpPosOrgRelationCollection empPosColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(viewInfo);
        return empPosColl;
    }

    public void writeAdminOrgAddNewChangeMsgData(Context ctx, AdminOrgUnitInfo adminOrgInfo) throws EASBizException, BOSException {
        String adminOrgId = adminOrgInfo.getId().toString();
        AdminOrgChangeMsgInfo orgChangeMsgInfo = new AdminOrgChangeMsgInfo();
        orgChangeMsgInfo.setAdminOrg(adminOrgId);
        orgChangeMsgInfo.setNewParent(adminOrgInfo.getParent().getId().toString());
        orgChangeMsgInfo.setNewChangeDate(adminOrgInfo.getEFFDT());
        orgChangeMsgInfo.setDealState(false);
        orgChangeMsgInfo.setModifyType(ModifyTypeEnum.ADDNEW);
        AdminOrgChangeMsgFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)orgChangeMsgInfo);
    }

    public void writeAdminOrgBatchAddNewChangeMsgData(Context ctx, AdminOrgUnitCollection adminOrgColl) throws EASBizException, BOSException {
        AdminOrgUnitInfo adminOrgInfo = null;
        CoreBaseCollection orgChangeMsgColl = new CoreBaseCollection();
        Timestamp curDate = HRUtilExtend.getCurTimestamp();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        int batchCount = 0;
        int size = adminOrgColl.size();
        for (int i = 0; i < size; ++i) {
            adminOrgInfo = adminOrgColl.get(i);
            String adminOrgId = adminOrgInfo.getId().toString();
            AdminOrgChangeMsgInfo orgChangeMsgInfo = new AdminOrgChangeMsgInfo();
            orgChangeMsgInfo.setAdminOrg(adminOrgId);
            if (adminOrgInfo.getParent() != null) {
                orgChangeMsgInfo.setNewParent(adminOrgInfo.getParent().getId().toString());
            }
            orgChangeMsgInfo.setNewChangeDate(adminOrgInfo.getEFFDT());
            orgChangeMsgInfo.setDealState(false);
            orgChangeMsgInfo.setModifyType(ModifyTypeEnum.ADDNEW);
            orgChangeMsgInfo.setCreateTime(curDate);
            orgChangeMsgInfo.setLastUpdateTime(curDate);
            orgChangeMsgInfo.setCreator(userInfo);
            orgChangeMsgInfo.setLastUpdateUser(userInfo);
            orgChangeMsgColl.add((CoreBaseInfo)orgChangeMsgInfo);
            if (++batchCount % 500 != 0) continue;
            AdminOrgChangeMsgFactory.getLocalInstance((Context)ctx).addnewBatchData(orgChangeMsgColl);
            batchCount = 0;
            orgChangeMsgColl = new CoreBaseCollection();
        }
        if (batchCount > 0) {
            AdminOrgChangeMsgFactory.getLocalInstance((Context)ctx).addnewBatchData(orgChangeMsgColl);
        }
    }

    public void writeAdminOrgUpdateChangeMsgData(Context ctx, AdminOrgUnitInfo adminInfo, AdminOrgUnitInfo oldAdminOrg) throws EASBizException, BOSException {
        String adminOrgId = adminInfo.getId().toString();
        AdminOrgUnitInfo adminOrgInfo = this.getAdminOrgUnitInfo(ctx, adminOrgId);
        if (adminOrgInfo.isIsStartSHR() && adminInfo.getParent() != null) {
            AdminOrgChangeMsgInfo orgChangeMsgInfo = new AdminOrgChangeMsgInfo();
            orgChangeMsgInfo.setAdminOrg(adminOrgId);
            if (adminInfo.getParent() != null) {
                orgChangeMsgInfo.setNewParent(adminInfo.getParent().getId().toString());
            }
            if (oldAdminOrg.getParent() != null) {
                orgChangeMsgInfo.setOldParent(oldAdminOrg.getParent().getId().toString());
            }
            orgChangeMsgInfo.setOldChangeDate(oldAdminOrg.getEFFDT());
            orgChangeMsgInfo.setNewChangeDate(adminOrgInfo.getEFFDT());
            orgChangeMsgInfo.setDealState(false);
            orgChangeMsgInfo.setModifyType(ModifyTypeEnum.EDIT);
            AdminOrgChangeMsgFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)orgChangeMsgInfo);
        }
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfo(Context ctx, String adminOrgId) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("EFFDT"));
        selector.add(new SelectorItemInfo("isStartSHR"));
        AdminOrgUnitInfo adminOrgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId), selector);
        return adminOrgInfo;
    }

    public static String getSpecialBizManageSQLByHRIdList(List<String> hrOrgUnitIdList) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select FPersonID from T_HR_PersonBURelation ").append(" where FBizManageTypeID='").append(BizManageType_EMP_ID).append("'").append(" and FState=").append(1);
        if (hrOrgUnitIdList != null && hrOrgUnitIdList.size() > 0) {
            sqlBuffer.append(" and FHrOrgUnitID in ").append(HRUtilExtend.getStrFromList(hrOrgUnitIdList));
        }
        return sqlBuffer.toString();
    }

    public static HROrgUnitInfo getManageHROByAdminOrg(Context ctx, String adminOrgUnitId) throws EASBizException, BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select manageHrOrg.id,manageHrOrg.name where adminOrg.id = '").append(adminOrgUnitId).append("' and bizManageType.id = '").append(BizManageType_EMP_ID).append("' and state = ").append(1);
        HROrgUnitInfo hroUnitInfo = null;
        if (AdminOrgBURelationFactory.getLocalInstance((Context)ctx).exists(oql.toString())) {
            AdminOrgBURelationCollection relaColl = AdminOrgBURelationFactory.getLocalInstance((Context)ctx).getAdminOrgBURelationCollection(oql.toString());
            AdminOrgBURelationInfo info = relaColl.get(0);
            hroUnitInfo = info.getManageHrOrg();
        }
        if (hroUnitInfo == null) {
            AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitId));
            Object[] params = new Object[]{"[" + adminOrgUnitInfo.getName() + "]"};
            throw new EmployeeException(EmployeeException.PERSON_ORG_NOBIZORG, params);
        }
        return hroUnitInfo;
    }

    public static ArrayList<String> getAdminOrgByManageHRO(Context ctx, String hrOrgUnitId) throws EASBizException, BOSException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String sql = "SELECT FAdminOrgID FROM T_HR_AdminOrgBURelation WHERE FBizManageTypeID = 'SGuJm3nXW0GshQfKRXenomWJ1dE=' AND FState = 1 AND FmanageHrOrgID = '" + hrOrgUnitId + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    public static EmpHRORelationHisInfo getEmpHRORelationHisInfo(Context ctx, String personId) throws BOSException {
        EmpHRORelationHisInfo relationInfo = null;
        StringBuffer oql = new StringBuffer();
        oql.append("select id,useDefault,hrOrgUnit.id,hrOrgUnit.name,hrOrgUnit.number,empOrgRelation.adminOrg.id,empOrgRelation.adminOrg.name,empOrgRelation.adminOrg.number,empOrgRelation.id ").append(" where bizManageType.id = '").append(BizManageType_EMP_ID).append("'").append(" and state = ").append(1).append(" and person.id = '").append(personId).append("'").append(" and empOrgRelation.assignType=1");
        EmpHRORelationHisCollection coll = EmpHRORelationHisFactory.getLocalInstance((Context)ctx).getEmpHRORelationHisCollection(oql.toString());
        if (coll.size() > 0) {
            relationInfo = coll.get(0);
        }
        return relationInfo;
    }

    public static HROrgUnitInfo getAddnewAdminDefaultManageOrg(Context ctx, String adminOrgUnitId, String bizManageTypeId) throws BOSException, EASBizException {
        HROrgUnitInfo info = null;
        AdminOrgUnitCollection coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(" where id = '" + adminOrgUnitId.trim() + "'");
        if (coll.size() < 1) {
            return info;
        }
        AdminOrgUnitInfo adminInfo = coll.get(0);
        if (adminInfo.getParent() != null) {
            String parentID = adminInfo.getParent().getId().toString();
            for (int i = 0; i < adminInfo.getLevel(); ++i) {
                AdminOrgUnitCollection parentColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(" where id = '" + parentID + "'");
                if (parentColl.size() <= 0) continue;
                AdminOrgUnitInfo parentInfo = parentColl.get(0);
                if (parentInfo.isIsStartSHR()) {
                    AdminOrgBURelationCollection relationColl = AdminOrgBURelationFactory.getLocalInstance((Context)ctx).getAdminOrgBURelationCollection("select manageHrOrg.* where adminOrg='" + parentInfo.getId().toString() + "' and bizManageType = '" + bizManageTypeId.trim() + "' and state = " + 1);
                    if (relationColl.size() < 1) {
                        return info;
                    }
                    AdminOrgBURelationInfo relationInfo = relationColl.get(0);
                    return relationInfo.getManageHrOrg();
                }
                if (parentInfo.getParent() != null) {
                    parentID = parentInfo.getParent().getId().toString();
                    continue;
                }
                return info;
            }
        } else {
            return info;
        }
        return info;
    }

    public static boolean checkIsPersonInSameHRO(Context ctx, String[] personIds) throws BOSException, SQLException {
        if (personIds.length <= 1) {
            return true;
        }
        String idFilter = HRUtilExtend.getStrFromArray((String[])personIds);
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) as countNum from ( select rel.FhrOrgUnitId from T_HR_EmpHRORelationHis rel ").append(" left join T_HR_EmpOrgRelation eor on eor.FId = rel.FEmpOrgRelationId").append(" where rel.FBizManageTypeId = '").append(BizManageType_EMP_ID).append("'").append(" and rel.FState = ").append(1).append(" and rel.FpersonId in ").append(idFilter).append(" and eor.FAssignType=1 group by rel.FhrOrgUnitId) t1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return !rs.next() || rs.getInt("countNum") <= 1;
    }
}

