/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.HashSet;

public class HROrgContextManageUtil {
    public static final String HRORG = "HRORGUNIT";
    public static final String HRORGUNITID = "hrOrgUnit.id";

    public static String getPermissionItem(Context context, IMetaDataPK pk) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.BASEQUERY, pk);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return permItemName;
            }
        }
        return null;
    }

    public static HashSet convertHROrgsToCUs(HROrgUnitCollection hrOrgs) {
        if (hrOrgs != null && hrOrgs.size() > 0) {
            HashSet<Object> set = new HashSet<Object>();
            if (hrOrgs.get(0).getCU() == null) {
                HashSet<String> hrOrgIDSet = new HashSet<String>();
                int size = hrOrgs.size();
                for (int i = 0; i < size; ++i) {
                    hrOrgIDSet.add(hrOrgs.get(i).getId().toString());
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", hrOrgIDSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                SelectorItemCollection selector = viewInfo.getSelector();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("cu.id"));
                selector.add(new SelectorItemInfo("cu.longnumber"));
                selector.add(new SelectorItemInfo("cu.name"));
                try {
                    hrOrgs = HROrgUnitFactory.getRemoteInstance().getHROrgUnitCollection(viewInfo);
                }
                catch (Exception e) {
                    hrOrgs = null;
                }
            }
            if (hrOrgs != null) {
                if (hrOrgs.get(0).getCU().getLongNumber() != null) {
                    int size = hrOrgs.size();
                    for (int i = 0; i < size; ++i) {
                        set.add(hrOrgs.get(i).getCU());
                    }
                } else {
                    int size = hrOrgs.size();
                    for (int i = 0; i < size; ++i) {
                        set.add(hrOrgs.get(i).getCU().getId().toString());
                    }
                }
            }
            return set;
        }
        return null;
    }

    public static HashSet convertHROrgsToCUInfos(HROrgUnitCollection hrOrgs) {
        if (hrOrgs != null && hrOrgs.size() > 0) {
            HashSet<CtrlUnitInfo> set = new HashSet<CtrlUnitInfo>();
            if (hrOrgs.get(0).getCU() == null || hrOrgs.get(0).getCU().getNumber() == null) {
                HashSet<String> hrOrgIDSet = new HashSet<String>();
                int size = hrOrgs.size();
                for (int i = 0; i < size; ++i) {
                    hrOrgIDSet.add(hrOrgs.get(i).getId().toString());
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", hrOrgIDSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                SelectorItemCollection selector = viewInfo.getSelector();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("cu.id"));
                selector.add(new SelectorItemInfo("cu.longnumber"));
                selector.add(new SelectorItemInfo("cu.number"));
                selector.add(new SelectorItemInfo("cu.name"));
                try {
                    hrOrgs = HROrgUnitFactory.getRemoteInstance().getHROrgUnitCollection(viewInfo);
                }
                catch (Exception e) {
                    hrOrgs = null;
                }
            }
            if (hrOrgs != null) {
                int size = hrOrgs.size();
                for (int i = 0; i < size; ++i) {
                    set.add(hrOrgs.get(i).getCU());
                }
            }
            return set;
        }
        return null;
    }
}

