/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.party.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.party.MemChaBillEntryFactory;
import com.kingdee.eas.hr.party.MemChaBillInfo;
import com.kingdee.eas.hr.party.app.AbstractMemChaBillControllerBean;
import com.kingdee.eas.hr.party.app.MemChaBillBizBean;
import java.util.Date;

public class MemChaBillControllerBean
extends AbstractMemChaBillControllerBean {
    private IHRBillBizBean bizBean = null;

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return MemChaBillEntryFactory.getLocalInstance(ctx);
    }

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected IHRBillBizBean getBizBean() {
        return new MemChaBillBizBean();
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String temp = "";
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        MemChaBillInfo info = (MemChaBillInfo)this._getValue(ctx, pk, sic);
        temp = info.getNumber() + "   ";
        return temp;
    }

    public void setAudited(Context arg0, BOSUuid arg1) throws BOSException, EASBizException {
        super.setAudited(arg0, arg1);
        this.updateBillState(arg0, arg1, HRBillStateEnum.AUDITED);
    }

    public void setAuditEnd(Context arg0, BOSUuid arg1) throws BOSException, EASBizException {
        super.setAuditEnd(arg0, arg1);
        this.updateBillState(arg0, arg1, HRBillStateEnum.AUDITEND);
    }

    public void setAuditing(Context arg0, BOSUuid arg1) throws BOSException, EASBizException {
        super.setAuditing(arg0, arg1);
        this.updateBillState(arg0, arg1, HRBillStateEnum.AUDITING);
    }

    protected void updateBillState(Context ctx, BOSUuid billID, HRBillStateEnum state) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("billState"));
        selector.add(new SelectorItemInfo("approveDate"));
        MemChaBillInfo model = this.getMemChaBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billID), selector);
        if (state.equals((Object)HRBillStateEnum.AUDITED) || state.equals((Object)HRBillStateEnum.AUDITEND) || state.equals((Object)HRBillStateEnum.AUDITING)) {
            model.setApproveDate(new Date());
        } else {
            model.setApproveDate(null);
        }
        model.setBillState(state);
        this.updatePartial(ctx, (CoreBaseInfo)model, selector);
    }
}

